/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.ConnectorStatus;
import org.soler.client.countdown.CountdownCallback;
import org.soler.client.countdown.CountdownTask;
import org.soler.client.init.ClientInitializer;
import org.soler.client.init.IntraServerInitializer;
import org.soler.client.listener.ClientAuthListener;
import org.soler.client.util.ClientMgr;
import org.soler.common.model.SolerMsg;
import org.soler.common.util.SolerConfig;
import org.soler.common.util.SolerUtil;

public class ClientContainer {
    private static Logger log = LoggerFactory.getLogger(ClientContainer.class);
    private static ClientContainer container = null;
    private NioEventLoopGroup workerGroup = null;
    private Bootstrap holerClient = null;
    private Bootstrap intraServer = null;
    private SolerConfig config = SolerConfig.getConfig();
    private long sleepTime = 1000L;
    ConnectorStatus mConnectorStatus;
    ChannelFuture connect;
    ClientAuthListener clientAuthListener = new ClientAuthListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            super.operationComplete(future);
            if (future.isSuccess()) {
                ClientContainer.this.sleepTime = 1000L;
            }
            if (ClientContainer.this.mConnectorStatus != null) {
                ClientContainer.this.mConnectorStatus.connectedFinish(future);
            }
        }
    };
    Timer timer;
    CountdownCallback countdownCallback = new CountdownCallback(){

        @Override
        public void countDown(int surplus) {
            if (ClientContainer.this.mConnectorStatus != null) {
                ClientContainer.this.mConnectorStatus.reconnect(surplus);
            }
            if (surplus <= 0) {
                ClientContainer.this.timer.cancel();
                ClientContainer.this.connectHolerServer();
            }
        }
    };

    private ClientContainer() {
    }

    public static ClientContainer getContainer() {
        if (null == container) {
            container = new ClientContainer();
        }
        return container;
    }

    public boolean isStarted() {
        return this.mConnectorStatus != null && this.mConnectorStatus.isRuning();
    }

    public void init() {
        this.sleepTime = 1000L;
        this.workerGroup = new NioEventLoopGroup();
        this.intraServer = new Bootstrap();
        this.intraServer.group((EventLoopGroup)this.workerGroup);
        this.intraServer.channel(NioSocketChannel.class);
        this.intraServer.handler((ChannelHandler)new IntraServerInitializer());
        this.holerClient = new Bootstrap();
        this.holerClient.group((EventLoopGroup)this.workerGroup);
        this.holerClient.channel(NioSocketChannel.class);
        this.holerClient.handler((ChannelHandler)new ClientInitializer());
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public Bootstrap getHolerClient() {
        return this.holerClient;
    }

    public Bootstrap getIntraServer() {
        return this.intraServer;
    }

    public void setConnectorStatus(ConnectorStatus mConnectorStatus) {
        this.mConnectorStatus = mConnectorStatus;
    }

    private void connectHolerServer() {
        String host = this.config.strValue("HOLER_SERVER_HOST");
        int port = this.config.intValue("HOLER_SERVER_PORT", 6060);
        ClientMgr.clearIntraServer();
        log.warn("\u6b63\u5728\u8fde\u63a5\u670d\u52a1\u5668");
        if (this.connect != null) {
            this.connect.removeListener((GenericFutureListener)this.clientAuthListener);
            this.connect.cancel(false);
        }
        this.connect = this.holerClient.connect(host, port);
        this.connect.addListener((GenericFutureListener)this.clientAuthListener);
    }

    public void waitMoment() {
        if (this.sleepTime > 30000L) {
            this.sleepTime = 30000L;
        }
        this.sleepTime *= 2L;
    }

    public void start() {
        if (this.mConnectorStatus != null) {
            this.mConnectorStatus.start();
        }
        this.init();
        this.connectHolerServer();
    }

    public void stop(byte status, String reason) {
        Channel clientChannel;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if ((clientChannel = ClientMgr.getClientChannel()) != null) {
            SolerMsg msg = new SolerMsg();
            msg.setType((byte)17);
            try {
                msg.setData(reason.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            clientChannel.writeAndFlush((Object)msg);
            SolerUtil.sleep(100L);
        }
        ClientMgr.clearHolerClient();
        ClientMgr.setClientChannel(null);
        ClientMgr.clearIntraServer();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.mConnectorStatus != null) {
            this.mConnectorStatus.stoped(status, reason);
        }
        log.warn("\u6b63\u5728\u6267\u884c\u505c\u6b62Stopped org client with status {} {} {}", new Object[]{clientChannel, status, reason});
    }

    public void restart() {
        SolerUtil.sleep(2000L);
        this.waitMoment();
        int time = (int)(this.sleepTime / 1000L);
        if (this.mConnectorStatus != null) {
            this.mConnectorStatus.reconnect(time);
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CountdownTask(time, this.countdownCallback), 1000L, 1000L);
    }

    public static void main(String[] args) {
        ClientContainer.getContainer().start();
        log.error("\u542f\u52a8\u6210\u529f");
    }
}

