/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.IUIPosition;
import org.soler.client.MainWindow;
import org.soler.client.util.AutoStart;
import org.soler.common.util.SolerConfig;

public class SettingWindow {
    private SolerConfig config = SolerConfig.getConfig();
    private static SettingWindow container = null;
    static final String regKey = "SX-Soler-Client";
    final JFrame window = new JFrame("key\u914d\u7f6e");
    ItemListener itemEvent = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JCheckBox checkBox = (JCheckBox)itemEvent.getSource();
            final boolean status = checkBox.isSelected();
            String filePath = SettingWindow.getExeFilePath();
            final String result = AutoStart.doAutoStart(status, SettingWindow.regKey, filePath);
            if (status) {
                boolean exeExits = false;
                try {
                    exeExits = new File(filePath).exists();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!exeExits) {
                    checkBox.removeItemListener(this);
                    checkBox.setSelected(!status);
                    checkBox.addItemListener(this);
                    new Thread(){

                        @Override
                        public void run() {
                            super.run();
                            JOptionPane.showMessageDialog(null, "\u542f\u52a8\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u52ff\u4fee\u6539" + SettingWindow.getExeFilePath(), "\u81ea\u542f\u8bbe\u7f6e\u5931\u8d25", 0);
                        }
                    }.start();
                    return;
                }
            }
            if (result != null && result.length() > 0) {
                new Thread(){

                    @Override
                    public void run() {
                        super.run();
                        if (status) {
                            JOptionPane.showMessageDialog(null, result, "\u5f00\u673a\u81ea\u542f", 2);
                        } else {
                            JOptionPane.showMessageDialog(null, result, "\u53d6\u6d88\u5f00\u673a\u81ea\u542f", 2);
                        }
                    }
                }.start();
            } else {
                new Thread(){

                    @Override
                    public void run() {
                        super.run();
                        if (status) {
                            JOptionPane.showMessageDialog(null, result + "eee", "\u5f00\u673a\u81ea\u542f", 0);
                        } else {
                            JOptionPane.showMessageDialog(null, result + "ddd", "\u53d6\u6d88\u5f00\u673a\u81ea\u542f", 0);
                        }
                    }
                }.start();
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(SettingWindow.class);

    static String getExeName() {
        String exeName = "\u7d20\u7384Soler\u5ba2\u6237\u7aef.exe";
        String str = System.getProperty("launch4j.exefile");
        try {
            exeName = new File(str).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exeName;
    }

    public static String getExePath() {
        String filePath = System.getProperty("user.dir");
        return filePath;
    }

    public static String getExeFilePath() {
        String filePath = System.getProperty("user.dir");
        filePath = filePath + File.separatorChar + SettingWindow.getExeName();
        String str = System.getProperty("launch4j.exefile");
        if (str != null && str.length() > 0) {
            filePath = str;
        }
        return filePath;
    }

    public static SettingWindow getInstance() {
        if (null == container) {
            container = new SettingWindow();
        }
        return container;
    }

    public void initWindow(int x, int y, final IUIPosition iuiPosition) {
        int pading = 10;
        int windowW = 350;
        int windowH = 250;
        int inputH = 150;
        String host = this.config.strValue("HOLER_SERVER_HOST");
        int port = this.config.intValue("HOLER_SERVER_PORT", 6060);
        String key = this.config.strValue("HOLER_ACCESS_KEY");
        this.window.setSize(windowW, windowH);
        this.window.setLocation(x, y);
        this.window.setResizable(false);
        this.window.setLayout(null);
        URL ul = this.getClass().getResource("/image/telnet.png");
        ImageIcon trayImg = new ImageIcon(ul);
        this.window.setIconImage(trayImg.getImage());
        JButton btnSave = new JButton("\u4fdd\u5b58");
        JPanel pInput = new JPanel();
        this.window.add(pInput);
        this.window.add(btnSave);
        this.window.setDefaultCloseOperation(2);
        this.window.setVisible(true);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                if (iuiPosition != null) {
                    iuiPosition.onPosition(SettingWindow.this.window.getX(), SettingWindow.this.window.getY());
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                MainWindow.getContainer().to();
            }
        });
        pInput.setBounds(pading, pading, windowW - pading * 4, inputH);
        GridLayout gridLayout = new GridLayout(4, 3, 5, 5);
        gridLayout.setHgap(-140);
        pInput.setLayout(gridLayout);
        JLabel measure = new JLabel("\u8bbf\u95eekey:");
        JLabel ipLable = new JLabel("\u670d\u52a1\u5730\u5740:");
        JLabel portLable = new JLabel("\u670d\u52a1\u7aef\u53e3:");
        JLabel remotPort = new JLabel("\u8fdc\u7a0b\u7aef\u53e3:" + AutoStart.getRemotePort());
        final JTextField measureText = new JTextField();
        final JTextField ipEdit = new JTextField();
        final JTextField portEdit = new JTextField();
        measureText.setText(key);
        ipEdit.setText(host);
        portEdit.setText(Integer.toString(port));
        pInput.add(measure);
        pInput.add(measureText);
        pInput.add(ipLable);
        pInput.add(ipEdit);
        pInput.add(portLable);
        pInput.add(portEdit);
        pInput.add(remotPort);
        boolean isReg = AutoStart.isReg(SettingWindow.getExeName());
        JCheckBox jcbox1 = new JCheckBox("\u5f00\u673a\u81ea\u542f\u52a8", isReg);
        pInput.add(jcbox1);
        jcbox1.addItemListener(this.itemEvent);
        btnSave.setBounds(windowW / 2 - 40, pInput.getY() + pInput.getHeight() + pading, 80, 30);
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.checkEmpty(measureText)) {
                    JOptionPane.showMessageDialog(SettingWindow.this.window, "\u8bbf\u95eekey \u4e0d\u80fd\u4e3a\u7a7a");
                    measureText.grabFocus();
                    return;
                }
                if (this.checkEmpty(ipEdit)) {
                    JOptionPane.showMessageDialog(SettingWindow.this.window, "IP\u4e0d\u80fd\u4e3a\u7a7a");
                    measureText.grabFocus();
                    return;
                }
                if (this.checkEmpty(portEdit)) {
                    JOptionPane.showMessageDialog(SettingWindow.this.window, "\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
                    measureText.grabFocus();
                    return;
                }
                String newKey = measureText.getText();
                SettingWindow.this.config.saveValue("HOLER_ACCESS_KEY", newKey);
                SettingWindow.this.config.saveValue("HOLER_SERVER_PORT", portEdit.getText());
                SettingWindow.this.config.saveValue("HOLER_SERVER_HOST", ipEdit.getText());
                log.warn("\u4fdd\u5b58\u8def\u5f84:" + SettingWindow.this.config.getOutSavePath());
                if (SettingWindow.this.config.save()) {
                    JOptionPane.showMessageDialog(SettingWindow.this.window, "\u5df2\u4fdd\u5b58, \u4fee\u6539Key/\u670d\u52a1\u5730\u5740/\u670d\u52a1\u7aef\u53e3,\u9700\u8981\u505c\u6b62\u8fde\u63a5\u540e\u518d\u6b21\u542f\u52a8\u751f\u6548");
                    SettingWindow.this.window.dispose();
                } else {
                    JOptionPane.showMessageDialog(SettingWindow.this.window, "\u4fdd\u5b58\u5931\u8d25");
                }
            }

            private boolean checkEmpty(JTextField tf) {
                String value = tf.getText();
                return value.length() == 0;
            }
        });
    }

    void initWindow() {
        this.initWindow(700, 500, null);
    }

    public static void main(String[] args) {
        SettingWindow.getInstance().initWindow();
    }

    void show(String string) {
        JOptionPane.showMessageDialog(null, string, "\u63d0\u793a\u6d88\u606f", 2);
    }
}

