/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.ClientContainer;
import org.soler.client.listener.IntraServerListener;
import org.soler.client.util.ClientMgr;
import org.soler.common.constant.SolerConst;
import org.soler.common.model.SolerMsg;
import org.soler.common.util.SolerConfig;
import org.soler.common.util.SolerUtil;

public class ClientHandler
extends SimpleChannelInboundHandler<SolerMsg> {
    private static Logger log = LoggerFactory.getLogger(ClientHandler.class);
    private SolerConfig config = SolerConfig.getConfig();

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u670d\u52a1\u5668\u5f02\u5e38\u505c\u6b62Caught holer server exception {} {}", (Object)ctx.channel(), (Object)cause.getMessage());
        super.exceptionCaught(ctx, cause);
    }

    private void handleConnectMsg(Channel clientChannel, SolerMsg msg) {
        String srvData = new String(msg.getData());
        String host = StringUtils.substringBefore((String)srvData, (String)":");
        String port = StringUtils.substringAfter((String)srvData, (String)":");
        if (StringUtils.isBlank((String)host)) {
            log.error("Invalid server host \u65e0\u6548\u7684\u670d\u52a1\u5668\u4e3b\u673a(\u672c\u8bf7\u6c42\u4f1a\u4ea7\u751f\u6570\u636e\u6570\u636e\u901a\u9053\u957f\u671f\u4e0d\u4f1a\u5173\u95ed){}", (Object)host);
            return;
        }
        if (StringUtils.isBlank((String)port) || !StringUtils.isNumeric((String)port)) {
            log.error("Invalid server port \u65e0\u6548\u7aef\u53e3(\u672c\u8bf7\u6c42\u4f1a\u4ea7\u751f\u6570\u636e\u6570\u636e\u901a\u9053\u957f\u671f\u4e0d\u4f1a\u5173\u95ed){}", (Object)port);
            return;
        }
        int portNum = Integer.parseInt(port);
        Bootstrap intraServer = ClientContainer.getContainer().getIntraServer();
        IntraServerListener listener = new IntraServerListener(clientChannel, msg);
        intraServer.connect(host, portNum).addListener((GenericFutureListener)listener);
    }

    private void handleDisconnectMsg(Channel clientChannel, SolerMsg msg) {
        Channel intraChannel = (Channel)clientChannel.attr(SolerConst.HOLER_CHANNEL).get();
        if (null == intraChannel) {
            log.error("   intraChannel  \u901a\u9053\u5185\u4e3a\u7a7a");
            return;
        }
        clientChannel.attr(SolerConst.HOLER_CHANNEL).set(null);
        ClientMgr.pushClient(clientChannel);
        intraChannel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void handleTransferMsg(Channel clientChannel, ByteBufAllocator allocator, SolerMsg msg) {
        Channel intraChannel = (Channel)clientChannel.attr(SolerConst.HOLER_CHANNEL).get();
        if (null == intraChannel) {
            String sss = new String(msg.getData());
            log.warn("\u6536\u5230\u5185\u5bb9:" + sss);
            return;
        }
        ByteBuf buf = allocator.buffer(msg.getData().length);
        buf.writeBytes(msg.getData());
        intraChannel.writeAndFlush((Object)buf);
    }

    private void handleServerMsg(Channel clientChannel, SolerMsg msg) {
        String msgInfo = "";
        switch (msg.getType()) {
            case 2: {
                msgInfo = "There are no available ports for the soler access key.\n\u8bbf\u95ee\u5bc6\u94a5\u6ca1\u6709\u53ef\u7528\u7aef\u53e3\u3002";
                break;
            }
            case 6: {
                msgInfo = "Soler access key is in use by other soler client.\nIf you want to have exclusive soler service\nplease visit 'www.suxuantech.cn' for more details.\n\u5176\u4ed6\u5ba2\u6237\u7aef\u6b63\u5728\u4f7f\u7528\u8be5\u8bbf\u95ee\u5bc6\u94a5,\u8bf7\u7a0d\u540e\u518d\u8bd5(\u8bf7\u52ff\u8fde\u7eed\u70b9\u51fb\u542f\u52a8)\u3002";
                break;
            }
            case 8: {
                msgInfo = "Soler access key has been disabled.\n\u5f53\u524dkey \u88ab\u7981\u7528";
                break;
            }
            case 9: {
                msgInfo = "Your soler client is overuse.\nThe trial soler access key can only be used for 20 minutes in 24 hours.\nIf you want to have exclusive soler service\nplease visit 'www.suxuantech.cn' for more details.\n\u5ba2\u6237\u7aef\u88ab\u8fc7\u5ea6\u4f7f\u7528(\u8bd5\u7528\u5ba2\u6237\u7aef\u88ab\u7981\u7528)";
                break;
            }
            case 16: {
                msgInfo = "Soler access key is not valid.\n\u65e0\u6548key";
                break;
            }
            case 17: {
                msgInfo = "Soler Normal Stop\n\u624b\u52a8\u6b63\u5e38\u505c\u6b62";
                break;
            }
            default: {
                msgInfo = "";
            }
        }
        if (StringUtils.isEmpty((String)msgInfo)) {
            return;
        }
        log.error("HOLER_ACCESS_KEY=" + this.config.strValue("HOLER_ACCESS_KEY") + "\u670d\u52a1\u6d88\u606f \uff08\u670d\u52a1\u5668\u8981\u6c42\u5ba2\u6237\u7aef\u5173\u95ed\u901a\u9053\u539f\u56e0:\uff09 " + msgInfo);
        SolerUtil.close(clientChannel);
        ClientContainer.getContainer().stop(msg.getType(), msgInfo);
    }

    protected void channelRead0(ChannelHandlerContext ctx, SolerMsg msg) throws Exception {
        Channel clientChannel = ctx.channel();
        switch (msg.getType()) {
            case 3: {
                this.handleConnectMsg(clientChannel, msg);
                break;
            }
            case 4: {
                this.handleDisconnectMsg(clientChannel, msg);
                break;
            }
            case 5: {
                this.handleTransferMsg(clientChannel, ctx.alloc(), msg);
                break;
            }
            case 7: {
                log.warn("\u6536\u5230\u5fc3\u8df3\u54cd\u5e94");
                break;
            }
            default: {
                this.handleServerMsg(clientChannel, msg);
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel clientChannel = ctx.channel();
        Channel intraChannel = (Channel)clientChannel.attr(SolerConst.HOLER_CHANNEL).get();
        if (null != intraChannel) {
            intraChannel.config().setOption(ChannelOption.AUTO_READ, (Object)clientChannel.isWritable());
        }
        super.channelWritabilityChanged(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel clientChannel = ctx.channel();
        if (ClientMgr.getClientChannel() == clientChannel) {
            log.error("\u5ba2\u6237\u7aef\u4e3b\u8981\u901a\u9053\u4e0d\u6d3b\u52a8\uff0c\u91cd\u65b0\u8fde\u63a5 ");
            ClientMgr.getClientChannel().attr(SolerConst.CLIENT_CLOSING_TIME).set((Object)SolerUtil.getNoWTime());
            ClientMgr.setClientChannel(null);
            ClientMgr.clearIntraServer();
            ClientContainer.getContainer().restart();
        } else {
            log.error("\u4e34\u65f6\u901a\u9053\u4e0d\u6d3b\u52a8\uff0c\u8fdb\u884c\u5173\u95ed");
            Channel intraChannel = (Channel)clientChannel.attr(SolerConst.HOLER_CHANNEL).get();
            SolerUtil.close(intraChannel);
        }
        ClientMgr.removeClient(clientChannel);
        super.channelInactive(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        log.warn("\u8fde\u63a5\u4e86\u670d\u52a1\u5668\u4ea7\u751f\u4e86\u901a\u9053" + ctx.channel());
    }
}

