/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.util.ClientMgr;
import org.soler.common.constant.SolerConst;
import org.soler.common.model.SolerMsg;

public class IntraServerHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static Logger log = LoggerFactory.getLogger(IntraServerHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u5ba2\u6237\u7aef\u5185\u90e8\u4ee3\u7406\u8bf7\u6c42\u670d\u52a1\u5f02\u5e38aught intra-server exception {} {}", (Object)ctx.channel(), (Object)cause.getMessage());
        super.exceptionCaught(ctx, cause);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        Channel intraChannel = ctx.channel();
        Channel holerChannel = (Channel)intraChannel.attr(SolerConst.HOLER_CHANNEL).get();
        if (null == holerChannel) {
            intraChannel.close();
            return;
        }
        byte[] data = new byte[msg.readableBytes()];
        msg.readBytes(data);
        SolerMsg hmsg = new SolerMsg();
        hmsg.setType((byte)5);
        hmsg.setUri(ClientMgr.getIntraServerUri(intraChannel));
        hmsg.setData(data);
        holerChannel.writeAndFlush((Object)hmsg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel intraChannel = ctx.channel();
        String uri = ClientMgr.getIntraServerUri(intraChannel);
        ClientMgr.removeIntraServer(uri);
        Channel holerChannel = (Channel)intraChannel.attr(SolerConst.HOLER_CHANNEL).get();
        if (null != holerChannel) {
            SolerMsg hmsg = new SolerMsg();
            hmsg.setType((byte)4);
            hmsg.setUri(uri);
            hmsg.setData("\u5ba2\u6237\u7aef\u5185\u90e8\u4ee3\u7406\u5df2\u5173\u95ed".getBytes("UTF-8"));
            holerChannel.writeAndFlush((Object)hmsg);
        }
        super.channelInactive(ctx);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Channel intraChannel = ctx.channel();
        Channel holerChannel = (Channel)intraChannel.attr(SolerConst.HOLER_CHANNEL).get();
        if (null != holerChannel) {
            holerChannel.config().setOption(ChannelOption.AUTO_READ, (Object)intraChannel.isWritable());
        }
        super.channelWritabilityChanged(ctx);
    }
}

