/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.init;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.soler.client.handler.ClientHandler;
import org.soler.common.util.IdleChecker;
import org.soler.common.util.MsgDecoder;
import org.soler.common.util.MsgEncoder;
import org.soler.common.util.SSLCreator;
import org.soler.common.util.SolerConfig;

public class ClientInitializer
extends ChannelInitializer<SocketChannel> {
    private SSLContext sslContext = null;

    protected void initChannel(SocketChannel ch) throws Exception {
        if (SolerConfig.getConfig().boolValue("HOLER_SSL_ENABLE", false)) {
            if (null == this.sslContext) {
                this.sslContext = SSLCreator.getCreator().getSSLContext();
            }
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(true);
            ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
        }
        ch.pipeline().addLast(new ChannelHandler[]{new MsgDecoder(0x200000, 0, 4, 0, 0)});
        ch.pipeline().addLast(new ChannelHandler[]{new MsgEncoder()});
        ch.pipeline().addLast(new ChannelHandler[]{new IdleChecker(60, 30, 0)});
        ch.pipeline().addLast(new ChannelHandler[]{new ClientHandler()});
    }
}

