/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.listener;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.ClientContainer;
import org.soler.client.util.ClientMgr;
import org.soler.common.constant.SolerConst;
import org.soler.common.model.SolerMsg;
import org.soler.common.util.SolerConfig;
import org.soler.common.util.SolerUtil;

public class ClientAuthListener
implements ChannelFutureListener {
    private static Logger log = LoggerFactory.getLogger(ClientAuthListener.class);

    public void operationComplete(ChannelFuture future) throws Exception {
        SolerConfig config = SolerConfig.getConfig();
        String host = config.strValue("HOLER_SERVER_HOST");
        int port = config.intValue("HOLER_SERVER_PORT", 6060);
        ClientContainer container = ClientContainer.getContainer();
        if (!future.isSuccess()) {
            log.error("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25Failed to connect holer server  <" + host + ":" + port + ">\u539f\u56e0:{}{}", (Object)future.channel(), (Object)future.cause().getMessage());
            container.restart();
            return;
        }
        Channel clientChannel = future.channel();
        log.warn("\u4e3b\u901a\u9053:" + clientChannel.id().toString());
        clientChannel.attr(SolerConst.CLIENT_OPEN_TIME).set((Object)SolerUtil.getNoWTime());
        ClientMgr.setClientChannel(clientChannel);
        SolerMsg hmsg = new SolerMsg();
        hmsg.setType((byte)1);
        hmsg.setUri(config.strValue("HOLER_ACCESS_KEY"));
        clientChannel.writeAndFlush((Object)hmsg);
        log.warn("\u5df2\u8fde\u63a5\u5230\u670d\u52a1\u5668:Connect holer server success {}", (Object)clientChannel);
    }
}

