/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.listener;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.util.ClientMgr;
import org.soler.common.constant.SolerConst;
import org.soler.common.model.SolerMsg;
import org.soler.common.util.SolerConfig;

public class ClientConnectListener
implements ChannelFutureListener {
    private static Logger log = LoggerFactory.getLogger(ClientConnectListener.class);
    private Channel clientChannel = null;
    private Channel intraChannel = null;
    private SolerMsg msg = null;

    public ClientConnectListener(Channel clientChannel, Channel intraChannel, SolerMsg msg) {
        this.clientChannel = clientChannel;
        this.intraChannel = intraChannel;
        this.msg = msg;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            SolerMsg hmsg = new SolerMsg();
            hmsg.setType((byte)4);
            hmsg.setUri(this.msg.getUri());
            hmsg.setData((new String(this.msg.getData()) + "\u5ba2\u6237\u7aef\u6b21\u901a\u9053\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25").getBytes("UTF-8"));
            this.clientChannel.writeAndFlush((Object)hmsg);
            log.error("Failed to connect holer server {}", (Object)future.cause().getMessage());
            return;
        }
        SolerConfig config = SolerConfig.getConfig();
        Channel holerChannel = future.channel();
        holerChannel.attr(SolerConst.HOLER_CHANNEL).set((Object)this.intraChannel);
        this.intraChannel.attr(SolerConst.HOLER_CHANNEL).set((Object)holerChannel);
        SolerMsg hmsg = new SolerMsg();
        hmsg.setType((byte)3);
        hmsg.setUri(this.msg.getUri() + "@" + config.strValue("HOLER_ACCESS_KEY"));
        holerChannel.writeAndFlush((Object)hmsg);
        this.intraChannel.config().setOption(ChannelOption.AUTO_READ, (Object)true);
        ClientMgr.addIntraServer(this.msg.getUri(), this.intraChannel);
        ClientMgr.setIntraServerUri(this.intraChannel, this.msg.getUri());
    }
}

