/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.listener;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.client.ClientContainer;
import org.soler.client.listener.ClientConnectListener;
import org.soler.client.util.ClientMgr;
import org.soler.common.constant.SolerConst;
import org.soler.common.model.SolerMsg;
import org.soler.common.util.SolerConfig;

public class IntraServerListener
implements ChannelFutureListener {
    private Channel clientChannel = null;
    private SolerMsg msg = null;
    private static Logger log = LoggerFactory.getLogger(IntraServerListener.class);

    public IntraServerListener(Channel channel, SolerMsg msg) {
        this.clientChannel = channel;
        this.msg = msg;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (!future.isSuccess()) {
            log.warn("\u5ba2\u6237\u7aef\u5185\u90e8\u4ee3\u7406\u8bf7\u6c42\u901a\u9053\u672a\u80fd\u8fde\u63a5,\u8ba9\u670d\u52a1\u5668\u65ad\u5f00\u5ba2\u6237\u7aef");
            SolerMsg hmsg = new SolerMsg();
            hmsg.setType((byte)4);
            hmsg.setUri(this.msg.getUri());
            hmsg.setData((new String(this.msg.getData()) + "\u8bbf\u95ee\u4e0d\u901a,\u8bf7\u68c0\u67e5\u60a8\u7684\u670d\u52a1\u662f\u5426\u5df2\u542f\u52a8!").getBytes("UTF-8"));
            this.clientChannel.writeAndFlush((Object)hmsg);
            return;
        }
        log.warn("\u5ba2\u6237\u7aef\u5185\u90e8\u4ee3\u7406\u8bf7\u6c42\u901a\u9053\u5df2\u5f00\u542f");
        SolerConfig config = SolerConfig.getConfig();
        Channel intraChannel = future.channel();
        intraChannel.config().setOption(ChannelOption.AUTO_READ, (Object)false);
        Channel holerChannel = ClientMgr.pollClient();
        if (null == holerChannel) {
            String host = config.strValue("HOLER_SERVER_HOST");
            int port = config.intValue("HOLER_SERVER_PORT");
            ClientConnectListener listener = new ClientConnectListener(this.clientChannel, intraChannel, this.msg);
            Bootstrap holerClient = ClientContainer.getContainer().getHolerClient();
            holerClient.connect(host, port).addListener((GenericFutureListener)listener);
            return;
        }
        holerChannel.attr(SolerConst.HOLER_CHANNEL).set((Object)intraChannel);
        intraChannel.attr(SolerConst.HOLER_CHANNEL).set((Object)holerChannel);
        SolerMsg hmsg = new SolerMsg();
        hmsg.setType((byte)3);
        hmsg.setUri(this.msg.getUri() + "@" + config.strValue("HOLER_ACCESS_KEY"));
        holerChannel.writeAndFlush((Object)hmsg);
        intraChannel.config().setOption(ChannelOption.AUTO_READ, (Object)true);
        ClientMgr.addIntraServer(this.msg.getUri(), intraChannel);
        ClientMgr.setIntraServerUri(intraChannel, this.msg.getUri());
    }
}

