/*
 * Decompiled with CFR 0.152.
 */
package org.soler.client.util;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.common.constant.SolerConst;
import org.soler.common.util.SolerUtil;

public class ClientMgr {
    private static Logger log = LoggerFactory.getLogger(ClientMgr.class);
    private static Map<String, Channel> intraServers = new ConcurrentHashMap<String, Channel>();
    private static ConcurrentLinkedQueue<Channel> holerClients = new ConcurrentLinkedQueue();
    private static volatile Channel clientChannel = null;

    public static Channel getClientChannel() {
        return clientChannel;
    }

    public static void setClientChannel(Channel channel) {
        clientChannel = channel;
    }

    public static void setIntraServerUri(Channel channel, String uri) {
        channel.attr(SolerConst.HOLER_URI).set((Object)uri);
    }

    public static String getIntraServerUri(Channel channel) {
        return (String)channel.attr(SolerConst.HOLER_URI).get();
    }

    public static void removeClient(Channel channel) {
        holerClients.remove(channel);
    }

    public static Channel pollClient() {
        return holerClients.poll();
    }

    public static void pushClient(Channel channel) {
        if (holerClients.size() > 100) {
            channel.close();
            return;
        }
        channel.config().setOption(ChannelOption.AUTO_READ, (Object)true);
        channel.attr(SolerConst.HOLER_CHANNEL).set(null);
        holerClients.offer(channel);
    }

    public static void clearIntraServer() {
        log.info("Channel closed, clear intranet server channels.");
        for (Map.Entry<String, Channel> entry : intraServers.entrySet()) {
            Channel channel = entry.getValue();
            if (!channel.isActive()) continue;
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        intraServers.clear();
    }

    public static void clearHolerClient() {
        for (Map.Entry<String, Channel> entry : intraServers.entrySet()) {
            Channel channel = entry.getValue();
            SolerUtil.close(channel);
        }
        intraServers.clear();
        SolerUtil.close(clientChannel);
        for (Channel clientChannel : holerClients) {
            SolerUtil.close(clientChannel);
        }
    }

    public static void addIntraServer(String uri, Channel channel) {
        intraServers.put(uri, channel);
    }

    public static Channel removeIntraServer(String uri) {
        if (StringUtils.isEmpty((String)uri)) {
            return null;
        }
        return intraServers.remove(uri);
    }
}

