#!/bin/bash

# Copyright 2018-present, Yudong (Dom) Wang
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -----------------------------------------------------------------------------
# Soler Setup Script
# -----------------------------------------------------------------------------
cd `dirname $0`/..

SOLER_OK=0
SOLER_ERR=1

SOLER_NAME="soler"
SOLER_HOME=`pwd`
SOLER_BIN=$SOLER_HOME/bin
SOLER_CONF=$SOLER_HOME/conf/soler.conf
SOLER_SERVICE="soler.service"
SYSD_DIR="/lib/systemd/system"

input() 
{
    # Asking for the soler access key
    if [ -z "$SOLER_ACCESS_KEY" ]; then
        echo "Enter soler access key:"
        read SOLER_ACCESS_KEY
        if [ -z "$SOLER_ACCESS_KEY" ]; then
            echo "Please enter soler access key."
            exit $SOLER_ERR
        fi
        echo "SOLER_ACCESS_KEY=$SOLER_ACCESS_KEY" > $SOLER_CONF
    fi

    # Asking for the soler server host
    if [ -z "$SOLER_SERVER_HOST" ]; then
        echo "Enter soler server host:"
        read SOLER_SERVER_HOST
        if [ -z "$SOLER_SERVER_HOST" ]; then
            echo "Please enter soler server host."
            exit $SOLER_ERR
        fi
        echo "SOLER_SERVER_HOST=$SOLER_SERVER_HOST" >> $SOLER_CONF
    fi
}

setup()
{
    input
    cp $SOLER_BIN/$SOLER_SERVICE $SYSD_DIR/
    sed -i "s|@SOLER_HOME@|$SOLER_HOME|" $SYSD_DIR/$SOLER_SERVICE

    chmod +x $SOLER_BIN/$SOLER_NAME*
    chmod +x $SOLER_BIN/*.sh

    systemctl enable $SOLER_SERVICE
    systemctl daemon-reload
    systemctl start $SOLER_SERVICE
    systemctl status $SOLER_SERVICE
}

setup
