' Copyright 2018-present, Yudong (Dom) Wang
'
' Licensed under the Apache License, Version 2.0 (the "License");
' you may not use this file except in compliance with the License.
' You may obtain a copy of the License at
'
'      http://www.apache.org/licenses/LICENSE-2.0
'
' Unless required by applicable law or agreed to in writing, software
' distributed under the License is distributed on an "AS IS" BASIS,
' WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
' See the License for the specific language governing permissions and
' limitations under the License.

'---------------------------------------------------
' SETUP.VBS
'---------------------------------------------------
Dim SOLER_FSO
Dim SOLER_WSH
Dim SOLER_ENV
Dim SOLER_HOME
Dim SOLER_ACCESS_KEY
Dim SOLER_SERVER_HOST
Dim SOLER_VBS_FILE
Dim SOLER_BOOT_DIR
Dim SOLER_CONTENTS

Set SOLER_FSO = CreateObject("Scripting.FileSystemObject")
Set SOLER_WSH = CreateObject("WScript.Shell")
Set SOLER_ENV = SOLER_WSH.Environment("USER")

SOLER_VBS_FILE = "soler.vbs"
SOLER_BOOT_DIR = "C:\ProgramData\Microsoft\Windows\Start Menu\Programs\StartUp\"
SOLER_HOME = SOLER_FSO.GetFolder("..\").Path & "\"
SOLER_CONF = SOLER_HOME & "conf\soler.conf"

'---------------------------------------------------
' Input parameters
'---------------------------------------------------
InputParam

'---------------------------------------------------
' Set SOLER ENV
'---------------------------------------------------
SOLER_ENV("SOLER_HOME") = SOLER_HOME
SOLER_ENV("SOLER_ACCESS_KEY") = SOLER_ACCESS_KEY
SOLER_ENV("SOLER_SERVER_HOST") = SOLER_SERVER_HOST

SOLER_CONTENTS = "SOLER_ACCESS_KEY=" & SOLER_ACCESS_KEY & vbCrLf & "SOLER_SERVER_HOST=" & SOLER_SERVER_HOST
WriteFile SOLER_CONF, SOLER_CONTENTS

'---------------------------------------------------
' Set startup
'---------------------------------------------------
SOLER_FSO.CopyFile SOLER_VBS_FILE, SOLER_BOOT_DIR

MsgBox("Done")
WScript.Quit

'---------------------------------------------------
' Ask user to input parameters
'---------------------------------------------------
Function InputParam()
    SOLER_ACCESS_KEY = InputBox("Enter soler access key")
    If SOLER_ACCESS_KEY = Empty Then
        MsgBox "Please enter soler access key"
        WScript.Quit
    End If

    SOLER_SERVER_HOST = InputBox("Enter soler server host")
    If SOLER_SERVER_HOST = Empty Then
        MsgBox "Please enter soler server host"
        WScript.Quit
    End If
End Function

'---------------------------------------------------
' Write contents to file
'---------------------------------------------------
Function WriteFile(file, contents)
    Dim OutStream, FSO

    on error resume Next
    Set FSO = CreateObject("Scripting.FileSystemObject")
    Set OutStream = FSO.OpenTextFile(file, 2, True)

    OutStream.Write contents
    OutStream.close
End Function
