#!/bin/bash

# Copyright 2018-present, Yudong (Dom) Wang
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -----------------------------------------------------------------------------
# Soler Shutdown
# -----------------------------------------------------------------------------
cd `dirname $0`/..

SOLER_OK=0
SOLER_ERR=1
SOLER_PID=""

SOLER_HOME=`pwd`
SOLER_LOG_DIR=$SOLER_HOME/logs
SOLER_LOG=$SOLER_LOG_DIR/soler-client.log
SOLER_APP=$SOLER_HOME/soler-client.jar

pid() 
{
    SOLER_PID=`ps -ef | grep -v grep | grep "$SOLER_APP" |awk '{print $2}'`
}

status() 
{
    pid
    if [ -n "$SOLER_PID" ]; then
        echo "Soler client PID <$SOLER_PID> is running."
    else
        echo "Soler client is stopped."
    fi
}

stop() 
{
    if [ ! -d $SOLER_LOG_DIR ]; then
        mkdir -p $SOLER_LOG_DIR
    fi

    pid
    if [ -z "$SOLER_PID" ]; then
        status
        return $SOLER_OK
    fi

    echo -e "Stopping the soler client PID <$SOLER_PID> ...\c"
    kill -9 $SOLER_PID >> $SOLER_LOG 2>&1
    status
}

stop
