' Copyright 2018-present, Yudong (Dom) Wang
'
' Licensed under the Apache License, Version 2.0 (the "License");
' you may not use this file except in compliance with the License.
' You may obtain a copy of the License at
'
'      http://www.apache.org/licenses/LICENSE-2.0
'
' Unless required by applicable law or agreed to in writing, software
' distributed under the License is distributed on an "AS IS" BASIS,
' WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
' See the License for the specific language governing permissions and
' limitations under the License.

'---------------------------------------------------
' SOLER STARTUP.VBS
'---------------------------------------------------
Dim JAVA_BIN
Dim SOLER_WSH
Dim SOLER_FSO
Dim SOLER_CMD
Dim SOLER_LINE
Dim SOLER_HOME
Dim SOLER_LOG
Dim SOLER_LOG_DIR
Dim SOLER_CONTENTS

Dim SOLER_ACCESS_KEY
Dim SOLER_SERVER_HOST

Set SOLER_FSO = CreateObject("Scripting.FileSystemObject")
Set SOLER_WSH = CreateObject("WScript.Shell")
Set SOLER_ENV = SOLER_WSH.Environment("USER")

JAVA_BIN = "javaw"

SOLER_ACCESS_KEY = SOLER_ENV("SOLER_ACCESS_KEY")
SOLER_SERVER_HOST = SOLER_ENV("SOLER_SERVER_HOST")
SOLER_HOME = SOLER_ENV("SOLER_HOME")

If SOLER_HOME = Empty Then
    MsgBox "Please set SOLER_HOME"
    WScript.Quit
End If

SOLER_APP = SOLER_HOME & "soler-client.jar"
SOLER_LOG_DIR = SOLER_HOME & "logs"
SOLER_LOG = SOLER_LOG_DIR & "\soler-client.log"
SOLER_LINE = "------------------------------------------"
SOLER_CONF = SOLER_HOME & "conf\soler.conf"

'---------------------------------------------------
' Input parameters
'---------------------------------------------------
InputParam

'---------------------------------------------------
' Create logs directory
'---------------------------------------------------
If Not SOLER_FSO.folderExists(SOLER_LOG_DIR) Then
    SOLER_FSO.CreateFolder SOLER_LOG_DIR
End If

'---------------------------------------------------
' Launch soler program
'---------------------------------------------------
LaunchSoler

'---------------------------------------------------
' Function - Ask user to input parameters
'---------------------------------------------------
Function InputParam()
    If SOLER_ACCESS_KEY = Empty Then
        SOLER_ACCESS_KEY = InputBox("Enter soler access key")
        If SOLER_ACCESS_KEY = Empty Then
            MsgBox "Please enter soler access key"
            WScript.Quit
        End If
        SOLER_ENV("SOLER_ACCESS_KEY") = SOLER_ACCESS_KEY
        SOLER_CONTENTS = "SOLER_ACCESS_KEY=" & SOLER_ACCESS_KEY & vbCrLf
    End If

    If SOLER_SERVER_HOST = Empty Then
        SOLER_SERVER_HOST = InputBox("Enter soler server host")
        If SOLER_SERVER_HOST = Empty Then
            MsgBox "Please enter soler server host"
            WScript.Quit
        End If
        SOLER_ENV("SOLER_SERVER_HOST") = SOLER_SERVER_HOST
        SOLER_CONTENTS = SOLER_CONTENTS & "SOLER_SERVER_HOST=" & SOLER_SERVER_HOST
        WriteFile SOLER_CONF, SOLER_CONTENTS
    End If
End Function

'---------------------------------------------------
' Write contents to file
'---------------------------------------------------
Function WriteFile(file, contents)
    Dim OutStream, FSO

    on error resume Next
    Set FSO = CreateObject("Scripting.FileSystemObject")
    Set OutStream = FSO.OpenTextFile(file, 2, True)

    OutStream.Write contents
    OutStream.close
End Function

'---------------------------------------------------
' Function - Launch soler program
'---------------------------------------------------
Function LaunchSoler()
    '---------------------------------------------------
    ' Launch soler daemon
    '---------------------------------------------------
    SOLER_CMD = "cmd.exe /c " & JAVA_BIN & " -jar """ & SOLER_APP & """ >> """ & SOLER_LOG & """"
    SOLER_WSH.Run SOLER_CMD, 0, False

    '---------------------------------------------------
    ' Find soler daemon
    '---------------------------------------------------
    SOLER_CMD = "cmd.exe /c echo Starting soler client... & timeout /T 3 /NOBREAK & echo " & SOLER_LINE & " & echo The running soler client: & tasklist | findstr " & JAVA_BIN & " & echo " & SOLER_LINE & " & pause"
    SOLER_WSH.Run SOLER_CMD, 1, True
End Function
