@echo off
@REM Copyright 2018-present, Yudong (Dom) Wang
@REM
@REM Licensed under the Apache License, Version 2.0 (the "License");
@REM you may not use this file except in compliance with the License.
@REM You may obtain a copy of the License at
@REM
@REM      http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM Unless required by applicable law or agreed to in writing, software
@REM distributed under the License is distributed on an "AS IS" BASIS,
@REM WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM See the License for the specific language governing permissions and
@REM limitations under the License.

@REM -----------------------------------------------------------------------------
@REM Soler Startup
@REM -----------------------------------------------------------------------------
title soler-client
setlocal enabledelayedexpansion
set errorlevel=

set JAVA_BIN=java

set SOLER_OK=0
set SOLER_ERR=1
set SOLER_CURDIR=%~dp0
cd /d %SOLER_CURDIR%\..
set SOLER_HOME=%cd%
set SOLER_APP=!SOLER_HOME!\soler-client.jar
set SOLER_LOG_DIR=!SOLER_HOME!\logs
set SOLER_LOG=!SOLER_LOG_DIR!\soler-client.log
set SOLER_LINE=------------------------------------------
set SOLER_CONF=!SOLER_HOME!\conf\soler.conf

@REM Create logs directory
if not exist "!SOLER_LOG_DIR!" (
    mkdir "!SOLER_LOG_DIR!"
)

@REM Check if Java is correctly installed and set
"!JAVA_BIN!" -version 1>nul 2>nul
if !errorlevel! neq 0 (
    @echo.
    @echo Please install Java 1.7 or higher and make sure the Java is set correctly.
    @echo.
    @echo You can execute command [ !JAVA_BIN! -version ] to check if Java is correctly installed and set.
    @echo.
    pause
    goto:eof
)

@REM Set SOLER ENV
if exist "!SOLER_CONF!" (
    for /f "usebackq eol=# delims== tokens=1,*" %%i in ("!SOLER_CONF!") do set %%i=%%j
)

@REM Asking for the SOLER_ACCESS_KEY
if "!SOLER_ACCESS_KEY!" equ "" (
    @echo !SOLER_LINE!
    set /p SOLER_ACCESS_KEY="Enter soler access key: "
    if "!SOLER_ACCESS_KEY!" == "" (
        @echo Please enter soler access key
        @echo !SOLER_LINE!
        pause
        exit /b !SOLER_ERR!
    )
    @echo SOLER_ACCESS_KEY=!SOLER_ACCESS_KEY!> "!SOLER_CONF!"
)

@REM Asking for the SOLER_SERVER_HOST
if "!SOLER_SERVER_HOST!" equ "" (
    @echo !SOLER_LINE!
    set /p SOLER_SERVER_HOST="Enter soler server host: "
    if "!SOLER_SERVER_HOST!" == "" (
        @echo Please enter soler server host
        @echo !SOLER_LINE!
        pause
        exit /b !SOLER_ERR!
    )
    @echo SOLER_SERVER_HOST=!SOLER_SERVER_HOST!>> "!SOLER_CONF!"
)

@echo !SOLER_LINE!
@echo Starting soler client...

start /b !JAVA_BIN!w -jar "!SOLER_APP!" >> "!SOLER_LOG!"
timeout /T 3 /NOBREAK

@echo !SOLER_LINE!
tasklist | findstr !JAVA_BIN!w

if !errorlevel! equ 0 (
    @echo !SOLER_LINE!
    @echo Started soler client.
    @echo.
    @echo The soler client is running.
    @echo !SOLER_LINE!
) else (
    @echo Soler client is stopped.
    @echo Please check the log file for details [ !SOLER_LOG! ]
    @echo !SOLER_LINE!
)

pause
goto:eof
