#!/bin/bash

# Copyright 2018-present, Yudong (Dom) Wang
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -----------------------------------------------------------------------------
# Soler Startup
# -----------------------------------------------------------------------------
cd `dirname $0`/..

JAVA_BIN=$JAVA_HOME/bin/java

SOLER_OK=0
SOLER_ERR=1
SOLER_PID=""

SOLER_HOME=`pwd`
SOLER_LOG_DIR=$SOLER_HOME/logs
SOLER_LOG=$SOLER_LOG_DIR/soler-client.log
SOLER_APP=$SOLER_HOME/soler-client.jar
SOLER_CONF=$SOLER_HOME/conf/soler.conf

pid() 
{
    SOLER_PID=`ps -ef | grep -v grep | grep "$SOLER_APP" |awk '{print $2}'`
}

status() 
{
    pid
    if [ -n "$SOLER_PID" ]; then
        echo "Soler client PID <$SOLER_PID> is running."
    else
        echo "Soler client is stopped."
    fi
}

input() 
{
    if [ -f $SOLER_CONF ]; then
        . $SOLER_CONF
    fi

    # Asking for the soler access key
    if [ -z "$SOLER_ACCESS_KEY" ]; then
        echo "Enter soler access key:"
        read SOLER_ACCESS_KEY
        if [ -z "$SOLER_ACCESS_KEY" ]; then
            echo "Please enter soler access key."
            exit $SOLER_ERR
        fi
        echo "SOLER_ACCESS_KEY=$SOLER_ACCESS_KEY" > $SOLER_CONF
    fi

    # Asking for the soler server host
    if [ -z "$SOLER_SERVER_HOST" ]; then
        echo "Enter soler server host:"
        read SOLER_SERVER_HOST
        if [ -z "$SOLER_SERVER_HOST" ]; then
            echo "Please enter soler server host."
            exit $SOLER_ERR
        fi
        echo "SOLER_SERVER_HOST=$SOLER_SERVER_HOST" >> $SOLER_CONF
    fi
}

start() 
{
    if [ ! -d $SOLER_LOG_DIR ]; then
        mkdir -p $SOLER_LOG_DIR
    fi

    pid
    if [ -n "$SOLER_PID" ]; then
        status
        return $SOLER_OK
    fi

    if [ ! -f "$JAVA_BIN" ]; then
        JAVA_BIN=`which java`
        if [ ! -f "$JAVA_BIN" ]; then
            JAVA_BIN=java
        fi
    fi

    input
    nohup $JAVA_BIN -jar $SOLER_APP >> $SOLER_LOG 2>&1 &
    status
}

start
