# ************************************************************
# Sequel Pro SQL dump
# Version 4541
#
# http://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 127.0.0.1 (MySQL 5.7.33)
# Database: sx6_erp
# Generation Time: 2021-01-29 09:04:03 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `app_version`;

CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  `up_sql2` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_shop_codesss` (`version`,`up_time`,`up_sql2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';



# Dump of table c_componentelements
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_componentelements`;

CREATE TABLE `c_componentelements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单编号',
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ele_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `photocount` int(11) NOT NULL DEFAULT '0',
  `remarks` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '备注',
  `sjstate` int(11) DEFAULT '0',
  `sjenddate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sjstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `photourl` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `isphoto` int(11) DEFAULT '0',
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  `consorting` int(11) DEFAULT '0' COMMENT '项',
  PRIMARY KEY (`id`),
  KEY `page_orderId` (`orderId`),
  KEY `ele_name` (`ele_name`),
  KEY `sjenddate` (`sjenddate`),
  KEY `sjstate` (`sjstate`),
  KEY `sjstaff` (`sjstaff`),
  KEY `consumption_name` (`consumption_name`),
  KEY `sorting` (`consorting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户产品手机表';



# Dump of table c_consumptioncontent
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_consumptioncontent`;

CREATE TABLE `c_consumptioncontent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `sorting` int(11) DEFAULT NULL COMMENT '项',
  `categories` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '子类别',
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `amount` int(11) DEFAULT NULL COMMENT '数量',
  `remarks` text COLLATE utf8_unicode_ci COMMENT '备注',
  `transfer_certificate` int(11) DEFAULT NULL COMMENT '是否转出件',
  `take_away_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '取件日期',
  `item_pagecount` int(11) DEFAULT NULL COMMENT 'P数',
  `item_sheetscount` int(11) DEFAULT NULL COMMENT '入册张数',
  `whethercantake` tinyint(4) DEFAULT '0' COMMENT '完成状态',
  `whether_already_take` tinyint(4) DEFAULT '0' COMMENT '取件状态',
  `Urgent` tinyint(4) DEFAULT '0' COMMENT '急件',
  `size` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '尺寸用于选片裁切',
  `getuser` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件人',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '单价',
  `cost` decimal(10,2) DEFAULT '0.00' COMMENT '成本',
  `total` decimal(10,2) DEFAULT '0.00' COMMENT '小计',
  `send_count` int(11) DEFAULT '0' COMMENT '送件次数',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `issources` int(11) DEFAULT NULL COMMENT '0代表一销，1代表二销售，2一箱赠送，3二销售赠送',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '数据创建时间',
  `take_can_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '整件日期',
  `take_urgent_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '急件日期',
  `specifications` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品规格',
  `updateremarks` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '升级备注',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '收款赠送id',
  `lockd` int(11) DEFAULT '0',
  `hasproduct` int(11) DEFAULT '0',
  `servicenumber` int(11) DEFAULT '1',
  `tx` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cztx` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `yejiprice` decimal(10,2) DEFAULT '0.00' COMMENT '成长包套单次服务价格',
  `yuanjiaprice` decimal(10,2) DEFAULT '0.00' COMMENT '原价',
  `addpcount` int(11) DEFAULT '0' COMMENT '加P',
  `xccolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zspcount` int(11) DEFAULT '0' COMMENT '赠送P',
  `yspcount` int(11) DEFAULT '0' COMMENT '项目原始P数',
  `tofendian` varchar(2) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '产品到店',
  `rfidno` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `outfacdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '出厂时间',
  `outfaclist` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `vipcardidxn` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '扣VIP虚拟',
  `vipxnmoney` decimal(10,2) DEFAULT '0.00' COMMENT 'VIP虚拟金额',
  `issp` int(11) DEFAULT '0' COMMENT '参与选片',
  `olditemid` int(11) DEFAULT '0',
  `othervipxnmoney` decimal(10,2) DEFAULT '0.00' COMMENT '额外扣除虚拟金额',
  `zhuijianreason` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '追件原因',
  `dayinrfidday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '打印rfid日期',
  `zengsongid` int(11) DEFAULT '0',
  `zsmoney` decimal(10,2) DEFAULT '0.00',
  `istxitem` int(11) DEFAULT '0',
  `tofendiandate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `ckssubtypes` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `ordertype` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `elesjover` int(11) DEFAULT '0',
  `txconmoney` decimal(10,2) DEFAULT '0.00',
  `payjmid` int(11) DEFAULT '0',
  `qianqimoney` decimal(10,2) DEFAULT '0.00',
  `erxiaomoney` decimal(10,2) DEFAULT '0.00',
  `shengjimoney` decimal(10,2) DEFAULT '0.00',
  `xudingmoney` decimal(10,2) DEFAULT '0.00',
  `todiantakaddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cantakeman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `rfiddayinman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `addman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `adddcount` int(11) DEFAULT '0',
  `ysdcount` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `page_orderId` (`orderId`),
  KEY `page_customerid` (`customerid`),
  KEY `page_shop_code` (`shop_code`),
  KEY `Index 5` (`rfidno`,`servicenumber`,`outfacdate`,`vipcardidxn`,`vipxnmoney`,`othervipxnmoney`),
  KEY `sorting_categories_consumption_name` (`sorting`,`categories`,`consumption_name`),
  KEY `create_time` (`create_time`),
  KEY `take_away_date` (`take_away_date`),
  KEY `transfer_certificate` (`transfer_certificate`),
  KEY `whethercantake_whether_already_take` (`whethercantake`,`whether_already_take`),
  KEY `send_count` (`send_count`),
  KEY `take_can_date_take_urgent_date` (`take_can_date`,`take_urgent_date`),
  KEY `issources` (`issources`),
  KEY `hasproduct` (`hasproduct`),
  KEY `setkey` (`setkey`),
  KEY `issp` (`issp`),
  KEY `outfaclist` (`outfaclist`),
  KEY `tofendiandate` (`tofendiandate`),
  KEY `zengsongid` (`zengsongid`),
  KEY `ckssubtypes` (`ckssubtypes`),
  KEY `tx` (`tx`),
  KEY `cztx` (`cztx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户消费想表';



# Dump of table c_consumptioncontentdel
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_consumptioncontentdel`;

CREATE TABLE `c_consumptioncontentdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_id` int(11) NOT NULL,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `sorting` int(11) DEFAULT NULL COMMENT '项',
  `categories` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '子类别',
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `amount` int(11) DEFAULT NULL COMMENT '数量',
  `remarks` text COLLATE utf8_unicode_ci COMMENT '备注',
  `transfer_certificate` int(11) DEFAULT NULL COMMENT '是否转出件',
  `take_away_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '取件日期',
  `item_pagecount` int(11) DEFAULT NULL COMMENT 'P数',
  `item_sheetscount` int(11) DEFAULT NULL COMMENT '入册张数',
  `whethercantake` tinyint(4) DEFAULT '0' COMMENT '完成状态',
  `whether_already_take` tinyint(4) DEFAULT '0' COMMENT '取件状态',
  `Urgent` tinyint(4) DEFAULT '0' COMMENT '急件',
  `size` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '尺寸用于选片裁切',
  `getuser` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件人',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '单价',
  `cost` decimal(10,2) DEFAULT '0.00' COMMENT '成本',
  `total` decimal(10,2) DEFAULT '0.00' COMMENT '小计',
  `send_count` int(11) DEFAULT '0' COMMENT '送件次数',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `issources` int(11) DEFAULT NULL COMMENT '0代表一销，1代表二销售，2一箱赠送，3二销售赠送',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `take_can_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '整件日期',
  `take_urgent_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '急件日期',
  `specifications` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品规格',
  `updateremarks` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '升级备注',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lockd` int(11) DEFAULT '0',
  `hasproduct` int(11) DEFAULT '0',
  `servicenumber` int(11) DEFAULT '1',
  `tx` varchar(100) COLLATE utf8_unicode_ci DEFAULT '1',
  `yejiprice` decimal(10,2) DEFAULT '0.00' COMMENT '成长包套单次服务价格',
  `yuanjiaprice` decimal(10,2) DEFAULT '0.00' COMMENT '原价',
  `addpcount` int(11) DEFAULT '0' COMMENT '加P',
  `xccolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zspcount` int(11) DEFAULT '0' COMMENT '赠送P',
  `yspcount` int(11) DEFAULT '0' COMMENT '项目原始P数',
  `tofendian` varchar(2) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '产品到店',
  `rfidno` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `outfacdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '出厂时间',
  `opshop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `opshop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '升级店面',
  `optype` varchar(10) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '操作类型',
  `issp` int(11) DEFAULT '0',
  `ckssubtypes` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zengsongid` int(11) DEFAULT '0',
  `deltime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `qianqimoney` decimal(10,2) DEFAULT '0.00',
  `erxiaomoney` decimal(10,2) DEFAULT '0.00',
  `shengjimoney` decimal(10,2) DEFAULT '0.00',
  `xudingmoney` decimal(10,2) DEFAULT '0.00',
  `addman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `adddcount` int(11) DEFAULT '0',
  `ysdcount` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `sorting` (`sorting`),
  KEY `consumption_name` (`consumption_name`),
  KEY `c_id` (`c_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户消费想升级表';



# Dump of table c_consumptioncontentkz
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_consumptioncontentkz`;

CREATE TABLE `c_consumptioncontentkz` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `sorting` int(11) DEFAULT NULL COMMENT '项',
  `categories` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '子类别',
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `amount` int(11) DEFAULT NULL COMMENT '数量',
  `remarks` text COLLATE utf8_unicode_ci COMMENT '备注',
  `transfer_certificate` int(11) DEFAULT NULL COMMENT '是否转出件',
  `take_away_date` datetime DEFAULT NULL COMMENT '取件日期',
  `item_pagecount` int(11) DEFAULT NULL COMMENT 'P数',
  `item_sheetscount` int(11) DEFAULT NULL COMMENT '入册张数',
  `take_away_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件时间',
  `whethercantake` tinyint(4) DEFAULT '0' COMMENT '完成状态',
  `whether_already_take` tinyint(4) DEFAULT '0' COMMENT '取件状态',
  `Urgent` tinyint(4) DEFAULT '0' COMMENT '急件',
  `size` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '尺寸用于选片裁切',
  `getuser` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件人',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '单价',
  `cost` decimal(10,2) DEFAULT '0.00' COMMENT '成本',
  `total` decimal(10,2) DEFAULT '0.00' COMMENT '小计',
  `send_count` int(11) DEFAULT '0' COMMENT '送件次数',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `issources` int(11) DEFAULT NULL COMMENT '0代表一销，1代表二销售，2一箱赠送，3二销售赠送',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `take_can_date` datetime DEFAULT NULL COMMENT '整件日期',
  `take_urgent_date` datetime DEFAULT NULL COMMENT '急件日期',
  `specifications` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品规格',
  `updateremarks` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '升级备注',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sj_sendtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_senddate` datetime DEFAULT NULL,
  `sj_sendname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_sendnumberplate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_sendphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_sendaddress` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_sendremarks` text COLLATE utf8_unicode_ci,
  `sj_area` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `tx` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `lockd` int(11) DEFAULT '0',
  `hasproduct` int(11) DEFAULT '0',
  `servicenumber` int(11) DEFAULT '1',
  `cid` int(11) DEFAULT '0',
  `yejiprice` decimal(10,2) DEFAULT '0.00',
  `yuanjiaprice` decimal(10,2) DEFAULT '0.00',
  `addpcount` int(11) DEFAULT '0',
  `xccolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zspcount` int(11) DEFAULT '0',
  `yspcount` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `page_orderId` (`orderId`),
  KEY `page_customerid` (`customerid`),
  KEY `page_shop_code` (`shop_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户消费项目快照备份表';



# Dump of table c_consumptioncontentzsmoney
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_consumptioncontentzsmoney`;

CREATE TABLE `c_consumptioncontentzsmoney` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `sorting` int(11) DEFAULT NULL COMMENT '项',
  `categories` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '子类别',
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `amount` int(11) DEFAULT '1' COMMENT '数量',
  `item_pagecount` int(11) DEFAULT NULL COMMENT 'P数',
  `item_sheetscount` int(11) DEFAULT NULL COMMENT '入册张数',
  `price` decimal(10,2) DEFAULT '0.00' COMMENT '单价',
  `cost` decimal(10,2) DEFAULT '0.00' COMMENT '成本',
  `total` decimal(10,2) DEFAULT '0.00' COMMENT '小计',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `issources` int(11) DEFAULT NULL COMMENT '0代表一销，1代表二销售，2一箱赠送，3二销售赠送',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '数据创建时间',
  `servicenumber` int(11) DEFAULT '1',
  `yejiprice` decimal(10,2) DEFAULT '0.00' COMMENT '成长包套单次服务价格',
  `yuanjiaprice` decimal(10,2) DEFAULT '0.00' COMMENT '原价',
  `tx` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cztx` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zengsongid` int(11) DEFAULT '0',
  `deltime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `page_orderId` (`orderId`),
  KEY `page_shop_code` (`shop_code`),
  KEY `Index 5` (`servicenumber`),
  KEY `sorting_categories_consumption_name` (`sorting`,`categories`,`consumption_name`),
  KEY `create_time` (`create_time`),
  KEY `issources` (`issources`),
  KEY `tx_cztx` (`tx`,`cztx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户消费想表';



# Dump of table c_customer_track
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customer_track`;

CREATE TABLE `c_customer_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '女士手机',
  `currentfc` int(11) NOT NULL DEFAULT '0' COMMENT '服次',
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '客户编号',
  `operating_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `operating_time` datetime DEFAULT NULL COMMENT '操作时间',
  `operating_content` text COLLATE utf8_unicode_ci COMMENT '操作内容',
  `remark_details` text COLLATE utf8_unicode_ci COMMENT '操作明细',
  `operating_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '操作类型',
  `type_subordinate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '操作下级类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户轨迹表';



# Dump of table c_customercomplaint
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customercomplaint`;

CREATE TABLE `c_customercomplaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户编号',
  `kesuday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `kesystate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuzhuti` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesutype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesujinjidu` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesufangshi` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesutel` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuinfo` text COLLATE utf8_unicode_ci,
  `createstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuqixian` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuopshop` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuopdep` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuopstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isopkesu` int(11) DEFAULT '0',
  `kesuendqixian` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kesuopsolution` text COLLATE utf8_unicode_ci,
  `kesuzerenstaff` text COLLATE utf8_unicode_ci,
  `kesujiandustaff` text COLLATE utf8_unicode_ci,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  `huifangstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `huifangday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesusolution` text COLLATE utf8_unicode_ci,
  `kesejiejueday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kesejiejuetype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `lcfzstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kesutime` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `customerid` (`customerid`),
  KEY `kesuday` (`kesuday`),
  KEY `kesystate` (`kesystate`),
  KEY `kesuzhuti` (`kesuzhuti`),
  KEY `kesutype` (`kesutype`),
  KEY `kesujinjidu` (`kesujinjidu`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客诉抱怨';



# Dump of table c_customerfenpeipaixianginfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerfenpeipaixianginfo`;

CREATE TABLE `c_customerfenpeipaixianginfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fenpeiyaoyueday` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fenpeiyaoyuestaff` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `yaoyuepaixiangstaff` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `createtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`),
  KEY `fenpeiyaoyueday` (`fenpeiyaoyueday`),
  KEY `fenpeiyaoyuestaff` (`fenpeiyaoyuestaff`),
  KEY `yaoyuepaixiangstaff` (`yaoyuepaixiangstaff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customerimagesp
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerimagesp`;

CREATE TABLE `c_customerimagesp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `imageurl` text COLLATE utf8_unicode_ci,
  `imagename` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `createtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `codetype` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customerimagetb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerimagetb`;

CREATE TABLE `c_customerimagetb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `imageurl` text COLLATE utf8_unicode_ci,
  `imagename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `imgtype` int(11) DEFAULT '0' COMMENT '0: 定妆照，1:三宝照',
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customerinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerinfo`;

CREATE TABLE `c_customerinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `mname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士姓名',
  `mphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士手机',
  `mwechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士微信',
  `mqq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士QQ',
  `wname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士姓名',
  `wphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士手机',
  `wwechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士微信',
  `wqq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女QQ',
  `address` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地址',
  `cssname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `mbirthdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士生日',
  `wbirthdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士生日',
  `midtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士证件类型',
  `mid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男证件号码',
  `introducerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人编号',
  `introducer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人姓名',
  `weddingdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `wIdtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女证件类型',
  `wid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女证件号码',
  `customernote` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `bbname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝姓名',
  `bnickname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝昵称',
  `bbithdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝生日（阳历）',
  `liunardate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝生日（阴历）',
  `bbsex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝性别',
  `bzodiac` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝生肖',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系邮箱',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户所属店面码',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户所属店面',
  `vipnum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员卡号',
  `viptype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员类型',
  `vippercents` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '线上会员折扣',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `yc_day` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '预产日期',
  `bb_hospital` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生医院',
  `customer_from` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户系统来源（CRM/会员/手机端开单）',
  `brandid` int(11) unsigned DEFAULT '0' COMMENT '事业部ID',
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `bbheight` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `bbweight` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `address_sheng` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `address_shi` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `address_qu` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `wxstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `consumption_types` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `intentionpagename` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `acceptor_addresss` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `djr_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fenpei_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `jindian_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shijijindian_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dingdan_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dingdan_shopcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dingdan_shopname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `op_signday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `yupai_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `is_fp` int(11) DEFAULT '0',
  `is_intostore` int(11) DEFAULT '0',
  `is_success` int(11) DEFAULT '0',
  `is_valid` int(11) DEFAULT '0',
  `is_loss` int(11) DEFAULT '0',
  `fpstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `lasttracktime` datetime DEFAULT NULL,
  `isdaorugengxin` int(11) DEFAULT '0',
  `tibaostaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cplastday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cpstaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isbandweixin` int(11) DEFAULT '0',
  `bbname2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `bbsex2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `bbithdate2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `dianfangtel` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cinfo_customerid` (`customerid`),
  KEY `customerid` (`customerid`),
  KEY `in_create_time` (`create_time`),
  KEY `in_wxstaff` (`wxstaff`),
  KEY `in_djr_day` (`djr_day`),
  KEY `in_fenpei_day` (`fenpei_day`),
  KEY `in_jindian_day` (`jindian_day`),
  KEY `in_shijijindian_day` (`shijijindian_day`),
  KEY `in_dingdan_day` (`dingdan_day`),
  KEY `in_is_fp` (`is_fp`),
  KEY `in_is_intostore` (`is_intostore`),
  KEY `in_is_success` (`is_success`),
  KEY `in_is_valid` (`is_valid`),
  KEY `in_is_loss` (`is_loss`),
  KEY `in_yupai_day` (`yupai_day`),
  KEY `in_fpstaff` (`fpstaff`),
  KEY `shop_code` (`shop_code`),
  KEY `shop_name` (`shop_name`),
  KEY `vipnum` (`vipnum`),
  KEY `mbirthdate` (`mbirthdate`),
  KEY `wbirthdate` (`wbirthdate`),
  KEY `bbithdate` (`bbithdate`),
  KEY `bbname` (`bbname`),
  KEY `area` (`area`),
  KEY `wphone` (`wphone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户基本资料表';



# Dump of table c_customerinfodel
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerinfodel`;

CREATE TABLE `c_customerinfodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `mname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士姓名',
  `mphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士手机',
  `mwechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士微信',
  `mqq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士QQ',
  `wname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士姓名',
  `wphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士手机',
  `wwechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士微信',
  `wqq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女QQ',
  `address` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地址',
  `cssname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `mbirthdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士生日',
  `wbirthdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士生日',
  `midtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士证件类型',
  `mid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男证件号码',
  `introducerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人编号',
  `introducer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人姓名',
  `weddingdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `wIdtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女证件类型',
  `wid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女证件号码',
  `customernote` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `bbname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝姓名',
  `bnickname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝昵称',
  `bbithdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝生日（阳历）',
  `liunardate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝生日（阴历）',
  `bbsex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝性别',
  `bzodiac` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝生肖',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系邮箱',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户所属店面码',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户所属店面',
  `vipnum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员卡号',
  `viptype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员类型',
  `vippercents` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '线上会员折扣',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `yc_day` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '预产日期',
  `bb_hospital` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生医院',
  `customer_from` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户系统来源（CRM/会员/手机端开单）',
  `brandid` int(11) unsigned DEFAULT '0' COMMENT '事业部ID',
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `bbheight` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `bbweight` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `address_sheng` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `address_shi` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `address_qu` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `wxstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `consumption_types` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `intentionpagename` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `acceptor_addresss` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `djr_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fenpei_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `jindian_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shijijindian_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dingdan_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dingdan_shopcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dingdan_shopname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `op_signday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `yupai_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `is_fp` int(11) DEFAULT '0',
  `is_intostore` int(11) DEFAULT '0',
  `is_success` int(11) DEFAULT '0',
  `is_valid` int(11) DEFAULT '0',
  `is_loss` int(11) DEFAULT '0',
  `fpstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `lasttracktime` datetime DEFAULT NULL,
  `isdaorugengxin` int(11) DEFAULT '0',
  `tibaostaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cplastday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cpstaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isbandweixin` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cinfo_customerid` (`customerid`),
  KEY `customerid` (`customerid`),
  KEY `in_create_time` (`create_time`),
  KEY `in_wxstaff` (`wxstaff`),
  KEY `in_djr_day` (`djr_day`),
  KEY `in_fenpei_day` (`fenpei_day`),
  KEY `in_jindian_day` (`jindian_day`),
  KEY `in_shijijindian_day` (`shijijindian_day`),
  KEY `in_dingdan_day` (`dingdan_day`),
  KEY `in_is_fp` (`is_fp`),
  KEY `in_is_intostore` (`is_intostore`),
  KEY `in_is_success` (`is_success`),
  KEY `in_is_valid` (`is_valid`),
  KEY `in_is_loss` (`is_loss`),
  KEY `in_yupai_day` (`yupai_day`),
  KEY `in_fpstaff` (`fpstaff`),
  KEY `shop_code` (`shop_code`),
  KEY `shop_name` (`shop_name`),
  KEY `vipnum` (`vipnum`),
  KEY `mbirthdate` (`mbirthdate`),
  KEY `wbirthdate` (`wbirthdate`),
  KEY `bbithdate` (`bbithdate`),
  KEY `bbname` (`bbname`),
  KEY `area` (`area`),
  KEY `wphone` (`wphone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customerorder
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerorder`;

CREATE TABLE `c_customerorder` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户编号',
  `order_type` tinyint(4) unsigned DEFAULT '0' COMMENT '订单状态',
  `consumption_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '消费类型',
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '套餐名称',
  `targetdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单日期',
  `targetime` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单时间',
  `storeconsuitant1` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '销售门市',
  `storeconsuitant2` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '网销门市',
  `acceptor_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '接单点',
  `total_money` decimal(10,2) DEFAULT '0.00' COMMENT '订单总额',
  `payment_money` decimal(10,2) DEFAULT '0.00' COMMENT '订单已付',
  `nopayment_money` decimal(10,2) DEFAULT '0.00' COMMENT '订单未付',
  `supplementary_money` decimal(10,2) DEFAULT '0.00' COMMENT '二消总额',
  `bargain_money` decimal(10,2) DEFAULT '0.00' COMMENT '一销总额',
  `allfinishfate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单完成日',
  `payoervedate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '付款完成日',
  `firstpaydate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单第一次付款日',
  `dressmony` decimal(10,2) DEFAULT '0.00' COMMENT '礼服加挑总额',
  `sellmoney` decimal(10,2) DEFAULT '0.00' COMMENT '商品销售总额（没有）',
  `ordernote` text COLLATE utf8_unicode_ci COMMENT '订单备注',
  `shop_order_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '开单店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户所属店面码',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户所属店面',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '数据创建时间',
  `blankoutannal` tinyint(4) unsigned DEFAULT '0' COMMENT '本单作废',
  `blankoutannalremark` varchar(5000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '作废原因',
  `take_takaddress` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户取件点',
  `uploadoriginal` int(11) DEFAULT '0' COMMENT '传原始',
  `uploaddesign` int(11) DEFAULT '0' COMMENT '传设计',
  `spImport_photocount` int(11) DEFAULT '0' COMMENT '导片张数',
  `spcount` int(11) DEFAULT '0' COMMENT '选片张数',
  `spbook_photocount` int(11) DEFAULT '0' COMMENT '入册张数',
  `sendtime` datetime DEFAULT NULL COMMENT '发包时间',
  `getDate` datetime DEFAULT NULL COMMENT '客户取件日期',
  `turntype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '单据来源方式',
  `refund` int(11) DEFAULT '0' COMMENT '退款状态',
  `refunddate` datetime DEFAULT NULL COMMENT '退款日期',
  `reservelock` int(11) DEFAULT '0' COMMENT '一销锁定',
  `addlock` int(11) DEFAULT '0' COMMENT '二销锁定',
  `order_type_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户服务进度说明',
  `ordertopic` varchar(2000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '拍照主题',
  `customernote` varchar(5000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户备注（没用）',
  `storeconsuitant3` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '门市三',
  `indoordresscount` int(11) DEFAULT '0' COMMENT '内景礼服数',
  `outerdresscount` int(11) DEFAULT '0' COMMENT '外景礼服数',
  `paizhaocount` int(11) DEFAULT '0' COMMENT '拍照张数',
  `rucecount` int(11) DEFAULT '0' COMMENT '入册张数',
  `jingxiucount` int(11) DEFAULT '0' COMMENT '精修张数',
  `customerphoto` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '底片云客服电话',
  `servicenumber` int(11) DEFAULT '1' COMMENT '总服务次数',
  `wancheng` int(11) DEFAULT '0' COMMENT '当前完成服务次数',
  `qj_produceoverday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '生成完成日',
  `selkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `islocktxkz` int(11) DEFAULT '0',
  `ischeckorder` int(11) DEFAULT '0',
  `checkorderday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `checkorderstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `oldcustomerid` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `iskesongjianday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `jiandangren` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `blankoutannalday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `yixiaochengben` decimal(10,2) DEFAULT '0.00',
  `erxiaochengben` decimal(10,2) DEFAULT '0.00',
  `zengpinchengben` decimal(10,2) DEFAULT '0.00',
  `zongchengben` decimal(10,2) DEFAULT '0.00',
  `sindex` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `ischaochuchenben` int(11) DEFAULT '0',
  `sellItemstotal` decimal(10,2) DEFAULT '0.00',
  `sellItemspaymoney` decimal(10,2) DEFAULT '0.00',
  `sellItemsnomoney` decimal(10,2) DEFAULT '0.00',
  `ischaochenben` int(11) DEFAULT '0',
  `chenbenremark` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isvalid` int(11) DEFAULT '0',
  `validdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yixiaokakou` decimal(10,2) DEFAULT '0.00',
  `erxiaokakou` decimal(10,2) DEFAULT '0.00',
  `yixiaoshishou` decimal(10,2) DEFAULT '0.00',
  `erxiaoshishou` decimal(10,2) DEFAULT '0.00',
  `yxpackage_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `yxpackage_price` decimal(10,2) DEFAULT '0.00',
  `packyouxiaodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `nextphotodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '下次电访时间',
  `ischengzhangka` tinyint(4) DEFAULT '0' COMMENT '是否有成长卡',
  `give_photo_num` int(11) DEFAULT '0' COMMENT '赠送底片数量（目前是网络部在用）',
  `crm_customer_number` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'crm_c_customerinfo表字段，客资编号',
  `crm_c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'crm_c_customer_main表字段',
  `crm_order_type` tinyint(4) DEFAULT '2' COMMENT 'crm，订单类型：''1：线上；2：线下''',
  `crm_into_id` int(11) DEFAULT NULL COMMENT 'crm  进客表（crm_c_customer_intostore）id',
  `crm_visit_id` int(11) DEFAULT NULL,
  `iskesu` int(11) DEFAULT '0',
  `kesujinjidu` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cp_chusheng` int(11) DEFAULT '0',
  `cp_manyue` int(11) DEFAULT '0',
  `cp_baitian` int(11) DEFAULT '0',
  `cp_bansui` int(11) DEFAULT '0',
  `cp_yunfu` int(11) DEFAULT '0',
  `orderyouxiao` int(11) DEFAULT '0',
  `orderyouxiaodate` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `orderyouxiaoupdate` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `cp_zhousui` int(11) DEFAULT '0',
  `shengjimoney` decimal(10,2) DEFAULT '0.00',
  `xudingmoney` decimal(10,2) DEFAULT '0.00',
  `tuikuandate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `fenpeiyaoyueday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `fenpeiyaoyuestaff` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yaoyuepaixiangstaff` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `tuiguangstaff` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `old_bargain_money` decimal(10,2) DEFAULT '0.00',
  `wangfutype` varchar(5) COLLATE utf8_unicode_ci DEFAULT '',
  `ispingjia` int(11) DEFAULT '0',
  `crm_customer_id` int(11) DEFAULT '0',
  `yuezihuisuo` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `yuezitype` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `orderId` (`orderId`),
  KEY `order_orderId` (`orderId`),
  KEY `order_customerid` (`customerid`),
  KEY `order_shop_code` (`shop_code`),
  KEY `targetdate` (`targetdate`),
  KEY `packyouxiaodate` (`packyouxiaodate`),
  KEY `nextphotodate` (`nextphotodate`),
  KEY `ischengzhangka` (`ischengzhangka`),
  KEY `isvalid_validdate` (`isvalid`,`validdate`),
  KEY `sindex` (`sindex`),
  KEY `ischeckorder_checkorderday_checkorderstaff` (`ischeckorder`,`checkorderday`,`checkorderstaff`),
  KEY `crm_customer_number` (`crm_customer_number`) USING BTREE,
  KEY `selkey` (`selkey`),
  KEY `blankoutannal` (`blankoutannal`),
  KEY `take_takaddress` (`take_takaddress`),
  KEY `getDate` (`getDate`),
  KEY `sendtime` (`sendtime`),
  KEY `shop_order_name` (`shop_order_name`),
  KEY `storeconsuitant1` (`storeconsuitant1`),
  KEY `consumption_type` (`consumption_type`),
  KEY `bargain_money` (`bargain_money`),
  KEY `allfinishfate` (`allfinishfate`),
  KEY `tuiguangstaff` (`tuiguangstaff`),
  KEY `crm_customer_id` (`crm_customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户门市订单表';



# Dump of table c_customerorder_servicefc
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerorder_servicefc`;

CREATE TABLE `c_customerorder_servicefc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currentfc` int(11) DEFAULT '0',
  `allfc` int(11) DEFAULT '0',
  `islastfc` int(11) DEFAULT '0',
  `fcstate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `fcoverday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `isfccheck` int(11) DEFAULT '0',
  `fccheckstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `fcnote` text COLLATE utf8_unicode_ci,
  `fcdress_count` int(11) DEFAULT '0' COMMENT '服务次拍衣件数',
  `ismvshoot` varchar(2) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'MV是否拍摄',
  `ismvhege` varchar(2) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'MV合格',
  `mvcameraman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `mvdaoshiman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `ismvsale` varchar(2) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'MV已售出',
  `qj_getDate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `qj_sjgetDate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `take_takaddress` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qj_renname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qj_bzname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `iswhethercantake` tinyint(4) DEFAULT '0' COMMENT '摄影整件完成',
  `isalreadytake` tinyint(4) DEFAULT '0' COMMENT '摄影取件完成',
  `whethercantakedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '摄影整件日期',
  `alreadytakedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '摄影取件日期',
  `tracknumber` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '快递单号',
  `rfidno` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'RFID',
  `xianduweikuai` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0000' COMMENT '先睹为快',
  `qj_psjdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_sendnumber` int(11) DEFAULT '0',
  `senddate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '送件日期',
  `shoulddate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '应回件日期',
  `backdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '回件日期',
  `photoorder` int(11) DEFAULT '0' COMMENT '拍照服务次',
  `oldfcid` int(11) DEFAULT '0',
  `isflashsale` varchar(2) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '是否售出flash',
  `iswxqjwctongzhi` int(11) DEFAULT '0',
  `qujiantongzhiday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qujiantongzhistaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qujiantongzhistate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `photo_clean` int(11) DEFAULT '0' COMMENT '照片是否清理，0未清理，1已清理',
  `photo_clean_date` datetime DEFAULT NULL,
  `uploadcloud` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `checkfcstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '服务次审核',
  `checkfcday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `ischeckfc` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `takeauditstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '取件审核',
  `takeauditday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `takeaudit` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `mvjianjishi` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `youxiaosucai` int(11) DEFAULT '0',
  `iscaifang` int(11) DEFAULT '0',
  `ishege` int(11) DEFAULT '0',
  `mvsybackdate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `whethercantakeman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `huifangstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `huifangdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `caifangman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sc_isupload` int(11) DEFAULT '0',
  `sc_isdown` int(11) DEFAULT '0',
  `sc_iscpupload` int(11) DEFAULT '0',
  `sc_uploadday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sc_uploadname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sc_downday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sc_downname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sc_cpuploadday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sc_cpuploadname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sporderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shouldtodiandate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `kaidanzhuti` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `zjdayinday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `zjdayinman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `iskpmv` int(11) DEFAULT '0',
  `kuaidimoney` decimal(10,2) DEFAULT '0.00',
  `shuangyuecountfc` int(11) DEFAULT '0',
  `jianjiday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `fcguanjia` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `uploadcloudaddress` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `uploadclouddate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `uploadcloudman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `downcloudfile` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `downdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `isdownfabao` int(11) DEFAULT '0',
  `isdowndipian` int(11) DEFAULT '0',
  `cp_uploadday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `customerid` (`customerid`),
  KEY `orderId` (`orderId`),
  KEY `currentfc` (`currentfc`),
  KEY `fcoverday` (`fcoverday`),
  KEY `islastfc` (`islastfc`),
  KEY `qj_getDate` (`qj_getDate`),
  KEY `qj_sjgetDate` (`qj_sjgetDate`),
  KEY `alreadytakedate` (`alreadytakedate`),
  KEY `whethercantakedate` (`whethercantakedate`),
  KEY `tracknumber` (`tracknumber`),
  KEY `rfidno` (`rfidno`),
  KEY `xianduweikuai` (`xianduweikuai`),
  KEY `senddate` (`senddate`),
  KEY `shoulddate` (`shoulddate`),
  KEY `backdate` (`backdate`),
  KEY `photoorder` (`photoorder`),
  KEY `fcstate` (`fcstate`),
  KEY `take_takaddress` (`take_takaddress`),
  KEY `allfc` (`allfc`),
  KEY `sporderid` (`sporderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='成长服务次数表';



# Dump of table c_customerorderdel
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerorderdel`;

CREATE TABLE `c_customerorderdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户编号',
  `order_type` tinyint(4) unsigned DEFAULT '0' COMMENT '订单状态',
  `consumption_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '消费类型',
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '套餐名称',
  `targetdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单日期',
  `targetime` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单时间',
  `storeconsuitant1` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '销售门市',
  `storeconsuitant2` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '网销门市',
  `acceptor_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '接单点',
  `total_money` decimal(10,2) DEFAULT '0.00' COMMENT '订单总额',
  `payment_money` decimal(10,2) DEFAULT '0.00' COMMENT '订单已付',
  `nopayment_money` decimal(10,2) DEFAULT '0.00' COMMENT '订单未付',
  `supplementary_money` decimal(10,2) DEFAULT '0.00' COMMENT '二消总额',
  `bargain_money` decimal(10,2) DEFAULT '0.00' COMMENT '一销总额',
  `allfinishfate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单完成日',
  `payoervedate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '付款完成日',
  `firstpaydate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单第一次付款日',
  `dressmony` decimal(10,2) DEFAULT '0.00' COMMENT '礼服加挑总额',
  `sellmoney` decimal(10,2) DEFAULT '0.00' COMMENT '商品销售总额（没有）',
  `ordernote` text COLLATE utf8_unicode_ci COMMENT '订单备注',
  `shop_order_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '开单店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户所属店面码',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户所属店面',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '数据创建时间',
  `blankoutannal` tinyint(4) unsigned DEFAULT '0' COMMENT '本单作废',
  `blankoutannalremark` varchar(5000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '作废原因',
  `take_takaddress` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户取件点',
  `uploadoriginal` int(11) DEFAULT '0' COMMENT '传原始',
  `uploaddesign` int(11) DEFAULT '0' COMMENT '传设计',
  `spImport_photocount` int(11) DEFAULT '0' COMMENT '导片张数',
  `spcount` int(11) DEFAULT '0' COMMENT '选片张数',
  `spbook_photocount` int(11) DEFAULT '0' COMMENT '入册张数',
  `sendtime` datetime DEFAULT NULL COMMENT '发包时间',
  `getDate` datetime DEFAULT NULL COMMENT '客户取件日期',
  `turntype` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '单据来源方式',
  `refund` int(11) DEFAULT '0' COMMENT '退款状态',
  `refunddate` datetime DEFAULT NULL COMMENT '退款日期',
  `reservelock` int(11) DEFAULT '0' COMMENT '一销锁定',
  `addlock` int(11) DEFAULT '0' COMMENT '二销锁定',
  `order_type_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户服务进度说明',
  `ordertopic` varchar(2000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '拍照主题',
  `customernote` varchar(5000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户备注（没用）',
  `storeconsuitant3` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '门市三',
  `indoordresscount` int(11) DEFAULT '0' COMMENT '内景礼服数',
  `outerdresscount` int(11) DEFAULT '0' COMMENT '外景礼服数',
  `paizhaocount` int(11) DEFAULT '0' COMMENT '拍照张数',
  `rucecount` int(11) DEFAULT '0' COMMENT '入册张数',
  `jingxiucount` int(11) DEFAULT '0' COMMENT '精修张数',
  `customerphoto` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '底片云客服电话',
  `servicenumber` int(11) DEFAULT '1' COMMENT '总服务次数',
  `wancheng` int(11) DEFAULT '0' COMMENT '当前完成服务次数',
  `qj_produceoverday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '生成完成日',
  `selkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `islocktxkz` int(11) DEFAULT '0',
  `ischeckorder` int(11) DEFAULT '0',
  `checkorderday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `checkorderstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `oldcustomerid` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `iskesongjianday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `jiandangren` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `blankoutannalday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `yixiaochengben` decimal(10,2) DEFAULT '0.00',
  `erxiaochengben` decimal(10,2) DEFAULT '0.00',
  `zengpinchengben` decimal(10,2) DEFAULT '0.00',
  `zongchengben` decimal(10,2) DEFAULT '0.00',
  `sindex` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `ischaochuchenben` int(11) DEFAULT '0',
  `sellItemstotal` decimal(10,2) DEFAULT '0.00',
  `sellItemspaymoney` decimal(10,2) DEFAULT '0.00',
  `sellItemsnomoney` decimal(10,2) DEFAULT '0.00',
  `ischaochenben` int(11) DEFAULT '0',
  `chenbenremark` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isvalid` int(11) DEFAULT '0',
  `validdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yixiaokakou` decimal(10,2) DEFAULT '0.00',
  `erxiaokakou` decimal(10,2) DEFAULT '0.00',
  `yixiaoshishou` decimal(10,2) DEFAULT '0.00',
  `erxiaoshishou` decimal(10,2) DEFAULT '0.00',
  `yxpackage_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `yxpackage_price` decimal(10,2) DEFAULT '0.00',
  `packyouxiaodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `nextphotodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '下次电访时间',
  `ischengzhangka` tinyint(4) DEFAULT '0' COMMENT '是否有成长卡',
  `give_photo_num` int(11) DEFAULT '0' COMMENT '赠送底片数量（目前是网络部在用）',
  `crm_customer_number` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'crm_c_customerinfo表字段，客资编号',
  `crm_c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'crm_c_customer_main表字段',
  `crm_order_type` tinyint(4) DEFAULT '2' COMMENT 'crm，订单类型：''1：线上；2：线下''',
  `crm_into_id` int(11) DEFAULT NULL COMMENT 'crm  进客表（crm_c_customer_intostore）id',
  `crm_visit_id` int(11) DEFAULT NULL,
  `iskesu` int(11) DEFAULT '0',
  `kesujinjidu` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cp_chusheng` int(11) DEFAULT '0',
  `cp_manyue` int(11) DEFAULT '0',
  `cp_baitian` int(11) DEFAULT '0',
  `cp_bansui` int(11) DEFAULT '0',
  `cp_yunfu` int(11) DEFAULT '0',
  `orderyouxiao` int(11) DEFAULT '0',
  `orderyouxiaodate` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `orderyouxiaoupdate` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `cp_zhousui` int(11) DEFAULT '0',
  `shengjimoney` decimal(10,2) DEFAULT '0.00',
  `xudingmoney` decimal(10,2) DEFAULT '0.00',
  `shengji_money` decimal(10,2) DEFAULT '0.00',
  `tuikuandate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `fenpeiyaoyueday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `fenpeiyaoyuestaff` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yaoyuepaixiangstaff` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `delman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `deltime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`,`orderId`),
  KEY `order_orderId` (`orderId`),
  KEY `order_customerid` (`customerid`),
  KEY `order_shop_code` (`shop_code`),
  KEY `targetdate` (`targetdate`),
  KEY `packyouxiaodate` (`packyouxiaodate`),
  KEY `nextphotodate` (`nextphotodate`),
  KEY `ischengzhangka` (`ischengzhangka`),
  KEY `isvalid_validdate` (`isvalid`,`validdate`),
  KEY `sindex` (`sindex`),
  KEY `ischeckorder_checkorderday_checkorderstaff` (`ischeckorder`,`checkorderday`,`checkorderstaff`),
  KEY `crm_customer_number` (`crm_customer_number`) USING BTREE,
  KEY `selkey` (`selkey`),
  KEY `blankoutannal` (`blankoutannal`),
  KEY `take_takaddress` (`take_takaddress`),
  KEY `getDate` (`getDate`),
  KEY `sendtime` (`sendtime`),
  KEY `shop_order_name` (`shop_order_name`),
  KEY `storeconsuitant1` (`storeconsuitant1`),
  KEY `consumption_type` (`consumption_type`),
  KEY `bargain_money` (`bargain_money`),
  KEY `allfinishfate` (`allfinishfate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customerphoto
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerphoto`;

CREATE TABLE `c_customerphoto` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `currentfc` int(11) DEFAULT '0' COMMENT '服次',
  `photodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '拍摄日期',
  `phototime` varchar(10) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '拍照时间',
  `cameraman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影师',
  `mentor_a` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '引导师A',
  `phototype` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄类型',
  `photostate` tinyint(4) DEFAULT '5' COMMENT '拍摄状态0全为1未完2全完',
  `dresser` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '化妆师',
  `photonote` text COLLATE utf8_unicode_ci COMMENT '拍摄备注',
  `photocount` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄张数',
  `locationcount` int(11) DEFAULT '0' COMMENT '外景数',
  `Interiorcount` int(11) DEFAULT '0' COMMENT '内景数',
  `photobase` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影基地、多选',
  `communication_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影沟通日期',
  `communication_state` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影沟通状态',
  `communication_man` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影沟通人员',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄店面',
  `shop_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄店面编码',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `topic` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影主题',
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `islast` int(11) DEFAULT '0',
  `yipaidress_count` int(11) DEFAULT '0' COMMENT '已拍服装',
  `paikongstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `isphoto_zd` int(11) DEFAULT '0' COMMENT '占档',
  `todian` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `photooverdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `yxphotodaystart` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '意向拍照日期',
  `yxphotodayend` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `callphotomark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '电访备注',
  `isfileupload` int(11) DEFAULT '0',
  `fileuploadurl` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fileuploadtime` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fileshopcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fileshopname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `filelasturl` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `oldphotoid` int(11) DEFAULT '0',
  `iswxpzwctongzhi` int(11) DEFAULT '0',
  `todianday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `mvsheying` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sucaicount` int(11) DEFAULT '0',
  `qianqitaobanstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qianqitaobanpcount` int(11) DEFAULT '0',
  `qqphotomoney` decimal(10,2) DEFAULT '0.00',
  `topiclist` varchar(300) COLLATE utf8_unicode_ci DEFAULT '',
  `fuwutype` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `dqiseffect` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qqtaobanoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `pz_startdate` datetime DEFAULT NULL,
  `pz_enddate` datetime DEFAULT NULL,
  `timecount` int(11) DEFAULT '0',
  `smchuxiustaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `smchuxiucount` int(11) DEFAULT '0',
  `paikongshop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongshop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `yxphotoweek` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qzcount` int(11) DEFAULT '0',
  `qjfcount` int(11) DEFAULT '0',
  `bbcount` int(11) DEFAULT '0',
  `wjcount` int(11) DEFAULT '0',
  `yfcount` int(11) DEFAULT '0',
  `dresser2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `photoscore` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `photo_orderId` (`orderId`),
  KEY `photo_customerid` (`customerid`),
  KEY `photo_shop_code` (`shop_code`),
  KEY `in_photodate` (`photodate`),
  KEY `phototype` (`phototype`),
  KEY `currentfc` (`currentfc`),
  KEY `yxphotodaystart_yxphotodayend` (`yxphotodaystart`,`yxphotodayend`),
  KEY `phototime` (`phototime`),
  KEY `cameraman` (`cameraman`),
  KEY `islast` (`islast`),
  KEY `oldphotoid` (`oldphotoid`),
  KEY `photostate` (`photostate`),
  KEY `mentor_a` (`mentor_a`),
  KEY `dresser` (`dresser`),
  KEY `todian` (`todian`),
  KEY `qianqitaobanstaff` (`qianqitaobanstaff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户摄影订单表';



# Dump of table c_customerphotogq
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerphotogq`;

CREATE TABLE `c_customerphotogq` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `currentfc` int(11) DEFAULT '0' COMMENT '服次',
  `photodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄日期',
  `phototime` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照时间',
  `cameraman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影师',
  `mentor_a` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '引导师A',
  `phototype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄类型',
  `photostate` tinyint(4) DEFAULT '5' COMMENT '拍摄状态0全为1未完2全完',
  `dresser` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '化妆师',
  `photonote` text COLLATE utf8_unicode_ci COMMENT '拍摄备注',
  `photocount` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄张数',
  `locationcount` int(11) DEFAULT '0' COMMENT '外景数',
  `Interiorcount` int(11) DEFAULT '0' COMMENT '内景数',
  `photobase` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影基地、多选',
  `communication_date` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影沟通日期',
  `communication_state` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影沟通状态',
  `communication_man` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影沟通人员',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄店面编码',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `topic` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影主题',
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `islast` int(11) DEFAULT '0',
  `yipaidress_count` int(11) DEFAULT '0' COMMENT '已拍服装',
  `paikongstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `isphoto_zd` int(11) DEFAULT '0' COMMENT '占档',
  `todian` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `photooverdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `yxphotodaystart` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '意向拍照日期',
  `yxphotodayend` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `callphotomark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `gqremark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '改期备注',
  `qgman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '改期人',
  `gqtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '改期时间',
  `dqiseffect` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongshop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongshop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `fuwutype` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `orderId_customerid_currentfc_photodate_phototime` (`orderId`,`customerid`,`currentfc`,`photodate`,`phototime`),
  KEY `shop_code` (`shop_code`),
  KEY `gqtime` (`gqtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户摄影改期表';



# Dump of table c_customerphotozd
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerphotozd`;

CREATE TABLE `c_customerphotozd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photoid` int(11) DEFAULT '0',
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `currentfc` int(11) DEFAULT '0',
  `area` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `photodate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `phototime` varchar(4) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `zdtype` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `zddel` varchar(4) COLLATE utf8_unicode_ci DEFAULT '',
  `zddelstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zddeltime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`,`currentfc`),
  KEY `photodate` (`photodate`,`phototime`),
  KEY `shop_code` (`shop_code`),
  KEY `paikongstaff` (`paikongstaff`,`paikongtime`),
  KEY `zddel` (`zddel`,`zddelstaff`,`zddeltime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customerremark
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerremark`;

CREATE TABLE `c_customerremark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sendman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `info` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `typename_sendman_orderid` (`typename`,`sendman`,`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customersp
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customersp`;

CREATE TABLE `c_customersp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `currentfc` int(11) DEFAULT '0' COMMENT '服次信息',
  `selectday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '选片日期',
  `selectTime` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片时间',
  `sptstate` tinyint(4) DEFAULT '2' COMMENT '选片状态  0未选完，1已选，2未选',
  `selectman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片师',
  `spremarks` text COLLATE utf8_unicode_ci COMMENT '选片备注',
  `spcount` int(11) DEFAULT '0' COMMENT '选片张数',
  `spbook_photocount` int(11) DEFAULT '0' COMMENT '入册张数',
  `spImport_photocount` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `spnoticestate` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片通知状态  0未通知，1已通知',
  `spnoticedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片通知日期',
  `spnoticeman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片通知人员',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片店面编码',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `select_record` int(11) DEFAULT '0' COMMENT '导原片标记',
  `select_recordtime` datetime DEFAULT NULL COMMENT '导原片时间',
  `islast` int(11) DEFAULT '0' COMMENT '最后标记',
  `sptend_day` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '选片完成日',
  `select_design` int(11) DEFAULT '0' COMMENT '导设计标记',
  `select_designtime` datetime DEFAULT NULL COMMENT '导设计时间',
  `upday` datetime DEFAULT NULL,
  `upstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `select_truing` int(11) DEFAULT '0' COMMENT '导精修',
  `select_truingtime` datetime DEFAULT NULL,
  `islock` int(11) DEFAULT '0',
  `kanbanriqi` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版日期',
  `kanbanshijian` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版时间',
  `kanbanshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版师',
  `kanbanstate` int(11) DEFAULT '5' COMMENT '看版状态',
  `kanbanendday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '看版日期',
  `ypremark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `jxremark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `sjremark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `ypwarn` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `jxwarn` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `sjwarn` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `ystatus` int(11) DEFAULT '0',
  `ypxzstatus` int(11) DEFAULT '0',
  `fbxzstatus` int(11) DEFAULT '0',
  `spscstatus` int(11) DEFAULT '0',
  `scscstatus` int(11) DEFAULT '0',
  `scxzstatus` int(11) DEFAULT '0',
  `sjscstatus` int(11) DEFAULT '0',
  `paikongstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `kanbanpaikongstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kanbanpaikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `sptodian` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `kbtodian` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `sm_tiaosecount` int(11) DEFAULT '0' COMMENT '调色数',
  `sm_meibiancount` int(11) DEFAULT '0' COMMENT '美编数',
  `sm_shejicount` int(11) DEFAULT '0' COMMENT '设计数',
  `sm_jingxiucount` int(11) DEFAULT '0' COMMENT '精修数',
  `sm_paibancount` int(11) DEFAULT '0' COMMENT '排版数',
  `yqtiaoseman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样前调色',
  `americaneditorman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样前美编师',
  `designerman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样后设计师',
  `yhjxman` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '样后精修师',
  `artistman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '相册排版',
  `sm_tiaoseoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '调色完成日',
  `sm_meibianoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '美编完成日',
  `sm_shejioverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '设计完成日',
  `sm_jingxiuoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '精修完成日',
  `sm_paibanoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '排版完成日',
  `yxselectdaystart` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yxselectdayend` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `sendtime` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `sm_yqmeibianphday` datetime DEFAULT NULL,
  `sm_yqmeibianywcday` datetime DEFAULT NULL,
  `sm_yhshejiphday` datetime DEFAULT NULL,
  `sm_yhshejiywcday` datetime DEFAULT NULL,
  `select_mv` int(11) DEFAULT '0',
  `callselectmark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '电访备注',
  `ismvupload` int(11) DEFAULT '0' COMMENT '微电影上传状态',
  `mvuploadurl` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mvuploadtime` datetime DEFAULT NULL COMMENT '微电影上传日期',
  `mvuploadshop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mvuploadshop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `mvlasturl` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `isfileupload` int(11) DEFAULT '0' COMMENT '素材上传状态',
  `fileuploadurl` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fileuploadtime` datetime DEFAULT NULL COMMENT '素材上传日期',
  `fileshopcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '上传店',
  `fileshopname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `filelasturl` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `mvstate` int(11) DEFAULT '0',
  `originmvdelstate` int(11) DEFAULT '0',
  `mvdelstate` int(11) DEFAULT '0',
  `subfolder` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fabaodate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `mvdowntime` datetime DEFAULT NULL,
  `spshenpiandate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `spshenpianman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `oldspid` int(11) DEFAULT '0',
  `iswxspwctongzhi` int(11) DEFAULT '0',
  `iswxkbwctongzhi` int(11) DEFAULT '0',
  `kanxiupianday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kanxiupianstate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `wxkanbanday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `wxkanbanstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `wxkanbanstate` int(11) DEFAULT '5',
  `spcomputer` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `fabaojieshouday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fabaojieshoustaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fabaojieshoustate` int(11) DEFAULT '0',
  `fabaojieshouremark` text COLLATE utf8_unicode_ci,
  `todianday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kanxiaoguostaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `taobanpshu` int(11) DEFAULT '0',
  `taobanstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `xiajianday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '打印rfid日期',
  `xiajianstate` int(11) DEFAULT '0',
  `zhengjianstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zhengjiancount` int(11) DEFAULT '0',
  `zhengjianday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `pinkongman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `chupiandate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `smzjwancday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `smtbwancday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `smqjfcount` int(11) DEFAULT '0',
  `smdpsjcount` int(11) DEFAULT '0',
  `smtspcount` int(11) DEFAULT '0',
  `taoxitype` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yxselectweek` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sp_startdate` datetime DEFAULT NULL,
  `sp_enddate` datetime DEFAULT NULL,
  `sp_timecount` int(11) DEFAULT '0',
  `istruing` int(11) DEFAULT '0',
  `fadown` int(11) DEFAULT '0',
  `fadowntime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `faacup` int(11) DEFAULT '0',
  `faacuptime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `faup` int(11) DEFAULT '0',
  `fauptime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `smdown` int(11) DEFAULT '0',
  `smdowntime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `smup` int(11) DEFAULT '0',
  `smuptime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `facdownload` int(11) DEFAULT '0',
  `facdownloadtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `canuploadcloud` int(11) DEFAULT '0',
  `canuploadcloudtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `sp_orderId` (`orderId`),
  KEY `sp_customerid` (`customerid`),
  KEY `sp_shop_code` (`shop_code`),
  KEY `kanbanriqi` (`kanbanriqi`),
  KEY `in_selectday` (`selectday`),
  KEY `in_is_kanbanriqi` (`kanbanriqi`),
  KEY `currentfc` (`currentfc`),
  KEY `yxselectdaystart_yxselectdayend` (`yxselectdaystart`,`yxselectdayend`),
  KEY `sptstate` (`sptstate`),
  KEY `selectTime` (`selectTime`),
  KEY `islast` (`islast`),
  KEY `kanbanshijian` (`kanbanshijian`),
  KEY `kanbanstate` (`kanbanstate`),
  KEY `kanbanendday` (`kanbanendday`),
  KEY `mvstate` (`mvstate`),
  KEY `mvdelstate` (`mvdelstate`),
  KEY `mvdowntime` (`mvdowntime`),
  KEY `fabaodate` (`fabaodate`),
  KEY `fabaojieshouday` (`fabaojieshouday`),
  KEY `fabaojieshoustate` (`fabaojieshoustate`),
  KEY `kanxiaoguostaff` (`kanxiaoguostaff`),
  KEY `sm_meibianoverday` (`sm_meibianoverday`),
  KEY `sm_shejioverday` (`sm_shejioverday`),
  KEY `sm_jingxiuoverday` (`sm_jingxiuoverday`),
  KEY `sm_paibanoverday` (`sm_paibanoverday`),
  KEY `taobanstaff` (`taobanstaff`),
  KEY `select_recordtime` (`select_recordtime`),
  KEY `select_designtime` (`select_designtime`),
  KEY `select_design` (`select_design`),
  KEY `select_record` (`select_record`),
  KEY `xiajianday` (`xiajianday`),
  KEY `xiajianstate` (`xiajianstate`),
  KEY `zhengjianstaff` (`zhengjianstaff`),
  KEY `zhengjiancount` (`zhengjiancount`),
  KEY `zhengjianday` (`zhengjianday`),
  KEY `selectman` (`selectman`),
  KEY `kanxiupianday` (`kanxiupianday`),
  KEY `kanxiupianstate` (`kanxiupianstate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户选片订单表';



# Dump of table c_customerspgq
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerspgq`;

CREATE TABLE `c_customerspgq` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `currentfc` int(11) DEFAULT '0' COMMENT '服次信息',
  `selectday` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片日期',
  `selectTime` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片时间',
  `sptstate` tinyint(4) DEFAULT '2' COMMENT '选片状态  0未选完，1已选，2未选',
  `selectman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片师',
  `spremarks` text COLLATE utf8_unicode_ci COMMENT '选片备注',
  `spcount` int(11) DEFAULT '0' COMMENT '选片张数',
  `spbook_photocount` int(11) DEFAULT '0' COMMENT '入册张数',
  `spImport_photocount` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `spnoticestate` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片通知状态  0未通知，1已通知',
  `spnoticedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片通知日期',
  `spnoticeman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片通知人员',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片店面编码',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `select_record` int(11) DEFAULT '0' COMMENT '导原片标记',
  `select_recordtime` datetime DEFAULT NULL COMMENT '导原片时间',
  `islast` int(11) DEFAULT '0' COMMENT '最后标记',
  `sptend_day` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '选片完成日',
  `select_design` int(11) DEFAULT '0' COMMENT '导设计标记',
  `select_designtime` datetime DEFAULT NULL COMMENT '导设计时间',
  `upday` datetime DEFAULT NULL,
  `upstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `select_truing` int(11) DEFAULT '0' COMMENT '导精修',
  `select_truingtime` datetime DEFAULT NULL,
  `islock` int(11) DEFAULT '0',
  `kanbanriqi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版日期',
  `kanbanshijian` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版时间',
  `kanbanshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版师',
  `kanbanstate` int(11) DEFAULT '5' COMMENT '看版状态',
  `kanbanendday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '看版日期',
  `ypremark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `jxremark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `sjremark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `ypwarn` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `jxwarn` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `sjwarn` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `ystatus` int(11) DEFAULT '0',
  `ypxzstatus` int(11) DEFAULT '0',
  `fbxzstatus` int(11) DEFAULT '0',
  `spscstatus` int(11) DEFAULT '0',
  `scscstatus` int(11) DEFAULT '0',
  `scxzstatus` int(11) DEFAULT '0',
  `sjscstatus` int(11) DEFAULT '0',
  `paikongstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `kanbanpaikongstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `kanbanpaikongtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `sptodian` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `kbtodian` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sm_tiaosecount` int(11) DEFAULT '0' COMMENT '调色数',
  `sm_meibiancount` int(11) DEFAULT '0' COMMENT '美编数',
  `sm_shejicount` int(11) DEFAULT '0' COMMENT '设计数',
  `sm_jingxiucount` int(11) DEFAULT '0' COMMENT '精修数',
  `sm_paibancount` int(11) DEFAULT '0' COMMENT '排版数',
  `yqtiaoseman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样前调色',
  `americaneditorman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样前美编师',
  `designerman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样后设计师',
  `yhjxman` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '样后精修师',
  `artistman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '相册排版',
  `sm_tiaoseoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '调色完成日',
  `sm_meibianoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '美编完成日',
  `sm_shejioverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '设计完成日',
  `sm_jingxiuoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '精修完成日',
  `sm_paibanoverday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '排版完成日',
  `yxselectdaystart` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `yxselectdayend` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `callselectmark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `gqremark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `qgman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qgtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `gqtype` varchar(4) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '改期类型',
  PRIMARY KEY (`id`),
  KEY `orderId_customerid_currentfc_selectday_sptstate_selectman` (`orderId`,`customerid`,`currentfc`,`selectday`,`sptstate`,`selectman`),
  KEY `shop_code` (`shop_code`),
  KEY `islast` (`islast`),
  KEY `shop_name` (`shop_name`),
  KEY `qgtime` (`qgtime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户选片订单表';



# Dump of table c_customerteltracking
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customerteltracking`;

CREATE TABLE `c_customerteltracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `teyday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nexttelcalltime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yxphotoday1` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yxphotoday2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telcallremark` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  `telstaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telguid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `starttime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `endtime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telway` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `customerid` (`customerid`),
  KEY `teyday` (`teyday`),
  KEY `telphone` (`telphone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='电访催拍追踪记录';



# Dump of table c_foundryitemstable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_foundryitemstable`;

CREATE TABLE `c_foundryitemstable` (
  `fmid` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) DEFAULT NULL COMMENT '维修件ID',
  `senddate` datetime DEFAULT NULL COMMENT '送件日期',
  `backdate` datetime DEFAULT NULL COMMENT '回件日期',
  `shouldbackdate` datetime DEFAULT NULL COMMENT '应回件日期',
  `itemname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品名称',
  `manuname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商名称',
  `sendremark` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '送件备注',
  `sendcount` int(11) DEFAULT NULL COMMENT '送件数量',
  `p` int(11) DEFAULT NULL COMMENT 'P数',
  `addp` int(11) DEFAULT NULL COMMENT '增P',
  `fitemname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ForderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `reject` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '退件',
  `dutier` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sendman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `backman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tmprinttime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `meigongzhizuo` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `meigongdate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`fmid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_foundryprojecttable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_foundryprojecttable`;

CREATE TABLE `c_foundryprojecttable` (
  `fdid` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `itemnum` int(11) DEFAULT NULL COMMENT '消费项目主键',
  `itemname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `itemsize` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '规格',
  `mfsid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工厂商编号',
  `manufacturersname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工厂商名称',
  `projectnum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工产品编号',
  `projectsname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工产品名称',
  `projectcount` int(11) DEFAULT NULL COMMENT '送件数量',
  `projectprice` decimal(10,2) DEFAULT '0.00' COMMENT '单价',
  `subtotal` decimal(10,2) DEFAULT '0.00' COMMENT '总价',
  `referreddate` datetime DEFAULT NULL COMMENT '送件日期',
  `shouldreturndate` datetime DEFAULT NULL COMMENT '应回件日',
  `returndate` datetime DEFAULT NULL COMMENT '回件日',
  `Remark` text COLLATE utf8_unicode_ci COMMENT '备注',
  `Reject` int(4) unsigned DEFAULT '0' COMMENT '0正常，1退件',
  `urgencyflag` int(4) DEFAULT '0' COMMENT '0正常，1急件',
  `dz_pcout` int(11) DEFAULT '0' COMMENT '厂商对账P数',
  `isdz` int(11) DEFAULT '0' COMMENT '是否已对账',
  `dz_subtotal` decimal(10,2) DEFAULT '0.00' COMMENT '厂商对账总价',
  `shopcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商代码',
  `sorting` int(11) DEFAULT NULL COMMENT '项',
  `pcout` int(11) DEFAULT '0' COMMENT 'P数',
  `addp` int(11) DEFAULT '0' COMMENT '增P',
  `sendman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '送件人',
  `sendtime` datetime DEFAULT NULL COMMENT '送件时间',
  `backman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回件人',
  `backtime` datetime DEFAULT NULL COMMENT '回件时间',
  `dutier` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人',
  `location` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地点',
  `tranphoto` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '传输图片',
  `prosize` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '输出面积',
  `proprice` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '输出价格',
  `flowwater` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fc` int(11) DEFAULT '1',
  `tmprinttime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `duizhangdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `meigongzhizuo` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `meigongdate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`fdid`),
  KEY `cfdpj_orderId` (`orderId`),
  KEY `cfdpj_customerid` (`customerid`),
  KEY `cfdpj_shop_code` (`shop_code`),
  KEY `itemnum` (`itemnum`),
  KEY `referreddate` (`referreddate`),
  KEY `shouldreturndate` (`shouldreturndate`),
  KEY `returndate` (`returndate`),
  KEY `sendtime` (`sendtime`),
  KEY `manufacturersname` (`manufacturersname`),
  KEY `projectsname` (`projectsname`),
  KEY `sorting` (`sorting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='代工送件表';



# Dump of table c_ftpupdownrecord
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_ftpupdownrecord`;

CREATE TABLE `c_ftpupdownrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ymname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '页面功能',
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单编号',
  `fc` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '服次',
  `usename` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `status` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '状态',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Instructions` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '说明',
  `photoname` varchar(5000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '照片',
  `xpid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL COMMENT '时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='FTP工具上传下载记录';



# Dump of table c_functiontable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_functiontable`;

CREATE TABLE `c_functiontable` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `gangwei_code` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位编号',
  `gangwei_name` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom1` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom2` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom3` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom4` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom5` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom6` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom7` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom8` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom9` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom10` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom11` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom12` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom13` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom14` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom15` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom16` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom17` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom18` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom19` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `popedom20` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='ERP权限管控表';



# Dump of table c_functiontablesys
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_functiontablesys`;

CREATE TABLE `c_functiontablesys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `systype` int(11) DEFAULT NULL,
  `aorb` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_guestinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_guestinfo`;

CREATE TABLE `c_guestinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户性别',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户手机',
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微信',
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微博',
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'QQ',
  `province_id` int(11) DEFAULT NULL COMMENT '省id',
  `province` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在省',
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在市',
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '县（区）',
  `customer_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地址',
  `mate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶姓名',
  `mate_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶性别',
  `mate_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶电话',
  `mate_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微信',
  `mate_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微博',
  `mate_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_cource` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_orderaddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `customer_area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `is_fp` tinyint(4) DEFAULT '2' COMMENT '是否分配，1已分配，2未分配，默认为2',
  `is_intostore` tinyint(4) DEFAULT '2' COMMENT '是否进店，1为是 2为否,默认为2',
  `is_success` tinyint(4) DEFAULT '2' COMMENT '是否成交，1 是，2 否，默认为2',
  `is_valid` tinyint(4) DEFAULT '1' COMMENT '是否有效，1 是，2否，默认为1',
  `is_loss` tinyint(4) DEFAULT '2' COMMENT '是否流失，1是，2否，默认为2',
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资标记',
  `op_signday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记日期',
  `customer_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户生日',
  `mate_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶生日',
  `wedding_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工',
  `fp_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员',
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员',
  `dj_day` datetime DEFAULT NULL COMMENT '登记日期',
  `fp_day` datetime DEFAULT NULL COMMENT '分配日期',
  `yjd_day` datetime DEFAULT NULL COMMENT '预约进店日期',
  `syjd_day` datetime DEFAULT NULL COMMENT '实际进店日期',
  `yp_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '预拍日期',
  `order_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '成交订单日期',
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单单号',
  `last_trackday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '最后一次追踪日期',
  `creator_day` datetime DEFAULT NULL COMMENT '创建日期',
  `customer_remark` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `statusremark` text COLLATE utf8_unicode_ci COMMENT '状态备注',
  `shop_codeZD` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_nameZD` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_from` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资系统来源（ERP、CRM）',
  `from_index` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资系统来源编号',
  `brandid` int(11) DEFAULT '0' COMMENT '事业部ID',
  `bbname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '宝宝姓名',
  `bbithdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '宝宝生日',
  `bbsex` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '宝宝性别',
  `yc_day` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预产日期',
  `bb_hospital` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '医院名称',
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='进客资料表';



# Dump of table c_introducetable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_introducetable`;

CREATE TABLE `c_introducetable` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `customerid` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人编号',
  `mname` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士姓名',
  `mphone` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士手机',
  `mwechat` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士微信',
  `mqq` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士QQ',
  `wname` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士姓名',
  `wphone` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士手机',
  `wwechat` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士微信',
  `wqq` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女QQ',
  `address` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地址',
  `introtype` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍类型',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='介绍人关系表';



# Dump of table c_jieshaorelation
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_jieshaorelation`;

CREATE TABLE `c_jieshaorelation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intorid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `intorid` (`intorid`),
  KEY `shop_code` (`shop_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='介绍人关系表';



# Dump of table c_jobscore
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_jobscore`;

CREATE TABLE `c_jobscore` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `yj_paytype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '付款类型',
  `yj_payclass` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '付款分类（0： 门市，1：礼服，2：化妆,3 VIP卡充值）',
  `yj_paymentdate` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '付款日期',
  `yj_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '业绩金额',
  `yj_cashierman` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收银员',
  `yj_fundname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '款项名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `yj_create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `yj_pyid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '收款id',
  `staffname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '业绩人',
  `department_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '部门',
  `yj_paymenttime` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '收款时间',
  `yj_mendian` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '业绩门店',
  `yj_mendiancode` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `position_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `customerid` (`customerid`),
  KEY `orderId` (`orderId`),
  KEY `shop_code` (`shop_code`),
  KEY `yj_paytype` (`yj_paytype`),
  KEY `yj_payclass` (`yj_payclass`),
  KEY `yj_paymentdate` (`yj_paymentdate`),
  KEY `staffname` (`staffname`),
  KEY `department_name` (`department_name`),
  KEY `position_name` (`position_name`),
  KEY `yj_fundname` (`yj_fundname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='收款业绩表';



# Dump of table c_kz_fenpeiinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_kz_fenpeiinfo`;

CREATE TABLE `c_kz_fenpeiinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fenpeiday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wxstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `groupname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fpstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `customerid` (`customerid`),
  KEY `fenpeiday` (`fenpeiday`),
  KEY `wxstaff` (`wxstaff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资分配记录';



# Dump of table c_kz_paichengdayset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_kz_paichengdayset`;

CREATE TABLE `c_kz_paichengdayset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctype` int(11) DEFAULT NULL COMMENT '排程类型：0拍照，1选片',
  `pcday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '排控日期',
  `pctime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时间点',
  `pcarea` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `ispc` int(11) DEFAULT '0' COMMENT '是否确认排档',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '排档订单',
  `iszd` int(11) DEFAULT '0' COMMENT '是否占档',
  `zdtime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '占档时间',
  `islock` int(11) DEFAULT '0' COMMENT '是否锁档',
  PRIMARY KEY (`id`),
  KEY `pctype` (`pctype`),
  KEY `pcday` (`pcday`),
  KEY `shop_code` (`shop_code`),
  KEY `ispc` (`ispc`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_kz_paichengtimeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_kz_paichengtimeset`;

CREATE TABLE `c_kz_paichengtimeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pcarea` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pccount` int(11) DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pctime` (`pctime`),
  KEY `pcarea` (`pcarea`),
  KEY `shop_code` (`shop_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_maintenanceitems
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_maintenanceitems`;

CREATE TABLE `c_maintenanceitems` (
  `miid` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客户编号',
  `itemname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '产品名',
  `amount` int(11) DEFAULT '0' COMMENT '数量',
  `receivedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '收件日期',
  `takeawaydate` varchar(10) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '取件日期',
  `create_time` datetime DEFAULT NULL COMMENT '操作日期',
  `remark` text COLLATE utf8_unicode_ci COMMENT '备注',
  `whethercantake` tinyint(4) DEFAULT '0' COMMENT '整件完成状态',
  `whetheralreadytake` tinyint(4) DEFAULT '0' COMMENT '取件完成状态',
  `zperson` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '收件人',
  `takeawaytime` varchar(10) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '取件时间',
  `wxid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '维修编号',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '维修价格',
  `responsible` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_staymark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_staymarkday` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_staymarkbz` text COLLATE utf8_unicode_ci,
  `chengben` decimal(10,2) DEFAULT '0.00' COMMENT '成本',
  `receivemoneystate` int(11) DEFAULT '0' COMMENT '已收款',
  `wxtakeawaystate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '通知状态',
  `tofendian` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `tracknumber` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '快递单号',
  `shouyin` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `rfidno` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `outfacdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `outfaclist` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `take_takaddress` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `dayinrfidday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `whethercantakedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `whethercantakeman` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `tofendiandate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `wxckssubtypes` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_receiveday` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_receivetime` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_receiveren` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_sendsjday` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_sendsjtime` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_sendsjren` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `wxsheji` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `wxsjoverday` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `wxsjovertime` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `wxsjoverren` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_receivesjday` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_receivesjtime` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_receivesjren` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_sendgcday` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_sendgctime` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `dd_sendgcren` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `tracknumbergc` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fangongtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`miid`),
  KEY `orderId` (`orderId`),
  KEY `customerid` (`customerid`),
  KEY `itemname` (`itemname`),
  KEY `receivedate` (`receivedate`),
  KEY `takeawaydate` (`takeawaydate`),
  KEY `whethercantake` (`whethercantake`),
  KEY `whetheralreadytake` (`whetheralreadytake`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='维修项目表';



# Dump of table c_mvphotolist
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_mvphotolist`;

CREATE TABLE `c_mvphotolist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uptype` int(11) DEFAULT '0',
  `PhotoNum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currentfc` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  `filehashSha` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `uptype` (`uptype`),
  KEY `createtime` (`createtime`),
  KEY `filehashSha` (`filehashSha`),
  KEY `shop_code` (`shop_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_order_pingjia
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_order_pingjia`;

CREATE TABLE `c_order_pingjia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `AsName` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `Subject` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `PJType` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `DFDate` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `DFRen` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `PingjiaNum` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `PingjiaConentts` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `Remark` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `ShenHeRen` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `PJDepart` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `PJPerson` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `pid` int(11) DEFAULT '0',
  `spid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `AsName` (`AsName`),
  KEY `Subject` (`Subject`),
  KEY `PJType` (`PJType`),
  KEY `DFDate` (`DFDate`),
  KEY `PingjiaNum` (`PingjiaNum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户评价记录表';



# Dump of table c_paymentcontent
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_paymentcontent`;

CREATE TABLE `c_paymentcontent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `payclass` int(11) DEFAULT NULL COMMENT '付款分类（0： 门市，3 VIP卡充值，4商品）',
  `paytype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '付款类型（现金、刷卡、微信、支付宝）',
  `paymentdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '付款日期',
  `paymenttime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '付款时间',
  `payment_money` decimal(10,2) DEFAULT '0.00' COMMENT '付款金额',
  `cashierman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '收银员',
  `fundname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '款项名称',
  `collectmoneynumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '收款流水号',
  `vipcardid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'VIP卡号',
  `viptype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'VIP卡类型',
  `ourselfresource` decimal(10,0) DEFAULT '0' COMMENT '消费积分',
  `othersource` decimal(10,0) DEFAULT NULL COMMENT '介绍人积分',
  `acceptor_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '收款接单点',
  `remarks` text COLLATE utf8_unicode_ci COMMENT '收银备注',
  `isaudit` tinyint(4) DEFAULT NULL COMMENT '核账',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `create_time` datetime DEFAULT NULL COMMENT '数据创建时间',
  `isshow` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '发票号',
  `vipuser_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员付款码ID',
  `wechat_payment` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信支付信息',
  `wechat_payment_mcid` int(11) DEFAULT '0' COMMENT '微信支付信息mcid',
  `viprechargemoney` decimal(10,2) DEFAULT '0.00' COMMENT '会员充入金额',
  `viprechargecard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员充入卡号',
  `suoshu` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '款项所属',
  `oldtype` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `oldpcid` int(11) DEFAULT '0',
  `paymentcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shoukuantype` int(11) DEFAULT '0',
  `paycodenumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `isfenci` int(11) DEFAULT '0',
  `ordernumber` int(11) DEFAULT '0',
  `psn` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `swimmingcs` int(11) DEFAULT '0',
  `viprechargemoneynew` decimal(10,2) DEFAULT '0.00',
  `viprechargecardnew` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isshishou` varchar(3) COLLATE utf8_unicode_ci DEFAULT '',
  `currentfc` int(11) DEFAULT '0' COMMENT '服务次',
  `vipxnmoney` decimal(10,2) DEFAULT '0.00' COMMENT 'VIP虚拟金额',
  `tuikuanzrr` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '退款责任人',
  `yejimv` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `printstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `printdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `zsitemid` int(11) DEFAULT '0' COMMENT '赠送产品ID',
  `hezhangstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hezhangday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hdxnmoney` decimal(10,2) DEFAULT '0.00',
  `hdjianmianmoney` decimal(10,2) DEFAULT '0.00',
  `hdzhekou` decimal(10,2) DEFAULT '0.00',
  `jmpayid` int(11) DEFAULT '0',
  `zkconid` int(11) DEFAULT '0',
  `currentfcerxiaoshixiaomoney` decimal(10,2) DEFAULT '0.00',
  `paymoneyjifen` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `pay_orderId` (`orderId`),
  KEY `pay_customerid` (`customerid`),
  KEY `pay_shop_code` (`shop_code`),
  KEY `viprechargecard` (`viprechargecard`,`viprechargemoney`,`viprechargemoneynew`,`viprechargecardnew`),
  KEY `collectmoneynumber` (`collectmoneynumber`),
  KEY `oldtype` (`oldtype`),
  KEY `swimmingcs` (`swimmingcs`),
  KEY `zsitemid` (`zsitemid`),
  KEY `hezhangday` (`hezhangday`),
  KEY `hezhangstaff` (`hezhangstaff`),
  KEY `shoukuantype` (`shoukuantype`),
  KEY `currentfc` (`currentfc`),
  KEY `suoshu` (`suoshu`),
  KEY `payclass` (`payclass`),
  KEY `paytype` (`paytype`),
  KEY `paymentdate` (`paymentdate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='收款表';



# Dump of table c_paymenttype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_paymenttype`;

CREATE TABLE `c_paymenttype` (
  `id` int(11) NOT NULL,
  `typecode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '是否为实收',
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `publicaccout` tinyint(1) DEFAULT '0',
  `iscanuse` int(11) DEFAULT '0',
  `isneedfkm` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `typename` (`typename`),
  KEY `typecode` (`typecode`),
  KEY `shop_code` (`shop_code`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `c_paymenttype` WRITE;
/*!40000 ALTER TABLE `c_paymenttype` DISABLE KEYS */;

INSERT INTO `c_paymenttype` (`id`, `typecode`, `typename`, `shop_code`, `publicaccout`, `iscanuse`, `isneedfkm`)
VALUES
	(1,'实收','现金',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(2,'实收','收钱吧刷卡',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(3,'虚拟','VIP卡',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(4,'实收','微信',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(5,'实收','支付宝',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(6,'虚拟','大众刷卡',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(7,'实收','收钱吧二维码',',MK01,MK02,MK03,MK04,MK05,',0,0,0),
	(8,'实收','大众二维码',',MK01,MK02,MK03,MK04,',0,0,0),
	(9,'实收','退款减免',',MK01,MK02,MK03,MK04,',0,0,0),
	(10,'实收','大众闪惠',',MK01,MK02,MK03,MK04,',0,0,0),
	(11,'实收','银行转账',',MK01,MK02,MK03,MK04,',0,0,0),
	(12,'实收','淘宝支付',',MK01,MK02,MK03,MK04,',0,0,0),
	(13,'实收','企业微信',',MK01,MK02,MK03,MK04,',0,0,0),
	(14,'实收','星管家',',MK01,MK02,MK03,MK04,',0,0,0);

/*!40000 ALTER TABLE `c_paymenttype` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table c_sellcontent
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_sellcontent`;

CREATE TABLE `c_sellcontent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `itemname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `count` int(10) unsigned DEFAULT '0',
  `item_pagecount` int(10) unsigned DEFAULT '0',
  `money` decimal(10,2) DEFAULT '0.00',
  `total` decimal(10,2) DEFAULT '0.00',
  `paeeman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost` decimal(10,2) DEFAULT '0.00',
  `yuanjia` decimal(10,2) DEFAULT '0.00',
  `getdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `remark` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '数据创建时间',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  PRIMARY KEY (`id`),
  KEY `itemname` (`itemname`),
  KEY `orderId` (`orderId`),
  KEY `shop_code` (`shop_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='商品销售';



# Dump of table c_staff_group
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_staff_group`;

CREATE TABLE `c_staff_group` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属部门',
  `create_staff_id` int(11) DEFAULT NULL COMMENT '创建人id',
  `create_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL,
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `admin` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_staff_group_relation
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_staff_group_relation`;

CREATE TABLE `c_staff_group_relation` (
  `group_id` int(11) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(11) unsigned DEFAULT '0' COMMENT '人员',
  `is_admin` tinyint(1) DEFAULT '0' COMMENT '是否管理员：1：是；0：不是',
  `staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='小组关系表';



# Dump of table c_staff_rowrest
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_staff_rowrest`;

CREATE TABLE `c_staff_rowrest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工姓名',
  `pc_month` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day1` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day3` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day4` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day5` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day6` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day7` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day8` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day9` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day10` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day11` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day12` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day13` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day14` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day15` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day16` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day17` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day18` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day19` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day20` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day21` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day22` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day23` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day24` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day25` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day26` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day27` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day28` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day29` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day30` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day31` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pc_year` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='员工排班';



# Dump of table c_staffinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_staffinfo`;

CREATE TABLE `c_staffinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `popedom1` text COLLATE utf8_unicode_ci,
  `popedom2` text COLLATE utf8_unicode_ci,
  `popedom3` text COLLATE utf8_unicode_ci,
  `popedom4` text COLLATE utf8_unicode_ci,
  `popedom5` text COLLATE utf8_unicode_ci,
  `popedom6` text COLLATE utf8_unicode_ci,
  `popedom7` text COLLATE utf8_unicode_ci,
  `popedom8` text COLLATE utf8_unicode_ci,
  `popedom9` text COLLATE utf8_unicode_ci,
  `popedom10` text COLLATE utf8_unicode_ci,
  `popedom11` text COLLATE utf8_unicode_ci,
  `popedom12` text COLLATE utf8_unicode_ci,
  `popedom13` text COLLATE utf8_unicode_ci,
  `popedom14` text COLLATE utf8_unicode_ci,
  `popedom15` text COLLATE utf8_unicode_ci,
  `popedom16` text COLLATE utf8_unicode_ci,
  `popedom17` text COLLATE utf8_unicode_ci,
  `popedom18` text COLLATE utf8_unicode_ci,
  `popedom19` text COLLATE utf8_unicode_ci,
  `popedom20` text COLLATE utf8_unicode_ci,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工姓名',
  `department_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面编码',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗标识',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗名称',
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '电话号',
  `QQ` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_level_id` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_level` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `working_status` varchar(10) COLLATE utf8_unicode_ci DEFAULT '1',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `work_shop` text COLLATE utf8_unicode_ci,
  `is_stand_auth` int(11) DEFAULT '0' COMMENT '是否修改过权限；1是，0否',
  `entry_date` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `birthday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `groupid` int(11) DEFAULT '0',
  `groupname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isheadman` int(11) DEFAULT '0',
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `usercode` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `staffnumber_staffname_shop_code` (`staffnumber`,`staffname`,`shop_code`),
  KEY `work_types` (`work_types`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_trackingrecord
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_trackingrecord`;

CREATE TABLE `c_trackingrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intentionpagename` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `op_signday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_valid` int(11) DEFAULT '1' COMMENT '是否有效，1 是，0否，默认为0',
  `telremarks` text COLLATE utf8_unicode_ci,
  `wxstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户所属店面码',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户所属店面',
  `trackingday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `customerid` (`customerid`),
  KEY `telphone` (`telphone`),
  KEY `wxstaff` (`wxstaff`),
  KEY `op_signday` (`op_signday`),
  KEY `shop_code` (`shop_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='追踪记录';



# Dump of table c_urgentnoticeinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_urgentnoticeinfo`;

CREATE TABLE `c_urgentnoticeinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tzday` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `opstaff` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `opshop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tzstaffinfo` text COLLATE utf8_unicode_ci,
  `tzurgentnoticeinfo` text COLLATE utf8_unicode_ci,
  `createtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `typeinfo` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `tzhhss` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `tzstate` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tzday` (`tzday`),
  KEY `tzhhss` (`tzhhss`),
  KEY `typeinfo` (`typeinfo`),
  KEY `opstaff` (`opstaff`),
  KEY `tzstate` (`tzstate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='紧急通知';



# Dump of table c_vipcardgiveitems
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_vipcardgiveitems`;

CREATE TABLE `c_vipcardgiveitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cardid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cardtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zptype` int(11) DEFAULT '0' COMMENT '1办卡赠，2充值赠送',
  `itemtype` int(11) DEFAULT '0' COMMENT '1产品，2包套',
  `giveiteminfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `iststate` int(11) DEFAULT '0' COMMENT '使用状态0未使用，1已使用',
  `usetime` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '使用日期',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `useorderid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用单号',
  `paycodenumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cardid` (`cardid`),
  KEY `useorderid` (`useorderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员卡内赠送可使用的产品';



# Dump of table c_vipcardinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_vipcardinfo`;

CREATE TABLE `c_vipcardinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cardid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cardtype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cardtime` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `givetime` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cardpwd` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cardmoney` decimal(10,2) NOT NULL DEFAULT '0.00',
  `start_validity` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `end_validity` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `percents` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `cardstate` int(11) NOT NULL DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `ismothercard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mothercard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `PaySource` decimal(10,2) DEFAULT NULL,
  `IntroSource` decimal(10,2) DEFAULT NULL,
  `PlusSource` decimal(10,2) DEFAULT NULL,
  `PayIntro` decimal(10,2) DEFAULT NULL,
  `forcardstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `isLast` int(11) DEFAULT '0',
  `cznopaymoney` decimal(10,2) DEFAULT '0.00',
  `swimmingcs` int(11) DEFAULT '0' COMMENT '游泳次数',
  `yycr` int(11) DEFAULT '0' COMMENT '冲入次数',
  `yysc` int(11) DEFAULT '0' COMMENT '游泳次数',
  `xnmoney` decimal(10,2) DEFAULT '0.00' COMMENT '充值赠送虚拟金额',
  `vipsel` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`,`cardid`),
  UNIQUE KEY `cardid` (`cardid`),
  KEY `cardtype` (`cardtype`),
  KEY `cardtime` (`cardtime`),
  KEY `givetime` (`givetime`),
  KEY `cardmoney` (`cardmoney`,`swimmingcs`,`yycr`,`yysc`,`xnmoney`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员卡表';



# Dump of table c_vipcardswimming
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_vipcardswimming`;

CREATE TABLE `c_vipcardswimming` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cardid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '操作类型：购买游泳次，游泳刷卡',
  `swimmingcs` int(11) DEFAULT '0',
  `opman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `yyremark` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `serviceman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `orderidczr` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `collectnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `ss` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cardid` (`cardid`,`swimmingcs`),
  KEY `typename` (`typename`),
  KEY `opdate` (`opdate`),
  KEY `shop_code` (`shop_code`),
  KEY `orderidczr` (`orderidczr`),
  KEY `opman` (`opman`),
  KEY `serviceman` (`serviceman`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_viprecharge_arrears
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_viprecharge_arrears`;

CREATE TABLE `c_viprecharge_arrears` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cztype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paymentdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cashierman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `czstate` int(11) DEFAULT '0',
  `fundname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `viprechargemoney` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `viprechargecard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paycodenumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payid` int(11) DEFAULT NULL,
  `suoshu` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '款项所属',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '数据创建时间',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`),
  KEY `paymentdate` (`paymentdate`),
  KEY `shop_code` (`shop_code`),
  KEY `payid` (`payid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='充值欠款';



# Dump of table c_vipsourcetable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_vipsourcetable`;

CREATE TABLE `c_vipsourcetable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cardid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '会员卡号',
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `stype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '积分类型',
  `sname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '积分项目',
  `resource` decimal(10,1) DEFAULT '0.0' COMMENT '积分值',
  `money` decimal(10,1) DEFAULT '0.0' COMMENT '消费值',
  `remark` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '备注',
  `opdate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '积分日期',
  `opname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店编号',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售店面',
  `payid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orderId` (`orderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员积分记录表';



# Dump of table c_vipupdatetable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_vipupdatetable`;

CREATE TABLE `c_vipupdatetable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cardid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '卡号',
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '订单号',
  `oldtype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '原类型',
  `newtype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '新类型',
  `remark` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `opdate` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作日期',
  `opname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员卡升级';



# Dump of table c_yqorderlist
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_yqorderlist`;

CREATE TABLE `c_yqorderlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bbname` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bbsex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imagename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `producttype` int(11) DEFAULT NULL,
  `productID` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `productname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` datetime DEFAULT CURRENT_TIMESTAMP,
  `productstate` int(11) DEFAULT '0',
  `videolink` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `opman` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opshop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opshop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `qorderId` int(11) DEFAULT '0',
  `bbpinyin` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `bbenname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `currentfc` int(11) DEFAULT '0',
  `heardir` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `productsmallpic` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `productIndexcovert` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `videourl` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `zhengdanxiadan` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `sphid` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_zhuguanmessage
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_zhuguanmessage`;

CREATE TABLE `c_zhuguanmessage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gangweiname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `jilihuashu` varchar(3000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `gangweivalues` int(11) NOT NULL DEFAULT '0',
  `paimingci` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zhidinghao` varchar(1000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table city
# ------------------------------------------------------------

DROP TABLE IF EXISTS `city`;

CREATE TABLE `city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ProvinceId` int(11) NOT NULL DEFAULT '0',
  `Name` varchar(100) COLLATE ucs2_unicode_ci NOT NULL DEFAULT '0',
  `AreaCode` varchar(100) COLLATE ucs2_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci;

LOCK TABLES `city` WRITE;
/*!40000 ALTER TABLE `city` DISABLE KEYS */;

INSERT INTO `city` (`id`, `ProvinceId`, `Name`, `AreaCode`)
VALUES
	(1,1,'北京市','010'),
	(2,2,'天津市','022'),
	(3,3,'石家庄市','0311'),
	(4,3,'唐山市','0315'),
	(5,3,'秦皇岛市','0335'),
	(6,3,'邯郸市','0310'),
	(7,3,'邢台市','0319'),
	(8,3,'保定市','0312'),
	(9,3,'张家口市','0313'),
	(10,3,'承德市','0314'),
	(11,3,'沧州市','0317'),
	(12,3,'廊坊市','0316'),
	(13,3,'衡水市','0318'),
	(14,4,'太原市','0351'),
	(15,4,'大同市','0352'),
	(16,4,'阳泉市','0353'),
	(17,4,'长治市','0355'),
	(18,4,'晋城市','0356'),
	(19,4,'朔州市','0349'),
	(20,4,'晋中市','0354'),
	(21,4,'运城市','0359'),
	(22,4,'忻州市','0350'),
	(23,4,'临汾市','0357'),
	(24,4,'吕梁市','0358'),
	(25,5,'呼和浩特市','0471'),
	(26,5,'包头市','0472'),
	(27,5,'乌海市','0473'),
	(28,5,'赤峰市','0476'),
	(29,5,'通辽市','0475'),
	(30,5,'鄂尔多斯市','0477'),
	(31,5,'呼伦贝尔市','0470'),
	(32,5,'巴彦淖尔市','0478'),
	(33,5,'乌兰察布市','0474'),
	(34,5,'兴安盟','0482'),
	(35,5,'锡林郭勒盟','0479'),
	(36,5,'阿拉善盟','0483'),
	(37,6,'沈阳市','024'),
	(38,6,'大连市','0411'),
	(39,6,'鞍山市','0412'),
	(40,6,'抚顺市','0413'),
	(41,6,'本溪市','0414'),
	(42,6,'丹东市','0415'),
	(43,6,'锦州市','0416'),
	(44,6,'营口市','0417'),
	(45,6,'阜新市','0418'),
	(46,6,'辽阳市','0419'),
	(47,6,'盘锦市','0427'),
	(48,6,'铁岭市','0410'),
	(49,6,'朝阳市','0421'),
	(50,6,'葫芦岛市','0429'),
	(51,7,'长春市','0431'),
	(52,7,'吉林市','0432'),
	(53,7,'四平市','0434'),
	(54,7,'辽源市','0437'),
	(55,7,'通化市','0435'),
	(56,7,'白山市','0439'),
	(57,7,'松原市','0438'),
	(58,7,'白城市','0436'),
	(59,7,'延边朝鲜族自治州','0433'),
	(60,8,'哈尔滨市','0451'),
	(61,8,'齐齐哈尔市','0452'),
	(62,8,'鸡西市','0467'),
	(63,8,'鹤岗市','0454'),
	(64,8,'双鸭山市','0454'),
	(65,8,'大庆市','0459'),
	(66,8,'伊春市','0458'),
	(67,8,'佳木斯市','0454'),
	(68,8,'七台河市','0464'),
	(69,8,'牡丹江市','0453'),
	(70,8,'黑河市','0456'),
	(71,8,'绥化市','0455'),
	(72,8,'大兴安岭地区','0457'),
	(73,9,'上海市','021'),
	(74,10,'南京市','025'),
	(75,10,'无锡市','0510'),
	(76,10,'徐州市','0516'),
	(77,10,'常州市','0519'),
	(78,10,'苏州市','0512'),
	(79,10,'南通市','0513'),
	(80,10,'连云港市','0518'),
	(81,10,'淮安市','0517'),
	(82,10,'盐城市','0515'),
	(83,10,'扬州市','0514'),
	(84,10,'镇江市','0511'),
	(85,10,'泰州市','0523'),
	(86,10,'宿迁市','0527'),
	(87,11,'杭州市','0571'),
	(88,11,'宁波市','0574'),
	(89,11,'温州市','0577'),
	(90,11,'嘉兴市','0573'),
	(91,11,'湖州市','0572'),
	(92,11,'绍兴市','0575'),
	(93,11,'金华市','0579'),
	(94,11,'衢州市','0570'),
	(95,11,'舟山市','0580'),
	(96,11,'台州市','0576'),
	(97,11,'丽水市','0578'),
	(98,12,'合肥市','0551'),
	(99,12,'芜湖市','0553'),
	(100,12,'蚌埠市','0552'),
	(101,12,'淮南市','0554'),
	(102,12,'马鞍山市','0555'),
	(103,12,'淮北市','0561'),
	(104,12,'铜陵市','0562'),
	(105,12,'安庆市','0556'),
	(106,12,'黄山市','0559'),
	(107,12,'滁州市','0550'),
	(108,12,'阜阳市','0558'),
	(109,12,'宿州市','0557'),
	(110,12,'巢湖市','0565'),
	(111,12,'六安市','0564'),
	(112,12,'亳州市','0558'),
	(113,12,'池州市','0566'),
	(114,12,'宣城市','0563'),
	(115,13,'福州市','0591'),
	(116,13,'厦门市','0592'),
	(117,13,'莆田市','0594'),
	(118,13,'三明市','0598'),
	(119,13,'泉州市','0595'),
	(120,13,'漳州市','0596'),
	(121,13,'南平市','0599'),
	(122,13,'龙岩市','0597'),
	(123,13,'宁德市','0593'),
	(124,14,'南昌市','0791'),
	(125,14,'景德镇市','0798'),
	(126,14,'萍乡市','0799'),
	(127,14,'九江市','0792'),
	(128,14,'新余市','0790'),
	(129,14,'鹰潭市','0701'),
	(130,14,'赣州市','0797'),
	(131,14,'吉安市','0796'),
	(132,14,'宜春市','0795'),
	(133,14,'抚州市','0794'),
	(134,14,'上饶市','0793'),
	(135,15,'济南市','0531'),
	(136,15,'青岛市','0532'),
	(137,15,'淄博市','0533'),
	(138,15,'枣庄市','0632'),
	(139,15,'东营市','0546'),
	(140,15,'烟台市','0535'),
	(141,15,'潍坊市','0536'),
	(142,15,'济宁市','0537'),
	(143,15,'泰安市','0538'),
	(144,15,'威海市','0631'),
	(145,15,'日照市','0633'),
	(146,15,'莱芜市','0634'),
	(147,15,'临沂市','0539'),
	(148,15,'德州市','0534'),
	(149,15,'聊城市','0635'),
	(150,15,'滨州市','0543'),
	(151,15,'菏泽市','0530'),
	(152,16,'郑州市','0371'),
	(153,16,'开封市','0378'),
	(154,16,'洛阳市','0379'),
	(155,16,'平顶山市','0375'),
	(156,16,'安阳市','0372'),
	(157,16,'鹤壁市','0392'),
	(158,16,'新乡市','0373'),
	(159,16,'焦作市','0391'),
	(160,16,'濮阳市','0393'),
	(161,16,'许昌市','0374'),
	(162,16,'漯河市','0395'),
	(163,16,'三门峡市','0398'),
	(164,16,'南阳市','0377'),
	(165,16,'商丘市','0370'),
	(166,16,'信阳市','0376'),
	(167,16,'周口市','0394'),
	(168,16,'驻马店市','0396'),
	(169,16,'济源市','0391'),
	(170,17,'武汉市','027'),
	(171,17,'黄石市','0714'),
	(172,17,'十堰市','0719'),
	(173,17,'宜昌市','0717'),
	(174,17,'襄樊市','0710'),
	(175,17,'鄂州市','0711'),
	(176,17,'荆门市','0724'),
	(177,17,'孝感市','0712'),
	(178,17,'荆州市','0716'),
	(179,17,'黄冈市','0713'),
	(180,17,'咸宁市','0715'),
	(181,17,'随州市','0722'),
	(182,17,'恩施土家族苗族自治州','0718'),
	(183,17,'省直辖县级行政单位','0728'),
	(184,18,'长沙市','0731'),
	(185,18,'株洲市','0733'),
	(186,18,'湘潭市','0732'),
	(187,18,'衡阳市','0734'),
	(188,18,'邵阳市','0739'),
	(189,18,'岳阳市','0730'),
	(190,18,'常德市','0736'),
	(191,18,'张家界市','0744'),
	(192,18,'益阳市','0737'),
	(193,18,'郴州市','0735'),
	(194,18,'永州市','0746'),
	(195,18,'怀化市','0745'),
	(196,18,'娄底市','0738'),
	(197,18,'湘西土家族苗族自治州','0743'),
	(198,19,'广州市','020'),
	(199,19,'韶关市','0751'),
	(200,19,'深圳市','0755'),
	(201,19,'珠海市','0756'),
	(202,19,'汕头市','0754'),
	(203,19,'佛山市','0757'),
	(204,19,'江门市','0750'),
	(205,19,'湛江市','0759'),
	(206,19,'茂名市','0668'),
	(207,19,'肇庆市','0758'),
	(208,19,'惠州市','0752'),
	(209,19,'梅州市','0753'),
	(210,19,'汕尾市','0660'),
	(211,19,'河源市','0762'),
	(212,19,'阳江市','0662'),
	(213,19,'清远市','0763'),
	(214,19,'东莞市','0769'),
	(215,19,'中山市','0760'),
	(216,19,'潮州市','0768'),
	(217,19,'揭阳市','0663'),
	(218,19,'云浮市','0766'),
	(219,20,'南宁市','0771'),
	(220,20,'柳州市','0772'),
	(221,20,'桂林市','0773'),
	(222,20,'梧州市','0774'),
	(223,20,'北海市','0779'),
	(224,20,'防城港市','0770'),
	(225,20,'钦州市','0777'),
	(226,20,'贵港市','0775'),
	(227,20,'玉林市','0775'),
	(228,20,'百色市','0776'),
	(229,20,'贺州市','0774'),
	(230,20,'河池市','0778'),
	(231,20,'来宾市','0772'),
	(232,20,'崇左市','0771'),
	(233,21,'海口市','0898'),
	(234,21,'三亚市','0898'),
	(235,21,'省直辖县级行政单位','0898'),
	(236,22,'重庆市','023'),
	(237,23,'成都市','028'),
	(238,23,'自贡市','0813'),
	(239,23,'攀枝花市','0812'),
	(240,23,'泸州市','0830'),
	(241,23,'德阳市','0838'),
	(242,23,'绵阳市','0816'),
	(243,23,'广元市','0839'),
	(244,23,'遂宁市','0825'),
	(245,23,'内江市','0832'),
	(246,23,'乐山市','0833'),
	(247,23,'南充市','0817'),
	(248,23,'眉山市','0833'),
	(249,23,'宜宾市','0831'),
	(250,23,'广安市','0826'),
	(251,23,'达州市','0818'),
	(252,23,'雅安市','0835'),
	(253,23,'巴中市','0827'),
	(254,23,'资阳市','0832'),
	(255,23,'阿坝藏族羌族自治州','0837'),
	(256,23,'甘孜藏族自治州','0836'),
	(257,23,'凉山彝族自治州','0834'),
	(258,24,'贵阳市','0851'),
	(259,24,'六盘水市','0858'),
	(260,24,'遵义市','0852'),
	(261,24,'安顺市','0853'),
	(262,24,'铜仁地区','0856'),
	(263,24,'黔西南布依族苗族自治州','0859'),
	(264,24,'毕节地区','0857'),
	(265,24,'黔东南苗族侗族自治州','0855'),
	(266,24,'黔南布依族苗族自治州','0854'),
	(267,25,'昆明市','0871'),
	(268,25,'曲靖市','0874'),
	(269,25,'玉溪市','0877'),
	(270,25,'保山市','0875'),
	(271,25,'昭通市','0870'),
	(272,25,'丽江市','0888'),
	(273,25,'普洱市','0879'),
	(274,25,'临沧市','0883'),
	(275,25,'楚雄彝族自治州','0878'),
	(276,25,'红河哈尼族彝族自治州','0873'),
	(277,25,'文山壮族苗族自治州','0876'),
	(278,25,'西双版纳傣族自治州','0691'),
	(279,25,'大理白族自治州','0872'),
	(280,25,'德宏傣族景颇族自治州','0692'),
	(281,25,'怒江傈僳族自治州','0886'),
	(282,25,'迪庆藏族自治州','0887'),
	(283,26,'拉萨市','0891'),
	(284,26,'昌都地区','0895'),
	(285,26,'山南地区','0893'),
	(286,26,'日喀则地区','0892'),
	(287,26,'那曲地区','0896'),
	(288,26,'阿里地区','0897'),
	(289,26,'林芝地区','0894'),
	(290,27,'西安市','029'),
	(291,27,'铜川市','0919'),
	(292,27,'宝鸡市','0917'),
	(293,27,'咸阳市','029'),
	(294,27,'渭南市','0913'),
	(295,27,'延安市','0911'),
	(296,27,'汉中市','0916'),
	(297,27,'榆林市','0912'),
	(298,27,'安康市','0915'),
	(299,27,'商洛市','0914'),
	(300,28,'兰州市','0931'),
	(301,28,'嘉峪关市','0937'),
	(302,28,'金昌市','0935'),
	(303,28,'白银市','0943'),
	(304,28,'天水市','0938'),
	(305,28,'武威市','0935'),
	(306,28,'张掖市','0936'),
	(307,28,'平凉市','0933'),
	(308,28,'酒泉市','0937'),
	(309,28,'庆阳市','0934'),
	(310,28,'定西市','0932'),
	(311,28,'陇南市','0939'),
	(312,28,'临夏回族自治州','0930'),
	(313,28,'甘南藏族自治州','0941'),
	(314,29,'西宁市','0971'),
	(315,29,'海东地区','0972'),
	(316,29,'海北藏族自治州','0970'),
	(317,29,'黄南藏族自治州','0973'),
	(318,29,'海南藏族自治州','0974'),
	(319,29,'果洛藏族自治州','0975'),
	(320,29,'玉树藏族自治州','0976'),
	(321,29,'海西蒙古族藏族自治州','0979'),
	(322,30,'银川市','0951'),
	(323,30,'石嘴山市','0952'),
	(324,30,'吴忠市','0953'),
	(325,30,'固原市','0954'),
	(326,30,'中卫市','0955'),
	(327,31,'乌鲁木齐市','0991'),
	(328,31,'克拉玛依市','0990'),
	(329,31,'吐鲁番地区','0995'),
	(330,31,'哈密地区','0902'),
	(331,31,'昌吉回族自治州','0994'),
	(332,31,'博尔塔拉蒙古自治州','0909'),
	(333,31,'巴音郭楞蒙古自治州','0996'),
	(334,31,'阿克苏地区','0997'),
	(335,31,'克孜勒苏柯尔克孜自治州','0908'),
	(336,31,'喀什地区','0998'),
	(337,31,'和田地区','0903'),
	(338,31,'伊犁哈萨克自治州','0999'),
	(339,31,'塔城地区','0901'),
	(340,31,'阿勒泰地区','0906'),
	(341,31,'省直辖县级行政单位','0993'),
	(342,32,'香港','1000'),
	(343,33,'澳门','1001'),
	(344,34,'台湾','1002');

/*!40000 ALTER TABLE `city` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_action_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_action_log`;

CREATE TABLE `crm_action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `module` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模块名称',
  `controller` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '是哪个控制器的',
  `action` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '进行的操作名称-',
  `old_data` text COLLATE utf8_unicode_ci,
  `data` text COLLATE utf8_unicode_ci COMMENT '操作的数据项',
  `customer_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作所关联的客户编号',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作的员工姓名',
  `staff_id` int(11) DEFAULT NULL COMMENT '操作的员工主键',
  `ip` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作客户的IP，如果是接口，则需要调用端转证customer_ip',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='记录系统内所有操作日志信息';



# Dump of table crm_api_app
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_api_app`;

CREATE TABLE `crm_api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext COLLATE utf8_unicode_ci NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='appId和appSecret表';

LOCK TABLES `crm_api_app` WRITE;
/*!40000 ALTER TABLE `crm_api_app` DISABLE KEYS */;

INSERT INTO `crm_api_app` (`id`, `app_id`, `app_secret`, `app_name`, `app_status`, `app_type`, `app_info`)
VALUES
	(2,'40021838','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','test',1,1,'test'),
	(3,'94201193','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','管理中心APP',1,1,''),
	(4,'44793168','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','客资系统',1,1,'客资CRM系统'),
	(5,'93816470','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','erp系统接口',1,1,'erp系统接口'),
	(6,'05194764','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','儿童erp接口',1,1,'儿童erp调用crm接口'),
	(7,'76014592','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','VIP接口',1,1,'VIP接口'),
	(8,'63822084','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','进客接口',1,1,'进客相关接口');

/*!40000 ALTER TABLE `crm_api_app` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_api_fields
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_api_fields`;

CREATE TABLE `crm_api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用于保存各个API的字段规则';

LOCK TABLES `crm_api_fields` WRITE;
/*!40000 ALTER TABLE `crm_api_fields` DISABLE KEYS */;

INSERT INTO `crm_api_fields` (`id`, `fieldName`, `hash`, `dataType`, `default`, `isMust`, `range`, `info`, `type`, `showName`)
VALUES
	(1,'aaa','',8,'123123',1,'fsdf','sf',0,'aaa'),
	(2,'sdf','',1,'asdf',1,'','',0,'sdf'),
	(3,'123','',1,'`12',1,'`12','',0,'123'),
	(10,'ergerger','59ea0cd052201',1,'324234',0,'2342342','34234',1,'ergerger'),
	(11,'username','59eb02fb401b1',2,'',1,'test','我是说明\n',0,'username'),
	(12,'password','59eb02fb401b1',2,'',1,'','密码',0,'password'),
	(13,'username','59eb2c9d9b723',2,'',1,'','用于登录的用户名，可以是手机号，或staff表内的登录名。',0,'username'),
	(14,'password','59eb2c9d9b723',2,'',1,'','登录密码',0,'password'),
	(16,'code','59eb2c9d9b723',1,'200',1,'','返回200表示成功。其他为失败',1,'code'),
	(17,'staffid','59eb382d6af16',1,'',1,'','',0,'staffid'),
	(18,'username','59ec9360b6861',2,'',1,'','用户名',0,'username'),
	(19,'password','59ec9360b6861',2,'',1,'','password',0,'password'),
	(20,'username','59f15d141e7e2',2,'',1,'','',0,'username'),
	(21,'oldpwd','59f15d141e7e2',2,'',1,'','',0,'oldpwd'),
	(22,'newpwd','59f15d141e7e2',2,'',1,'','新密码',0,'newpwd'),
	(23,'staffname','59f2e9fb5f863',2,'',1,'','员工名',0,'staffname'),
	(24,'password','59f2e9fb5f863',2,'',1,'','密码',0,'password'),
	(26,'staff_id','59f424811d52f',1,'',1,'','员工id',0,'staff_id'),
	(28,'staffname','59f44a14c3cae',2,'',1,'','员工名',0,'staffname'),
	(29,'oldPassword','59f44a14c3cae',2,'',1,'','旧密码',0,'oldPassword'),
	(30,'newPassword','59f44a14c3cae',2,'',1,'','新密码',0,'newPassword'),
	(31,'abc','59f83a849c87d',7,'',1,'123','456',0,'abc'),
	(44,'user_name','59f96a8def678',2,'',1,'','',0,'user_name'),
	(45,'password','59f96a8def678',2,'',1,'','',0,'password'),
	(53,'create_time','5a4cb959b1c8b',2,'',0,'','订单创建时间',0,'create_time'),
	(54,'order_sn','5a4cb959b1c8b',2,'',1,'','订单号',0,'order_sn'),
	(55,'m_tel','5a4cb959b1c8b',2,'',0,'','男手机号',0,'m_tel'),
	(56,'w_tel','5a4cb959b1c8b',2,'',0,'','女手机号',0,'w_tel'),
	(57,'order_fact','5a4cb959b1c8b',2,'',0,'','一销实收',0,'order_fact'),
	(58,'order_amount','5a4cb959b1c8b',2,'',0,'','一销总额',0,'order_amount'),
	(59,'two_pin_fact','5a4cb959b1c8b',2,'',0,'','二销实收',0,'two_pin_fact'),
	(60,'two_pin_amount','5a4cb959b1c8b',2,'',0,'','二销总额',0,'two_pin_amount'),
	(61,'brandclass_id','5a4cb959b1c8b',1,'',1,'','事业部id',0,'brandclass_id'),
	(62,'shop_code','5a4cb959b1c8b',2,'',0,'','实体店shop_code',0,'shop_code'),
	(63,'customer_id','5a4cbaf782dc0',1,'',1,'','客资id',0,'customer_id'),
	(64,'order_sn','5a4cbaf782dc0',2,'',1,'','订单编号',0,'order_sn'),
	(65,'code','5a4d9063d2ca8',1,'',1,'1:进店进客；2：进店非进客；3：未进店；4：流失','1:进店进客；2：进店非进客；3：未进店；4：流失',0,'code'),
	(66,'create_time','5a4d9063d2ca8',2,'',1,'进店时间/标记时间','进店时间/标记时间',0,'create_time'),
	(67,'lose_reason','5a4d9063d2ca8',2,'',0,'流失原因','流失原因',0,'lose_reason'),
	(70,'m_tel','5a4d9063d2ca8',1,'',0,'男士手机号','男士手机号',0,'m_tel'),
	(71,'w_tel','5a4d9063d2ca8',1,'',1,'女士手机号','女士手机号',0,'w_tel'),
	(72,'brandclass_id','5a4d9063d2ca8',1,'',1,'事业部id','事业部id',0,'brandclass_id'),
	(73,'shop_code','5a4d9063d2ca8',1,'',1,'shop_code','shop_code',0,'shop_code'),
	(96,'diff','5a4cb959b1c8b',1,'1',1,'','用于区分是开单(1)，添加消费产品(2)还是收款(3)',0,'diff'),
	(98,'customer_number','5a4d9063d2ca8',1,'',1,'crm系统客户编号     ERP系统中的 From_index','crm系统客户编号     ERP系统中的 From_index',0,'customer_number'),
	(100,'brandclass_id','5a4cab8e0e678',1,'',1,'事业部id','事业部id',0,'brandclass_id'),
	(101,'shop_code','5a4cab8e0e678',2,'',1,'shop_code','shop_code',0,'shop_code'),
	(102,'staff_id','5a4cab8e0e678',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(103,'customer_number','5a4cab8e0e678',2,'',0,'crm系统客户编号   erp的  From_index','crm系统客户编号',0,'customer_number'),
	(104,'customer_name','5a4cab8e0e678',2,'',1,'客户姓名','客户姓名',0,'customer_name'),
	(105,'customer_tel','5a4cab8e0e678',2,'',1,'客户手机','客户手机',0,'customer_tel'),
	(106,'customer_wechat','5a4cab8e0e678',2,'',0,'客户微信','客户微信',0,'customer_wechat'),
	(107,'customer_qq','5a4cab8e0e678',2,'',0,'客户QQ','客户QQ',0,'customer_qq'),
	(108,'customer_sex','5a4cab8e0e678',2,'',0,'客户性别 （男，女）','客户性别 （男，女）',0,'customer_sex'),
	(109,'customer_birthday','5a4cab8e0e678',2,'',0,'客户生日','客户生日',0,'customer_birthday'),
	(110,'consultation_type_id','5a4cab8e0e678',1,'',0,'消费类型id','消费类型id',0,'consultation_type_id'),
	(111,'consultation_type','5a4cab8e0e678',2,'',0,'消费类型','消费类型',0,'consultation_type'),
	(112,'customer_area_id','5a4cab8e0e678',1,'',0,'客户分区id','客户分区id',0,'customer_area_id'),
	(113,'customer_area','5a4cab8e0e678',2,'',0,'客户分区','客户分区',0,'customer_area'),
	(114,'customer_cource_id','5a4cab8e0e678',1,'',0,'客户来源id','客户来源id',0,'customer_cource_id'),
	(115,'customer_cource','5a4cab8e0e678',2,'',0,'客户来源','客户来源',0,'customer_cource'),
	(116,'customer_intention_id','5a4cab8e0e678',1,'',0,'客户意向id','客户意向id',0,'customer_intention_id'),
	(117,'customer_intention','5a4cab8e0e678',2,'',0,'客户意向','客户意向',0,'customer_intention'),
	(118,'customer_orderaddress','5a4cab8e0e678',2,'',0,'接单点','接单点',0,'customer_orderaddress'),
	(119,'customer_address','5a4cab8e0e678',2,'',0,'客户地址','客户地址',0,'customer_address'),
	(120,'yp_day','5a4cab8e0e678',2,'',0,'预拍日期','预拍日期',0,'yp_day'),
	(121,'marry_day','5a4cab8e0e678',2,'',0,'结婚日期','结婚日期',0,'marry_day'),
	(122,'mate_name','5a4cab8e0e678',2,'',0,'配偶姓名','配偶姓名',0,'mate_name'),
	(123,'mate_tel','5a4cab8e0e678',2,'',0,'配偶手机','配偶手机',0,'mate_tel'),
	(124,'mate_wechat','5a4cab8e0e678',2,'',0,'配偶微信','配偶微信',0,'mate_wechat'),
	(125,'mate_qq','5a4cab8e0e678',2,'',0,'配偶QQ','配偶QQ',0,'mate_qq'),
	(126,'mate_sex','5a4cab8e0e678',2,'',0,'配偶性别','配偶性别',0,'mate_sex'),
	(127,'mate_birthday','5a4cab8e0e678',2,'',0,'配偶生日','配偶生日',0,'mate_birthday'),
	(128,'ready_baby_day','5a4cab8e0e678',2,'',0,'预产期','预产期',0,'ready_baby_day'),
	(129,'baby_birthday','5a4cab8e0e678',2,'',0,'宝宝生日','宝宝生日',0,'baby_birthday'),
	(130,'baby_address','5a4cab8e0e678',2,'',0,'宝宝出生地','宝宝出生地',0,'baby_address'),
	(131,'customer_remark','5a4cab8e0e678',2,'',0,'客户备注','客户备注',0,'customer_remark'),
	(132,'staff_id','5a4d9063d2ca8',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(133,'brandclass_id','5a56b32c2b6fa',1,'',1,'事业部id','事业部id',0,'brandclass_id'),
	(134,'shop_code','5a56b32c2b6fa',2,'',1,'操作员工所属 shop_code','操作员工所属 shop_code',0,'shop_code'),
	(135,'staff_id','5a56b32c2b6fa',1,'',1,'当前操作者  staff_id','当前操作者  staff_id',0,'staff_id'),
	(136,'order_sn','5a56b32c2b6fa',2,'',1,'erp系统中的订单编号','erp系统中的订单编号',0,'order_sn'),
	(137,'create_time','5a56b32c2b6fa',2,'',0,'订单创建时间  2018-01-11 14:20:30','订单创建时间  2018-01-11 14:20:30',0,'create_time'),
	(138,'consultation_type','5a56b32c2b6fa',2,'',0,'消费类型','消费类型',0,'consultation_type'),
	(139,'consultation_type_id','5a56b32c2b6fa',1,'',0,'消费类型 id','消费类型 id',0,'consultation_type_id'),
	(140,'customer_cource','5a56b32c2b6fa',2,'',0,'客户来源','客户来源',0,'customer_cource'),
	(141,'customer_cource_id','5a56b32c2b6fa',1,'',0,'客户 来源 id','客户 来源 id',0,'customer_cource_id'),
	(142,'customer_area','5a56b32c2b6fa',2,'',0,'客户分区','客户分区',0,'customer_area'),
	(143,'customer_area_id','5a56b32c2b6fa',1,'',0,'客户分区 id','客户分区 id',0,'customer_area_id'),
	(144,'marry_day','5a56b32c2b6fa',2,'',0,'结婚日期  2018-01-11 14:20:30','结婚日期  2018-01-11 14:20:30',0,'marry_day'),
	(145,'baby_birthday','5a56b32c2b6fa',2,'',0,'宝宝生日  2018-01-11 14:20:30','宝宝生日  2018-01-11 14:20:30',0,'baby_birthday'),
	(146,'wname','5a56b32c2b6fa',2,'',1,'女士姓名','女士姓名',0,'wname'),
	(147,'wphone','5a56b32c2b6fa',2,'',1,'女士手机号','女士手机号',0,'wphone'),
	(148,'wwechat','5a56b32c2b6fa',2,'',0,'女士微信','女士微信',0,'wwechat'),
	(149,'mname','5a56b32c2b6fa',2,'',0,'男士姓名','男士姓名',0,'mname'),
	(150,'mphone','5a56b32c2b6fa',2,'',0,'男士手机','男士手机',0,'mphone'),
	(151,'mwechat','5a56b32c2b6fa',2,'',0,'男士微信','男士微信',0,'mwechat'),
	(152,'customer_number','5a4cb959b1c8b',2,'',1,'客资编号，即：erp中，From_index','客资编号，即：erp中，From_index',0,'customer_number'),
	(153,'consultation_type','5a4cb959b1c8b',2,'',1,'消费类型','消费类型',0,'consultation_type'),
	(154,'brandclass_id','5a9d032325040',1,'',1,'事业部id','事业部id',0,'brandclass_id'),
	(155,'shop_code','5a9d032325040',2,'',1,'shop_code','shop_code',0,'shop_code'),
	(156,'shop_name','5a9d032325040',2,'',1,'shop_name','shop_name',0,'shop_name'),
	(157,'create_time','5a9d032325040',2,'',0,'创建时间 (y-m-d H:i:s)','创建时间 (y-m-d H:i:s)',0,'create_time'),
	(158,'staff_name','5a9d032325040',2,'',0,'操作人','操作人',0,'staff_name'),
	(159,'consultation_type','5a9d032325040',2,'',1,'消费类型','消费类型',0,'consultation_type'),
	(160,'customer_cource','5a9d032325040',2,'',0,'客户来源','客户来源',0,'customer_cource'),
	(162,'customer_area','5a9d032325040',2,'',0,'客户分区','客户分区',0,'customer_area'),
	(164,'marry_day','5a9d032325040',2,'',0,'结婚日期','结婚日期',0,'marry_day'),
	(165,'baby_birthday','5a9d032325040',2,'',0,'宝宝生日','宝宝生日',0,'baby_birthday'),
	(166,'wname','5a9d032325040',2,'',1,'女士姓名','女士姓名',0,'wname'),
	(167,'wphone','5a9d032325040',1,'',1,'女士手机','女士手机',0,'wphone'),
	(168,'wwechat','5a9d032325040',2,'',0,'女士微信','女士微信',0,'wwechat'),
	(169,'mname','5a9d032325040',2,'',0,'男士姓名','男士姓名',0,'mname'),
	(170,'mphone','5a9d032325040',1,'',0,'男士手机','男士手机',0,'mphone'),
	(171,'mwechat','5a9d032325040',2,'',0,'男士微信','男士微信',0,'mwechat'),
	(172,'brandclass_id','5a9d038620298',1,'',1,'事业部id','事业部id',0,'brandclass_id'),
	(173,'shop_code','5a9d038620298',2,'',1,'shop_code','shop_code',0,'shop_code'),
	(174,'shop_name','5a9d038620298',2,'',1,'shop_name','shop_name',0,'shop_name'),
	(176,'customer_number','5a9d038620298',2,'',1,'客资编号','客资编号',0,'customer_number'),
	(177,'order_sn','5a9d038620298',2,'',1,'订单编号','订单编号',0,'order_sn'),
	(178,'order_amount','5a9d038620298',2,'',1,'一销套系金额','一销套系金额',0,'order_amount'),
	(179,'two_pin_amount','5a9d038620298',2,'',0,'二销套系金额','二销套系金额',0,'two_pin_amount'),
	(180,'customer_orderaddress','5a9d038620298',2,'',0,'接单点','接单点',0,'customer_orderaddress'),
	(181,'order_note','5a9d038620298',2,'',0,'订单备注','订单备注',0,'order_note'),
	(182,'consultation_type','5a9d038620298',2,'',1,'消费类型','消费类型',0,'consultation_type'),
	(183,'brandclass_id','5a9d03d28c863',1,'',1,'事业部id','事业部id',0,'brandclass_id'),
	(184,'shop_code','5a9d03d28c863',2,'',1,'shop_code','shop_code',0,'shop_code'),
	(185,'shop_name','5a9d03d28c863',2,'',1,'shop_name','shop_name',0,'shop_name'),
	(187,'customer_number','5a9d03d28c863',2,'',1,'客资编号','客资编号',0,'customer_number'),
	(188,'order_sn','5a9d03d28c863',2,'',1,'订单编号','订单编号',0,'order_sn'),
	(189,'order_fact','5a9d03d28c863',2,'',1,'一销实收金额','一销实收金额',0,'order_fact'),
	(190,'two_pin_fact','5a9d03d28c863',2,'',0,'二销实收金额','二销实收金额',0,'two_pin_fact'),
	(191,'target_time','5a9d038620298',2,'',0,'订单获取时间 (y-m-d H:i:s)','订单获取时间 (y-m-d H:i:s)',0,'target_time'),
	(192,'update_time','5a9d03d28c863',2,'',0,'订单收款时间 (y-m-d H:i:s)','订单收款时间 (y-m-d H:i:s)',0,'update_time'),
	(194,'target_time','5a9d032325040',2,'',0,'客资获取时间','客资获取时间',0,'target_time'),
	(195,'create_time','5a9d038620298',2,'',0,'订单录入时间','订单录入时间',0,'create_time'),
	(196,'order_sn','5abf60677c448',2,'',1,'erp订单单号','erp订单单号',0,'order_sn'),
	(197,'staff_id','5abf60677c448',1,'',1,'当前操作人id ','当前操作人id',0,'staff_id'),
	(198,'staff_name','5abf60677c448',2,'',1,'当前操作人姓名','当前操作人姓名',0,'staff_name'),
	(220,'brandclass_id','5acd6abcb09be',1,'',0,'事业部id','事业部id',0,'brandclass_id'),
	(221,'shop_code','5acd6abcb09be',2,'',0,'','',0,'shop_code'),
	(222,'department_id','5acd6abcb09be',1,'',0,'部门id ','部门id',0,'department_id'),
	(223,'staff_id','5acd6abcb09be',1,'',0,'登记人id','登记人id',0,'staff_id'),
	(224,'start','5acd6abcb09be',2,'',0,'客资登记开始时间','客资登记开始时间，格式是：2018-04-01 15:30:15,下面参数亦如此',0,'start'),
	(225,'end','5acd6abcb09be',2,'',0,'客资登记结束时间','客资登记结束时间',0,'end'),
	(226,'search','5b1a178493b48',2,'',0,'','模糊查询,可查询到匹配的联系方式,姓名,编号,单号',0,'search'),
	(227,'start','5b1a178493b48',2,'',0,'','录入开始时间,不传默认当天',0,'start'),
	(228,'end','5b1a178493b48',2,'',0,'','录入结束时间,不传默认当天',0,'end'),
	(229,'customer_number','5b1a18f6249f0',2,'',1,' ','客资编号',0,'customer_number'),
	(230,'customer_number','5b1a1f8ebd740',2,'',2,'','客资编号',0,'customer_number'),
	(231,'customer_number','5b3b60b24ada9',2,'',0,'客资编号','客资编号',0,'customer_number'),
	(232,'brandclass_id','5b3b60b24ada9',1,'',0,'事业部ID','事业部ID',0,'brandclass_id'),
	(233,'brandclass','5b3b60b24ada9',2,'',0,'事业部','事业部',0,'brandclass'),
	(234,'contact_type','5b3b60b24ada9',1,'',0,'联系方式类型(1：手机；2：微信；3：qq)','联系方式类型(1：手机；2：微信；3：qq)',0,'contact_type'),
	(235,'contact_w','5b3b60b24ada9',2,'',0,'联系方式_母亲','联系方式_母亲',0,'contact_w'),
	(236,'contact_m','5b3b60b24ada9',2,'',0,'联系方式_父亲','联系方式_父亲',0,'contact_m'),
	(237,'customer_number','5b3b61169ed69',2,'',0,'客资编号','客资编号',0,'customer_number'),
	(238,'brandclass_id','5b3b61169ed69',1,'',1,'事业部ID','事业部ID',0,'brandclass_id'),
	(239,'brandclass','5b3b61169ed69',2,'',1,'事业部','事业部',0,'brandclass'),
	(240,'shop_code','5b3b61169ed69',2,'',1,'操作店code','操作店code',0,'shop_code'),
	(241,'shop_name','5b3b61169ed69',2,'',1,'操作店名','操作店名',0,'shop_name'),
	(242,'staff_id','5b3b61169ed69',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(243,'staff_name','5b3b61169ed69',2,'',1,'操作人','操作人',0,'staff_name'),
	(244,'baby_name','5b3b61169ed69',2,'',0,'宝宝姓名','宝宝姓名',0,'baby_name'),
	(245,'baby_sex','5b3b61169ed69',2,'',0,'宝宝性别','宝宝性别',0,'baby_sex'),
	(246,'baby_birthday','5b3b61169ed69',2,'',0,'宝宝生日','宝宝生日',0,'baby_birthday'),
	(247,'baby_address','5b3b61169ed69',2,'',0,'宝宝出生地(医院)','宝宝出生地(医院)',0,'baby_address'),
	(248,'customer_name','5b3b61169ed69',2,'',0,'母亲姓名','母亲姓名',0,'customer_name'),
	(249,'customer_tel','5b3b61169ed69',2,'',0,'母亲手机','母亲手机',0,'customer_tel'),
	(250,'customer_wechat','5b3b61169ed69',2,'',0,'母亲微信','母亲微信',0,'customer_wechat'),
	(251,'customer_qq','5b3b61169ed69',2,'',0,'母亲QQ','母亲QQ',0,'customer_qq'),
	(252,'customer_birthday','5b3b61169ed69',2,'',0,'母亲生日','母亲生日',0,'customer_birthday'),
	(253,'mate_name','5b3b61169ed69',2,'',0,'父亲姓名','父亲姓名',0,'mate_name'),
	(254,'mate_tel','5b3b61169ed69',2,'',0,'父亲手机','父亲手机',0,'mate_tel'),
	(255,'mate_wechat','5b3b61169ed69',2,'',0,'父亲微信','父亲微信',0,'mate_wechat'),
	(256,'mate_qq','5b3b61169ed69',2,'',0,'父亲QQ','父亲QQ',0,'mate_qq'),
	(257,'mate_birthday','5b3b61169ed69',2,'',0,'父亲生日','父亲生日',0,'mate_birthday'),
	(258,'ready_baby_day','5b3b61169ed69',2,'',0,'预产期','预产期',0,'ready_baby_day'),
	(259,'marry_day','5b3b61169ed69',2,'',0,'结婚日期','结婚日期',0,'marry_day'),
	(260,'yp_day','5b3b61169ed69',2,'',0,'预拍日期','预拍日期',0,'yp_day'),
	(261,'consultation_type_id','5b3b61169ed69',1,'',0,'消费类型id','消费类型id',0,'consultation_type_id'),
	(262,'consultation_type','5b3b61169ed69',2,'',0,'消费类型','消费类型',0,'consultation_type'),
	(263,'customer_area_id','5b3b61169ed69',1,'',0,'客户分区id','客户分区id',0,'customer_area_id'),
	(264,'customer_area','5b3b61169ed69',2,'',0,'客户分区','客户分区',0,'customer_area'),
	(265,'customer_cource_id','5b3b61169ed69',1,'',0,'客户来源id','客户来源id',0,'customer_cource_id'),
	(266,'customer_cource','5b3b61169ed69',2,'',0,'客户来源','客户来源',0,'customer_cource'),
	(267,'customer_intention_id','5b3b61169ed69',1,'',0,'客户意向id','客户意向id',0,'customer_intention_id'),
	(268,'customer_intention','5b3b61169ed69',2,'',0,'客户意向','客户意向',0,'customer_intention'),
	(269,'customer_orderaddress','5b3b61169ed69',1,'',0,'接单点_id','接单点_id',0,'customer_orderaddress_id'),
	(270,'customer_orderaddress_id','5b3b61169ed69',2,'',0,'接单点','接单点',0,'customer_orderaddress'),
	(271,'province','5b3b61169ed69',2,'',0,'省','省',0,'province'),
	(272,'city','5b3b61169ed69',2,'',0,'市','市',0,'city'),
	(273,'county','5b3b61169ed69',2,'',0,'区/县','区/县',0,'county'),
	(274,'home_phone','5b3b61169ed69',2,'',0,'座机','座机',0,'home_phone'),
	(275,'email','5b3b61169ed69',2,'',0,'邮箱','邮箱',0,'email'),
	(276,'customer_address','5b3b61169ed69',2,'',0,'客户地址','客户地址',0,'customer_address'),
	(277,'customer_remark','5b3b61169ed69',2,'',0,'客户备注','客户备注',0,'customer_remark'),
	(278,'customer_number','5b3b63334a9c1',2,'',1,'客资编号','客资编号',0,'customer_number'),
	(279,'staff_id','5b3b63334a9c1',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(280,'staff_name','5b3b63334a9c1',2,'',1,'操作人','操作人',0,'staff_name'),
	(281,'code','5b3b63334a9c1',1,'',1,'1:进店进客；2：进店非进客；3：未进店；4：流失','1:进店进客；2：进店非进客；3：未进店；4：流失',0,'code'),
	(282,'lose_reason','5b3b63334a9c1',2,'',0,'流失原因','流失原因',0,'lose_reason'),
	(283,'create_time','5b3b63334a9c1',2,'',1,'流失/进店时间','流失/进店时间',0,'create_time'),
	(284,'customer_number','5b3b63ad39081',2,'',0,'客资编号','客资编号',0,'customer_number'),
	(285,'staff_id','5b3b63ad39081',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(286,'staff_name','5b3b63ad39081',2,'',1,'操作人','操作人',0,'staff_name'),
	(287,'baby_name','5b3b63ad39081',2,'',0,'宝宝姓名','宝宝姓名',0,'baby_name'),
	(288,'baby_sex','5b3b63ad39081',2,'',0,'宝宝性别','宝宝性别',0,'baby_sex'),
	(289,'baby_birthday','5b3b63ad39081',2,'',0,'宝宝生日','宝宝生日',0,'baby_birthday'),
	(290,'baby_address','5b3b63ad39081',2,'',0,'宝宝出生地(医院)','宝宝出生地(医院)',0,'baby_address'),
	(291,'customer_name','5b3b63ad39081',2,'',0,'母亲姓名','母亲姓名',0,'customer_name'),
	(292,'customer_tel','5b3b63ad39081',2,'',0,'母亲手机','母亲手机',0,'customer_tel'),
	(293,'customer_wechat','5b3b63ad39081',2,'',0,'母亲微信','母亲微信',0,'customer_wechat'),
	(294,'customer_qq','5b3b63ad39081',2,'',0,'母亲QQ','母亲QQ',0,'customer_qq'),
	(295,'customer_birthday','5b3b63ad39081',2,'',0,'母亲生日','母亲生日',0,'customer_birthday'),
	(296,'mate_name','5b3b63ad39081',2,'',0,'父亲姓名','父亲姓名',0,'mate_name'),
	(297,'mate_tel','5b3b63ad39081',2,'',0,'父亲手机','父亲手机',0,'mate_tel'),
	(298,'mate_wechat','5b3b63ad39081',2,'',0,'父亲微信','父亲微信',0,'mate_wechat'),
	(299,'mate_qq','5b3b63ad39081',2,'',0,'父亲QQ','父亲QQ',0,'mate_qq'),
	(300,'mate_birthday','5b3b63ad39081',2,'',0,'父亲生日','父亲生日',0,'mate_birthday'),
	(301,'ready_baby_day','5b3b63ad39081',2,'',0,'预产期','预产期',0,'ready_baby_day'),
	(302,'marry_day','5b3b63ad39081',2,'',0,'结婚日期','结婚日期',0,'marry_day'),
	(303,'yp_day','5b3b63ad39081',2,'',0,'预拍日期','预拍日期',0,'yp_day'),
	(304,'consultation_type_id','5b3b63ad39081',1,'',0,'消费类型id','消费类型id',0,'consultation_type_id'),
	(305,'consultation_type','5b3b63ad39081',2,'',0,'消费类型','消费类型',0,'consultation_type'),
	(306,'customer_area_id','5b3b63ad39081',1,'',0,'客户分区id','客户分区id',0,'customer_area_id'),
	(307,'customer_area','5b3b63ad39081',2,'',0,'客户分区','客户分区',0,'customer_area'),
	(308,'customer_cource_id','5b3b63ad39081',1,'',0,'客户来源id','客户来源id',0,'customer_cource_id'),
	(309,'customer_cource','5b3b63ad39081',2,'',0,'客户来源','客户来源',0,'customer_cource'),
	(310,'customer_intention_id','5b3b63ad39081',1,'',0,'客户意向id','客户意向id',0,'customer_intention_id'),
	(311,'customer_intention','5b3b63ad39081',2,'',0,'客户意向','客户意向',0,'customer_intention'),
	(312,'customer_orderaddress','5b3b63ad39081',1,'',0,'接单点_id','接单点_id',0,'customer_orderaddress_id'),
	(313,'customer_orderaddress_id','5b3b63ad39081',2,'',0,'接单点','接单点',0,'customer_orderaddress'),
	(314,'province','5b3b63ad39081',2,'',0,'省','省',0,'province'),
	(315,'city','5b3b63ad39081',2,'',0,'市','市',0,'city'),
	(316,'county','5b3b63ad39081',2,'',0,'区/县','区/县',0,'county'),
	(317,'home_phone','5b3b63ad39081',2,'',0,'座机','座机',0,'home_phone'),
	(318,'email','5b3b63ad39081',2,'',0,'邮箱','邮箱',0,'email'),
	(319,'customer_address','5b3b63ad39081',2,'',0,'客户地址','客户地址',0,'customer_address'),
	(320,'customer_remark','5b3b63ad39081',2,'',0,'客户备注','客户备注',0,'customer_remark'),
	(321,'order_sn','5b3b640593da1',2,'',1,'订单编号','订单编号',0,'order_sn'),
	(322,'brandclass_id','5b3b640593da1',1,'',1,'事业部ID','事业部ID',0,'brandclass_id'),
	(323,'brandclass','5b3b640593da1',2,'',1,'事业部','事业部',0,'brandclass'),
	(324,'shop_code','5b3b640593da1',2,'',1,'操作店code','操作店code',0,'shop_code'),
	(325,'shop_name','5b3b640593da1',2,'',1,'操作店名','操作店名',0,'shop_name'),
	(326,'staff_id','5b3b640593da1',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(327,'staff_name','5b3b640593da1',2,'',1,'操作人','操作人',0,'staff_name'),
	(328,'baby_name','5b3b640593da1',2,'',0,'宝宝姓名','宝宝姓名',0,'baby_name'),
	(329,'baby_sex','5b3b640593da1',2,'',0,'宝宝性别','宝宝性别',0,'baby_sex'),
	(330,'baby_birthday','5b3b640593da1',2,'',0,'宝宝生日','宝宝生日',0,'baby_birthday'),
	(331,'baby_address','5b3b640593da1',2,'',0,'宝宝出生地(医院)','宝宝出生地(医院)',0,'baby_address'),
	(332,'customer_name','5b3b640593da1',2,'',0,'母亲姓名','母亲姓名',0,'customer_name'),
	(333,'customer_tel','5b3b640593da1',2,'',0,'母亲手机','母亲手机',0,'customer_tel'),
	(334,'customer_wechat','5b3b640593da1',2,'',0,'母亲微信','母亲微信',0,'customer_wechat'),
	(335,'customer_qq','5b3b640593da1',2,'',0,'母亲QQ','母亲QQ',0,'customer_qq'),
	(336,'customer_birthday','5b3b640593da1',2,'',0,'母亲生日','母亲生日',0,'customer_birthday'),
	(337,'mate_name','5b3b640593da1',2,'',0,'父亲姓名','父亲姓名',0,'mate_name'),
	(338,'mate_tel','5b3b640593da1',2,'',0,'父亲手机','父亲手机',0,'mate_tel'),
	(339,'mate_wechat','5b3b640593da1',2,'',0,'父亲微信','父亲微信',0,'mate_wechat'),
	(340,'mate_qq','5b3b640593da1',2,'',0,'父亲QQ','父亲QQ',0,'mate_qq'),
	(341,'mate_birthday','5b3b640593da1',2,'',0,'父亲生日','父亲生日',0,'mate_birthday'),
	(342,'ready_baby_day','5b3b640593da1',2,'',0,'预产期','预产期',0,'ready_baby_day'),
	(343,'marry_day','5b3b640593da1',2,'',0,'结婚日期','结婚日期',0,'marry_day'),
	(344,'yp_day','5b3b640593da1',2,'',0,'预拍日期','预拍日期',0,'yp_day'),
	(345,'consultation_type_id','5b3b640593da1',1,'',0,'消费类型id','消费类型id',0,'consultation_type_id'),
	(346,'consultation_type','5b3b640593da1',2,'',0,'消费类型','消费类型',0,'consultation_type'),
	(347,'customer_area_id','5b3b640593da1',1,'',0,'客户分区id','客户分区id',0,'customer_area_id'),
	(348,'customer_area','5b3b640593da1',2,'',0,'客户分区','客户分区',0,'customer_area'),
	(349,'customer_cource_id','5b3b640593da1',1,'',0,'客户来源id','客户来源id',0,'customer_cource_id'),
	(350,'customer_cource','5b3b640593da1',2,'',0,'客户来源','客户来源',0,'customer_cource'),
	(351,'customer_intention_id','5b3b640593da1',1,'',0,'客户意向id','客户意向id',0,'customer_intention_id'),
	(352,'customer_intention','5b3b640593da1',2,'',0,'客户意向','客户意向',0,'customer_intention'),
	(353,'customer_orderaddress','5b3b640593da1',1,'',0,'接单点_id','接单点_id',0,'customer_orderaddress_id'),
	(354,'customer_orderaddress_id','5b3b640593da1',2,'',0,'接单点','接单点',0,'customer_orderaddress'),
	(355,'province','5b3b640593da1',2,'',0,'省','省',0,'province'),
	(356,'city','5b3b640593da1',2,'',0,'市','市',0,'city'),
	(357,'county','5b3b640593da1',2,'',0,'区/县','区/县',0,'county'),
	(358,'home_phone','5b3b640593da1',2,'',0,'座机','座机',0,'home_phone'),
	(359,'email','5b3b640593da1',2,'',0,'邮箱','邮箱',0,'email'),
	(360,'customer_address','5b3b640593da1',2,'',0,'客户地址','客户地址',0,'customer_address'),
	(361,'customer_remark','5b3b640593da1',2,'',0,'客户备注','客户备注',0,'customer_remark'),
	(362,'order_sn','5b3b645687669',2,'',1,'订单编号','订单编号',0,'order_sn'),
	(363,'brandclass_id','5b3b645687669',1,'',1,'事业部ID','事业部ID',0,'brandclass_id'),
	(364,'brandclass','5b3b645687669',2,'',1,'事业部','事业部',0,'brandclass'),
	(365,'shop_code','5b3b645687669',2,'',1,'操作店code','操作店code',0,'shop_code'),
	(366,'shop_name','5b3b645687669',2,'',1,'操作店名','操作店名',0,'shop_name'),
	(367,'staff_id','5b3b645687669',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(368,'staff_name','5b3b645687669',2,'',1,'操作人','操作人',0,'staff_name'),
	(369,'order_amount','5b3b645687669',2,'',1,'一销套系总额','一销套系总额',0,'order_amount'),
	(370,'two_pin_amount','5b3b645687669',2,'',1,'二销套系总额','二销套系总额',0,'two_pin_amount'),
	(371,'order_sn','5b3b64b260d39',2,'',1,'订单编号','订单编号',0,'order_sn'),
	(378,'order_fact','5b3b64b260d39',1,'',1,'一销收款金额','一销收款金额',0,'order_fact'),
	(379,'two_pin_fact','5b3b64b260d39',2,'',1,'二销收款金额','二销收款金额',0,'two_pin_fact'),
	(380,'order_sn','5b3b64f2b9f01',2,'',1,'订单编号','订单编号',0,'order_sn'),
	(381,'staff_id','5b3b64f2b9f01',1,'',1,'操作人id','操作人id',0,'staff_id'),
	(382,'staff_name','5b3b64f2b9f01',2,'',1,'操作人','操作人',0,'staff_name'),
	(383,'diff','5b3b6722b9f01',1,'',1,'用于区分是转订单（1）添加消费产品(2)还是收款(3)','用于区分是转订单（1）添加消费产品(2)还是收款(3)',0,'diff'),
	(384,'create_time','5b3b6722b9f01',2,'',0,'订单创建时间','订单创建时间',0,'create_time'),
	(385,'customer_number','5b3b6722b9f01',2,'',1,'客资编号','客资编号',0,'customer_number'),
	(386,'order_sn','5b3b6722b9f01',2,'',0,'订单号','订单号',0,'order_sn'),
	(387,'order_valid','5b3b6722b9f01',1,'',0,'订单有效状态（1：无效；2：有效）','订单有效状态（1：无效；2：有效）',0,'order_valid'),
	(388,'m_tel','5b3b6722b9f01',2,'',0,'母亲手机','母亲手机',0,'m_tel'),
	(389,'w_tel','5b3b6722b9f01',2,'',0,'父亲手机','父亲手机',0,'w_tel'),
	(390,'order_valid','5b3b6722b9f01',2,'',0,'','',0,'order_valid'),
	(391,'order_fact','5b3b6722b9f01',2,'',0,'一销实收','一销实收',0,'order_fact'),
	(392,'order_amount','5b3b6722b9f01',2,'',0,'一销总额','一销总额',0,'order_amount'),
	(393,'two_pin_fact','5b3b6722b9f01',2,'',0,'二销实收','二销实收',0,'two_pin_fact'),
	(394,'two_pin_amount','5b3b6722b9f01',2,'',0,'二销总额','二销总额',0,'two_pin_amount'),
	(395,'brandclass_id','5b3b6722b9f01',2,'',0,'事业部ID','事业部ID',0,'brandclass_id'),
	(396,'brandclass','5b3b6722b9f01',2,'',0,'事业部','事业部',0,'brandclass'),
	(397,'shop_code','5b3b6722b9f01',2,'',0,'shop_code','shop_code',0,'shop_code'),
	(398,'shop_name','5b3b6722b9f01',2,'',0,'shop_name','shop_name',0,'shop_name'),
	(486,'customer_number','5b1a174a2cd3',2,'',1,'','客资编号',0,'customer_number'),
	(487,'customer_number','5b935efda2990',2,'',1,'客资编号','客资编号',0,'customer_number'),
	(488,'staff_name','5b935efda2990',2,'',1,'当前操作人姓名','当前操作人姓名',0,'staff_name'),
	(489,'shop_code','5b935efda2990',2,'',1,'操作店shop_code','操作店shop_code',0,'shop_code'),
	(490,'shop_name','5b935efda2990',1,'',1,'操作店shop_name','操作店shop_name',0,'shop_name'),
	(491,'sign_name','5b935efda2990',2,'',1,'标记名称','标记名称',0,'sign_name'),
	(492,'sign_time','5b935efda2990',2,'',1,'标记时间','标记时间',0,'sign_time'),
	(493,'order_day','5bd42d703b150',2,'',1,'','订单时间',0,'order_day'),
	(494,'customer_number','5bd42d703b150',1,'',1,'','客资编号',0,'customer_number'),
	(495,'order_sn','5bd42d703b150',1,'',1,'','单号',0,'order_sn'),
	(496,'total_money','5bd42d703b150',1,'',1,'','套系',0,'total_money'),
	(497,'fact_money','5bd42d703b150',1,'',1,'','实收',0,'fact_money'),
	(498,'reception_name','5bd42d703b150',1,'',0,'','门市',0,'reception_name'),
	(499,'pay_type','5bd42d703b150',2,'',0,'','付款方式',0,'pay_type'),
	(500,'staff_id','5be54b43c8bb8',1,'',1,'','登记人id',0,'staff_id'),
	(501,'hd_name','5be54b43c8bb8',1,'',1,'','活动名称',0,'hd_name'),
	(502,'customer_name','5be54b43c8bb8',1,'',1,'','客户姓名',0,'customer_name'),
	(503,'customer_tel','5be54b43c8bb8',1,'',1,'','客户手机',0,'customer_tel'),
	(504,'consulation_shop_code','5be54b43c8bb8',0,'',1,'','意向店面编码',0,'consulation_shop_code'),
	(505,'consulation_shop','5be54b43c8bb8',1,'',0,'','意向店面',0,'consulation_shop'),
	(506,'customer_cource_id','5be54b43c8bb8',1,'',0,'','客户来源id',0,'customer_cource_id'),
	(507,'customer_cource','5be54b43c8bb8',2,'',0,'','客户来源',0,'customer_cource'),
	(515,'brandclass_id','465abc8e0e679',1,'',0,'事业部id','事业部id',0,'brandclass_id'),
	(516,'customer_wechat','465abc8e0e679',2,'',0,'微信号','微信号',0,'customer_wechat'),
	(517,'from_index','465abc8e0e679',1,'',0,'客资编号 ','客资编号',0,'from_index'),
	(518,'customer_tel','465abc8e0e679',1,'',0,'联系电话','联系电话',0,'customer_tel'),
	(519,'mate_tel','465abc8e0e679',2,'',0,'配偶电话','配偶电话',0,'mate_tel'),
	(520,'customer_qq','465abc8e0e679',2,'',0,'客户QQ','客户QQ',0,'customer_qq'),
	(530,'order_sn','5b1a174a2cd3',2,'',1,'','订单编号',0,'order_sn'),
	(541,'customer_number','5b285b5c829d8',2,'',0,'客资编号','客资编号',0,'customer_number'),
	(542,'contace_type','5b285b5c829d8',1,'',0,'联系方式类型(1：手机；2：微信；3：qq)','联系方式类型(1：手机；2：微信；3：qq)',0,'contace_type'),
	(543,'contace_m','5b285b5c829d8',2,'',0,'联系方式_男士','联系方式_男士',0,'contace'),
	(544,'contace_w','5b285b5c829d8',2,'',0,'联系方式_女士','联系方式_女士',0,'contace'),
	(555,'type','5b1a174a2cd3',1,'',1,'','',0,'type'),
	(556,'month','5c207f0794700',2,'',1,'年月','月份',0,'month'),
	(557,'shop_code','5c207f0794700',2,'',1,'','',0,'shop_code'),
	(558,'area_id','5c207f0794700',2,'',0,'','分区id',0,'area_id'),
	(559,'time','5c207f0794700',2,'',0,'','时间点',0,'time'),
	(560,'id','5c207f8394318',1,'',1,'','客资id',0,'id'),
	(561,'staff_id','5c207f8394318',1,'',1,'','操作人id',0,'staff_id'),
	(562,'pc_time','5c207f8394318',2,'',1,'2018-12-29','排程日期',0,'pc_time'),
	(563,'pc_shop_code','5c207f8394318',2,'',1,'','排程店面code',0,'pc_shop_code'),
	(564,'pc_shop_name','5c207f8394318',2,'',1,'','排程店面',0,'pc_shop_name'),
	(565,'area_id','5c207f8394318',1,'',0,'','分区id',0,'area_id'),
	(566,'area_name','5c207f8394318',2,'',0,'','分区',0,'area_name'),
	(567,'time','5c207f8394318',2,'',0,'','时间点',0,'time'),
	(568,'cameraman_id','5c207f8394318',1,'',0,'','摄影师id',0,'cameraman_id'),
	(569,'cameraman_name','5c207f8394318',2,'',0,'','摄影师',0,'cameraman_name'),
	(570,'sale_id','5c207f8394318',1,'',0,'','销售id',0,'sale_id'),
	(571,'sale_name','5c207f8394318',2,'',0,'','销售',0,'sale_name'),
	(572,'tutor_id','5c207f8394318',1,'',0,'','导师id',0,'tutor_id'),
	(573,'tutor_name','5c207f8394318',2,'',0,'','导师',0,'tutor_name'),
	(574,'remark','5c207f8394318',2,'',0,'','排程备注',0,'remark'),
	(575,'model_id','5c207f8394318',1,'',0,'','短信模板id',0,'短信模板id'),
	(576,'shop_code','5c2095b23efd0',2,'',1,'','店code',0,'店code'),
	(577,'brandclass_id','5c6a8c262b8e0',1,'',0,'事业部ID','事业部ID',0,'brandclass_id'),
	(578,'search_time','5c6a8c262b8e0',2,'',0,'查询的时间类型（dj_day）等','查询的时间类型（dj_day）等',0,'search_time'),
	(579,'start','5c6a8c262b8e0',1,'',0,'开始时间','开始时间',0,'start'),
	(580,'end','5c6a8c262b8e0',1,'',0,'结束时间','结束时间',0,'end'),
	(985,'id','5c459396a8750',1,'',1,'','进店表id',0,'id'),
	(986,'reception_id','5c459396a8750',1,'',0,'','',0,'reception_id'),
	(987,'reception_name','5c459396a8750',2,'',0,'','接待人',0,'reception_name'),
	(988,'yjd_day','5c459396a8750',2,'',0,'YYYY-mm-dd HH:II:SS','预约进店时间',0,'yjd_day'),
	(989,'staff_id','5c459396a8750',1,'',1,'','操作人id',0,'staff_id'),
	(990,'staff_name','5c459396a8750',2,'',1,'','操作人',0,'staff_name'),
	(991,'consulation_shop_code','5c459396a8750',1,'',0,'','意向店面编码',0,'consulation_shop_code'),
	(992,'consulation_shop_name','5c459396a8750',2,'',0,'','意向店面',0,'consulation_shop_name'),
	(993,'id','5c4595ab2b750',1,'',1,'','进店id',0,'id'),
	(994,'staff_id','5c4595ab2b750',1,'',1,'','',0,'staff_id'),
	(995,'staff_name','5c4595ab2b750',1,'',1,'','操作人',0,'staff_name'),
	(996,'id','5c4596536c660',1,'',1,'','进店id',0,'id'),
	(997,'id','5c459af2ccd58',1,'',1,'','',0,'id'),
	(998,'giftinfo','5c459af2ccd58',2,'',1,'','礼品信息',0,'giftinfo'),
	(999,'costs','5c459af2ccd58',2,'',0,'','礼品花费',0,'costs'),
	(1000,'staff_id','5c459af2ccd58',1,'',1,'','',0,'staff_id'),
	(1001,'staff_name','5c459af2ccd58',2,'',1,'','操作人',0,'staff_name'),
	(1002,'id','5c459ba5c96a8',1,'',1,'','',0,'id'),
	(1003,'staff_id','5c459ba5c96a8',1,'',1,'','',0,'staff_id'),
	(1004,'staff_name','5c459ba5c96a8',2,'',1,'','操作人',0,'staff_name'),
	(1005,'reception_id','5c459ba5c96a8',1,'',1,'','',0,'reception_id'),
	(1006,'reception_name','5c459ba5c96a8',2,'',1,'','接待人',0,'reception_name'),
	(1007,'id','5c459b56b6210',1,'',1,'','',0,'id'),
	(1008,'op_signinfo','5c459b56b6210',2,'',1,'','门市标记',0,'op_signinfo'),
	(1009,'staff_id','5c459b56b6210',1,'',1,'','',0,'staff_id'),
	(1010,'staff_name','5c459b56b6210',2,'',1,'','操作人',0,'staff_name'),
	(1011,'id','5c459c06aae60',1,'',1,'','',0,'id'),
	(1012,'staff_id','5c459c06aae60',1,'',1,'','',0,'staff_id'),
	(1013,'staff_name','5c459c06aae60',2,'',1,'','操作人',0,'staff_name'),
	(1014,'customer_tel','5c459c06aae60',2,'',0,'','客资手机',0,'customer_tel'),
	(1015,'customer_sex','5c459c06aae60',2,'',0,'男/女','',0,'customer_sex'),
	(1016,'customer_wechat','5c459c06aae60',2,'',0,'','',0,'customer_wechat'),
	(1017,'customer_qq','5c459c06aae60',2,'',0,'','',0,'customer_qq'),
	(1018,'is_intostore','5c459c06aae60',1,'',0,'1：未进店；2：进店进客；3：进店非进客','是否进店',0,'is_intostore'),
	(1019,'syjd_day','5c459c06aae60',2,'',0,'年月日 时分秒','实际进店时间',0,'syjd_day'),
	(1020,'is_success','5c459c06aae60',1,'2',0,'1：已订单；2：未订单；3：已订金','是否成交',0,'is_success'),
	(1021,'order_day','5c459c06aae60',2,'',0,'2018-10-12 12:02:15','订单时间',0,'order_day'),
	(1022,'intostore_note','5c459c06aae60',2,'',0,'','进店备注',0,'intostore_note'),
	(1023,'customer_birthday','5c459c06aae60',2,'',0,'2005-12-12','客资生日',0,'customer_birthday'),
	(1024,'mate_name','5c459c06aae60',2,'',0,'','配偶姓名',0,'mate_name'),
	(1025,'mate_sex','5c459c06aae60',2,'',0,'','',0,'mate_sex'),
	(1026,'mate_tel','5c459c06aae60',2,'',0,'','',0,'mate_tel'),
	(1027,'mate_wechat','5c459c06aae60',2,'',0,'','',0,'mate_wechat'),
	(1028,'mate_qq','5c459c06aae60',2,'',0,'','',0,'mate_qq'),
	(1029,'marry_day','5c459c06aae60',2,'',0,'2015-12-12','结婚日期',0,'marry_day'),
	(1030,'yp_day','5c459c06aae60',2,'',0,'2012-12-12 12:12：12','预拍时间',0,'yp_day'),
	(1031,'customer_area_id','5c459c06aae60',1,'',0,'','',0,'customer_area_id'),
	(1032,'customer_area','5c459c06aae60',2,'',0,'','客户分区',0,'customer_area'),
	(1033,'customer_cource_id','5c459c06aae60',1,'',0,'','',0,'customer_cource_id'),
	(1034,'customer_cource','5c459c06aae60',2,'',0,'','客资来源',0,'customer_cource'),
	(1035,'consulation_shop_code','5c459c06aae60',2,'',0,'','',0,'consulation_shop_code'),
	(1036,'consulation_shop_name','5c459c06aae60',2,'',0,'','意向店面',0,'consulation_shop_name'),
	(1037,'customer_tel','5c47046db54c8',2,'',1,'','男手机',0,'customer_tel'),
	(1038,'mate_tel','5c47046db54c8',2,'',0,'','女手机',0,'mate_tel'),
	(1039,'brandclass','5c47046db54c8',2,'',1,'','事业部',0,'brandclass'),
	(1040,'staff_id','5c47046db54c8',1,'',1,'','',0,'staff_id'),
	(1041,'staff_name','5c47046db54c8',2,'',1,'','操作人',0,'staff_name'),
	(1042,'search_time','5c4704a203138',2,'',0,'','查询时间方式，如：yjd_day,syjd_day，默认yjd_day',0,'search_time'),
	(1043,'flag','5c4704a203138',1,'',0,'','查询标记，如：1：未进店+邀约流失；2：成交（成交+定金）;3:流失（流失+进店流失）；4：进店（进客+非进客+进店流失）',0,'flag'),
	(1044,'content','5c4704a203138',2,'',0,'','精确搜索内容',0,'content'),
	(1045,'start','5c4704a203138',2,'',0,'2018-01-01 12:12:12','搜索开始时间',0,'start'),
	(1046,'end','5c4704a203138',2,'',0,'2018-01-01 12:12:12','搜索结束时间',0,'end'),
	(1047,'reception_id','5c4704a203138',1,'',0,'','接待人id',0,'reception_id'),
	(1048,'customer_intention_id','5c4704a203138',1,'',0,'','客户意向id',0,'customer_intention_id'),
	(1049,'consulation_shop_code','5c4704a203138',2,'',0,'','意向店面编码',0,'consulation_shop_code'),
	(1050,'consultation_type_id','5c4704a203138',1,'',0,'','消费类型id',0,'consultation_type_id'),
	(1051,'customer_cource_id','5c4704a203138',1,'',0,'','客户来源id',0,'customer_cource_id'),
	(1052,'dj_staff_id','5c4704a203138',1,'',0,'','登记人id',0,'dj_staff_id'),
	(1053,'staff_id','5c4704a203138',1,'',1,'','',0,'staff_id'),
	(1054,'staff_name','5c4704a203138',1,'',1,'','',0,'staff_name'),
	(1055,'id','5c4704d990ad8',1,'',1,'','进店表id',0,'id'),
	(1056,'order_sn','5c4704d990ad8',2,'',1,'','单号',0,'order_sn'),
	(1057,'target_time','5c4704d990ad8',2,'',0,'2018-01-01 12:12:12','开单时间',0,'target_time'),
	(1058,'consulation_shop_code','5c4704d990ad8',2,'',0,'','',0,'consulation_shop_code'),
	(1059,'consulation_shop_name','5c4704d990ad8',2,'',0,'','意向店面',0,'consulation_shop_name'),
	(1060,'reception_id','5c4704d990ad8',1,'',0,'','',0,'reception_id'),
	(1061,'reception_name','5c4704d990ad8',2,'',0,'','接待人',0,'reception_name'),
	(1062,'staff_id','5c4704d990ad8',1,'',1,'','',0,'staff_id'),
	(1063,'staff_name','5c4704d990ad8',2,'',1,'','',0,'staff_name'),
	(1064,'brandclass_id','5c4704b515630',1,'',1,'','',0,'brandclass_id'),
	(1065,'shop_code','5c4704b515630',2,'',1,'','操作人shop_code',0,'shop_code'),
	(1066,'staff_id','5c4704b515630',1,'',1,'','',0,'staff_id'),
	(1067,'staff_name','5c4704b515630',1,'',1,'','',0,'staff_name'),
	(1068,'order_sn','5c4704b515630',2,'',0,'','',0,'order_sn'),
	(1069,'create_time','5c4704b515630',2,'',1,'','操作时间',0,'create_time'),
	(1070,'consultation_type_id','5c4704b515630',1,'',0,'','',0,'consultation_type_id'),
	(1071,'consultation_type','5c4704b515630',2,'',0,'','消费类型',0,'consultation_type'),
	(1072,'customer_cource_id','5c4704b515630',1,'',0,'','客户来源id',0,'customer_cource_id'),
	(1073,'customer_cource','5c4704b515630',2,'',0,'','客户来源',0,'customer_cource'),
	(1074,'customer_area_id','5c4704b515630',1,'',0,'','',0,'customer_area_id'),
	(1075,'customer_area','5c4704b515630',2,'',0,'','客户分区',0,'customer_area'),
	(1076,'marry_day','5c4704b515630',1,'',0,'','结婚日期',0,'marry_day'),
	(1077,'baby_birthday','5c4704b515630',2,'',0,'','宝宝生日',0,'baby_birthday'),
	(1078,'wname','5c4704b515630',2,'',1,'','女士姓名',0,'wname'),
	(1079,'wphone','5c4704b515630',2,'',1,'','女士手机',0,'wphone'),
	(1080,'mname','5c4704b515630',2,'',0,'','男士姓名',0,'mname'),
	(1081,'wphone','5c4704b515630',2,'',0,'','男士手机',0,'wphone'),
	(1082,'wwechat','5c4704b515630',2,'',0,'','女士微信',0,'wwechat'),
	(1083,'mwechat','5c4704b515630',2,'',0,'','男士微信',0,'mwechat'),
	(1084,'wbirthday','5c4704b515630',2,'',0,'','女士生日',0,'wbirthday'),
	(1085,'mbirthday','5c4704b515630',2,'',0,'','男士生日',0,'mbirthday'),
	(1086,'introducer_name','5c4704b515630',2,'',0,'','介绍人',0,'introducer_name'),
	(1087,'introducer_tel','5c4704b515630',2,'',0,'','介绍人电话',0,'introducer_tel'),
	(1088,'province','5c4704b515630',2,'',0,'','省',0,'province'),
	(1089,'city','5c4704b515630',2,'',0,'','市',0,'city'),
	(1090,'county','5c4704b515630',2,'',0,'','区县',0,'county'),
	(1091,'customer_address','5c4704b515630',2,'',0,'','接单点',0,'customer_address'),
	(1092,'loss_reason','5c4a7b30027d8',2,'',0,'','流失原因',0,'loss_reason'),
	(1097,'loss_time','5c4596536c660',2,'',0,'','格式：2019-01-12 12:20:45',0,'loss_time'),
	(1098,'op_signday','5c459b56b6210',2,'',0,'','格式：2019-01-20 15:45:12',0,'op_signday'),
	(1099,'syjd_day','5c4a7b30027d8',2,'',0,'','规则：2019-05-12 16:31:12',0,'syjd_day'),
	(1100,'brandclass_id','5c6a8c262b8e0',1,'',0,'事业部ID','事业部ID',0,'brandclass_id'),
	(1101,'search_time','5c6a8c262b8e0',2,'',0,'查询的时间类型（dj_day）等','查询的时间类型（dj_day）等',0,'search_time'),
	(1102,'start','5c6a8c262b8e0',1,'',0,'开始时间','开始时间',0,'start'),
	(1103,'end','5c6a8c262b8e0',1,'',0,'结束时间','结束时间',0,'end'),
	(1107,'customer_number','5a56b32c2b6fa',2,'',0,'客资编号','客资编号',0,'customer_number'),
	(1108,'customer_number','5b3b640593da1',2,'',0,'客资编号','客资编号',0,'customer_number'),
	(1109,'create_time','5b3b640593da1',2,'',0,'erp的target_time','erp的target_time',0,'create_time'),
	(1110,'order_amount','5c4704d990ad8',2,'',0,'套系总额','套系总额',0,'order_amount'),
	(1111,'id','5ce3624dca72a',1,'',1,'','进客id',0,'time'),
	(1112,'time','5ce3624dca72a',1,'',1,'','实际进店时间的时分秒，格式：143035',0,'id'),
	(1113,'paymentdate','5b3b64b260d39',2,'',1,'收款时间','收款时间',0,'paymentdate'),
	(1114,'collectmoneynumber','5b3b64b260d39',2,'',1,'收款流水号','收款流水号',0,'collectmoneynumber'),
	(1115,'isdel','5b3b64b260d39',1,'0',1,'是否删除本次收款（0：不删除；1：删除）','是否删除本次收款（0：不删除；1：删除）',0,'isdel'),
	(1116,'consultation_type_id','5c4704d990ad8',1,'',0,'','消费类型id',0,'consultation_type_id'),
	(1117,'consultation_type','5c4704d990ad8',2,'',0,'','消费类型',0,'consultation_type'),
	(1118,'brandclass_id','5b285b5c829d8',1,'',0,'','',0,'brandclass_id'),
	(1119,'brandclass','5b285b5c829d8',1,'',0,'','',0,'brandclass'),
	(1120,'introducer_name','5b286c6bbf298',2,'',0,'介绍人姓名','介绍人姓名',0,'introducer_name'),
	(1121,'introducer_ordernum','5b286c6bbf298',2,'',0,'介绍人单号','介绍人单号',0,'introducer_ordernum'),
	(1123,'introducer_tel','5b286c6bbf298',1,'',0,'介绍人电话','介绍人电话',0,'introducer_tel'),
	(1124,'dj_staff_id','5b286c6bbf298',1,'',1,'提报人ID','提报人ID',0,'dj_staff_id'),
	(1125,'dj_staff','5b286c6bbf298',2,'',1,'提报人','提报人',0,'dj_staff'),
	(1126,'brandclass_id','5b286c6bbf298',1,'',1,'事业部ID','事业部ID',0,'brandclass_id'),
	(1127,'brandclass','5b286c6bbf298',2,'',1,'事业部','事业部',0,'brandclass'),
	(1128,'shop_code','5b286c6bbf298',2,'',1,'客资接入店shop_code','客资接入店shop_code',0,'shop_code'),
	(1129,'shop_name','5b286c6bbf298',2,'',1,'客资接入店shop_name','客资接入店shop_name',0,'shop_name'),
	(1132,'contact_w','5b285b5c829d8',2,'',0,'联系方式_女士','联系方式_女士',0,'contace_w'),
	(1133,'brandclass','5b285b5c829d8',1,'',0,'事业部ID','事业部ID',0,'brandclass'),
	(1134,'brandclass_id','5b285b5c829d8',2,'',0,'事业部','事业部',0,'brandclass_id'),
	(1135,'info','5b286c6bbf298',2,'',1,'name-tel*','name-tel*',0,'info'),
	(1136,'add_shop_code','5d64ca8e6f540',2,'',1,'提报店shop_code','',0,'add_shop_code'),
	(1137,'customer_channel','5b286c6bbf298',2,'',1,'','',0,'customer_channel'),
	(1138,'customer_channel_id','5b286c6bbf298',1,'',1,'','',0,'customer_channel_id'),
	(1139,'add_shop_code','5d64ca8e6f540',2,'',1,'提报店shop_code','提报店shop_code',0,'add_shop_code');

/*!40000 ALTER TABLE `crm_api_fields` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_api_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_api_list`;

CREATE TABLE `crm_api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COLLATE utf8_unicode_ci COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用于维护接口信息';

LOCK TABLES `crm_api_list` WRITE;
/*!40000 ALTER TABLE `crm_api_list` DISABLE KEYS */;

INSERT INTO `crm_api_list` (`id`, `apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`)
VALUES
	(1,'验证客资是否存在','Customer/checkCustomer',5,'5a4cab8e0e678',0,0,1,1,'验证客资是否存在',0,''),
	(2,'ERP开单，添加消费产品，付款接口','Customer/receivables',5,'5a4cb959b1c8b',1,0,1,1,'ERP开单，添加消费产品，付款接口',0,''),
	(3,'验证订单','Customer/checkOrder',5,'5a4cbaf782dc0',0,0,1,1,'验证订单是否存在',0,''),
	(4,'修改客资状态','Customer/changeCustomerStatus',5,'5a4d9063d2ca8',0,0,1,1,'修改客资状态：进店进客，进店非进客，未进店，流失',0,''),
	(7,'登录接口erp','Staff/login',2,'59f2e9fb5f863',0,0,1,1,'登录接口',1,NULL),
	(9,'退出登录','Staff/logOut',2,'59f424811d52f',0,0,1,1,'退出登录',1,NULL),
	(10,'修改密码','Staff/updatePassword',2,'59f44a14c3cae',0,0,1,1,'修改密码',1,NULL),
	(12,'test','test/te33f',3,'59f8322eb4d03',1,1,1,1,'fdff',0,NULL),
	(13,'登录','erp/Auth/login',4,'59f96a8def678',1,0,1,1,'',0,NULL),
	(18,'创建新订单','Customer/createOrder',5,'5a56b32c2b6fa',0,0,1,1,'没有进店登记，直接创建新订单',0,NULL),
	(19,'erp转库专用接口1，创建客资','Customer/addCustomer',5,'5a9d032325040',0,0,1,1,'erp转库专用接口1，创建客资',1,NULL),
	(20,'erp转库专用接口2，创建订单，并且添加消费产品','Customer/addCustomerOrder',5,'5a9d038620298',0,0,1,1,'erp转库专用接口2，创建订单，并且添加消费产品',1,NULL),
	(21,'erp转库专用接口3，更新订单收款信息','Customer/updateCustomerOrder',5,'5a9d03d28c863',0,0,1,1,'erp转库专用接口3，更新订单收款信息',1,NULL),
	(22,'删除订单','Customer/delOrder',5,'5abf60677c448',0,0,1,1,'删除订单接口',1,NULL),
	(26,'获取员工的A客和毛客资数','Customer/getStaffAllCustomer',5,'5acd6abcb09be',0,0,1,1,'获取员工的A客和毛客资数',0,NULL),
	(27,' 客资列表','Customer/getCustomerList',5,'5b1a178493b48',0,0,1,1,'获取客资列表',0,NULL),
	(28,' 获取客资详情','Customer/getCustomerInfo',5,'5b1a18f6249f0',0,0,1,1,'',0,NULL),
	(29,' 获取客资追踪记录','Customer/getSalesLog',5,'5b1a1f8ebd740',0,0,1,1,'',0,NULL),
	(30,'查询客资信息','Child/getCustomerInfomation',6,'5b3b60b24ada9',0,0,1,1,'根据手机号获取客资信息，用于erp自动填充信息',0,NULL),
	(31,'进客登记','Child/createCustomer',6,'5b3b61169ed69',0,0,1,1,'erp进客登记用',0,NULL),
	(32,'修改客资状态','Child/changeCustomerStatus',6,'5b3b63334a9c1',0,0,1,1,'标记客资进店，流失',0,NULL),
	(33,'编辑客资信息','Child/erpEditCustomer',6,'5b3b63ad39081',0,0,1,1,'根据客资编号，编辑客资信息',0,NULL),
	(34,'创建订单','Child/createOrder',6,'5b3b640593da1',0,0,1,1,'右键转订单（客资编号），直接开单',0,NULL),
	(35,'添加消费项目','Child/addOrderTotal',6,'5b3b645687669',0,0,1,1,'根据订单编号，添加消费项目，套系总额',0,NULL),
	(36,'收款接口','Child/cashMoney',6,'5b3b64b260d39',0,0,1,1,'根据订单编号，收款',0,NULL),
	(37,'删除订单','Child/delOrder',6,'5b3b64f2b9f01',0,0,1,1,'根据订单编号，删除订单（物理删除）',0,NULL),
	(38,'开单/加套系/收款','Child/receivables',6,'5b3b6722b9f01',0,0,1,1,'开单/加套系/收款',0,NULL),
	(45,'退单','Customer/refund',5,'5b1a174a2cd3',0,0,1,1,'退单',0,NULL),
	(46,'新增erp追踪记录','Customer/erpAddTrackinfo',5,'5b935efda2990',0,0,1,1,'erp进客登记中的标记功能，crm记录一次客资追踪记录',0,NULL),
	(47,'erp通知crm成单','Customer/erpCallCrmCreateOrder',5,'5bd42d703b150',0,0,1,1,'用于转单后ERP通知CRM订单',0,NULL),
	(48,'活动提报客资接口','Vip/addCustomer',7,'5be54b43c8bb8',0,0,1,1,'用于活动中的客资提报',0,NULL),
	(49,'校验进客信息是否算网销订单，','Customer/preCheckCustomer',5,'465abc8e0e679',0,0,1,1,'校验进客信息是否算网销订单，包括传CRM客资编号的也有可能不算网销订单',0,NULL),
	(60,'根据联系方式，查询客资信息','Customer/getCustomerInfomation',5,'5b285b5c829d8',0,0,1,1,'根据联系方式，查询客资信息',0,NULL),
	(61,'获取排程余量','Child/paichengNum',4,'5c207f0794700',0,0,1,1,'获取上门拍排程余量',0,NULL),
	(62,'排程','Child/paicheng',4,'5c207f8394318',0,0,1,1,'上门拍排程',0,NULL),
	(63,'获取短信模板','Child/getModel',4,'5c2095b23efd0',0,0,1,1,'获取短信模板',0,NULL),
	(64,' 获取渠道名称列表','Customer/getAllChannel',5,'5c3ff3eb4ef48',0,0,1,1,'返回所有渠道名称（包含一二三级）',0,NULL),
	(65,'客资列表','Vip/getCustomerList',6,'5c6a8c262b8e0',0,0,1,1,'查询客资列表',0,NULL),
	(74,'回门','Intostore/returnDoor',8,'5c459396a8750',0,0,1,1,'',0,NULL),
	(75,'删除进店','Intostore/deleteInto',8,'5c4595ab2b750',0,0,1,1,'',0,NULL),
	(76,'流失','Intostore/loss',8,'5c4596536c660',0,0,1,1,'',0,NULL),
	(77,'领取礼品','Intostore/gift',8,'5c459af2ccd58',0,0,1,1,'领取礼品',0,NULL),
	(78,'门市标记','Intostore/customerSign',8,'5c459b56b6210',0,0,1,1,'',0,NULL),
	(79,'分配接待人','Intostore/allotReception',8,'5c459ba5c96a8',0,0,1,1,'',0,NULL),
	(80,'客资编辑','Intostore/customerEdit',8,'5c459c06aae60',0,0,1,1,'',0,NULL),
	(81,'创建新客资前检查客资是否重复','Intostore/checkCustomerRepeat',8,'5c47046db54c8',0,0,1,1,'',0,NULL),
	(82,'进客列表','Intostore/customerList',8,'5c4704a203138',0,0,1,1,'',0,NULL),
	(83,'创建新客资','Intostore/createCustomer',8,'5c4704b515630',0,0,1,1,'',0,NULL),
	(84,'erp转单','Intostore/createNewOrder',8,'5c4704d990ad8',0,0,1,1,'',0,NULL),
	(85,'进客/非进客','Intostore/intostore',8,'5c4a7b30027d8',0,0,1,1,'',0,''),
	(86,'修改实际进店时间','Intostore/editSyjd',8,'5ce3624dca72a',1,0,1,1,'',0,NULL),
	(87,'erp提报转介绍客资','Child/erpAddCustomer',5,'5b286c6bbf298',0,0,1,1,'erp提报转介绍客资',0,NULL),
	(88,'根据提报店，获取对应渠道','Customer/getChannelByAddshopcode',4,'5d64ca8e6f540',0,0,1,1,'根据提报店，获取对应渠道',1,'');

/*!40000 ALTER TABLE `crm_api_list` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_api_logs
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_api_logs`;

CREATE TABLE `crm_api_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hash` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `api_url` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `result_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci,
  `api_start_time` decimal(16,5) DEFAULT NULL,
  `api_end_time` decimal(16,5) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_app_version`;

CREATE TABLE `crm_app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  `up_sql2` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

LOCK TABLES `crm_app_version` WRITE;
/*!40000 ALTER TABLE `crm_app_version` DISABLE KEYS */;

INSERT INTO `crm_app_version` (`id`, `version`, `up_time`, `up_sql`, `up_sql2`)
VALUES
	(4,'1.1.6','2019-09-04 09:13:38',NULL,NULL),
	(5,'1.1.58','2020-11-13 11:20:08',' ALTER TABLE `crm_l_pc_log`  ADD COLUMN `sm_type` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_c_excel_import_data`  ADD COLUMN `sign_id` int(11)  NULL , ADD COLUMN `sign_name` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `sign_time` datetime  NULL \r\n ALTER TABLE `crm_c_excel_import_data`  ADD COLUMN `baby_time` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_l_pc_setting_log`  ADD COLUMN `sm_type` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_l_pc_log`  ADD COLUMN `is_chaoju` tinyint(1)  NULL  DEFAULT 2 \r\n ALTER TABLE `crm_s_channel`  ADD COLUMN `channel_qrcode` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `sign_id` int(11)  NULL , ADD COLUMN `sign_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `bind_sign_ids` varchar(1000)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_c_customer_main`  ADD COLUMN `province` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `city` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `county` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_c_excel_import_data`  ADD COLUMN `hospital_photo_cameraman` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `hospital_photo_assistant` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `hospital_photo_time` datetime  NULL \r\n ALTER TABLE `crm_c_excel_import_data`  ADD COLUMN `recommend_staff` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_c_customerinfo`  ADD COLUMN `baby_time` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `crm_s_channel`  ADD COLUMN `staff_id` int(11)  NULL , ADD COLUMN `staff_name` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `create_time` datetime  NULL \r\n ALTER TABLE `crm_l_pc_log`  ADD COLUMN `is_gq` int(4)  NULL  DEFAULT 1 \r\nCREATE TABLE `crm_s_goal_name`(`id` int  NOT NULL  AUTO_INCREMENT ,`goal_name` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `crm_s_goal`(`id` int  NOT NULL  AUTO_INCREMENT ,`goal_name` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`key` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`method` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`goal_value` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`year` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`month` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`day` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(4)  NOT NULL  DEFAULT 1 ,`create_time` datetime  NULL ,`update_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `crm_c_excel_import_data`  ADD COLUMN `baby_weight` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `baby_stature` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' \r\nCREATE TABLE `crm_s_bggoalset`(`id` int  NOT NULL  AUTO_INCREMENT ,`shop_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`target` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`jinri` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`biaozhun` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`dachenglv` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`yuehui` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`yuedachenglv` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`huanbi` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`manzulv` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`day` datetime(0)  NULL ,`create_time` datetime(0)  NULL ,`update_time` datetime(0)  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB  INSERT INTO `crm_api_fields`  (`fieldName`,`hash`,`dataType`,`isMust`,`range`,`info`,`type`,`showName`)  SELECT \'add_shop_code\',\'5d64ca8e6f540\',\'2\',\'1\',\'提报店shop_code\',\'提报店shop_code\',\'0\',\'add_shop_code\' \r\nCREATE TABLE IF NOT EXISTS `crm_s_advert_list` (\n                  `id` int(11) NOT NULL AUTO_INCREMENT,\n                  `advert_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'表单编号\',\n                  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'表单名称\',\n                  `request_num` int(11) DEFAULT \'0\' COMMENT \'提交客资数量\',\n                  `repeat_num` int(11) DEFAULT \'0\' COMMENT \'与客资系统重复的数量\',\n                  `click_num` int(11) DEFAULT \'0\' COMMENT \'点击数\',\n                  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `template` text COLLATE utf8_unicode_ci COMMENT \'组件\',\n                  `style` text COLLATE utf8_unicode_ci COMMENT \'样式\',\n                  `openfeedbackpwd` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'是否为必选项\',\n                  `submitonce` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'只提交一次\',\n                  `onlywechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'仅微信提交\',\n                  `consumption_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'消费类型\',\n                  `js_customer_service` text COLLATE utf8_unicode_ci COMMENT \'客服代码js\',\n                  `btn_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'按钮名称\',\n                  `create_time` datetime DEFAULT NULL,\n                  `update_time` datetime DEFAULT NULL,\n                  PRIMARY KEY (`id`),\n                  UNIQUE KEY `advert_code` (`advert_code`) USING BTREE,\n                  KEY `add_shop_code` (`add_shop_code`) USING BTREE\n                ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT=\'广告落地页列表\';\n            \r\nCREATE TABLE IF NOT EXISTS `crm_s_advert_customer` (\n                  `id` int(11) NOT NULL AUTO_INCREMENT,\n                  `advert_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'表单编号\',\n                  `customer_channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `customer_channel_id` int(11) DEFAULT NULL,\n                  `consultation_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'消费类型\',\n                  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `customer_tel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `customer_wechat` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `brandclass_id` int(11) DEFAULT NULL,\n                  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `form_content` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'咨询内容\',\n                  `ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `from_address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'来源地址\',\n                  `create_time` datetime DEFAULT NULL,\n                  `is_in` tinyint(4) DEFAULT NULL COMMENT \'是否存在于客资\',\n                  `c_id` int(11) DEFAULT NULL COMMENT \'客资id\',\n                  PRIMARY KEY (`id`),\n                  KEY `advert_code` (`advert_code`) USING BTREE\n                ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT=\'活动落地页提交客资表\';\n            \r\nCREATE TABLE IF NOT EXISTS `crm_s_advert_channel` (\n                  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,\n                  `channel_id` int(11) NOT NULL,\n                  `channel_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,\n                  `sort` tinyint(4) NOT NULL DEFAULT \'1\' COMMENT \'排序\',\n                  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,\n                  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,\n                  `staff_id` int(11) DEFAULT NULL,\n                  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `brandclass_id` int(11) DEFAULT NULL,\n                  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                  `create_time` datetime DEFAULT NULL,\n                  PRIMARY KEY (`id`)\n                ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\n            \r\n INSERT INTO `crm_s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'批量待定\',\'61\',\'menu1571722592\',\'/crm/Customer/customerMoreDd\',\'1\',\'0\' \r\n INSERT INTO `crm_s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'1500\',\'人员追踪数据\',\'138\',\'menu1573033477\',\'/crm/Customer/staffTrackLog\',\'1\',\'2\' \r\n INSERT INTO `crm_s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'1501\',\'查询本店通话记录\',\'1500\',\'menu1573096502\',\'\',\'0\',\'1\' \r\n INSERT INTO `crm_s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'1502\',\'查询本人通话记录\',\'1500\',\'menu1573096503\',\'\',\'0\',\'2\' \r\nCREATE TABLE IF NOT EXISTS `crm_s_channel_keywords` (\n                      `id` int(11) unsigned NOT NULL AUTO_INCREMENT,\n                      `channel_id` int(11) DEFAULT NULL,\n                      `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'渠道名称\',\n                      `keyword` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'关键字(不可重复)\',\n                      `staff_id` int(11) DEFAULT NULL,\n                      `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'创建人\',\n                      `create_time` datetime DEFAULT NULL COMMENT \'创建时间\',\n                      `qrcode` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      `valid_date` datetime DEFAULT NULL COMMENT \'有效时间\',\n                      `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      `is_delete` tinyint(1) DEFAULT \'2\' COMMENT \'是否删除：1：删除；2：未删除\',\n                      PRIMARY KEY (`id`)\n                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT=\'渠道关键字表\';\n                    \r\nCREATE TABLE IF NOT EXISTS `crm_s_wx_menu` (\n                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,\n                      `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'菜单名称\',\n                      `fid` int(11) DEFAULT NULL,\n                      `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'功能菜单唯一标识\',\n                      `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'菜单url\',\n                      `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'菜单图标\',\n                      `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'当菜单类型是小程序时要用到\',\n                      `status` tinyint(4) DEFAULT NULL COMMENT \'状态:99:删除\',\n                      `sort` int(10) unsigned DEFAULT NULL COMMENT \'排序\',\n                      `level` tinyint(1) unsigned DEFAULT NULL COMMENT \'菜单等级\',\n                      `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT \'view\' COMMENT \'菜单类型：view：网页；miniprogram：小程序；\',\n                      `keyword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'消息回复关键字\',\n                      `pagepath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'小程序用，页面路径\',\n                      PRIMARY KEY (`id`)\n                    ) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT=\'微信自定义菜单表\';\n                    \r\n INSERT INTO `crm_s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'上门类型设定\',\'2060\',\'menu1574042737\',\'/crm/Visit/smTypeSet\',\'1\',\'2\' \r\nCREATE TABLE IF NOT EXISTS `crm_s_pc_type_set` (\n                      `id` int(11) unsigned NOT NULL AUTO_INCREMENT,\n                      `sm_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'上门类型\',\n                      `create_time` datetime DEFAULT NULL COMMENT \'添加时间\',\n                      `staff_id` int(11) DEFAULT NULL,\n                      `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT \'操作人\',\n                      `status` tinyint(1) DEFAULT \'2\' COMMENT \'是否删除：1：删除；2：未删除\',\n                      PRIMARY KEY (`id`)\n                    ) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\n                                        \r\n INSERT INTO `crm_s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'查询本店上门拍\',\'2033\',\'menu1576489359\',\'/crm/Visit/toHome\',\'1\',\'2\' union  SELECT \'查询本人上门拍\',\'2033\',\'menu1576489412\',\'/crm/Visit/toHome\',\'1\',\'2\' union  SELECT \'分配上门人员\',\'2033\',\'menu1577329871\',\'/crm/Visit/cameramanFP\',\'1\',\'2\' union  SELECT \'上门分组\',\'2033\',\'menu1577329895\',\'/crm/Visit/setSmGroup\',\'1\',\'2\' union  SELECT \'上门开单\',\'2033\',\'menu1577329926\',\'/crm/Visit/order\',\'1\',\'2\' union  SELECT \'上门核销\',\'2033\',\'menu1577329949\',\'/crm/Visit/markHX\',\'1\',\'2\' union  SELECT \'上门删除\',\'2033\',\'menu1577329973\',\'\',\'1\',\'2\' union  SELECT \'上门改期\',\'2033\',\'menu1577329992\',\'/crm/Visit/changeVisit\',\'1\',\'2\' union  SELECT \'上门反馈\',\'2033\',\'menu1577330039\',\'\',\'1\',\'2\' \r\nCREATE TABLE IF NOT EXISTS `crm_c_client_introduct` (\n                      `id` int(11) NOT NULL AUTO_INCREMENT,\n                      `mid` int(11) DEFAULT NULL COMMENT \'main表主键id\',\n                      `type` tinyint(4) DEFAULT NULL COMMENT \'转介绍类型：1亲属；2朋友\',\n                      `introduct_mid` int(11) DEFAULT NULL,\n                      `create_time` datetime DEFAULT NULL,\n                      PRIMARY KEY (`id`),\n                      KEY `mid` (`mid`) USING BTREE,\n                      KEY `introduct_mid` (`introduct_mid`) USING BTREE,\n                      KEY `type` (`type`) USING BTREE\n                    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;\r\n INSERT INTO `crm_s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'会所名称设定\',\'900\',\'menu1591943564\',\'/crm/Setting/clubNameset\',\'1\',\'0\' \r\nCREATE TABLE IF NOT EXISTS `crm_s_club` (\n                      `id` int(11) NOT NULL AUTO_INCREMENT COMMENT \'会所表\',\n                      `club_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      `brandclass_id` int(11) DEFAULT \'0\',\n                      `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,\n                      PRIMARY KEY (`id`)\n                    ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;',NULL),
	(6,'1.1.59','2020-11-13 13:50:28','',NULL);

/*!40000 ALTER TABLE `crm_app_version` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_c_call_registration
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_call_registration`;

CREATE TABLE `crm_c_call_registration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_id` int(11) DEFAULT NULL,
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_region` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资地域',
  `customer_area` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `customer_cource` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源',
  `op_signinfo` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记',
  `access_model` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `customer_channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道',
  `customer_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_remark` text COLLATE utf8_unicode_ci,
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_staff_id` int(11) DEFAULT NULL,
  `dj_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_orderaddress` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `introducer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '邀约人姓名',
  `tel_alltime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通话总时长',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `audio_path` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='来电记录表';



# Dump of table crm_c_client_introduct
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_client_introduct`;

CREATE TABLE `crm_c_client_introduct` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) DEFAULT NULL COMMENT 'main表主键id',
  `type` tinyint(4) DEFAULT NULL COMMENT '转介绍类型：1亲属；2朋友',
  `introduct_mid` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mid` (`mid`) USING BTREE,
  KEY `introduct_mid` (`introduct_mid`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `crm_c_client_introduct` WRITE;
/*!40000 ALTER TABLE `crm_c_client_introduct` DISABLE KEYS */;

INSERT INTO `crm_c_client_introduct` (`id`, `mid`, `type`, `introduct_mid`, `create_time`)
VALUES
	(1,1,2,10,'2020-11-17 10:55:33'),
	(2,NULL,2,11,'2020-11-17 10:55:47'),
	(3,NULL,2,NULL,'2020-11-17 10:58:51'),
	(4,11,2,12,'2020-11-17 10:59:51'),
	(5,NULL,2,13,'2020-11-17 11:00:25');

/*!40000 ALTER TABLE `crm_c_client_introduct` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_c_customer_contact
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_contact`;

CREATE TABLE `crm_c_customer_contact` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `c_id` int(11) DEFAULT NULL,
  `c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户表（main）的唯一标识',
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资（获取）渠道',
  `contact` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `c_id` (`c_id`) USING BTREE,
  KEY `c_unique` (`c_unique`) USING BTREE,
  KEY `contact` (`contact`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='联系方式表，排重';


DELIMITER ;;
/*!50003 SET SESSION SQL_MODE="STRICT_ALL_TABLES,NO_AUTO_CREATE_USER" */;;
/*!50003 CREATE */ /*!50017 DEFINER=`root`@`127.0.0.1` */ /*!50003 TRIGGER `setCustomerNumber` AFTER INSERT ON `crm_c_customer_contact` FOR EACH ROW BEGIN

DECLARE n INT;

DECLARE NUMBER VARCHAR(50)character set utf8;

DECLARE TODAY VARCHAR(10);

SET TODAY=curdate();

SELECT IFNULL(max(RIGHT(customer_number, 6)), 0)  into n FROM crm_c_customerinfo WHERE dj_day >TODAY;

SET NUMBER=concat(replace(TODAY,'-',''),RIGHT (1000001 + n, 6));

update crm_c_customerinfo set customer_number = NUMBER where id=NEW.c_id;

END */;;
DELIMITER ;
/*!50003 SET SESSION SQL_MODE=@OLD_SQL_MODE */;


# Dump of table crm_c_customer_cost
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_cost`;

CREATE TABLE `crm_c_customer_cost` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cost_time` date DEFAULT NULL,
  `cost_avg` decimal(10,4) DEFAULT '0.0000',
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT '0',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `return_avg` decimal(10,4) DEFAULT NULL,
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass_id` int(11) DEFAULT NULL,
  `belong_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道、成本、返点 花费分摊表';



# Dump of table crm_c_customer_intostore
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_intostore`;

CREATE TABLE `crm_c_customer_intostore` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL COMMENT '客资id',
  `yjd_day` datetime DEFAULT NULL COMMENT '预计进店时间',
  `syjd_day` datetime DEFAULT NULL COMMENT '实际进店时间',
  `consulation_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面',
  `consulation_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面',
  `reception_id` int(11) DEFAULT NULL COMMENT '接待门市id',
  `reception_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接待门市名字',
  `fp_rec_time` datetime DEFAULT NULL COMMENT '分配接待门市的时间',
  `operate_id` int(11) DEFAULT NULL COMMENT '操作人id',
  `operate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人name',
  `op_signinfo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '门市标记',
  `op_signday` datetime DEFAULT NULL COMMENT '门市标记时间',
  `sys_loss` tinyint(4) DEFAULT '1' COMMENT '系统自动标记（进店未成交）1：未流失；2：已流失；默认：1',
  `loss_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '流失原因',
  `loss_time` datetime DEFAULT NULL COMMENT '系统自动标记时间（进店未成交）默认：null',
  `is_intostore` int(11) DEFAULT '1' COMMENT '进店状态：1未进店；2进店进客；3进店非进客；4：邀约未进店（爽约）5：进店未成交（流失）',
  `is_success` tinyint(4) DEFAULT '2' COMMENT '订单状态：1 已成交；2 未成交；3 已定金；4 本单作废',
  `giftinfo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '礼品情况',
  `costs` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '礼品成本',
  `status` tinyint(4) DEFAULT '1' COMMENT '状态（1：正常；2：取消预约，默认：1）,99:删除',
  `reback` tinyint(4) DEFAULT '1' COMMENT '是否回门（1：正常邀约；2：回门客资；默认：1）',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `intostore_remark` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`) USING BTREE,
  KEY `consulation_shop_code` (`consulation_shop_code`) USING BTREE,
  KEY `reception_id` (`reception_id`) USING BTREE,
  KEY `status` (`status`) USING BTREE,
  KEY `is_intostore` (`is_intostore`) USING BTREE,
  KEY `is_success` (`is_success`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资进店表（客资每次邀约都记录）';



# Dump of table crm_c_customer_jdm
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_jdm`;

CREATE TABLE `crm_c_customer_jdm` (
  `c_id` int(11) DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jd_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jd_time` datetime DEFAULT NULL,
  `is_jd` tinyint(1) DEFAULT '2'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资进店码表，客资（可能）会有多条进店码';



# Dump of table crm_c_customer_main
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_main`;

CREATE TABLE `crm_c_customer_main` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '母亲姓名',
  `wphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '母亲手机',
  `wwechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '母亲微信',
  `wbirthday` date DEFAULT NULL COMMENT '母亲生日',
  `wcardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '母亲身份证号',
  `mname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '父亲姓名',
  `mphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '父亲手机',
  `mwechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '父亲微信',
  `mbirthday` date DEFAULT NULL COMMENT '父亲生日',
  `mcardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '父亲身份证',
  `homephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '家庭座机',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '邮箱',
  `marryday` date DEFAULT NULL COMMENT '结婚日期',
  `readybabyday` date DEFAULT NULL COMMENT '预产期',
  `babyname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝姓名',
  `babybirthday` date DEFAULT NULL COMMENT '宝宝生日',
  `babysex` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝性别',
  `babyhospital` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '宝宝出生地（医院）',
  `street` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '街道',
  `street_id` int(11) DEFAULT NULL COMMENT '街道id',
  `address` text COLLATE utf8_unicode_ci COMMENT '具体地址',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户唯一标识',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `province` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `county` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `c_unique` (`c_unique`) USING BTREE,
  KEY `wphone` (`wphone`),
  KEY `wname` (`wname`),
  KEY `mname` (`mname`),
  KEY `mphone` (`mphone`),
  KEY `brandclass_id` (`brandclass_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户表，主表';

# Dump of table crm_c_customer_order
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_order`;

CREATE TABLE `crm_c_customer_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_channel_id` int(10) DEFAULT NULL,
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户渠道',
  `order_status` tinyint(1) DEFAULT '1' COMMENT '状态（1:已成交；2：未成交）默认1；',
  `order_valid` int(2) DEFAULT '1' COMMENT '有效订单（1：无效；2：有效）默认1',
  `order_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `earnest_money` decimal(10,2) DEFAULT NULL COMMENT '定金',
  `order_fact` decimal(10,2) DEFAULT NULL COMMENT '实际收款(订单金额达到标准，订单成为有效订单时启用)',
  `order_amount` decimal(10,2) DEFAULT NULL COMMENT '订单总额',
  `consultation_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `customer_orderaddress` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_type` tinyint(1) DEFAULT '0' COMMENT '1：线上；2：线下',
  `order_source` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `two_pin_fact` decimal(9,0) DEFAULT NULL,
  `two_pin_amount` decimal(9,0) DEFAULT NULL,
  `order_note` text COLLATE utf8_unicode_ci,
  `target_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) NOT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `valid_time` datetime DEFAULT NULL,
  `unvalid_time` datetime DEFAULT NULL,
  `is_delete` tinyint(4) DEFAULT '2',
  `unvalid_reason` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refund` tinyint(2) DEFAULT '1',
  `reback` tinyint(2) DEFAULT '1',
  `photo_shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照店面',
  `photo_shop_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `into_id` int(11) DEFAULT NULL,
  `order_shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单店面',
  `order_shop_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单店面',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`customer_id`,`order_sn`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户订单表';



# Dump of table crm_c_customer_tel
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customer_tel`;

CREATE TABLE `crm_c_customer_tel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_belong` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_operator` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_area_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='手机归属地表';



# Dump of table crm_c_customerinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_customerinfo`;

CREATE TABLE `crm_c_customerinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eid` int(11) DEFAULT NULL COMMENT '导入时的id',
  `c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户性别',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户手机',
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微信',
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微博',
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL COMMENT '省id',
  `province` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在省',
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在市',
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '县（区）',
  `customer_address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地址',
  `mate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶姓名',
  `mate_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶性别',
  `mate_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶电话',
  `mate_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微信',
  `mate_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微博',
  `mate_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mate_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶地址',
  `consultation_type_id` int(11) DEFAULT NULL,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户类型，1新单、2转介绍',
  `consulation_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面编码',
  `consulation_shop` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面',
  `customer_channel_id` int(11) DEFAULT NULL,
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户渠道',
  `customer_cource_id` int(11) DEFAULT NULL,
  `customer_cource` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `customer_intention_id` int(11) DEFAULT NULL,
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_orderaddress_id` int(11) DEFAULT NULL,
  `customer_orderaddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `access_model_id` int(11) DEFAULT NULL,
  `access_model` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `customer_area_id` int(11) DEFAULT NULL,
  `customer_area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `customer_region_id` int(11) DEFAULT NULL,
  `customer_region` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地域',
  `is_intostore` tinyint(4) DEFAULT '1' COMMENT '是否进店，1未进店； 2进店进客；3进店非进客；4：邀约流失；5：进店流失',
  `is_success` tinyint(4) DEFAULT '2' COMMENT '是否成交，1 已成交，2 未成交，3已定金',
  `is_valid` tinyint(4) DEFAULT '2' COMMENT '是否有效，1 有效，2待定，3无效，录入时默认为2',
  `yx_day` datetime DEFAULT NULL COMMENT '标记有效日期',
  `is_loss` tinyint(4) DEFAULT '2' COMMENT '不再追踪，1是，2否',
  `is_next` tinyint(1) DEFAULT '2' COMMENT '是否再约：1：是；2：否',
  `next_time` datetime DEFAULT NULL COMMENT '再约时间',
  `is_send_next_msg` tinyint(1) DEFAULT '2' COMMENT '再约提醒信息是否已发送:1:是；2：否',
  `is_send_birthday_msg` tinyint(1) DEFAULT '2' COMMENT '生日提醒信息是否已发送:1:是；2：否',
  `is_send_wedd_msg` tinyint(1) DEFAULT '2' COMMENT '结婚纪念日提醒信息是否已发送:1:是；2：否',
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资标记',
  `op_signday` datetime DEFAULT NULL COMMENT '标记日期',
  `photo_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照地',
  `customer_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户生日',
  `customer_idtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户证件类型',
  `customer_idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户证件号',
  `mate_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶生日',
  `mate_idtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶证件类型',
  `mate_idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶证件号码',
  `introducer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人姓名',
  `introducer_ordernum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人单号',
  `introducer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人手机',
  `wedding_date` datetime DEFAULT NULL COMMENT '结婚日期',
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工',
  `dj_staff_id` int(11) DEFAULT NULL COMMENT '登记员工id',
  `dj_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工编号',
  `dj_day` datetime DEFAULT NULL COMMENT '登记日期',
  `fp_staff_id` int(11) DEFAULT NULL COMMENT '分配人员id',
  `fp_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员',
  `fp_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员编号',
  `fp_day` datetime DEFAULT NULL COMMENT '分配日期',
  `is_fp` tinyint(4) DEFAULT '2' COMMENT '是否分配，1已分配，2未分配，3待接收,4分配失败',
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员',
  `sales_staff_id` int(11) DEFAULT NULL COMMENT '销售人员id',
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员编号',
  `jr_day` datetime DEFAULT NULL COMMENT '接入日期',
  `yjd_day` datetime DEFAULT NULL COMMENT '预约进店日期',
  `syjd_day` datetime DEFAULT NULL COMMENT '实际进店日期',
  `yp_day` datetime DEFAULT NULL COMMENT '预拍日期',
  `order_day` datetime DEFAULT NULL COMMENT '成交订单日期',
  `totalpay_money` decimal(16,4) DEFAULT NULL,
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单单号',
  `seles_step` int(11) DEFAULT NULL COMMENT '追踪阶段id',
  `step_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪阶段名称',
  `c_star_day` datetime DEFAULT NULL COMMENT '客资追踪开始日期',
  `c_end_day` datetime DEFAULT NULL COMMENT '客资追踪结束日期',
  `last_trackday` datetime DEFAULT NULL COMMENT '最后一次追踪日期',
  `seles_error_id` int(11) DEFAULT NULL COMMENT '追踪失败原因id',
  `seles_error_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪失败原因',
  `customer_remark` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `photo_day` datetime DEFAULT NULL COMMENT '实际拍照日期',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属品牌（事业部）',
  `is_status` int(11) DEFAULT '1',
  `sign_id` int(11) DEFAULT NULL,
  `sign_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客资标记',
  `tel_visit_num` int(11) DEFAULT '0',
  `loss_cause` text COLLATE utf8_unicode_ci COMMENT '不再追踪原因',
  `create_time` datetime DEFAULT NULL,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_staff_id` int(11) DEFAULT NULL,
  `tel_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_time` datetime DEFAULT NULL,
  `is_first_tel` tinyint(2) DEFAULT NULL,
  `channel_plan_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_key` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intostore_note` text COLLATE utf8_unicode_ci,
  `ready_baby_day` datetime DEFAULT NULL,
  `baby_birthday` datetime DEFAULT NULL,
  `baby_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marry_day` datetime DEFAULT NULL,
  `fp_time_out` int(10) DEFAULT NULL,
  `img_record` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `track_record` text COLLATE utf8_unicode_ci,
  `budget` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fact_money` decimal(16,4) DEFAULT NULL,
  `tel_belong` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_operator` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_area_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `reception_id` int(11) DEFAULT NULL,
  `reception_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_first_wechat` tinyint(2) DEFAULT NULL,
  `wechat_staff_id` int(11) DEFAULT NULL,
  `wechat_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wechat_time` datetime DEFAULT NULL,
  `c_from` tinyint(2) NOT NULL DEFAULT '1',
  `order_start_time` datetime DEFAULT NULL,
  `order_type` tinyint(4) DEFAULT '0' COMMENT '1：线上；2：线下',
  `is_send_yjd_msg` tinyint(1) DEFAULT '2' COMMENT '是否已发预进店信息：1：是；2：否',
  `is_send_syjd_msg` tinyint(1) DEFAULT '2' COMMENT '是否已发进店信息：1：是；2：否',
  `sign_time` datetime DEFAULT NULL COMMENT '客资标记时间',
  `loss_day` datetime DEFAULT NULL COMMENT '不再追踪时间',
  `op_signinfo_id` int(11) DEFAULT '0',
  `is_act` int(2) DEFAULT '1',
  `yjd_action_day` datetime DEFAULT NULL,
  `reject_reason` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reject_remark` text COLLATE utf8_unicode_ci,
  `loss_remark` text COLLATE utf8_unicode_ci COMMENT '不再追踪备注',
  `update_time` datetime DEFAULT NULL,
  `del_time` datetime DEFAULT NULL,
  `unvalid_id` int(11) DEFAULT '0',
  `unvalid_reason` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `erp_loss` tinyint(2) NOT NULL DEFAULT '1',
  `erp_loss_reason` text COLLATE utf8_unicode_ci,
  `erp_loss_time` datetime DEFAULT NULL,
  `dj_department_id` int(11) DEFAULT NULL,
  `dj_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_department_id` int(11) DEFAULT NULL,
  `sales_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_examine` tinyint(4) DEFAULT '1' COMMENT '是否审核',
  `examine_reason` text COLLATE utf8_unicode_ci,
  `baby_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `home_phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `introduce_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zjs_from` tinyint(2) NOT NULL DEFAULT '0',
  `ad_page` text COLLATE utf8_unicode_ci,
  `add_friend_time` datetime DEFAULT NULL,
  `erp_wphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `erp_mphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_group_id` int(11) DEFAULT NULL,
  `dj_group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_group_id` int(11) DEFAULT NULL,
  `sales_group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_channel_cost` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道客资成本',
  `bonus` tinyint(2) DEFAULT '2' COMMENT 'A客奖金',
  `bonus_deal` tinyint(2) DEFAULT '2' COMMENT '成交奖金',
  `customer_contact` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valid_new` tinyint(4) DEFAULT NULL COMMENT '是否为有效新客（0：无效；1：有效）',
  `customer_capacity` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费能力',
  `is_urgent` int(11) DEFAULT NULL COMMENT '是否加急，1加急，2否',
  `company_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_label` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资标签',
  `record_day` datetime DEFAULT NULL,
  `huoqu_num` int(11) DEFAULT '1',
  `hospital_photo_time` datetime DEFAULT NULL,
  `hospital_photo_cameraman_id` int(11) DEFAULT NULL,
  `hospital_photo_cameraman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hospital_photo_assistant_id` int(11) DEFAULT NULL,
  `hospital_photo_assistant` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pinlei` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `club_id` int(11) DEFAULT NULL,
  `club_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recommend_staff` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recommend_staff_id` int(11) DEFAULT NULL,
  `baby_weight` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_stature` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_already_sk` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `all_staff` (`dj_staff_id`,`fp_staff_id`,`sales_staff_id`) USING BTREE,
  KEY `customer_contact` (`customer_tel`,`customer_wechat`,`customer_qq`,`mate_tel`) USING BTREE,
  KEY `shop_code` (`shop_code`,`add_shop_code`,`brandclass_id`) USING BTREE,
  KEY `status` (`is_intostore`,`is_success`,`is_valid`,`is_loss`,`is_fp`,`is_status`,`c_from`,`order_type`) USING BTREE,
  KEY `reception_id` (`reception_id`) USING BTREE,
  KEY `sales_staff_id` (`sales_staff_id`) USING BTREE,
  KEY `customer_type` (`customer_type`) USING BTREE,
  KEY `customer_wechat` (`customer_wechat`) USING BTREE,
  KEY `order_number` (`order_number`) USING BTREE,
  KEY `syjd_day` (`syjd_day`) USING BTREE,
  KEY `c_unique` (`c_unique`) USING BTREE,
  KEY `customer_number` (`customer_number`),
  KEY `all_time` (`dj_day`,`fp_day`,`jr_day`,`yjd_day`,`syjd_day`,`yp_day`,`order_day`,`c_star_day`,`c_end_day`,`create_time`,`order_start_time`,`sign_time`,`ready_baby_day`,`baby_address`) USING BTREE,
  KEY `eid` (`eid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资信息表';


DELIMITER ;;
/*!50003 SET SESSION SQL_MODE="STRICT_ALL_TABLES,NO_AUTO_CREATE_USER" */;;
/*!50003 CREATE */ /*!50017 DEFINER=`root`@`127.0.0.1` */ /*!50003 TRIGGER `contact_update` BEFORE UPDATE ON `crm_c_customerinfo` FOR EACH ROW BEGIN

set NEW.customer_contact=CONCAT(NEW.id,',',IFNULL(NEW.customer_number,''),',',IFNULL(NEW.customer_name,''),',',IFNULL(NEW.customer_tel,''),',',IFNULL(NEW.customer_wechat,''),'',IFNULL(NEW.mate_name,''),',',IFNULL(NEW.mate_tel,''),',',IFNULL(NEW.mate_wechat,''));

END */;;
DELIMITER ;
/*!50003 SET SESSION SQL_MODE=@OLD_SQL_MODE */;


# Dump of table crm_c_day_number
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_day_number`;

CREATE TABLE `crm_c_day_number` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `dj_customer` int(11) unsigned DEFAULT '0' COMMENT '提报客资数',
  `dj_mobile` int(11) unsigned DEFAULT '0' COMMENT '提报手机号数',
  `sel_customer` int(11) DEFAULT '0' COMMENT '筛客人的筛客数量',
  `fp_customer` int(11) unsigned DEFAULT '0' COMMENT '分配客资数',
  `fp_no_mobile` int(11) unsigned DEFAULT '0' COMMENT '分配无手机号数',
  `add_mobile` int(11) unsigned DEFAULT '0' COMMENT '新增手机号数',
  `valid_customer` int(11) unsigned DEFAULT '0' COMMENT '有效客资数',
  `no_valid_customer` int(11) unsigned DEFAULT '0' COMMENT '无效客资数',
  `yjd` int(11) unsigned DEFAULT '0' COMMENT '预约进店数',
  `syjd_jk` int(11) unsigned DEFAULT '0' COMMENT '实际进店数，进客',
  `syjd_no_jk` int(11) unsigned DEFAULT '0' COMMENT '实际进店数，非进客',
  `orders` int(11) unsigned DEFAULT '0' COMMENT '成单数',
  `valid_order` int(11) unsigned DEFAULT '0' COMMENT '有效成单数',
  `tel_visit` int(11) DEFAULT '0' COMMENT '电访量',
  `a_customer` int(11) unsigned DEFAULT '0' COMMENT 'A客数',
  `addtime` date DEFAULT NULL COMMENT '数据插入时间',
  `staff_id` int(11) DEFAULT NULL COMMENT '操作人id',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名字',
  `staff_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编码',
  `group_id` int(11) DEFAULT NULL COMMENT '组id',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `dj_xw` int(11) DEFAULT NULL,
  `dj_qq` int(11) DEFAULT NULL,
  `today_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='日统计表';



# Dump of table crm_c_ds_report
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_ds_report`;

CREATE TABLE `crm_c_ds_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `region` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost` decimal(12,4) DEFAULT NULL,
  `return_cost` decimal(12,4) DEFAULT NULL,
  `new_customer` int(11) DEFAULT NULL,
  `valid_customer` int(11) DEFAULT NULL,
  `acquisition_rate` decimal(7,4) DEFAULT NULL,
  `invitation` int(11) DEFAULT NULL,
  `into` int(11) DEFAULT NULL,
  `in_rate` decimal(7,4) DEFAULT NULL,
  `order_num` int(11) DEFAULT NULL,
  `deal_rate` decimal(7,4) DEFAULT NULL,
  `change_rate` decimal(7,4) DEFAULT NULL,
  `orer_amount` decimal(12,4) DEFAULT NULL,
  `earning` decimal(12,4) DEFAULT NULL,
  `average_price` decimal(12,4) DEFAULT NULL,
  `obtain_cost` decimal(12,4) DEFAULT NULL,
  `vaild_cost` decimal(12,4) DEFAULT NULL,
  `deal_cost` decimal(12,4) DEFAULT NULL,
  `roi` decimal(12,4) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='电商渠道花费月报表';



# Dump of table crm_c_excel_cost_import
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_excel_cost_import`;

CREATE TABLE `crm_c_excel_cost_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fail_file_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  `status` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `all_number` int(11) DEFAULT '0',
  `import_number` int(11) DEFAULT '0',
  `fail_number` int(11) DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `import_fail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道花费导入表';



# Dump of table crm_c_excel_import
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_excel_import`;

CREATE TABLE `crm_c_excel_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上传文件名',
  `file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fail_file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '错误文件地址',
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工姓名',
  `addtime` datetime DEFAULT NULL COMMENT '导入时间',
  `status` tinyint(2) DEFAULT '0' COMMENT '导入状态，0未导入，1已导入，2正在导入，默认为0',
  `all_number` int(11) DEFAULT '0' COMMENT '数据总条数',
  `upload_num` int(11) DEFAULT NULL,
  `import_number` int(11) DEFAULT '0' COMMENT '成功导入条数',
  `fail_number` int(11) DEFAULT '0' COMMENT '导入失败数据条数',
  `is_sk` tinyint(1) DEFAULT '2',
  `sk_staff_id` int(11) DEFAULT NULL,
  `sk_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `import_fail` int(11) DEFAULT NULL,
  `belong_shop_code` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='导入记录表';



# Dump of table crm_c_excel_import_data
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_excel_import_data`;

CREATE TABLE `crm_c_excel_import_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eid` int(11) DEFAULT NULL COMMENT '导入时的id',
  `baby_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_birthday` datetime DEFAULT NULL COMMENT '宝宝生日',
  `ready_baby_day` datetime DEFAULT NULL COMMENT '预产期',
  `record_day` datetime DEFAULT NULL COMMENT '填写日期',
  `baby_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生地',
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户手机',
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微信',
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微博',
  `mate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶姓名',
  `mate_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶电话',
  `province_id` int(11) DEFAULT NULL,
  `province` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在省',
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在市',
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '县（区）',
  `customer_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地址',
  `customer_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户类型，1新单、2转介绍',
  `introducer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人姓名',
  `customer_channel_id` int(11) DEFAULT NULL,
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户渠道',
  `access_model_id` int(11) DEFAULT NULL,
  `access_model` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `consultation_type_id` int(11) DEFAULT NULL,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_cource_id` int(11) DEFAULT NULL,
  `customer_cource` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `channel_plan_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '推广编号',
  `ad_page` text COLLATE utf8_unicode_ci COMMENT '广告落地页',
  `customer_area_id` int(11) DEFAULT NULL,
  `customer_area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `customer_intention_id` int(11) DEFAULT NULL,
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `consulation_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `consulation_shop` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面',
  `customer_orderaddress_id` int(11) DEFAULT NULL,
  `customer_orderaddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工',
  `dj_staff_id` int(11) DEFAULT NULL COMMENT '登记员工id',
  `dj_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工编号',
  `dj_group_id` int(11) DEFAULT NULL,
  `dj_group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_department_id` int(11) DEFAULT NULL,
  `dj_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_day` datetime DEFAULT NULL COMMENT '登记日期',
  `yx_day` datetime DEFAULT NULL,
  `fp_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员',
  `fp_staff_id` int(11) DEFAULT NULL,
  `fp_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_fp` tinyint(4) DEFAULT '2',
  `fp_day` datetime DEFAULT NULL,
  `jr_day` datetime DEFAULT NULL,
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员',
  `sales_staff_id` int(11) DEFAULT NULL,
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_group_id` int(11) DEFAULT NULL,
  `sales_group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_department_id` int(11) DEFAULT NULL,
  `sales_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `customer_remark` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `introduce_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '转介绍员工',
  `customer_key` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关键字',
  `valid_new` tinyint(4) DEFAULT NULL COMMENT '是否为有效新客（0：无效；1：有效）',
  `same_tel` int(11) DEFAULT NULL COMMENT '重复数量',
  `import_status` tinyint(4) DEFAULT '0' COMMENT '导入状态（1：成功；2：失败）',
  `msg` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '成功失败原因',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `sign_id` int(11) DEFAULT NULL,
  `sign_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sign_time` datetime DEFAULT NULL,
  `baby_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hospital_photo_cameraman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hospital_photo_assistant` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hospital_photo_time` datetime DEFAULT NULL,
  `recommend_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_weight` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_stature` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eid` (`eid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='导入信息记录表';

LOCK TABLES `crm_c_excel_import_data` WRITE;
/*!40000 ALTER TABLE `crm_c_excel_import_data` DISABLE KEYS */;

INSERT INTO `crm_c_excel_import_data` (`id`, `eid`, `baby_name`, `baby_sex`, `baby_birthday`, `ready_baby_day`, `record_day`, `baby_address`, `customer_name`, `customer_tel`, `customer_wechat`, `customer_qq`, `customer_weibo`, `mate_name`, `mate_tel`, `province_id`, `province`, `city_id`, `city`, `county_id`, `county`, `customer_address`, `customer_type`, `introducer_name`, `customer_channel_id`, `customer_channel`, `access_model_id`, `access_model`, `consultation_type_id`, `consultation_type`, `customer_cource_id`, `customer_cource`, `channel_plan_number`, `ad_page`, `customer_area_id`, `customer_area`, `customer_intention_id`, `customer_intention`, `consulation_shop_code`, `consulation_shop`, `customer_orderaddress_id`, `customer_orderaddress`, `dj_staff`, `dj_staff_id`, `dj_staff_number`, `dj_group_id`, `dj_group_name`, `dj_department_id`, `dj_department_name`, `add_shop_code`, `add_shop_name`, `dj_day`, `yx_day`, `fp_staff`, `fp_staff_id`, `fp_staff_number`, `is_fp`, `fp_day`, `jr_day`, `sales_staff`, `sales_staff_id`, `sales_staff_number`, `sales_group_id`, `sales_group_name`, `sales_department_id`, `sales_department_name`, `shop_code`, `shop_name`, `brandclass`, `brandclass_id`, `customer_remark`, `introduce_staff_name`, `customer_key`, `valid_new`, `same_tel`, `import_status`, `msg`, `create_time`, `update_time`, `sign_id`, `sign_name`, `sign_time`, `baby_time`, `hospital_photo_cameraman`, `hospital_photo_assistant`, `hospital_photo_time`, `recommend_staff`, `baby_weight`, `baby_stature`)
VALUES
	(1,1,'','','2020-01-01 00:00:00',NULL,'2020-01-01 00:00:00','','刘月明','18877561121','','','','','',NULL,'',NULL,'',NULL,'','','','',NULL,'大众点评',NULL,'',NULL,'',NULL,'','','',NULL,'',NULL,'',NULL,'',NULL,'','管理员',1,'MKX001',NULL,NULL,3,'爱婴部','MK03','马克叔叔爱婴中心','2020-11-17 09:09:32',NULL,NULL,NULL,NULL,2,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,'MK03','马克叔叔爱婴中心','马克叔叔',1,'','','',NULL,0,1,NULL,'2020-11-17 09:09:32',NULL,NULL,'',NULL,'一胎','','',NULL,'','',''),
	(2,2,'','','2020-01-01 00:00:00',NULL,'2020-01-01 00:00:00','','刘月明','17765442318','','','','','',NULL,'',NULL,'',NULL,'','','','',NULL,'大众点评',NULL,'',NULL,'',NULL,'','','',NULL,'',NULL,'',NULL,'',NULL,'','管理员',1,'MKX001',NULL,NULL,2,'电商部','MK04','马克叔叔电商中心','2020-11-17 13:25:48',NULL,NULL,NULL,NULL,2,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,'MK04','马克叔叔电商中心','马克叔叔',1,'','','',NULL,NULL,2,'渠道名称填写有误','2020-11-17 13:25:48','2020-11-17 13:26:53',NULL,'',NULL,'一胎','','',NULL,'','',''),
	(3,3,'test','男','2018-08-02 00:00:00',NULL,NULL,'','123','13212344321','','','','','',NULL,'',NULL,'',NULL,'','','','',NULL,'玛丽亚西区',NULL,'',NULL,'',NULL,'','','',NULL,'',NULL,'',NULL,'',NULL,'','马克彩虹',52,'MKAY002',NULL,NULL,3,'爱婴部','MK03','马克叔叔爱婴中心','2020-11-17 17:38:01',NULL,NULL,NULL,NULL,2,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,'MK03','马克叔叔爱婴中心','马克叔叔',1,'','','',NULL,0,1,NULL,'2020-11-17 17:38:01',NULL,NULL,'',NULL,'1','','',NULL,'','12','12'),
	(4,4,'','','2020-01-01 00:00:00',NULL,'2020-01-01 00:00:00','','刘月明','188787665420','','','','','',NULL,'',NULL,'',NULL,'','','','',NULL,'大众点评',NULL,'',NULL,'',NULL,'','','',NULL,'',NULL,'',NULL,'',NULL,'','马克彩虹',52,'MKAY002',NULL,NULL,3,'爱婴部','MK03','马克叔叔爱婴中心','2020-11-17 19:23:21',NULL,NULL,NULL,NULL,2,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,NULL,'MK03','马克叔叔爱婴中心','马克叔叔',1,'','','',NULL,NULL,2,'列：妈妈手机号，填写错误','2020-11-17 19:23:21',NULL,NULL,'',NULL,'一胎','','',NULL,'','','');

/*!40000 ALTER TABLE `crm_c_excel_import_data` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_c_fp_pool
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_fp_pool`;

CREATE TABLE `crm_c_fp_pool` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT NULL,
  `msg` text COLLATE utf8_unicode_ci,
  `fp_time_out` int(10) DEFAULT NULL,
  `count` int(10) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `pool_type` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分配失败缓存表';



# Dump of table crm_c_message
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_message`;

CREATE TABLE `crm_c_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `send_type` int(4) DEFAULT '1' COMMENT '发送的消息类型:1:短消息(弹窗)；2：通知',
  `send_id` int(11) DEFAULT NULL COMMENT '发送者id（-1：为系统发送）',
  `send_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送者名称（系统：system）',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `send_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消息标题',
  `send_msg` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送的消息内容',
  `operation_type` int(4) DEFAULT NULL COMMENT '操作类型（1：可操作；2：不可操作）',
  `operation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作方法（二维数组的json）',
  `time_out` char(13) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '过期时间的时间戳',
  `customer_id` int(11) DEFAULT NULL COMMENT '客资id',
  `receive_id` int(11) DEFAULT NULL COMMENT '接收者id',
  `receive_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接收者姓名',
  `receive_status` int(4) DEFAULT '0' COMMENT '接收状态（0：未接收；1：已接收；2：已放弃）',
  `receive_time` datetime DEFAULT NULL COMMENT '接收/放弃 时间',
  `read_status` int(4) DEFAULT '0' COMMENT '阅读状态（0：未读；1：已读）',
  `read_time` datetime DEFAULT NULL COMMENT '阅读消息时间',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否删除：1：删除；0：未删除',
  PRIMARY KEY (`id`),
  KEY `id` (`id`,`send_id`,`receive_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消息通知表';



# Dump of table crm_c_order_detail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_order_detail`;

CREATE TABLE `crm_c_order_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_sn` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `pay_time` date NOT NULL,
  `collectmoneynumber` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_valid` tinyint(2) DEFAULT '1',
  `order_fact` decimal(10,4) DEFAULT '0.0000',
  `pay_type` int(2) NOT NULL,
  `create_time` datetime NOT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `collectmoneynumber` (`collectmoneynumber`) USING BTREE,
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='订单收款记录表';



# Dump of table crm_c_salestrackinginfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_salestrackinginfo`;

CREATE TABLE `crm_c_salestrackinginfo` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gtType` tinyint(4) DEFAULT NULL COMMENT '沟通方式(电话/微信/QQ/其他)',
  `c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL COMMENT '客户id',
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `sales_day` datetime DEFAULT NULL COMMENT '追踪日期',
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售追踪人员',
  `sales_staff_id` int(11) DEFAULT NULL COMMENT '销售追踪人ID',
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售追踪编号',
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拨打号码',
  `tel_starttime` datetime DEFAULT NULL COMMENT '拨打开始时间',
  `tel_endtime` datetime DEFAULT NULL COMMENT '拨打结束时间',
  `tel_alltime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通话总时长',
  `sales_remark` text COLLATE utf8_unicode_ci COMMENT '追踪备注',
  `tel_type` tinyint(4) DEFAULT NULL COMMENT '呼叫方式(1主叫、2被叫)',
  `seles_step` int(11) DEFAULT NULL COMMENT '沟通进度',
  `step_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪阶段',
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `tel_static` tinyint(4) DEFAULT NULL COMMENT '是否接通(1：已接通，2：未接通)',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `audio_path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `no_track` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='营销追踪记录表C_salestrackinginfo';



# Dump of table crm_c_send_message_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_send_message_log`;

CREATE TABLE `crm_c_send_message_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `send_id` int(11) DEFAULT NULL COMMENT '发送者id',
  `send_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送者名称',
  `send_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送的消息内容',
  `model_id` int(11) DEFAULT NULL COMMENT '模板id',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `receive_id` int(11) DEFAULT NULL COMMENT '接受者id',
  `receive_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接收者姓名',
  `receive_phone` varchar(15) COLLATE utf8_unicode_ci NOT NULL COMMENT '接收人手机号',
  PRIMARY KEY (`id`),
  KEY `receive_id` (`receive_id`) USING BTREE,
  KEY `receive_phone` (`receive_phone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信发送日志表';



# Dump of table crm_c_staff_trench_mate
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_staff_trench_mate`;

CREATE TABLE `crm_c_staff_trench_mate` (
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trench` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='员工渠道绑定表';



# Dump of table crm_c_swap_customer
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_swap_customer`;

CREATE TABLE `crm_c_swap_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `swap_number` char(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `c_is_valid` tinyint(2) DEFAULT '0',
  `is_valid` tinyint(2) DEFAULT '0',
  `c_is_intostore` tinyint(2) DEFAULT '0',
  `is_intostore` tinyint(2) DEFAULT '0',
  `c_is_success` tinyint(2) DEFAULT '0',
  `is_success` tinyint(2) DEFAULT '0',
  `sales_staff_id` int(11) DEFAULT '0',
  `sales_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  `c_yjd_day` datetime NOT NULL,
  `yjd_day` datetime NOT NULL,
  `c_yjd_action_day` datetime DEFAULT NULL,
  `yjd_action_day` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='爆破客资表';



# Dump of table crm_c_sysconfig
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_c_sysconfig`;

CREATE TABLE `crm_c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容',
  PRIMARY KEY (`ckey`),
  UNIQUE KEY `ckey` (`ckey`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='系统设定表';



# Dump of table crm_d_ds_channel_ld
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_d_ds_channel_ld`;

CREATE TABLE `crm_d_ds_channel_ld` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` date DEFAULT NULL,
  `cost` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkz` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `channel_name` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dd` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jd` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fact` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amountAVG` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `validRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jdRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderValidRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mkzCost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `validCost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderCost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `roi` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='电商渠道漏斗沉淀表';



# Dump of table crm_d_wx_group
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_d_wx_group`;

CREATE TABLE `crm_d_wx_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` date DEFAULT NULL,
  `mkz` int(11) DEFAULT NULL,
  `jr` int(11) DEFAULT NULL,
  `valid` int(11) DEFAULT NULL,
  `dd` int(11) DEFAULT NULL,
  `wx` int(11) DEFAULT NULL,
  `validRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wxRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ddRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notel` int(11) DEFAULT NULL,
  `zhaunTel` int(11) DEFAULT NULL,
  `zhaunRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel` int(11) DEFAULT NULL,
  `jd` int(11) DEFAULT NULL,
  `jdRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `orderRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `loss` int(11) DEFAULT NULL,
  `lossRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fact` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yk` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderMkzRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderValidRate` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='网销小组数据统计沉淀表';



# Dump of table crm_l_camera_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_camera_log`;

CREATE TABLE `crm_l_camera_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT NULL,
  `eid` int(11) DEFAULT NULL,
  `fp_model` tinyint(4) DEFAULT NULL COMMENT '分配方式(1：自动分配；2：手动分配）',
  `fp_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配状态（1：已分配；2：未分配；3：待接收；4：分配失败；5：放弃）',
  `fp_time` datetime DEFAULT NULL,
  `fp_staff_id` int(11) DEFAULT NULL,
  `fp_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_time` datetime DEFAULT NULL,
  `jr_staff_id` int(11) DEFAULT NULL,
  `jr_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分配日志表';

LOCK TABLES `crm_l_camera_log` WRITE;
/*!40000 ALTER TABLE `crm_l_camera_log` DISABLE KEYS */;

INSERT INTO `crm_l_camera_log` (`id`, `cid`, `eid`, `fp_model`, `fp_status`, `fp_time`, `fp_staff_id`, `fp_staff_name`, `fp_shop_code`, `fp_shop_name`, `jr_time`, `jr_staff_id`, `jr_staff_name`, `jr_shop_code`, `jr_shop_name`, `fp_brandclass_id`)
VALUES
	(1,9,NULL,2,'1','2020-11-17 19:36:21',52,'马克彩虹','MK03','马克叔叔爱婴中心','2020-11-17 19:36:00',65,'马克小米/马克彩虹','MK03','马克叔叔爱婴中心',1);

/*!40000 ALTER TABLE `crm_l_camera_log` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_l_error_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_error_log`;

CREATE TABLE `crm_l_error_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `error_reason` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='监控排重用的表';



# Dump of table crm_l_fp_logs
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_fp_logs`;

CREATE TABLE `crm_l_fp_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT NULL,
  `eid` int(11) DEFAULT NULL,
  `fp_model` tinyint(4) DEFAULT NULL COMMENT '分配方式(1：自动分配；2：手动分配；3：录入指定；4：话务录入）',
  `fp_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配状态（1：已分配；2：未分配；3：待接收；4：分配失败；5：放弃）',
  `fp_time` datetime DEFAULT NULL,
  `fp_staff_id` int(11) DEFAULT NULL,
  `fp_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_time` datetime DEFAULT NULL,
  `jr_staff_id` int(11) DEFAULT NULL,
  `jr_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分配日志表';



# Dump of table crm_l_login_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_login_log`;

CREATE TABLE `crm_l_login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_five` tinyint(1) DEFAULT '2',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `login_out_time` datetime DEFAULT NULL,
  `session_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='登录日志表';



# Dump of table crm_l_pc_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_pc_log`;

CREATE TABLE `crm_l_pc_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT NULL,
  `c_unique` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户唯一标识',
  `smgroup` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上门客资分组',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资的追踪店面',
  `pc_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '预约上门的服务店面',
  `pc_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cameraman_id` int(11) DEFAULT NULL,
  `cameraman_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影师',
  `sale_id` int(11) DEFAULT NULL,
  `sale_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '邀约人，即邀约上门时的操作人，不一定是网销',
  `tutor_id` int(11) DEFAULT NULL,
  `tutor_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '导师',
  `remark` text COLLATE utf8_unicode_ci COMMENT '预约上门备注',
  `pc_time` date DEFAULT NULL COMMENT '预约上门日期',
  `area_id` int(11) DEFAULT NULL,
  `area_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区(不用了）',
  `time` int(5) DEFAULT NULL COMMENT '具体时间（暂时不用）',
  `result` tinyint(4) DEFAULT '1' COMMENT '拍摄状态：1：未完成；2：已完成（暂时不用了）',
  `code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '核销码',
  `status` tinyint(1) DEFAULT '1' COMMENT '上门状态：1：未上门；2：已成交(有套系）；3：未成交（核销未开单，或无套系）；4：已取消',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '核销人',
  `hx_time` datetime DEFAULT NULL COMMENT '核销时间',
  `reason` text COLLATE utf8_unicode_ci COMMENT '原因（取消，改期原因）',
  `consulation_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `street_id` int(11) DEFAULT NULL,
  `street` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `assistant` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '助理',
  `pc_type` tinyint(1) DEFAULT '2' COMMENT '排程类型：1：到店拍；2：上门拍（只用上门拍）',
  `create_time` datetime DEFAULT NULL,
  `is_delete` tinyint(1) DEFAULT '2' COMMENT '是否删除：1：删除；2：未删除',
  `backup` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取消或者其他什么时候写的备注',
  `sm_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上门类型:理发，拍摄，售后，其他',
  `is_chaoju` tinyint(1) DEFAULT '2' COMMENT '是否超距离（1：是；2：否）',
  `is_gq` int(4) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`) USING BTREE,
  KEY `cid` (`cid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='到店拍排程日志';



# Dump of table crm_l_pc_setting_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_pc_setting_log`;

CREATE TABLE `crm_l_pc_setting_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `num` int(11) DEFAULT NULL,
  `setting_date` date DEFAULT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `area_id` int(11) DEFAULT NULL,
  `area_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pc_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1：到店拍；2：上门拍',
  `sm_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `week` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='儿童用，排程设定表';



# Dump of table crm_l_yjd_ctrl
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_l_yjd_ctrl`;

CREATE TABLE `crm_l_yjd_ctrl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_code` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `use_day` date DEFAULT NULL,
  `week` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `time_area` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `start` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `end` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `is_del` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='预约进店排程（设定）表';



# Dump of table crm_request_logs
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_request_logs`;

CREATE TABLE `crm_request_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `request_url` longtext COLLATE utf8_unicode_ci,
  `request_data` longtext COLLATE utf8_unicode_ci,
  `response_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `response_data` longtext COLLATE utf8_unicode_ci,
  `request_start_time` decimal(16,5) DEFAULT NULL,
  `request_end_time` decimal(16,5) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `response_code` (`response_code`) USING BTREE,
  FULLTEXT KEY `request_url` (`request_url`),
  FULLTEXT KEY `request_data` (`request_data`),
  FULLTEXT KEY `response_data` (`response_data`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_address
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_address`;

CREATE TABLE `crm_s_address` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(120) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '2',
  `order_sort` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `path` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 正在导出表  wsygbb_sx6_bberp.crm_s_address 的数据：4,044 rows
DELETE FROM `crm_s_address`;
/*!40000 ALTER TABLE `crm_s_address` DISABLE KEYS */;
INSERT INTO `crm_s_address` (`id`, `pid`, `name`, `type`, `order_sort`, `path`) VALUES
  (1, 0, '中国', 0, '', NULL),
  (2, 3, '北京', 1, '', NULL),
  (3, 3, '天津', 1, '', NULL),
  (4, 3, '河北省', 1, '', NULL),
  (5, 3, '山西省', 1, '', NULL),
  (6, 3, '内蒙古自治区', 1, '', NULL),
  (7, 1, '辽宁省', 1, '', NULL),
  (8, 1, '吉林省', 1, '', NULL),
  (9, 1, '黑龙江省', 1, '', NULL),
  (10, 2, '上海', 1, '', NULL),
  (11, 2, '江苏省', 1, '', NULL),
  (12, 2, '浙江省', 1, '', NULL),
  (13, 2, '安徽省', 1, '', NULL),
  (14, 2, '福建省', 1, '', NULL),
  (15, 2, '江西省', 1, '', NULL),
  (16, 2, '山东省', 1, '', NULL),
  (17, 4, '河南省', 1, '', NULL),
  (18, 4, '湖北省', 1, '', NULL),
  (19, 4, '湖南省', 1, '', NULL),
  (20, 5, '广东省', 1, '', NULL),
  (21, 5, '广西壮族自治区', 1, '', NULL),
  (22, 5, '海南省', 1, '', NULL),
  (23, 6, '重庆', 1, '', NULL),
  (24, 6, '四川省', 1, '', NULL),
  (25, 6, '贵州省', 1, '', NULL),
  (26, 6, '云南省', 1, '', NULL),
  (27, 6, '西藏自治区', 1, '', NULL),
  (28, 7, '陕西省', 1, '', NULL),
  (29, 7, '甘肃省', 1, '', NULL),
  (30, 7, '青海省', 1, '', NULL),
  (31, 7, '宁夏回族自治区', 1, '', NULL),
  (32, 7, '新疆维吾尔自治区', 1, '', NULL),
  (33, 2, '台湾', 1, '', NULL),
  (34, 5, '香港特别行政区', 1, '', NULL),
  (35, 5, '澳门特别行政区', 1, '', NULL),
  (36, 1, '海外', 1, '', NULL),
  (37, 2, '北京市', 2, '', NULL),
  (38, 3, '天津市', 2, '', NULL),
  (39, 4, '石家庄市', 2, '', NULL),
  (40, 4, '唐山市', 2, '', NULL),
  (41, 4, '秦皇岛市', 2, '', NULL),
  (42, 4, '邯郸市', 2, '', NULL),
  (43, 4, '邢台市', 2, '', NULL),
  (44, 4, '保定市', 2, '', NULL),
  (45, 4, '张家口市', 2, '', NULL),
  (46, 4, '承德市', 2, '', NULL),
  (47, 4, '沧州市', 2, '', NULL),
  (48, 4, '廊坊市', 2, '', NULL),
  (49, 4, '衡水市', 2, '', NULL),
  (50, 5, '太原市', 2, '', NULL),
  (51, 5, '大同市', 2, '', NULL),
  (52, 5, '阳泉市', 2, '', NULL),
  (53, 5, '长治市', 2, '', NULL),
  (54, 5, '晋城市', 2, '', NULL),
  (55, 5, '朔州市', 2, '', NULL),
  (56, 5, '晋中市', 2, '', NULL),
  (57, 5, '运城市', 2, '', NULL),
  (58, 5, '忻州市', 2, '', NULL),
  (59, 5, '临汾市', 2, '', NULL),
  (60, 5, '吕梁市', 2, '', NULL),
  (61, 6, '呼和浩特市', 2, '', NULL),
  (62, 6, '包头市', 2, '', NULL),
  (63, 6, '乌海市', 2, '', NULL),
  (64, 6, '赤峰市', 2, '', NULL),
  (65, 6, '通辽市', 2, '', NULL),
  (66, 6, '鄂尔多斯市', 2, '', NULL),
  (67, 6, '呼伦贝尔市', 2, '', NULL),
  (68, 6, '巴彦淖尔市', 2, '', NULL),
  (69, 6, '乌兰察布市', 2, '', NULL),
  (70, 6, '兴安盟', 2, '', NULL),
  (71, 6, '锡林郭勒盟', 2, '', NULL),
  (72, 6, '阿拉善盟', 2, '', NULL),
  (73, 7, '沈阳市', 2, '', NULL),
  (74, 7, '大连市', 2, '', NULL),
  (75, 7, '鞍山市', 2, '', NULL),
  (76, 7, '抚顺市', 2, '', NULL),
  (77, 7, '本溪市', 2, '', NULL),
  (78, 7, '丹东市', 2, '', NULL),
  (79, 7, '锦州市', 2, '', NULL),
  (80, 7, '营口市', 2, '', NULL),
  (81, 7, '阜新市', 2, '', NULL),
  (82, 7, '辽阳市', 2, '', NULL),
  (83, 7, '盘锦市', 2, '', NULL),
  (84, 7, '铁岭市', 2, '', NULL),
  (85, 7, '朝阳市', 2, '', NULL),
  (86, 7, '葫芦岛市', 2, '', NULL),
  (87, 8, '长春市', 2, '', NULL),
  (88, 8, '吉林市', 2, '', NULL),
  (89, 8, '四平市', 2, '', NULL),
  (90, 8, '辽源市', 2, '', NULL),
  (91, 8, '通化市', 2, '', NULL),
  (92, 8, '白山市', 2, '', NULL),
  (93, 8, '松原市', 2, '', NULL),
  (94, 8, '白城市', 2, '', NULL),
  (95, 8, '延边朝鲜族自治州', 2, '', NULL),
  (96, 9, '哈尔滨市', 2, '', NULL),
  (97, 9, '齐齐哈尔市', 2, '', NULL),
  (98, 9, '鸡西市', 2, '', NULL),
  (99, 9, '鹤岗市', 2, '', NULL),
  (100, 9, '双鸭山市', 2, '', NULL),
  (101, 9, '大庆市', 2, '', NULL),
  (102, 9, '伊春市', 2, '', NULL),
  (103, 9, '佳木斯市', 2, '', NULL),
  (104, 9, '七台河市', 2, '', NULL),
  (105, 9, '牡丹江市', 2, '', NULL),
  (106, 9, '黑河市', 2, '', NULL),
  (107, 9, '绥化市', 2, '', NULL),
  (108, 9, '大兴安岭地区', 2, '', NULL),
  (109, 10, '上海市', 2, '', NULL),
  (110, 11, '南京市', 2, '', NULL),
  (111, 11, '无锡市', 2, '', NULL),
  (112, 11, '徐州市', 2, '', NULL),
  (113, 11, '常州市', 2, '', NULL),
  (114, 11, '苏州市', 2, '', NULL),
  (115, 11, '南通市', 2, '', NULL),
  (116, 11, '连云港市', 2, '', NULL),
  (117, 11, '淮安市', 2, '', NULL),
  (118, 11, '盐城市', 2, '', NULL),
  (119, 11, '扬州市', 2, '', NULL),
  (120, 11, '镇江市', 2, '', NULL),
  (121, 11, '泰州市', 2, '', NULL),
  (122, 11, '宿迁市', 2, '', NULL),
  (123, 12, '杭州市', 2, '', NULL),
  (124, 12, '宁波市', 2, '', NULL),
  (125, 12, '温州市', 2, '', NULL),
  (126, 12, '嘉兴市', 2, '', NULL),
  (127, 12, '湖州市', 2, '', NULL),
  (128, 12, '绍兴市', 2, '', NULL),
  (129, 12, '金华市', 2, '', NULL),
  (130, 12, '衢州市', 2, '', NULL),
  (131, 12, '舟山市', 2, '', NULL),
  (132, 12, '台州市', 2, '', NULL),
  (133, 12, '丽水市', 2, '', NULL),
  (134, 13, '合肥市', 2, '', NULL),
  (135, 13, '芜湖市', 2, '', NULL),
  (136, 13, '蚌埠市', 2, '', NULL),
  (137, 13, '淮南市', 2, '', NULL),
  (138, 13, '马鞍山市', 2, '', NULL),
  (139, 13, '淮北市', 2, '', NULL),
  (140, 13, '铜陵市', 2, '', NULL),
  (141, 13, '安庆市', 2, '', NULL),
  (142, 13, '黄山市', 2, '', NULL),
  (143, 13, '滁州市', 2, '', NULL),
  (144, 13, '阜阳市', 2, '', NULL),
  (145, 13, '宿州市', 2, '', NULL),
  (146, 13, '六安市', 2, '', NULL),
  (147, 13, '亳州市', 2, '', NULL),
  (148, 13, '池州市', 2, '', NULL),
  (149, 13, '宣城市', 2, '', NULL),
  (150, 14, '福州市', 2, '', NULL),
  (151, 14, '厦门市', 2, '', NULL),
  (152, 14, '莆田市', 2, '', NULL),
  (153, 14, '三明市', 2, '', NULL),
  (154, 14, '泉州市', 2, '', NULL),
  (155, 14, '漳州市', 2, '', NULL),
  (156, 14, '南平市', 2, '', NULL),
  (157, 14, '龙岩市', 2, '', NULL),
  (158, 14, '宁德市', 2, '', NULL),
  (159, 15, '南昌市', 2, '', NULL),
  (160, 15, '景德镇市', 2, '', NULL),
  (161, 15, '萍乡市', 2, '', NULL),
  (162, 15, '九江市', 2, '', NULL),
  (163, 15, '新余市', 2, '', NULL),
  (164, 15, '鹰潭市', 2, '', NULL),
  (165, 15, '赣州市', 2, '', NULL),
  (166, 15, '吉安市', 2, '', NULL),
  (167, 15, '宜春市', 2, '', NULL),
  (168, 15, '抚州市', 2, '', NULL),
  (169, 15, '上饶市', 2, '', NULL),
  (170, 16, '济南市', 2, '', NULL),
  (171, 16, '青岛市', 2, '', NULL),
  (172, 16, '淄博市', 2, '', NULL),
  (173, 16, '枣庄市', 2, '', NULL),
  (174, 16, '东营市', 2, '', NULL),
  (175, 16, '烟台市', 2, '', NULL),
  (176, 16, '潍坊市', 2, '', NULL),
  (177, 16, '济宁市', 2, '', NULL),
  (178, 16, '泰安市', 2, '', NULL),
  (179, 16, '威海市', 2, '', NULL),
  (180, 16, '日照市', 2, '', NULL),
  (181, 16, '莱芜市', 2, '', NULL),
  (182, 16, '临沂市', 2, '', NULL),
  (183, 16, '德州市', 2, '', NULL),
  (184, 16, '聊城市', 2, '', NULL),
  (185, 16, '滨州市', 2, '', NULL),
  (186, 16, '菏泽市', 2, '', NULL),
  (187, 17, '郑州市', 2, '', NULL),
  (188, 17, '开封市', 2, '', NULL),
  (189, 17, '洛阳市', 2, '', NULL),
  (190, 17, '平顶山市', 2, '', NULL),
  (191, 17, '安阳市', 2, '', NULL),
  (192, 17, '鹤壁市', 2, '', NULL),
  (193, 17, '新乡市', 2, '', NULL),
  (194, 17, '焦作市', 2, '', NULL),
  (195, 17, '濮阳市', 2, '', NULL),
  (196, 17, '许昌市', 2, '', NULL),
  (197, 17, '漯河市', 2, '', NULL),
  (198, 17, '三门峡市', 2, '', NULL),
  (199, 17, '南阳市', 2, '', NULL),
  (200, 17, '商丘市', 2, '', NULL),
  (201, 17, '信阳市', 2, '', NULL),
  (202, 17, '周口市', 2, '', NULL),
  (203, 17, '驻马店市', 2, '', NULL),
  (204, 18, '武汉市', 2, '', NULL),
  (205, 18, '黄石市', 2, '', NULL),
  (206, 18, '十堰市', 2, '', NULL),
  (207, 18, '宜昌市', 2, '', NULL),
  (208, 18, '襄阳市', 2, '', NULL),
  (209, 18, '鄂州市', 2, '', NULL),
  (210, 18, '荆门市', 2, '', NULL),
  (211, 18, '孝感市', 2, '', NULL),
  (212, 18, '荆州市', 2, '', NULL),
  (213, 18, '黄冈市', 2, '', NULL),
  (214, 18, '咸宁市', 2, '', NULL),
  (215, 18, '随州市', 2, '', NULL),
  (216, 18, '恩施土家族苗族自治州', 2, '', NULL),
  (217, 19, '长沙市', 2, '', NULL),
  (218, 19, '株洲市', 2, '', NULL),
  (219, 19, '湘潭市', 2, '', NULL),
  (220, 19, '衡阳市', 2, '', NULL),
  (221, 19, '邵阳市', 2, '', NULL),
  (222, 19, '岳阳市', 2, '', NULL),
  (223, 19, '常德市', 2, '', NULL),
  (224, 19, '张家界市', 2, '', NULL),
  (225, 19, '益阳市', 2, '', NULL),
  (226, 19, '郴州市', 2, '', NULL),
  (227, 19, '永州市', 2, '', NULL),
  (228, 19, '怀化市', 2, '', NULL),
  (229, 19, '娄底市', 2, '', NULL),
  (230, 19, '湘西土家族苗族自治州', 2, '', NULL),
  (231, 20, '广州市', 2, '', NULL),
  (232, 20, '韶关市', 2, '', NULL),
  (233, 20, '深圳市', 2, '', NULL),
  (234, 20, '珠海市', 2, '', NULL),
  (235, 20, '汕头市', 2, '', NULL),
  (236, 20, '佛山市', 2, '', NULL),
  (237, 20, '江门市', 2, '', NULL),
  (238, 20, '湛江市', 2, '', NULL),
  (239, 20, '茂名市', 2, '', NULL),
  (240, 20, '肇庆市', 2, '', NULL),
  (241, 20, '惠州市', 2, '', NULL),
  (242, 20, '梅州市', 2, '', NULL),
  (243, 20, '汕尾市', 2, '', NULL),
  (244, 20, '河源市', 2, '', NULL),
  (245, 20, '阳江市', 2, '', NULL),
  (246, 20, '清远市', 2, '', NULL),
  (247, 20, '东莞市', 2, '', NULL),
  (248, 20, '中山市', 2, '', NULL),
  (249, 20, '东沙群岛', 2, '', NULL),
  (250, 20, '潮州市', 2, '', NULL),
  (251, 20, '揭阳市', 2, '', NULL),
  (252, 20, '云浮市', 2, '', NULL),
  (253, 21, '南宁市', 2, '', NULL),
  (254, 21, '柳州市', 2, '', NULL),
  (255, 21, '桂林市', 2, '', NULL),
  (256, 21, '梧州市', 2, '', NULL),
  (257, 21, '北海市', 2, '', NULL),
  (258, 21, '防城港市', 2, '', NULL),
  (259, 21, '钦州市', 2, '', NULL),
  (260, 21, '贵港市', 2, '', NULL),
  (261, 21, '玉林市', 2, '', NULL),
  (262, 21, '百色市', 2, '', NULL),
  (263, 21, '贺州市', 2, '', NULL),
  (264, 21, '河池市', 2, '', NULL),
  (265, 21, '来宾市', 2, '', NULL),
  (266, 21, '崇左市', 2, '', NULL),
  (267, 22, '海口市', 2, '', NULL),
  (268, 22, '三亚市', 2, '', NULL),
  (269, 22, '三沙市', 2, '', NULL),
  (270, 23, '重庆市', 2, '', NULL),
  (271, 24, '成都市', 2, '', NULL),
  (272, 24, '自贡市', 2, '', NULL),
  (273, 24, '攀枝花市', 2, '', NULL),
  (274, 24, '泸州市', 2, '', NULL),
  (275, 24, '德阳市', 2, '', NULL),
  (276, 24, '绵阳市', 2, '', NULL),
  (277, 24, '广元市', 2, '', NULL),
  (278, 24, '遂宁市', 2, '', NULL),
  (279, 24, '内江市', 2, '', NULL),
  (280, 24, '乐山市', 2, '', NULL),
  (281, 24, '南充市', 2, '', NULL),
  (282, 24, '眉山市', 2, '', NULL),
  (283, 24, '宜宾市', 2, '', NULL),
  (284, 24, '广安市', 2, '', NULL),
  (285, 24, '达州市', 2, '', NULL),
  (286, 24, '雅安市', 2, '', NULL),
  (287, 24, '巴中市', 2, '', NULL),
  (288, 24, '资阳市', 2, '', NULL),
  (289, 24, '阿坝藏族羌族自治州', 2, '', NULL),
  (290, 24, '甘孜藏族自治州', 2, '', NULL),
  (291, 24, '凉山彝族自治州', 2, '', NULL),
  (292, 25, '贵阳市', 2, '', NULL),
  (293, 25, '六盘水市', 2, '', NULL),
  (294, 25, '遵义市', 2, '', NULL),
  (295, 25, '安顺市', 2, '', NULL),
  (296, 25, '铜仁市', 2, '', NULL),
  (297, 25, '黔西南布依族苗族自治州', 2, '', NULL),
  (298, 25, '毕节市', 2, '', NULL),
  (299, 25, '黔东南苗族侗族自治州', 2, '', NULL),
  (300, 25, '黔南布依族苗族自治州', 2, '', NULL),
  (301, 26, '昆明市', 2, '', NULL),
  (302, 26, '曲靖市', 2, '', NULL),
  (303, 26, '玉溪市', 2, '', NULL),
  (304, 26, '保山市', 2, '', NULL),
  (305, 26, '昭通市', 2, '', NULL),
  (306, 26, '丽江市', 2, '', NULL),
  (307, 26, '普洱市', 2, '', NULL),
  (308, 26, '临沧市', 2, '', NULL),
  (309, 26, '楚雄彝族自治州', 2, '', NULL),
  (310, 26, '红河哈尼族彝族自治州', 2, '', NULL),
  (311, 26, '文山壮族苗族自治州', 2, '', NULL),
  (312, 26, '西双版纳傣族自治州', 2, '', NULL),
  (313, 26, '大理白族自治州', 2, '', NULL),
  (314, 26, '德宏傣族景颇族自治州', 2, '', NULL),
  (315, 26, '怒江傈僳族自治州', 2, '', NULL),
  (316, 26, '迪庆藏族自治州', 2, '', NULL),
  (317, 27, '拉萨市', 2, '', NULL),
  (318, 27, '昌都市', 2, '', NULL),
  (319, 27, '山南地区', 2, '', NULL),
  (320, 27, '日喀则市', 2, '', NULL),
  (321, 27, '那曲地区', 2, '', NULL),
  (322, 27, '阿里地区', 2, '', NULL),
  (323, 27, '林芝市', 2, '', NULL),
  (324, 28, '西安市', 2, '', NULL),
  (325, 28, '铜川市', 2, '', NULL),
  (326, 28, '宝鸡市', 2, '', NULL),
  (327, 28, '咸阳市', 2, '', NULL),
  (328, 28, '渭南市', 2, '', NULL),
  (329, 28, '延安市', 2, '', NULL),
  (330, 28, '汉中市', 2, '', NULL),
  (331, 28, '榆林市', 2, '', NULL),
  (332, 28, '安康市', 2, '', NULL),
  (333, 28, '商洛市', 2, '', NULL),
  (334, 29, '兰州市', 2, '', NULL),
  (335, 29, '嘉峪关市', 2, '', NULL),
  (336, 29, '金昌市', 2, '', NULL),
  (337, 29, '白银市', 2, '', NULL),
  (338, 29, '天水市', 2, '', NULL),
  (339, 29, '武威市', 2, '', NULL),
  (340, 29, '张掖市', 2, '', NULL),
  (341, 29, '平凉市', 2, '', NULL),
  (342, 29, '酒泉市', 2, '', NULL),
  (343, 29, '庆阳市', 2, '', NULL),
  (344, 29, '定西市', 2, '', NULL),
  (345, 29, '陇南市', 2, '', NULL),
  (346, 29, '临夏回族自治州', 2, '', NULL),
  (347, 29, '甘南藏族自治州', 2, '', NULL),
  (348, 30, '西宁市', 2, '', NULL),
  (349, 30, '海东市', 2, '', NULL),
  (350, 30, '海北藏族自治州', 2, '', NULL),
  (351, 30, '黄南藏族自治州', 2, '', NULL),
  (352, 30, '海南藏族自治州', 2, '', NULL),
  (353, 30, '果洛藏族自治州', 2, '', NULL),
  (354, 30, '玉树藏族自治州', 2, '', NULL),
  (355, 30, '海西蒙古族藏族自治州', 2, '', NULL),
  (356, 31, '银川市', 2, '', NULL),
  (357, 31, '石嘴山市', 2, '', NULL),
  (358, 31, '吴忠市', 2, '', NULL),
  (359, 31, '固原市', 2, '', NULL),
  (360, 31, '中卫市', 2, '', NULL),
  (361, 32, '乌鲁木齐市', 2, '', NULL),
  (362, 32, '克拉玛依市', 2, '', NULL),
  (363, 32, '吐鲁番市', 2, '', NULL),
  (364, 32, '哈密地区', 2, '', NULL),
  (365, 32, '昌吉回族自治州', 2, '', NULL),
  (366, 32, '博尔塔拉蒙古自治州', 2, '', NULL),
  (367, 32, '巴音郭楞蒙古自治州', 2, '', NULL),
  (368, 32, '阿克苏地区', 2, '', NULL),
  (369, 32, '克孜勒苏柯尔克孜自治州', 2, '', NULL),
  (370, 32, '喀什地区', 2, '', NULL),
  (371, 32, '和田地区', 2, '', NULL),
  (372, 32, '伊犁哈萨克自治州', 2, '', NULL),
  (373, 32, '塔城地区', 2, '', NULL),
  (374, 32, '阿勒泰地区', 2, '', NULL),
  (375, 33, '台北市', 2, '', NULL),
  (376, 33, '高雄市', 2, '', NULL),
  (377, 33, '台南市', 2, '', NULL),
  (378, 33, '台中市', 2, '', NULL),
  (379, 33, '金门县', 2, '', NULL),
  (380, 33, '南投县', 2, '', NULL),
  (381, 33, '基隆市', 2, '', NULL),
  (382, 33, '新竹市', 2, '', NULL),
  (383, 33, '嘉义市', 2, '', NULL),
  (384, 33, '新北市', 2, '', NULL),
  (385, 33, '宜兰县', 2, '', NULL),
  (386, 33, '新竹县', 2, '', NULL),
  (387, 33, '桃园县', 2, '', NULL),
  (388, 33, '苗栗县', 2, '', NULL),
  (389, 33, '彰化县', 2, '', NULL),
  (390, 33, '嘉义县', 2, '', NULL),
  (391, 33, '云林县', 2, '', NULL),
  (392, 33, '屏东县', 2, '', NULL),
  (393, 33, '台东县', 2, '', NULL),
  (394, 33, '花莲县', 2, '', NULL),
  (395, 33, '澎湖县', 2, '', NULL),
  (396, 33, '连江县', 2, '', NULL),
  (397, 34, '香港岛', 2, '', NULL),
  (398, 34, '九龙', 2, '', NULL),
  (399, 34, '新界', 2, '', NULL),
  (400, 35, '澳门半岛', 2, '', NULL),
  (401, 35, '离岛', 2, '', NULL),
  (402, 36, '海外', 2, '', NULL),
  (403, 37, '东城区', 3, '', NULL),
  (404, 37, '西城区', 3, '', NULL),
  (405, 37, '崇文区', 3, '', NULL),
  (406, 37, '宣武区', 3, '', NULL),
  (407, 37, '朝阳区', 3, '', NULL),
  (408, 37, '丰台区', 3, '', NULL),
  (409, 37, '石景山区', 3, '', NULL),
  (410, 37, '海淀区', 3, '', NULL),
  (411, 37, '门头沟区', 3, '', NULL),
  (412, 37, '房山区', 3, '', NULL),
  (413, 37, '通州区', 3, '', NULL),
  (414, 37, '顺义区', 3, '', NULL),
  (415, 37, '昌平区', 3, '', NULL),
  (416, 37, '大兴区', 3, '', NULL),
  (417, 37, '怀柔区', 3, '', NULL),
  (418, 37, '平谷区', 3, '', NULL),
  (419, 37, '密云县', 3, '', NULL),
  (420, 37, '延庆县', 3, '', NULL),
  (421, 37, '其它区', 3, '', NULL),
  (422, 38, '和平区', 3, '', NULL),
  (423, 38, '河东区', 3, '', NULL),
  (424, 38, '河西区', 3, '', NULL),
  (425, 38, '南开区', 3, '', NULL),
  (426, 38, '河北区', 3, '', NULL),
  (427, 38, '红桥区', 3, '', NULL),
  (428, 38, '塘沽区', 3, '', NULL),
  (429, 38, '汉沽区', 3, '', NULL),
  (430, 38, '大港区', 3, '', NULL),
  (431, 38, '东丽区', 3, '', NULL),
  (432, 38, '西青区', 3, '', NULL),
  (433, 38, '津南区', 3, '', NULL),
  (434, 38, '北辰区', 3, '', NULL),
  (435, 38, '武清区', 3, '', NULL),
  (436, 38, '宝坻区', 3, '', NULL),
  (437, 38, '滨海新区', 3, '', NULL),
  (438, 38, '宁河县', 3, '', NULL),
  (439, 38, '静海县', 3, '', NULL),
  (440, 38, '蓟县', 3, '', NULL),
  (441, 38, '其它区', 3, '', NULL),
  (442, 39, '长安区', 3, '', NULL),
  (443, 39, '桥东区', 3, '', NULL),
  (444, 39, '桥西区', 3, '', NULL),
  (445, 39, '新华区', 3, '', NULL),
  (446, 39, '井陉矿区', 3, '', NULL),
  (447, 39, '裕华区', 3, '', NULL),
  (448, 39, '井陉县', 3, '', NULL),
  (449, 39, '正定县', 3, '', NULL),
  (450, 39, '栾城区', 3, '', NULL),
  (451, 39, '行唐县', 3, '', NULL),
  (452, 39, '灵寿县', 3, '', NULL),
  (453, 39, '高邑县', 3, '', NULL),
  (454, 39, '深泽县', 3, '', NULL),
  (455, 39, '赞皇县', 3, '', NULL),
  (456, 39, '无极县', 3, '', NULL),
  (457, 39, '平山县', 3, '', NULL),
  (458, 39, '元氏县', 3, '', NULL),
  (459, 39, '赵县', 3, '', NULL),
  (460, 39, '辛集市', 3, '', NULL),
  (461, 39, '藁城区', 3, '', NULL),
  (462, 39, '晋州市', 3, '', NULL),
  (463, 39, '新乐市', 3, '', NULL),
  (464, 39, '鹿泉区', 3, '', NULL),
  (465, 39, '其它区', 3, '', NULL),
  (466, 40, '路南区', 3, '', NULL),
  (467, 40, '路北区', 3, '', NULL),
  (468, 40, '古冶区', 3, '', NULL),
  (469, 40, '开平区', 3, '', NULL),
  (470, 40, '丰南区', 3, '', NULL),
  (471, 40, '丰润区', 3, '', NULL),
  (472, 40, '滦县', 3, '', NULL),
  (473, 40, '滦南县', 3, '', NULL),
  (474, 40, '乐亭县', 3, '', NULL),
  (475, 40, '迁西县', 3, '', NULL),
  (476, 40, '玉田县', 3, '', NULL),
  (477, 40, '曹妃甸区', 3, '', NULL),
  (478, 40, '遵化市', 3, '', NULL),
  (479, 40, '迁安市', 3, '', NULL),
  (480, 40, '其它区', 3, '', NULL),
  (481, 41, '海港区', 3, '', NULL),
  (482, 41, '山海关区', 3, '', NULL),
  (483, 41, '北戴河区', 3, '', NULL),
  (484, 41, '青龙满族自治县', 3, '', NULL),
  (485, 41, '昌黎县', 3, '', NULL),
  (486, 41, '抚宁县', 3, '', NULL),
  (487, 41, '卢龙县', 3, '', NULL),
  (488, 41, '其它区', 3, '', NULL),
  (489, 41, '经济技术开发区', 3, '', NULL),
  (490, 42, '邯山区', 3, '', NULL),
  (491, 42, '丛台区', 3, '', NULL),
  (492, 42, '复兴区', 3, '', NULL),
  (493, 42, '峰峰矿区', 3, '', NULL),
  (494, 42, '邯郸县', 3, '', NULL),
  (495, 42, '临漳县', 3, '', NULL),
  (496, 42, '成安县', 3, '', NULL),
  (497, 42, '大名县', 3, '', NULL),
  (498, 42, '涉县', 3, '', NULL),
  (499, 42, '磁县', 3, '', NULL),
  (500, 42, '肥乡县', 3, '', NULL),
  (501, 42, '永年县', 3, '', NULL),
  (502, 42, '邱县', 3, '', NULL),
  (503, 42, '鸡泽县', 3, '', NULL),
  (504, 42, '广平县', 3, '', NULL),
  (505, 42, '馆陶县', 3, '', NULL),
  (506, 42, '魏县', 3, '', NULL),
  (507, 42, '曲周县', 3, '', NULL),
  (508, 42, '武安市', 3, '', NULL),
  (509, 42, '其它区', 3, '', NULL),
  (510, 43, '桥东区', 3, '', NULL),
  (511, 43, '桥西区', 3, '', NULL),
  (512, 43, '邢台县', 3, '', NULL),
  (513, 43, '临城县', 3, '', NULL),
  (514, 43, '内丘县', 3, '', NULL),
  (515, 43, '柏乡县', 3, '', NULL),
  (516, 43, '隆尧县', 3, '', NULL),
  (517, 43, '任县', 3, '', NULL),
  (518, 43, '南和县', 3, '', NULL),
  (519, 43, '宁晋县', 3, '', NULL),
  (520, 43, '巨鹿县', 3, '', NULL),
  (521, 43, '新河县', 3, '', NULL),
  (522, 43, '广宗县', 3, '', NULL),
  (523, 43, '平乡县', 3, '', NULL),
  (524, 43, '威县', 3, '', NULL),
  (525, 43, '清河县', 3, '', NULL),
  (526, 43, '临西县', 3, '', NULL),
  (527, 43, '南宫市', 3, '', NULL),
  (528, 43, '沙河市', 3, '', NULL),
  (529, 43, '其它区', 3, '', NULL),
  (530, 44, '新市区', 3, '', NULL),
  (531, 44, '北市区', 3, '', NULL),
  (532, 44, '南市区', 3, '', NULL),
  (533, 44, '满城县', 3, '', NULL),
  (534, 44, '清苑县', 3, '', NULL),
  (535, 44, '涞水县', 3, '', NULL),
  (536, 44, '阜平县', 3, '', NULL),
  (537, 44, '徐水县', 3, '', NULL),
  (538, 44, '定兴县', 3, '', NULL),
  (539, 44, '唐县', 3, '', NULL),
  (540, 44, '高阳县', 3, '', NULL),
  (541, 44, '容城县', 3, '', NULL),
  (542, 44, '涞源县', 3, '', NULL),
  (543, 44, '望都县', 3, '', NULL),
  (544, 44, '安新县', 3, '', NULL),
  (545, 44, '易县', 3, '', NULL),
  (546, 44, '曲阳县', 3, '', NULL),
  (547, 44, '蠡县', 3, '', NULL),
  (548, 44, '顺平县', 3, '', NULL),
  (549, 44, '博野县', 3, '', NULL),
  (550, 44, '雄县', 3, '', NULL),
  (551, 44, '涿州市', 3, '', NULL),
  (552, 44, '定州市', 3, '', NULL),
  (553, 44, '安国市', 3, '', NULL),
  (554, 44, '高碑店市', 3, '', NULL),
  (555, 44, '高开区', 3, '', NULL),
  (556, 44, '其它区', 3, '', NULL),
  (557, 45, '桥东区', 3, '', NULL),
  (558, 45, '桥西区', 3, '', NULL),
  (559, 45, '宣化区', 3, '', NULL),
  (560, 45, '下花园区', 3, '', NULL),
  (561, 45, '宣化县', 3, '', NULL),
  (562, 45, '张北县', 3, '', NULL),
  (563, 45, '康保县', 3, '', NULL),
  (564, 45, '沽源县', 3, '', NULL),
  (565, 45, '尚义县', 3, '', NULL),
  (566, 45, '蔚县', 3, '', NULL),
  (567, 45, '阳原县', 3, '', NULL),
  (568, 45, '怀安县', 3, '', NULL),
  (569, 45, '万全县', 3, '', NULL),
  (570, 45, '怀来县', 3, '', NULL),
  (571, 45, '涿鹿县', 3, '', NULL),
  (572, 45, '赤城县', 3, '', NULL),
  (573, 45, '崇礼县', 3, '', NULL),
  (574, 45, '其它区', 3, '', NULL),
  (575, 46, '双桥区', 3, '', NULL),
  (576, 46, '双滦区', 3, '', NULL),
  (577, 46, '鹰手营子矿区', 3, '', NULL),
  (578, 46, '承德县', 3, '', NULL),
  (579, 46, '兴隆县', 3, '', NULL),
  (580, 46, '平泉县', 3, '', NULL),
  (581, 46, '滦平县', 3, '', NULL),
  (582, 46, '隆化县', 3, '', NULL),
  (583, 46, '丰宁满族自治县', 3, '', NULL),
  (584, 46, '宽城满族自治县', 3, '', NULL),
  (585, 46, '围场满族蒙古族自治县', 3, '', NULL),
  (586, 46, '其它区', 3, '', NULL),
  (587, 47, '新华区', 3, '', NULL),
  (588, 47, '运河区', 3, '', NULL),
  (589, 47, '沧县', 3, '', NULL),
  (590, 47, '青县', 3, '', NULL),
  (591, 47, '东光县', 3, '', NULL),
  (592, 47, '海兴县', 3, '', NULL),
  (593, 47, '盐山县', 3, '', NULL),
  (594, 47, '肃宁县', 3, '', NULL),
  (595, 47, '南皮县', 3, '', NULL),
  (596, 47, '吴桥县', 3, '', NULL),
  (597, 47, '献县', 3, '', NULL),
  (598, 47, '孟村回族自治县', 3, '', NULL),
  (599, 47, '泊头市', 3, '', NULL),
  (600, 47, '任丘市', 3, '', NULL),
  (601, 47, '黄骅市', 3, '', NULL),
  (602, 47, '河间市', 3, '', NULL),
  (603, 47, '其它区', 3, '', NULL),
  (604, 48, '安次区', 3, '', NULL),
  (605, 48, '广阳区', 3, '', NULL),
  (606, 48, '固安县', 3, '', NULL),
  (607, 48, '永清县', 3, '', NULL),
  (608, 48, '香河县', 3, '', NULL),
  (609, 48, '大城县', 3, '', NULL),
  (610, 48, '文安县', 3, '', NULL),
  (611, 48, '大厂回族自治县', 3, '', NULL),
  (612, 48, '开发区', 3, '', NULL),
  (613, 48, '燕郊经济技术开发区', 3, '', NULL),
  (614, 48, '霸州市', 3, '', NULL),
  (615, 48, '三河市', 3, '', NULL),
  (616, 48, '其它区', 3, '', NULL),
  (617, 49, '桃城区', 3, '', NULL),
  (618, 49, '枣强县', 3, '', NULL),
  (619, 49, '武邑县', 3, '', NULL),
  (620, 49, '武强县', 3, '', NULL),
  (621, 49, '饶阳县', 3, '', NULL),
  (622, 49, '安平县', 3, '', NULL),
  (623, 49, '故城县', 3, '', NULL),
  (624, 49, '景县', 3, '', NULL),
  (625, 49, '阜城县', 3, '', NULL),
  (626, 49, '冀州市', 3, '', NULL),
  (627, 49, '深州市', 3, '', NULL),
  (628, 49, '其它区', 3, '', NULL),
  (629, 50, '小店区', 3, '', NULL),
  (630, 50, '迎泽区', 3, '', NULL),
  (631, 50, '杏花岭区', 3, '', NULL),
  (632, 50, '尖草坪区', 3, '', NULL),
  (633, 50, '万柏林区', 3, '', NULL),
  (634, 50, '晋源区', 3, '', NULL),
  (635, 50, '清徐县', 3, '', NULL),
  (636, 50, '阳曲县', 3, '', NULL),
  (637, 50, '娄烦县', 3, '', NULL),
  (638, 50, '古交市', 3, '', NULL),
  (639, 50, '其它区', 3, '', NULL),
  (640, 51, '城区', 3, '', NULL),
  (641, 51, '矿区', 3, '', NULL),
  (642, 51, '南郊区', 3, '', NULL),
  (643, 51, '新荣区', 3, '', NULL),
  (644, 51, '阳高县', 3, '', NULL),
  (645, 51, '天镇县', 3, '', NULL),
  (646, 51, '广灵县', 3, '', NULL),
  (647, 51, '灵丘县', 3, '', NULL),
  (648, 51, '浑源县', 3, '', NULL),
  (649, 51, '左云县', 3, '', NULL),
  (650, 51, '大同县', 3, '', NULL),
  (651, 51, '其它区', 3, '', NULL),
  (652, 52, '城区', 3, '', NULL),
  (653, 52, '矿区', 3, '', NULL),
  (654, 52, '郊区', 3, '', NULL),
  (655, 52, '平定县', 3, '', NULL),
  (656, 52, '盂县', 3, '', NULL),
  (657, 52, '其它区', 3, '', NULL),
  (658, 53, '长治县', 3, '', NULL),
  (659, 53, '襄垣县', 3, '', NULL),
  (660, 53, '屯留县', 3, '', NULL),
  (661, 53, '平顺县', 3, '', NULL),
  (662, 53, '黎城县', 3, '', NULL),
  (663, 53, '壶关县', 3, '', NULL),
  (664, 53, '长子县', 3, '', NULL),
  (665, 53, '武乡县', 3, '', NULL),
  (666, 53, '沁县', 3, '', NULL),
  (667, 53, '沁源县', 3, '', NULL),
  (668, 53, '潞城市', 3, '', NULL),
  (669, 53, '城区', 3, '', NULL),
  (670, 53, '郊区', 3, '', NULL),
  (671, 53, '高新区', 3, '', NULL),
  (672, 53, '其它区', 3, '', NULL),
  (673, 54, '城区', 3, '', NULL),
  (674, 54, '沁水县', 3, '', NULL),
  (675, 54, '阳城县', 3, '', NULL),
  (676, 54, '陵川县', 3, '', NULL),
  (677, 54, '泽州县', 3, '', NULL),
  (678, 54, '高平市', 3, '', NULL),
  (679, 54, '其它区', 3, '', NULL),
  (680, 55, '朔城区', 3, '', NULL),
  (681, 55, '平鲁区', 3, '', NULL),
  (682, 55, '山阴县', 3, '', NULL),
  (683, 55, '应县', 3, '', NULL),
  (684, 55, '右玉县', 3, '', NULL),
  (685, 55, '怀仁县', 3, '', NULL),
  (686, 55, '其它区', 3, '', NULL),
  (687, 56, '榆次区', 3, '', NULL),
  (688, 56, '榆社县', 3, '', NULL),
  (689, 56, '左权县', 3, '', NULL),
  (690, 56, '和顺县', 3, '', NULL),
  (691, 56, '昔阳县', 3, '', NULL),
  (692, 56, '寿阳县', 3, '', NULL),
  (693, 56, '太谷县', 3, '', NULL),
  (694, 56, '祁县', 3, '', NULL),
  (695, 56, '平遥县', 3, '', NULL),
  (696, 56, '灵石县', 3, '', NULL),
  (697, 56, '介休市', 3, '', NULL),
  (698, 56, '其它区', 3, '', NULL),
  (699, 57, '盐湖区', 3, '', NULL),
  (700, 57, '临猗县', 3, '', NULL),
  (701, 57, '万荣县', 3, '', NULL),
  (702, 57, '闻喜县', 3, '', NULL),
  (703, 57, '稷山县', 3, '', NULL),
  (704, 57, '新绛县', 3, '', NULL),
  (705, 57, '绛县', 3, '', NULL),
  (706, 57, '垣曲县', 3, '', NULL),
  (707, 57, '夏县', 3, '', NULL),
  (708, 57, '平陆县', 3, '', NULL),
  (709, 57, '芮城县', 3, '', NULL),
  (710, 57, '永济市', 3, '', NULL),
  (711, 57, '河津市', 3, '', NULL),
  (712, 57, '其它区', 3, '', NULL),
  (713, 58, '忻府区', 3, '', NULL),
  (714, 58, '定襄县', 3, '', NULL),
  (715, 58, '五台县', 3, '', NULL),
  (716, 58, '代县', 3, '', NULL),
  (717, 58, '繁峙县', 3, '', NULL),
  (718, 58, '宁武县', 3, '', NULL),
  (719, 58, '静乐县', 3, '', NULL),
  (720, 58, '神池县', 3, '', NULL),
  (721, 58, '五寨县', 3, '', NULL),
  (722, 58, '岢岚县', 3, '', NULL),
  (723, 58, '河曲县', 3, '', NULL),
  (724, 58, '保德县', 3, '', NULL),
  (725, 58, '偏关县', 3, '', NULL),
  (726, 58, '原平市', 3, '', NULL),
  (727, 58, '其它区', 3, '', NULL),
  (728, 59, '尧都区', 3, '', NULL),
  (729, 59, '曲沃县', 3, '', NULL),
  (730, 59, '翼城县', 3, '', NULL),
  (731, 59, '襄汾县', 3, '', NULL),
  (732, 59, '洪洞县', 3, '', NULL),
  (733, 59, '古县', 3, '', NULL),
  (734, 59, '安泽县', 3, '', NULL),
  (735, 59, '浮山县', 3, '', NULL),
  (736, 59, '吉县', 3, '', NULL),
  (737, 59, '乡宁县', 3, '', NULL),
  (738, 59, '大宁县', 3, '', NULL),
  (739, 59, '隰县', 3, '', NULL),
  (740, 59, '永和县', 3, '', NULL),
  (741, 59, '蒲县', 3, '', NULL),
  (742, 59, '汾西县', 3, '', NULL),
  (743, 59, '侯马市', 3, '', NULL),
  (744, 59, '霍州市', 3, '', NULL),
  (745, 59, '其它区', 3, '', NULL),
  (746, 60, '离石区', 3, '', NULL),
  (747, 60, '文水县', 3, '', NULL),
  (748, 60, '交城县', 3, '', NULL),
  (749, 60, '兴县', 3, '', NULL),
  (750, 60, '临县', 3, '', NULL),
  (751, 60, '柳林县', 3, '', NULL),
  (752, 60, '石楼县', 3, '', NULL),
  (753, 60, '岚县', 3, '', NULL),
  (754, 60, '方山县', 3, '', NULL),
  (755, 60, '中阳县', 3, '', NULL),
  (756, 60, '交口县', 3, '', NULL),
  (757, 60, '孝义市', 3, '', NULL),
  (758, 60, '汾阳市', 3, '', NULL),
  (759, 60, '其它区', 3, '', NULL),
  (760, 61, '新城区', 3, '', NULL),
  (761, 61, '回民区', 3, '', NULL),
  (762, 61, '玉泉区', 3, '', NULL),
  (763, 61, '赛罕区', 3, '', NULL),
  (764, 61, '土默特左旗', 3, '', NULL),
  (765, 61, '托克托县', 3, '', NULL),
  (766, 61, '和林格尔县', 3, '', NULL),
  (767, 61, '清水河县', 3, '', NULL),
  (768, 61, '武川县', 3, '', NULL),
  (769, 61, '其它区', 3, '', NULL),
  (770, 62, '东河区', 3, '', NULL),
  (771, 62, '昆都仑区', 3, '', NULL),
  (772, 62, '青山区', 3, '', NULL),
  (773, 62, '石拐区', 3, '', NULL),
  (774, 62, '白云鄂博矿区', 3, '', NULL),
  (775, 62, '九原区', 3, '', NULL),
  (776, 62, '土默特右旗', 3, '', NULL),
  (777, 62, '固阳县', 3, '', NULL),
  (778, 62, '达尔罕茂明安联合旗', 3, '', NULL),
  (779, 62, '其它区', 3, '', NULL),
  (780, 63, '海勃湾区', 3, '', NULL),
  (781, 63, '海南区', 3, '', NULL),
  (782, 63, '乌达区', 3, '', NULL),
  (783, 63, '其它区', 3, '', NULL),
  (784, 64, '红山区', 3, '', NULL),
  (785, 64, '元宝山区', 3, '', NULL),
  (786, 64, '松山区', 3, '', NULL),
  (787, 64, '阿鲁科尔沁旗', 3, '', NULL),
  (788, 64, '巴林左旗', 3, '', NULL),
  (789, 64, '巴林右旗', 3, '', NULL),
  (790, 64, '林西县', 3, '', NULL),
  (791, 64, '克什克腾旗', 3, '', NULL),
  (792, 64, '翁牛特旗', 3, '', NULL),
  (793, 64, '喀喇沁旗', 3, '', NULL),
  (794, 64, '宁城县', 3, '', NULL),
  (795, 64, '敖汉旗', 3, '', NULL),
  (796, 64, '其它区', 3, '', NULL),
  (797, 65, '科尔沁区', 3, '', NULL),
  (798, 65, '科尔沁左翼中旗', 3, '', NULL),
  (799, 65, '科尔沁左翼后旗', 3, '', NULL),
  (800, 65, '开鲁县', 3, '', NULL),
  (801, 65, '库伦旗', 3, '', NULL),
  (802, 65, '奈曼旗', 3, '', NULL),
  (803, 65, '扎鲁特旗', 3, '', NULL),
  (804, 65, '霍林郭勒市', 3, '', NULL),
  (805, 65, '其它区', 3, '', NULL),
  (806, 66, '东胜区', 3, '', NULL),
  (807, 66, '达拉特旗', 3, '', NULL),
  (808, 66, '准格尔旗', 3, '', NULL),
  (809, 66, '鄂托克前旗', 3, '', NULL),
  (810, 66, '鄂托克旗', 3, '', NULL),
  (811, 66, '杭锦旗', 3, '', NULL),
  (812, 66, '乌审旗', 3, '', NULL),
  (813, 66, '伊金霍洛旗', 3, '', NULL),
  (814, 66, '其它区', 3, '', NULL),
  (815, 67, '海拉尔区', 3, '', NULL),
  (816, 67, '扎赉诺尔区', 3, '', NULL),
  (817, 67, '阿荣旗', 3, '', NULL),
  (818, 67, '莫力达瓦达斡尔族自治旗', 3, '', NULL),
  (819, 67, '鄂伦春自治旗', 3, '', NULL),
  (820, 67, '鄂温克族自治旗', 3, '', NULL),
  (821, 67, '陈巴尔虎旗', 3, '', NULL),
  (822, 67, '新巴尔虎左旗', 3, '', NULL),
  (823, 67, '新巴尔虎右旗', 3, '', NULL),
  (824, 67, '满洲里市', 3, '', NULL),
  (825, 67, '牙克石市', 3, '', NULL),
  (826, 67, '扎兰屯市', 3, '', NULL),
  (827, 67, '额尔古纳市', 3, '', NULL),
  (828, 67, '根河市', 3, '', NULL),
  (829, 67, '其它区', 3, '', NULL),
  (830, 68, '临河区', 3, '', NULL),
  (831, 68, '五原县', 3, '', NULL),
  (832, 68, '磴口县', 3, '', NULL),
  (833, 68, '乌拉特前旗', 3, '', NULL),
  (834, 68, '乌拉特中旗', 3, '', NULL),
  (835, 68, '乌拉特后旗', 3, '', NULL),
  (836, 68, '杭锦后旗', 3, '', NULL),
  (837, 68, '其它区', 3, '', NULL),
  (838, 69, '集宁区', 3, '', NULL),
  (839, 69, '卓资县', 3, '', NULL),
  (840, 69, '化德县', 3, '', NULL),
  (841, 69, '商都县', 3, '', NULL),
  (842, 69, '兴和县', 3, '', NULL),
  (843, 69, '凉城县', 3, '', NULL),
  (844, 69, '察哈尔右翼前旗', 3, '', NULL),
  (845, 69, '察哈尔右翼中旗', 3, '', NULL),
  (846, 69, '察哈尔右翼后旗', 3, '', NULL),
  (847, 69, '四子王旗', 3, '', NULL),
  (848, 69, '丰镇市', 3, '', NULL),
  (849, 69, '其它区', 3, '', NULL),
  (850, 70, '乌兰浩特市', 3, '', NULL),
  (851, 70, '阿尔山市', 3, '', NULL),
  (852, 70, '科尔沁右翼前旗', 3, '', NULL),
  (853, 70, '科尔沁右翼中旗', 3, '', NULL),
  (854, 70, '扎赉特旗', 3, '', NULL),
  (855, 70, '突泉县', 3, '', NULL),
  (856, 70, '其它区', 3, '', NULL),
  (857, 71, '二连浩特市', 3, '', NULL),
  (858, 71, '锡林浩特市', 3, '', NULL),
  (859, 71, '阿巴嘎旗', 3, '', NULL),
  (860, 71, '苏尼特左旗', 3, '', NULL),
  (861, 71, '苏尼特右旗', 3, '', NULL),
  (862, 71, '东乌珠穆沁旗', 3, '', NULL),
  (863, 71, '西乌珠穆沁旗', 3, '', NULL),
  (864, 71, '太仆寺旗', 3, '', NULL),
  (865, 71, '镶黄旗', 3, '', NULL),
  (866, 71, '正镶白旗', 3, '', NULL),
  (867, 71, '正蓝旗', 3, '', NULL),
  (868, 71, '多伦县', 3, '', NULL),
  (869, 71, '其它区', 3, '', NULL),
  (870, 72, '阿拉善左旗', 3, '', NULL),
  (871, 72, '阿拉善右旗', 3, '', NULL),
  (872, 72, '额济纳旗', 3, '', NULL),
  (873, 72, '其它区', 3, '', NULL),
  (874, 73, '和平区', 3, '', NULL),
  (875, 73, '沈河区', 3, '', NULL),
  (876, 73, '大东区', 3, '', NULL),
  (877, 73, '皇姑区', 3, '', NULL),
  (878, 73, '铁西区', 3, '', NULL),
  (879, 73, '苏家屯区', 3, '', NULL),
  (880, 73, '浑南区', 3, '', NULL),
  (881, 73, '新城子区', 3, '', NULL),
  (882, 73, '于洪区', 3, '', NULL),
  (883, 73, '辽中县', 3, '', NULL),
  (884, 73, '康平县', 3, '', NULL),
  (885, 73, '法库县', 3, '', NULL),
  (886, 73, '新民市', 3, '', NULL),
  (887, 73, '浑南新区', 3, '', NULL),
  (888, 73, '张士开发区', 3, '', NULL),
  (889, 73, '沈北新区', 3, '', NULL),
  (890, 73, '其它区', 3, '', NULL),
  (891, 74, '中山区', 3, '', NULL),
  (892, 74, '西岗区', 3, '', NULL),
  (893, 74, '沙河口区', 3, '', NULL),
  (894, 74, '甘井子区', 3, '', NULL),
  (895, 74, '旅顺口区', 3, '', NULL),
  (896, 74, '金州区', 3, '', NULL),
  (897, 74, '长海县', 3, '', NULL),
  (898, 74, '开发区', 3, '', NULL),
  (899, 74, '瓦房店市', 3, '', NULL),
  (900, 74, '普兰店市', 3, '', NULL),
  (901, 74, '庄河市', 3, '', NULL),
  (902, 74, '岭前区', 3, '', NULL),
  (903, 74, '其它区', 3, '', NULL),
  (904, 75, '铁东区', 3, '', NULL),
  (905, 75, '铁西区', 3, '', NULL),
  (906, 75, '立山区', 3, '', NULL),
  (907, 75, '千山区', 3, '', NULL),
  (908, 75, '台安县', 3, '', NULL),
  (909, 75, '岫岩满族自治县', 3, '', NULL),
  (910, 75, '高新区', 3, '', NULL),
  (911, 75, '海城市', 3, '', NULL),
  (912, 75, '其它区', 3, '', NULL),
  (913, 76, '新抚区', 3, '', NULL),
  (914, 76, '东洲区', 3, '', NULL),
  (915, 76, '望花区', 3, '', NULL),
  (916, 76, '顺城区', 3, '', NULL),
  (917, 76, '抚顺县', 3, '', NULL),
  (918, 76, '新宾满族自治县', 3, '', NULL),
  (919, 76, '清原满族自治县', 3, '', NULL),
  (920, 76, '其它区', 3, '', NULL),
  (921, 77, '平山区', 3, '', NULL),
  (922, 77, '溪湖区', 3, '', NULL),
  (923, 77, '明山区', 3, '', NULL),
  (924, 77, '南芬区', 3, '', NULL),
  (925, 77, '本溪满族自治县', 3, '', NULL),
  (926, 77, '桓仁满族自治县', 3, '', NULL),
  (927, 77, '其它区', 3, '', NULL),
  (928, 78, '元宝区', 3, '', NULL),
  (929, 78, '振兴区', 3, '', NULL),
  (930, 78, '振安区', 3, '', NULL),
  (931, 78, '宽甸满族自治县', 3, '', NULL),
  (932, 78, '东港市', 3, '', NULL),
  (933, 78, '凤城市', 3, '', NULL),
  (934, 78, '其它区', 3, '', NULL),
  (935, 79, '古塔区', 3, '', NULL),
  (936, 79, '凌河区', 3, '', NULL),
  (937, 79, '太和区', 3, '', NULL),
  (938, 79, '黑山县', 3, '', NULL),
  (939, 79, '义县', 3, '', NULL),
  (940, 79, '凌海市', 3, '', NULL),
  (941, 79, '北镇市', 3, '', NULL),
  (942, 79, '其它区', 3, '', NULL),
  (943, 80, '站前区', 3, '', NULL),
  (944, 80, '西市区', 3, '', NULL),
  (945, 80, '鲅鱼圈区', 3, '', NULL),
  (946, 80, '老边区', 3, '', NULL),
  (947, 80, '盖州市', 3, '', NULL),
  (948, 80, '大石桥市', 3, '', NULL),
  (949, 80, '其它区', 3, '', NULL),
  (950, 81, '海州区', 3, '', NULL),
  (951, 81, '新邱区', 3, '', NULL),
  (952, 81, '太平区', 3, '', NULL),
  (953, 81, '清河门区', 3, '', NULL),
  (954, 81, '细河区', 3, '', NULL),
  (955, 81, '阜新蒙古族自治县', 3, '', NULL),
  (956, 81, '彰武县', 3, '', NULL),
  (957, 81, '其它区', 3, '', NULL),
  (958, 82, '白塔区', 3, '', NULL),
  (959, 82, '文圣区', 3, '', NULL),
  (960, 82, '宏伟区', 3, '', NULL),
  (961, 82, '弓长岭区', 3, '', NULL),
  (962, 82, '太子河区', 3, '', NULL),
  (963, 82, '辽阳县', 3, '', NULL),
  (964, 82, '灯塔市', 3, '', NULL),
  (965, 82, '其它区', 3, '', NULL),
  (966, 83, '双台子区', 3, '', NULL),
  (967, 83, '兴隆台区', 3, '', NULL),
  (968, 83, '大洼县', 3, '', NULL),
  (969, 83, '盘山县', 3, '', NULL),
  (970, 83, '其它区', 3, '', NULL),
  (971, 84, '银州区', 3, '', NULL),
  (972, 84, '清河区', 3, '', NULL),
  (973, 84, '铁岭县', 3, '', NULL),
  (974, 84, '西丰县', 3, '', NULL),
  (975, 84, '昌图县', 3, '', NULL),
  (976, 84, '调兵山市', 3, '', NULL),
  (977, 84, '开原市', 3, '', NULL),
  (978, 84, '其它区', 3, '', NULL),
  (979, 85, '双塔区', 3, '', NULL),
  (980, 85, '龙城区', 3, '', NULL),
  (981, 85, '朝阳县', 3, '', NULL),
  (982, 85, '建平县', 3, '', NULL),
  (983, 85, '喀喇沁左翼蒙古族自治县', 3, '', NULL),
  (984, 85, '北票市', 3, '', NULL),
  (985, 85, '凌源市', 3, '', NULL),
  (986, 85, '其它区', 3, '', NULL),
  (987, 86, '连山区', 3, '', NULL),
  (988, 86, '龙港区', 3, '', NULL),
  (989, 86, '南票区', 3, '', NULL),
  (990, 86, '绥中县', 3, '', NULL),
  (991, 86, '建昌县', 3, '', NULL),
  (992, 86, '兴城市', 3, '', NULL),
  (993, 86, '其它区', 3, '', NULL),
  (994, 87, '南关区', 3, '', NULL),
  (995, 87, '宽城区', 3, '', NULL),
  (996, 87, '朝阳区', 3, '', NULL),
  (997, 87, '二道区', 3, '', NULL),
  (998, 87, '绿园区', 3, '', NULL),
  (999, 87, '双阳区', 3, '', NULL),
  (1000, 87, '农安县', 3, '', NULL),
  (1001, 87, '九台区', 3, '', NULL),
  (1002, 87, '榆树市', 3, '', NULL),
  (1003, 87, '德惠市', 3, '', NULL),
  (1004, 87, '高新技术产业开发区', 3, '', NULL),
  (1005, 87, '汽车产业开发区', 3, '', NULL),
  (1006, 87, '经济技术开发区', 3, '', NULL),
  (1007, 87, '净月旅游开发区', 3, '', NULL),
  (1008, 87, '其它区', 3, '', NULL),
  (1009, 88, '昌邑区', 3, '', NULL),
  (1010, 88, '龙潭区', 3, '', NULL),
  (1011, 88, '船营区', 3, '', NULL),
  (1012, 88, '丰满区', 3, '', NULL),
  (1013, 88, '永吉县', 3, '', NULL),
  (1014, 88, '蛟河市', 3, '', NULL),
  (1015, 88, '桦甸市', 3, '', NULL),
  (1016, 88, '舒兰市', 3, '', NULL),
  (1017, 88, '磐石市', 3, '', NULL),
  (1018, 88, '其它区', 3, '', NULL),
  (1019, 89, '铁西区', 3, '', NULL),
  (1020, 89, '铁东区', 3, '', NULL),
  (1021, 89, '梨树县', 3, '', NULL),
  (1022, 89, '伊通满族自治县', 3, '', NULL),
  (1023, 89, '公主岭市', 3, '', NULL),
  (1024, 89, '双辽市', 3, '', NULL),
  (1025, 89, '其它区', 3, '', NULL),
  (1026, 90, '龙山区', 3, '', NULL),
  (1027, 90, '西安区', 3, '', NULL),
  (1028, 90, '东丰县', 3, '', NULL),
  (1029, 90, '东辽县', 3, '', NULL),
  (1030, 90, '其它区', 3, '', NULL),
  (1031, 91, '东昌区', 3, '', NULL),
  (1032, 91, '二道江区', 3, '', NULL),
  (1033, 91, '通化县', 3, '', NULL),
  (1034, 91, '辉南县', 3, '', NULL),
  (1035, 91, '柳河县', 3, '', NULL),
  (1036, 91, '梅河口市', 3, '', NULL),
  (1037, 91, '集安市', 3, '', NULL),
  (1038, 91, '其它区', 3, '', NULL),
  (1039, 92, '浑江区', 3, '', NULL),
  (1040, 92, '抚松县', 3, '', NULL),
  (1041, 92, '靖宇县', 3, '', NULL),
  (1042, 92, '长白朝鲜族自治县', 3, '', NULL),
  (1043, 92, '江源区', 3, '', NULL),
  (1044, 92, '临江市', 3, '', NULL),
  (1045, 92, '其它区', 3, '', NULL),
  (1046, 93, '宁江区', 3, '', NULL),
  (1047, 93, '前郭尔罗斯蒙古族自治县', 3, '', NULL),
  (1048, 93, '长岭县', 3, '', NULL),
  (1049, 93, '乾安县', 3, '', NULL),
  (1050, 93, '扶余市', 3, '', NULL),
  (1051, 93, '其它区', 3, '', NULL),
  (1052, 94, '洮北区', 3, '', NULL),
  (1053, 94, '镇赉县', 3, '', NULL),
  (1054, 94, '通榆县', 3, '', NULL),
  (1055, 94, '洮南市', 3, '', NULL),
  (1056, 94, '大安市', 3, '', NULL),
  (1057, 94, '其它区', 3, '', NULL),
  (1058, 95, '延吉市', 3, '', NULL),
  (1059, 95, '图们市', 3, '', NULL),
  (1060, 95, '敦化市', 3, '', NULL),
  (1061, 95, '珲春市', 3, '', NULL),
  (1062, 95, '龙井市', 3, '', NULL),
  (1063, 95, '和龙市', 3, '', NULL),
  (1064, 95, '汪清县', 3, '', NULL),
  (1065, 95, '安图县', 3, '', NULL),
  (1066, 95, '其它区', 3, '', NULL),
  (1067, 96, '道里区', 3, '', NULL),
  (1068, 96, '南岗区', 3, '', NULL),
  (1069, 96, '道外区', 3, '', NULL),
  (1070, 96, '香坊区', 3, '', NULL),
  (1071, 96, '动力区', 3, '', NULL),
  (1072, 96, '平房区', 3, '', NULL),
  (1073, 96, '松北区', 3, '', NULL),
  (1074, 96, '呼兰区', 3, '', NULL),
  (1075, 96, '依兰县', 3, '', NULL),
  (1076, 96, '方正县', 3, '', NULL),
  (1077, 96, '宾县', 3, '', NULL),
  (1078, 96, '巴彦县', 3, '', NULL),
  (1079, 96, '木兰县', 3, '', NULL),
  (1080, 96, '通河县', 3, '', NULL),
  (1081, 96, '延寿县', 3, '', NULL),
  (1082, 96, '阿城区', 3, '', NULL),
  (1083, 96, '双城区', 3, '', NULL),
  (1084, 96, '尚志市', 3, '', NULL),
  (1085, 96, '五常市', 3, '', NULL),
  (1086, 96, '阿城市', 3, '', NULL),
  (1087, 96, '其它区', 3, '', NULL),
  (1088, 97, '龙沙区', 3, '', NULL),
  (1089, 97, '建华区', 3, '', NULL),
  (1090, 97, '铁锋区', 3, '', NULL),
  (1091, 97, '昂昂溪区', 3, '', NULL),
  (1092, 97, '富拉尔基区', 3, '', NULL),
  (1093, 97, '碾子山区', 3, '', NULL),
  (1094, 97, '梅里斯达斡尔族区', 3, '', NULL),
  (1095, 97, '龙江县', 3, '', NULL),
  (1096, 97, '依安县', 3, '', NULL),
  (1097, 97, '泰来县', 3, '', NULL),
  (1098, 97, '甘南县', 3, '', NULL),
  (1099, 97, '富裕县', 3, '', NULL),
  (1100, 97, '克山县', 3, '', NULL),
  (1101, 97, '克东县', 3, '', NULL),
  (1102, 97, '拜泉县', 3, '', NULL),
  (1103, 97, '讷河市', 3, '', NULL),
  (1104, 97, '其它区', 3, '', NULL),
  (1105, 98, '鸡冠区', 3, '', NULL),
  (1106, 98, '恒山区', 3, '', NULL),
  (1107, 98, '滴道区', 3, '', NULL),
  (1108, 98, '梨树区', 3, '', NULL),
  (1109, 98, '城子河区', 3, '', NULL),
  (1110, 98, '麻山区', 3, '', NULL),
  (1111, 98, '鸡东县', 3, '', NULL),
  (1112, 98, '虎林市', 3, '', NULL),
  (1113, 98, '密山市', 3, '', NULL),
  (1114, 98, '其它区', 3, '', NULL),
  (1115, 99, '向阳区', 3, '', NULL),
  (1116, 99, '工农区', 3, '', NULL),
  (1117, 99, '南山区', 3, '', NULL),
  (1118, 99, '兴安区', 3, '', NULL),
  (1119, 99, '东山区', 3, '', NULL),
  (1120, 99, '兴山区', 3, '', NULL),
  (1121, 99, '萝北县', 3, '', NULL),
  (1122, 99, '绥滨县', 3, '', NULL),
  (1123, 99, '其它区', 3, '', NULL),
  (1124, 100, '尖山区', 3, '', NULL),
  (1125, 100, '岭东区', 3, '', NULL),
  (1126, 100, '四方台区', 3, '', NULL),
  (1127, 100, '宝山区', 3, '', NULL),
  (1128, 100, '集贤县', 3, '', NULL),
  (1129, 100, '友谊县', 3, '', NULL),
  (1130, 100, '宝清县', 3, '', NULL),
  (1131, 100, '饶河县', 3, '', NULL),
  (1132, 100, '其它区', 3, '', NULL),
  (1133, 101, '萨尔图区', 3, '', NULL),
  (1134, 101, '龙凤区', 3, '', NULL),
  (1135, 101, '让胡路区', 3, '', NULL),
  (1136, 101, '红岗区', 3, '', NULL),
  (1137, 101, '大同区', 3, '', NULL),
  (1138, 101, '肇州县', 3, '', NULL),
  (1139, 101, '肇源县', 3, '', NULL),
  (1140, 101, '林甸县', 3, '', NULL),
  (1141, 101, '杜尔伯特蒙古族自治县', 3, '', NULL),
  (1142, 101, '其它区', 3, '', NULL),
  (1143, 102, '伊春区', 3, '', NULL),
  (1144, 102, '南岔区', 3, '', NULL),
  (1145, 102, '友好区', 3, '', NULL),
  (1146, 102, '西林区', 3, '', NULL),
  (1147, 102, '翠峦区', 3, '', NULL),
  (1148, 102, '新青区', 3, '', NULL),
  (1149, 102, '美溪区', 3, '', NULL),
  (1150, 102, '金山屯区', 3, '', NULL),
  (1151, 102, '五营区', 3, '', NULL),
  (1152, 102, '乌马河区', 3, '', NULL),
  (1153, 102, '汤旺河区', 3, '', NULL),
  (1154, 102, '带岭区', 3, '', NULL),
  (1155, 102, '乌伊岭区', 3, '', NULL),
  (1156, 102, '红星区', 3, '', NULL),
  (1157, 102, '上甘岭区', 3, '', NULL),
  (1158, 102, '嘉荫县', 3, '', NULL),
  (1159, 102, '铁力市', 3, '', NULL),
  (1160, 102, '其它区', 3, '', NULL),
  (1161, 103, '永红区', 3, '', NULL),
  (1162, 103, '向阳区', 3, '', NULL),
  (1163, 103, '前进区', 3, '', NULL),
  (1164, 103, '东风区', 3, '', NULL),
  (1165, 103, '郊区', 3, '', NULL),
  (1166, 103, '桦南县', 3, '', NULL),
  (1167, 103, '桦川县', 3, '', NULL),
  (1168, 103, '汤原县', 3, '', NULL),
  (1169, 103, '抚远县', 3, '', NULL),
  (1170, 103, '同江市', 3, '', NULL),
  (1171, 103, '富锦市', 3, '', NULL),
  (1172, 103, '其它区', 3, '', NULL),
  (1173, 104, '新兴区', 3, '', NULL),
  (1174, 104, '桃山区', 3, '', NULL),
  (1175, 104, '茄子河区', 3, '', NULL),
  (1176, 104, '勃利县', 3, '', NULL),
  (1177, 104, '其它区', 3, '', NULL),
  (1178, 105, '东安区', 3, '', NULL),
  (1179, 105, '阳明区', 3, '', NULL),
  (1180, 105, '爱民区', 3, '', NULL),
  (1181, 105, '西安区', 3, '', NULL),
  (1182, 105, '东宁县', 3, '', NULL),
  (1183, 105, '林口县', 3, '', NULL),
  (1184, 105, '绥芬河市', 3, '', NULL),
  (1185, 105, '海林市', 3, '', NULL),
  (1186, 105, '宁安市', 3, '', NULL),
  (1187, 105, '穆棱市', 3, '', NULL),
  (1188, 105, '其它区', 3, '', NULL),
  (1189, 106, '爱辉区', 3, '', NULL),
  (1190, 106, '嫩江县', 3, '', NULL),
  (1191, 106, '逊克县', 3, '', NULL),
  (1192, 106, '孙吴县', 3, '', NULL),
  (1193, 106, '北安市', 3, '', NULL),
  (1194, 106, '五大连池市', 3, '', NULL),
  (1195, 106, '其它区', 3, '', NULL),
  (1196, 107, '北林区', 3, '', NULL),
  (1197, 107, '望奎县', 3, '', NULL),
  (1198, 107, '兰西县', 3, '', NULL),
  (1199, 107, '青冈县', 3, '', NULL),
  (1200, 107, '庆安县', 3, '', NULL),
  (1201, 107, '明水县', 3, '', NULL),
  (1202, 107, '绥棱县', 3, '', NULL),
  (1203, 107, '安达市', 3, '', NULL),
  (1204, 107, '肇东市', 3, '', NULL),
  (1205, 107, '海伦市', 3, '', NULL),
  (1206, 107, '其它区', 3, '', NULL),
  (1207, 108, '松岭区', 3, '', NULL),
  (1208, 108, '新林区', 3, '', NULL),
  (1209, 108, '呼中区', 3, '', NULL),
  (1210, 108, '呼玛县', 3, '', NULL),
  (1211, 108, '塔河县', 3, '', NULL),
  (1212, 108, '漠河县', 3, '', NULL),
  (1213, 108, '加格达奇区', 3, '', NULL),
  (1214, 108, '其它区', 3, '', NULL),
  (1215, 109, '黄浦区', 3, '', NULL),
  (1216, 109, '卢湾区', 3, '', NULL),
  (1217, 109, '徐汇区', 3, '', NULL),
  (1218, 109, '长宁区', 3, '', NULL),
  (1219, 109, '静安区', 3, '', NULL),
  (1220, 109, '普陀区', 3, '', NULL),
  (1221, 109, '闸北区', 3, '', NULL),
  (1222, 109, '虹口区', 3, '', NULL),
  (1223, 109, '杨浦区', 3, '', NULL),
  (1224, 109, '闵行区', 3, '', NULL),
  (1225, 109, '宝山区', 3, '', NULL),
  (1226, 109, '嘉定区', 3, '', NULL),
  (1227, 109, '浦东新区', 3, '', NULL),
  (1228, 109, '金山区', 3, '', NULL),
  (1229, 109, '松江区', 3, '', NULL),
  (1230, 109, '青浦区', 3, '', NULL),
  (1231, 109, '南汇区', 3, '', NULL),
  (1232, 109, '奉贤区', 3, '', NULL),
  (1233, 109, '川沙区', 3, '', NULL),
  (1234, 109, '崇明县', 3, '', NULL),
  (1235, 109, '其它区', 3, '', NULL),
  (1236, 110, '玄武区', 3, '', NULL),
  (1237, 110, '白下区', 3, '', NULL),
  (1238, 110, '秦淮区', 3, '', NULL),
  (1239, 110, '建邺区', 3, '', NULL),
  (1240, 110, '鼓楼区', 3, '', NULL),
  (1241, 110, '下关区', 3, '', NULL),
  (1242, 110, '浦口区', 3, '', NULL),
  (1243, 110, '栖霞区', 3, '', NULL),
  (1244, 110, '雨花台区', 3, '', NULL),
  (1245, 110, '江宁区', 3, '', NULL),
  (1246, 110, '六合区', 3, '', NULL),
  (1247, 110, '溧水区', 3, '', NULL),
  (1248, 110, '高淳区', 3, '', NULL),
  (1249, 110, '其它区', 3, '', NULL),
  (1250, 111, '崇安区', 3, '', NULL),
  (1251, 111, '南长区', 3, '', NULL),
  (1252, 111, '北塘区', 3, '', NULL),
  (1253, 111, '锡山区', 3, '', NULL),
  (1254, 111, '惠山区', 3, '', NULL),
  (1255, 111, '滨湖区', 3, '', NULL),
  (1256, 111, '江阴市', 3, '', NULL),
  (1257, 111, '宜兴市', 3, '', NULL),
  (1258, 111, '新区', 3, '', NULL),
  (1259, 111, '其它区', 3, '', NULL),
  (1260, 112, '鼓楼区', 3, '', NULL),
  (1261, 112, '云龙区', 3, '', NULL),
  (1262, 112, '九里区', 3, '', NULL),
  (1263, 112, '贾汪区', 3, '', NULL),
  (1264, 112, '泉山区', 3, '', NULL),
  (1265, 112, '丰县', 3, '', NULL),
  (1266, 112, '沛县', 3, '', NULL),
  (1267, 112, '铜山区', 3, '', NULL),
  (1268, 112, '睢宁县', 3, '', NULL),
  (1269, 112, '新沂市', 3, '', NULL),
  (1270, 112, '邳州市', 3, '', NULL),
  (1271, 112, '其它区', 3, '', NULL),
  (1272, 113, '天宁区', 3, '', NULL),
  (1273, 113, '钟楼区', 3, '', NULL),
  (1274, 113, '戚墅堰区', 3, '', NULL),
  (1275, 113, '新北区', 3, '', NULL),
  (1276, 113, '武进区', 3, '', NULL),
  (1277, 113, '溧阳市', 3, '', NULL),
  (1278, 113, '金坛市', 3, '', NULL),
  (1279, 113, '其它区', 3, '', NULL),
  (1280, 114, '沧浪区', 3, '', NULL),
  (1281, 114, '平江区', 3, '', NULL),
  (1282, 114, '金阊区', 3, '', NULL),
  (1283, 114, '虎丘区', 3, '', NULL),
  (1284, 114, '吴中区', 3, '', NULL),
  (1285, 114, '相城区', 3, '', NULL),
  (1286, 114, '姑苏区', 3, '', NULL),
  (1287, 114, '常熟市', 3, '', NULL),
  (1288, 114, '张家港市', 3, '', NULL),
  (1289, 114, '昆山市', 3, '', NULL),
  (1290, 114, '吴江区', 3, '', NULL),
  (1291, 114, '太仓市', 3, '', NULL),
  (1292, 114, '新区', 3, '', NULL),
  (1293, 114, '园区', 3, '', NULL),
  (1294, 114, '其它区', 3, '', NULL),
  (1295, 115, '崇川区', 3, '', NULL),
  (1296, 115, '港闸区', 3, '', NULL),
  (1297, 115, '通州区', 3, '', NULL),
  (1298, 115, '海安县', 3, '', NULL),
  (1299, 115, '如东县', 3, '', NULL),
  (1300, 115, '启东市', 3, '', NULL),
  (1301, 115, '如皋市', 3, '', NULL),
  (1302, 115, '通州市', 3, '', NULL),
  (1303, 115, '海门市', 3, '', NULL),
  (1304, 115, '开发区', 3, '', NULL),
  (1305, 115, '其它区', 3, '', NULL),
  (1306, 116, '连云区', 3, '', NULL),
  (1307, 116, '新浦区', 3, '', NULL),
  (1308, 116, '海州区', 3, '', NULL),
  (1309, 116, '赣榆区', 3, '', NULL),
  (1310, 116, '东海县', 3, '', NULL),
  (1311, 116, '灌云县', 3, '', NULL),
  (1312, 116, '灌南县', 3, '', NULL),
  (1313, 116, '其它区', 3, '', NULL),
  (1314, 117, '清河区', 3, '', NULL),
  (1315, 117, '淮安区', 3, '', NULL),
  (1316, 117, '淮阴区', 3, '', NULL),
  (1317, 117, '清浦区', 3, '', NULL),
  (1318, 117, '涟水县', 3, '', NULL),
  (1319, 117, '洪泽县', 3, '', NULL),
  (1320, 117, '盱眙县', 3, '', NULL),
  (1321, 117, '金湖县', 3, '', NULL),
  (1322, 117, '其它区', 3, '', NULL),
  (1323, 118, '亭湖区', 3, '', NULL),
  (1324, 118, '盐都区', 3, '', NULL),
  (1325, 118, '响水县', 3, '', NULL),
  (1326, 118, '滨海县', 3, '', NULL),
  (1327, 118, '阜宁县', 3, '', NULL),
  (1328, 118, '射阳县', 3, '', NULL),
  (1329, 118, '建湖县', 3, '', NULL),
  (1330, 118, '东台市', 3, '', NULL),
  (1331, 118, '大丰市', 3, '', NULL),
  (1332, 118, '其它区', 3, '', NULL),
  (1333, 119, '广陵区', 3, '', NULL),
  (1334, 119, '邗江区', 3, '', NULL),
  (1335, 119, '维扬区', 3, '', NULL),
  (1336, 119, '宝应县', 3, '', NULL),
  (1337, 119, '仪征市', 3, '', NULL),
  (1338, 119, '高邮市', 3, '', NULL),
  (1339, 119, '江都区', 3, '', NULL),
  (1340, 119, '经济开发区', 3, '', NULL),
  (1341, 119, '其它区', 3, '', NULL),
  (1342, 120, '京口区', 3, '', NULL),
  (1343, 120, '润州区', 3, '', NULL),
  (1344, 120, '丹徒区', 3, '', NULL),
  (1345, 120, '丹阳市', 3, '', NULL),
  (1346, 120, '扬中市', 3, '', NULL),
  (1347, 120, '句容市', 3, '', NULL),
  (1348, 120, '其它区', 3, '', NULL),
  (1349, 121, '海陵区', 3, '', NULL),
  (1350, 121, '高港区', 3, '', NULL),
  (1351, 121, '兴化市', 3, '', NULL),
  (1352, 121, '靖江市', 3, '', NULL),
  (1353, 121, '泰兴市', 3, '', NULL),
  (1354, 121, '姜堰区', 3, '', NULL),
  (1355, 121, '其它区', 3, '', NULL),
  (1356, 122, '宿城区', 3, '', NULL),
  (1357, 122, '宿豫区', 3, '', NULL),
  (1358, 122, '沭阳县', 3, '', NULL),
  (1359, 122, '泗阳县', 3, '', NULL),
  (1360, 122, '泗洪县', 3, '', NULL),
  (1361, 122, '其它区', 3, '', NULL),
  (1362, 123, '上城区', 3, '', NULL),
  (1363, 123, '下城区', 3, '', NULL),
  (1364, 123, '江干区', 3, '', NULL),
  (1365, 123, '拱墅区', 3, '', NULL),
  (1366, 123, '西湖区', 3, '', NULL),
  (1367, 123, '滨江区', 3, '', NULL),
  (1368, 123, '萧山区', 3, '', NULL),
  (1369, 123, '余杭区', 3, '', NULL),
  (1370, 123, '桐庐县', 3, '', NULL),
  (1371, 123, '淳安县', 3, '', NULL),
  (1372, 123, '建德市', 3, '', NULL),
  (1373, 123, '富阳区', 3, '', NULL),
  (1374, 123, '临安市', 3, '', NULL),
  (1375, 123, '其它区', 3, '', NULL),
  (1376, 124, '海曙区', 3, '', NULL),
  (1377, 124, '江东区', 3, '', NULL),
  (1378, 124, '江北区', 3, '', NULL),
  (1379, 124, '北仑区', 3, '', NULL),
  (1380, 124, '镇海区', 3, '', NULL),
  (1381, 124, '鄞州区', 3, '', NULL),
  (1382, 124, '象山县', 3, '', NULL),
  (1383, 124, '宁海县', 3, '', NULL),
  (1384, 124, '余姚市', 3, '', NULL),
  (1385, 124, '慈溪市', 3, '', NULL),
  (1386, 124, '奉化市', 3, '', NULL),
  (1387, 124, '其它区', 3, '', NULL),
  (1388, 125, '鹿城区', 3, '', NULL),
  (1389, 125, '龙湾区', 3, '', NULL),
  (1390, 125, '瓯海区', 3, '', NULL),
  (1391, 125, '洞头县', 3, '', NULL),
  (1392, 125, '永嘉县', 3, '', NULL),
  (1393, 125, '平阳县', 3, '', NULL),
  (1394, 125, '苍南县', 3, '', NULL),
  (1395, 125, '文成县', 3, '', NULL),
  (1396, 125, '泰顺县', 3, '', NULL),
  (1397, 125, '瑞安市', 3, '', NULL),
  (1398, 125, '乐清市', 3, '', NULL),
  (1399, 125, '其它区', 3, '', NULL),
  (1400, 126, '南湖区', 3, '', NULL),
  (1401, 126, '秀洲区', 3, '', NULL),
  (1402, 126, '嘉善县', 3, '', NULL),
  (1403, 126, '海盐县', 3, '', NULL),
  (1404, 126, '海宁市', 3, '', NULL),
  (1405, 126, '平湖市', 3, '', NULL),
  (1406, 126, '桐乡市', 3, '', NULL),
  (1407, 126, '其它区', 3, '', NULL),
  (1408, 127, '吴兴区', 3, '', NULL),
  (1409, 127, '南浔区', 3, '', NULL),
  (1410, 127, '德清县', 3, '', NULL),
  (1411, 127, '长兴县', 3, '', NULL),
  (1412, 127, '安吉县', 3, '', NULL),
  (1413, 127, '其它区', 3, '', NULL),
  (1414, 128, '越城区', 3, '', NULL),
  (1415, 128, '柯桥区', 3, '', NULL),
  (1416, 128, '新昌县', 3, '', NULL),
  (1417, 128, '诸暨市', 3, '', NULL),
  (1418, 128, '上虞区', 3, '', NULL),
  (1419, 128, '嵊州市', 3, '', NULL),
  (1420, 128, '其它区', 3, '', NULL),
  (1421, 129, '婺城区', 3, '', NULL),
  (1422, 129, '金东区', 3, '', NULL),
  (1423, 129, '武义县', 3, '', NULL),
  (1424, 129, '浦江县', 3, '', NULL),
  (1425, 129, '磐安县', 3, '', NULL),
  (1426, 129, '兰溪市', 3, '', NULL),
  (1427, 129, '义乌市', 3, '', NULL),
  (1428, 129, '东阳市', 3, '', NULL),
  (1429, 129, '永康市', 3, '', NULL),
  (1430, 129, '其它区', 3, '', NULL),
  (1431, 130, '柯城区', 3, '', NULL),
  (1432, 130, '衢江区', 3, '', NULL),
  (1433, 130, '常山县', 3, '', NULL),
  (1434, 130, '开化县', 3, '', NULL),
  (1435, 130, '龙游县', 3, '', NULL),
  (1436, 130, '江山市', 3, '', NULL),
  (1437, 130, '其它区', 3, '', NULL),
  (1438, 131, '定海区', 3, '', NULL),
  (1439, 131, '普陀区', 3, '', NULL),
  (1440, 131, '岱山县', 3, '', NULL),
  (1441, 131, '嵊泗县', 3, '', NULL),
  (1442, 131, '其它区', 3, '', NULL),
  (1443, 132, '椒江区', 3, '', NULL),
  (1444, 132, '黄岩区', 3, '', NULL),
  (1445, 132, '路桥区', 3, '', NULL),
  (1446, 132, '玉环县', 3, '', NULL),
  (1447, 132, '三门县', 3, '', NULL),
  (1448, 132, '天台县', 3, '', NULL),
  (1449, 132, '仙居县', 3, '', NULL),
  (1450, 132, '温岭市', 3, '', NULL),
  (1451, 132, '临海市', 3, '', NULL),
  (1452, 132, '其它区', 3, '', NULL),
  (1453, 133, '莲都区', 3, '', NULL),
  (1454, 133, '青田县', 3, '', NULL),
  (1455, 133, '缙云县', 3, '', NULL),
  (1456, 133, '遂昌县', 3, '', NULL),
  (1457, 133, '松阳县', 3, '', NULL),
  (1458, 133, '云和县', 3, '', NULL),
  (1459, 133, '庆元县', 3, '', NULL),
  (1460, 133, '景宁畲族自治县', 3, '', NULL),
  (1461, 133, '龙泉市', 3, '', NULL),
  (1462, 133, '其它区', 3, '', NULL),
  (1463, 134, '瑶海区', 3, '', NULL),
  (1464, 134, '庐阳区', 3, '', NULL),
  (1465, 134, '蜀山区', 3, '', NULL),
  (1466, 134, '包河区', 3, '', NULL),
  (1467, 134, '长丰县', 3, '', NULL),
  (1468, 134, '肥东县', 3, '', NULL),
  (1469, 134, '肥西县', 3, '', NULL),
  (1470, 134, '高新区', 3, '', NULL),
  (1471, 134, '中区', 3, '', NULL),
  (1472, 134, '其它区', 3, '', NULL),
  (1473, 135, '镜湖区', 3, '', NULL),
  (1474, 135, '弋江区', 3, '', NULL),
  (1475, 135, '鸠江区', 3, '', NULL),
  (1476, 135, '三山区', 3, '', NULL),
  (1477, 135, '芜湖县', 3, '', NULL),
  (1478, 135, '繁昌县', 3, '', NULL),
  (1479, 135, '南陵县', 3, '', NULL),
  (1480, 135, '其它区', 3, '', NULL),
  (1481, 136, '龙子湖区', 3, '', NULL),
  (1482, 136, '蚌山区', 3, '', NULL),
  (1483, 136, '禹会区', 3, '', NULL),
  (1484, 136, '淮上区', 3, '', NULL),
  (1485, 136, '怀远县', 3, '', NULL),
  (1486, 136, '五河县', 3, '', NULL),
  (1487, 136, '固镇县', 3, '', NULL),
  (1488, 136, '其它区', 3, '', NULL),
  (1489, 137, '大通区', 3, '', NULL),
  (1490, 137, '田家庵区', 3, '', NULL),
  (1491, 137, '谢家集区', 3, '', NULL),
  (1492, 137, '八公山区', 3, '', NULL),
  (1493, 137, '潘集区', 3, '', NULL),
  (1494, 137, '凤台县', 3, '', NULL),
  (1495, 137, '其它区', 3, '', NULL),
  (1496, 138, '金家庄区', 3, '', NULL),
  (1497, 138, '花山区', 3, '', NULL),
  (1498, 138, '雨山区', 3, '', NULL),
  (1499, 138, '博望区', 3, '', NULL),
  (1500, 138, '当涂县', 3, '', NULL),
  (1501, 138, '其它区', 3, '', NULL),
  (1502, 139, '杜集区', 3, '', NULL),
  (1503, 139, '相山区', 3, '', NULL),
  (1504, 139, '烈山区', 3, '', NULL),
  (1505, 139, '濉溪县', 3, '', NULL),
  (1506, 139, '其它区', 3, '', NULL),
  (1507, 140, '铜官山区', 3, '', NULL),
  (1508, 140, '狮子山区', 3, '', NULL),
  (1509, 140, '郊区', 3, '', NULL),
  (1510, 140, '铜陵县', 3, '', NULL),
  (1511, 140, '其它区', 3, '', NULL),
  (1512, 141, '迎江区', 3, '', NULL),
  (1513, 141, '大观区', 3, '', NULL),
  (1514, 141, '宜秀区', 3, '', NULL),
  (1515, 141, '怀宁县', 3, '', NULL),
  (1516, 141, '枞阳县', 3, '', NULL),
  (1517, 141, '潜山县', 3, '', NULL),
  (1518, 141, '太湖县', 3, '', NULL),
  (1519, 141, '宿松县', 3, '', NULL),
  (1520, 141, '望江县', 3, '', NULL),
  (1521, 141, '岳西县', 3, '', NULL),
  (1522, 141, '桐城市', 3, '', NULL),
  (1523, 141, '其它区', 3, '', NULL),
  (1524, 142, '屯溪区', 3, '', NULL),
  (1525, 142, '黄山区', 3, '', NULL),
  (1526, 142, '徽州区', 3, '', NULL),
  (1527, 142, '歙县', 3, '', NULL),
  (1528, 142, '休宁县', 3, '', NULL),
  (1529, 142, '黟县', 3, '', NULL),
  (1530, 142, '祁门县', 3, '', NULL),
  (1531, 142, '其它区', 3, '', NULL),
  (1532, 143, '琅琊区', 3, '', NULL),
  (1533, 143, '南谯区', 3, '', NULL),
  (1534, 143, '来安县', 3, '', NULL),
  (1535, 143, '全椒县', 3, '', NULL),
  (1536, 143, '定远县', 3, '', NULL),
  (1537, 143, '凤阳县', 3, '', NULL),
  (1538, 143, '天长市', 3, '', NULL),
  (1539, 143, '明光市', 3, '', NULL),
  (1540, 143, '其它区', 3, '', NULL),
  (1541, 144, '颍州区', 3, '', NULL),
  (1542, 144, '颍东区', 3, '', NULL),
  (1543, 144, '颍泉区', 3, '', NULL),
  (1544, 144, '临泉县', 3, '', NULL),
  (1545, 144, '太和县', 3, '', NULL),
  (1546, 144, '阜南县', 3, '', NULL),
  (1547, 144, '颍上县', 3, '', NULL),
  (1548, 144, '界首市', 3, '', NULL),
  (1549, 144, '其它区', 3, '', NULL),
  (1550, 145, '埇桥区', 3, '', NULL),
  (1551, 145, '砀山县', 3, '', NULL),
  (1552, 145, '萧县', 3, '', NULL),
  (1553, 145, '灵璧县', 3, '', NULL),
  (1554, 145, '泗县', 3, '', NULL),
  (1555, 145, '其它区', 3, '', NULL),
  (1556, 134, '巢湖市', 3, '', NULL),
  (1557, 134, '居巢区', 3, '', NULL),
  (1558, 134, '庐江县', 3, '', NULL),
  (1559, 135, '无为县', 3, '', NULL),
  (1560, 138, '含山县', 3, '', NULL),
  (1561, 138, '和县', 3, '', NULL),
  (1562, 146, '金安区', 3, '', NULL),
  (1563, 146, '裕安区', 3, '', NULL),
  (1564, 146, '寿县', 3, '', NULL),
  (1565, 146, '霍邱县', 3, '', NULL),
  (1566, 146, '舒城县', 3, '', NULL),
  (1567, 146, '金寨县', 3, '', NULL),
  (1568, 146, '霍山县', 3, '', NULL),
  (1569, 146, '其它区', 3, '', NULL),
  (1570, 147, '谯城区', 3, '', NULL),
  (1571, 147, '涡阳县', 3, '', NULL),
  (1572, 147, '蒙城县', 3, '', NULL),
  (1573, 147, '利辛县', 3, '', NULL),
  (1574, 147, '其它区', 3, '', NULL),
  (1575, 148, '贵池区', 3, '', NULL),
  (1576, 148, '东至县', 3, '', NULL),
  (1577, 148, '石台县', 3, '', NULL),
  (1578, 148, '青阳县', 3, '', NULL),
  (1579, 148, '其它区', 3, '', NULL),
  (1580, 149, '宣州区', 3, '', NULL),
  (1581, 149, '郎溪县', 3, '', NULL),
  (1582, 149, '广德县', 3, '', NULL),
  (1583, 149, '泾县', 3, '', NULL),
  (1584, 149, '绩溪县', 3, '', NULL),
  (1585, 149, '旌德县', 3, '', NULL),
  (1586, 149, '宁国市', 3, '', NULL),
  (1587, 149, '其它区', 3, '', NULL),
  (1588, 150, '鼓楼区', 3, '', NULL),
  (1589, 150, '台江区', 3, '', NULL),
  (1590, 150, '仓山区', 3, '', NULL),
  (1591, 150, '马尾区', 3, '', NULL),
  (1592, 150, '晋安区', 3, '', NULL),
  (1593, 150, '闽侯县', 3, '', NULL),
  (1594, 150, '连江县', 3, '', NULL),
  (1595, 150, '罗源县', 3, '', NULL),
  (1596, 150, '闽清县', 3, '', NULL),
  (1597, 150, '永泰县', 3, '', NULL),
  (1598, 150, '平潭县', 3, '', NULL),
  (1599, 150, '福清市', 3, '', NULL),
  (1600, 150, '长乐市', 3, '', NULL),
  (1601, 150, '其它区', 3, '', NULL),
  (1602, 151, '思明区', 3, '', NULL),
  (1603, 151, '海沧区', 3, '', NULL),
  (1604, 151, '湖里区', 3, '', NULL),
  (1605, 151, '集美区', 3, '', NULL),
  (1606, 151, '同安区', 3, '', NULL),
  (1607, 151, '翔安区', 3, '', NULL),
  (1608, 151, '其它区', 3, '', NULL),
  (1609, 152, '城厢区', 3, '', NULL),
  (1610, 152, '涵江区', 3, '', NULL),
  (1611, 152, '荔城区', 3, '', NULL),
  (1612, 152, '秀屿区', 3, '', NULL),
  (1613, 152, '仙游县', 3, '', NULL),
  (1614, 152, '其它区', 3, '', NULL),
  (1615, 153, '梅列区', 3, '', NULL),
  (1616, 153, '三元区', 3, '', NULL),
  (1617, 153, '明溪县', 3, '', NULL),
  (1618, 153, '清流县', 3, '', NULL),
  (1619, 153, '宁化县', 3, '', NULL),
  (1620, 153, '大田县', 3, '', NULL),
  (1621, 153, '尤溪县', 3, '', NULL),
  (1622, 153, '沙县', 3, '', NULL),
  (1623, 153, '将乐县', 3, '', NULL),
  (1624, 153, '泰宁县', 3, '', NULL),
  (1625, 153, '建宁县', 3, '', NULL),
  (1626, 153, '永安市', 3, '', NULL),
  (1627, 153, '其它区', 3, '', NULL),
  (1628, 154, '鲤城区', 3, '', NULL),
  (1629, 154, '丰泽区', 3, '', NULL),
  (1630, 154, '洛江区', 3, '', NULL),
  (1631, 154, '泉港区', 3, '', NULL),
  (1632, 154, '惠安县', 3, '', NULL),
  (1633, 154, '安溪县', 3, '', NULL),
  (1634, 154, '永春县', 3, '', NULL),
  (1635, 154, '德化县', 3, '', NULL),
  (1636, 154, '金门县', 3, '', NULL),
  (1637, 154, '石狮市', 3, '', NULL),
  (1638, 154, '晋江市', 3, '', NULL),
  (1639, 154, '南安市', 3, '', NULL),
  (1640, 154, '其它区', 3, '', NULL),
  (1641, 155, '芗城区', 3, '', NULL),
  (1642, 155, '龙文区', 3, '', NULL),
  (1643, 155, '云霄县', 3, '', NULL),
  (1644, 155, '漳浦县', 3, '', NULL),
  (1645, 155, '诏安县', 3, '', NULL),
  (1646, 155, '长泰县', 3, '', NULL),
  (1647, 155, '东山县', 3, '', NULL),
  (1648, 155, '南靖县', 3, '', NULL),
  (1649, 155, '平和县', 3, '', NULL),
  (1650, 155, '华安县', 3, '', NULL),
  (1651, 155, '龙海市', 3, '', NULL),
  (1652, 155, '其它区', 3, '', NULL),
  (1653, 156, '延平区', 3, '', NULL),
  (1654, 156, '顺昌县', 3, '', NULL),
  (1655, 156, '浦城县', 3, '', NULL),
  (1656, 156, '光泽县', 3, '', NULL),
  (1657, 156, '松溪县', 3, '', NULL),
  (1658, 156, '政和县', 3, '', NULL),
  (1659, 156, '邵武市', 3, '', NULL),
  (1660, 156, '武夷山市', 3, '', NULL),
  (1661, 156, '建瓯市', 3, '', NULL),
  (1662, 156, '建阳区', 3, '', NULL),
  (1663, 156, '其它区', 3, '', NULL),
  (1664, 157, '新罗区', 3, '', NULL),
  (1665, 157, '长汀县', 3, '', NULL),
  (1666, 157, '永定区', 3, '', NULL),
  (1667, 157, '上杭县', 3, '', NULL),
  (1668, 157, '武平县', 3, '', NULL),
  (1669, 157, '连城县', 3, '', NULL),
  (1670, 157, '漳平市', 3, '', NULL),
  (1671, 157, '其它区', 3, '', NULL),
  (1672, 158, '蕉城区', 3, '', NULL),
  (1673, 158, '霞浦县', 3, '', NULL),
  (1674, 158, '古田县', 3, '', NULL),
  (1675, 158, '屏南县', 3, '', NULL),
  (1676, 158, '寿宁县', 3, '', NULL),
  (1677, 158, '周宁县', 3, '', NULL),
  (1678, 158, '柘荣县', 3, '', NULL),
  (1679, 158, '福安市', 3, '', NULL),
  (1680, 158, '福鼎市', 3, '', NULL),
  (1681, 158, '其它区', 3, '', NULL),
  (1682, 159, '东湖区', 3, '', NULL),
  (1683, 159, '西湖区', 3, '', NULL),
  (1684, 159, '青云谱区', 3, '', NULL),
  (1685, 159, '湾里区', 3, '', NULL),
  (1686, 159, '青山湖区', 3, '', NULL),
  (1687, 159, '南昌县', 3, '', NULL),
  (1688, 159, '新建县', 3, '', NULL),
  (1689, 159, '安义县', 3, '', NULL),
  (1690, 159, '进贤县', 3, '', NULL),
  (1691, 159, '红谷滩新区', 3, '', NULL),
  (1692, 159, '经济技术开发区', 3, '', NULL),
  (1693, 159, '昌北区', 3, '', NULL),
  (1694, 159, '其它区', 3, '', NULL),
  (1695, 160, '昌江区', 3, '', NULL),
  (1696, 160, '珠山区', 3, '', NULL),
  (1697, 160, '浮梁县', 3, '', NULL),
  (1698, 160, '乐平市', 3, '', NULL),
  (1699, 160, '其它区', 3, '', NULL),
  (1700, 161, '安源区', 3, '', NULL),
  (1701, 161, '湘东区', 3, '', NULL),
  (1702, 161, '莲花县', 3, '', NULL),
  (1703, 161, '上栗县', 3, '', NULL),
  (1704, 161, '芦溪县', 3, '', NULL),
  (1705, 161, '其它区', 3, '', NULL),
  (1706, 162, '庐山区', 3, '', NULL),
  (1707, 162, '浔阳区', 3, '', NULL),
  (1708, 162, '九江县', 3, '', NULL),
  (1709, 162, '武宁县', 3, '', NULL),
  (1710, 162, '修水县', 3, '', NULL),
  (1711, 162, '永修县', 3, '', NULL),
  (1712, 162, '德安县', 3, '', NULL),
  (1713, 162, '星子县', 3, '', NULL),
  (1714, 162, '都昌县', 3, '', NULL),
  (1715, 162, '湖口县', 3, '', NULL),
  (1716, 162, '彭泽县', 3, '', NULL),
  (1717, 162, '瑞昌市', 3, '', NULL),
  (1718, 162, '其它区', 3, '', NULL),
  (1719, 162, '共青城市', 3, '', NULL),
  (1720, 163, '渝水区', 3, '', NULL),
  (1721, 163, '分宜县', 3, '', NULL),
  (1722, 163, '其它区', 3, '', NULL),
  (1723, 164, '月湖区', 3, '', NULL),
  (1724, 164, '余江县', 3, '', NULL),
  (1725, 164, '贵溪市', 3, '', NULL),
  (1726, 164, '其它区', 3, '', NULL),
  (1727, 165, '章贡区', 3, '', NULL),
  (1728, 165, '赣县', 3, '', NULL),
  (1729, 165, '信丰县', 3, '', NULL),
  (1730, 165, '大余县', 3, '', NULL),
  (1731, 165, '上犹县', 3, '', NULL),
  (1732, 165, '崇义县', 3, '', NULL),
  (1733, 165, '安远县', 3, '', NULL),
  (1734, 165, '龙南县', 3, '', NULL),
  (1735, 165, '定南县', 3, '', NULL),
  (1736, 165, '全南县', 3, '', NULL),
  (1737, 165, '宁都县', 3, '', NULL),
  (1738, 165, '于都县', 3, '', NULL),
  (1739, 165, '兴国县', 3, '', NULL),
  (1740, 165, '会昌县', 3, '', NULL),
  (1741, 165, '寻乌县', 3, '', NULL),
  (1742, 165, '石城县', 3, '', NULL),
  (1743, 165, '黄金区', 3, '', NULL),
  (1744, 165, '瑞金市', 3, '', NULL),
  (1745, 165, '南康区', 3, '', NULL),
  (1746, 165, '其它区', 3, '', NULL),
  (1747, 166, '吉州区', 3, '', NULL),
  (1748, 166, '青原区', 3, '', NULL),
  (1749, 166, '吉安县', 3, '', NULL),
  (1750, 166, '吉水县', 3, '', NULL),
  (1751, 166, '峡江县', 3, '', NULL),
  (1752, 166, '新干县', 3, '', NULL),
  (1753, 166, '永丰县', 3, '', NULL),
  (1754, 166, '泰和县', 3, '', NULL),
  (1755, 166, '遂川县', 3, '', NULL),
  (1756, 166, '万安县', 3, '', NULL),
  (1757, 166, '安福县', 3, '', NULL),
  (1758, 166, '永新县', 3, '', NULL),
  (1759, 166, '井冈山市', 3, '', NULL),
  (1760, 166, '其它区', 3, '', NULL),
  (1761, 167, '袁州区', 3, '', NULL),
  (1762, 167, '奉新县', 3, '', NULL),
  (1763, 167, '万载县', 3, '', NULL),
  (1764, 167, '上高县', 3, '', NULL),
  (1765, 167, '宜丰县', 3, '', NULL),
  (1766, 167, '靖安县', 3, '', NULL),
  (1767, 167, '铜鼓县', 3, '', NULL),
  (1768, 167, '丰城市', 3, '', NULL),
  (1769, 167, '樟树市', 3, '', NULL),
  (1770, 167, '高安市', 3, '', NULL),
  (1771, 167, '其它区', 3, '', NULL),
  (1772, 168, '临川区', 3, '', NULL),
  (1773, 168, '南城县', 3, '', NULL),
  (1774, 168, '黎川县', 3, '', NULL),
  (1775, 168, '南丰县', 3, '', NULL),
  (1776, 168, '崇仁县', 3, '', NULL),
  (1777, 168, '乐安县', 3, '', NULL),
  (1778, 168, '宜黄县', 3, '', NULL),
  (1779, 168, '金溪县', 3, '', NULL),
  (1780, 168, '资溪县', 3, '', NULL),
  (1781, 168, '东乡县', 3, '', NULL),
  (1782, 168, '广昌县', 3, '', NULL),
  (1783, 168, '其它区', 3, '', NULL),
  (1784, 169, '信州区', 3, '', NULL),
  (1785, 169, '上饶县', 3, '', NULL),
  (1786, 169, '广丰区', 3, '', NULL),
  (1787, 169, '玉山县', 3, '', NULL),
  (1788, 169, '铅山县', 3, '', NULL),
  (1789, 169, '横峰县', 3, '', NULL),
  (1790, 169, '弋阳县', 3, '', NULL),
  (1791, 169, '余干县', 3, '', NULL),
  (1792, 169, '鄱阳县', 3, '', NULL),
  (1793, 169, '万年县', 3, '', NULL),
  (1794, 169, '婺源县', 3, '', NULL),
  (1795, 169, '德兴市', 3, '', NULL),
  (1796, 169, '其它区', 3, '', NULL),
  (1797, 170, '历下区', 3, '', NULL),
  (1798, 170, '市中区', 3, '', NULL),
  (1799, 170, '槐荫区', 3, '', NULL),
  (1800, 170, '天桥区', 3, '', NULL),
  (1801, 170, '历城区', 3, '', NULL),
  (1802, 170, '长清区', 3, '', NULL),
  (1803, 170, '平阴县', 3, '', NULL),
  (1804, 170, '济阳县', 3, '', NULL),
  (1805, 170, '商河县', 3, '', NULL),
  (1806, 170, '章丘市', 3, '', NULL),
  (1807, 170, '其它区', 3, '', NULL),
  (1808, 171, '市南区', 3, '', NULL),
  (1809, 171, '市北区', 3, '', NULL),
  (1810, 171, '四方区', 3, '', NULL),
  (1811, 171, '黄岛区', 3, '', NULL),
  (1812, 171, '崂山区', 3, '', NULL),
  (1813, 171, '李沧区', 3, '', NULL),
  (1814, 171, '城阳区', 3, '', NULL),
  (1815, 171, '开发区', 3, '', NULL),
  (1816, 171, '胶州市', 3, '', NULL),
  (1817, 171, '即墨市', 3, '', NULL),
  (1818, 171, '平度市', 3, '', NULL),
  (1819, 171, '胶南市', 3, '', NULL),
  (1820, 171, '莱西市', 3, '', NULL),
  (1821, 171, '其它区', 3, '', NULL),
  (1822, 172, '淄川区', 3, '', NULL),
  (1823, 172, '张店区', 3, '', NULL),
  (1824, 172, '博山区', 3, '', NULL),
  (1825, 172, '临淄区', 3, '', NULL),
  (1826, 172, '周村区', 3, '', NULL),
  (1827, 172, '桓台县', 3, '', NULL),
  (1828, 172, '高青县', 3, '', NULL),
  (1829, 172, '沂源县', 3, '', NULL),
  (1830, 172, '其它区', 3, '', NULL),
  (1831, 173, '市中区', 3, '', NULL),
  (1832, 173, '薛城区', 3, '', NULL),
  (1833, 173, '峄城区', 3, '', NULL),
  (1834, 173, '台儿庄区', 3, '', NULL),
  (1835, 173, '山亭区', 3, '', NULL),
  (1836, 173, '滕州市', 3, '', NULL),
  (1837, 173, '其它区', 3, '', NULL),
  (1838, 174, '东营区', 3, '', NULL),
  (1839, 174, '河口区', 3, '', NULL),
  (1840, 174, '垦利县', 3, '', NULL),
  (1841, 174, '利津县', 3, '', NULL),
  (1842, 174, '广饶县', 3, '', NULL),
  (1843, 174, '西城区', 3, '', NULL),
  (1844, 174, '东城区', 3, '', NULL),
  (1845, 174, '其它区', 3, '', NULL),
  (1846, 175, '芝罘区', 3, '', NULL),
  (1847, 175, '福山区', 3, '', NULL),
  (1848, 175, '牟平区', 3, '', NULL),
  (1849, 175, '莱山区', 3, '', NULL),
  (1850, 175, '长岛县', 3, '', NULL),
  (1851, 175, '龙口市', 3, '', NULL),
  (1852, 175, '莱阳市', 3, '', NULL),
  (1853, 175, '莱州市', 3, '', NULL),
  (1854, 175, '蓬莱市', 3, '', NULL),
  (1855, 175, '招远市', 3, '', NULL),
  (1856, 175, '栖霞市', 3, '', NULL),
  (1857, 175, '海阳市', 3, '', NULL),
  (1858, 175, '其它区', 3, '', NULL),
  (1859, 176, '潍城区', 3, '', NULL),
  (1860, 176, '寒亭区', 3, '', NULL),
  (1861, 176, '坊子区', 3, '', NULL),
  (1862, 176, '奎文区', 3, '', NULL),
  (1863, 176, '临朐县', 3, '', NULL),
  (1864, 176, '昌乐县', 3, '', NULL),
  (1865, 176, '开发区', 3, '', NULL),
  (1866, 176, '青州市', 3, '', NULL),
  (1867, 176, '诸城市', 3, '', NULL),
  (1868, 176, '寿光市', 3, '', NULL),
  (1869, 176, '安丘市', 3, '', NULL),
  (1870, 176, '高密市', 3, '', NULL),
  (1871, 176, '昌邑市', 3, '', NULL),
  (1872, 176, '其它区', 3, '', NULL),
  (1873, 177, '市中区', 3, '', NULL),
  (1874, 177, '任城区', 3, '', NULL),
  (1875, 177, '微山县', 3, '', NULL),
  (1876, 177, '鱼台县', 3, '', NULL),
  (1877, 177, '金乡县', 3, '', NULL),
  (1878, 177, '嘉祥县', 3, '', NULL),
  (1879, 177, '汶上县', 3, '', NULL),
  (1880, 177, '泗水县', 3, '', NULL),
  (1881, 177, '梁山县', 3, '', NULL),
  (1882, 177, '曲阜市', 3, '', NULL),
  (1883, 177, '兖州区', 3, '', NULL),
  (1884, 177, '邹城市', 3, '', NULL),
  (1885, 177, '其它区', 3, '', NULL),
  (1886, 178, '泰山区', 3, '', NULL),
  (1887, 178, '岱岳区', 3, '', NULL),
  (1888, 178, '宁阳县', 3, '', NULL),
  (1889, 178, '东平县', 3, '', NULL),
  (1890, 178, '新泰市', 3, '', NULL),
  (1891, 178, '肥城市', 3, '', NULL),
  (1892, 178, '其它区', 3, '', NULL),
  (1893, 179, '环翠区', 3, '', NULL),
  (1894, 179, '文登区', 3, '', NULL),
  (1895, 179, '荣成市', 3, '', NULL),
  (1896, 179, '乳山市', 3, '', NULL),
  (1897, 179, '其它区', 3, '', NULL),
  (1898, 180, '东港区', 3, '', NULL),
  (1899, 180, '岚山区', 3, '', NULL),
  (1900, 180, '五莲县', 3, '', NULL),
  (1901, 180, '莒县', 3, '', NULL),
  (1902, 180, '其它区', 3, '', NULL),
  (1903, 181, '莱城区', 3, '', NULL),
  (1904, 181, '钢城区', 3, '', NULL),
  (1905, 181, '其它区', 3, '', NULL),
  (1906, 182, '兰山区', 3, '', NULL),
  (1907, 182, '罗庄区', 3, '', NULL),
  (1908, 182, '河东区', 3, '', NULL),
  (1909, 182, '沂南县', 3, '', NULL),
  (1910, 182, '郯城县', 3, '', NULL),
  (1911, 182, '沂水县', 3, '', NULL),
  (1912, 182, '兰陵县', 3, '', NULL),
  (1913, 182, '费县', 3, '', NULL),
  (1914, 182, '平邑县', 3, '', NULL),
  (1915, 182, '莒南县', 3, '', NULL),
  (1916, 182, '蒙阴县', 3, '', NULL),
  (1917, 182, '临沭县', 3, '', NULL),
  (1918, 182, '其它区', 3, '', NULL),
  (1919, 183, '德城区', 3, '', NULL),
  (1920, 183, '陵城区', 3, '', NULL),
  (1921, 183, '宁津县', 3, '', NULL),
  (1922, 183, '庆云县', 3, '', NULL),
  (1923, 183, '临邑县', 3, '', NULL),
  (1924, 183, '齐河县', 3, '', NULL),
  (1925, 183, '平原县', 3, '', NULL),
  (1926, 183, '夏津县', 3, '', NULL),
  (1927, 183, '武城县', 3, '', NULL),
  (1928, 183, '开发区', 3, '', NULL),
  (1929, 183, '乐陵市', 3, '', NULL),
  (1930, 183, '禹城市', 3, '', NULL),
  (1931, 183, '其它区', 3, '', NULL),
  (1932, 184, '东昌府区', 3, '', NULL),
  (1933, 184, '阳谷县', 3, '', NULL),
  (1934, 184, '莘县', 3, '', NULL),
  (1935, 184, '茌平县', 3, '', NULL),
  (1936, 184, '东阿县', 3, '', NULL),
  (1937, 184, '冠县', 3, '', NULL),
  (1938, 184, '高唐县', 3, '', NULL),
  (1939, 184, '临清市', 3, '', NULL),
  (1940, 184, '其它区', 3, '', NULL),
  (1941, 185, '滨城区', 3, '', NULL),
  (1942, 185, '惠民县', 3, '', NULL),
  (1943, 185, '阳信县', 3, '', NULL),
  (1944, 185, '无棣县', 3, '', NULL),
  (1945, 185, '沾化区', 3, '', NULL),
  (1946, 185, '博兴县', 3, '', NULL),
  (1947, 185, '邹平县', 3, '', NULL),
  (1948, 185, '其它区', 3, '', NULL),
  (1949, 186, '牡丹区', 3, '', NULL),
  (1950, 186, '曹县', 3, '', NULL),
  (1951, 186, '单县', 3, '', NULL),
  (1952, 186, '成武县', 3, '', NULL),
  (1953, 186, '巨野县', 3, '', NULL),
  (1954, 186, '郓城县', 3, '', NULL),
  (1955, 186, '鄄城县', 3, '', NULL),
  (1956, 186, '定陶县', 3, '', NULL),
  (1957, 186, '东明县', 3, '', NULL),
  (1958, 186, '其它区', 3, '', NULL),
  (1959, 187, '中原区', 3, '', NULL),
  (1960, 187, '二七区', 3, '', NULL),
  (1961, 187, '管城回族区', 3, '', NULL),
  (1962, 187, '金水区', 3, '', NULL),
  (1963, 187, '上街区', 3, '', NULL),
  (1964, 187, '惠济区', 3, '', NULL),
  (1965, 187, '中牟县', 3, '', NULL),
  (1966, 187, '巩义市', 3, '', NULL),
  (1967, 187, '荥阳市', 3, '', NULL),
  (1968, 187, '新密市', 3, '', NULL),
  (1969, 187, '新郑市', 3, '', NULL),
  (1970, 187, '登封市', 3, '', NULL),
  (1971, 187, '郑东新区', 3, '', NULL),
  (1972, 187, '高新区', 3, '', NULL),
  (1973, 187, '其它区', 3, '', NULL),
  (1974, 188, '龙亭区', 3, '', NULL),
  (1975, 188, '顺河回族区', 3, '', NULL),
  (1976, 188, '鼓楼区', 3, '', NULL),
  (1977, 188, '禹王台区', 3, '', NULL),
  (1978, 188, '金明区', 3, '', NULL),
  (1979, 188, '杞县', 3, '', NULL),
  (1980, 188, '通许县', 3, '', NULL),
  (1981, 188, '尉氏县', 3, '', NULL),
  (1982, 188, '祥符区', 3, '', NULL),
  (1983, 188, '兰考县', 3, '', NULL),
  (1984, 188, '其它区', 3, '', NULL),
  (1985, 189, '老城区', 3, '', NULL),
  (1986, 189, '西工区', 3, '', NULL),
  (1987, 189, '瀍河回族区', 3, '', NULL),
  (1988, 189, '涧西区', 3, '', NULL),
  (1989, 189, '吉利区', 3, '', NULL),
  (1990, 189, '洛龙区', 3, '', NULL),
  (1991, 189, '孟津县', 3, '', NULL),
  (1992, 189, '新安县', 3, '', NULL),
  (1993, 189, '栾川县', 3, '', NULL),
  (1994, 189, '嵩县', 3, '', NULL),
  (1995, 189, '汝阳县', 3, '', NULL),
  (1996, 189, '宜阳县', 3, '', NULL),
  (1997, 189, '洛宁县', 3, '', NULL),
  (1998, 189, '伊川县', 3, '', NULL),
  (1999, 189, '偃师市', 3, '', NULL),
  (2000, 190, '新华区', 3, '', NULL),
  (2001, 190, '卫东区', 3, '', NULL),
  (2002, 190, '石龙区', 3, '', NULL),
  (2003, 190, '湛河区', 3, '', NULL),
  (2004, 190, '宝丰县', 3, '', NULL),
  (2005, 190, '叶县', 3, '', NULL),
  (2006, 190, '鲁山县', 3, '', NULL),
  (2007, 190, '郏县', 3, '', NULL),
  (2008, 190, '舞钢市', 3, '', NULL),
  (2009, 190, '汝州市', 3, '', NULL),
  (2010, 190, '其它区', 3, '', NULL),
  (2011, 191, '文峰区', 3, '', NULL),
  (2012, 191, '北关区', 3, '', NULL),
  (2013, 191, '殷都区', 3, '', NULL),
  (2014, 191, '龙安区', 3, '', NULL),
  (2015, 191, '安阳县', 3, '', NULL),
  (2016, 191, '汤阴县', 3, '', NULL),
  (2017, 191, '滑县', 3, '', NULL),
  (2018, 191, '内黄县', 3, '', NULL),
  (2019, 191, '林州市', 3, '', NULL),
  (2020, 191, '其它区', 3, '', NULL),
  (2021, 192, '鹤山区', 3, '', NULL),
  (2022, 192, '山城区', 3, '', NULL),
  (2023, 192, '淇滨区', 3, '', NULL),
  (2024, 192, '浚县', 3, '', NULL),
  (2025, 192, '淇县', 3, '', NULL),
  (2026, 192, '其它区', 3, '', NULL),
  (2027, 193, '红旗区', 3, '', NULL),
  (2028, 193, '卫滨区', 3, '', NULL),
  (2029, 193, '凤泉区', 3, '', NULL),
  (2030, 193, '牧野区', 3, '', NULL),
  (2031, 193, '新乡县', 3, '', NULL),
  (2032, 193, '获嘉县', 3, '', NULL),
  (2033, 193, '原阳县', 3, '', NULL),
  (2034, 193, '延津县', 3, '', NULL),
  (2035, 193, '封丘县', 3, '', NULL),
  (2036, 193, '长垣县', 3, '', NULL),
  (2037, 193, '卫辉市', 3, '', NULL),
  (2038, 193, '辉县市', 3, '', NULL),
  (2039, 193, '其它区', 3, '', NULL),
  (2040, 194, '解放区', 3, '', NULL),
  (2041, 194, '中站区', 3, '', NULL),
  (2042, 194, '马村区', 3, '', NULL),
  (2043, 194, '山阳区', 3, '', NULL),
  (2044, 194, '修武县', 3, '', NULL),
  (2045, 194, '博爱县', 3, '', NULL),
  (2046, 194, '武陟县', 3, '', NULL),
  (2047, 194, '温县', 3, '', NULL),
  (2048, 194, '沁阳市', 3, '', NULL),
  (2049, 194, '孟州市', 3, '', NULL),
  (2050, 194, '其它区', 3, '', NULL),
  (2051, 195, '华龙区', 3, '', NULL),
  (2052, 195, '清丰县', 3, '', NULL),
  (2053, 195, '南乐县', 3, '', NULL),
  (2054, 195, '范县', 3, '', NULL),
  (2055, 195, '台前县', 3, '', NULL),
  (2056, 195, '濮阳县', 3, '', NULL),
  (2057, 195, '其它区', 3, '', NULL),
  (2058, 196, '魏都区', 3, '', NULL),
  (2059, 196, '许昌县', 3, '', NULL),
  (2060, 196, '鄢陵县', 3, '', NULL),
  (2061, 196, '襄城县', 3, '', NULL),
  (2062, 196, '禹州市', 3, '', NULL),
  (2063, 196, '长葛市', 3, '', NULL),
  (2064, 196, '其它区', 3, '', NULL),
  (2065, 197, '源汇区', 3, '', NULL),
  (2066, 197, '郾城区', 3, '', NULL),
  (2067, 197, '召陵区', 3, '', NULL),
  (2068, 197, '舞阳县', 3, '', NULL),
  (2069, 197, '临颍县', 3, '', NULL),
  (2070, 197, '其它区', 3, '', NULL),
  (2071, 198, '湖滨区', 3, '', NULL),
  (2072, 198, '渑池县', 3, '', NULL),
  (2073, 198, '陕州区', 3, '', NULL),
  (2074, 198, '卢氏县', 3, '', NULL),
  (2075, 198, '义马市', 3, '', NULL),
  (2076, 198, '灵宝市', 3, '', NULL),
  (2077, 198, '其它区', 3, '', NULL),
  (2078, 199, '宛城区', 3, '', NULL),
  (2079, 199, '卧龙区', 3, '', NULL),
  (2080, 199, '南召县', 3, '', NULL),
  (2081, 199, '方城县', 3, '', NULL),
  (2082, 199, '西峡县', 3, '', NULL),
  (2083, 199, '镇平县', 3, '', NULL),
  (2084, 199, '内乡县', 3, '', NULL),
  (2085, 199, '淅川县', 3, '', NULL),
  (2086, 199, '社旗县', 3, '', NULL),
  (2087, 199, '唐河县', 3, '', NULL),
  (2088, 199, '新野县', 3, '', NULL),
  (2089, 199, '桐柏县', 3, '', NULL),
  (2090, 199, '邓州市', 3, '', NULL),
  (2091, 199, '其它区', 3, '', NULL),
  (2092, 200, '梁园区', 3, '', NULL),
  (2093, 200, '睢阳区', 3, '', NULL),
  (2094, 200, '民权县', 3, '', NULL),
  (2095, 200, '睢县', 3, '', NULL),
  (2096, 200, '宁陵县', 3, '', NULL),
  (2097, 200, '柘城县', 3, '', NULL),
  (2098, 200, '虞城县', 3, '', NULL),
  (2099, 200, '夏邑县', 3, '', NULL),
  (2100, 200, '永城市', 3, '', NULL),
  (2101, 200, '其它区', 3, '', NULL),
  (2102, 201, '浉河区', 3, '', NULL),
  (2103, 201, '平桥区', 3, '', NULL),
  (2104, 201, '罗山县', 3, '', NULL),
  (2105, 201, '光山县', 3, '', NULL),
  (2106, 201, '新县', 3, '', NULL),
  (2107, 201, '商城县', 3, '', NULL),
  (2108, 201, '固始县', 3, '', NULL),
  (2109, 201, '潢川县', 3, '', NULL),
  (2110, 201, '淮滨县', 3, '', NULL),
  (2111, 201, '息县', 3, '', NULL),
  (2112, 201, '其它区', 3, '', NULL),
  (2113, 202, '川汇区', 3, '', NULL),
  (2114, 202, '扶沟县', 3, '', NULL),
  (2115, 202, '西华县', 3, '', NULL),
  (2116, 202, '商水县', 3, '', NULL),
  (2117, 202, '沈丘县', 3, '', NULL),
  (2118, 202, '郸城县', 3, '', NULL),
  (2119, 202, '淮阳县', 3, '', NULL),
  (2120, 202, '太康县', 3, '', NULL),
  (2121, 202, '鹿邑县', 3, '', NULL),
  (2122, 202, '项城市', 3, '', NULL),
  (2123, 202, '其它区', 3, '', NULL),
  (2124, 203, '驿城区', 3, '', NULL),
  (2125, 203, '西平县', 3, '', NULL),
  (2126, 203, '上蔡县', 3, '', NULL),
  (2127, 203, '平舆县', 3, '', NULL),
  (2128, 203, '正阳县', 3, '', NULL),
  (2129, 203, '确山县', 3, '', NULL),
  (2130, 203, '泌阳县', 3, '', NULL),
  (2131, 203, '汝南县', 3, '', NULL),
  (2132, 203, '遂平县', 3, '', NULL),
  (2133, 203, '新蔡县', 3, '', NULL),
  (2134, 203, '其它区', 3, '', NULL),
  (2135, 204, '江岸区', 3, '', NULL),
  (2136, 204, '江汉区', 3, '', NULL),
  (2137, 204, '硚口区', 3, '', NULL),
  (2138, 204, '汉阳区', 3, '', NULL),
  (2139, 204, '武昌区', 3, '', NULL),
  (2140, 204, '青山区', 3, '', NULL),
  (2141, 204, '洪山区', 3, '', NULL),
  (2142, 204, '东西湖区', 3, '', NULL),
  (2143, 204, '汉南区', 3, '', NULL),
  (2144, 204, '蔡甸区', 3, '', NULL),
  (2145, 204, '江夏区', 3, '', NULL),
  (2146, 204, '黄陂区', 3, '', NULL),
  (2147, 204, '新洲区', 3, '', NULL),
  (2148, 204, '其它区', 3, '', NULL),
  (2149, 205, '黄石港区', 3, '', NULL),
  (2150, 205, '西塞山区', 3, '', NULL),
  (2151, 205, '下陆区', 3, '', NULL),
  (2152, 205, '铁山区', 3, '', NULL),
  (2153, 205, '阳新县', 3, '', NULL),
  (2154, 205, '大冶市', 3, '', NULL),
  (2155, 205, '其它区', 3, '', NULL),
  (2156, 206, '茅箭区', 3, '', NULL),
  (2157, 206, '张湾区', 3, '', NULL),
  (2158, 206, '郧阳区', 3, '', NULL),
  (2159, 206, '郧西县', 3, '', NULL),
  (2160, 206, '竹山县', 3, '', NULL),
  (2161, 206, '竹溪县', 3, '', NULL),
  (2162, 206, '房县', 3, '', NULL),
  (2163, 206, '丹江口市', 3, '', NULL),
  (2164, 206, '城区', 3, '', NULL),
  (2165, 206, '其它区', 3, '', NULL),
  (2166, 207, '西陵区', 3, '', NULL),
  (2167, 207, '伍家岗区', 3, '', NULL),
  (2168, 207, '点军区', 3, '', NULL),
  (2169, 207, '猇亭区', 3, '', NULL),
  (2170, 207, '夷陵区', 3, '', NULL),
  (2171, 207, '远安县', 3, '', NULL),
  (2172, 207, '兴山县', 3, '', NULL),
  (2173, 207, '秭归县', 3, '', NULL),
  (2174, 207, '长阳土家族自治县', 3, '', NULL),
  (2175, 207, '五峰土家族自治县', 3, '', NULL),
  (2176, 207, '葛洲坝区', 3, '', NULL),
  (2177, 207, '开发区', 3, '', NULL),
  (2178, 207, '宜都市', 3, '', NULL),
  (2179, 207, '当阳市', 3, '', NULL),
  (2180, 207, '枝江市', 3, '', NULL),
  (2181, 207, '其它区', 3, '', NULL),
  (2182, 208, '襄城区', 3, '', NULL),
  (2183, 208, '樊城区', 3, '', NULL),
  (2184, 208, '襄州区', 3, '', NULL),
  (2185, 208, '南漳县', 3, '', NULL),
  (2186, 208, '谷城县', 3, '', NULL),
  (2187, 208, '保康县', 3, '', NULL),
  (2188, 208, '老河口市', 3, '', NULL),
  (2189, 208, '枣阳市', 3, '', NULL),
  (2190, 208, '宜城市', 3, '', NULL),
  (2191, 208, '其它区', 3, '', NULL),
  (2192, 209, '梁子湖区', 3, '', NULL),
  (2193, 209, '华容区', 3, '', NULL),
  (2194, 209, '鄂城区', 3, '', NULL),
  (2195, 209, '其它区', 3, '', NULL),
  (2196, 210, '东宝区', 3, '', NULL),
  (2197, 210, '掇刀区', 3, '', NULL),
  (2198, 210, '京山县', 3, '', NULL),
  (2199, 210, '沙洋县', 3, '', NULL),
  (2200, 210, '钟祥市', 3, '', NULL),
  (2201, 210, '其它区', 3, '', NULL),
  (2202, 211, '孝南区', 3, '', NULL),
  (2203, 211, '孝昌县', 3, '', NULL),
  (2204, 211, '大悟县', 3, '', NULL),
  (2205, 211, '云梦县', 3, '', NULL),
  (2206, 211, '应城市', 3, '', NULL),
  (2207, 211, '安陆市', 3, '', NULL),
  (2208, 211, '汉川市', 3, '', NULL),
  (2209, 211, '其它区', 3, '', NULL),
  (2210, 212, '沙市区', 3, '', NULL),
  (2211, 212, '荆州区', 3, '', NULL),
  (2212, 212, '公安县', 3, '', NULL),
  (2213, 212, '监利县', 3, '', NULL),
  (2214, 212, '江陵县', 3, '', NULL),
  (2215, 212, '石首市', 3, '', NULL),
  (2216, 212, '洪湖市', 3, '', NULL),
  (2217, 212, '松滋市', 3, '', NULL),
  (2218, 212, '其它区', 3, '', NULL),
  (2219, 213, '黄州区', 3, '', NULL),
  (2220, 213, '团风县', 3, '', NULL),
  (2221, 213, '红安县', 3, '', NULL),
  (2222, 213, '罗田县', 3, '', NULL),
  (2223, 213, '英山县', 3, '', NULL),
  (2224, 213, '浠水县', 3, '', NULL),
  (2225, 213, '蕲春县', 3, '', NULL),
  (2226, 213, '黄梅县', 3, '', NULL),
  (2227, 213, '麻城市', 3, '', NULL),
  (2228, 213, '武穴市', 3, '', NULL),
  (2229, 213, '其它区', 3, '', NULL),
  (2230, 214, '咸安区', 3, '', NULL),
  (2231, 214, '嘉鱼县', 3, '', NULL),
  (2232, 214, '通城县', 3, '', NULL),
  (2233, 214, '崇阳县', 3, '', NULL),
  (2234, 214, '通山县', 3, '', NULL),
  (2235, 214, '赤壁市', 3, '', NULL),
  (2236, 214, '温泉城区', 3, '', NULL),
  (2237, 214, '其它区', 3, '', NULL),
  (2238, 215, '曾都区', 3, '', NULL),
  (2239, 215, '随县', 3, '', NULL),
  (2240, 215, '广水市', 3, '', NULL),
  (2241, 215, '其它区', 3, '', NULL),
  (2242, 216, '恩施市', 3, '', NULL),
  (2243, 216, '利川市', 3, '', NULL),
  (2244, 216, '建始县', 3, '', NULL),
  (2245, 216, '巴东县', 3, '', NULL),
  (2246, 216, '宣恩县', 3, '', NULL),
  (2247, 216, '咸丰县', 3, '', NULL),
  (2248, 216, '来凤县', 3, '', NULL),
  (2249, 216, '鹤峰县', 3, '', NULL),
  (2250, 216, '其它区', 3, '', NULL),
  (2251, 217, '芙蓉区', 3, '', NULL),
  (2252, 217, '天心区', 3, '', NULL),
  (2253, 217, '岳麓区', 3, '', NULL),
  (2254, 217, '开福区', 3, '', NULL),
  (2255, 217, '雨花区', 3, '', NULL),
  (2256, 217, '长沙县', 3, '', NULL),
  (2257, 217, '望城区', 3, '', NULL),
  (2258, 217, '宁乡县', 3, '', NULL),
  (2259, 217, '浏阳市', 3, '', NULL),
  (2260, 217, '其它区', 3, '', NULL),
  (2261, 218, '荷塘区', 3, '', NULL),
  (2262, 218, '芦淞区', 3, '', NULL),
  (2263, 218, '石峰区', 3, '', NULL),
  (2264, 218, '天元区', 3, '', NULL),
  (2265, 218, '株洲县', 3, '', NULL),
  (2266, 218, '攸县', 3, '', NULL),
  (2267, 218, '茶陵县', 3, '', NULL),
  (2268, 218, '炎陵县', 3, '', NULL),
  (2269, 218, '醴陵市', 3, '', NULL),
  (2270, 218, '其它区', 3, '', NULL),
  (2271, 219, '雨湖区', 3, '', NULL),
  (2272, 219, '岳塘区', 3, '', NULL),
  (2273, 219, '湘潭县', 3, '', NULL),
  (2274, 219, '湘乡市', 3, '', NULL),
  (2275, 219, '韶山市', 3, '', NULL),
  (2276, 219, '其它区', 3, '', NULL),
  (2277, 220, '珠晖区', 3, '', NULL),
  (2278, 220, '雁峰区', 3, '', NULL),
  (2279, 220, '石鼓区', 3, '', NULL),
  (2280, 220, '蒸湘区', 3, '', NULL),
  (2281, 220, '南岳区', 3, '', NULL),
  (2282, 220, '衡阳县', 3, '', NULL),
  (2283, 220, '衡南县', 3, '', NULL),
  (2284, 220, '衡山县', 3, '', NULL),
  (2285, 220, '衡东县', 3, '', NULL),
  (2286, 220, '祁东县', 3, '', NULL),
  (2287, 220, '耒阳市', 3, '', NULL),
  (2288, 220, '常宁市', 3, '', NULL),
  (2289, 220, '其它区', 3, '', NULL),
  (2290, 221, '双清区', 3, '', NULL),
  (2291, 221, '大祥区', 3, '', NULL),
  (2292, 221, '北塔区', 3, '', NULL),
  (2293, 221, '邵东县', 3, '', NULL),
  (2294, 221, '新邵县', 3, '', NULL),
  (2295, 221, '邵阳县', 3, '', NULL),
  (2296, 221, '隆回县', 3, '', NULL),
  (2297, 221, '洞口县', 3, '', NULL),
  (2298, 221, '绥宁县', 3, '', NULL),
  (2299, 221, '新宁县', 3, '', NULL),
  (2300, 221, '城步苗族自治县', 3, '', NULL),
  (2301, 221, '武冈市', 3, '', NULL),
  (2302, 221, '其它区', 3, '', NULL),
  (2303, 222, '岳阳楼区', 3, '', NULL),
  (2304, 222, '云溪区', 3, '', NULL),
  (2305, 222, '君山区', 3, '', NULL),
  (2306, 222, '岳阳县', 3, '', NULL),
  (2307, 222, '华容县', 3, '', NULL),
  (2308, 222, '湘阴县', 3, '', NULL),
  (2309, 222, '平江县', 3, '', NULL),
  (2310, 222, '汨罗市', 3, '', NULL),
  (2311, 222, '临湘市', 3, '', NULL),
  (2312, 222, '其它区', 3, '', NULL),
  (2313, 223, '武陵区', 3, '', NULL),
  (2314, 223, '鼎城区', 3, '', NULL),
  (2315, 223, '安乡县', 3, '', NULL),
  (2316, 223, '汉寿县', 3, '', NULL),
  (2317, 223, '澧县', 3, '', NULL),
  (2318, 223, '临澧县', 3, '', NULL),
  (2319, 223, '桃源县', 3, '', NULL),
  (2320, 223, '石门县', 3, '', NULL),
  (2321, 223, '津市市', 3, '', NULL),
  (2322, 223, '其它区', 3, '', NULL),
  (2323, 224, '永定区', 3, '', NULL),
  (2324, 224, '武陵源区', 3, '', NULL),
  (2325, 224, '慈利县', 3, '', NULL),
  (2326, 224, '桑植县', 3, '', NULL),
  (2327, 224, '其它区', 3, '', NULL),
  (2328, 225, '资阳区', 3, '', NULL),
  (2329, 225, '赫山区', 3, '', NULL),
  (2330, 225, '南县', 3, '', NULL),
  (2331, 225, '桃江县', 3, '', NULL),
  (2332, 225, '安化县', 3, '', NULL),
  (2333, 225, '沅江市', 3, '', NULL),
  (2334, 225, '其它区', 3, '', NULL),
  (2335, 226, '北湖区', 3, '', NULL),
  (2336, 226, '苏仙区', 3, '', NULL),
  (2337, 226, '桂阳县', 3, '', NULL),
  (2338, 226, '宜章县', 3, '', NULL),
  (2339, 226, '永兴县', 3, '', NULL),
  (2340, 226, '嘉禾县', 3, '', NULL),
  (2341, 226, '临武县', 3, '', NULL),
  (2342, 226, '汝城县', 3, '', NULL),
  (2343, 226, '桂东县', 3, '', NULL),
  (2344, 226, '安仁县', 3, '', NULL),
  (2345, 226, '资兴市', 3, '', NULL),
  (2346, 226, '其它区', 3, '', NULL),
  (2347, 227, '零陵区', 3, '', NULL),
  (2348, 227, '冷水滩区', 3, '', NULL),
  (2349, 227, '祁阳县', 3, '', NULL),
  (2350, 227, '东安县', 3, '', NULL),
  (2351, 227, '双牌县', 3, '', NULL),
  (2352, 227, '道县', 3, '', NULL),
  (2353, 227, '江永县', 3, '', NULL),
  (2354, 227, '宁远县', 3, '', NULL),
  (2355, 227, '蓝山县', 3, '', NULL),
  (2356, 227, '新田县', 3, '', NULL),
  (2357, 227, '江华瑶族自治县', 3, '', NULL),
  (2358, 227, '其它区', 3, '', NULL),
  (2359, 228, '鹤城区', 3, '', NULL),
  (2360, 228, '中方县', 3, '', NULL),
  (2361, 228, '沅陵县', 3, '', NULL),
  (2362, 228, '辰溪县', 3, '', NULL),
  (2363, 228, '溆浦县', 3, '', NULL),
  (2364, 228, '会同县', 3, '', NULL),
  (2365, 228, '麻阳苗族自治县', 3, '', NULL),
  (2366, 228, '新晃侗族自治县', 3, '', NULL),
  (2367, 228, '芷江侗族自治县', 3, '', NULL),
  (2368, 228, '靖州苗族侗族自治县', 3, '', NULL),
  (2369, 228, '通道侗族自治县', 3, '', NULL),
  (2370, 228, '洪江市', 3, '', NULL),
  (2371, 228, '其它区', 3, '', NULL),
  (2372, 229, '娄星区', 3, '', NULL),
  (2373, 229, '双峰县', 3, '', NULL),
  (2374, 229, '新化县', 3, '', NULL),
  (2375, 229, '冷水江市', 3, '', NULL),
  (2376, 229, '涟源市', 3, '', NULL),
  (2377, 229, '其它区', 3, '', NULL),
  (2378, 230, '吉首市', 3, '', NULL),
  (2379, 230, '泸溪县', 3, '', NULL),
  (2380, 230, '凤凰县', 3, '', NULL),
  (2381, 230, '花垣县', 3, '', NULL),
  (2382, 230, '保靖县', 3, '', NULL),
  (2383, 230, '古丈县', 3, '', NULL),
  (2384, 230, '永顺县', 3, '', NULL),
  (2385, 230, '龙山县', 3, '', NULL),
  (2386, 230, '其它区', 3, '', NULL),
  (2387, 231, '荔湾区', 3, '', NULL),
  (2388, 231, '越秀区', 3, '', NULL),
  (2389, 231, '海珠区', 3, '', NULL),
  (2390, 231, '天河区', 3, '', NULL),
  (2391, 231, '白云区', 3, '', NULL),
  (2392, 231, '黄埔区', 3, '', NULL),
  (2393, 231, '番禺区', 3, '', NULL),
  (2394, 231, '花都区', 3, '', NULL),
  (2395, 231, '南沙区', 3, '', NULL),
  (2396, 231, '萝岗区', 3, '', NULL),
  (2397, 231, '增城区', 3, '', NULL),
  (2398, 231, '从化区', 3, '', NULL),
  (2399, 231, '东山区', 3, '', NULL),
  (2400, 231, '其它区', 3, '', NULL),
  (2401, 232, '武江区', 3, '', NULL),
  (2402, 232, '浈江区', 3, '', NULL),
  (2403, 232, '曲江区', 3, '', NULL),
  (2404, 232, '始兴县', 3, '', NULL),
  (2405, 232, '仁化县', 3, '', NULL),
  (2406, 232, '翁源县', 3, '', NULL),
  (2407, 232, '乳源瑶族自治县', 3, '', NULL),
  (2408, 232, '新丰县', 3, '', NULL),
  (2409, 232, '乐昌市', 3, '', NULL),
  (2410, 232, '南雄市', 3, '', NULL),
  (2411, 232, '其它区', 3, '', NULL),
  (2412, 233, '罗湖区', 3, '', NULL),
  (2413, 233, '福田区', 3, '', NULL),
  (2414, 233, '南山区', 3, '', NULL),
  (2415, 233, '宝安区', 3, '', NULL),
  (2416, 233, '龙岗区', 3, '', NULL),
  (2417, 233, '盐田区', 3, '', NULL),
  (2418, 233, '其它区', 3, '', NULL),
  (2419, 233, '光明新区', 3, '', NULL),
  (2420, 233, '坪山新区', 3, '', NULL),
  (2421, 233, '大鹏新区', 3, '', NULL),
  (2422, 233, '龙华新区', 3, '', NULL),
  (2423, 234, '香洲区', 3, '', NULL),
  (2424, 234, '斗门区', 3, '', NULL),
  (2425, 234, '金湾区', 3, '', NULL),
  (2426, 234, '金唐区', 3, '', NULL),
  (2427, 234, '南湾区', 3, '', NULL),
  (2428, 234, '其它区', 3, '', NULL),
  (2429, 235, '龙湖区', 3, '', NULL),
  (2430, 235, '金平区', 3, '', NULL),
  (2431, 235, '濠江区', 3, '', NULL),
  (2432, 235, '潮阳区', 3, '', NULL),
  (2433, 235, '潮南区', 3, '', NULL),
  (2434, 235, '澄海区', 3, '', NULL),
  (2435, 235, '南澳县', 3, '', NULL),
  (2436, 235, '其它区', 3, '', NULL),
  (2437, 236, '禅城区', 3, '', NULL),
  (2438, 236, '南海区', 3, '', NULL),
  (2439, 236, '顺德区', 3, '', NULL),
  (2440, 236, '三水区', 3, '', NULL),
  (2441, 236, '高明区', 3, '', NULL),
  (2442, 236, '其它区', 3, '', NULL),
  (2443, 237, '蓬江区', 3, '', NULL),
  (2444, 237, '江海区', 3, '', NULL),
  (2445, 237, '新会区', 3, '', NULL),
  (2446, 237, '台山市', 3, '', NULL),
  (2447, 237, '开平市', 3, '', NULL),
  (2448, 237, '鹤山市', 3, '', NULL),
  (2449, 237, '恩平市', 3, '', NULL),
  (2450, 237, '其它区', 3, '', NULL),
  (2451, 238, '赤坎区', 3, '', NULL),
  (2452, 238, '霞山区', 3, '', NULL),
  (2453, 238, '坡头区', 3, '', NULL),
  (2454, 238, '麻章区', 3, '', NULL),
  (2455, 238, '遂溪县', 3, '', NULL),
  (2456, 238, '徐闻县', 3, '', NULL),
  (2457, 238, '廉江市', 3, '', NULL),
  (2458, 238, '雷州市', 3, '', NULL),
  (2459, 238, '吴川市', 3, '', NULL),
  (2460, 238, '其它区', 3, '', NULL),
  (2461, 239, '茂南区', 3, '', NULL),
  (2462, 239, '电白区', 3, '', NULL),
  (2463, 239, '电白县', 3, '', NULL),
  (2464, 239, '高州市', 3, '', NULL),
  (2465, 239, '化州市', 3, '', NULL),
  (2466, 239, '信宜市', 3, '', NULL),
  (2467, 239, '其它区', 3, '', NULL),
  (2468, 240, '端州区', 3, '', NULL),
  (2469, 240, '鼎湖区', 3, '', NULL),
  (2470, 240, '广宁县', 3, '', NULL),
  (2471, 240, '怀集县', 3, '', NULL),
  (2472, 240, '封开县', 3, '', NULL),
  (2473, 240, '德庆县', 3, '', NULL),
  (2474, 240, '高要市', 3, '', NULL),
  (2475, 240, '四会市', 3, '', NULL),
  (2476, 240, '其它区', 3, '', NULL),
  (2477, 241, '惠城区', 3, '', NULL),
  (2478, 241, '惠阳区', 3, '', NULL),
  (2479, 241, '博罗县', 3, '', NULL),
  (2480, 241, '惠东县', 3, '', NULL),
  (2481, 241, '龙门县', 3, '', NULL),
  (2482, 241, '其它区', 3, '', NULL),
  (2483, 242, '梅江区', 3, '', NULL),
  (2484, 242, '梅县区', 3, '', NULL),
  (2485, 242, '大埔县', 3, '', NULL),
  (2486, 242, '丰顺县', 3, '', NULL),
  (2487, 242, '五华县', 3, '', NULL),
  (2488, 242, '平远县', 3, '', NULL),
  (2489, 242, '蕉岭县', 3, '', NULL),
  (2490, 242, '兴宁市', 3, '', NULL),
  (2491, 242, '其它区', 3, '', NULL),
  (2492, 243, '城区', 3, '', NULL),
  (2493, 243, '海丰县', 3, '', NULL),
  (2494, 243, '陆河县', 3, '', NULL),
  (2495, 243, '陆丰市', 3, '', NULL),
  (2496, 243, '其它区', 3, '', NULL),
  (2497, 244, '源城区', 3, '', NULL),
  (2498, 244, '紫金县', 3, '', NULL),
  (2499, 244, '龙川县', 3, '', NULL),
  (2500, 244, '连平县', 3, '', NULL),
  (2501, 244, '和平县', 3, '', NULL),
  (2502, 244, '东源县', 3, '', NULL),
  (2503, 244, '其它区', 3, '', NULL),
  (2504, 245, '江城区', 3, '', NULL),
  (2505, 245, '阳西县', 3, '', NULL),
  (2506, 245, '阳东区', 3, '', NULL),
  (2507, 245, '阳春市', 3, '', NULL),
  (2508, 245, '其它区', 3, '', NULL),
  (2509, 246, '清城区', 3, '', NULL),
  (2510, 246, '佛冈县', 3, '', NULL),
  (2511, 246, '阳山县', 3, '', NULL),
  (2512, 246, '连山壮族瑶族自治县', 3, '', NULL),
  (2513, 246, '连南瑶族自治县', 3, '', NULL),
  (2514, 246, '清新区', 3, '', NULL),
  (2515, 246, '英德市', 3, '', NULL),
  (2516, 246, '连州市', 3, '', NULL),
  (2517, 246, '其它区', 3, '', NULL),
  (2518, 250, '湘桥区', 3, '', NULL),
  (2519, 250, '潮安区', 3, '', NULL),
  (2520, 250, '饶平县', 3, '', NULL),
  (2521, 250, '枫溪区', 3, '', NULL),
  (2522, 250, '其它区', 3, '', NULL),
  (2523, 251, '榕城区', 3, '', NULL),
  (2524, 251, '揭东区', 3, '', NULL),
  (2525, 251, '揭西县', 3, '', NULL),
  (2526, 251, '惠来县', 3, '', NULL),
  (2527, 251, '普宁市', 3, '', NULL),
  (2528, 251, '东山区', 3, '', NULL),
  (2529, 251, '其它区', 3, '', NULL),
  (2530, 252, '云城区', 3, '', NULL),
  (2531, 252, '新兴县', 3, '', NULL),
  (2532, 252, '郁南县', 3, '', NULL),
  (2533, 252, '云安区', 3, '', NULL),
  (2534, 252, '罗定市', 3, '', NULL),
  (2535, 252, '其它区', 3, '', NULL),
  (2536, 253, '兴宁区', 3, '', NULL),
  (2537, 253, '青秀区', 3, '', NULL),
  (2538, 253, '江南区', 3, '', NULL),
  (2539, 253, '西乡塘区', 3, '', NULL),
  (2540, 253, '良庆区', 3, '', NULL),
  (2541, 253, '邕宁区', 3, '', NULL),
  (2542, 253, '武鸣区', 3, '', NULL),
  (2543, 253, '隆安县', 3, '', NULL),
  (2544, 253, '马山县', 3, '', NULL),
  (2545, 253, '上林县', 3, '', NULL),
  (2546, 253, '宾阳县', 3, '', NULL),
  (2547, 253, '横县', 3, '', NULL),
  (2548, 253, '其它区', 3, '', NULL),
  (2549, 254, '城中区', 3, '', NULL),
  (2550, 254, '鱼峰区', 3, '', NULL),
  (2551, 254, '柳南区', 3, '', NULL),
  (2552, 254, '柳北区', 3, '', NULL),
  (2553, 254, '柳江县', 3, '', NULL),
  (2554, 254, '柳城县', 3, '', NULL),
  (2555, 254, '鹿寨县', 3, '', NULL),
  (2556, 254, '融安县', 3, '', NULL),
  (2557, 254, '融水苗族自治县', 3, '', NULL),
  (2558, 254, '三江侗族自治县', 3, '', NULL),
  (2559, 254, '其它区', 3, '', NULL),
  (2560, 255, '秀峰区', 3, '', NULL),
  (2561, 255, '叠彩区', 3, '', NULL),
  (2562, 255, '象山区', 3, '', NULL),
  (2563, 255, '七星区', 3, '', NULL),
  (2564, 255, '雁山区', 3, '', NULL),
  (2565, 255, '阳朔县', 3, '', NULL),
  (2566, 255, '临桂区', 3, '', NULL),
  (2567, 255, '灵川县', 3, '', NULL),
  (2568, 255, '全州县', 3, '', NULL),
  (2569, 255, '兴安县', 3, '', NULL),
  (2570, 255, '永福县', 3, '', NULL),
  (2571, 255, '灌阳县', 3, '', NULL),
  (2572, 255, '龙胜各族自治县', 3, '', NULL),
  (2573, 255, '资源县', 3, '', NULL),
  (2574, 255, '平乐县', 3, '', NULL),
  (2575, 255, '荔浦县', 3, '', NULL),
  (2576, 255, '恭城瑶族自治县', 3, '', NULL),
  (2577, 255, '其它区', 3, '', NULL),
  (2578, 256, '万秀区', 3, '', NULL),
  (2579, 256, '蝶山区', 3, '', NULL),
  (2580, 256, '长洲区', 3, '', NULL),
  (2581, 256, '龙圩区', 3, '', NULL),
  (2582, 256, '苍梧县', 3, '', NULL),
  (2583, 256, '藤县', 3, '', NULL),
  (2584, 256, '蒙山县', 3, '', NULL),
  (2585, 256, '岑溪市', 3, '', NULL),
  (2586, 256, '其它区', 3, '', NULL),
  (2587, 257, '海城区', 3, '', NULL),
  (2588, 257, '银海区', 3, '', NULL),
  (2589, 257, '铁山港区', 3, '', NULL),
  (2590, 257, '合浦县', 3, '', NULL),
  (2591, 257, '其它区', 3, '', NULL),
  (2592, 258, '港口区', 3, '', NULL),
  (2593, 258, '防城区', 3, '', NULL),
  (2594, 258, '上思县', 3, '', NULL),
  (2595, 258, '东兴市', 3, '', NULL),
  (2596, 258, '其它区', 3, '', NULL),
  (2597, 259, '钦南区', 3, '', NULL),
  (2598, 259, '钦北区', 3, '', NULL),
  (2599, 259, '灵山县', 3, '', NULL),
  (2600, 259, '浦北县', 3, '', NULL),
  (2601, 259, '其它区', 3, '', NULL),
  (2602, 260, '港北区', 3, '', NULL),
  (2603, 260, '港南区', 3, '', NULL),
  (2604, 260, '覃塘区', 3, '', NULL),
  (2605, 260, '平南县', 3, '', NULL),
  (2606, 260, '桂平市', 3, '', NULL),
  (2607, 260, '其它区', 3, '', NULL),
  (2608, 261, '玉州区', 3, '', NULL),
  (2609, 261, '福绵区', 3, '', NULL),
  (2610, 261, '容县', 3, '', NULL),
  (2611, 261, '陆川县', 3, '', NULL),
  (2612, 261, '博白县', 3, '', NULL),
  (2613, 261, '兴业县', 3, '', NULL),
  (2614, 261, '北流市', 3, '', NULL),
  (2615, 261, '其它区', 3, '', NULL),
  (2616, 262, '右江区', 3, '', NULL),
  (2617, 262, '田阳县', 3, '', NULL),
  (2618, 262, '田东县', 3, '', NULL),
  (2619, 262, '平果县', 3, '', NULL),
  (2620, 262, '德保县', 3, '', NULL),
  (2621, 262, '靖西县', 3, '', NULL),
  (2622, 262, '那坡县', 3, '', NULL),
  (2623, 262, '凌云县', 3, '', NULL),
  (2624, 262, '乐业县', 3, '', NULL),
  (2625, 262, '田林县', 3, '', NULL),
  (2626, 262, '西林县', 3, '', NULL),
  (2627, 262, '隆林各族自治县', 3, '', NULL),
  (2628, 262, '其它区', 3, '', NULL),
  (2629, 263, '八步区', 3, '', NULL),
  (2630, 263, '平桂管理区', 3, '', NULL),
  (2631, 263, '昭平县', 3, '', NULL),
  (2632, 263, '钟山县', 3, '', NULL),
  (2633, 263, '富川瑶族自治县', 3, '', NULL),
  (2634, 263, '其它区', 3, '', NULL),
  (2635, 264, '金城江区', 3, '', NULL),
  (2636, 264, '南丹县', 3, '', NULL),
  (2637, 264, '天峨县', 3, '', NULL),
  (2638, 264, '凤山县', 3, '', NULL),
  (2639, 264, '东兰县', 3, '', NULL),
  (2640, 264, '罗城仫佬族自治县', 3, '', NULL),
  (2641, 264, '环江毛南族自治县', 3, '', NULL),
  (2642, 264, '巴马瑶族自治县', 3, '', NULL),
  (2643, 264, '都安瑶族自治县', 3, '', NULL),
  (2644, 264, '大化瑶族自治县', 3, '', NULL),
  (2645, 264, '宜州市', 3, '', NULL),
  (2646, 264, '其它区', 3, '', NULL),
  (2647, 265, '兴宾区', 3, '', NULL),
  (2648, 265, '忻城县', 3, '', NULL),
  (2649, 265, '象州县', 3, '', NULL),
  (2650, 265, '武宣县', 3, '', NULL),
  (2651, 265, '金秀瑶族自治县', 3, '', NULL),
  (2652, 265, '合山市', 3, '', NULL),
  (2653, 265, '其它区', 3, '', NULL),
  (2654, 266, '江州区', 3, '', NULL),
  (2655, 266, '扶绥县', 3, '', NULL),
  (2656, 266, '宁明县', 3, '', NULL),
  (2657, 266, '龙州县', 3, '', NULL),
  (2658, 266, '大新县', 3, '', NULL),
  (2659, 266, '天等县', 3, '', NULL),
  (2660, 266, '凭祥市', 3, '', NULL),
  (2661, 266, '其它区', 3, '', NULL),
  (2662, 267, '秀英区', 3, '', NULL),
  (2663, 267, '龙华区', 3, '', NULL),
  (2664, 267, '琼山区', 3, '', NULL),
  (2665, 267, '美兰区', 3, '', NULL),
  (2666, 267, '其它区', 3, '', NULL),
  (2667, 269, '西沙群岛', 3, '', NULL),
  (2668, 269, '南沙群岛', 3, '', NULL),
  (2669, 269, '中沙群岛的岛礁及其海域', 3, '', NULL),
  (2670, 189, '高新区', 3, '', NULL),
  (2671, 189, '其它区', 3, '', NULL),
  (2672, 270, '万州区', 3, '', NULL),
  (2673, 270, '涪陵区', 3, '', NULL),
  (2674, 270, '渝中区', 3, '', NULL),
  (2675, 270, '大渡口区', 3, '', NULL),
  (2676, 270, '江北区', 3, '', NULL),
  (2677, 270, '沙坪坝区', 3, '', NULL),
  (2678, 270, '九龙坡区', 3, '', NULL),
  (2679, 270, '南岸区', 3, '', NULL),
  (2680, 270, '北碚区', 3, '', NULL),
  (2681, 270, '万盛区', 3, '', NULL),
  (2682, 270, '双桥区', 3, '', NULL),
  (2683, 270, '渝北区', 3, '', NULL),
  (2684, 270, '巴南区', 3, '', NULL),
  (2685, 270, '黔江区', 3, '', NULL),
  (2686, 270, '长寿区', 3, '', NULL),
  (2687, 270, '綦江区', 3, '', NULL),
  (2688, 270, '潼南县', 3, '', NULL),
  (2689, 270, '铜梁区', 3, '', NULL),
  (2690, 270, '大足区', 3, '', NULL),
  (2691, 270, '荣昌县', 3, '', NULL),
  (2692, 270, '璧山区', 3, '', NULL),
  (2693, 270, '梁平县', 3, '', NULL),
  (2694, 270, '城口县', 3, '', NULL),
  (2695, 270, '丰都县', 3, '', NULL),
  (2696, 270, '垫江县', 3, '', NULL),
  (2697, 270, '武隆县', 3, '', NULL),
  (2698, 270, '忠县', 3, '', NULL),
  (2699, 270, '开县', 3, '', NULL),
  (2700, 270, '云阳县', 3, '', NULL),
  (2701, 270, '奉节县', 3, '', NULL),
  (2702, 270, '巫山县', 3, '', NULL),
  (2703, 270, '巫溪县', 3, '', NULL),
  (2704, 270, '石柱土家族自治县', 3, '', NULL),
  (2705, 270, '秀山土家族苗族自治县', 3, '', NULL),
  (2706, 270, '酉阳土家族苗族自治县', 3, '', NULL),
  (2707, 270, '彭水苗族土家族自治县', 3, '', NULL),
  (2708, 270, '江津区', 3, '', NULL),
  (2709, 270, '合川区', 3, '', NULL),
  (2710, 270, '永川区', 3, '', NULL),
  (2711, 270, '南川区', 3, '', NULL),
  (2712, 270, '其它区', 3, '', NULL),
  (2713, 271, '锦江区', 3, '', NULL),
  (2714, 271, '青羊区', 3, '', NULL),
  (2715, 271, '金牛区', 3, '', NULL),
  (2716, 271, '武侯区', 3, '', NULL),
  (2717, 271, '成华区', 3, '', NULL),
  (2718, 271, '龙泉驿区', 3, '', NULL),
  (2719, 271, '青白江区', 3, '', NULL),
  (2720, 271, '新都区', 3, '', NULL),
  (2721, 271, '温江区', 3, '', NULL),
  (2722, 271, '金堂县', 3, '', NULL),
  (2723, 271, '双流县', 3, '', NULL),
  (2724, 271, '郫县', 3, '', NULL),
  (2725, 271, '大邑县', 3, '', NULL),
  (2726, 271, '蒲江县', 3, '', NULL),
  (2727, 271, '新津县', 3, '', NULL),
  (2728, 271, '都江堰市', 3, '', NULL),
  (2729, 271, '彭州市', 3, '', NULL),
  (2730, 271, '邛崃市', 3, '', NULL),
  (2731, 271, '崇州市', 3, '', NULL),
  (2732, 271, '其它区', 3, '', NULL),
  (2733, 272, '自流井区', 3, '', NULL),
  (2734, 272, '贡井区', 3, '', NULL),
  (2735, 272, '大安区', 3, '', NULL),
  (2736, 272, '沿滩区', 3, '', NULL),
  (2737, 272, '荣县', 3, '', NULL),
  (2738, 272, '富顺县', 3, '', NULL),
  (2739, 272, '其它区', 3, '', NULL),
  (2740, 273, '东区', 3, '', NULL),
  (2741, 273, '西区', 3, '', NULL),
  (2742, 273, '仁和区', 3, '', NULL),
  (2743, 273, '米易县', 3, '', NULL),
  (2744, 273, '盐边县', 3, '', NULL),
  (2745, 273, '其它区', 3, '', NULL),
  (2746, 274, '江阳区', 3, '', NULL),
  (2747, 274, '纳溪区', 3, '', NULL),
  (2748, 274, '龙马潭区', 3, '', NULL),
  (2749, 274, '泸县', 3, '', NULL),
  (2750, 274, '合江县', 3, '', NULL),
  (2751, 274, '叙永县', 3, '', NULL),
  (2752, 274, '古蔺县', 3, '', NULL),
  (2753, 274, '其它区', 3, '', NULL),
  (2754, 275, '旌阳区', 3, '', NULL),
  (2755, 275, '中江县', 3, '', NULL),
  (2756, 275, '罗江县', 3, '', NULL),
  (2757, 275, '广汉市', 3, '', NULL),
  (2758, 275, '什邡市', 3, '', NULL),
  (2759, 275, '绵竹市', 3, '', NULL),
  (2760, 275, '其它区', 3, '', NULL),
  (2761, 276, '涪城区', 3, '', NULL),
  (2762, 276, '游仙区', 3, '', NULL),
  (2763, 276, '三台县', 3, '', NULL),
  (2764, 276, '盐亭县', 3, '', NULL),
  (2765, 276, '安县', 3, '', NULL),
  (2766, 276, '梓潼县', 3, '', NULL),
  (2767, 276, '北川羌族自治县', 3, '', NULL),
  (2768, 276, '平武县', 3, '', NULL),
  (2769, 276, '高新区', 3, '', NULL),
  (2770, 276, '江油市', 3, '', NULL),
  (2771, 276, '其它区', 3, '', NULL),
  (2772, 277, '利州区', 3, '', NULL),
  (2773, 277, '昭化区', 3, '', NULL),
  (2774, 277, '朝天区', 3, '', NULL),
  (2775, 277, '旺苍县', 3, '', NULL),
  (2776, 277, '青川县', 3, '', NULL),
  (2777, 277, '剑阁县', 3, '', NULL),
  (2778, 277, '苍溪县', 3, '', NULL),
  (2779, 277, '其它区', 3, '', NULL),
  (2780, 278, '船山区', 3, '', NULL),
  (2781, 278, '安居区', 3, '', NULL),
  (2782, 278, '蓬溪县', 3, '', NULL),
  (2783, 278, '射洪县', 3, '', NULL),
  (2784, 278, '大英县', 3, '', NULL),
  (2785, 278, '其它区', 3, '', NULL),
  (2786, 279, '市中区', 3, '', NULL),
  (2787, 279, '东兴区', 3, '', NULL),
  (2788, 279, '威远县', 3, '', NULL),
  (2789, 279, '资中县', 3, '', NULL),
  (2790, 279, '隆昌县', 3, '', NULL),
  (2791, 279, '其它区', 3, '', NULL),
  (2792, 280, '市中区', 3, '', NULL),
  (2793, 280, '沙湾区', 3, '', NULL),
  (2794, 280, '五通桥区', 3, '', NULL),
  (2795, 280, '金口河区', 3, '', NULL),
  (2796, 280, '犍为县', 3, '', NULL),
  (2797, 280, '井研县', 3, '', NULL),
  (2798, 280, '夹江县', 3, '', NULL),
  (2799, 280, '沐川县', 3, '', NULL),
  (2800, 280, '峨边彝族自治县', 3, '', NULL),
  (2801, 280, '马边彝族自治县', 3, '', NULL),
  (2802, 280, '峨眉山市', 3, '', NULL),
  (2803, 280, '其它区', 3, '', NULL),
  (2804, 281, '顺庆区', 3, '', NULL),
  (2805, 281, '高坪区', 3, '', NULL),
  (2806, 281, '嘉陵区', 3, '', NULL),
  (2807, 281, '南部县', 3, '', NULL),
  (2808, 281, '营山县', 3, '', NULL),
  (2809, 281, '蓬安县', 3, '', NULL),
  (2810, 281, '仪陇县', 3, '', NULL),
  (2811, 281, '西充县', 3, '', NULL),
  (2812, 281, '阆中市', 3, '', NULL),
  (2813, 281, '其它区', 3, '', NULL),
  (2814, 282, '东坡区', 3, '', NULL),
  (2815, 282, '仁寿县', 3, '', NULL),
  (2816, 282, '彭山区', 3, '', NULL),
  (2817, 282, '洪雅县', 3, '', NULL),
  (2818, 282, '丹棱县', 3, '', NULL),
  (2819, 282, '青神县', 3, '', NULL),
  (2820, 282, '其它区', 3, '', NULL),
  (2821, 283, '翠屏区', 3, '', NULL),
  (2822, 283, '宜宾县', 3, '', NULL),
  (2823, 283, '南溪区', 3, '', NULL),
  (2824, 283, '江安县', 3, '', NULL),
  (2825, 283, '长宁县', 3, '', NULL),
  (2826, 283, '高县', 3, '', NULL),
  (2827, 283, '珙县', 3, '', NULL),
  (2828, 283, '筠连县', 3, '', NULL),
  (2829, 283, '兴文县', 3, '', NULL),
  (2830, 283, '屏山县', 3, '', NULL),
  (2831, 283, '其它区', 3, '', NULL),
  (2832, 284, '广安区', 3, '', NULL),
  (2833, 284, '前锋区', 3, '', NULL),
  (2834, 284, '岳池县', 3, '', NULL),
  (2835, 284, '武胜县', 3, '', NULL),
  (2836, 284, '邻水县', 3, '', NULL),
  (2837, 284, '华蓥市', 3, '', NULL),
  (2838, 284, '市辖区', 3, '', NULL),
  (2839, 284, '其它区', 3, '', NULL),
  (2840, 285, '通川区', 3, '', NULL),
  (2841, 285, '达川区', 3, '', NULL),
  (2842, 285, '宣汉县', 3, '', NULL),
  (2843, 285, '开江县', 3, '', NULL),
  (2844, 285, '大竹县', 3, '', NULL),
  (2845, 285, '渠县', 3, '', NULL),
  (2846, 285, '万源市', 3, '', NULL),
  (2847, 285, '其它区', 3, '', NULL),
  (2848, 286, '雨城区', 3, '', NULL),
  (2849, 286, '名山区', 3, '', NULL),
  (2850, 286, '荥经县', 3, '', NULL),
  (2851, 286, '汉源县', 3, '', NULL),
  (2852, 286, '石棉县', 3, '', NULL),
  (2853, 286, '天全县', 3, '', NULL),
  (2854, 286, '芦山县', 3, '', NULL),
  (2855, 286, '宝兴县', 3, '', NULL),
  (2856, 286, '其它区', 3, '', NULL),
  (2857, 287, '巴州区', 3, '', NULL),
  (2858, 287, '恩阳区', 3, '', NULL),
  (2859, 287, '通江县', 3, '', NULL),
  (2860, 287, '南江县', 3, '', NULL),
  (2861, 287, '平昌县', 3, '', NULL),
  (2862, 287, '其它区', 3, '', NULL),
  (2863, 288, '雁江区', 3, '', NULL),
  (2864, 288, '安岳县', 3, '', NULL),
  (2865, 288, '乐至县', 3, '', NULL),
  (2866, 288, '简阳市', 3, '', NULL),
  (2867, 288, '其它区', 3, '', NULL),
  (2868, 289, '汶川县', 3, '', NULL),
  (2869, 289, '理县', 3, '', NULL),
  (2870, 289, '茂县', 3, '', NULL),
  (2871, 289, '松潘县', 3, '', NULL),
  (2872, 289, '九寨沟县', 3, '', NULL),
  (2873, 289, '金川县', 3, '', NULL),
  (2874, 289, '小金县', 3, '', NULL),
  (2875, 289, '黑水县', 3, '', NULL),
  (2876, 289, '马尔康县', 3, '', NULL),
  (2877, 289, '壤塘县', 3, '', NULL),
  (2878, 289, '阿坝县', 3, '', NULL),
  (2879, 289, '若尔盖县', 3, '', NULL),
  (2880, 289, '红原县', 3, '', NULL),
  (2881, 289, '其它区', 3, '', NULL),
  (2882, 290, '康定市', 3, '', NULL),
  (2883, 290, '泸定县', 3, '', NULL),
  (2884, 290, '丹巴县', 3, '', NULL),
  (2885, 290, '九龙县', 3, '', NULL),
  (2886, 290, '雅江县', 3, '', NULL),
  (2887, 290, '道孚县', 3, '', NULL),
  (2888, 290, '炉霍县', 3, '', NULL),
  (2889, 290, '甘孜县', 3, '', NULL),
  (2890, 290, '新龙县', 3, '', NULL),
  (2891, 290, '德格县', 3, '', NULL),
  (2892, 290, '白玉县', 3, '', NULL),
  (2893, 290, '石渠县', 3, '', NULL),
  (2894, 290, '色达县', 3, '', NULL),
  (2895, 290, '理塘县', 3, '', NULL),
  (2896, 290, '巴塘县', 3, '', NULL),
  (2897, 290, '乡城县', 3, '', NULL),
  (2898, 290, '稻城县', 3, '', NULL),
  (2899, 290, '得荣县', 3, '', NULL),
  (2900, 290, '其它区', 3, '', NULL),
  (2901, 291, '西昌市', 3, '', NULL),
  (2902, 291, '木里藏族自治县', 3, '', NULL),
  (2903, 291, '盐源县', 3, '', NULL),
  (2904, 291, '德昌县', 3, '', NULL),
  (2905, 291, '会理县', 3, '', NULL),
  (2906, 291, '会东县', 3, '', NULL),
  (2907, 291, '宁南县', 3, '', NULL),
  (2908, 291, '普格县', 3, '', NULL),
  (2909, 291, '布拖县', 3, '', NULL),
  (2910, 291, '金阳县', 3, '', NULL),
  (2911, 291, '昭觉县', 3, '', NULL),
  (2912, 291, '喜德县', 3, '', NULL),
  (2913, 291, '冕宁县', 3, '', NULL),
  (2914, 291, '越西县', 3, '', NULL),
  (2915, 291, '甘洛县', 3, '', NULL),
  (2916, 291, '美姑县', 3, '', NULL),
  (2917, 291, '雷波县', 3, '', NULL),
  (2918, 291, '其它区', 3, '', NULL),
  (2919, 292, '南明区', 3, '', NULL),
  (2920, 292, '云岩区', 3, '', NULL),
  (2921, 292, '花溪区', 3, '', NULL),
  (2922, 292, '乌当区', 3, '', NULL),
  (2923, 292, '白云区', 3, '', NULL),
  (2924, 292, '小河区', 3, '', NULL),
  (2925, 292, '开阳县', 3, '', NULL),
  (2926, 292, '息烽县', 3, '', NULL),
  (2927, 292, '修文县', 3, '', NULL),
  (2928, 292, '观山湖区', 3, '', NULL),
  (2929, 292, '清镇市', 3, '', NULL),
  (2930, 292, '其它区', 3, '', NULL),
  (2931, 293, '钟山区', 3, '', NULL),
  (2932, 293, '六枝特区', 3, '', NULL),
  (2933, 293, '水城县', 3, '', NULL),
  (2934, 293, '盘县', 3, '', NULL),
  (2935, 293, '其它区', 3, '', NULL),
  (2936, 294, '红花岗区', 3, '', NULL),
  (2937, 294, '汇川区', 3, '', NULL),
  (2938, 294, '遵义县', 3, '', NULL),
  (2939, 294, '桐梓县', 3, '', NULL),
  (2940, 294, '绥阳县', 3, '', NULL),
  (2941, 294, '正安县', 3, '', NULL),
  (2942, 294, '道真仡佬族苗族自治县', 3, '', NULL),
  (2943, 294, '务川仡佬族苗族自治县', 3, '', NULL),
  (2944, 294, '凤冈县', 3, '', NULL),
  (2945, 294, '湄潭县', 3, '', NULL),
  (2946, 294, '余庆县', 3, '', NULL),
  (2947, 294, '习水县', 3, '', NULL),
  (2948, 294, '赤水市', 3, '', NULL),
  (2949, 294, '仁怀市', 3, '', NULL),
  (2950, 294, '其它区', 3, '', NULL),
  (2951, 295, '西秀区', 3, '', NULL),
  (2952, 295, '平坝区', 3, '', NULL),
  (2953, 295, '普定县', 3, '', NULL),
  (2954, 295, '镇宁布依族苗族自治县', 3, '', NULL),
  (2955, 295, '关岭布依族苗族自治县', 3, '', NULL),
  (2956, 295, '紫云苗族布依族自治县', 3, '', NULL),
  (2957, 295, '其它区', 3, '', NULL),
  (2958, 296, '碧江区', 3, '', NULL),
  (2959, 296, '江口县', 3, '', NULL),
  (2960, 296, '玉屏侗族自治县', 3, '', NULL),
  (2961, 296, '石阡县', 3, '', NULL),
  (2962, 296, '思南县', 3, '', NULL),
  (2963, 296, '印江土家族苗族自治县', 3, '', NULL),
  (2964, 296, '德江县', 3, '', NULL),
  (2965, 296, '沿河土家族自治县', 3, '', NULL),
  (2966, 296, '松桃苗族自治县', 3, '', NULL),
  (2967, 296, '万山区', 3, '', NULL),
  (2968, 296, '其它区', 3, '', NULL),
  (2969, 297, '兴义市', 3, '', NULL),
  (2970, 297, '兴仁县', 3, '', NULL),
  (2971, 297, '普安县', 3, '', NULL),
  (2972, 297, '晴隆县', 3, '', NULL),
  (2973, 297, '贞丰县', 3, '', NULL),
  (2974, 297, '望谟县', 3, '', NULL),
  (2975, 297, '册亨县', 3, '', NULL),
  (2976, 297, '安龙县', 3, '', NULL),
  (2977, 297, '其它区', 3, '', NULL),
  (2978, 298, '七星关区', 3, '', NULL),
  (2979, 298, '大方县', 3, '', NULL),
  (2980, 298, '黔西县', 3, '', NULL),
  (2981, 298, '金沙县', 3, '', NULL),
  (2982, 298, '织金县', 3, '', NULL),
  (2983, 298, '纳雍县', 3, '', NULL),
  (2984, 298, '威宁彝族回族苗族自治县', 3, '', NULL),
  (2985, 298, '赫章县', 3, '', NULL),
  (2986, 298, '其它区', 3, '', NULL),
  (2987, 299, '凯里市', 3, '', NULL),
  (2988, 299, '黄平县', 3, '', NULL),
  (2989, 299, '施秉县', 3, '', NULL),
  (2990, 299, '三穗县', 3, '', NULL),
  (2991, 299, '镇远县', 3, '', NULL),
  (2992, 299, '岑巩县', 3, '', NULL),
  (2993, 299, '天柱县', 3, '', NULL),
  (2994, 299, '锦屏县', 3, '', NULL),
  (2995, 299, '剑河县', 3, '', NULL),
  (2996, 299, '台江县', 3, '', NULL),
  (2997, 299, '黎平县', 3, '', NULL),
  (2998, 299, '榕江县', 3, '', NULL),
  (2999, 299, '从江县', 3, '', NULL),
  (3000, 299, '雷山县', 3, '', NULL),
  (3001, 299, '麻江县', 3, '', NULL),
  (3002, 299, '丹寨县', 3, '', NULL),
  (3003, 299, '其它区', 3, '', NULL),
  (3004, 300, '都匀市', 3, '', NULL),
  (3005, 300, '福泉市', 3, '', NULL),
  (3006, 300, '荔波县', 3, '', NULL),
  (3007, 300, '贵定县', 3, '', NULL),
  (3008, 300, '瓮安县', 3, '', NULL),
  (3009, 300, '独山县', 3, '', NULL),
  (3010, 300, '平塘县', 3, '', NULL),
  (3011, 300, '罗甸县', 3, '', NULL),
  (3012, 300, '长顺县', 3, '', NULL),
  (3013, 300, '龙里县', 3, '', NULL),
  (3014, 300, '惠水县', 3, '', NULL),
  (3015, 300, '三都水族自治县', 3, '', NULL),
  (3016, 300, '其它区', 3, '', NULL),
  (3017, 301, '五华区', 3, '', NULL),
  (3018, 301, '盘龙区', 3, '', NULL),
  (3019, 301, '官渡区', 3, '', NULL),
  (3020, 301, '西山区', 3, '', NULL),
  (3021, 301, '东川区', 3, '', NULL),
  (3022, 301, '呈贡区', 3, '', NULL),
  (3023, 301, '晋宁县', 3, '', NULL),
  (3024, 301, '富民县', 3, '', NULL),
  (3025, 301, '宜良县', 3, '', NULL),
  (3026, 301, '石林彝族自治县', 3, '', NULL),
  (3027, 301, '嵩明县', 3, '', NULL),
  (3028, 301, '禄劝彝族苗族自治县', 3, '', NULL),
  (3029, 301, '寻甸回族彝族自治县', 3, '', NULL),
  (3030, 301, '安宁市', 3, '', NULL),
  (3031, 301, '其它区', 3, '', NULL),
  (3032, 302, '麒麟区', 3, '', NULL),
  (3033, 302, '马龙县', 3, '', NULL),
  (3034, 302, '陆良县', 3, '', NULL),
  (3035, 302, '师宗县', 3, '', NULL),
  (3036, 302, '罗平县', 3, '', NULL),
  (3037, 302, '富源县', 3, '', NULL),
  (3038, 302, '会泽县', 3, '', NULL),
  (3039, 302, '沾益县', 3, '', NULL),
  (3040, 302, '宣威市', 3, '', NULL),
  (3041, 302, '其它区', 3, '', NULL),
  (3042, 303, '红塔区', 3, '', NULL),
  (3043, 303, '江川县', 3, '', NULL),
  (3044, 303, '澄江县', 3, '', NULL),
  (3045, 303, '通海县', 3, '', NULL),
  (3046, 303, '华宁县', 3, '', NULL),
  (3047, 303, '易门县', 3, '', NULL),
  (3048, 303, '峨山彝族自治县', 3, '', NULL),
  (3049, 303, '新平彝族傣族自治县', 3, '', NULL),
  (3050, 303, '元江哈尼族彝族傣族自治县', 3, '', NULL),
  (3051, 303, '其它区', 3, '', NULL),
  (3052, 304, '隆阳区', 3, '', NULL),
  (3053, 304, '施甸县', 3, '', NULL),
  (3054, 304, '腾冲县', 3, '', NULL),
  (3055, 304, '龙陵县', 3, '', NULL),
  (3056, 304, '昌宁县', 3, '', NULL),
  (3057, 304, '其它区', 3, '', NULL),
  (3058, 305, '昭阳区', 3, '', NULL),
  (3059, 305, '鲁甸县', 3, '', NULL),
  (3060, 305, '巧家县', 3, '', NULL),
  (3061, 305, '盐津县', 3, '', NULL),
  (3062, 305, '大关县', 3, '', NULL),
  (3063, 305, '永善县', 3, '', NULL),
  (3064, 305, '绥江县', 3, '', NULL),
  (3065, 305, '镇雄县', 3, '', NULL),
  (3066, 305, '彝良县', 3, '', NULL),
  (3067, 305, '威信县', 3, '', NULL),
  (3068, 305, '水富县', 3, '', NULL),
  (3069, 305, '其它区', 3, '', NULL),
  (3070, 306, '古城区', 3, '', NULL),
  (3071, 306, '玉龙纳西族自治县', 3, '', NULL),
  (3072, 306, '永胜县', 3, '', NULL),
  (3073, 306, '华坪县', 3, '', NULL),
  (3074, 306, '宁蒗彝族自治县', 3, '', NULL),
  (3075, 306, '其它区', 3, '', NULL),
  (3076, 307, '思茅区', 3, '', NULL),
  (3077, 307, '宁洱哈尼族彝族自治县', 3, '', NULL),
  (3078, 307, '墨江哈尼族自治县', 3, '', NULL),
  (3079, 307, '景东彝族自治县', 3, '', NULL),
  (3080, 307, '景谷傣族彝族自治县', 3, '', NULL),
  (3081, 307, '镇沅彝族哈尼族拉祜族自治县', 3, '', NULL),
  (3082, 307, '江城哈尼族彝族自治县', 3, '', NULL),
  (3083, 307, '孟连傣族拉祜族佤族自治县', 3, '', NULL),
  (3084, 307, '澜沧拉祜族自治县', 3, '', NULL),
  (3085, 307, '西盟佤族自治县', 3, '', NULL),
  (3086, 307, '其它区', 3, '', NULL),
  (3087, 308, '临翔区', 3, '', NULL),
  (3088, 308, '凤庆县', 3, '', NULL),
  (3089, 308, '云县', 3, '', NULL),
  (3090, 308, '永德县', 3, '', NULL),
  (3091, 308, '镇康县', 3, '', NULL),
  (3092, 308, '双江拉祜族佤族布朗族傣族自治县', 3, '', NULL),
  (3093, 308, '耿马傣族佤族自治县', 3, '', NULL),
  (3094, 308, '沧源佤族自治县', 3, '', NULL),
  (3095, 308, '其它区', 3, '', NULL),
  (3096, 309, '楚雄市', 3, '', NULL),
  (3097, 309, '双柏县', 3, '', NULL),
  (3098, 309, '牟定县', 3, '', NULL),
  (3099, 309, '南华县', 3, '', NULL),
  (3100, 309, '姚安县', 3, '', NULL),
  (3101, 309, '大姚县', 3, '', NULL),
  (3102, 309, '永仁县', 3, '', NULL),
  (3103, 309, '元谋县', 3, '', NULL),
  (3104, 309, '武定县', 3, '', NULL),
  (3105, 309, '禄丰县', 3, '', NULL),
  (3106, 309, '其它区', 3, '', NULL),
  (3107, 310, '个旧市', 3, '', NULL),
  (3108, 310, '开远市', 3, '', NULL),
  (3109, 310, '蒙自市', 3, '', NULL),
  (3110, 310, '屏边苗族自治县', 3, '', NULL),
  (3111, 310, '建水县', 3, '', NULL),
  (3112, 310, '石屏县', 3, '', NULL),
  (3113, 310, '弥勒市', 3, '', NULL),
  (3114, 310, '泸西县', 3, '', NULL),
  (3115, 310, '元阳县', 3, '', NULL),
  (3116, 310, '红河县', 3, '', NULL),
  (3117, 310, '金平苗族瑶族傣族自治县', 3, '', NULL),
  (3118, 310, '绿春县', 3, '', NULL),
  (3119, 310, '河口瑶族自治县', 3, '', NULL),
  (3120, 310, '其它区', 3, '', NULL),
  (3121, 311, '文山市', 3, '', NULL),
  (3122, 311, '砚山县', 3, '', NULL),
  (3123, 311, '西畴县', 3, '', NULL),
  (3124, 311, '麻栗坡县', 3, '', NULL),
  (3125, 311, '马关县', 3, '', NULL),
  (3126, 311, '丘北县', 3, '', NULL),
  (3127, 311, '广南县', 3, '', NULL),
  (3128, 311, '富宁县', 3, '', NULL),
  (3129, 311, '其它区', 3, '', NULL),
  (3130, 312, '景洪市', 3, '', NULL),
  (3131, 312, '勐海县', 3, '', NULL),
  (3132, 312, '勐腊县', 3, '', NULL),
  (3133, 312, '其它区', 3, '', NULL),
  (3134, 313, '大理市', 3, '', NULL),
  (3135, 313, '漾濞彝族自治县', 3, '', NULL),
  (3136, 313, '祥云县', 3, '', NULL),
  (3137, 313, '宾川县', 3, '', NULL),
  (3138, 313, '弥渡县', 3, '', NULL),
  (3139, 313, '南涧彝族自治县', 3, '', NULL),
  (3140, 313, '巍山彝族回族自治县', 3, '', NULL),
  (3141, 313, '永平县', 3, '', NULL),
  (3142, 313, '云龙县', 3, '', NULL),
  (3143, 313, '洱源县', 3, '', NULL),
  (3144, 313, '剑川县', 3, '', NULL),
  (3145, 313, '鹤庆县', 3, '', NULL),
  (3146, 313, '其它区', 3, '', NULL),
  (3147, 314, '瑞丽市', 3, '', NULL),
  (3148, 314, '芒市', 3, '', NULL),
  (3149, 314, '梁河县', 3, '', NULL),
  (3150, 314, '盈江县', 3, '', NULL),
  (3151, 314, '陇川县', 3, '', NULL),
  (3152, 314, '其它区', 3, '', NULL),
  (3153, 315, '泸水县', 3, '', NULL),
  (3154, 315, '福贡县', 3, '', NULL),
  (3155, 315, '贡山独龙族怒族自治县', 3, '', NULL),
  (3156, 315, '兰坪白族普米族自治县', 3, '', NULL),
  (3157, 315, '其它区', 3, '', NULL),
  (3158, 316, '香格里拉市', 3, '', NULL),
  (3159, 316, '德钦县', 3, '', NULL),
  (3160, 316, '维西傈僳族自治县', 3, '', NULL),
  (3161, 316, '其它区', 3, '', NULL),
  (3162, 317, '城关区', 3, '', NULL),
  (3163, 317, '林周县', 3, '', NULL),
  (3164, 317, '当雄县', 3, '', NULL),
  (3165, 317, '尼木县', 3, '', NULL),
  (3166, 317, '曲水县', 3, '', NULL),
  (3167, 317, '堆龙德庆县', 3, '', NULL),
  (3168, 317, '达孜县', 3, '', NULL),
  (3169, 317, '墨竹工卡县', 3, '', NULL),
  (3170, 317, '其它区', 3, '', NULL),
  (3171, 318, '卡若区', 3, '', NULL),
  (3172, 318, '江达县', 3, '', NULL),
  (3173, 318, '贡觉县', 3, '', NULL),
  (3174, 318, '类乌齐县', 3, '', NULL),
  (3175, 318, '丁青县', 3, '', NULL),
  (3176, 318, '察雅县', 3, '', NULL),
  (3177, 318, '八宿县', 3, '', NULL),
  (3178, 318, '左贡县', 3, '', NULL),
  (3179, 318, '芒康县', 3, '', NULL),
  (3180, 318, '洛隆县', 3, '', NULL),
  (3181, 318, '边坝县', 3, '', NULL),
  (3182, 318, '其它区', 3, '', NULL),
  (3183, 319, '乃东县', 3, '', NULL),
  (3184, 319, '扎囊县', 3, '', NULL),
  (3185, 319, '贡嘎县', 3, '', NULL),
  (3186, 319, '桑日县', 3, '', NULL),
  (3187, 319, '琼结县', 3, '', NULL),
  (3188, 319, '曲松县', 3, '', NULL),
  (3189, 319, '措美县', 3, '', NULL),
  (3190, 319, '洛扎县', 3, '', NULL),
  (3191, 319, '加查县', 3, '', NULL),
  (3192, 319, '隆子县', 3, '', NULL),
  (3193, 319, '错那县', 3, '', NULL),
  (3194, 319, '浪卡子县', 3, '', NULL),
  (3195, 319, '其它区', 3, '', NULL),
  (3196, 320, '桑珠孜区', 3, '', NULL),
  (3197, 320, '南木林县', 3, '', NULL),
  (3198, 320, '江孜县', 3, '', NULL),
  (3199, 320, '定日县', 3, '', NULL),
  (3200, 320, '萨迦县', 3, '', NULL),
  (3201, 320, '拉孜县', 3, '', NULL),
  (3202, 320, '昂仁县', 3, '', NULL),
  (3203, 320, '谢通门县', 3, '', NULL),
  (3204, 320, '白朗县', 3, '', NULL),
  (3205, 320, '仁布县', 3, '', NULL),
  (3206, 320, '康马县', 3, '', NULL),
  (3207, 320, '定结县', 3, '', NULL),
  (3208, 320, '仲巴县', 3, '', NULL),
  (3209, 320, '亚东县', 3, '', NULL),
  (3210, 320, '吉隆县', 3, '', NULL),
  (3211, 320, '聂拉木县', 3, '', NULL),
  (3212, 320, '萨嘎县', 3, '', NULL),
  (3213, 320, '岗巴县', 3, '', NULL),
  (3214, 320, '其它区', 3, '', NULL),
  (3215, 321, '那曲县', 3, '', NULL),
  (3216, 321, '嘉黎县', 3, '', NULL),
  (3217, 321, '比如县', 3, '', NULL),
  (3218, 321, '聂荣县', 3, '', NULL),
  (3219, 321, '安多县', 3, '', NULL),
  (3220, 321, '申扎县', 3, '', NULL),
  (3221, 321, '索县', 3, '', NULL),
  (3222, 321, '班戈县', 3, '', NULL),
  (3223, 321, '巴青县', 3, '', NULL),
  (3224, 321, '尼玛县', 3, '', NULL),
  (3225, 321, '其它区', 3, '', NULL),
  (3226, 321, '双湖县', 3, '', NULL),
  (3227, 322, '普兰县', 3, '', NULL),
  (3228, 322, '札达县', 3, '', NULL),
  (3229, 322, '噶尔县', 3, '', NULL),
  (3230, 322, '日土县', 3, '', NULL),
  (3231, 322, '革吉县', 3, '', NULL),
  (3232, 322, '改则县', 3, '', NULL),
  (3233, 322, '措勤县', 3, '', NULL),
  (3234, 322, '其它区', 3, '', NULL),
  (3235, 323, '巴宜区', 3, '', NULL),
  (3236, 323, '工布江达县', 3, '', NULL),
  (3237, 323, '米林县', 3, '', NULL),
  (3238, 323, '墨脱县', 3, '', NULL),
  (3239, 323, '波密县', 3, '', NULL),
  (3240, 323, '察隅县', 3, '', NULL),
  (3241, 323, '朗县', 3, '', NULL),
  (3242, 323, '其它区', 3, '', NULL),
  (3243, 324, '新城区', 3, '', NULL),
  (3244, 324, '碑林区', 3, '', NULL),
  (3245, 324, '莲湖区', 3, '', NULL),
  (3246, 324, '灞桥区', 3, '', NULL),
  (3247, 324, '未央区', 3, '', NULL),
  (3248, 324, '雁塔区', 3, '', NULL),
  (3249, 324, '阎良区', 3, '', NULL),
  (3250, 324, '临潼区', 3, '', NULL),
  (3251, 324, '长安区', 3, '', NULL),
  (3252, 324, '蓝田县', 3, '', NULL),
  (3253, 324, '周至县', 3, '', NULL),
  (3254, 324, '户县', 3, '', NULL),
  (3255, 324, '高陵区', 3, '', NULL),
  (3256, 324, '其它区', 3, '', NULL),
  (3257, 325, '王益区', 3, '', NULL),
  (3258, 325, '印台区', 3, '', NULL),
  (3259, 325, '耀州区', 3, '', NULL),
  (3260, 325, '宜君县', 3, '', NULL),
  (3261, 325, '其它区', 3, '', NULL),
  (3262, 326, '渭滨区', 3, '', NULL),
  (3263, 326, '金台区', 3, '', NULL),
  (3264, 326, '陈仓区', 3, '', NULL),
  (3265, 326, '凤翔县', 3, '', NULL),
  (3266, 326, '岐山县', 3, '', NULL),
  (3267, 326, '扶风县', 3, '', NULL),
  (3268, 326, '眉县', 3, '', NULL),
  (3269, 326, '陇县', 3, '', NULL),
  (3270, 326, '千阳县', 3, '', NULL),
  (3271, 326, '麟游县', 3, '', NULL),
  (3272, 326, '凤县', 3, '', NULL),
  (3273, 326, '太白县', 3, '', NULL),
  (3274, 326, '其它区', 3, '', NULL),
  (3275, 327, '秦都区', 3, '', NULL),
  (3276, 327, '杨陵区', 3, '', NULL),
  (3277, 327, '渭城区', 3, '', NULL),
  (3278, 327, '三原县', 3, '', NULL),
  (3279, 327, '泾阳县', 3, '', NULL),
  (3280, 327, '乾县', 3, '', NULL),
  (3281, 327, '礼泉县', 3, '', NULL),
  (3282, 327, '永寿县', 3, '', NULL),
  (3283, 327, '彬县', 3, '', NULL),
  (3284, 327, '长武县', 3, '', NULL),
  (3285, 327, '旬邑县', 3, '', NULL),
  (3286, 327, '淳化县', 3, '', NULL),
  (3287, 327, '武功县', 3, '', NULL),
  (3288, 327, '兴平市', 3, '', NULL),
  (3289, 327, '其它区', 3, '', NULL),
  (3290, 328, '临渭区', 3, '', NULL),
  (3291, 328, '华县', 3, '', NULL),
  (3292, 328, '潼关县', 3, '', NULL),
  (3293, 328, '大荔县', 3, '', NULL),
  (3294, 328, '合阳县', 3, '', NULL),
  (3295, 328, '澄城县', 3, '', NULL),
  (3296, 328, '蒲城县', 3, '', NULL),
  (3297, 328, '白水县', 3, '', NULL),
  (3298, 328, '富平县', 3, '', NULL),
  (3299, 328, '韩城市', 3, '', NULL),
  (3300, 328, '华阴市', 3, '', NULL),
  (3301, 328, '其它区', 3, '', NULL),
  (3302, 329, '宝塔区', 3, '', NULL),
  (3303, 329, '延长县', 3, '', NULL),
  (3304, 329, '延川县', 3, '', NULL),
  (3305, 329, '子长县', 3, '', NULL),
  (3306, 329, '安塞县', 3, '', NULL),
  (3307, 329, '志丹县', 3, '', NULL),
  (3308, 329, '吴起县', 3, '', NULL),
  (3309, 329, '甘泉县', 3, '', NULL),
  (3310, 329, '富县', 3, '', NULL),
  (3311, 329, '洛川县', 3, '', NULL),
  (3312, 329, '宜川县', 3, '', NULL),
  (3313, 329, '黄龙县', 3, '', NULL),
  (3314, 329, '黄陵县', 3, '', NULL),
  (3315, 329, '其它区', 3, '', NULL),
  (3316, 330, '汉台区', 3, '', NULL),
  (3317, 330, '南郑县', 3, '', NULL),
  (3318, 330, '城固县', 3, '', NULL),
  (3319, 330, '洋县', 3, '', NULL),
  (3320, 330, '西乡县', 3, '', NULL),
  (3321, 330, '勉县', 3, '', NULL),
  (3322, 330, '宁强县', 3, '', NULL),
  (3323, 330, '略阳县', 3, '', NULL),
  (3324, 330, '镇巴县', 3, '', NULL),
  (3325, 330, '留坝县', 3, '', NULL),
  (3326, 330, '佛坪县', 3, '', NULL),
  (3327, 330, '其它区', 3, '', NULL),
  (3328, 331, '榆阳区', 3, '', NULL),
  (3329, 331, '神木县', 3, '', NULL),
  (3330, 331, '府谷县', 3, '', NULL),
  (3331, 331, '横山县', 3, '', NULL),
  (3332, 331, '靖边县', 3, '', NULL),
  (3333, 331, '定边县', 3, '', NULL),
  (3334, 331, '绥德县', 3, '', NULL),
  (3335, 331, '米脂县', 3, '', NULL),
  (3336, 331, '佳县', 3, '', NULL),
  (3337, 331, '吴堡县', 3, '', NULL),
  (3338, 331, '清涧县', 3, '', NULL),
  (3339, 331, '子洲县', 3, '', NULL),
  (3340, 331, '其它区', 3, '', NULL),
  (3341, 332, '汉滨区', 3, '', NULL),
  (3342, 332, '汉阴县', 3, '', NULL),
  (3343, 332, '石泉县', 3, '', NULL),
  (3344, 332, '宁陕县', 3, '', NULL),
  (3345, 332, '紫阳县', 3, '', NULL),
  (3346, 332, '岚皋县', 3, '', NULL),
  (3347, 332, '平利县', 3, '', NULL),
  (3348, 332, '镇坪县', 3, '', NULL),
  (3349, 332, '旬阳县', 3, '', NULL),
  (3350, 332, '白河县', 3, '', NULL),
  (3351, 332, '其它区', 3, '', NULL),
  (3352, 333, '商州区', 3, '', NULL),
  (3353, 333, '洛南县', 3, '', NULL),
  (3354, 333, '丹凤县', 3, '', NULL),
  (3355, 333, '商南县', 3, '', NULL),
  (3356, 333, '山阳县', 3, '', NULL),
  (3357, 333, '镇安县', 3, '', NULL),
  (3358, 333, '柞水县', 3, '', NULL),
  (3359, 333, '其它区', 3, '', NULL),
  (3360, 334, '城关区', 3, '', NULL),
  (3361, 334, '七里河区', 3, '', NULL),
  (3362, 334, '西固区', 3, '', NULL),
  (3363, 334, '安宁区', 3, '', NULL),
  (3364, 334, '红古区', 3, '', NULL),
  (3365, 334, '永登县', 3, '', NULL),
  (3366, 334, '皋兰县', 3, '', NULL),
  (3367, 334, '榆中县', 3, '', NULL),
  (3368, 334, '其它区', 3, '', NULL),
  (3369, 336, '金川区', 3, '', NULL),
  (3370, 336, '永昌县', 3, '', NULL),
  (3371, 336, '其它区', 3, '', NULL),
  (3372, 337, '白银区', 3, '', NULL),
  (3373, 337, '平川区', 3, '', NULL),
  (3374, 337, '靖远县', 3, '', NULL),
  (3375, 337, '会宁县', 3, '', NULL),
  (3376, 337, '景泰县', 3, '', NULL),
  (3377, 337, '其它区', 3, '', NULL),
  (3378, 338, '秦州区', 3, '', NULL),
  (3379, 338, '麦积区', 3, '', NULL),
  (3380, 338, '清水县', 3, '', NULL),
  (3381, 338, '秦安县', 3, '', NULL),
  (3382, 338, '甘谷县', 3, '', NULL),
  (3383, 338, '武山县', 3, '', NULL),
  (3384, 338, '张家川回族自治县', 3, '', NULL),
  (3385, 338, '其它区', 3, '', NULL),
  (3386, 339, '凉州区', 3, '', NULL),
  (3387, 339, '民勤县', 3, '', NULL),
  (3388, 339, '古浪县', 3, '', NULL),
  (3389, 339, '天祝藏族自治县', 3, '', NULL),
  (3390, 339, '其它区', 3, '', NULL),
  (3391, 340, '甘州区', 3, '', NULL),
  (3392, 340, '肃南裕固族自治县', 3, '', NULL),
  (3393, 340, '民乐县', 3, '', NULL),
  (3394, 340, '临泽县', 3, '', NULL),
  (3395, 340, '高台县', 3, '', NULL),
  (3396, 340, '山丹县', 3, '', NULL),
  (3397, 340, '其它区', 3, '', NULL),
  (3398, 341, '崆峒区', 3, '', NULL),
  (3399, 341, '泾川县', 3, '', NULL),
  (3400, 341, '灵台县', 3, '', NULL),
  (3401, 341, '崇信县', 3, '', NULL),
  (3402, 341, '华亭县', 3, '', NULL),
  (3403, 341, '庄浪县', 3, '', NULL),
  (3404, 341, '静宁县', 3, '', NULL),
  (3405, 341, '其它区', 3, '', NULL),
  (3406, 342, '肃州区', 3, '', NULL),
  (3407, 342, '金塔县', 3, '', NULL),
  (3408, 342, '瓜州县', 3, '', NULL),
  (3409, 342, '肃北蒙古族自治县', 3, '', NULL),
  (3410, 342, '阿克塞哈萨克族自治县', 3, '', NULL),
  (3411, 342, '玉门市', 3, '', NULL),
  (3412, 342, '敦煌市', 3, '', NULL),
  (3413, 342, '其它区', 3, '', NULL),
  (3414, 343, '西峰区', 3, '', NULL),
  (3415, 343, '庆城县', 3, '', NULL),
  (3416, 343, '环县', 3, '', NULL),
  (3417, 343, '华池县', 3, '', NULL),
  (3418, 343, '合水县', 3, '', NULL),
  (3419, 343, '正宁县', 3, '', NULL),
  (3420, 343, '宁县', 3, '', NULL),
  (3421, 343, '镇原县', 3, '', NULL),
  (3422, 343, '其它区', 3, '', NULL),
  (3423, 344, '安定区', 3, '', NULL),
  (3424, 344, '通渭县', 3, '', NULL),
  (3425, 344, '陇西县', 3, '', NULL),
  (3426, 344, '渭源县', 3, '', NULL),
  (3427, 344, '临洮县', 3, '', NULL),
  (3428, 344, '漳县', 3, '', NULL),
  (3429, 344, '岷县', 3, '', NULL),
  (3430, 344, '其它区', 3, '', NULL),
  (3431, 345, '武都区', 3, '', NULL),
  (3432, 345, '成县', 3, '', NULL),
  (3433, 345, '文县', 3, '', NULL),
  (3434, 345, '宕昌县', 3, '', NULL),
  (3435, 345, '康县', 3, '', NULL),
  (3436, 345, '西和县', 3, '', NULL),
  (3437, 345, '礼县', 3, '', NULL),
  (3438, 345, '徽县', 3, '', NULL),
  (3439, 345, '两当县', 3, '', NULL),
  (3440, 345, '其它区', 3, '', NULL),
  (3441, 346, '临夏市', 3, '', NULL),
  (3442, 346, '临夏县', 3, '', NULL),
  (3443, 346, '康乐县', 3, '', NULL),
  (3444, 346, '永靖县', 3, '', NULL),
  (3445, 346, '广河县', 3, '', NULL),
  (3446, 346, '和政县', 3, '', NULL),
  (3447, 346, '东乡族自治县', 3, '', NULL),
  (3448, 346, '积石山保安族东乡族撒拉族自治县', 3, '', NULL),
  (3449, 346, '其它区', 3, '', NULL),
  (3450, 347, '合作市', 3, '', NULL),
  (3451, 347, '临潭县', 3, '', NULL),
  (3452, 347, '卓尼县', 3, '', NULL),
  (3453, 347, '舟曲县', 3, '', NULL),
  (3454, 347, '迭部县', 3, '', NULL),
  (3455, 347, '玛曲县', 3, '', NULL),
  (3456, 347, '碌曲县', 3, '', NULL),
  (3457, 347, '夏河县', 3, '', NULL),
  (3458, 347, '其它区', 3, '', NULL),
  (3459, 348, '城东区', 3, '', NULL),
  (3460, 348, '城中区', 3, '', NULL),
  (3461, 348, '城西区', 3, '', NULL),
  (3462, 348, '城北区', 3, '', NULL),
  (3463, 348, '大通回族土族自治县', 3, '', NULL),
  (3464, 348, '湟中县', 3, '', NULL),
  (3465, 348, '湟源县', 3, '', NULL),
  (3466, 348, '其它区', 3, '', NULL),
  (3467, 349, '平安区', 3, '', NULL),
  (3468, 349, '民和回族土族自治县', 3, '', NULL),
  (3469, 349, '乐都区', 3, '', NULL),
  (3470, 349, '互助土族自治县', 3, '', NULL),
  (3471, 349, '化隆回族自治县', 3, '', NULL),
  (3472, 349, '循化撒拉族自治县', 3, '', NULL),
  (3473, 349, '其它区', 3, '', NULL),
  (3474, 350, '门源回族自治县', 3, '', NULL),
  (3475, 350, '祁连县', 3, '', NULL),
  (3476, 350, '海晏县', 3, '', NULL),
  (3477, 350, '刚察县', 3, '', NULL),
  (3478, 350, '其它区', 3, '', NULL),
  (3479, 351, '同仁县', 3, '', NULL),
  (3480, 351, '尖扎县', 3, '', NULL),
  (3481, 351, '泽库县', 3, '', NULL),
  (3482, 351, '河南蒙古族自治县', 3, '', NULL),
  (3483, 351, '其它区', 3, '', NULL),
  (3484, 352, '共和县', 3, '', NULL),
  (3485, 352, '同德县', 3, '', NULL),
  (3486, 352, '贵德县', 3, '', NULL),
  (3487, 352, '兴海县', 3, '', NULL),
  (3488, 352, '贵南县', 3, '', NULL),
  (3489, 352, '其它区', 3, '', NULL),
  (3490, 353, '玛沁县', 3, '', NULL),
  (3491, 353, '班玛县', 3, '', NULL),
  (3492, 353, '甘德县', 3, '', NULL),
  (3493, 353, '达日县', 3, '', NULL),
  (3494, 353, '久治县', 3, '', NULL),
  (3495, 353, '玛多县', 3, '', NULL),
  (3496, 353, '其它区', 3, '', NULL),
  (3497, 354, '玉树市', 3, '', NULL),
  (3498, 354, '杂多县', 3, '', NULL),
  (3499, 354, '称多县', 3, '', NULL),
  (3500, 354, '治多县', 3, '', NULL),
  (3501, 354, '囊谦县', 3, '', NULL),
  (3502, 354, '曲麻莱县', 3, '', NULL),
  (3503, 354, '其它区', 3, '', NULL),
  (3504, 355, '格尔木市', 3, '', NULL),
  (3505, 355, '德令哈市', 3, '', NULL),
  (3506, 355, '乌兰县', 3, '', NULL),
  (3507, 355, '都兰县', 3, '', NULL),
  (3508, 355, '天峻县', 3, '', NULL),
  (3509, 355, '其它区', 3, '', NULL),
  (3510, 356, '兴庆区', 3, '', NULL),
  (3511, 356, '西夏区', 3, '', NULL),
  (3512, 356, '金凤区', 3, '', NULL),
  (3513, 356, '永宁县', 3, '', NULL),
  (3514, 356, '贺兰县', 3, '', NULL),
  (3515, 356, '灵武市', 3, '', NULL),
  (3516, 356, '其它区', 3, '', NULL),
  (3517, 357, '大武口区', 3, '', NULL),
  (3518, 357, '惠农区', 3, '', NULL),
  (3519, 357, '平罗县', 3, '', NULL),
  (3520, 357, '其它区', 3, '', NULL),
  (3521, 358, '利通区', 3, '', NULL),
  (3522, 358, '红寺堡区', 3, '', NULL),
  (3523, 358, '盐池县', 3, '', NULL),
  (3524, 358, '同心县', 3, '', NULL),
  (3525, 358, '青铜峡市', 3, '', NULL),
  (3526, 358, '其它区', 3, '', NULL),
  (3527, 359, '原州区', 3, '', NULL),
  (3528, 359, '西吉县', 3, '', NULL),
  (3529, 359, '隆德县', 3, '', NULL),
  (3530, 359, '泾源县', 3, '', NULL),
  (3531, 359, '彭阳县', 3, '', NULL),
  (3532, 359, '其它区', 3, '', NULL),
  (3533, 360, '沙坡头区', 3, '', NULL),
  (3534, 360, '中宁县', 3, '', NULL),
  (3535, 360, '海原县', 3, '', NULL),
  (3536, 360, '其它区', 3, '', NULL),
  (3537, 361, '天山区', 3, '', NULL),
  (3538, 361, '沙依巴克区', 3, '', NULL),
  (3539, 361, '新市区', 3, '', NULL),
  (3540, 361, '水磨沟区', 3, '', NULL),
  (3541, 361, '头屯河区', 3, '', NULL),
  (3542, 361, '达坂城区', 3, '', NULL),
  (3543, 361, '东山区', 3, '', NULL),
  (3544, 361, '米东区', 3, '', NULL),
  (3545, 361, '乌鲁木齐县', 3, '', NULL),
  (3546, 361, '其它区', 3, '', NULL),
  (3547, 362, '独山子区', 3, '', NULL),
  (3548, 362, '克拉玛依区', 3, '', NULL),
  (3549, 362, '白碱滩区', 3, '', NULL),
  (3550, 362, '乌尔禾区', 3, '', NULL),
  (3551, 362, '其它区', 3, '', NULL),
  (3552, 363, '高昌区', 3, '', NULL),
  (3553, 363, '鄯善县', 3, '', NULL),
  (3554, 363, '托克逊县', 3, '', NULL),
  (3555, 363, '其它区', 3, '', NULL),
  (3556, 364, '哈密市', 3, '', NULL),
  (3557, 364, '巴里坤哈萨克自治县', 3, '', NULL),
  (3558, 364, '伊吾县', 3, '', NULL),
  (3559, 364, '其它区', 3, '', NULL),
  (3560, 365, '昌吉市', 3, '', NULL),
  (3561, 365, '阜康市', 3, '', NULL),
  (3562, 365, '米泉市', 3, '', NULL),
  (3563, 365, '呼图壁县', 3, '', NULL),
  (3564, 365, '玛纳斯县', 3, '', NULL),
  (3565, 365, '奇台县', 3, '', NULL),
  (3566, 365, '吉木萨尔县', 3, '', NULL),
  (3567, 365, '木垒哈萨克自治县', 3, '', NULL),
  (3568, 365, '其它区', 3, '', NULL),
  (3569, 366, '博乐市', 3, '', NULL),
  (3570, 366, '阿拉山口市', 3, '', NULL),
  (3571, 366, '精河县', 3, '', NULL),
  (3572, 366, '温泉县', 3, '', NULL),
  (3573, 366, '其它区', 3, '', NULL),
  (3574, 367, '库尔勒市', 3, '', NULL),
  (3575, 367, '轮台县', 3, '', NULL),
  (3576, 367, '尉犁县', 3, '', NULL),
  (3577, 367, '若羌县', 3, '', NULL),
  (3578, 367, '且末县', 3, '', NULL),
  (3579, 367, '焉耆回族自治县', 3, '', NULL),
  (3580, 367, '和静县', 3, '', NULL),
  (3581, 367, '和硕县', 3, '', NULL),
  (3582, 367, '博湖县', 3, '', NULL),
  (3583, 367, '其它区', 3, '', NULL),
  (3584, 368, '阿克苏市', 3, '', NULL),
  (3585, 368, '温宿县', 3, '', NULL),
  (3586, 368, '库车县', 3, '', NULL),
  (3587, 368, '沙雅县', 3, '', NULL),
  (3588, 368, '新和县', 3, '', NULL),
  (3589, 368, '拜城县', 3, '', NULL),
  (3590, 368, '乌什县', 3, '', NULL),
  (3591, 368, '阿瓦提县', 3, '', NULL),
  (3592, 368, '柯坪县', 3, '', NULL),
  (3593, 368, '其它区', 3, '', NULL),
  (3594, 369, '阿图什市', 3, '', NULL),
  (3595, 369, '阿克陶县', 3, '', NULL),
  (3596, 369, '阿合奇县', 3, '', NULL),
  (3597, 369, '乌恰县', 3, '', NULL),
  (3598, 369, '其它区', 3, '', NULL),
  (3599, 370, '喀什市', 3, '', NULL),
  (3600, 370, '疏附县', 3, '', NULL),
  (3601, 370, '疏勒县', 3, '', NULL),
  (3602, 370, '英吉沙县', 3, '', NULL),
  (3603, 370, '泽普县', 3, '', NULL),
  (3604, 370, '莎车县', 3, '', NULL),
  (3605, 370, '叶城县', 3, '', NULL),
  (3606, 370, '麦盖提县', 3, '', NULL),
  (3607, 370, '岳普湖县', 3, '', NULL),
  (3608, 370, '伽师县', 3, '', NULL),
  (3609, 370, '巴楚县', 3, '', NULL),
  (3610, 370, '塔什库尔干塔吉克自治县', 3, '', NULL),
  (3611, 370, '其它区', 3, '', NULL),
  (3612, 371, '和田市', 3, '', NULL),
  (3613, 371, '和田县', 3, '', NULL),
  (3614, 371, '墨玉县', 3, '', NULL),
  (3615, 371, '皮山县', 3, '', NULL),
  (3616, 371, '洛浦县', 3, '', NULL),
  (3617, 371, '策勒县', 3, '', NULL),
  (3618, 371, '于田县', 3, '', NULL),
  (3619, 371, '民丰县', 3, '', NULL),
  (3620, 371, '其它区', 3, '', NULL),
  (3621, 372, '伊宁市', 3, '', NULL),
  (3622, 372, '奎屯市', 3, '', NULL),
  (3623, 372, '伊宁县', 3, '', NULL),
  (3624, 372, '察布查尔锡伯自治县', 3, '', NULL),
  (3625, 372, '霍城县', 3, '', NULL),
  (3626, 372, '巩留县', 3, '', NULL),
  (3627, 372, '新源县', 3, '', NULL),
  (3628, 372, '昭苏县', 3, '', NULL),
  (3629, 372, '特克斯县', 3, '', NULL),
  (3630, 372, '尼勒克县', 3, '', NULL),
  (3631, 372, '其它区', 3, '', NULL),
  (3632, 373, '塔城市', 3, '', NULL),
  (3633, 373, '乌苏市', 3, '', NULL),
  (3634, 373, '额敏县', 3, '', NULL),
  (3635, 373, '沙湾县', 3, '', NULL),
  (3636, 373, '托里县', 3, '', NULL),
  (3637, 373, '裕民县', 3, '', NULL),
  (3638, 373, '和布克赛尔蒙古自治县', 3, '', NULL),
  (3639, 373, '其它区', 3, '', NULL),
  (3640, 374, '阿勒泰市', 3, '', NULL),
  (3641, 374, '布尔津县', 3, '', NULL),
  (3642, 374, '富蕴县', 3, '', NULL),
  (3643, 374, '福海县', 3, '', NULL),
  (3644, 374, '哈巴河县', 3, '', NULL),
  (3645, 374, '青河县', 3, '', NULL),
  (3646, 374, '吉木乃县', 3, '', NULL),
  (3647, 374, '其它区', 3, '', NULL),
  (3648, 375, '中正区', 3, '', NULL),
  (3649, 375, '大同区', 3, '', NULL),
  (3650, 375, '中山区', 3, '', NULL),
  (3651, 375, '松山区', 3, '', NULL),
  (3652, 375, '大安区', 3, '', NULL),
  (3653, 375, '万华区', 3, '', NULL),
  (3654, 375, '信义区', 3, '', NULL),
  (3655, 375, '士林区', 3, '', NULL),
  (3656, 375, '北投区', 3, '', NULL),
  (3657, 375, '内湖区', 3, '', NULL),
  (3658, 375, '南港区', 3, '', NULL),
  (3659, 375, '文山区', 3, '', NULL),
  (3660, 375, '其它区', 3, '', NULL),
  (3661, 376, '新兴区', 3, '', NULL),
  (3662, 376, '前金区', 3, '', NULL),
  (3663, 376, '芩雅区', 3, '', NULL),
  (3664, 376, '盐埕区', 3, '', NULL),
  (3665, 376, '鼓山区', 3, '', NULL),
  (3666, 376, '旗津区', 3, '', NULL),
  (3667, 376, '前镇区', 3, '', NULL),
  (3668, 376, '三民区', 3, '', NULL),
  (3669, 376, '左营区', 3, '', NULL),
  (3670, 376, '楠梓区', 3, '', NULL),
  (3671, 376, '小港区', 3, '', NULL),
  (3672, 376, '其它区', 3, '', NULL),
  (3673, 376, '苓雅区', 3, '', NULL),
  (3674, 376, '仁武区', 3, '', NULL),
  (3675, 376, '大社区', 3, '', NULL),
  (3676, 376, '冈山区', 3, '', NULL),
  (3677, 376, '路竹区', 3, '', NULL),
  (3678, 376, '阿莲区', 3, '', NULL),
  (3679, 376, '田寮区', 3, '', NULL),
  (3680, 376, '燕巢区', 3, '', NULL),
  (3681, 376, '桥头区', 3, '', NULL),
  (3682, 376, '梓官区', 3, '', NULL),
  (3683, 376, '弥陀区', 3, '', NULL),
  (3684, 376, '永安区', 3, '', NULL),
  (3685, 376, '湖内区', 3, '', NULL),
  (3686, 376, '凤山区', 3, '', NULL),
  (3687, 376, '大寮区', 3, '', NULL),
  (3688, 376, '林园区', 3, '', NULL),
  (3689, 376, '鸟松区', 3, '', NULL),
  (3690, 376, '大树区', 3, '', NULL),
  (3691, 376, '旗山区', 3, '', NULL),
  (3692, 376, '美浓区', 3, '', NULL),
  (3693, 376, '六龟区', 3, '', NULL),
  (3694, 376, '内门区', 3, '', NULL),
  (3695, 376, '杉林区', 3, '', NULL),
  (3696, 376, '甲仙区', 3, '', NULL),
  (3697, 376, '桃源区', 3, '', NULL),
  (3698, 376, '那玛夏区', 3, '', NULL),
  (3699, 376, '茂林区', 3, '', NULL),
  (3700, 376, '茄萣区', 3, '', NULL),
  (3701, 377, '中西区', 3, '', NULL),
  (3702, 377, '东区', 3, '', NULL),
  (3703, 377, '南区', 3, '', NULL),
  (3704, 377, '北区', 3, '', NULL),
  (3705, 377, '安平区', 3, '', NULL),
  (3706, 377, '安南区', 3, '', NULL),
  (3707, 377, '其它区', 3, '', NULL),
  (3708, 377, '永康区', 3, '', NULL),
  (3709, 377, '归仁区', 3, '', NULL),
  (3710, 377, '新化区', 3, '', NULL),
  (3711, 377, '左镇区', 3, '', NULL),
  (3712, 377, '玉井区', 3, '', NULL),
  (3713, 377, '楠西区', 3, '', NULL),
  (3714, 377, '南化区', 3, '', NULL),
  (3715, 377, '仁德区', 3, '', NULL),
  (3716, 377, '关庙区', 3, '', NULL),
  (3717, 377, '龙崎区', 3, '', NULL),
  (3718, 377, '官田区', 3, '', NULL),
  (3719, 377, '麻豆区', 3, '', NULL),
  (3720, 377, '佳里区', 3, '', NULL),
  (3721, 377, '西港区', 3, '', NULL),
  (3722, 377, '七股区', 3, '', NULL),
  (3723, 377, '将军区', 3, '', NULL),
  (3724, 377, '学甲区', 3, '', NULL),
  (3725, 377, '北门区', 3, '', NULL),
  (3726, 377, '新营区', 3, '', NULL),
  (3727, 377, '后壁区', 3, '', NULL),
  (3728, 377, '白河区', 3, '', NULL),
  (3729, 377, '东山区', 3, '', NULL),
  (3730, 377, '六甲区', 3, '', NULL),
  (3731, 377, '下营区', 3, '', NULL),
  (3732, 377, '柳营区', 3, '', NULL),
  (3733, 377, '盐水区', 3, '', NULL),
  (3734, 377, '善化区', 3, '', NULL),
  (3735, 377, '大内区', 3, '', NULL),
  (3736, 377, '山上区', 3, '', NULL),
  (3737, 377, '新市区', 3, '', NULL),
  (3738, 377, '安定区', 3, '', NULL),
  (3739, 378, '中区', 3, '', NULL),
  (3740, 378, '东区', 3, '', NULL),
  (3741, 378, '南区', 3, '', NULL),
  (3742, 378, '西区', 3, '', NULL),
  (3743, 378, '北区', 3, '', NULL),
  (3744, 378, '北屯区', 3, '', NULL),
  (3745, 378, '西屯区', 3, '', NULL),
  (3746, 378, '南屯区', 3, '', NULL),
  (3747, 378, '其它区', 3, '', NULL),
  (3748, 378, '太平区', 3, '', NULL),
  (3749, 378, '大里区', 3, '', NULL),
  (3750, 378, '雾峰区', 3, '', NULL),
  (3751, 378, '乌日区', 3, '', NULL),
  (3752, 378, '丰原区', 3, '', NULL),
  (3753, 378, '后里区', 3, '', NULL),
  (3754, 378, '石冈区', 3, '', NULL),
  (3755, 378, '东势区', 3, '', NULL),
  (3756, 378, '和平区', 3, '', NULL),
  (3757, 378, '新社区', 3, '', NULL),
  (3758, 378, '潭子区', 3, '', NULL),
  (3759, 378, '大雅区', 3, '', NULL),
  (3760, 378, '神冈区', 3, '', NULL),
  (3761, 378, '大肚区', 3, '', NULL),
  (3762, 378, '沙鹿区', 3, '', NULL),
  (3763, 378, '龙井区', 3, '', NULL),
  (3764, 378, '梧栖区', 3, '', NULL),
  (3765, 378, '清水区', 3, '', NULL),
  (3766, 378, '大甲区', 3, '', NULL),
  (3767, 378, '外埔区', 3, '', NULL),
  (3768, 378, '大安区', 3, '', NULL),
  (3769, 379, '金沙镇', 3, '', NULL),
  (3770, 379, '金湖镇', 3, '', NULL),
  (3771, 379, '金宁乡', 3, '', NULL),
  (3772, 379, '金城镇', 3, '', NULL),
  (3773, 379, '烈屿乡', 3, '', NULL),
  (3774, 379, '乌坵乡', 3, '', NULL),
  (3775, 380, '南投市', 3, '', NULL),
  (3776, 380, '中寮乡', 3, '', NULL),
  (3777, 380, '草屯镇', 3, '', NULL),
  (3778, 380, '国姓乡', 3, '', NULL),
  (3779, 380, '埔里镇', 3, '', NULL),
  (3780, 380, '仁爱乡', 3, '', NULL),
  (3781, 380, '名间乡', 3, '', NULL),
  (3782, 380, '集集镇', 3, '', NULL),
  (3783, 380, '水里乡', 3, '', NULL),
  (3784, 380, '鱼池乡', 3, '', NULL),
  (3785, 380, '信义乡', 3, '', NULL),
  (3786, 380, '竹山镇', 3, '', NULL),
  (3787, 380, '鹿谷乡', 3, '', NULL),
  (3788, 381, '仁爱区', 3, '', NULL),
  (3789, 381, '信义区', 3, '', NULL),
  (3790, 381, '中正区', 3, '', NULL),
  (3791, 381, '中山区', 3, '', NULL),
  (3792, 381, '安乐区', 3, '', NULL),
  (3793, 381, '暖暖区', 3, '', NULL),
  (3794, 381, '七堵区', 3, '', NULL),
  (3795, 381, '其它区', 3, '', NULL),
  (3796, 382, '东区', 3, '', NULL),
  (3797, 382, '北区', 3, '', NULL),
  (3798, 382, '香山区', 3, '', NULL),
  (3799, 382, '其它区', 3, '', NULL),
  (3800, 383, '东区', 3, '', NULL),
  (3801, 383, '西区', 3, '', NULL),
  (3802, 383, '其它区', 3, '', NULL),
  (3803, 384, '万里区', 3, '', NULL),
  (3804, 384, '金山区', 3, '', NULL),
  (3805, 384, '板桥区', 3, '', NULL),
  (3806, 384, '汐止区', 3, '', NULL),
  (3807, 384, '深坑区', 3, '', NULL),
  (3808, 384, '石碇区', 3, '', NULL),
  (3809, 384, '瑞芳区', 3, '', NULL),
  (3810, 384, '平溪区', 3, '', NULL),
  (3811, 384, '双溪区', 3, '', NULL),
  (3812, 384, '贡寮区', 3, '', NULL),
  (3813, 384, '新店区', 3, '', NULL),
  (3814, 384, '坪林区', 3, '', NULL),
  (3815, 384, '乌来区', 3, '', NULL),
  (3816, 384, '永和区', 3, '', NULL),
  (3817, 384, '中和区', 3, '', NULL),
  (3818, 384, '土城区', 3, '', NULL),
  (3819, 384, '三峡区', 3, '', NULL),
  (3820, 384, '树林区', 3, '', NULL),
  (3821, 384, '莺歌区', 3, '', NULL),
  (3822, 384, '三重区', 3, '', NULL),
  (3823, 384, '新庄区', 3, '', NULL),
  (3824, 384, '泰山区', 3, '', NULL),
  (3825, 384, '林口区', 3, '', NULL),
  (3826, 384, '芦洲区', 3, '', NULL),
  (3827, 384, '五股区', 3, '', NULL),
  (3828, 384, '八里区', 3, '', NULL),
  (3829, 384, '淡水区', 3, '', NULL),
  (3830, 384, '三芝区', 3, '', NULL),
  (3831, 384, '石门区', 3, '', NULL),
  (3832, 385, '宜兰市', 3, '', NULL),
  (3833, 385, '头城镇', 3, '', NULL),
  (3834, 385, '礁溪乡', 3, '', NULL),
  (3835, 385, '壮围乡', 3, '', NULL),
  (3836, 385, '员山乡', 3, '', NULL),
  (3837, 385, '罗东镇', 3, '', NULL),
  (3838, 385, '三星乡', 3, '', NULL),
  (3839, 385, '大同乡', 3, '', NULL),
  (3840, 385, '五结乡', 3, '', NULL),
  (3841, 385, '冬山乡', 3, '', NULL),
  (3842, 385, '苏澳镇', 3, '', NULL),
  (3843, 385, '南澳乡', 3, '', NULL),
  (3844, 385, '钓鱼台', 3, '', NULL),
  (3845, 386, '竹北市', 3, '', NULL),
  (3846, 386, '湖口乡', 3, '', NULL),
  (3847, 386, '新丰乡', 3, '', NULL),
  (3848, 386, '新埔镇', 3, '', NULL),
  (3849, 386, '关西镇', 3, '', NULL),
  (3850, 386, '芎林乡', 3, '', NULL),
  (3851, 386, '宝山乡', 3, '', NULL),
  (3852, 386, '竹东镇', 3, '', NULL),
  (3853, 386, '五峰乡', 3, '', NULL),
  (3854, 386, '横山乡', 3, '', NULL),
  (3855, 386, '尖石乡', 3, '', NULL),
  (3856, 386, '北埔乡', 3, '', NULL),
  (3857, 386, '峨眉乡', 3, '', NULL),
  (3858, 387, '中坜市', 3, '', NULL),
  (3859, 387, '平镇市', 3, '', NULL),
  (3860, 387, '龙潭乡', 3, '', NULL),
  (3861, 387, '杨梅市', 3, '', NULL),
  (3862, 387, '新屋乡', 3, '', NULL),
  (3863, 387, '观音乡', 3, '', NULL),
  (3864, 387, '桃园市', 3, '', NULL),
  (3865, 387, '龟山乡', 3, '', NULL),
  (3866, 387, '八德市', 3, '', NULL),
  (3867, 387, '大溪镇', 3, '', NULL),
  (3868, 387, '复兴乡', 3, '', NULL),
  (3869, 387, '大园乡', 3, '', NULL),
  (3870, 387, '芦竹乡', 3, '', NULL),
  (3871, 388, '竹南镇', 3, '', NULL),
  (3872, 388, '头份镇', 3, '', NULL),
  (3873, 388, '三湾乡', 3, '', NULL),
  (3874, 388, '南庄乡', 3, '', NULL),
  (3875, 388, '狮潭乡', 3, '', NULL),
  (3876, 388, '后龙镇', 3, '', NULL),
  (3877, 388, '通霄镇', 3, '', NULL),
  (3878, 388, '苑里镇', 3, '', NULL),
  (3879, 388, '苗栗市', 3, '', NULL),
  (3880, 388, '造桥乡', 3, '', NULL),
  (3881, 388, '头屋乡', 3, '', NULL),
  (3882, 388, '公馆乡', 3, '', NULL),
  (3883, 388, '大湖乡', 3, '', NULL),
  (3884, 388, '泰安乡', 3, '', NULL),
  (3885, 388, '铜锣乡', 3, '', NULL),
  (3886, 388, '三义乡', 3, '', NULL),
  (3887, 388, '西湖乡', 3, '', NULL),
  (3888, 388, '卓兰镇', 3, '', NULL),
  (3889, 389, '彰化市', 3, '', NULL),
  (3890, 389, '芬园乡', 3, '', NULL),
  (3891, 389, '花坛乡', 3, '', NULL),
  (3892, 389, '秀水乡', 3, '', NULL),
  (3893, 389, '鹿港镇', 3, '', NULL),
  (3894, 389, '福兴乡', 3, '', NULL),
  (3895, 389, '线西乡', 3, '', NULL),
  (3896, 389, '和美镇', 3, '', NULL),
  (3897, 389, '伸港乡', 3, '', NULL),
  (3898, 389, '员林镇', 3, '', NULL),
  (3899, 389, '社头乡', 3, '', NULL),
  (3900, 389, '永靖乡', 3, '', NULL),
  (3901, 389, '埔心乡', 3, '', NULL),
  (3902, 389, '溪湖镇', 3, '', NULL),
  (3903, 389, '大村乡', 3, '', NULL),
  (3904, 389, '埔盐乡', 3, '', NULL),
  (3905, 389, '田中镇', 3, '', NULL),
  (3906, 389, '北斗镇', 3, '', NULL),
  (3907, 389, '田尾乡', 3, '', NULL),
  (3908, 389, '埤头乡', 3, '', NULL),
  (3909, 389, '溪州乡', 3, '', NULL),
  (3910, 389, '竹塘乡', 3, '', NULL),
  (3911, 389, '二林镇', 3, '', NULL),
  (3912, 389, '大城乡', 3, '', NULL),
  (3913, 389, '芳苑乡', 3, '', NULL),
  (3914, 389, '二水乡', 3, '', NULL),
  (3915, 390, '番路乡', 3, '', NULL),
  (3916, 390, '梅山乡', 3, '', NULL),
  (3917, 390, '竹崎乡', 3, '', NULL),
  (3918, 390, '阿里山乡', 3, '', NULL),
  (3919, 390, '中埔乡', 3, '', NULL),
  (3920, 390, '大埔乡', 3, '', NULL),
  (3921, 390, '水上乡', 3, '', NULL),
  (3922, 390, '鹿草乡', 3, '', NULL),
  (3923, 390, '太保市', 3, '', NULL),
  (3924, 390, '朴子市', 3, '', NULL),
  (3925, 390, '东石乡', 3, '', NULL),
  (3926, 390, '六脚乡', 3, '', NULL),
  (3927, 390, '新港乡', 3, '', NULL),
  (3928, 390, '民雄乡', 3, '', NULL),
  (3929, 390, '大林镇', 3, '', NULL),
  (3930, 390, '溪口乡', 3, '', NULL),
  (3931, 390, '义竹乡', 3, '', NULL),
  (3932, 390, '布袋镇', 3, '', NULL),
  (3933, 391, '斗南镇', 3, '', NULL),
  (3934, 391, '大埤乡', 3, '', NULL),
  (3935, 391, '虎尾镇', 3, '', NULL),
  (3936, 391, '土库镇', 3, '', NULL),
  (3937, 391, '褒忠乡', 3, '', NULL),
  (3938, 391, '东势乡', 3, '', NULL),
  (3939, 391, '台西乡', 3, '', NULL),
  (3940, 391, '仑背乡', 3, '', NULL),
  (3941, 391, '麦寮乡', 3, '', NULL),
  (3942, 391, '斗六市', 3, '', NULL),
  (3943, 391, '林内乡', 3, '', NULL),
  (3944, 391, '古坑乡', 3, '', NULL),
  (3945, 391, '莿桐乡', 3, '', NULL),
  (3946, 391, '西螺镇', 3, '', NULL),
  (3947, 391, '二仑乡', 3, '', NULL),
  (3948, 391, '北港镇', 3, '', NULL),
  (3949, 391, '水林乡', 3, '', NULL),
  (3950, 391, '口湖乡', 3, '', NULL),
  (3951, 391, '四湖乡', 3, '', NULL),
  (3952, 391, '元长乡', 3, '', NULL),
  (3953, 392, '屏东市', 3, '', NULL),
  (3954, 392, '三地门乡', 3, '', NULL),
  (3955, 392, '雾台乡', 3, '', NULL),
  (3956, 392, '玛家乡', 3, '', NULL),
  (3957, 392, '九如乡', 3, '', NULL),
  (3958, 392, '里港乡', 3, '', NULL),
  (3959, 392, '高树乡', 3, '', NULL),
  (3960, 392, '盐埔乡', 3, '', NULL),
  (3961, 392, '长治乡', 3, '', NULL),
  (3962, 392, '麟洛乡', 3, '', NULL),
  (3963, 392, '竹田乡', 3, '', NULL),
  (3964, 392, '内埔乡', 3, '', NULL),
  (3965, 392, '万丹乡', 3, '', NULL),
  (3966, 392, '潮州镇', 3, '', NULL),
  (3967, 392, '泰武乡', 3, '', NULL),
  (3968, 392, '来义乡', 3, '', NULL),
  (3969, 392, '万峦乡', 3, '', NULL),
  (3970, 392, '崁顶乡', 3, '', NULL),
  (3971, 392, '新埤乡', 3, '', NULL),
  (3972, 392, '南州乡', 3, '', NULL),
  (3973, 392, '林边乡', 3, '', NULL),
  (3974, 392, '东港镇', 3, '', NULL),
  (3975, 392, '琉球乡', 3, '', NULL),
  (3976, 392, '佳冬乡', 3, '', NULL),
  (3977, 392, '新园乡', 3, '', NULL),
  (3978, 392, '枋寮乡', 3, '', NULL),
  (3979, 392, '枋山乡', 3, '', NULL),
  (3980, 392, '春日乡', 3, '', NULL),
  (3981, 392, '狮子乡', 3, '', NULL),
  (3982, 392, '车城乡', 3, '', NULL),
  (3983, 392, '牡丹乡', 3, '', NULL),
  (3984, 392, '恒春镇', 3, '', NULL),
  (3985, 392, '满州乡', 3, '', NULL),
  (3986, 393, '台东市', 3, '', NULL),
  (3987, 393, '绿岛乡', 3, '', NULL),
  (3988, 393, '兰屿乡', 3, '', NULL),
  (3989, 393, '延平乡', 3, '', NULL),
  (3990, 393, '卑南乡', 3, '', NULL),
  (3991, 393, '鹿野乡', 3, '', NULL),
  (3992, 393, '关山镇', 3, '', NULL),
  (3993, 393, '海端乡', 3, '', NULL),
  (3994, 393, '池上乡', 3, '', NULL),
  (3995, 393, '东河乡', 3, '', NULL),
  (3996, 393, '成功镇', 3, '', NULL),
  (3997, 393, '长滨乡', 3, '', NULL),
  (3998, 393, '金峰乡', 3, '', NULL),
  (3999, 393, '大武乡', 3, '', NULL),
  (4000, 393, '达仁乡', 3, '', NULL),
  (4001, 393, '太麻里乡', 3, '', NULL),
  (4002, 394, '花莲市', 3, '', NULL),
  (4003, 394, '新城乡', 3, '', NULL),
  (4004, 394, '太鲁阁', 3, '', NULL),
  (4005, 394, '秀林乡', 3, '', NULL),
  (4006, 394, '吉安乡', 3, '', NULL),
  (4007, 394, '寿丰乡', 3, '', NULL),
  (4008, 394, '凤林镇', 3, '', NULL),
  (4009, 394, '光复乡', 3, '', NULL),
  (4010, 394, '丰滨乡', 3, '', NULL),
  (4011, 394, '瑞穗乡', 3, '', NULL),
  (4012, 394, '万荣乡', 3, '', NULL),
  (4013, 394, '玉里镇', 3, '', NULL),
  (4014, 394, '卓溪乡', 3, '', NULL),
  (4015, 394, '富里乡', 3, '', NULL),
  (4016, 395, '马公市', 3, '', NULL),
  (4017, 395, '西屿乡', 3, '', NULL),
  (4018, 395, '望安乡', 3, '', NULL),
  (4019, 395, '七美乡', 3, '', NULL),
  (4020, 395, '白沙乡', 3, '', NULL),
  (4021, 395, '湖西乡', 3, '', NULL),
  (4022, 396, '南竿乡', 3, '', NULL),
  (4023, 396, '北竿乡', 3, '', NULL),
  (4024, 396, '莒光乡', 3, '', NULL),
  (4025, 396, '东引乡', 3, '', NULL),
  (4026, 397, '中西区', 3, '', NULL),
  (4027, 397, '湾仔', 3, '', NULL),
  (4028, 397, '东区', 3, '', NULL),
  (4029, 397, '南区', 3, '', NULL),
  (4030, 398, '九龙城区', 3, '', NULL),
  (4031, 398, '油尖旺区', 3, '', NULL),
  (4032, 398, '深水埗区', 3, '', NULL),
  (4033, 398, '黄大仙区', 3, '', NULL),
  (4034, 398, '观塘区', 3, '', NULL),
  (4035, 399, '北区', 3, '', NULL),
  (4036, 399, '大埔区', 3, '', NULL),
  (4037, 399, '沙田区', 3, '', NULL),
  (4038, 399, '西贡区', 3, '', NULL),
  (4039, 399, '元朗区', 3, '', NULL),
  (4040, 399, '屯门区', 3, '', NULL),
  (4041, 399, '荃湾区', 3, '', NULL),
  (4042, 399, '葵青区', 3, '', NULL),
  (4043, 399, '离岛区', 3, '', NULL),
  (4044, 0, '东北', 2, '', NULL);
/*!40000 ALTER TABLE `crm_s_address` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;


# Dump of table crm_s_advert_channel
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_advert_channel`;

CREATE TABLE `crm_s_advert_channel` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) NOT NULL,
  `channel_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `sort` tinyint(4) NOT NULL DEFAULT '1' COMMENT '排序',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_advert_customer
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_advert_customer`;

CREATE TABLE `crm_s_advert_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `advert_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单编号',
  `customer_channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_channel_id` int(11) DEFAULT NULL,
  `consultation_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_tel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_wechat` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `form_content` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '咨询内容',
  `ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `from_address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源地址',
  `create_time` datetime DEFAULT NULL,
  `is_in` tinyint(4) DEFAULT NULL COMMENT '是否存在于客资',
  `c_id` int(11) DEFAULT NULL COMMENT '客资id',
  PRIMARY KEY (`id`),
  KEY `advert_code` (`advert_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='活动落地页提交客资表';



# Dump of table crm_s_advert_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_advert_list`;

CREATE TABLE `crm_s_advert_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `advert_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单编号',
  `name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单名称',
  `request_num` int(11) DEFAULT '0' COMMENT '提交客资数量',
  `repeat_num` int(11) DEFAULT '0' COMMENT '与客资系统重复的数量',
  `click_num` int(11) DEFAULT '0' COMMENT '点击数',
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template` text COLLATE utf8_unicode_ci COMMENT '组件',
  `style` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样式',
  `openfeedbackpwd` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '是否为必选项',
  `submitonce` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '只提交一次',
  `onlywechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '仅微信提交',
  `consumption_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `js_customer_service` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客服代码js',
  `btn_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '按钮名称',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `advert_code` (`advert_code`) USING BTREE,
  KEY `add_shop_code` (`add_shop_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='广告落地页列表';



# Dump of table crm_s_allocation_rule
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_allocation_rule`;

CREATE TABLE `crm_s_allocation_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `isopen` int(11) DEFAULT '1' COMMENT '0关闭，1启用',
  `allocationtype` int(11) DEFAULT '0' COMMENT '0平均，1条件',
  `allocationtype_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '条件分配值',
  `active_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'this_week' COMMENT '分配有效时间',
  `customer_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道来源字段',
  `customer_value` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源值',
  `group_id` int(11) DEFAULT NULL COMMENT '小组ID',
  `group_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_id` int(11) DEFAULT NULL COMMENT '主岗位id',
  `position_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_sort` smallint(5) unsigned DEFAULT '1' COMMENT '排序规则',
  `staff_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_value` text COLLATE utf8_unicode_ci,
  `belong_shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `brandclass_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资自动分配设定表';



# Dump of table crm_s_another_cost
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_another_cost`;

CREATE TABLE `crm_s_another_cost` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost` decimal(14,4) DEFAULT '0.0000',
  `cost_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(100) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='其他花费录入表';



# Dump of table crm_s_another_cost_detail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_another_cost_detail`;

CREATE TABLE `crm_s_another_cost_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost_avg` decimal(14,4) DEFAULT '0.0000',
  `cost_date` date DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(10) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='其他花费分摊表（每天）';



# Dump of table crm_s_another_setting
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_another_setting`;

CREATE TABLE `crm_s_another_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `exposure` int(11) DEFAULT '0',
  `click` int(11) DEFAULT '0',
  `show` int(11) DEFAULT '0',
  `fans` int(11) DEFAULT '0',
  `time` date DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `group_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='广告及其他信息录入（曝光量，点击量，粉丝等）';



# Dump of table crm_s_bggoalset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_bggoalset`;

CREATE TABLE `crm_s_bggoalset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `target` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jinri` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `biaozhun` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dachenglv` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yuehui` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `yuedachenglv` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `huanbi` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manzulv` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day` datetime DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_call_center
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_call_center`;

CREATE TABLE `crm_s_call_center` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `call_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `port` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='呼叫中心列表';



# Dump of table crm_s_call_man
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_call_man`;

CREATE TABLE `crm_s_call_man` (
  `user` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `pwd` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) NOT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) NOT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `is_busy` tinyint(4) DEFAULT NULL,
  `right_now_tel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当前正在拨通的电话，每次呼叫会更新，挂断会清空',
  KEY `staff_id` (`staff_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='呼叫中心 坐席表';



# Dump of table crm_s_call_prefix
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_call_prefix`;

CREATE TABLE `crm_s_call_prefix` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='呼叫前缀';



# Dump of table crm_s_changedate_reason
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_changedate_reason`;

CREATE TABLE `crm_s_changedate_reason` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '核销改期原因',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='上门拍改期原因设定';



# Dump of table crm_s_channel
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_channel`;

CREATE TABLE `crm_s_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_class_id` int(11) NOT NULL,
  `channel_class_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channel_info_id` int(11) NOT NULL,
  `channel_info_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channel_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `order_sort` int(3) DEFAULT '0',
  `share_shops` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享的shop_code',
  `channel_qrcode` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sign_id` int(11) DEFAULT NULL,
  `sign_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bind_sign_ids` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `channel_name` (`channel_name`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道设定表';



# Dump of table crm_s_channel_cost
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_channel_cost`;

CREATE TABLE `crm_s_channel_cost` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `chan_id` int(255) DEFAULT NULL COMMENT '渠道类型id ',
  `channelclass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道类型名',
  `channel_id` int(11) DEFAULT NULL,
  `channel_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道名',
  `area_id` int(11) DEFAULT NULL COMMENT '地域id',
  `area_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地域名',
  `region_id` int(11) DEFAULT NULL COMMENT '地区id',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地区名',
  `cost` decimal(10,4) DEFAULT NULL,
  `year` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '年份',
  `month` tinyint(2) DEFAULT NULL COMMENT '月份',
  `cost_avg` decimal(10,4) DEFAULT NULL COMMENT '花费平均值',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_end_day` tinyint(1) NOT NULL DEFAULT '2',
  `staff_id` int(11) DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `cost_date` date DEFAULT NULL COMMENT '花费设定时间',
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `eid` int(11) DEFAULT '0',
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道花费表';



# Dump of table crm_s_channel_cost_return
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_channel_cost_return`;

CREATE TABLE `crm_s_channel_cost_return` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `chan_id` int(11) DEFAULT NULL,
  `channelclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `area_id` int(11) DEFAULT NULL,
  `area_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_month` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_cost` decimal(10,4) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `brandclass_id` int(11) NOT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_pay` decimal(10,4) DEFAULT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_id` int(11) DEFAULT NULL,
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道返点表';



# Dump of table crm_s_channel_keywords
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_channel_keywords`;

CREATE TABLE `crm_s_channel_keywords` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `channel_id` int(11) DEFAULT NULL,
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道名称',
  `keyword` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关键字(不可重复)',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `qrcode` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valid_date` datetime DEFAULT NULL COMMENT '有效时间',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_delete` tinyint(1) DEFAULT '2' COMMENT '是否删除：1：删除；2：未删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道关键字表';



# Dump of table crm_s_club
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_club`;

CREATE TABLE `crm_s_club` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '会所表',
  `club_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(10) DEFAULT NULL,
  `brandclass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_custom_column
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_custom_column`;

CREATE TABLE `crm_s_custom_column` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `custom_model` text COLLATE utf8_unicode_ci,
  `custom_name` text COLLATE utf8_unicode_ci,
  `custom_column` text COLLATE utf8_unicode_ci,
  `staff_id` int(11) NOT NULL DEFAULT '0',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_type` tinyint(2) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='自定义列表';



# Dump of table crm_s_customer_interface
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_customer_interface`;

CREATE TABLE `crm_s_customer_interface` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_config` text COLLATE utf8_unicode_ci NOT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT '0',
  `create_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `is_delete` tinyint(1) NOT NULL DEFAULT '2',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='第三方录入（金数据）接口，设定表';



# Dump of table crm_s_customer_interface_detail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_customer_interface_detail`;

CREATE TABLE `crm_s_customer_interface_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT '0',
  `data` text COLLATE utf8_unicode_ci,
  `result_code` int(3) DEFAULT '0',
  `error_reason` text COLLATE utf8_unicode_ci,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  `update_staff_id` int(11) DEFAULT '0',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='第三方录入接口，录入参数';



# Dump of table crm_s_customer_tab
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_customer_tab`;

CREATE TABLE `crm_s_customer_tab` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sql` text COLLATE utf8_unicode_ci,
  `order_sort` int(4) DEFAULT '0',
  `is_use` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应该是自定义客资tab，好像没用上';



# Dump of table crm_s_data_dp
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_data_dp`;

CREATE TABLE `crm_s_data_dp` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receive` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `into` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `money` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='计划是给大屏用的，但是没用上';



# Dump of table crm_s_file_reason
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_file_reason`;

CREATE TABLE `crm_s_file_reason` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪失败原因',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='不在追踪原因设定';



# Dump of table crm_s_goal
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_goal`;

CREATE TABLE `crm_s_goal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goal_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `key` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `method` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `goal_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `year` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `month` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `day` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_goal_name
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_goal_name`;

CREATE TABLE `crm_s_goal_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goal_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_home_show
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_home_show`;

CREATE TABLE `crm_s_home_show` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_id` int(11) NOT NULL,
  `position_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `position_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `time` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资简析设定表';



# Dump of table crm_s_hx_cancel_reason
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_hx_cancel_reason`;

CREATE TABLE `crm_s_hx_cancel_reason` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '核销改期原因',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='上门拍取消原因';



# Dump of table crm_s_kf_staff_system
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_kf_staff_system`;

CREATE TABLE `crm_s_kf_staff_system` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `kf_user` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '客服账号',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '人员名称',
  `nick_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '昵称',
  `staff_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '人员编号',
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '头像地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客服人员管理表';



# Dump of table crm_s_kpi_staffgoal
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_kpi_staffgoal`;

CREATE TABLE `crm_s_kpi_staffgoal` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_id` int(11) DEFAULT NULL,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位',
  `year` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `month` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `kpi_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标id',
  `kpi_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标名',
  `kpi_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '值',
  `kpi_unit` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单位',
  `create_time` datetime DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定的店面识别码',
  `order_sort` int(5) DEFAULT '0',
  `flag` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT '0',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT '0',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `day_number` int(11) DEFAULT NULL,
  `avg_value` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `start` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `group_id` int(11) DEFAULT '0',
  `group_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(5) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='目标设定表';



# Dump of table crm_s_label
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_label`;

CREATE TABLE `crm_s_label` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_delete` tinyint(1) DEFAULT '2' COMMENT '状态：1：删除；2:未删除',
  `label_cat_id` int(11) DEFAULT NULL,
  `label_cat_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `label_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_label_cat
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_label_cat`;

CREATE TABLE `crm_s_label_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) DEFAULT '2' COMMENT '状态：1：删除；2:未删除',
  `cat_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分类名称',
  `brandclass_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table crm_s_markset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_markset`;

CREATE TABLE `crm_s_markset` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `mark_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记名',
  `mark_color` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='追踪标记设定表';



# Dump of table crm_s_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_menu`;

CREATE TABLE `crm_s_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
  `fid` int(11) DEFAULT NULL,
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单url',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='功能菜单表';

LOCK TABLES `crm_s_menu` WRITE;
/*!40000 ALTER TABLE `crm_s_menu` DISABLE KEYS */;

INSERT INTO `crm_s_menu` (`id`, `menu_name`, `fid`, `menu_code`, `menu_url`, `menu_icon`, `status`, `sort`)
VALUES
	(1,'我的工作',0,'menu1512736714','/crm/Customer/index','fa-home',1,1),
	(2,'客户管理',0,'menu1512735953','/crm/Customer/customerList','fa-user',1,2),
	(5,'统计分析',0,'menu1512736477','/crm/setting/statistics_list','fa-bar-chart',1,4),
	(6,'系统设置',0,'menu1512650831','#','fa-cog',1,7),
	(7,'渠道花费',8,'menu1512650793','/crm/Setting/channelFee','',1,1),
	(8,'花费录入',0,'menu1529995000','#','fa-money',1,6),
	(9,'系统日志',0,'menu1537322224','#','fa-file-text',1,5),
	(10,'客资分配设定',6,'menu1512009199','/crm/Setting/fpSet',NULL,1,2),
	(12,'客资提醒设定',6,'menu1512028590','/crm/Setting/remindSet',NULL,1,4),
	(13,'追踪阶段设定',6,'menu1512028684','/crm/Setting/workFlow','',1,5),
	(14,'业务目标设定',6,'menu1512028704','/crm/Setting/goalSet',NULL,1,6),
	(15,'五维图设定',6,'menu1512028736','/crm/Setting/biao',NULL,1,7),
	(16,'不在追踪原因设定',6,'menu1512029560','/crm/Setting/fileReason','',1,8),
	(17,'短信模板设定',6,'menu1512029583','/crm/Setting/modalSet',NULL,1,9),
	(18,'微信模板设定',6,'menu1512029604','/crm/Setting/pushModal','',0,10),
	(19,'电访备注设定',6,'menu1512029635','/crm/Setting/telphoneRemark','',99,11),
	(21,'功能菜单设定',6,'menu1512029909','/crm/Setting/menuSet',NULL,1,13),
	(22,'权限设定',6,'menu1512029925','/crm/Setting/permission',NULL,1,14),
	(32,'查看所有客资',34,'menu1512637269','allCustomer','',1,1),
	(33,'新增客资',61,'menu1512970660','/crm/Customer/addCustomer','',1,1),
	(34,'客资查询',2,'menu1512970347','','',0,1),
	(35,'查看追踪人的客资',34,'menu1512650502','','',1,3),
	(36,'删除客资',61,'menu1512970570','/crm/Customer/delCustomer','',1,2),
	(37,'导入客资',61,'menu1512970672','/crm/Customer/import','',1,4),
	(38,'导出客资',61,'menu1512970678','/crm/Customer/export','',1,5),
	(39,'刷新列表',61,'menu1512970682','','',1,6),
	(40,'客资分配',61,'menu1512970623','/crm/Customer/customerAllotOne','',1,8),
	(41,'选项卡-所有客资',34,'menu1512698495','','',1,4),
	(42,'选项卡-待追踪',34,'menu1512698552','','',1,5),
	(43,'选项卡-待分配',34,'menu1512698635','','',1,6),
	(44,'选项卡-追踪中',34,'menu1512698693','','',1,7),
	(45,'选项卡-已订单',34,'menu1512698717','','',1,8),
	(46,'选项卡-进店未成交',34,'menu1512698836','','',1,9),
	(60,'追踪标记设定',6,'menu1512898027','/crm/Setting/markSet','',1,50),
	(61,'客资维护',2,'menu1512970388','','',0,2),
	(62,'修改客资',61,'menu1512970667','/crm/Customer/customerInfo','',1,3),
	(63,'客资追踪',2,'menu1512971674','','',0,3),
	(64,'客资电话追踪',63,'menu1512971662','/crm/Customer/','',1,1),
	(65,'客资标记',63,'menu1512971681','','',0,2),
	(66,'查看追踪记录',63,'menu1512971583','/crm/Customer/trackLog','',1,3),
	(67,'发送短信',63,'menu1512971646','/crm/Customer/send_message','',1,4),
	(68,'查看个人工作',70,'menu1512987407','','',1,1),
	(69,'查看小组成员工作',70,'menu1512987394','','',1,2),
	(70,'界面菜单',1,'menu1512993265','','fa-home',0,0),
	(71,'查看手机号',34,'menu1512998373','3','',1,2),
	(72,'客资标记设定',6,'menu1513213883','/crm/Setting/trackingKmarker','',1,20),
	(73,'花费返点',8,'menu1513343947','/crm/Setting/qdReturn','',99,52),
	(74,'岗位授权',22,'menu1513394914','/crm/Setting/authorise','',1,1),
	(75,'选项卡-不再追踪',34,'menu1513395549','','',1,10),
	(76,'修改qq/微信/微博',61,'menu1513409629','','',1,9),
	(77,'修改客资渠道',61,'menu1513409657','','',1,10),
	(78,'修改获取方式',61,'menu1513409684','','',1,11),
	(79,'修改消费类型',61,'menu1513409704','','',1,12),
	(80,'修改客户来源',61,'menu1513409882','','',1,13),
	(81,'修改客户意向',61,'menu1513410030','','',1,14),
	(82,'修改客资分区',61,'menu1513410084','','',1,15),
	(83,'修改客资地域',61,'menu1513410164','','',1,16),
	(84,'选项卡-待筛客',34,'menu1513592505','','',99,11),
	(85,'获取成本',8,'menu1513855331','/crm/Setting/obtainCost','',99,60),
	(86,'选项卡-已筛客',34,'menu1513863618','','',99,12),
	(87,'呼叫前缀设定',6,'menu1514183289','/crm/Setting/callPrefix','',1,30),
	(93,'首页客资简析',6,'menu1514430518','/crm/Setting/homeShowSet','',1,46),
	(97,'转客资',61,'menu1515837753','','',99,0),
	(98,'查看个人权限',22,'menu1515927010','','',0,0),
	(103,'渠道名称设定',6,'menu1516949559','/crm/Setting/channel','',1,50),
	(104,'失败再分配',61,'menu1517042801','/crm/Customer/customerReAllot',NULL,99,0),
	(106,'客资标记',2,'menu1517129233','',NULL,0,30),
	(107,'标记有效',106,'menu1517129299','/crm/signValid','',1,30),
	(108,'标记无效',106,'menu1517129331','/crm/signUnvalid','',1,30),
	(109,'当日接收',34,'menu1517217988','','',1,2),
	(110,'三日内追踪',34,'menu1517218007','','',1,2),
	(111,'当日预进店',34,'menu1517218044','','',1,2),
	(112,'客资驳回',2,'menu1517278817','/crm/customerValidUpdate','',0,20),
	(113,'客资反驳回',2,'menu1517278844','/crm/customerUnValidUpdate','',0,20),
	(115,'省市区设定',6,'menu1517560908','/crm/Setting/province',NULL,1,90),
	(117,'选项卡-有效客资',34,'menu1519611713','',NULL,99,13),
	(118,'选项卡-无效客资',34,'menu1519611738','',NULL,99,14),
	(119,'选项卡-待定客资',34,'menu1519611762','',NULL,99,15),
	(120,'选项卡-驳回客资',34,'menu1519611781','',NULL,99,16),
	(121,'右键-客资标记',2,'menu1519631971','/crm/Customer/customerSign',NULL,0,20),
	(122,'右键-追踪标记',2,'menu1519632099','/crm/Customer/customerSign',NULL,0,21),
	(123,'右键-不再追踪',2,'menu1519633436','/crm/Customer/notTraking',NULL,0,30),
	(124,'右键-预约进店',2,'menu1519633870','/crm/Customer/customerYJD',NULL,0,25),
	(125,'右键-网付订单',2,'menu1519633923','/crm/Customer/zhuanOrder','',0,26),
	(126,'右键-编辑订单',2,'menu1519633959','/crm/Customer/editOrder',NULL,0,27),
	(127,'右键-筛客',2,'menu1519635403','/crm/Customer/skCustomer',NULL,99,20),
	(135,'右键-撤销',2,'menu1520675106','/crm/Customer/customerRevoke',NULL,0,28),
	(136,'返点规则',8,'menu1521280345','/crm/Setting/shop_return_setting',NULL,99,100),
	(138,'查询服务',0,'menu1521267312','/crm/Customer/moreSearch','fa-search',1,3),
	(170,'批量客资查询',138,'menu1521439092','/crm/Customer/moreSearch',NULL,1,0),
	(171,'门市订单查询',138,'menu1521352773','/crm/Customer/searchorders',NULL,1,2),
	(173,'客资爆破',6,'menu1521091523','/crm/Setting/customerSwap','',99,101),
	(174,'爆破设定',173,'menu1521093152','/crm/Setting/customerSwapSet',NULL,99,102),
	(175,'添加客资',173,'menu1521093203','/crm/Setting/addCustomerSwap',NULL,99,103),
	(176,'驳回原因设定',6,'menu1521784361','/crm/Setting/RejectReason',NULL,1,21),
	(177,'系统配置',6,'menu1522207375','/crm/Setting/erpSet','',1,101),
	(178,'订单来源设定',6,'menu1522225258','/crm/Setting/orderSource','',99,102),
	(180,'右键-介绍人修改',2,'menu1522653972','/crm/Customer/editIntroducer',NULL,0,29),
	(186,'第三方录入接口配置',6,'menu1523588039','/crm/Setting/customerInterface',NULL,1,103),
	(187,'本店报表设置',5,'menu1523775076','','',0,1),
	(188,'服务监控',70,'menu1523865883','/server/index',NULL,1,1),
	(189,'其它花费',8,'menu1524225422','/crm/Setting/anotherCost','',99,105),
	(190,'今日需追踪',34,'menu1524450329','','',1,2),
	(191,'客资池',61,'menu1524551642','',NULL,99,0),
	(195,'查看小组客资',34,'menu1529653231','','',0,1),
	(196,'回收站',61,'menu1529995330','/crm/Customer/customerBack',NULL,0,9),
	(197,'客资审核',61,'menu1531379209','/crm/Customer/customerExamine','',1,10),
	(198,'查看部门客资',34,'menu1531471639','','',0,1),
	(199,'客资转移',61,'menu1532333135','',NULL,0,11),
	(200,'客资姓名修改',61,'menu1533803338','',NULL,0,11),
	(203,'删除小组',74,'menu1535542292','',NULL,99,15),
	(204,'批量有效',61,'menu1529401205','/crm/Customer/customerMoreValid',NULL,0,7),
	(205,'批量无效',61,'menu1529401206','/crm/Customer/customerMoreUnValid',NULL,0,8),
	(206,'呼叫中心设置',6,'menu1537348792','/crm/Setting/callCenterSet','',1,103),
	(207,'坐席监控',70,'menu1537587731','',NULL,0,3),
	(208,'客资分配日志',9,'menu1537322380','/crm/Logs/fplogs',NULL,1,1),
	(209,'网销签到信息',9,'menu1538119117','',NULL,0,1),
	(210,'手机修改日志',9,'menu1538103712','/crm/Logs/telLogs',NULL,99,1),
	(211,'客资操作日志',9,'menu1538103743','/crm/Logs/customerLogs',NULL,1,1),
	(212,'设定日志',9,'menu1538103771','/crm/Logs/settingLogs',NULL,1,1),
	(215,'客资提醒查询',9,'menu1538103331','/crm/Logs/remindLogs',NULL,1,1),
	(216,'关键字修改',61,'menu1539573890','',NULL,0,20),
	(217,'提报表单设定',6,'menu1540363547','/crm/Setting/customerForms',NULL,1,30),
	(218,'选项卡-过期客资',34,'menu1540550148','',NULL,99,17),
	(457,'客资再分配',61,'menu1541663886','',NULL,1,8),
	(458,'到店拍排程设定',6,'menu1542112060','/crm/Setting/pcSet','',99,35),
	(1500,'人员追踪数据',138,'menu1573033477','/crm/Customer/staffTrackLog',NULL,1,2),
	(1501,'查询本店通话记录',1500,'menu1573096502','',NULL,0,1),
	(1502,'查询本人通话记录',1500,'menu1573096503','',NULL,0,2),
	(2000,'店务系统',0,'menu1542196943','','fa-home',99,7),
	(2001,'排控',2000,'menu1542196979','/erp/Erp/childArrange','',99,1),
	(2002,'体验拍',2000,'menu1542197015','/erp/Erp/mark','',99,2),
	(2004,'订单转移',61,'menu1512977628','/crm/Customer/customerMerge','fa-home',99,0),
	(2014,'修改手机号',61,'menu1555556591','','',1,90),
	(2020,'离职交接',61,'menu1532333136','','',0,12),
	(2021,'广告信息录入',8,'menu1544608169','/crm/Setting/anotherSetting',NULL,1,110),
	(2022,'右键-标记有效',2,'menu1546854995','/crm/signValid','',0,30),
	(2023,'查看一年内客资',34,'menu1546854888','','',0,3),
	(2024,'奖金标记',61,'menu1546854777','','',99,22),
	(2025,'预约客资查询',138,'menu1552037035','/crm/Customer/yjdSearch','',1,0),
	(2026,'成交奖金',61,'menu1546854778','','',99,22),
	(2027,'修改加好友时间',61,'menu1513409630','','',1,9),
	(2028,'员工绑定渠道',6,'menu1556360310','/crm/Setting/staffTrenchMate_List','',1,0),
	(2029,'核销改期原因设定',6,'menu1556525898','/crm/Setting/changedateReason','',99,120),
	(2030,'核销取消原因设定',6,'menu1556525858','/crm/Setting/cancelReason','',99,121),
	(2031,'上门拍排程设定',6,'menu1557049289','/crm/Setting/smpcset','',99,100),
	(2032,'到店拍',138,'menu1557198900','/erp/Erp/mark','',99,5),
	(2033,'上门拍',138,'menu1557199264','/erp/Erp/toHome','',99,7),
	(2034,'查看本店客资',34,'menu1559716359','','',0,1),
	(2035,'查看事业部客资',34,'menu1559716412','','',0,1),
	(2036,'坐席配置',70,'menu1561718791','','',0,3),
	(2037,'微信会话',0,'menu1563353339','','fa-user',1,7),
	(2038,'客服人员管理',2037,'menu1563353465','/weixin/Weixin/kfStaffSystem','',1,1),
	(2039,'公众号配置',2037,'menu1563353533','/weixin/Weixin/wxSetting','',1,2),
	(2040,'快捷回复设定',2037,'menu1563767097','/weixin/weixin/replySetting','',1,3),
	(2041,'追踪时间设置',6,'menu1563867868','/crm/Setting/getTabTimearea','',1,10),
	(2042,'微信会话列表',2037,'menu1564452085','/weixin/weixin/wxTalkList','',1,0),
	(2043,'孕妈追踪',34,'menu1564454831','','',0,20),
	(2044,'出生追踪',34,'menu1564454848','','',0,21),
	(2045,'满月追踪',34,'menu1564454860','','',0,22),
	(2046,'百天追踪',34,'menu1564454873','','',0,23),
	(2047,'半岁追踪',34,'menu1564454884','','',0,24),
	(2048,'周岁追踪',34,'menu1564454900','','',0,25),
	(2049,'查看个人会话',2037,'menu1564539988','','',0,5),
	(2050,'查看所有会话',2037,'menu1564540006','','',0,6),
	(2051,'分配客服',2037,'menu1565071368','','',0,7),
	(2052,'会话配置',2037,'menu1565072157','/weixin/Weixin/talkSetting','',1,4),
	(2053,'查看统计报表',5,'menu1568895548','','',0,0),
	(2054,'落地页设置',0,'menu1567476313','','fa-reorder',1,9),
	(2055,'落地页列表',2054,'menu1567737010','/advert/Advert/index','',1,1),
	(2056,'落地页渠道',2054,'menu1567737059','/advert/Advert/advertChannel','',1,2),
	(2057,'批量待定',61,'menu1571722592','/crm/Customer/customerMoreDd',NULL,1,0),
	(2058,'上门类型设定',2060,'menu1574042737','/crm/Visit/smTypeSet',NULL,1,2),
	(2059,'查询本店上门拍',2033,'menu1576489359','/crm/Visit/toHome',NULL,1,2),
	(2060,'查询本人上门拍',2033,'menu1576489412','/crm/Visit/toHome',NULL,1,2),
	(2061,'分配上门人员',2033,'menu1577329871','/crm/Visit/cameramanFP',NULL,1,2),
	(2062,'上门分组',2033,'menu1577329895','/crm/Visit/setSmGroup',NULL,1,2),
	(2063,'上门开单',2033,'menu1577329926','/crm/Visit/order',NULL,1,2),
	(2064,'上门核销',2033,'menu1577329949','/crm/Visit/markHX',NULL,1,2),
	(2065,'上门删除',2033,'menu1577329973','',NULL,1,2),
	(2066,'上门改期',2033,'menu1577329992','/crm/Visit/changeVisit',NULL,1,2),
	(2067,'上门反馈',2033,'menu1577330039','',NULL,1,2),
	(2074,'会所名称设定',900,'menu1591943564','/crm/Setting/clubNameset',NULL,1,0);

/*!40000 ALTER TABLE `crm_s_menu` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_s_message_templateinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_message_templateinfo`;

CREATE TABLE `crm_s_message_templateinfo` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `mtemplate_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板名称',
  `mtemplate_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板内容',
  `outsex` int(11) DEFAULT NULL,
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否启用',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信模板设定';



# Dump of table crm_s_order_source
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_order_source`;

CREATE TABLE `crm_s_order_source` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `source` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) NOT NULL DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_delete` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='订单来源表（天猫，京东等等）';



# Dump of table crm_s_pc_type_set
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_pc_type_set`;

CREATE TABLE `crm_s_pc_type_set` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sm_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上门类型',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人',
  `status` tinyint(1) DEFAULT '2' COMMENT '是否删除：1：删除；2：未删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `crm_s_pc_type_set` WRITE;
/*!40000 ALTER TABLE `crm_s_pc_type_set` DISABLE KEYS */;

INSERT INTO `crm_s_pc_type_set` (`id`, `sm_type`, `create_time`, `staff_id`, `staff_name`, `status`)
VALUES
	(1,'拍照','2020-11-17 15:30:56',1,'管理员',2),
	(2,'理发','2020-11-17 15:31:01',1,'管理员',2),
	(3,'视频','2020-11-17 19:30:36',52,'马克彩虹',2);

/*!40000 ALTER TABLE `crm_s_pc_type_set` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_s_position_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_position_menu`;

CREATE TABLE `crm_s_position_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `menu_code` text COLLATE utf8_unicode_ci,
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单url',
  `status` tinyint(2) DEFAULT NULL COMMENT '状态，1是显示，2不显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='岗位权限表';



# Dump of table crm_s_reject_reason
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_reject_reason`;

CREATE TABLE `crm_s_reject_reason` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='驳回原因设定';



# Dump of table crm_s_reminditemset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_reminditemset`;

CREATE TABLE `crm_s_reminditemset` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT 'id',
  `remind_type` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isopen` int(11) DEFAULT NULL,
  `advancehour` int(11) DEFAULT NULL,
  `brandclass` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `send_method` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `send_receive` text COLLATE utf8_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资提醒设定表';



# Dump of table crm_s_reply
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_reply`;

CREATE TABLE `crm_s_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_delete` tinyint(1) DEFAULT '2' COMMENT '状态：1：删除；2:未删除',
  `reply_cat_id` int(11) DEFAULT NULL,
  `reply_cat_name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reply_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信回复内容设定表';



# Dump of table crm_s_reply_cat
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_reply_cat`;

CREATE TABLE `crm_s_reply_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) DEFAULT '2' COMMENT '状态：1：删除；2:未删除',
  `reply_cat_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分类名称',
  `brandclass_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信回复分类设定表';



# Dump of table crm_s_report_detail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_report_detail`;

CREATE TABLE `crm_s_report_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL DEFAULT '0',
  `brandclass_id` int(11) DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `group_id` int(11) DEFAULT NULL,
  `report_auth` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `report_auth_detail` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='报表设定表';



# Dump of table crm_s_report_form
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_report_form`;

CREATE TABLE `crm_s_report_form` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `report_class_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `report_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `report_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `level` int(11) DEFAULT '0',
  `report_type` tinyint(1) DEFAULT '1',
  `code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `add_time` datetime DEFAULT NULL,
  `described` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `thumb` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT '0',
  `report_type_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='报表列表';

LOCK TABLES `crm_s_report_form` WRITE;
/*!40000 ALTER TABLE `crm_s_report_form` DISABLE KEYS */;

INSERT INTO `crm_s_report_form` (`id`, `report_class_name`, `report_name`, `report_url`, `level`, `report_type`, `code`, `status`, `add_time`, `described`, `thumb`, `sort`, `report_type_name`)
VALUES
	(15,'Customer_pc','上门信息统计','/crm/report/index/id/Customer_pc.html',1,1,'code1568197500',2,'2019-11-16 17:19:36',NULL,NULL,0,'爱婴'),
	(16,'Customer_channel_pc','渠道上门信息统计','/crm/report/index/id/Customer_channel_pc.html',1,1,'code1568187500',2,'2019-11-21 11:42:58',NULL,NULL,1,'爱婴'),
	(19,'Customer_sales_data','网销追踪统计','/crm/report/index/id/Customer_sales_data.html',1,1,'code1568182674',2,'2019-11-26 15:56:14',NULL,NULL,0,'网销'),
	(20,'Customer_sales_hour_data','网销追踪时段统计','/crm/report/index/id/Customer_sales_hour_data.html',1,3,'code1568182474',2,'2019-11-26 16:49:38',NULL,NULL,0,'网销'),
	(28,'cd_channel_data','渠道数据统计','/crm/report/index/id/cd_channel_data.html',1,1,'code1591154774',2,'2020-06-03 11:26:23',NULL,NULL,0,'电商'),
	(29,'cd_channel_days_cus_data','渠道每日客资统计','/crm/report/index/id/cd_channel_days_cus_data.html',1,1,'code1591326889',2,'2020-06-05 11:14:57',NULL,NULL,0,'电商'),
	(34,'yp_cameraman_data','医拍摄影师统计','/crm/report/index/id/yp_cameraman_data.html',1,1,'code1591842392',2,'2020-06-11 10:22:42',NULL,NULL,0,'电商'),
	(35,'yp_assistant_data','医拍助理统计','/crm/report/index/id/yp_assistant_data.html',1,1,'code1591871877',2,'2020-06-24 10:22:42',NULL,NULL,0,'电商'),
	(36,'hs_customer_data','会所客资统计','/crm/report/index/id/hs_customer_data.html',1,1,'code1592535420',2,'2020-06-12 16:29:35',NULL,NULL,0,'电商'),
	(40,'Cd_month_customer','月度客资统计报表','/crm/report/index/id/Cd_month_customer.html',0,1,'code1592808723',2,'2020-06-22 11:11:27',NULL,NULL,0,'电商'),
	(41,'Cd_year_customer','年度客资统计报表','/crm/report/index/id/Cd_year_customer.html',0,1,'code1592896053',2,'2020-06-22 11:11:27',NULL,NULL,0,'电商'),
	(42,'Cd_group_staff_customer','推广客资统计','/crm/report/index/id/Cd_group_staff_customer.html',0,1,'code1592899519',2,'2020-06-23 16:09:54',NULL,NULL,0,'电商'),
	(43,'Cd_customer_advertising','客资广告信息汇总','/crm/report/index/id/Cd_customer_advertising.html',0,1,'code1592908984',2,'2020-06-22 11:11:27',NULL,NULL,0,'电商'),
	(44,'Cd_status_customer','状态客资统计','/crm/report/index/id/Cd_status_customer.html',0,1,'code1592981289',2,'2020-06-24 12:48:14',NULL,NULL,0,'电商'),
	(45,'Cd_customer_access','客资获取方式信息汇总','/crm/report/index/id/Cd_customer_access.html',0,1,'code1592992364',2,'2020-06-24 12:48:14',NULL,NULL,0,'电商'),
	(46,'Cd_keyword_data','关键词数据分析','/crm/report/index/id/Cd_keyword_data.html',0,1,'code1593050977',2,'2020-06-24 19:00:39',NULL,NULL,0,'电商'),
	(47,'Cd_unvalid_cause','无效客资原因','/crm/report/index/id/Cd_unvalid_cause.html',0,1,'code1593055246',2,'2020-06-24 19:00:39',NULL,NULL,0,'电商'),
	(48,'Cd_province_customer','省域客资分析','/crm/report/index/id/Cd_province_customer.html',0,1,'code1593057633',2,'2020-06-25 12:00:39',NULL,NULL,0,'电商'),
	(49,'Cd_city_customer','市客资分析','/crm/report/index/id/Cd_city_customer.html',0,1,'code1593058089',2,'2020-06-25 12:08:20',NULL,NULL,0,'电商'),
	(50,'Cd_wx_order_info','网销成交明细表','/crm/report/index/id/Cd_wx_order_info.html',0,3,'code1593322620',2,'2020-06-28 10:37:10',NULL,NULL,0,'网销'),
	(51,'Cd_wx_staff_yeji','网销销售个人数据业绩表','/crm/report/index/id/Cd_wx_staff_yeji.html',0,3,'code1593339260',2,'2020-06-28 16:14:27',NULL,NULL,0,'网销');

/*!40000 ALTER TABLE `crm_s_report_form` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table crm_s_sales_routines
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_sales_routines`;

CREATE TABLE `crm_s_sales_routines` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `step_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `step_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `step_stage` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='沟通流程设定表';



# Dump of table crm_s_session
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_session`;

CREATE TABLE `crm_s_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌;3:离线',
  `login_time` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';



# Dump of table crm_s_shop_address
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_shop_address`;

CREATE TABLE `crm_s_shop_address` (
  `id` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='店与地址绑定';



# Dump of table crm_s_shop_return_rule
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_shop_return_rule`;

CREATE TABLE `crm_s_shop_return_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `return_rule` tinyint(1) DEFAULT '1',
  `return_value` int(10) DEFAULT '0',
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='返点规则表';



# Dump of table crm_s_staff_ability
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_staff_ability`;

CREATE TABLE `crm_s_staff_ability` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `abilityItem` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '能力',
  `max` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '能力指标最大值',
  `times` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='五维图设定表';



# Dump of table crm_s_swapset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_swapset`;

CREATE TABLE `crm_s_swapset` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `swap_number` char(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `swap_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `swap_staff_ids` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `swap_staff_names` text COLLATE utf8_unicode_ci NOT NULL,
  `customer_start` date DEFAULT NULL,
  `customer_end` date DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(2) DEFAULT '1',
  `is_del` tinyint(2) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资爆破设定表';



# Dump of table crm_s_telremark
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_telremark`;

CREATE TABLE `crm_s_telremark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telremark` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '备注信息',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_delete` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='电访备注设定表';



# Dump of table crm_s_third
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_third`;

CREATE TABLE `crm_s_third` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `columns` text COLLATE utf8_unicode_ci,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_staff_id` int(11) DEFAULT NULL,
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_cource_id` int(11) DEFAULT NULL,
  `customer_cource` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8_unicode_ci,
  `token` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='第三方表单提报客资配置';



# Dump of table crm_s_third_detail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_third_detail`;

CREATE TABLE `crm_s_third_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT '0',
  `data` text COLLATE utf8_unicode_ci,
  `result_code` int(3) DEFAULT '0',
  `error_reason` text COLLATE utf8_unicode_ci,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  `update_staff_id` int(11) DEFAULT '0',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='第三方表单提报客资明细';



# Dump of table crm_s_tracksign
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_tracksign`;

CREATE TABLE `crm_s_tracksign` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tracksign` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_delete` tinyint(1) DEFAULT '1',
  `sign_color` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资标记设定表';



# Dump of table crm_s_wx_kf_staff
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_wx_kf_staff`;

CREATE TABLE `crm_s_wx_kf_staff` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '人员名称',
  `staff_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '人员编号',
  `kf_account` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客服账号',
  `kf_nick` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '昵称',
  `kf_wx` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '头像地址',
  `belong_wx_id` int(11) DEFAULT NULL,
  `belong_wx_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客服人员管理表';



# Dump of table crm_s_wx_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_wx_menu`;

CREATE TABLE `crm_s_wx_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
  `fid` int(11) DEFAULT NULL,
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单url',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当菜单类型是小程序时要用到',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态:99:删除',
  `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
  `level` tinyint(1) unsigned DEFAULT NULL COMMENT '菜单等级',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'view' COMMENT '菜单类型：view：网页；miniprogram：小程序；',
  `keyword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消息回复关键字',
  `pagepath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '小程序用，页面路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信自定义菜单表';



# Dump of table crm_s_wx_relation
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_wx_relation`;

CREATE TABLE `crm_s_wx_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subscribe` tinyint(4) DEFAULT NULL COMMENT '用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。',
  `openid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nickname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户的昵称',
  `sex` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '1时是男性，2时是女性，0时是未知',
  `language` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户的语言，简体中文为zh_CN',
  `headimgurl` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像）',
  `subscribe_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间',
  `unionid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。',
  `remark` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '公众号运营者对粉丝的备注',
  `kf_id` int(11) DEFAULT NULL COMMENT '对应的客服id',
  `cid` int(11) DEFAULT NULL COMMENT '对应的客资id',
  `wx_sys_id` int(11) DEFAULT NULL COMMENT '对应的微信公众id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `openid` (`openid`) USING BTREE,
  KEY `kf_id` (`kf_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客服与客户之间的对应表';



# Dump of table crm_s_wx_system
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_wx_system`;

CREATE TABLE `crm_s_wx_system` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '公众号名称',
  `appid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'appid',
  `secret` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '开发者密码',
  `wx_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定微信号',
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'token',
  `staff_id` int(11) DEFAULT NULL COMMENT '操作人id',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信公众号配置';



# Dump of table crm_s_wx_talk
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crm_s_wx_talk`;

CREATE TABLE `crm_s_wx_talk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opercode` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作码，2002（客服发送信息），2003（客服接收消息）',
  `text` text COLLATE utf8_unicode_ci,
  `time` datetime DEFAULT NULL,
  `kf_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`) USING BTREE,
  KEY `kf_id` (`kf_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信会话记录表';



# Dump of table customertb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `customertb`;

CREATE TABLE `customertb` (
  `id` int(11) NOT NULL,
  `eid` int(11) DEFAULT NULL,
  `CustomerID` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `birthday` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `birthdayTime` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `BedNum` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `gender` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `montherName` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `monthermobile` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fatherName` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fathermobile` varchar(24) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fQQ` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mQQ` varchar(15) COLLATE utf8_unicode_ci DEFAULT NULL,
  `hospital` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Address` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Remark` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `IsAbandon` smallint(6) DEFAULT NULL,
  `OutHospital` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Djr` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `BBName` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `YCDate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ISOKState` smallint(6) DEFAULT NULL COMMENT '最终成功',
  `GTOK` smallint(6) DEFAULT NULL COMMENT '沟通成功，答应拍照',
  `PZOK` smallint(6) DEFAULT NULL COMMENT '拍照完成',
  `GTDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '最后一次沟通日期',
  `PZDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '最后一次拍照日期',
  `QJDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件日期',
  `dengjiDate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记日期',
  `IsZhuandan` smallint(6) DEFAULT NULL COMMENT '是否已经转单',
  `menshijiedai` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jiedanyuan` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jiedandian` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `HYDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CKEY` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `OPCompanys` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Communication` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `SMDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `StateAgainDay` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Region` text COLLATE utf8_unicode_ci,
  `LastCallRemark` text COLLATE utf8_unicode_ci,
  `CallDateTime` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Photographer` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Status` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Product` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Price` double DEFAULT NULL,
  `Services` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Assignmentdate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fc` int(11) DEFAULT NULL,
  `PHid` int(11) DEFAULT NULL,
  `LandlineOne` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `LandlineTwo` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `UnionStaff` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Hospitalphotographer` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `PhotographDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ERPDian` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ERPOrder` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `DDDate` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `WeiBoStaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `WeiXinStaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `TuiGuangStaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `YaoYueStaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `SuccessIntent` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ConsultingType` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `AppointmentType` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CSSName` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `HDJiaWei` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `OPCompanysX` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `InsingleDate` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Area` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `StoreConsultant2` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ISPaiDan` smallint(6) DEFAULT NULL,
  `ISFC` smallint(6) DEFAULT NULL,
  `QiTaBJDay` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `IsExERP` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `IsExERPDian` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last` int(11) DEFAULT NULL,
  `CheckSH` smallint(6) DEFAULT NULL,
  `AllocationTime` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`CustomerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table dep_shopyejijidutable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `dep_shopyejijidutable`;

CREATE TABLE `dep_shopyejijidutable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `years` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `months` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyueshishoumubiao` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyueqianqishishoumubiao` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyuehouqishishoumubiao` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leijiwancshishouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyueqianqishishouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leijiqianqishishouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyuehouqishishouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leijishouqishishouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyueleijikakouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyuedingdan` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyuepaizhao` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyuekanyang` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `benyueqitashishouyeji` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jiezhimubiaosuoxubaifenbi` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jiezhimubiaoshijibaifenbi` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_code` (`shop_code`) USING BTREE,
  KEY `shop_name` (`shop_name`) USING BTREE,
  KEY `years` (`years`) USING BTREE,
  KEY `months` (`months`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='实收业绩进度表-沉淀';



# Dump of table district
# ------------------------------------------------------------

DROP TABLE IF EXISTS `district`;

CREATE TABLE `district` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `CityId` int(11) NOT NULL DEFAULT '0',
  `Name` varchar(100) COLLATE ucs2_unicode_ci NOT NULL DEFAULT '0',
  `PostCode` varchar(100) COLLATE ucs2_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci;

LOCK TABLES `district` WRITE;
/*!40000 ALTER TABLE `district` DISABLE KEYS */;

INSERT INTO `district` (`id`, `CityId`, `Name`, `PostCode`)
VALUES
	(1,1,'东城区','100010'),
	(2,1,'西城区','100032'),
	(3,1,'崇文区','100061'),
	(4,1,'宣武区','100054'),
	(5,1,'朝阳区','100020'),
	(6,1,'丰台区','100071'),
	(7,1,'石景山区','100043'),
	(8,1,'海淀区','100089'),
	(9,1,'门头沟区','102300'),
	(10,1,'房山区','102488'),
	(11,1,'通州区','101100'),
	(12,1,'顺义区','101300'),
	(13,1,'昌平区','102200'),
	(14,1,'大兴区','102600'),
	(15,1,'怀柔区','101400'),
	(16,1,'平谷区','101200'),
	(17,1,'密云县','101500'),
	(18,1,'延庆县','102100'),
	(19,2,'和平区','300041'),
	(20,2,'河东区','300171'),
	(21,2,'河西区','300202'),
	(22,2,'南开区','300100'),
	(23,2,'河北区','300143'),
	(24,2,'红桥区','300131'),
	(25,2,'塘沽区','300450'),
	(26,2,'汉沽区','300480'),
	(27,2,'大港区','300270'),
	(28,2,'东丽区','300300'),
	(29,2,'西青区','300380'),
	(30,2,'津南区','300350'),
	(31,2,'北辰区','300400'),
	(32,2,'武清区','301700'),
	(33,2,'宝坻区','301800'),
	(34,2,'宁河县','301500'),
	(35,2,'静海县','301600'),
	(36,2,'蓟县','301900'),
	(37,2,'保税区','300308'),
	(38,2,'经济技术开发区','300457'),
	(39,2,'高新区','300384'),
	(40,2,'滨海新区','300457'),
	(41,3,'长安区','050011'),
	(42,3,'桥东区','050011'),
	(43,3,'桥西区','050051'),
	(44,3,'新华区','050051'),
	(45,3,'井陉矿区','050100'),
	(46,3,'裕华区','050081'),
	(47,3,'井陉县','050300'),
	(48,3,'正定县','050800'),
	(49,3,'栾城县','051430'),
	(50,3,'行唐县','050600'),
	(51,3,'灵寿县','050500'),
	(52,3,'高邑县','051330'),
	(53,3,'深泽县','052560'),
	(54,3,'赞皇县','051230'),
	(55,3,'无极县','052400'),
	(56,3,'平山县','050400'),
	(57,3,'元氏县','051130'),
	(58,3,'赵县','051530'),
	(59,3,'辛集市','052300'),
	(60,3,'藁城市','052160'),
	(61,3,'晋州市','052200'),
	(62,3,'新乐市','050700'),
	(63,3,'鹿泉市','050200'),
	(64,3,'高新技术开发区','050035'),
	(65,4,'路南区','063017'),
	(66,4,'路北区','063015'),
	(67,4,'古冶区','063104'),
	(68,4,'开平区','063021'),
	(69,4,'丰南区','063300'),
	(70,4,'丰润区','064000'),
	(71,4,'滦县','063700'),
	(72,4,'滦南县','063500'),
	(73,4,'乐亭县','063600'),
	(74,4,'迁西县','064300'),
	(75,4,'玉田县','064100'),
	(76,4,'唐海县','063200'),
	(77,4,'遵化市','064200'),
	(78,4,'迁安市','064400'),
	(79,4,'高新区','063020'),
	(80,4,'汉沽管理区','301501'),
	(81,4,'海港开发区','063600'),
	(82,4,'芦台开发区','301501'),
	(83,4,'南堡开发区','063305'),
	(84,4,'曹妃甸工业区','063200'),
	(85,5,'海港区','066000'),
	(86,5,'山海关区','066200'),
	(87,5,'北戴河区','066100'),
	(88,5,'青龙满族自治县','066500'),
	(89,5,'昌黎县','066600'),
	(90,5,'抚宁县','066300'),
	(91,5,'卢龙县','066400'),
	(92,5,'经济技术开发区','066004'),
	(93,6,'邯山区','056001'),
	(94,6,'丛台区','056004'),
	(95,6,'复兴区','056003'),
	(96,6,'峰峰矿区','056200'),
	(97,6,'邯郸县','056100'),
	(98,6,'临漳县','056600'),
	(99,6,'成安县','056700'),
	(100,6,'大名县','056900'),
	(101,6,'涉县','056400'),
	(102,6,'磁县','056500'),
	(103,6,'肥乡县','057550'),
	(104,6,'永年县','057150'),
	(105,6,'邱县','057450'),
	(106,6,'鸡泽县','057350'),
	(107,6,'广平县','057650'),
	(108,6,'馆陶县','057750'),
	(109,6,'魏县','056800'),
	(110,6,'曲周县','057250'),
	(111,6,'武安市','056300'),
	(112,6,'经济开发区','056002'),
	(113,7,'桥东区','054001'),
	(114,7,'桥西区','054000'),
	(115,7,'邢台县','054001'),
	(116,7,'临城县','054300'),
	(117,7,'内丘县','054200'),
	(118,7,'柏乡县','055450'),
	(119,7,'隆尧县','055350'),
	(120,7,'任县','055150'),
	(121,7,'南和县','054400'),
	(122,7,'宁晋县','055550'),
	(123,7,'巨鹿县','055250'),
	(124,7,'新河县','051730'),
	(125,7,'广宗县','054600'),
	(126,7,'平乡县','054500'),
	(127,7,'威县','054700'),
	(128,7,'清河县','054800'),
	(129,7,'临西县','054900'),
	(130,7,'南宫市','055750'),
	(131,7,'沙河市','054100'),
	(132,8,'新市区','071052'),
	(133,8,'南市区','071000'),
	(134,8,'北市区','071000'),
	(135,8,'满城县','072150'),
	(136,8,'清苑县','071100'),
	(137,8,'涞水县','074100'),
	(138,8,'阜平县','073200'),
	(139,8,'徐水县','072550'),
	(140,8,'定兴县','072650'),
	(141,8,'唐县','072350'),
	(142,8,'高阳县','071500'),
	(143,8,'容城县','071700'),
	(144,8,'涞源县','074300'),
	(145,8,'望都县','072450'),
	(146,8,'安新县','071600'),
	(147,8,'易县','074200'),
	(148,8,'曲阳县','073100'),
	(149,8,'蠡县','071400'),
	(150,8,'顺平县','072250'),
	(151,8,'博野县','071300'),
	(152,8,'雄县','071800'),
	(153,8,'涿州市','072750'),
	(154,8,'定州市','073000'),
	(155,8,'安国市','071200'),
	(156,8,'高碑店市','074000'),
	(157,9,'桥东区','075000'),
	(158,9,'桥西区','075061'),
	(159,9,'宣化区','075100'),
	(160,9,'下花园区','075300'),
	(161,9,'宣化县','075100'),
	(162,9,'张北县','076450'),
	(163,9,'康保县','076650'),
	(164,9,'沽源县','076550'),
	(165,9,'尚义县','076750'),
	(166,9,'蔚县','075700'),
	(167,9,'阳原县','075800'),
	(168,9,'怀安县','076150'),
	(169,9,'万全县','076250'),
	(170,9,'怀来县','075400'),
	(171,9,'涿鹿县','075600'),
	(172,9,'赤城县','075500'),
	(173,9,'崇礼县','076350'),
	(174,10,'双桥区','067000'),
	(175,10,'双滦区','067000'),
	(176,10,'鹰手营子矿区','067200'),
	(177,10,'承德县','067400'),
	(178,10,'兴隆县','067300'),
	(179,10,'平泉县','067500'),
	(180,10,'滦平县','068250'),
	(181,10,'隆化县','068150'),
	(182,10,'丰宁满族自治县','068350'),
	(183,10,'宽城满族自治县','067600'),
	(184,10,'围场满族蒙古族自治县','068450'),
	(185,11,'新华区','061000'),
	(186,11,'运河区','061000'),
	(187,11,'沧县','061000'),
	(188,11,'青县','062650'),
	(189,11,'东光县','061600'),
	(190,11,'海兴县','061200'),
	(191,11,'盐山县','061300'),
	(192,11,'肃宁县','062350'),
	(193,11,'南皮县','061500'),
	(194,11,'吴桥县','061800'),
	(195,11,'献县','062250'),
	(196,11,'孟村回族自治县','061400'),
	(197,11,'泊头市','062150'),
	(198,11,'任丘市','062550'),
	(199,11,'黄骅市','061100'),
	(200,11,'河间市','062450'),
	(201,12,'安次区','065000'),
	(202,12,'广阳区','065000'),
	(203,12,'固安县','065500'),
	(204,12,'永清县','065600'),
	(205,12,'香河县','065400'),
	(206,12,'大城县','065900'),
	(207,12,'文安县','065800'),
	(208,12,'大厂回族自治县','065300'),
	(209,12,'霸州市','065700'),
	(210,12,'三河市','065200'),
	(211,12,'开发区','065001'),
	(212,13,'桃城区','053000'),
	(213,13,'枣强县','053100'),
	(214,13,'武邑县','053400'),
	(215,13,'武强县','053300'),
	(216,13,'饶阳县','053900'),
	(217,13,'安平县','053600'),
	(218,13,'故城县','253800'),
	(219,13,'景县','053500'),
	(220,13,'阜城县','053700'),
	(221,13,'冀州市','053200'),
	(222,13,'深州市','053800'),
	(223,14,'小店区','030032'),
	(224,14,'迎泽区','030024'),
	(225,14,'杏花岭区','030001'),
	(226,14,'尖草坪区','030003'),
	(227,14,'万柏林区','030027'),
	(228,14,'晋源区','030025'),
	(229,14,'清徐县','030400'),
	(230,14,'阳曲县','030100'),
	(231,14,'娄烦县','030300'),
	(232,14,'古交市','030200'),
	(233,15,'城区','037008'),
	(234,15,'矿区','037001'),
	(235,15,'南郊区','037001'),
	(236,15,'新荣区','037002'),
	(237,15,'阳高县','038100'),
	(238,15,'天镇县','038200'),
	(239,15,'广灵县','037500'),
	(240,15,'灵丘县','034400'),
	(241,15,'浑源县','037400'),
	(242,15,'左云县','037100'),
	(243,15,'大同县','037300'),
	(244,16,'城区','045000'),
	(245,16,'矿区','045000'),
	(246,16,'郊区','045011'),
	(247,16,'平定县','045200'),
	(248,16,'盂县','045100'),
	(249,17,'城区','046011'),
	(250,17,'郊区','046011'),
	(251,17,'长治县','047100'),
	(252,17,'襄垣县','046200'),
	(253,17,'屯留县','046100'),
	(254,17,'平顺县','047400'),
	(255,17,'黎城县','047600'),
	(256,17,'壶关县','047300'),
	(257,17,'长子县','046600'),
	(258,17,'武乡县','046300'),
	(259,17,'沁县','046400'),
	(260,17,'沁源县','046500'),
	(261,17,'潞城市','047500'),
	(262,18,'城区','048000'),
	(263,18,'沁水县','048200'),
	(264,18,'阳城县','048100'),
	(265,18,'陵川县','048300'),
	(266,18,'泽州县','048012'),
	(267,18,'高平市','048400'),
	(268,19,'朔城区','038500'),
	(269,19,'平鲁区','038600'),
	(270,19,'山阴县','036900'),
	(271,19,'应县','037600'),
	(272,19,'右玉县','037200'),
	(273,19,'怀仁县','038300'),
	(274,20,'榆次区','030600'),
	(275,20,'榆社县','031800'),
	(276,20,'左权县','032600'),
	(277,20,'和顺县','032700'),
	(278,20,'昔阳县','045300'),
	(279,20,'寿阳县','045400'),
	(280,20,'太谷县','030800'),
	(281,20,'祁县','030900'),
	(282,20,'平遥县','031100'),
	(283,20,'灵石县','031300'),
	(284,20,'介休市','031200'),
	(285,21,'盐湖区','044000'),
	(286,21,'临猗县','044100'),
	(287,21,'万荣县','044200'),
	(288,21,'闻喜县','043800'),
	(289,21,'稷山县','043200'),
	(290,21,'新绛县','043100'),
	(291,21,'绛县','043600'),
	(292,21,'垣曲县','043700'),
	(293,21,'夏县','044400'),
	(294,21,'平陆县','044300'),
	(295,21,'芮城县','044600'),
	(296,21,'永济市','044500'),
	(297,21,'河津市','043300'),
	(298,22,'忻府区','034000'),
	(299,22,'定襄县','035400'),
	(300,22,'五台县','035500'),
	(301,22,'代县','034200'),
	(302,22,'繁峙县','034300'),
	(303,22,'宁武县','036700'),
	(304,22,'静乐县','035100'),
	(305,22,'神池县','036100'),
	(306,22,'五寨县','036200'),
	(307,22,'岢岚县','036300'),
	(308,22,'河曲县','036500'),
	(309,22,'保德县','036600'),
	(310,22,'偏关县','036400'),
	(311,22,'原平市','034100'),
	(312,23,'尧都区','041000'),
	(313,23,'曲沃县','043400'),
	(314,23,'翼城县','043500'),
	(315,23,'襄汾县','041500'),
	(316,23,'洪洞县','031600'),
	(317,23,'古县','042400'),
	(318,23,'安泽县','042500'),
	(319,23,'浮山县','042600'),
	(320,23,'吉县','042200'),
	(321,23,'乡宁县','042100'),
	(322,23,'大宁县','042300'),
	(323,23,'隰县','041300'),
	(324,23,'永和县','041400'),
	(325,23,'蒲县','041200'),
	(326,23,'汾西县','031500'),
	(327,23,'侯马市','043007'),
	(328,23,'霍州市','031400'),
	(329,24,'离石区','033000'),
	(330,24,'文水县','032100'),
	(331,24,'交城县','030500'),
	(332,24,'兴县','033600'),
	(333,24,'临县','033200'),
	(334,24,'柳林县','033300'),
	(335,24,'石楼县','032500'),
	(336,24,'岚县','033500'),
	(337,24,'方山县','033100'),
	(338,24,'中阳县','033400'),
	(339,24,'交口县','032400'),
	(340,24,'孝义市','032300'),
	(341,24,'汾阳市','032200'),
	(342,25,'回民区','010030'),
	(343,25,'玉泉区','010020'),
	(344,25,'新城区','010030'),
	(345,25,'赛罕区','010020'),
	(346,25,'土默特左旗','010100'),
	(347,25,'托克托县','010200'),
	(348,25,'和林格尔县','011500'),
	(349,25,'清水河县','011600'),
	(350,25,'武川县','011700'),
	(351,26,'东河区','014040'),
	(352,26,'昆都仑区','014010'),
	(353,26,'青山区','014030'),
	(354,26,'石拐区','014070'),
	(355,26,'白云矿区','014080'),
	(356,26,'九原区','014060'),
	(357,26,'土默特右旗','014100'),
	(358,26,'固阳县','014200'),
	(359,26,'达尔罕茂明安联合旗','014500'),
	(360,27,'海勃湾区','016000'),
	(361,27,'海南区','016030'),
	(362,27,'乌达区','016040'),
	(363,28,'红山区','024020'),
	(364,28,'元宝山区','024076'),
	(365,28,'松山区','024005'),
	(366,28,'阿鲁科尔沁旗','025550'),
	(367,28,'巴林左旗','025450'),
	(368,28,'巴林右旗','025150'),
	(369,28,'林西县','025250'),
	(370,28,'克什克腾旗','025350'),
	(371,28,'翁牛特旗','024500'),
	(372,28,'喀喇沁旗','024400'),
	(373,28,'宁城县','024200'),
	(374,28,'敖汉旗','024300'),
	(375,28,'新城区','025350'),
	(376,29,'科尔沁区','028000'),
	(377,29,'科尔沁左翼中旗','029300'),
	(378,29,'科尔沁左翼后旗','028100'),
	(379,29,'开鲁县','028400'),
	(380,29,'库伦旗','028200'),
	(381,29,'奈曼旗','028300'),
	(382,29,'扎鲁特旗','029100'),
	(383,29,'霍林郭勒市','029200'),
	(384,30,'东胜区','017000'),
	(385,30,'达拉特旗','014300'),
	(386,30,'准格尔旗','017100'),
	(387,30,'鄂托克前旗','016200'),
	(388,30,'鄂托克旗','016100'),
	(389,30,'杭锦旗','017400'),
	(390,30,'乌审旗','017300'),
	(391,30,'伊金霍洛旗','017200'),
	(392,31,'海拉尔区','021000'),
	(393,31,'阿荣旗','162750'),
	(394,31,'莫力达瓦达斡尔族自治旗','162850'),
	(395,31,'鄂伦春自治旗','165450'),
	(396,31,'鄂温克族自治旗','021100'),
	(397,31,'陈巴尔虎旗','021500'),
	(398,31,'新巴尔虎左旗','021200'),
	(399,31,'新巴尔虎右旗','021300'),
	(400,31,'满洲里市','021400'),
	(401,31,'牙克石市','022150'),
	(402,31,'扎兰屯市','162650'),
	(403,31,'额尔古纳市','022250'),
	(404,31,'根河市','022350'),
	(405,32,'临河区','015001'),
	(406,32,'五原县','015100'),
	(407,32,'磴口县','015200'),
	(408,32,'乌拉特前旗','014400'),
	(409,32,'乌拉特中旗','015300'),
	(410,32,'乌拉特后旗','015500'),
	(411,32,'杭锦后旗','015400'),
	(412,33,'集宁区','012000'),
	(413,33,'卓资县','012300'),
	(414,33,'化德县','013350'),
	(415,33,'商都县','013450'),
	(416,33,'兴和县','013650'),
	(417,33,'凉城县','013750'),
	(418,33,'察哈尔右翼前旗','012200'),
	(419,33,'察哈尔右翼中旗','013550'),
	(420,33,'察哈尔右翼后旗','012400'),
	(421,33,'四子王旗','011800'),
	(422,33,'丰镇市','012100'),
	(423,34,'乌兰浩特市','137401'),
	(424,34,'阿尔山市','137800'),
	(425,34,'科尔沁右翼前旗','137423'),
	(426,34,'科尔沁右翼中旗','029400'),
	(427,34,'扎赉特旗','137600'),
	(428,34,'突泉县','137500'),
	(429,35,'二连浩特市','011100'),
	(430,35,'锡林浩特市','026000'),
	(431,35,'阿巴嘎旗','011400'),
	(432,35,'苏尼特左旗','011300'),
	(433,35,'苏尼特右旗','011200'),
	(434,35,'东乌珠穆沁旗','026300'),
	(435,35,'西乌珠穆沁旗','026200'),
	(436,35,'太仆寺旗','027000'),
	(437,35,'镶黄旗','013250'),
	(438,35,'正镶白旗','013800'),
	(439,35,'正蓝旗','027200'),
	(440,35,'多伦县','027300'),
	(441,36,'阿拉善左旗','750306'),
	(442,36,'阿拉善右旗','737300'),
	(443,36,'额济纳旗','735400'),
	(444,37,'和平区','110001'),
	(445,37,'沈河区','110013'),
	(446,37,'大东区','110041'),
	(447,37,'皇姑区','110031'),
	(448,37,'铁西区','110021'),
	(449,37,'苏家屯区','110101'),
	(450,37,'东陵区','110015'),
	(451,37,'沈北新区','110121'),
	(452,37,'于洪区','110141'),
	(453,37,'辽中县','110200'),
	(454,37,'康平县','110500'),
	(455,37,'法库县','110400'),
	(456,37,'新民市','110300'),
	(457,37,'经济技术开发区','110141'),
	(458,37,'浑南新区','110179'),
	(459,37,'新城子经济技术开发区','110121'),
	(460,38,'中山区','116001'),
	(461,38,'西岗区','116011'),
	(462,38,'沙河口区','116021'),
	(463,38,'甘井子区','116033'),
	(464,38,'旅顺口区','116041'),
	(465,38,'金州区','116100'),
	(466,38,'长海县','116500'),
	(467,38,'瓦房店市','116300'),
	(468,38,'普兰店市','116200'),
	(469,38,'庄河市','116400'),
	(470,38,'开发区','116600'),
	(471,38,'保税区','116600'),
	(472,39,'铁东区','114001'),
	(473,39,'铁西区','114013'),
	(474,39,'立山区','114031'),
	(475,39,'千山区','114041'),
	(476,39,'台安县','114100'),
	(477,39,'岫岩满族自治县','114300'),
	(478,39,'海城市','114200'),
	(479,40,'新抚区','113008'),
	(480,40,'东洲区','113003'),
	(481,40,'望花区','113001'),
	(482,40,'顺城区','113006'),
	(483,40,'抚顺县','113006'),
	(484,40,'新宾满族自治县','113200'),
	(485,40,'清原满族自治县','113300'),
	(486,41,'平山区','117000'),
	(487,41,'明山区','117021'),
	(488,41,'溪湖区','117002'),
	(489,41,'南芬区','117014'),
	(490,41,'本溪满族自治县','117100'),
	(491,41,'桓仁满族自治县','117200'),
	(492,42,'元宝区','118000'),
	(493,42,'振兴区','118002'),
	(494,42,'振安区','118001'),
	(495,42,'宽甸满族自治县','118200'),
	(496,42,'东港市','118300'),
	(497,42,'凤城市','118100'),
	(498,43,'古塔区','121001'),
	(499,43,'凌河区','121000'),
	(500,43,'太和区','121011'),
	(501,43,'黑山县','121400'),
	(502,43,'义县','121100'),
	(503,43,'凌海市','121200'),
	(504,43,'北宁市','121300'),
	(505,43,'松山新区','121219'),
	(506,43,'经济技术开发区','121007'),
	(507,44,'站前区','115002'),
	(508,44,'西市区','115004'),
	(509,44,'鲅鱼圈区','115007'),
	(510,44,'老边区','115005'),
	(511,44,'盖州市','115200'),
	(512,44,'大石桥市','115100'),
	(513,45,'海州区','123000'),
	(514,45,'新邱区','123005'),
	(515,45,'太平区','123003'),
	(516,45,'清河门区','123006'),
	(517,45,'细河区','123000'),
	(518,45,'阜新蒙古族自治县','123100'),
	(519,45,'彰武县','123200'),
	(520,46,'白塔区','111000'),
	(521,46,'文圣区','111000'),
	(522,46,'宏伟区','111003'),
	(523,46,'弓长岭区','111008'),
	(524,46,'太子河区','111000'),
	(525,46,'辽阳县','111200'),
	(526,46,'灯塔市','111300'),
	(527,47,'双台子区','124000'),
	(528,47,'兴隆台区','124010'),
	(529,47,'大洼县','124200'),
	(530,47,'盘山县','124000'),
	(531,48,'银州区','112000'),
	(532,48,'清河区','112003'),
	(533,48,'铁岭县','112000'),
	(534,48,'西丰县','112400'),
	(535,48,'昌图县','112500'),
	(536,48,'调兵山市','112700'),
	(537,48,'开原市','112300'),
	(538,49,'双塔区','122000'),
	(539,49,'龙城区','122000'),
	(540,49,'朝阳县','122000'),
	(541,49,'建平县','122400'),
	(542,49,'喀喇沁左翼蒙古族自治县','122300'),
	(543,49,'北票市','122100'),
	(544,49,'凌源市','122500'),
	(545,50,'连山区','125001'),
	(546,50,'龙港区','125003'),
	(547,50,'南票区','125027'),
	(548,50,'绥中县','125200'),
	(549,50,'建昌县','125300'),
	(550,50,'兴城市','125100'),
	(551,51,'南关区','130022'),
	(552,51,'宽城区','130051'),
	(553,51,'朝阳区','130012'),
	(554,51,'二道区','130031'),
	(555,51,'绿园区','130062'),
	(556,51,'双阳区','130600'),
	(557,51,'农安县','130200'),
	(558,51,'九台市','130500'),
	(559,51,'榆树市','130400'),
	(560,51,'德惠市','130300'),
	(561,51,'净月经济开发区','130117'),
	(562,51,'高新技术产业开发区','130015'),
	(563,51,'经济技术开发区','130022'),
	(564,52,'昌邑区','132002'),
	(565,52,'龙潭区','132021'),
	(566,52,'船营区','132011'),
	(567,52,'丰满区','132013'),
	(568,52,'永吉县','132200'),
	(569,52,'蛟河市','132500'),
	(570,52,'桦甸市','132400'),
	(571,52,'舒兰市','132600'),
	(572,52,'磐石市','132300'),
	(573,53,'铁西区','136000'),
	(574,53,'铁东区','136001'),
	(575,53,'梨树县','136500'),
	(576,53,'伊通满族自治县','130700'),
	(577,53,'公主岭市','136100'),
	(578,53,'双辽市','136400'),
	(579,54,'龙山区','136200'),
	(580,54,'西安区','136201'),
	(581,54,'东丰县','136300'),
	(582,54,'东辽县','136600'),
	(583,55,'东昌区','134001'),
	(584,55,'二道江区','134003'),
	(585,55,'通化县','134100'),
	(586,55,'辉南县','135100'),
	(587,55,'柳河县','135300'),
	(588,55,'梅河口市','135000'),
	(589,55,'集安市','134200'),
	(590,56,'八道江区','134300'),
	(591,56,'抚松县','134500'),
	(592,56,'靖宇县','135200'),
	(593,56,'长白朝鲜族自治县','134400'),
	(594,56,'江源县','134700'),
	(595,56,'临江市','134600'),
	(596,57,'宁江区','138000'),
	(597,57,'前郭尔罗斯蒙古族自治县','138000'),
	(598,57,'长岭县','131500'),
	(599,57,'乾安县','131400'),
	(600,57,'扶余县','131200'),
	(601,58,'洮北区','137000'),
	(602,58,'镇赉县','137300'),
	(603,58,'通榆县','137200'),
	(604,58,'洮南市','137100'),
	(605,58,'大安市','131300'),
	(606,59,'延吉市','133000'),
	(607,59,'图们市','133100'),
	(608,59,'敦化市','133700'),
	(609,59,'珲春市','133300'),
	(610,59,'龙井市','133400'),
	(611,59,'和龙市','133500'),
	(612,59,'汪清县','133200'),
	(613,59,'安图县','133600'),
	(614,60,'道里区','150010'),
	(615,60,'南岗区','150006'),
	(616,60,'道外区','150020'),
	(617,60,'香坊区','150036'),
	(618,60,'动力区','150040'),
	(619,60,'平房区','150060'),
	(620,60,'松北区','150028'),
	(621,60,'呼兰区','150500'),
	(622,60,'依兰县','154800'),
	(623,60,'方正县','150800'),
	(624,60,'宾县','150400'),
	(625,60,'巴彦县','151800'),
	(626,60,'木兰县','151900'),
	(627,60,'通河县','150900'),
	(628,60,'延寿县','150700'),
	(629,60,'阿城市','150300'),
	(630,60,'双城市','150100'),
	(631,60,'尚志市','150600'),
	(632,60,'五常市','150200'),
	(633,61,'龙沙区','161000'),
	(634,61,'建华区','161006'),
	(635,61,'铁锋区','161000'),
	(636,61,'昂昂溪区','161031'),
	(637,61,'富拉尔基区','161041'),
	(638,61,'碾子山区','161046'),
	(639,61,'梅里斯达斡尔族区','161021'),
	(640,61,'龙江县','161100'),
	(641,61,'依安县','161500'),
	(642,61,'泰来县','162400'),
	(643,61,'甘南县','162100'),
	(644,61,'富裕县','161200'),
	(645,61,'克山县','161600'),
	(646,61,'克东县','164800'),
	(647,61,'拜泉县','164700'),
	(648,61,'讷河市','161300'),
	(649,62,'鸡冠区','158100'),
	(650,62,'恒山区','158130'),
	(651,62,'滴道区','158150'),
	(652,62,'梨树区','158160'),
	(653,62,'城子河区','158170'),
	(654,62,'麻山区','158180'),
	(655,62,'鸡东县','158200'),
	(656,62,'虎林市','158400'),
	(657,62,'密山市','158300'),
	(658,63,'向阳区','154100'),
	(659,63,'工农区','154101'),
	(660,63,'南山区','154104'),
	(661,63,'兴安区','154102'),
	(662,63,'东山区','154106'),
	(663,63,'兴山区','154105'),
	(664,63,'萝北县','154200'),
	(665,63,'绥滨县','156200'),
	(666,64,'尖山区','155100'),
	(667,64,'岭东区','155120'),
	(668,64,'四方台区','155130'),
	(669,64,'宝山区','155131'),
	(670,64,'集贤县','155900'),
	(671,64,'友谊县','155800'),
	(672,64,'宝清县','155600'),
	(673,64,'饶河县','155700'),
	(674,65,'萨尔图区','163001'),
	(675,65,'龙凤区','163711'),
	(676,65,'让胡路区','163712'),
	(677,65,'红岗区','163511'),
	(678,65,'大同区','163515'),
	(679,65,'肇州县','166400'),
	(680,65,'肇源县','166500'),
	(681,65,'林甸县','166300'),
	(682,65,'杜尔伯特蒙古族自治县','166200'),
	(683,66,'伊春区','153000'),
	(684,66,'南岔区','153100'),
	(685,66,'友好区','153031'),
	(686,66,'西林区','153025'),
	(687,66,'翠峦区','153013'),
	(688,66,'新青区','153036'),
	(689,66,'美溪区','153021'),
	(690,66,'金山屯区','153026'),
	(691,66,'五营区','153033'),
	(692,66,'乌马河区','153011'),
	(693,66,'汤旺河区','153037'),
	(694,66,'带岭区','153106'),
	(695,66,'乌伊岭区','153038'),
	(696,66,'红星区','153035'),
	(697,66,'上甘岭区','153032'),
	(698,66,'嘉荫县','153200'),
	(699,66,'铁力市','152500'),
	(700,67,'向阳区','154002'),
	(701,67,'前进区','154002'),
	(702,67,'东风区','154005'),
	(703,67,'郊区','154004'),
	(704,67,'桦南县','154400'),
	(705,67,'桦川县','154300'),
	(706,67,'汤原县','154700'),
	(707,67,'抚远县','156500'),
	(708,67,'同江市','156400'),
	(709,67,'富锦市','156100'),
	(710,68,'新兴区','154604'),
	(711,68,'桃山区','154600'),
	(712,68,'茄子河区','154622'),
	(713,68,'勃利县','154500'),
	(714,69,'东安区','157000'),
	(715,69,'爱民区','157009'),
	(716,69,'阳明区','157013'),
	(717,69,'西安区','157000'),
	(718,69,'东宁县','157200'),
	(719,69,'林口县','157600'),
	(720,69,'绥芬河市','157300'),
	(721,69,'海林市','157100'),
	(722,69,'宁安市','157400'),
	(723,69,'穆棱市','157500'),
	(724,70,'爱辉区','164300'),
	(725,70,'嫩江县','161400'),
	(726,70,'逊克县','164400'),
	(727,70,'孙吴县','164200'),
	(728,70,'北安市','164000'),
	(729,70,'五大连池市','164100'),
	(730,71,'北林区','152000'),
	(731,71,'望奎县','152100'),
	(732,71,'兰西县','151500'),
	(733,71,'青冈县','151600'),
	(734,71,'庆安县','152400'),
	(735,71,'明水县','151700'),
	(736,71,'绥棱县','152200'),
	(737,71,'安达市','151400'),
	(738,71,'肇东市','151100'),
	(739,71,'海伦市','152300'),
	(740,72,'呼玛县','165100'),
	(741,72,'塔河县','165200'),
	(742,72,'漠河县','165300'),
	(743,72,'加格达奇区','165000'),
	(744,72,'松岭区','165012'),
	(745,72,'新林区','165023'),
	(746,72,'呼中区','165036'),
	(747,73,'黄浦区','200001'),
	(748,73,'卢湾区','200020'),
	(749,73,'徐汇区','200030'),
	(750,73,'长宁区','200050'),
	(751,73,'静安区','200040'),
	(752,73,'普陀区','200333'),
	(753,73,'闸北区','200070'),
	(754,73,'虹口区','200080'),
	(755,73,'杨浦区','200082'),
	(756,73,'闵行区','201100'),
	(757,73,'宝山区','201900'),
	(758,73,'嘉定区','201800'),
	(759,73,'浦东新区','200135'),
	(760,73,'金山区','200540'),
	(761,73,'松江区','201600'),
	(762,73,'青浦区','201700'),
	(763,73,'南汇区','201300'),
	(764,73,'奉贤区','201400'),
	(765,73,'崇明县','202150'),
	(766,74,'玄武区','210018'),
	(767,74,'白下区','210002'),
	(768,74,'秦淮区','210001'),
	(769,74,'建邺区','210004'),
	(770,74,'鼓楼区','210009'),
	(771,74,'下关区','210011'),
	(772,74,'浦口区','211800'),
	(773,74,'栖霞区','210046'),
	(774,74,'雨花台区','210012'),
	(775,74,'江宁区','211100'),
	(776,74,'六合区','211500'),
	(777,74,'溧水县','211200'),
	(778,74,'高淳县','211300'),
	(779,75,'崇安区','214002'),
	(780,75,'南长区','214021'),
	(781,75,'北塘区','214044'),
	(782,75,'锡山区','214101'),
	(783,75,'惠山区','214174'),
	(784,75,'滨湖区','214062'),
	(785,75,'江阴市','214400'),
	(786,75,'宜兴市','214200'),
	(787,75,'新区','214028'),
	(788,76,'云龙区','221009'),
	(789,76,'鼓楼区','221005'),
	(790,76,'九里区','221140'),
	(791,76,'泉山区','221006'),
	(792,76,'铜山县','221116'),
	(793,76,'贾汪区','221011'),
	(794,76,'丰县','221700'),
	(795,76,'沛县','221600'),
	(796,76,'睢宁县','221200'),
	(797,76,'新沂市','221400'),
	(798,76,'邳州市','221300'),
	(799,77,'天宁区','213003'),
	(800,77,'钟楼区','213002'),
	(801,77,'戚墅堰区','213011'),
	(802,77,'新北区','213001'),
	(803,77,'武进区','213161'),
	(804,77,'溧阳市','213300'),
	(805,77,'金坛市','213200'),
	(806,78,'沧浪区','215006'),
	(807,78,'平江区','215005'),
	(808,78,'金阊区','215008'),
	(809,78,'虎丘区','215004'),
	(810,78,'吴中区','215128'),
	(811,78,'相城区','215131'),
	(812,78,'常熟市','215500'),
	(813,78,'张家港市','215600'),
	(814,78,'昆山市','215300'),
	(815,78,'吴江市','215200'),
	(816,78,'太仓市','215400'),
	(817,78,'工业园区','215028'),
	(818,78,'高新区','215011'),
	(819,79,'崇川区','226001'),
	(820,79,'港闸区','226001'),
	(821,79,'海安县','226600'),
	(822,79,'如东县','226400'),
	(823,79,'启东市','226200'),
	(824,79,'如皋市','226500'),
	(825,79,'通州市','226300'),
	(826,79,'海门市','226100'),
	(827,79,'经济技术开发区','226009'),
	(828,80,'连云区','222042'),
	(829,80,'新浦区','222003'),
	(830,80,'海州区','222023'),
	(831,80,'赣榆县','222100'),
	(832,80,'东海县','222300'),
	(833,80,'灌云县','222200'),
	(834,80,'灌南县','223500'),
	(835,81,'清河区','223001'),
	(836,81,'楚州区','223200'),
	(837,81,'淮阴区','223300'),
	(838,81,'清浦区','223002'),
	(839,81,'涟水县','223400'),
	(840,81,'洪泽县','223100'),
	(841,81,'盱眙县','211700'),
	(842,81,'金湖县','211600'),
	(843,82,'亭湖区','224005'),
	(844,82,'盐都区','224055'),
	(845,82,'响水县','224600'),
	(846,82,'滨海县','224500'),
	(847,82,'阜宁县','224400'),
	(848,82,'射阳县','224300'),
	(849,82,'建湖县','224700'),
	(850,82,'东台市','224200'),
	(851,82,'大丰市','224100'),
	(852,83,'广陵区','225002'),
	(853,83,'邗江区','225002'),
	(854,83,'宝应县','225800'),
	(855,83,'仪征市','211400'),
	(856,83,'高邮市','225600'),
	(857,83,'江都市','225200'),
	(858,83,'维扬区','225002'),
	(859,83,'经济开发区','225101'),
	(860,84,'京口区','212001'),
	(861,84,'润州区','212004'),
	(862,84,'丹徒区','212001'),
	(863,84,'丹阳市','212300'),
	(864,84,'扬中市','212200'),
	(865,84,'句容市','212400'),
	(866,84,'新区','212132'),
	(867,85,'海陵区','225300'),
	(868,85,'高港区','225321'),
	(869,85,'兴化市','225700'),
	(870,85,'靖江市','214500'),
	(871,85,'泰兴市','225400'),
	(872,85,'姜堰市','225500'),
	(873,86,'宿城区','223800'),
	(874,86,'宿豫区','223800'),
	(875,86,'沭阳县','223600'),
	(876,86,'泗阳县','223700'),
	(877,86,'泗洪县','223900'),
	(878,87,'上城区','310002'),
	(879,87,'下城区','310006'),
	(880,87,'江干区','310016'),
	(881,87,'拱墅区','310011'),
	(882,87,'西湖区','310013'),
	(883,87,'滨江区','310051'),
	(884,87,'萧山区','311200'),
	(885,87,'余杭区','311100'),
	(886,87,'桐庐县','311500'),
	(887,87,'淳安县','311700'),
	(888,87,'建德市','311600'),
	(889,87,'富阳市','311400'),
	(890,87,'临安市','311300'),
	(891,88,'海曙区','315000'),
	(892,88,'江东区','315040'),
	(893,88,'江北区','315040'),
	(894,88,'北仑区','315800'),
	(895,88,'镇海区','315200'),
	(896,88,'鄞州区','315100'),
	(897,88,'象山县','315700'),
	(898,88,'宁海县','315600'),
	(899,88,'余姚市','315400'),
	(900,88,'慈溪市','315300'),
	(901,88,'奉化市','315500'),
	(902,89,'鹿城区','325000'),
	(903,89,'龙湾区','325013'),
	(904,89,'瓯海区','325005'),
	(905,89,'洞头县','325700'),
	(906,89,'永嘉县','315100'),
	(907,89,'平阳县','325400'),
	(908,89,'苍南县','325800'),
	(909,89,'文成县','325300'),
	(910,89,'泰顺县','325500'),
	(911,89,'瑞安市','325200'),
	(912,89,'乐清市','325600'),
	(913,90,'秀洲区','314001'),
	(914,90,'嘉善县','314100'),
	(915,90,'海盐县','314300'),
	(916,90,'海宁市','314400'),
	(917,90,'平湖市','314200'),
	(918,90,'桐乡市','314500'),
	(919,90,'南湖区','314001'),
	(920,91,'吴兴区','313000'),
	(921,91,'南浔区','313009'),
	(922,91,'德清县','313200'),
	(923,91,'长兴县','313100'),
	(924,91,'安吉县','313300'),
	(925,92,'越城区','312000'),
	(926,92,'柯桥区','312000'),
	(927,92,'新昌县','312500'),
	(928,92,'诸暨市','311800'),
	(929,92,'上虞市','312300'),
	(930,92,'嵊州市','312400'),
	(931,93,'婺城区','321000'),
	(932,93,'金东区','321000'),
	(933,93,'武义县','321200'),
	(934,93,'浦江县','322200'),
	(935,93,'磐安县','322300'),
	(936,93,'兰溪市','321100'),
	(937,93,'义乌市','322000'),
	(938,93,'东阳市','322100'),
	(939,93,'永康市','321300'),
	(940,94,'柯城区','324100'),
	(941,94,'衢江区','324022'),
	(942,94,'常山县','324200'),
	(943,94,'开化县','324300'),
	(944,94,'龙游县','324400'),
	(945,94,'江山市','324100'),
	(946,95,'定海区','316000'),
	(947,95,'普陀区','316100'),
	(948,95,'岱山县','316200'),
	(949,95,'嵊泗县','202450'),
	(950,96,'椒江区','318000'),
	(951,96,'路桥区','318050'),
	(952,96,'黄岩区','318020'),
	(953,96,'玉环县','317600'),
	(954,96,'三门县','317100'),
	(955,96,'天台县','317200'),
	(956,96,'仙居县','317300'),
	(957,96,'温岭市','317500'),
	(958,96,'临海市','317000'),
	(959,97,'莲都区','323000'),
	(960,97,'青田县','323900'),
	(961,97,'缙云县','321400'),
	(962,97,'遂昌县','323300'),
	(963,97,'松阳县','323400'),
	(964,97,'云和县','323600'),
	(965,97,'庆元县','323800'),
	(966,97,'景宁畲族自治县','323500'),
	(967,97,'龙泉市','323700'),
	(968,98,'瑶海区','230011'),
	(969,98,'庐阳区','230001'),
	(970,98,'蜀山区','230031'),
	(971,98,'包河区','230041'),
	(972,98,'长丰县','231100'),
	(973,98,'肥东县','231600'),
	(974,98,'肥西县','231200'),
	(975,98,'经济技术开发区','230601'),
	(976,98,'新站试验区','230011'),
	(977,98,'政务文化新区','230066'),
	(978,98,'高新技术产业开发区','230088'),
	(979,99,'镜湖区','241000'),
	(980,99,'鸠江区','241000'),
	(981,99,'芜湖县','241100'),
	(982,99,'繁昌县','241200'),
	(983,99,'南陵县','242400'),
	(984,99,'弋江区',''),
	(985,99,'三山区','241000'),
	(986,100,'龙子湖区','233000'),
	(987,100,'蚌山区','233000'),
	(988,100,'禹会区','233000'),
	(989,100,'淮上区','233000'),
	(990,100,'怀远县','233400'),
	(991,100,'五河县','233300'),
	(992,100,'固镇县','233700'),
	(993,101,'大通区','232033'),
	(994,101,'田家庵区','232000'),
	(995,101,'谢家集区','232052'),
	(996,101,'八公山区','232072'),
	(997,101,'潘集区','232082'),
	(998,101,'凤台县','232100'),
	(999,102,'雨山区','243071'),
	(1000,102,'花山区','243000'),
	(1001,102,'金家庄区','243021'),
	(1002,102,'当涂县','243100'),
	(1003,102,'经济技术开发区','243041'),
	(1004,103,'杜集区','235000'),
	(1005,103,'相山区','235000'),
	(1006,103,'烈山区','235000'),
	(1007,103,'濉溪县','235100'),
	(1008,104,'铜官山区','244000'),
	(1009,104,'狮子山区','244000'),
	(1010,104,'郊区','244000'),
	(1011,104,'铜陵县','244100'),
	(1012,105,'迎江区','246001'),
	(1013,105,'大观区','246002'),
	(1014,105,'怀宁县','246100'),
	(1015,105,'枞阳县','246700'),
	(1016,105,'潜山县','246300'),
	(1017,105,'太湖县','246400'),
	(1018,105,'宿松县','246500'),
	(1019,105,'望江县','246200'),
	(1020,105,'岳西县','246600'),
	(1021,105,'桐城市','231400'),
	(1022,105,'宜秀区','246003'),
	(1023,106,'屯溪区','245000'),
	(1024,106,'黄山区','242700'),
	(1025,106,'徽州区','245061'),
	(1026,106,'歙县','245200'),
	(1027,106,'休宁县','245400'),
	(1028,106,'黟县','245500'),
	(1029,106,'祁门县','245600'),
	(1030,107,'琅琊区','239000'),
	(1031,107,'南谯区','239000'),
	(1032,107,'来安县','239200'),
	(1033,107,'全椒县','239500'),
	(1034,107,'定远县','233200'),
	(1035,107,'凤阳县','233100'),
	(1036,107,'天长市','239300'),
	(1037,107,'明光市','239400'),
	(1038,108,'颍州区','236001'),
	(1039,108,'颍东区','236058'),
	(1040,108,'颍泉区','236045'),
	(1041,108,'临泉县','236400'),
	(1042,108,'太和县','236600'),
	(1043,108,'阜南县','236300'),
	(1044,108,'颍上县','236200'),
	(1045,108,'界首市','236500'),
	(1046,108,'经济开发区','236112'),
	(1047,109,'埇桥区','234000'),
	(1048,109,'砀山县','235300'),
	(1049,109,'萧县','235200'),
	(1050,109,'灵璧县','234200'),
	(1051,109,'泗县','234300'),
	(1052,110,'居巢区','238000'),
	(1053,110,'庐江县','231500'),
	(1054,110,'无为县','238300'),
	(1055,110,'含山县','238100'),
	(1056,110,'和县','238200'),
	(1057,111,'金安区','237000'),
	(1058,111,'裕安区','237010'),
	(1059,111,'寿县','232200'),
	(1060,111,'霍邱县','237400'),
	(1061,111,'舒城县','231300'),
	(1062,111,'金寨县','237300'),
	(1063,111,'霍山县','237200'),
	(1064,112,'谯城区','236800'),
	(1065,112,'涡阳县','233600'),
	(1066,112,'蒙城县','233500'),
	(1067,112,'利辛县','236700'),
	(1068,113,'贵池区','247100'),
	(1069,113,'东至县','247200'),
	(1070,113,'石台县','245100'),
	(1071,113,'青阳县','242800'),
	(1072,114,'宣州区','242000'),
	(1073,114,'郎溪县','242100'),
	(1074,114,'广德县','242200'),
	(1075,114,'泾县','242500'),
	(1076,114,'绩溪县','245300'),
	(1077,114,'旌德县','242600'),
	(1078,114,'宁国市','242300'),
	(1079,115,'鼓楼区','350001'),
	(1080,115,'台江区','350004'),
	(1081,115,'仓山区','350007'),
	(1082,115,'马尾区','350015'),
	(1083,115,'晋安区','350011'),
	(1084,115,'闽侯县','350100'),
	(1085,115,'连江县','350500'),
	(1086,115,'罗源县','350600'),
	(1087,115,'闽清县','350800'),
	(1088,115,'永泰县','350700'),
	(1089,115,'平潭县','350400'),
	(1090,115,'福清市','350300'),
	(1091,115,'长乐市','350200'),
	(1092,116,'思明区','361001'),
	(1093,116,'海沧区','361026'),
	(1094,116,'湖里区','361006'),
	(1095,116,'集美区','361021'),
	(1096,116,'同安区','361100'),
	(1097,116,'翔安区','361101'),
	(1098,116,'鼓浪屿区','361002'),
	(1099,116,'象屿保税区','361006'),
	(1100,116,'火炬高新区','361006'),
	(1101,117,'城厢区','351100'),
	(1102,117,'涵江区','351111'),
	(1103,117,'荔城区','351100'),
	(1104,117,'秀屿区','351152'),
	(1105,117,'仙游县','351200'),
	(1106,118,'梅列区','365000'),
	(1107,118,'三元区','365001'),
	(1108,118,'明溪县','365200'),
	(1109,118,'清流县','365300'),
	(1110,118,'宁化县','365400'),
	(1111,118,'大田县','366100'),
	(1112,118,'尤溪县','365100'),
	(1113,118,'沙县','365500'),
	(1114,118,'将乐县','353300'),
	(1115,118,'泰宁县','354400'),
	(1116,118,'建宁县','354500'),
	(1117,118,'永安市','366000'),
	(1118,119,'鲤城区','362000'),
	(1119,119,'丰泽区','362000'),
	(1120,119,'洛江区','362011'),
	(1121,119,'泉港区','362114'),
	(1122,119,'惠安县','362100'),
	(1123,119,'安溪县','362400'),
	(1124,119,'永春县','362600'),
	(1125,119,'德化县','362500'),
	(1126,119,'金门县','362000'),
	(1127,119,'石狮市','362700'),
	(1128,119,'晋江市','362200'),
	(1129,119,'南安市','362300'),
	(1130,119,'经济技术开发区','362005'),
	(1131,120,'芗城区','363000'),
	(1132,120,'龙文区','363005'),
	(1133,120,'云霄县','363300'),
	(1134,120,'漳浦县','363200'),
	(1135,120,'诏安县','363500'),
	(1136,120,'长泰县','363900'),
	(1137,120,'东山县','363400'),
	(1138,120,'南靖县','363600'),
	(1139,120,'平和县','363700'),
	(1140,120,'华安县','363800'),
	(1141,120,'龙海市','363100'),
	(1142,121,'延平区','353000'),
	(1143,121,'顺昌县','353200'),
	(1144,121,'浦城县','353400'),
	(1145,121,'光泽县','354100'),
	(1146,121,'松溪县','353500'),
	(1147,121,'政和县','353600'),
	(1148,121,'邵武市','354000'),
	(1149,121,'武夷山市','354300'),
	(1150,121,'建瓯市','353100'),
	(1151,121,'建阳市','354200'),
	(1152,122,'新罗区','364000'),
	(1153,122,'长汀县','366300'),
	(1154,122,'永定县','364100'),
	(1155,122,'上杭县','364200'),
	(1156,122,'武平县','364300'),
	(1157,122,'连城县','366200'),
	(1158,122,'漳平市','364400'),
	(1159,123,'蕉城区','352100'),
	(1160,123,'霞浦县','355100'),
	(1161,123,'古田县','352200'),
	(1162,123,'屏南县','352300'),
	(1163,123,'寿宁县','355500'),
	(1164,123,'周宁县','355400'),
	(1165,123,'柘荣县','355300'),
	(1166,123,'福安市','355000'),
	(1167,123,'福鼎市','355200'),
	(1168,124,'东湖区','330006'),
	(1169,124,'西湖区','330009'),
	(1170,124,'青云谱区','330001'),
	(1171,124,'湾里区','330004'),
	(1172,124,'青山湖区','330029'),
	(1173,124,'南昌县','330200'),
	(1174,124,'新建县','330100'),
	(1175,124,'安义县','330500'),
	(1176,124,'进贤县','331700'),
	(1177,124,'经济技术开发区','330013'),
	(1178,124,'红谷滩新区','330038'),
	(1179,124,'高新技术产业开发区','330029'),
	(1180,124,'桑海经济技术开发区','330115'),
	(1181,124,'英雄经济开发区','330200'),
	(1182,125,'昌江区','333000'),
	(1183,125,'珠山区','333000'),
	(1184,125,'浮梁县','333400'),
	(1185,125,'乐平市','333300'),
	(1186,126,'安源区','337000'),
	(1187,126,'湘东区','337016'),
	(1188,126,'莲花县','337100'),
	(1189,126,'上栗县','337009'),
	(1190,126,'芦溪县','337053'),
	(1191,127,'庐山区','332005'),
	(1192,127,'浔阳区','332000'),
	(1193,127,'九江县','332100'),
	(1194,127,'武宁县','332300'),
	(1195,127,'修水县','332400'),
	(1196,127,'永修县','330300'),
	(1197,127,'德安县','330400'),
	(1198,127,'星子县','332800'),
	(1199,127,'都昌县','332600'),
	(1200,127,'湖口县','332500'),
	(1201,127,'彭泽县','332700'),
	(1202,127,'瑞昌市','332200'),
	(1203,128,'渝水区','338025'),
	(1204,128,'分宜县','336600'),
	(1205,129,'月湖区','335000'),
	(1206,129,'余江县','335200'),
	(1207,129,'贵溪市','335400'),
	(1208,130,'章贡区','341000'),
	(1209,130,'赣县','341100'),
	(1210,130,'信丰县','341600'),
	(1211,130,'大余县','341500'),
	(1212,130,'上犹县','341200'),
	(1213,130,'崇义县','341300'),
	(1214,130,'安远县','342100'),
	(1215,130,'龙南县','341700'),
	(1216,130,'定南县','341900'),
	(1217,130,'全南县','341800'),
	(1218,130,'宁都县','342800'),
	(1219,130,'于都县','342300'),
	(1220,130,'兴国县','342400'),
	(1221,130,'会昌县','342600'),
	(1222,130,'寻乌县','342200'),
	(1223,130,'石城县','342700'),
	(1224,130,'瑞金市','342500'),
	(1225,130,'南康市','341400'),
	(1226,131,'吉州区','343000'),
	(1227,131,'青原区','343009'),
	(1228,131,'吉安县','343100'),
	(1229,131,'吉水县','331600'),
	(1230,131,'峡江县','331400'),
	(1231,131,'新干县','331300'),
	(1232,131,'永丰县','331500'),
	(1233,131,'泰和县','343700'),
	(1234,131,'遂川县','343900'),
	(1235,131,'万安县','343800'),
	(1236,131,'安福县','343200'),
	(1237,131,'永新县','343400'),
	(1238,131,'井冈山市','343600'),
	(1239,132,'袁州区','336000'),
	(1240,132,'奉新县','330700'),
	(1241,132,'万载县','336100'),
	(1242,132,'上高县','336400'),
	(1243,132,'宜丰县','336300'),
	(1244,132,'靖安县','330600'),
	(1245,132,'铜鼓县','336200'),
	(1246,132,'丰城市','331100'),
	(1247,132,'樟树市','331200'),
	(1248,132,'高安市','330800'),
	(1249,133,'临川区','344100'),
	(1250,133,'南城县','344700'),
	(1251,133,'黎川县','344600'),
	(1252,133,'南丰县','344500'),
	(1253,133,'崇仁县','344200'),
	(1254,133,'乐安县','344300'),
	(1255,133,'宜黄县','344400'),
	(1256,133,'金溪县','344800'),
	(1257,133,'资溪县','335300'),
	(1258,133,'东乡县','331800'),
	(1259,133,'广昌县','344900'),
	(1260,134,'信州区','334000'),
	(1261,134,'上饶县','334100'),
	(1262,134,'广丰县','334600'),
	(1263,134,'玉山县','334700'),
	(1264,134,'铅山县','334500'),
	(1265,134,'横峰县','334300'),
	(1266,134,'弋阳县','334400'),
	(1267,134,'余干县','335100'),
	(1268,134,'鄱阳县','333100'),
	(1269,134,'万年县','335500'),
	(1270,134,'婺源县','333200'),
	(1271,134,'德兴市','334200'),
	(1272,135,'历下区','250014'),
	(1273,135,'市中区','250001'),
	(1274,135,'槐荫区','250022'),
	(1275,135,'天桥区','250031'),
	(1276,135,'历城区','250100'),
	(1277,135,'长清区','250300'),
	(1278,135,'平阴县','250400'),
	(1279,135,'济阳县','251400'),
	(1280,135,'商河县','251600'),
	(1281,135,'章丘市','250200'),
	(1282,135,'高新区','250101'),
	(1283,135,'经济开发区','250300'),
	(1284,136,'市南区','266001'),
	(1285,136,'市北区','266011'),
	(1286,136,'四方区','266031'),
	(1287,136,'黄岛区','266500'),
	(1288,136,'崂山区','266100'),
	(1289,136,'李沧区','266021'),
	(1290,136,'城阳区','266041'),
	(1291,136,'胶州市','266300'),
	(1292,136,'即墨市','266200'),
	(1293,136,'平度市','266700'),
	(1294,136,'胶南市','266400'),
	(1295,136,'莱西市','266600'),
	(1296,137,'淄川区','255100'),
	(1297,137,'张店区','255022'),
	(1298,137,'博山区','255200'),
	(1299,137,'临淄区','255400'),
	(1300,137,'周村区','255300'),
	(1301,137,'桓台县','256400'),
	(1302,137,'高青县','256300'),
	(1303,137,'沂源县','256100'),
	(1304,137,'高新区','255086'),
	(1305,138,'市中区','277101'),
	(1306,138,'薛城区','277000'),
	(1307,138,'峄城区','277300'),
	(1308,138,'台儿庄区','277400'),
	(1309,138,'山亭区','277200'),
	(1310,138,'滕州市','277500'),
	(1311,139,'东营区','257029'),
	(1312,139,'河口区','257200'),
	(1313,139,'垦利县','257500'),
	(1314,139,'利津县','257400'),
	(1315,139,'广饶县','257300'),
	(1316,140,'芝罘区','264001'),
	(1317,140,'福山区','265500'),
	(1318,140,'牟平区','264100'),
	(1319,140,'莱山区','264600'),
	(1320,140,'长岛县','265800'),
	(1321,140,'龙口市','265700'),
	(1322,140,'莱阳市','265200'),
	(1323,140,'莱州市','261400'),
	(1324,140,'蓬莱市','265600'),
	(1325,140,'招远市','265400'),
	(1326,140,'栖霞市','265300'),
	(1327,140,'海阳市','265100'),
	(1328,140,'开发区','264006'),
	(1329,141,'潍城区','261021'),
	(1330,141,'寒亭区','261100'),
	(1331,141,'坊子区','261200'),
	(1332,141,'奎文区','261031'),
	(1333,141,'临朐县','262600'),
	(1334,141,'昌乐县','262400'),
	(1335,141,'青州市','262500'),
	(1336,141,'诸城市','262200'),
	(1337,141,'寿光市','262700'),
	(1338,141,'安丘市','262100'),
	(1339,141,'高密市','261500'),
	(1340,141,'昌邑市','261300'),
	(1341,141,'经济开发区','261061'),
	(1342,141,'滨海经济开发区','262737'),
	(1343,141,'高新技术开发区','261061'),
	(1344,141,'出口加工区','261205'),
	(1345,142,'市中区','272133'),
	(1346,142,'任城区','272113'),
	(1347,142,'微山县','277600'),
	(1348,142,'鱼台县','272300'),
	(1349,142,'金乡县','272200'),
	(1350,142,'嘉祥县','272400'),
	(1351,142,'汶上县','272501'),
	(1352,142,'泗水县','273200'),
	(1353,142,'梁山县','272600'),
	(1354,142,'曲阜市','273100'),
	(1355,142,'兖州市','272000'),
	(1356,142,'邹城市','273500'),
	(1357,143,'泰山区','271000'),
	(1358,143,'岱岳区','271000'),
	(1359,143,'宁阳县','271400'),
	(1360,143,'东平县','271500'),
	(1361,143,'新泰市','271200'),
	(1362,143,'肥城市','271600'),
	(1363,144,'环翠区','264200'),
	(1364,144,'文登市','264400'),
	(1365,144,'荣成市','264300'),
	(1366,144,'乳山市','264500'),
	(1367,144,'经济技术开发区','264205'),
	(1368,144,'高技术开发区','264209'),
	(1369,145,'东港区','276800'),
	(1370,145,'岚山区','276808'),
	(1371,145,'五莲县','272300'),
	(1372,145,'莒县','266500'),
	(1373,146,'莱城区','271100'),
	(1374,146,'钢城区','271100'),
	(1375,147,'兰山区','276002'),
	(1376,147,'罗庄区','276022'),
	(1377,147,'河东区','276034'),
	(1378,147,'沂南县','276300'),
	(1379,147,'郯城县','276100'),
	(1380,147,'沂水县','276400'),
	(1381,147,'苍山县','277700'),
	(1382,147,'费县','273400'),
	(1383,147,'平邑县','273300'),
	(1384,147,'莒南县','276600'),
	(1385,147,'蒙阴县','276200'),
	(1386,147,'临沭县','276700'),
	(1387,148,'德城区','253011'),
	(1388,148,'陵县','253500'),
	(1389,148,'宁津县','253400'),
	(1390,148,'庆云县','253700'),
	(1391,148,'临邑县','251500'),
	(1392,148,'齐河县','251100'),
	(1393,148,'平原县','253100'),
	(1394,148,'夏津县','253200'),
	(1395,148,'武城县','253300'),
	(1396,148,'乐陵市','253600'),
	(1397,148,'禹城市','251200'),
	(1398,149,'东昌府区','252000'),
	(1399,149,'阳谷县','252300'),
	(1400,149,'莘县','252400'),
	(1401,149,'茌平县','252100'),
	(1402,149,'东阿县','252200'),
	(1403,149,'冠县','252500'),
	(1404,149,'高唐县','252800'),
	(1405,149,'临清市','252600'),
	(1406,150,'滨城区','256613'),
	(1407,150,'惠民县','251700'),
	(1408,150,'阳信县','251800'),
	(1409,150,'无棣县','251900'),
	(1410,150,'沾化县','256800'),
	(1411,150,'博兴县','256500'),
	(1412,150,'邹平县','256200'),
	(1413,151,'牡丹区','274009'),
	(1414,151,'曹县','274400'),
	(1415,151,'单县','274300'),
	(1416,151,'成武县','274200'),
	(1417,151,'巨野县','274900'),
	(1418,151,'郓城县','274700'),
	(1419,151,'鄄城县','274600'),
	(1420,151,'定陶县','274100'),
	(1421,151,'东明县','274500'),
	(1422,152,'中原区','450007'),
	(1423,152,'二七区','450052'),
	(1424,152,'管城回族区','450000'),
	(1425,152,'金水区','450003'),
	(1426,152,'上街区','450041'),
	(1427,152,'中牟县','451450'),
	(1428,152,'巩义市','451200'),
	(1429,152,'荥阳市','450100'),
	(1430,152,'新密市','452300'),
	(1431,152,'新郑市','451100'),
	(1432,152,'登封市','452470'),
	(1433,152,'高新技术开发区','450001'),
	(1434,152,'惠济区','450053'),
	(1435,152,'经济技术开发区','450016'),
	(1436,152,'郑东新区','450008'),
	(1437,152,'出口加工区','450016'),
	(1438,153,'龙亭区','475100'),
	(1439,153,'顺河回族区','475000'),
	(1440,153,'鼓楼区','475000'),
	(1441,153,'杞县','475200'),
	(1442,153,'通许县','475400'),
	(1443,153,'尉氏县','475500'),
	(1444,153,'开封县','475100'),
	(1445,153,'兰考县','475300'),
	(1446,153,'金明区','475003'),
	(1447,153,'禹王台区','475003'),
	(1448,154,'老城区','471002'),
	(1449,154,'西工区','471000'),
	(1450,154,'瀍河回族区','471002'),
	(1451,154,'涧西区','471003'),
	(1452,154,'吉利区','471012'),
	(1453,154,'洛龙区','471000'),
	(1454,154,'孟津县','471100'),
	(1455,154,'新安县','471800'),
	(1456,154,'栾川县','471500'),
	(1457,154,'嵩县','471400'),
	(1458,154,'汝阳县','471200'),
	(1459,154,'宜阳县','471600'),
	(1460,154,'洛宁县','471700'),
	(1461,154,'伊川县','471300'),
	(1462,154,'偃师市','471900'),
	(1463,154,'高新技术开发区','471003'),
	(1464,154,'经济技术开发区','471023'),
	(1465,155,'新华区','467002'),
	(1466,155,'卫东区','467021'),
	(1467,155,'石龙区','467045'),
	(1468,155,'湛河区','467000'),
	(1469,155,'宝丰县','467400'),
	(1470,155,'叶县','467200'),
	(1471,155,'鲁山县','467300'),
	(1472,155,'郏县','467100'),
	(1473,155,'舞钢市','462500'),
	(1474,155,'汝州市','467500'),
	(1475,156,'文峰区','455000'),
	(1476,156,'北关区','455001'),
	(1477,156,'殷都区','455004'),
	(1478,156,'龙安区','455001'),
	(1479,156,'安阳县','455000'),
	(1480,156,'汤阴县','456150'),
	(1481,156,'滑县','456400'),
	(1482,156,'内黄县','456350'),
	(1483,156,'林州市','456500'),
	(1484,157,'鹤山区','458010'),
	(1485,157,'山城区','458000'),
	(1486,157,'淇滨区','458000'),
	(1487,157,'浚县','456250'),
	(1488,157,'淇县','456750'),
	(1489,158,'红旗区','453000'),
	(1490,158,'卫滨区','453000'),
	(1491,158,'凤泉区','453011'),
	(1492,158,'牧野区','453002'),
	(1493,158,'新乡县','453700'),
	(1494,158,'获嘉县','453800'),
	(1495,158,'原阳县','453500'),
	(1496,158,'延津县','453200'),
	(1497,158,'封丘县','453300'),
	(1498,158,'长垣县','453400'),
	(1499,158,'卫辉市','453100'),
	(1500,158,'辉县市','453600'),
	(1501,159,'解放区','454000'),
	(1502,159,'中站区','454191'),
	(1503,159,'马村区','454171'),
	(1504,159,'山阳区','454002'),
	(1505,159,'修武县','454350'),
	(1506,159,'博爱县','454450'),
	(1507,159,'武陟县','454950'),
	(1508,159,'温县','454850'),
	(1509,159,'沁阳市','454550'),
	(1510,159,'孟州市','454750'),
	(1511,160,'华龙区','457001'),
	(1512,160,'清丰县','457300'),
	(1513,160,'南乐县','457400'),
	(1514,160,'范县','457500'),
	(1515,160,'台前县','457600'),
	(1516,160,'濮阳县','457100'),
	(1517,161,'魏都区','461000'),
	(1518,161,'许昌县','461100'),
	(1519,161,'鄢陵县','461200'),
	(1520,161,'襄城县','461700'),
	(1521,161,'禹州市','461670'),
	(1522,161,'长葛市','461500'),
	(1523,162,'源汇区','462000'),
	(1524,162,'郾城区','462300'),
	(1525,162,'召陵区','462300'),
	(1526,162,'舞阳县','462400'),
	(1527,162,'临颍县','462600'),
	(1528,163,'湖滨区','472000'),
	(1529,163,'渑池县','472400'),
	(1530,163,'陕县','472100'),
	(1531,163,'卢氏县','472200'),
	(1532,163,'义马市','472300'),
	(1533,163,'灵宝市','472500'),
	(1534,164,'宛城区','473001'),
	(1535,164,'卧龙区','473003'),
	(1536,164,'南召县','474650'),
	(1537,164,'方城县','473200'),
	(1538,164,'西峡县','474550'),
	(1539,164,'镇平县','474250'),
	(1540,164,'内乡县','474350'),
	(1541,164,'淅川县','474450'),
	(1542,164,'社旗县','473300'),
	(1543,164,'唐河县','473400'),
	(1544,164,'新野县','473500'),
	(1545,164,'桐柏县','474750'),
	(1546,164,'邓州市','474150'),
	(1547,165,'梁园区','476000'),
	(1548,165,'睢阳区','476100'),
	(1549,165,'民权县','476800'),
	(1550,165,'睢县','476900'),
	(1551,165,'宁陵县','476700'),
	(1552,165,'柘城县','476200'),
	(1553,165,'虞城县','476300'),
	(1554,165,'夏邑县','476400'),
	(1555,165,'永城市','476600'),
	(1556,166,'浉河区','464000'),
	(1557,166,'平桥区','464100'),
	(1558,166,'罗山县','464200'),
	(1559,166,'光山县','465450'),
	(1560,166,'新县','465550'),
	(1561,166,'商城县','465350'),
	(1562,166,'固始县','465250'),
	(1563,166,'潢川县','465150'),
	(1564,166,'淮滨县','464400'),
	(1565,166,'息县','464300'),
	(1566,167,'川汇区','466000'),
	(1567,167,'扶沟县','461300'),
	(1568,167,'西华县','466600'),
	(1569,167,'商水县','466100'),
	(1570,167,'沈丘县','466300'),
	(1571,167,'郸城县','477150'),
	(1572,167,'淮阳县','466700'),
	(1573,167,'太康县','461400'),
	(1574,167,'鹿邑县','477200'),
	(1575,167,'项城市','466200'),
	(1576,168,'驿城区','463000'),
	(1577,168,'西平县','463900'),
	(1578,168,'上蔡县','463800'),
	(1579,168,'平舆县','463400'),
	(1580,168,'正阳县','463600'),
	(1581,168,'确山县','463200'),
	(1582,168,'泌阳县','463700'),
	(1583,168,'汝南县','463300'),
	(1584,168,'遂平县','463100'),
	(1585,168,'新蔡县','463500'),
	(1586,169,'济源市','454650'),
	(1587,170,'江岸区','430014'),
	(1588,170,'江汉区','430021'),
	(1589,170,'硚口区','430033'),
	(1590,170,'汉阳区','430050'),
	(1591,170,'武昌区','430061'),
	(1592,170,'青山区','430080'),
	(1593,170,'洪山区','430070'),
	(1594,170,'东西湖区','430040'),
	(1595,170,'汉南区','430090'),
	(1596,170,'蔡甸区','430100'),
	(1597,170,'江夏区','430200'),
	(1598,170,'黄陂区','432200'),
	(1599,170,'新洲区','431400'),
	(1600,171,'黄石港区','435000'),
	(1601,171,'西塞山区','435001'),
	(1602,171,'下陆区','435005'),
	(1603,171,'铁山区','435006'),
	(1604,171,'阳新县','435200'),
	(1605,171,'大冶市','435100'),
	(1606,172,'茅箭区','442012'),
	(1607,172,'张湾区','442001'),
	(1608,172,'郧县','442500'),
	(1609,172,'郧西县','442600'),
	(1610,172,'竹山县','442200'),
	(1611,172,'竹溪县','442300'),
	(1612,172,'房县','442100'),
	(1613,172,'丹江口市','442700'),
	(1614,173,'西陵区','443000'),
	(1615,173,'伍家岗区','443001'),
	(1616,173,'点军区','443006'),
	(1617,173,'虢亭区','443007'),
	(1618,173,'夷陵区','443100'),
	(1619,173,'远安县','444200'),
	(1620,173,'兴山县','443711'),
	(1621,173,'秭归县','443600'),
	(1622,173,'长阳土家族自治县','443500'),
	(1623,173,'五峰土家族自治县','443400'),
	(1624,173,'宜都市','443300'),
	(1625,173,'当阳市','444100'),
	(1626,173,'枝江市','443200'),
	(1627,173,'经济技术开发区','443003'),
	(1628,174,'襄城区','441021'),
	(1629,174,'樊城区','441001'),
	(1630,174,'襄阳区','441100'),
	(1631,174,'南漳县','441500'),
	(1632,174,'谷城县','441700'),
	(1633,174,'保康县','441600'),
	(1634,174,'老河口市','441800'),
	(1635,174,'枣阳市','441200'),
	(1636,174,'宜城市','441400'),
	(1637,175,'梁子湖区','436064'),
	(1638,175,'华容区','436030'),
	(1639,175,'鄂城区','436000'),
	(1640,176,'东宝区','448004'),
	(1641,176,'掇刀区','448124'),
	(1642,176,'京山县','431800'),
	(1643,176,'沙洋县','448200'),
	(1644,176,'钟祥市','431900'),
	(1645,177,'孝南区','432100'),
	(1646,177,'孝昌县','432900'),
	(1647,177,'大悟县','432800'),
	(1648,177,'云梦县','432500'),
	(1649,177,'应城市','432400'),
	(1650,177,'安陆市','432600'),
	(1651,177,'汉川市','432300'),
	(1652,178,'沙市区','434000'),
	(1653,178,'荆州区','434020'),
	(1654,178,'公安县','434300'),
	(1655,178,'监利县','433300'),
	(1656,178,'江陵县','434101'),
	(1657,178,'石首市','434400'),
	(1658,178,'洪湖市','433200'),
	(1659,178,'松滋市','434200'),
	(1660,179,'黄州区','438000'),
	(1661,179,'团风县','438000'),
	(1662,179,'红安县','438401'),
	(1663,179,'罗田县','438600'),
	(1664,179,'英山县','438700'),
	(1665,179,'浠水县','438200'),
	(1666,179,'蕲春县','435300'),
	(1667,179,'黄梅县','435500'),
	(1668,179,'麻城市','438300'),
	(1669,179,'武穴市','435400'),
	(1670,180,'咸安区','437000'),
	(1671,180,'嘉鱼县','437200'),
	(1672,180,'通城县','437400'),
	(1673,180,'崇阳县','437500'),
	(1674,180,'通山县','437600'),
	(1675,180,'赤壁市','437300'),
	(1676,181,'曾都区','441300'),
	(1677,181,'广水市','432700'),
	(1678,182,'恩施市','445000'),
	(1679,182,'利川市','445400'),
	(1680,182,'建始县','445300'),
	(1681,182,'巴东县','444300'),
	(1682,182,'宣恩县','445500'),
	(1683,182,'咸丰县','445600'),
	(1684,182,'来凤县','445700'),
	(1685,182,'鹤峰县','445800'),
	(1686,183,'仙桃市','433000'),
	(1687,183,'潜江市','433100'),
	(1688,183,'天门市','431700'),
	(1689,183,'神农架林区','442400'),
	(1690,184,'芙蓉区','410011'),
	(1691,184,'天心区','410011'),
	(1692,184,'岳麓区','410006'),
	(1693,184,'开福区','410008'),
	(1694,184,'雨花区','410011'),
	(1695,184,'长沙县','410100'),
	(1696,184,'望城县','410200'),
	(1697,184,'宁乡县','410600'),
	(1698,184,'浏阳市','410300'),
	(1699,185,'荷塘区','412000'),
	(1700,185,'芦淞区','412000'),
	(1701,185,'石峰区','412005'),
	(1702,185,'天元区','412007'),
	(1703,185,'株洲县','412100'),
	(1704,185,'攸县','412300'),
	(1705,185,'茶陵县','412400'),
	(1706,185,'炎陵县','412500'),
	(1707,185,'醴陵市','412200'),
	(1708,186,'雨湖区','411100'),
	(1709,186,'岳塘区','411101'),
	(1710,186,'湘潭县','411228'),
	(1711,186,'湘乡市','411400'),
	(1712,186,'韶山市','411300'),
	(1713,187,'珠晖区','421002'),
	(1714,187,'雁峰区','421001'),
	(1715,187,'石鼓区','421001'),
	(1716,187,'蒸湘区','421001'),
	(1717,187,'南岳区','421900'),
	(1718,187,'衡阳县','421200'),
	(1719,187,'衡南县','421131'),
	(1720,187,'衡山县','421300'),
	(1721,187,'衡东县','421400'),
	(1722,187,'祁东县','421600'),
	(1723,187,'耒阳市','421800'),
	(1724,187,'常宁市','421500'),
	(1725,188,'双清区','422001'),
	(1726,188,'大祥区','422000'),
	(1727,188,'北塔区','422007'),
	(1728,188,'邵东县','422800'),
	(1729,188,'新邵县','422900'),
	(1730,188,'邵阳县','422100'),
	(1731,188,'隆回县','422200'),
	(1732,188,'洞口县','422300'),
	(1733,188,'绥宁县','422600'),
	(1734,188,'新宁县','422700'),
	(1735,188,'城步苗族自治县','422500'),
	(1736,188,'武冈市','422400'),
	(1737,189,'岳阳楼区','414000'),
	(1738,189,'云溪区','414009'),
	(1739,189,'君山区','414005'),
	(1740,189,'岳阳县','414100'),
	(1741,189,'华容县','414200'),
	(1742,189,'湘阴县','410500'),
	(1743,189,'平江县','414500'),
	(1744,189,'汨罗市','414400'),
	(1745,189,'临湘市','414300'),
	(1746,190,'武陵区','415000'),
	(1747,190,'鼎城区','415101'),
	(1748,190,'安乡县','415600'),
	(1749,190,'汉寿县','415900'),
	(1750,190,'澧县','415500'),
	(1751,190,'临澧县','415200'),
	(1752,190,'桃源县','415700'),
	(1753,190,'石门县','415300'),
	(1754,190,'津市市','415400'),
	(1755,191,'永定区','427000'),
	(1756,191,'武陵源区','427400'),
	(1757,191,'慈利县','427200'),
	(1758,191,'桑植县','427100'),
	(1759,192,'资阳区','413001'),
	(1760,192,'赫山区','413002'),
	(1761,192,'南县','413200'),
	(1762,192,'桃江县','413400'),
	(1763,192,'安化县','413500'),
	(1764,192,'沅江市','413100'),
	(1765,193,'北湖区','423000'),
	(1766,193,'苏仙区','423000'),
	(1767,193,'桂阳县','424400'),
	(1768,193,'宜章县','424200'),
	(1769,193,'永兴县','423300'),
	(1770,193,'嘉禾县','424500'),
	(1771,193,'临武县','424300'),
	(1772,193,'汝城县','424100'),
	(1773,193,'桂东县','423500'),
	(1774,193,'安仁县','423600'),
	(1775,193,'资兴市','423400'),
	(1776,194,'冷水滩区','425100'),
	(1777,194,'祁阳县','426100'),
	(1778,194,'东安县','425900'),
	(1779,194,'双牌县','425200'),
	(1780,194,'道县','425300'),
	(1781,194,'江永县','425400'),
	(1782,194,'宁远县','425600'),
	(1783,194,'蓝山县','425800'),
	(1784,194,'新田县','425700'),
	(1785,194,'江华瑶族自治县','425500'),
	(1786,194,'零陵区','425002'),
	(1787,195,'鹤城区','418000'),
	(1788,195,'中方县','418005'),
	(1789,195,'沅陵县','419600'),
	(1790,195,'辰溪县','419500'),
	(1791,195,'溆浦县','419300'),
	(1792,195,'会同县','418300'),
	(1793,195,'麻阳苗族自治县','419400'),
	(1794,195,'新晃侗族自治县','419200'),
	(1795,195,'芷江侗族自治县','419100'),
	(1796,195,'靖州苗族侗族自治县','418400'),
	(1797,195,'通道侗族自治县','418500'),
	(1798,195,'洪江市','418116'),
	(1799,196,'娄星区','417000'),
	(1800,196,'双峰县','417700'),
	(1801,196,'新化县','417600'),
	(1802,196,'冷水江市','417500'),
	(1803,196,'涟源市','417100'),
	(1804,197,'吉首市','416000'),
	(1805,197,'泸溪县','416100'),
	(1806,197,'凤凰县','416200'),
	(1807,197,'花垣县','416400'),
	(1808,197,'保靖县','416500'),
	(1809,197,'古丈县','416300'),
	(1810,197,'永顺县','416700'),
	(1811,197,'龙山县','416800'),
	(1812,198,'荔湾区','510145'),
	(1813,198,'越秀区','510030'),
	(1814,198,'海珠区','510220'),
	(1815,198,'天河区','510630'),
	(1816,198,'白云区','510080'),
	(1817,198,'黄埔区','510700'),
	(1818,198,'番禺区','511400'),
	(1819,198,'花都区','510800'),
	(1820,198,'增城市','511300'),
	(1821,198,'从化市','510900'),
	(1822,198,'南沙区','511400'),
	(1823,198,'萝岗区','510100'),
	(1824,199,'武江区','512026'),
	(1825,199,'浈江区','512023'),
	(1826,199,'曲江区','512100'),
	(1827,199,'始兴县','512500'),
	(1828,199,'仁化县','512300'),
	(1829,199,'翁源县','512600'),
	(1830,199,'乳源瑶族自治县','512700'),
	(1831,199,'新丰县','511100'),
	(1832,199,'乐昌市','512200'),
	(1833,199,'南雄市','512400'),
	(1834,200,'罗湖区','518001'),
	(1835,200,'福田区','518033'),
	(1836,200,'南山区','518052'),
	(1837,200,'宝安区','518101'),
	(1838,200,'龙岗区','518116'),
	(1839,200,'盐田区','518083'),
	(1840,200,'光明新区','518107'),
	(1841,200,'坪山新区','518118'),
	(1842,201,'香洲区','519000'),
	(1843,201,'斗门区','519100'),
	(1844,201,'金湾区','519090'),
	(1845,202,'龙湖区','515041'),
	(1846,202,'金平区','515041'),
	(1847,202,'濠江区','515071'),
	(1848,202,'潮阳区','515100'),
	(1849,202,'潮南区','515144'),
	(1850,202,'澄海区','515800'),
	(1851,202,'南澳县','515900'),
	(1852,203,'禅城区','528000'),
	(1853,203,'南海区','528200'),
	(1854,203,'顺德区','528300'),
	(1855,203,'三水区','528100'),
	(1856,203,'高明区','528500'),
	(1857,204,'蓬江区','529051'),
	(1858,204,'江海区','529000'),
	(1859,204,'新会区','529100'),
	(1860,204,'台山市','529211'),
	(1861,204,'开平市','529312'),
	(1862,204,'鹤山市','529711'),
	(1863,204,'恩平市','529411'),
	(1864,205,'赤坎区','524033'),
	(1865,205,'霞山区','524002'),
	(1866,205,'坡头区','524057'),
	(1867,205,'麻章区','524003'),
	(1868,205,'遂溪县','524300'),
	(1869,205,'徐闻县','524100'),
	(1870,205,'廉江市','524400'),
	(1871,205,'雷州市','524200'),
	(1872,205,'吴川市','524500'),
	(1873,205,'开发区','524022'),
	(1874,206,'茂南区','525011'),
	(1875,206,'茂港区','525027'),
	(1876,206,'电白县','525400'),
	(1877,206,'高州市','525200'),
	(1878,206,'化州市','525100'),
	(1879,206,'信宜市','525300'),
	(1880,207,'端州区','526040'),
	(1881,207,'鼎湖区','526070'),
	(1882,207,'广宁县','526300'),
	(1883,207,'怀集县','526400'),
	(1884,207,'封开县','526500'),
	(1885,207,'德庆县','526600'),
	(1886,207,'高要市','526100'),
	(1887,207,'四会市','526200'),
	(1888,207,'高新技术产业开发区','526238'),
	(1889,208,'惠城区','516001'),
	(1890,208,'惠阳区','516200'),
	(1891,208,'博罗县','516100'),
	(1892,208,'惠东县','516300'),
	(1893,208,'龙门县','516800'),
	(1894,208,'大亚湾区','516080'),
	(1895,208,'仲恺高新区','516080'),
	(1896,209,'梅江区','514000'),
	(1897,209,'梅县','514733'),
	(1898,209,'大埔县','514200'),
	(1899,209,'丰顺县','514300'),
	(1900,209,'五华县','514400'),
	(1901,209,'平远县','514600'),
	(1902,209,'蕉岭县','514100'),
	(1903,209,'兴宁市','514500'),
	(1904,210,'城区','516601'),
	(1905,210,'陆丰市','516500'),
	(1906,210,'海丰县','516400'),
	(1907,210,'陆河县','516700'),
	(1908,211,'源城区','517000'),
	(1909,211,'紫金县','517400'),
	(1910,211,'龙川县','517300'),
	(1911,211,'连平县','517100'),
	(1912,211,'和平县','517200'),
	(1913,211,'东源县','517500'),
	(1914,212,'江城区','529525'),
	(1915,212,'阳西县','529800'),
	(1916,212,'阳东县','529931'),
	(1917,212,'阳春市','529611'),
	(1918,213,'清城区','511500'),
	(1919,213,'佛冈县','511600'),
	(1920,213,'阳山县','513100'),
	(1921,213,'连山壮族瑶族自治县','513200'),
	(1922,213,'连南瑶族自治县','513300'),
	(1923,213,'清新县','511800'),
	(1924,213,'英德市','513000'),
	(1925,213,'连州市','513401'),
	(1926,214,'南城区','523000'),
	(1927,214,'石龙镇','523021'),
	(1928,214,'长安镇','523068'),
	(1929,214,'虎门镇','523061'),
	(1930,214,'横沥镇','523032'),
	(1931,214,'寮步镇','523058'),
	(1932,214,'黄江镇','523054'),
	(1933,214,'清溪镇','523046'),
	(1934,214,'莞城区','523000'),
	(1935,214,'万江区','523050'),
	(1936,214,'东城区','523000'),
	(1937,214,'石碣镇','523024'),
	(1938,214,'茶山镇','523029'),
	(1939,214,'石排镇','523025'),
	(1940,214,'企石镇','523027'),
	(1941,214,'桥头镇','523038'),
	(1942,214,'谢岗镇','523044'),
	(1943,214,'东坑镇','523034'),
	(1944,214,'常平镇','523036'),
	(1945,214,'大朗镇','523056'),
	(1946,214,'塘厦镇','523710'),
	(1947,214,'凤岗镇','523048'),
	(1948,214,'厚街镇','523071'),
	(1949,214,'沙田镇','523073'),
	(1950,214,'道滘镇','523170'),
	(1951,214,'洪梅镇','523083'),
	(1952,214,'麻涌镇','523078'),
	(1953,214,'中堂镇','523075'),
	(1954,214,'高埗镇','523270'),
	(1955,214,'樟木头镇','523041'),
	(1956,214,'大岭山镇','523074'),
	(1957,214,'望牛墩镇','523077'),
	(1958,215,'中山市','528403'),
	(1959,216,'湘桥区','521000'),
	(1960,216,'潮安县','515638'),
	(1961,216,'饶平县','515700'),
	(1962,217,'榕城区','522095'),
	(1963,217,'揭东县','515554'),
	(1964,217,'揭西县','515400'),
	(1965,217,'惠来县','515200'),
	(1966,217,'普宁市','515300'),
	(1967,217,'东山区','522031'),
	(1968,217,'普侨区','515339'),
	(1969,217,'大南山侨区','515237'),
	(1970,218,'云城区','527300'),
	(1971,218,'新兴县','527400'),
	(1972,218,'郁南县','527100'),
	(1973,218,'云安县','527500'),
	(1974,218,'罗定市','527200'),
	(1975,219,'兴宁区','530012'),
	(1976,219,'青秀区','530022'),
	(1977,219,'江南区','530031'),
	(1978,219,'西乡塘区','530001'),
	(1979,219,'良庆区','530200'),
	(1980,219,'邕宁区','530200'),
	(1981,219,'武鸣县','530100'),
	(1982,219,'隆安县','532700'),
	(1983,219,'马山县','530600'),
	(1984,219,'上林县','530500'),
	(1985,219,'宾阳县','530400'),
	(1986,219,'横县','530300'),
	(1987,220,'城中区','545001'),
	(1988,220,'鱼峰区','545005'),
	(1989,220,'柳南区','545005'),
	(1990,220,'柳北区','545001'),
	(1991,220,'柳江县','545100'),
	(1992,220,'柳城县','545200'),
	(1993,220,'鹿寨县','545600'),
	(1994,220,'融安县','545400'),
	(1995,220,'融水苗族自治县','545300'),
	(1996,220,'三江侗族自治县','545500'),
	(1997,221,'秀峰区','541001'),
	(1998,221,'叠彩区','541001'),
	(1999,221,'象山区','541002'),
	(2000,221,'七星区','541004'),
	(2001,221,'雁山区','541006'),
	(2002,221,'阳朔县','541900'),
	(2003,221,'临桂县','541100'),
	(2004,221,'灵川县','541200'),
	(2005,221,'全州县','541500'),
	(2006,221,'兴安县','541300'),
	(2007,221,'永福县','541800'),
	(2008,221,'灌阳县','541600'),
	(2009,221,'龙胜各族自治县','541700'),
	(2010,221,'资源县','541400'),
	(2011,221,'平乐县','542400'),
	(2012,221,'荔浦县','546600'),
	(2013,221,'恭城瑶族自治县','542500'),
	(2014,222,'万秀区','543000'),
	(2015,222,'蝶山区','543002'),
	(2016,222,'长洲区','543002'),
	(2017,222,'苍梧县','543100'),
	(2018,222,'藤县','543300'),
	(2019,222,'蒙山县','546700'),
	(2020,222,'岑溪市','543200'),
	(2021,223,'海城区','536000'),
	(2022,223,'银海区','536000'),
	(2023,223,'铁山港区','536017'),
	(2024,223,'合浦县','536100'),
	(2025,224,'港口区','538001'),
	(2026,224,'防城区','538021'),
	(2027,224,'上思县','535500'),
	(2028,224,'东兴市','538100'),
	(2029,225,'钦南区','535000'),
	(2030,225,'钦北区','535000'),
	(2031,225,'灵山县','535400'),
	(2032,225,'浦北县','535300'),
	(2033,225,'钦州港经济开发区','535008'),
	(2034,226,'港北区','537100'),
	(2035,226,'港南区','537132'),
	(2036,226,'覃塘区','537121'),
	(2037,226,'平南县','537300'),
	(2038,226,'桂平市','537200'),
	(2039,227,'玉州区','537000'),
	(2040,227,'容县','537500'),
	(2041,227,'陆川县','537700'),
	(2042,227,'博白县','537600'),
	(2043,227,'兴业县','537800'),
	(2044,227,'北流市','537400'),
	(2045,228,'右江区','533000'),
	(2046,228,'田阳县','533600'),
	(2047,228,'田东县','531500'),
	(2048,228,'平果县','531400'),
	(2049,228,'德保县','533700'),
	(2050,228,'靖西县','533800'),
	(2051,228,'那坡县','533900'),
	(2052,228,'凌云县','533100'),
	(2053,228,'乐业县','533200'),
	(2054,228,'田林县','533300'),
	(2055,228,'西林县','533500'),
	(2056,228,'隆林各族自治县','533400'),
	(2057,229,'八步区','542800'),
	(2058,229,'昭平县','546800'),
	(2059,229,'钟山县','542600'),
	(2060,229,'富川瑶族自治县','542700'),
	(2061,230,'金城江区','547000'),
	(2062,230,'南丹县','547200'),
	(2063,230,'天峨县','547300'),
	(2064,230,'凤山县','547600'),
	(2065,230,'东兰县','547400'),
	(2066,230,'罗城仫佬族自治县','546400'),
	(2067,230,'环江毛南族自治县','547100'),
	(2068,230,'巴马瑶族自治县','547500'),
	(2069,230,'都安瑶族自治县','530700'),
	(2070,230,'大化瑶族自治县','530800'),
	(2071,230,'宜州市','546300'),
	(2072,231,'兴宾区','546100'),
	(2073,231,'忻城县','546200'),
	(2074,231,'象州县','545800'),
	(2075,231,'武宣县','545900'),
	(2076,231,'金秀瑶族自治县','545700'),
	(2077,231,'合山市','546500'),
	(2078,232,'江洲区','532200'),
	(2079,232,'扶绥县','532100'),
	(2080,232,'宁明县','532500'),
	(2081,232,'龙州县','532400'),
	(2082,232,'大新县','532300'),
	(2083,232,'天等县','532800'),
	(2084,232,'凭祥市','532600'),
	(2085,233,'秀英区','570311'),
	(2086,233,'龙华区','570105'),
	(2087,233,'琼山区','571100'),
	(2088,233,'美兰区','570203'),
	(2089,234,'河西区','572000'),
	(2090,234,'河东区','572000'),
	(2091,234,'田独镇','572011'),
	(2092,234,'凤凰镇','572023'),
	(2093,234,'三亚市','572000'),
	(2094,234,'崖城镇','572025'),
	(2095,234,'天涯镇','572029'),
	(2096,234,'育才乡','572032'),
	(2097,234,'海棠湾镇','572014'),
	(2098,235,'五指山市','572200'),
	(2099,235,'琼海市','571400'),
	(2100,235,'儋州市','571700'),
	(2101,235,'文昌市','571300'),
	(2102,235,'万宁市','571500'),
	(2103,235,'东方市','572600'),
	(2104,235,'定安县','571200'),
	(2105,235,'屯昌县','571600'),
	(2106,235,'澄迈县','571900'),
	(2107,235,'临高县','571800'),
	(2108,235,'白沙黎族自治县','572800'),
	(2109,235,'昌江黎族自治县','572700'),
	(2110,235,'乐东黎族自治县','572500'),
	(2111,235,'陵水黎族自治县','572400'),
	(2112,235,'保亭黎族苗族自治县','572300'),
	(2113,235,'琼中黎族苗族自治县','572900'),
	(2114,235,'西、南、中沙群岛办事处','573100'),
	(2115,236,'万州区','404100'),
	(2116,236,'涪陵区','408000'),
	(2117,236,'渝中区','400010'),
	(2118,236,'大渡口区','400080'),
	(2119,236,'江北区','400020'),
	(2120,236,'沙坪坝区','400030'),
	(2121,236,'九龙坡区','400050'),
	(2122,236,'南岸区','400064'),
	(2123,236,'北碚区','400700'),
	(2124,236,'万盛区','400800'),
	(2125,236,'双桥区','400900'),
	(2126,236,'渝北区','401120'),
	(2127,236,'巴南区','401320'),
	(2128,236,'黔江区','409700'),
	(2129,236,'长寿区','401220'),
	(2130,236,'綦江县','401420'),
	(2131,236,'潼南县','402660'),
	(2132,236,'铜梁县','402560'),
	(2133,236,'大足县','402360'),
	(2134,236,'荣昌县','402460'),
	(2135,236,'璧山县','402760'),
	(2136,236,'梁平县','405200'),
	(2137,236,'城口县','405900'),
	(2138,236,'丰都县','408200'),
	(2139,236,'垫江县','408300'),
	(2140,236,'武隆县','408500'),
	(2141,236,'忠县','404300'),
	(2142,236,'开县','405400'),
	(2143,236,'云阳县','404500'),
	(2144,236,'奉节县','404600'),
	(2145,236,'巫山县','404700'),
	(2146,236,'巫溪县','405800'),
	(2147,236,'石柱土家族自治县','409100'),
	(2148,236,'秀山土家族苗族自治县','409900'),
	(2149,236,'酉阳土家族苗族自治县','409800'),
	(2150,236,'彭水苗族土家族自治县','409600'),
	(2151,236,'高新区','400039'),
	(2152,236,'江津区','402260'),
	(2153,236,'合川区','401520'),
	(2154,236,'永川区','402160'),
	(2155,236,'南川区','408400'),
	(2156,237,'锦江区','610021'),
	(2157,237,'青羊区','610031'),
	(2158,237,'金牛区','610036'),
	(2159,237,'武侯区','610041'),
	(2160,237,'成华区','610066'),
	(2161,237,'龙泉驿区','610100'),
	(2162,237,'青白江区','610300'),
	(2163,237,'新都区','610500'),
	(2164,237,'温江区','611130'),
	(2165,237,'金堂县','610400'),
	(2166,237,'双流县','610200'),
	(2167,237,'郫县','611700'),
	(2168,237,'大邑县','611300'),
	(2169,237,'蒲江县','611630'),
	(2170,237,'新津县','611430'),
	(2171,237,'都江堰市','611830'),
	(2172,237,'彭州市','611930'),
	(2173,237,'邛崃市','611530'),
	(2174,237,'崇州市','611230'),
	(2175,237,'高新区','610041'),
	(2176,237,'高新西区','611731'),
	(2177,238,'自流井区','643000'),
	(2178,238,'贡井区','643020'),
	(2179,238,'大安区','643010'),
	(2180,238,'沿滩区','643030'),
	(2181,238,'荣县','643100'),
	(2182,238,'富顺县','643200'),
	(2183,239,'东区','617067'),
	(2184,239,'西区','617068'),
	(2185,239,'仁和区','617061'),
	(2186,239,'米易县','617200'),
	(2187,239,'盐边县','617100'),
	(2188,240,'江阳区','646000'),
	(2189,240,'纳溪区','646300'),
	(2190,240,'龙马潭区','646000'),
	(2191,240,'泸县','646106'),
	(2192,240,'合江县','646200'),
	(2193,240,'叙永县','646400'),
	(2194,240,'古蔺县','646500'),
	(2195,241,'旌阳区','618000'),
	(2196,241,'中江县','618100'),
	(2197,241,'罗江县','618500'),
	(2198,241,'广汉市','618300'),
	(2199,241,'什邡市','618400'),
	(2200,241,'绵竹市','618200'),
	(2201,242,'涪城区','621000'),
	(2202,242,'游仙区','621022'),
	(2203,242,'三台县','621100'),
	(2204,242,'盐亭县','621600'),
	(2205,242,'安县','622650'),
	(2206,242,'梓潼县','622150'),
	(2207,242,'北川羌族自治县','622750'),
	(2208,242,'平武县','622550'),
	(2209,242,'江油市','621700'),
	(2210,242,'农科区','621023'),
	(2211,242,'经济技术开发区','621000'),
	(2212,242,'高新区','621000'),
	(2213,242,'仙海区','621007'),
	(2214,243,'利州区','628017'),
	(2215,243,'元坝区','628017'),
	(2216,243,'朝天区','628017'),
	(2217,243,'旺苍县','628200'),
	(2218,243,'青川县','628100'),
	(2219,243,'剑阁县','628300'),
	(2220,243,'苍溪县','628400'),
	(2221,244,'船山区','629000'),
	(2222,244,'安居区','629000'),
	(2223,244,'蓬溪县','629100'),
	(2224,244,'射洪县','629200'),
	(2225,244,'大英县','629300'),
	(2226,245,'市中区','641000'),
	(2227,245,'东兴区','641100'),
	(2228,245,'威远县','642450'),
	(2229,245,'资中县','641200'),
	(2230,245,'隆昌县','642150'),
	(2231,246,'市中区','614000'),
	(2232,246,'沙湾区','614900'),
	(2233,246,'五通桥区','614800'),
	(2234,246,'金口河区','614700'),
	(2235,246,'犍为县','614400'),
	(2236,246,'井研县','613100'),
	(2237,246,'夹江县','614100'),
	(2238,246,'沐川县','614500'),
	(2239,246,'峨边彝族自治县','614300'),
	(2240,246,'马边彝族自治县','614600'),
	(2241,246,'峨眉山市','614200'),
	(2242,247,'顺庆区','637000'),
	(2243,247,'高坪区','637100'),
	(2244,247,'嘉陵区','637100'),
	(2245,247,'南部县','637300'),
	(2246,247,'营山县','637700'),
	(2247,247,'蓬安县','637800'),
	(2248,247,'仪陇县','637600'),
	(2249,247,'西充县','637200'),
	(2250,247,'阆中市','637400'),
	(2251,248,'东坡区','620010'),
	(2252,248,'仁寿县','620500'),
	(2253,248,'彭山县','620860'),
	(2254,248,'洪雅县','620360'),
	(2255,248,'丹棱县','620200'),
	(2256,248,'青神县','620460'),
	(2257,249,'翠屏区','644000'),
	(2258,249,'宜宾县','644600'),
	(2259,249,'南溪县','644100'),
	(2260,249,'江安县','644200'),
	(2261,249,'长宁县','644300'),
	(2262,249,'高县','645150'),
	(2263,249,'珙县','644500'),
	(2264,249,'筠连县','645250'),
	(2265,249,'兴文县','644400'),
	(2266,249,'屏山县','645350'),
	(2267,250,'广安区','638000'),
	(2268,250,'岳池县','638300'),
	(2269,250,'武胜县','638400'),
	(2270,250,'邻水县','638500'),
	(2271,250,'华蓥市','638600'),
	(2272,251,'通川区','635000'),
	(2273,251,'达县','635000'),
	(2274,251,'宣汉县','636150'),
	(2275,251,'开江县','636250'),
	(2276,251,'大竹县','635100'),
	(2277,251,'渠县','635200'),
	(2278,251,'万源市','636350'),
	(2279,252,'雨城区','625000'),
	(2280,252,'名山县','625100'),
	(2281,252,'荥经县','625200'),
	(2282,252,'汉源县','625300'),
	(2283,252,'石棉县','625400'),
	(2284,252,'天全县','625500'),
	(2285,252,'芦山县','625600'),
	(2286,252,'宝兴县','625700'),
	(2287,253,'巴州区','636001'),
	(2288,253,'通江县','636700'),
	(2289,253,'南江县','636600'),
	(2290,253,'平昌县','636400'),
	(2291,254,'雁江区','641300'),
	(2292,254,'安岳县','642350'),
	(2293,254,'乐至县','641500'),
	(2294,254,'简阳市','641400'),
	(2295,255,'汶川县','623000'),
	(2296,255,'理县','623100'),
	(2297,255,'茂县','623200'),
	(2298,255,'松潘县','623300'),
	(2299,255,'九寨沟县','623400'),
	(2300,255,'金川县','624100'),
	(2301,255,'小金县','624200'),
	(2302,255,'黑水县','623500'),
	(2303,255,'马尔康县','624000'),
	(2304,255,'壤塘县','624300'),
	(2305,255,'阿坝县','624600'),
	(2306,255,'若尔盖县','624500'),
	(2307,255,'红原县','624400'),
	(2308,256,'康定县','626000'),
	(2309,256,'泸定县','626100'),
	(2310,256,'丹巴县','626300'),
	(2311,256,'九龙县','626200'),
	(2312,256,'雅江县','627450'),
	(2313,256,'道孚县','626400'),
	(2314,256,'炉霍县','626500'),
	(2315,256,'甘孜县','626700'),
	(2316,256,'新龙县','626800'),
	(2317,256,'德格县','627250'),
	(2318,256,'白玉县','627150'),
	(2319,256,'石渠县','627350'),
	(2320,256,'色达县','626600'),
	(2321,256,'理塘县','627550'),
	(2322,256,'巴塘县','627650'),
	(2323,256,'乡城县','627850'),
	(2324,256,'稻城县','627750'),
	(2325,256,'得荣县','627950'),
	(2326,257,'西昌市','615000'),
	(2327,257,'木里藏族自治县','615800'),
	(2328,257,'盐源县','615700'),
	(2329,257,'德昌县','615500'),
	(2330,257,'会理县','615100'),
	(2331,257,'会东县','615200'),
	(2332,257,'宁南县','615400'),
	(2333,257,'普格县','615300'),
	(2334,257,'布拖县','615350'),
	(2335,257,'金阳县','616250'),
	(2336,257,'昭觉县','616150'),
	(2337,257,'喜德县','616750'),
	(2338,257,'冕宁县','615600'),
	(2339,257,'越西县','616650'),
	(2340,257,'甘洛县','616850'),
	(2341,257,'美姑县','616450'),
	(2342,257,'雷波县','616550'),
	(2343,258,'南明区','550001'),
	(2344,258,'云岩区','550001'),
	(2345,258,'花溪区','550025'),
	(2346,258,'乌当区','550018'),
	(2347,258,'白云区','550014'),
	(2348,258,'小河区','550009'),
	(2349,258,'开阳县','550300'),
	(2350,258,'息烽县','551100'),
	(2351,258,'修文县','550200'),
	(2352,258,'清镇市','551400'),
	(2353,258,'金阳新区','550081'),
	(2354,259,'钟山区','553000'),
	(2355,259,'六枝特区','553400'),
	(2356,259,'水城县','553000'),
	(2357,259,'盘县','561601'),
	(2358,260,'红花岗区','563000'),
	(2359,260,'汇川区','563000'),
	(2360,260,'遵义县','563100'),
	(2361,260,'桐梓县','563200'),
	(2362,260,'绥阳县','563300'),
	(2363,260,'正安县','563400'),
	(2364,260,'道真仡佬族苗族自治县','563500'),
	(2365,260,'务川仡佬族苗族自治县','564300'),
	(2366,260,'凤冈县','564200'),
	(2367,260,'湄潭县','564100'),
	(2368,260,'余庆县','564400'),
	(2369,260,'习水县','564600'),
	(2370,260,'赤水市','564700'),
	(2371,260,'仁怀市','564500'),
	(2372,261,'西秀区','561000'),
	(2373,261,'平坝县','561100'),
	(2374,261,'普定县','562100'),
	(2375,261,'镇宁布依族苗族自治县','561200'),
	(2376,261,'关岭布依族苗族自治县','561300'),
	(2377,261,'紫云苗族布依族自治县','550800'),
	(2378,262,'铜仁市','554300'),
	(2379,262,'江口县','554400'),
	(2380,262,'玉屏侗族自治县','554004'),
	(2381,262,'石阡县','555100'),
	(2382,262,'思南县','565100'),
	(2383,262,'印江土家族苗族自治县','555200'),
	(2384,262,'德江县','565200'),
	(2385,262,'沿河土家族自治县','565300'),
	(2386,262,'松桃苗族自治县','554100'),
	(2387,262,'万山特区','554200'),
	(2388,263,'兴义市','562400'),
	(2389,263,'兴仁县','562300'),
	(2390,263,'普安县','561500'),
	(2391,263,'晴隆县','561400'),
	(2392,263,'贞丰县','562200'),
	(2393,263,'望谟县','552300'),
	(2394,263,'册亨县','552200'),
	(2395,263,'安龙县','552400'),
	(2396,264,'毕节市','551700'),
	(2397,264,'大方县','551600'),
	(2398,264,'黔西县','551500'),
	(2399,264,'金沙县','551800'),
	(2400,264,'织金县','552100'),
	(2401,264,'纳雍县','553300'),
	(2402,264,'威宁彝族回族苗族自治县','553100'),
	(2403,264,'赫章县','553200'),
	(2404,265,'凯里市','556000'),
	(2405,265,'黄平县','556100'),
	(2406,265,'施秉县','556200'),
	(2407,265,'三穗县','556500'),
	(2408,265,'镇远县','557700'),
	(2409,265,'岑巩县','557800'),
	(2410,265,'天柱县','556600'),
	(2411,265,'锦屏县','556700'),
	(2412,265,'剑河县','556400'),
	(2413,265,'台江县','556300'),
	(2414,265,'黎平县','557300'),
	(2415,265,'榕江县','557200'),
	(2416,265,'从江县','557400'),
	(2417,265,'雷山县','557100'),
	(2418,265,'麻江县','557600'),
	(2419,265,'丹寨县','557500'),
	(2420,266,'都匀市','558000'),
	(2421,266,'福泉市','550500'),
	(2422,266,'荔波县','558400'),
	(2423,266,'贵定县','551300'),
	(2424,266,'瓮安县','550400'),
	(2425,266,'独山县','558200'),
	(2426,266,'平塘县','558300'),
	(2427,266,'罗甸县','550100'),
	(2428,266,'长顺县','550700'),
	(2429,266,'龙里县','551200'),
	(2430,266,'惠水县','550600'),
	(2431,266,'三都水族自治县','558100'),
	(2432,267,'五华区','650032'),
	(2433,267,'盘龙区','650051'),
	(2434,267,'官渡区','650220'),
	(2435,267,'西山区','650100'),
	(2436,267,'东川区','654100'),
	(2437,267,'呈贡县','650500'),
	(2438,267,'晋宁县','650600'),
	(2439,267,'富民县','650400'),
	(2440,267,'宜良县','652100'),
	(2441,267,'石林彝族自治县','652200'),
	(2442,267,'嵩明县','651700'),
	(2443,267,'禄劝彝族苗族自治县','651500'),
	(2444,267,'寻甸回族彝族自治县','655200'),
	(2445,267,'安宁市','650300'),
	(2446,268,'麒麟区','655000'),
	(2447,268,'马龙县','655100'),
	(2448,268,'陆良县','655600'),
	(2449,268,'师宗县','655700'),
	(2450,268,'罗平县','655800'),
	(2451,268,'富源县','655500'),
	(2452,268,'会泽县','654200'),
	(2453,268,'沾益县','655331'),
	(2454,268,'宣威市','655400'),
	(2455,269,'红塔区','653100'),
	(2456,269,'江川县','652600'),
	(2457,269,'澄江县','652500'),
	(2458,269,'通海县','652700'),
	(2459,269,'华宁县','652800'),
	(2460,269,'易门县','651100'),
	(2461,269,'峨山彝族自治县','653200'),
	(2462,269,'新平彝族傣族自治县','653400'),
	(2463,269,'元江哈尼族彝族傣族自治县','653300'),
	(2464,270,'隆阳区','678000'),
	(2465,270,'施甸县','678200'),
	(2466,270,'腾冲县','679100'),
	(2467,270,'龙陵县','678300'),
	(2468,270,'昌宁县','678100'),
	(2469,271,'昭阳区','657000'),
	(2470,271,'鲁甸县','657100'),
	(2471,271,'巧家县','654600'),
	(2472,271,'盐津县','657500'),
	(2473,271,'大关县','657400'),
	(2474,271,'永善县','657300'),
	(2475,271,'绥江县','657700'),
	(2476,271,'镇雄县','657200'),
	(2477,271,'彝良县','657600'),
	(2478,271,'威信县','657900'),
	(2479,271,'水富县','657800'),
	(2480,272,'古城区','674100'),
	(2481,272,'玉龙纳西族自治县','674100'),
	(2482,272,'永胜县','674200'),
	(2483,272,'华坪县','674800'),
	(2484,272,'宁蒗彝族自治县','674300'),
	(2485,273,'思茅区','665000'),
	(2486,273,'宁洱哈尼族彝族自治县','665100'),
	(2487,273,'墨江哈尼族自治县','654800'),
	(2488,273,'景东彝族自治县','676200'),
	(2489,273,'景谷傣族彝族自治县','666400'),
	(2490,273,'镇沅彝族哈尼族拉祜族自治县','666500'),
	(2491,273,'江城哈尼族彝族自治县','665900'),
	(2492,273,'孟连傣族拉祜族佤族自治县','665800'),
	(2493,273,'澜沧拉祜族自治县','665600'),
	(2494,273,'西盟佤族自治县','665700'),
	(2495,274,'临翔区','677000'),
	(2496,274,'凤庆县','675900'),
	(2497,274,'云县','675800'),
	(2498,274,'永德县','677600'),
	(2499,274,'镇康县','677704'),
	(2500,274,'双江拉祜族佤族布朗族傣族自治县','677300'),
	(2501,274,'耿马傣族佤族自治县','677500'),
	(2502,274,'沧源佤族自治县','677400'),
	(2503,275,'楚雄市','675000'),
	(2504,275,'双柏县','675100'),
	(2505,275,'牟定县','675500'),
	(2506,275,'南华县','675200'),
	(2507,275,'姚安县','675300'),
	(2508,275,'大姚县','675400'),
	(2509,275,'永仁县','651400'),
	(2510,275,'元谋县','651300'),
	(2511,275,'武定县','651600'),
	(2512,275,'禄丰县','651200'),
	(2513,276,'个旧市','661000'),
	(2514,276,'开远市','661600'),
	(2515,276,'蒙自县','661100'),
	(2516,276,'屏边苗族自治县','661200'),
	(2517,276,'建水县','654300'),
	(2518,276,'石屏县','662200'),
	(2519,276,'弥勒县','652300'),
	(2520,276,'泸西县','652400'),
	(2521,276,'元阳县','662400'),
	(2522,276,'红河县','654400'),
	(2523,276,'金平苗族瑶族傣族自治县','661500'),
	(2524,276,'绿春县','662500'),
	(2525,276,'河口瑶族自治县','661300'),
	(2526,277,'文山县','663000'),
	(2527,277,'砚山县','663100'),
	(2528,277,'西畴县','663500'),
	(2529,277,'麻栗坡县','663600'),
	(2530,277,'马关县','663700'),
	(2531,277,'丘北县','663200'),
	(2532,277,'广南县','663300'),
	(2533,277,'富宁县','663400'),
	(2534,278,'景洪市','666100'),
	(2535,278,'勐海县','666200'),
	(2536,278,'勐腊县','666300'),
	(2537,279,'大理市','671000'),
	(2538,279,'漾濞彝族自治县','672500'),
	(2539,279,'祥云县','672100'),
	(2540,279,'宾川县','671600'),
	(2541,279,'弥渡县','675600'),
	(2542,279,'南涧彝族自治县','675700'),
	(2543,279,'巍山彝族回族自治县','672400'),
	(2544,279,'永平县','672600'),
	(2545,279,'云龙县','672700'),
	(2546,279,'洱源县','671200'),
	(2547,279,'剑川县','671300'),
	(2548,279,'鹤庆县','671500'),
	(2549,280,'瑞丽市','678600'),
	(2550,280,'潞西市','678400'),
	(2551,280,'梁河县','679200'),
	(2552,280,'盈江县','679300'),
	(2553,280,'陇川县','678700'),
	(2554,281,'泸水县','673100'),
	(2555,281,'福贡县','673400'),
	(2556,281,'贡山独龙族怒族自治县','673500'),
	(2557,281,'兰坪白族普米族自治县','671400'),
	(2558,282,'香格里拉县','674400'),
	(2559,282,'德钦县','674500'),
	(2560,282,'维西傈僳族自治县','674600'),
	(2561,283,'城关区','850000'),
	(2562,283,'林周县','852000'),
	(2563,283,'当雄县','851500'),
	(2564,283,'尼木县','851300'),
	(2565,283,'曲水县','850600'),
	(2566,283,'堆龙德庆县','851400'),
	(2567,283,'达孜县','850100'),
	(2568,283,'墨竹工卡县','850200'),
	(2569,284,'昌都县','854000'),
	(2570,284,'江达县','854100'),
	(2571,284,'贡觉县','854200'),
	(2572,284,'类乌齐县','855600'),
	(2573,284,'丁青县','855700'),
	(2574,284,'察雅县','854300'),
	(2575,284,'八宿县','854600'),
	(2576,284,'左贡县','854400'),
	(2577,284,'芒康县','854500'),
	(2578,284,'洛隆县','855400'),
	(2579,284,'边坝县','855500'),
	(2580,285,'乃东县','856100'),
	(2581,285,'扎囊县','850800'),
	(2582,285,'贡嘎县','850700'),
	(2583,285,'桑日县','856200'),
	(2584,285,'琼结县','856800'),
	(2585,285,'曲松县','856300'),
	(2586,285,'措美县','856900'),
	(2587,285,'洛扎县','851200'),
	(2588,285,'加查县','856400'),
	(2589,285,'隆子县','856600'),
	(2590,285,'错那县','856700'),
	(2591,285,'浪卡子县','851000'),
	(2592,286,'日喀则市','857000'),
	(2593,286,'南木林县','857100'),
	(2594,286,'江孜县','857400'),
	(2595,286,'定日县','858200'),
	(2596,286,'萨迦县','857800'),
	(2597,286,'拉孜县','858100'),
	(2598,286,'昂仁县','858500'),
	(2599,286,'谢通门县','858900'),
	(2600,286,'白朗县','857300'),
	(2601,286,'仁布县','857200'),
	(2602,286,'康马县','857500'),
	(2603,286,'定结县','857900'),
	(2604,286,'仲巴县','858800'),
	(2605,286,'亚东县','857600'),
	(2606,286,'吉隆县','858700'),
	(2607,286,'聂拉木县','858300'),
	(2608,286,'萨嘎县','857800'),
	(2609,286,'岗巴县','857700'),
	(2610,287,'那曲县','852000'),
	(2611,287,'嘉黎县','852400'),
	(2612,287,'比如县','852300'),
	(2613,287,'聂荣县','853500'),
	(2614,287,'安多县','852600'),
	(2615,287,'申扎县','853100'),
	(2616,287,'索县','852200'),
	(2617,287,'班戈县','852500'),
	(2618,287,'巴青县','852100'),
	(2619,287,'尼玛县','853200'),
	(2620,288,'普兰县','859500'),
	(2621,288,'札达县','859600'),
	(2622,288,'噶尔县','859400'),
	(2623,288,'日土县','859700'),
	(2624,288,'革吉县','859100'),
	(2625,288,'改则县','859200'),
	(2626,288,'措勤县','859300'),
	(2627,289,'林芝县','850400'),
	(2628,289,'工布江达县','850300'),
	(2629,289,'米林县','860500'),
	(2630,289,'墨脱县','855300'),
	(2631,289,'波密县','855200'),
	(2632,289,'察隅县','855100'),
	(2633,289,'朗县','856500'),
	(2634,290,'新城区','710004'),
	(2635,290,'碑林区','710001'),
	(2636,290,'莲湖区','710003'),
	(2637,290,'灞桥区','710038'),
	(2638,290,'未央区','710014'),
	(2639,290,'雁塔区','710061'),
	(2640,290,'阎良区','710087'),
	(2641,290,'临潼区','710600'),
	(2642,290,'长安区','710100'),
	(2643,290,'蓝田县','710500'),
	(2644,290,'周至县','710400'),
	(2645,290,'户县','710300'),
	(2646,290,'高陵县','710200'),
	(2647,290,'高新区','710075'),
	(2648,291,'王益区','727000'),
	(2649,291,'印台区','727007'),
	(2650,291,'耀州区','727100'),
	(2651,291,'宜君县','727200'),
	(2652,291,'新区','727100'),
	(2653,292,'渭滨区','721000'),
	(2654,292,'金台区','721000'),
	(2655,292,'陈仓区','721300'),
	(2656,292,'凤翔县','721400'),
	(2657,292,'岐山县','722400'),
	(2658,292,'扶风县','722200'),
	(2659,292,'眉县','722300'),
	(2660,292,'陇县','721200'),
	(2661,292,'千阳县','721100'),
	(2662,292,'麟游县','721500'),
	(2663,292,'凤县','721700'),
	(2664,292,'太白县','721600'),
	(2665,293,'秦都区','712000'),
	(2666,293,'渭城区','712000'),
	(2667,293,'杨陵区','712100'),
	(2668,293,'三原县','713800'),
	(2669,293,'泾阳县','713700'),
	(2670,293,'兴平市','713100'),
	(2671,293,'乾县','713300'),
	(2672,293,'礼泉县','713200'),
	(2673,293,'永寿县','713400'),
	(2674,293,'彬县','713500'),
	(2675,293,'长武县','713600'),
	(2676,293,'旬邑县','711300'),
	(2677,293,'淳化县','711200'),
	(2678,293,'武功县','712200'),
	(2679,294,'临渭区','714000'),
	(2680,294,'华县','714100'),
	(2681,294,'潼关县','714300'),
	(2682,294,'大荔县','715100'),
	(2683,294,'合阳县','715300'),
	(2684,294,'澄城县','715200'),
	(2685,294,'蒲城县','715500'),
	(2686,294,'白水县','715600'),
	(2687,294,'富平县','711700'),
	(2688,294,'韩城市','715400'),
	(2689,294,'华阴市','714200'),
	(2690,295,'宝塔区','716000'),
	(2691,295,'延长县','717100'),
	(2692,295,'延川县','717200'),
	(2693,295,'子长县','717300'),
	(2694,295,'安塞县','717400'),
	(2695,295,'志丹县','717500'),
	(2696,295,'吴旗县','717600'),
	(2697,295,'甘泉县','716100'),
	(2698,295,'富县','727500'),
	(2699,295,'洛川县','727400'),
	(2700,295,'宜川县','716200'),
	(2701,295,'黄龙县','715700'),
	(2702,295,'黄陵县','727300'),
	(2703,296,'汉台区','723000'),
	(2704,296,'南郑县','723100'),
	(2705,296,'城固县','723200'),
	(2706,296,'洋县','723300'),
	(2707,296,'西乡县','723500'),
	(2708,296,'勉县','724200'),
	(2709,296,'宁强县','724400'),
	(2710,296,'略阳县','724300'),
	(2711,296,'镇巴县','723600'),
	(2712,296,'留坝县','724100'),
	(2713,296,'佛坪县','723400'),
	(2714,296,'经济开发区','723000'),
	(2715,297,'榆阳区','719000'),
	(2716,297,'神木县','719300'),
	(2717,297,'府谷县','719400'),
	(2718,297,'横山县','719100'),
	(2719,297,'靖边县','718500'),
	(2720,297,'定边县','718600'),
	(2721,297,'绥德县','718000'),
	(2722,297,'米脂县','718100'),
	(2723,297,'佳县','719200'),
	(2724,297,'吴堡县','718200'),
	(2725,297,'清涧县','718300'),
	(2726,297,'子洲县','718400'),
	(2727,298,'汉滨区','725000'),
	(2728,298,'汉阴县','725100'),
	(2729,298,'石泉县','725200'),
	(2730,298,'宁陕县','711600'),
	(2731,298,'紫阳县','725300'),
	(2732,298,'岚皋县','725400'),
	(2733,298,'平利县','725500'),
	(2734,298,'镇坪县','725600'),
	(2735,298,'旬阳县','725700'),
	(2736,298,'白河县','725800'),
	(2737,299,'商州区','726000'),
	(2738,299,'洛南县','726100'),
	(2739,299,'丹凤县','726200'),
	(2740,299,'商南县','726300'),
	(2741,299,'山阳县','726400'),
	(2742,299,'镇安县','711500'),
	(2743,299,'柞水县','711400'),
	(2744,300,'城关区','730030'),
	(2745,300,'七里河区','730050'),
	(2746,300,'西固区','730060'),
	(2747,300,'安宁区','730070'),
	(2748,300,'红古区','730080'),
	(2749,300,'永登县','730300'),
	(2750,300,'皋兰县','730200'),
	(2751,300,'榆中县','730100'),
	(2752,301,'嘉峪关市','735100'),
	(2753,302,'金川区','737103'),
	(2754,302,'永昌县','737200'),
	(2755,303,'白银区','730900'),
	(2756,303,'平川区','730913'),
	(2757,303,'靖远县','730600'),
	(2758,303,'会宁县','730700'),
	(2759,303,'景泰县','730400'),
	(2760,304,'秦州区','741000'),
	(2761,304,'麦积区','741020'),
	(2762,304,'清水县','741400'),
	(2763,304,'秦安县','741600'),
	(2764,304,'甘谷县','741200'),
	(2765,304,'武山县','741300'),
	(2766,304,'张家川回族自治县','741500'),
	(2767,305,'凉州区','733000'),
	(2768,305,'民勤县','733300'),
	(2769,305,'古浪县','733100'),
	(2770,305,'天祝藏族自治县','733200'),
	(2771,306,'甘州区','734000'),
	(2772,306,'肃南裕固族自治县','734400'),
	(2773,306,'民乐县','734500'),
	(2774,306,'临泽县','734200'),
	(2775,306,'高台县','734300'),
	(2776,306,'山丹县','734100'),
	(2777,307,'崆峒区','744000'),
	(2778,307,'泾川县','744300'),
	(2779,307,'灵台县','744400'),
	(2780,307,'崇信县','744200'),
	(2781,307,'华亭县','744100'),
	(2782,307,'庄浪县','744600'),
	(2783,307,'静宁县','743400'),
	(2784,308,'肃州区','735000'),
	(2785,308,'金塔县','735300'),
	(2786,308,'安西县','736100'),
	(2787,308,'肃北蒙古族自治县','736300'),
	(2788,308,'阿克塞哈萨克族自治县','736400'),
	(2789,308,'玉门市','735200'),
	(2790,308,'敦煌市','736200'),
	(2791,309,'西峰区','745000'),
	(2792,309,'庆城县','745100'),
	(2793,309,'环县','745700'),
	(2794,309,'华池县','745600'),
	(2795,309,'合水县','745400'),
	(2796,309,'正宁县','745300'),
	(2797,309,'宁县','745200'),
	(2798,309,'镇原县','744500'),
	(2799,310,'安定区','744300'),
	(2800,310,'通渭县','743300'),
	(2801,310,'陇西县','748100'),
	(2802,310,'渭源县','748200'),
	(2803,310,'临洮县','730500'),
	(2804,310,'漳县','748300'),
	(2805,310,'岷县','748400'),
	(2806,311,'武都区','746000'),
	(2807,311,'成县','742500'),
	(2808,311,'文县','746400'),
	(2809,311,'宕昌县','748500'),
	(2810,311,'康县','746500'),
	(2811,311,'西和县','742100'),
	(2812,311,'礼县','742200'),
	(2813,311,'徽县','742300'),
	(2814,311,'两当县','742400'),
	(2815,312,'临夏市','731100'),
	(2816,312,'临夏县','731800'),
	(2817,312,'康乐县','731500'),
	(2818,312,'永靖县','731600'),
	(2819,312,'广河县','731300'),
	(2820,312,'和政县','731200'),
	(2821,312,'东乡族自治县','731400'),
	(2822,312,'积石山保安族东乡族撒拉族自治县','731700'),
	(2823,313,'合作市','747000'),
	(2824,313,'临潭县','747500'),
	(2825,313,'卓尼县','747600'),
	(2826,313,'舟曲县','746300'),
	(2827,313,'迭部县','747400'),
	(2828,313,'玛曲县','747300'),
	(2829,313,'碌曲县','747200'),
	(2830,313,'夏河县','747100'),
	(2831,314,'城东区','810000'),
	(2832,314,'城中区','810000'),
	(2833,314,'城西区','810000'),
	(2834,314,'城北区','810000'),
	(2835,314,'大通回族土族自治县','810100'),
	(2836,314,'湟中县','811600'),
	(2837,314,'湟源县','812100'),
	(2838,315,'平安县','810600'),
	(2839,315,'民和回族土族自治县','810800'),
	(2840,315,'乐都县','810700'),
	(2841,315,'互助土族自治县','810500'),
	(2842,315,'化隆回族自治县','810900'),
	(2843,315,'循化撒拉族自治县','811100'),
	(2844,316,'门源回族自治县','810300'),
	(2845,316,'祁连县','810400'),
	(2846,316,'海晏县','812200'),
	(2847,316,'刚察县','812300'),
	(2848,317,'同仁县','811300'),
	(2849,317,'尖扎县','811200'),
	(2850,317,'泽库县','811400'),
	(2851,317,'河南蒙古族自治县','811500'),
	(2852,318,'共和县','813000'),
	(2853,318,'同德县','813200'),
	(2854,318,'贵德县','811700'),
	(2855,318,'兴海县','813300'),
	(2856,318,'贵南县','813100'),
	(2857,319,'玛沁县','814000'),
	(2858,319,'班玛县','814300'),
	(2859,319,'甘德县','814100'),
	(2860,319,'达日县','814200'),
	(2861,319,'久治县','624700'),
	(2862,319,'玛多县','813500'),
	(2863,320,'玉树县','815000'),
	(2864,320,'杂多县','815300'),
	(2865,320,'称多县','815100'),
	(2866,320,'治多县','815400'),
	(2867,320,'囊谦县','815200'),
	(2868,320,'曲麻莱县','815500'),
	(2869,321,'格尔木市','816000'),
	(2870,321,'德令哈市','817000'),
	(2871,321,'乌兰县','817100'),
	(2872,321,'都兰县','816100'),
	(2873,321,'天峻县','817200'),
	(2874,321,'大柴旦行委','817300'),
	(2875,322,'兴庆区','750001'),
	(2876,322,'西夏区','750021'),
	(2877,322,'金凤区','750011'),
	(2878,322,'永宁县','750100'),
	(2879,322,'贺兰县','750200'),
	(2880,322,'灵武市','750004'),
	(2881,323,'大武口区','753000'),
	(2882,323,'惠农区','753600'),
	(2883,323,'平罗县','753400'),
	(2884,324,'利通区','751100'),
	(2885,324,'盐池县','751500'),
	(2886,324,'同心县','751300'),
	(2887,324,'青铜峡市','751600'),
	(2888,325,'原州区','756000'),
	(2889,325,'西吉县','756200'),
	(2890,325,'隆德县','756300'),
	(2891,325,'泾源县','756400'),
	(2892,325,'彭阳县','756500'),
	(2893,326,'沙坡头区','755000'),
	(2894,326,'中宁县','755100'),
	(2895,326,'海原县','755200'),
	(2896,327,'天山区','830000'),
	(2897,327,'沙依巴克区','830002'),
	(2898,327,'新市区','830011'),
	(2899,327,'水磨沟区','830017'),
	(2900,327,'头屯河区','830022'),
	(2901,327,'达坂城区','830039'),
	(2902,327,'米东区','830019'),
	(2903,327,'乌鲁木齐县','830063'),
	(2904,328,'独山子区','834021'),
	(2905,328,'克拉玛依区','834000'),
	(2906,328,'白碱滩区','834008'),
	(2907,328,'乌尔禾区','834012'),
	(2908,329,'吐鲁番市','838000'),
	(2909,329,'鄯善县','838200'),
	(2910,329,'托克逊县','838100'),
	(2911,330,'哈密市','839000'),
	(2912,330,'巴里坤哈萨克自治县','839200'),
	(2913,330,'伊吾县','839300'),
	(2914,331,'昌吉市','831100'),
	(2915,331,'阜康市','831500'),
	(2916,331,'米泉市','831400'),
	(2917,331,'呼图壁县','831200'),
	(2918,331,'玛纳斯县','832200'),
	(2919,331,'奇台县','831800'),
	(2920,331,'吉木萨尔县','831700'),
	(2921,331,'木垒哈萨克自治县','831900'),
	(2922,332,'博乐市','833400'),
	(2923,332,'精河县','833300'),
	(2924,332,'温泉县','833500'),
	(2925,333,'库尔勒市','841000'),
	(2926,333,'轮台县','841600'),
	(2927,333,'尉犁县','841500'),
	(2928,333,'若羌县','841800'),
	(2929,333,'且末县','841900'),
	(2930,333,'焉耆回族自治县','841100'),
	(2931,333,'和静县','841300'),
	(2932,333,'和硕县','841200'),
	(2933,333,'博湖县','841400'),
	(2934,334,'阿克苏市','843000'),
	(2935,334,'温宿县','843100'),
	(2936,334,'库车县','842000'),
	(2937,334,'沙雅县','842200'),
	(2938,334,'新和县','842100'),
	(2939,334,'拜城县','842300'),
	(2940,334,'乌什县','843400'),
	(2941,334,'阿瓦提县','843200'),
	(2942,334,'柯坪县','843600'),
	(2943,335,'阿图什市','845350'),
	(2944,335,'阿克陶县','845550'),
	(2945,335,'阿合奇县','843500'),
	(2946,335,'乌恰县','845450'),
	(2947,336,'喀什市','844000'),
	(2948,336,'疏附县','844100'),
	(2949,336,'疏勒县','844200'),
	(2950,336,'英吉沙县','844500'),
	(2951,336,'泽普县','844800'),
	(2952,336,'莎车县','844700'),
	(2953,336,'叶城县','844900'),
	(2954,336,'麦盖提县','844600'),
	(2955,336,'岳普湖县','844400'),
	(2956,336,'伽师县','844300'),
	(2957,336,'巴楚县','843800'),
	(2958,336,'塔什库尔干塔吉克自治县','845250'),
	(2959,337,'和田市','848000'),
	(2960,337,'和田县','848000'),
	(2961,337,'墨玉县','848100'),
	(2962,337,'皮山县','845150'),
	(2963,337,'洛浦县','848200'),
	(2964,337,'策勒县','848300'),
	(2965,337,'于田县','848400'),
	(2966,337,'民丰县','848500'),
	(2967,338,'伊宁市','835000'),
	(2968,338,'奎屯市','833200'),
	(2969,338,'伊宁县','835100'),
	(2970,338,'察布查尔锡伯自治县','835300'),
	(2971,338,'霍城县','835200'),
	(2972,338,'巩留县','835400'),
	(2973,338,'新源县','835800'),
	(2974,338,'昭苏县','835600'),
	(2975,338,'特克斯县','835500'),
	(2976,338,'尼勒克县','835700'),
	(2977,339,'塔城市','834700'),
	(2978,339,'乌苏市','833300'),
	(2979,339,'额敏县','834600'),
	(2980,339,'沙湾县','832100'),
	(2981,339,'托里县','834500'),
	(2982,339,'裕民县','834800'),
	(2983,339,'和布克赛尔蒙古自治县','834400'),
	(2984,340,'阿勒泰市','836500'),
	(2985,340,'布尔津县','836600'),
	(2986,340,'富蕴县','836100'),
	(2987,340,'福海县','836400'),
	(2988,340,'哈巴河县','836700'),
	(2989,340,'青河县','836200'),
	(2990,340,'吉木乃县','836800'),
	(2991,341,'石河子市','832000'),
	(2992,341,'阿拉尔市','843300'),
	(2993,341,'图木舒克市','843806'),
	(2994,341,'五家渠市','831300'),
	(2995,342,'香港','860600'),
	(2996,343,'澳门','860700'),
	(2997,344,'台湾','860800');

/*!40000 ALTER TABLE `district` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table factory_action_logs
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_action_logs`;

CREATE TABLE `factory_action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT '0' COMMENT '登陆的用户id',
  `user_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户名',
  `cp_id` int(11) DEFAULT NULL COMMENT '产品id',
  `order_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '收件，整件，发件，打印条码，给客户发快递',
  `content` text COLLATE utf8_unicode_ci COMMENT '详细描述',
  `old_data` text COLLATE utf8_unicode_ci,
  `ip` varchar(60) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'ip地址',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table factory_api_app
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_api_app`;

CREATE TABLE `factory_api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='appId和appSecret表';



# Dump of table factory_api_fields
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_api_fields`;

CREATE TABLE `factory_api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用于保存各个API的字段规则';



# Dump of table factory_api_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_api_list`;

CREATE TABLE `factory_api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用于维护接口信息';



# Dump of table factory_app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_app_version`;

CREATE TABLE `factory_app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';



# Dump of table factory_c_sysconfig
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_c_sysconfig`;

CREATE TABLE `factory_c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table factory_cp
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_cp`;

CREATE TABLE `factory_cp` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '产品id,与订单产品表id一致',
  `fid` int(11) DEFAULT NULL COMMENT 'c_foundryprojecttable表主键id',
  `itemnum` int(11) DEFAULT NULL COMMENT '产品id，正常件才有，返工件为null',
  `fmid` int(11) DEFAULT NULL COMMENT 'c_foundryitemstable表主键id，返工件才有，正常件为null',
  `mid` int(11) DEFAULT NULL COMMENT '维修件ID，返工件才有，正常件为null',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品标题',
  `cp_status` tinyint(2) DEFAULT '1' COMMENT '0:待收件，1:待整件，2:待发件，3:已发件，4:已快递给客户',
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sorting` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品项，正常件才有，返工件为null',
  `number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用于打印的唯一条码',
  `qrcode` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二维码图片地址',
  `cp_sj_uid` int(11) DEFAULT NULL,
  `cp_sj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_sj_time` datetime DEFAULT NULL,
  `cp_zj_uid` int(11) DEFAULT NULL,
  `cp_zj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_zj_time` datetime DEFAULT NULL,
  `cp_fj_uid` int(11) DEFAULT NULL,
  `cp_fj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_fj_time` datetime DEFAULT NULL,
  `express_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '快递单号',
  `express_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '快递名称',
  `express_time` datetime DEFAULT NULL COMMENT '快递时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table factory_express
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_express`;

CREATE TABLE `factory_express` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `express_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '快递单号',
  `express_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '快递名称',
  `express_money` decimal(10,2) DEFAULT NULL COMMENT '快递费用',
  `express_address` text COLLATE utf8_unicode_ci COMMENT '客户地址',
  `express_time` datetime DEFAULT NULL COMMENT '快递时间',
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单号',
  `cp_num` int(11) DEFAULT '1' COMMENT '产品数量',
  `cp_ids` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_names` text COLLATE utf8_unicode_ci COMMENT '多个产品名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `uid` int(11) DEFAULT NULL,
  `uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(2) DEFAULT '2' COMMENT '1已确认，2未确认',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='快递信息';



# Dump of table factory_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_menu`;

CREATE TABLE `factory_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fid` int(11) DEFAULT '0',
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  `sort` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table factory_order
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_order`;

CREATE TABLE `factory_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_sn` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '单号',
  `cp_num` int(11) DEFAULT '1' COMMENT '此订单的产品数量',
  `order_status` tinyint(4) DEFAULT '1' COMMENT '0:待收件，1:待整件，2:待发件，3:已发件',
  `sj_uid` int(11) DEFAULT NULL,
  `sj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '收件人',
  `sj_time` datetime DEFAULT NULL,
  `zj_uid` int(11) DEFAULT NULL,
  `zj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '整件完成人',
  `zj_time` datetime DEFAULT NULL,
  `fj_uid` int(11) DEFAULT NULL,
  `fj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fj_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_sn` (`order_sn`) USING BTREE,
  KEY `uid` (`sj_uid`) USING BTREE,
  KEY `create_time` (`sj_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='订单表';



# Dump of table factory_rework
# ------------------------------------------------------------

DROP TABLE IF EXISTS `factory_rework`;

CREATE TABLE `factory_rework` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '产品id,与订单产品表id一致',
  `fmid` int(11) DEFAULT NULL COMMENT 'c_foundryitemstable表主键id',
  `mid` int(11) DEFAULT NULL COMMENT '维修件id',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '产品标题',
  `cp_status` tinyint(2) DEFAULT '1' COMMENT '0:待收件，1:待整件，2:待发件，3:已发件，4:已快递给客户',
  `orderId` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用于打印的唯一条码',
  `qrcode` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二维码图片地址',
  `cp_sj_uid` int(11) DEFAULT NULL,
  `cp_sj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_sj_time` datetime DEFAULT NULL,
  `cp_zj_uid` int(11) DEFAULT NULL,
  `cp_zj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_zj_time` datetime DEFAULT NULL,
  `cp_fj_uid` int(11) DEFAULT NULL,
  `cp_fj_uname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cp_fj_time` datetime DEFAULT NULL,
  `express_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '快递单号',
  `express_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '快递名称',
  `express_time` datetime DEFAULT NULL COMMENT '快递时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='返工件状态表';



# Dump of table lf_dress_borrow
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_borrow`;

CREATE TABLE `lf_dress_borrow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fdid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `borrowday` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '借调日期',
  `yuanshop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '原使用店面',
  `yuanshop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '使用店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `operating_time` datetime DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服借调记录';



# Dump of table lf_dress_changshang
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_changshang`;

CREATE TABLE `lf_dress_changshang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `changshangname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cstype` int(11) NOT NULL DEFAULT '0' COMMENT '0全部、1订货2、送洗',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dealtype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服厂商设定';



# Dump of table lf_dress_infoset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_infoset`;

CREATE TABLE `lf_dress_infoset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fdid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '礼服编号',
  `fdname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '礼服名称',
  `changshangname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '厂商名称',
  `typename` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '礼服类型',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '所在店面code',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '所在店面',
  `barcode_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '条码编号',
  `ssshop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '所属店面code',
  `ssshop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '所属店面',
  `buydate` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '购买日期',
  `baofeidate` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '报废日期',
  `sysex` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '适用性别',
  `buymoney` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '购买金额',
  `wash_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '送洗金额',
  `rent_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '出租金额',
  `start_age` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '适用时间段始',
  `end_age` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '适用时间段束',
  `remark` text COLLATE utf8_unicode_ci NOT NULL COMMENT '备注',
  `operating_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作人',
  `operating_time` datetime DEFAULT NULL COMMENT '操作时间',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `systatus` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '使用状态',
  `systatussz` int(11) DEFAULT '0' COMMENT '备用使用状态1、使用2、出租、3送洗',
  `washname_last` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '最近送洗人',
  `washday_last` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '最近送洗日',
  `washrearuse_count` int(11) DEFAULT '0' COMMENT '送洗后使用次数',
  `totalusecount` int(11) DEFAULT '0' COMMENT '总使用次数',
  `usename_last` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '最近使用人',
  `useday_last` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '最近使用日',
  `scenesnamelist` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fdid` (`fdid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服信息设定';



# Dump of table lf_dress_outerrent
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_outerrent`;

CREATE TABLE `lf_dress_outerrent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fdid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '礼服编号',
  `lease_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '借出日期',
  `return_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '归还日期',
  `rentplace` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '外借地',
  `rentmoney` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `remark` text COLLATE utf8_unicode_ci COMMENT '备注',
  `operating_time` datetime DEFAULT NULL,
  `operating_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `return_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服出租';



# Dump of table lf_dress_scenesset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_scenesset`;

CREATE TABLE `lf_dress_scenesset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `scenesname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(1000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服场景设定';



# Dump of table lf_dress_typeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_typeset`;

CREATE TABLE `lf_dress_typeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typename` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(1000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服类型设定';



# Dump of table lf_dress_use
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_use`;

CREATE TABLE `lf_dress_use` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customerid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fdid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `usetype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `photoid` int(11) NOT NULL DEFAULT '0',
  `lease_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `return_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_time` datetime DEFAULT NULL,
  `remark` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服使用表';



# Dump of table lf_dress_wash
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_wash`;

CREATE TABLE `lf_dress_wash` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sxid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fdid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `send_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `washmoney` decimal(10,2) NOT NULL DEFAULT '0.00',
  `return_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `return_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_time` datetime DEFAULT NULL,
  `remark` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服送洗明细';



# Dump of table lf_dress_washdj
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lf_dress_washdj`;

CREATE TABLE `lf_dress_washdj` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sxid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '送洗编号',
  `send_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '送洗日期',
  `return_date` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '归还日期',
  `manufacturers_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '厂商名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `return_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '归还人',
  `remark` text COLLATE utf8_unicode_ci NOT NULL,
  `operating_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='礼服送洗单据';



# Dump of table lm_customerflowtb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lm_customerflowtb`;

CREATE TABLE `lm_customerflowtb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flowtype` int(11) DEFAULT '0' COMMENT '0标准1单流程返工',
  `flowname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '流程名',
  `defalutday` int(11) DEFAULT NULL COMMENT '默认天',
  `aliasname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '数量名',
  `zmoney` decimal(10,2) DEFAULT NULL COMMENT '单价',
  `needVerify` int(11) DEFAULT '0' COMMENT '是否审核',
  `count` int(11) DEFAULT '0' COMMENT '数量',
  `shengchengshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '插入时',
  `paihuoshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '派活时',
  `paihuoren` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '派活人',
  `yingwanchengshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '应完成时',
  `wanchengren` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '完成人',
  `wanchengshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '完成时',
  `wanchengstate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '完成状态0未分配，1已分配',
  `shenheren` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核人',
  `shenheshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核时',
  `flowid` int(11) DEFAULT '0',
  `upprogress` int(11) DEFAULT '0' COMMENT '0还不能操作，1能操作',
  `thisprogress` int(11) DEFAULT '0',
  `remark` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `defaultdy` int(11) DEFAULT '0',
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `tsxiutiao` int(11) DEFAULT '0' COMMENT '数量',
  `supermoney` decimal(10,2) DEFAULT '0.00',
  `defaultcount` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `defaultuser` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fk` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `defaultsuper` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxsa` int(11) DEFAULT '0',
  `isfxsb` int(11) DEFAULT '0',
  `needwait` int(11) DEFAULT '0',
  `isfxsaname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxsbname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxscname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `supermoneyc` decimal(10,2) DEFAULT '0.00',
  `defaultsuperc` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxsc` int(11) DEFAULT '0',
  `isaddqjdate` int(11) DEFAULT '0',
  `addqjdate` int(11) DEFAULT '0',
  `tsxiutiaoc` int(11) DEFAULT '0',
  `ggqqggcount` int(11) DEFAULT '0',
  `gghqggcount` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table lm_flowreturn
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lm_flowreturn`;

CREATE TABLE `lm_flowreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flowname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flowid` int(11) DEFAULT NULL,
  `fangongshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '制作时',
  `fangongren` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '返工单制作人',
  `yingwanchengshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '应完成时',
  `wanchengren` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '完成人',
  `remark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '备注',
  `wanchengshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '完成时',
  `shenheren` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核人',
  `iswancheng` int(11) DEFAULT '0' COMMENT '是否完成',
  `shenheshi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `returncount` int(11) DEFAULT '0',
  `flowtbid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table lm_gaigaorecord
# ------------------------------------------------------------

DROP TABLE IF EXISTS `lm_gaigaorecord`;

CREATE TABLE `lm_gaigaorecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `flowid` int(11) DEFAULT NULL,
  `orderid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `info` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `optime` datetime DEFAULT CURRENT_TIMESTAMP,
  `opname` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`),
  KEY `flowid` (`flowid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table ls_authority
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ls_authority`;

CREATE TABLE `ls_authority` (
  `ID` int(11) NOT NULL,
  `authorname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ParentID` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `ls_authority` WRITE;
/*!40000 ALTER TABLE `ls_authority` DISABLE KEYS */;

INSERT INTO `ls_authority` (`ID`, `authorname`, `ParentID`)
VALUES
	(1,'全部',0),
	(2,'工作调度',1),
	(3,'业务汇总',1),
	(4,'数码统计',1),
	(5,'系统设定',1),
	(6,'新增任务',2),
	(7,'派活',2),
	(8,'环节审核',2),
	(9,'修改数量',2),
	(10,'添加返工',2),
	(11,'返工审核',2),
	(12,'工作环节设置',5),
	(13,'客户来源设置',5),
	(14,'人员设置',5),
	(15,'工作量统计',4),
	(16,'删除派活',1);

/*!40000 ALTER TABLE `ls_authority` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table ls_flowtb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ls_flowtb`;

CREATE TABLE `ls_flowtb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `flowname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '流程名',
  `defalutday` int(11) DEFAULT NULL COMMENT '默认天',
  `aliasname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '数量名',
  `zmoney` decimal(10,2) DEFAULT NULL COMMENT '单价',
  `needVerify` int(11) DEFAULT '0' COMMENT '是否审核',
  `defaultcount` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `defaultuser` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `supermoney` decimal(10,2) DEFAULT NULL,
  `defaultsuper` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxsa` int(11) DEFAULT '0',
  `isfxsb` int(11) DEFAULT '0',
  `upbuwan` int(11) DEFAULT '0',
  `isfxsaname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxsbname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxscname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `supermoneyc` decimal(10,2) DEFAULT '0.00',
  `defaultsuperc` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isfxsc` int(11) DEFAULT '0',
  `isaddqjdate` int(11) DEFAULT '0',
  `addqjdate` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table ls_grouptb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ls_grouptb`;

CREATE TABLE `ls_grouptb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `authorid` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flowid` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `showwork` int(11) DEFAULT '0',
  `mainindex` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table ls_shoptb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ls_shoptb`;

CREATE TABLE `ls_shoptb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shopname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shopcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contactsman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contactstel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shoptypeid` int(11) DEFAULT NULL,
  `butt` int(11) DEFAULT '0',
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table ls_shoptype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ls_shoptype`;

CREATE TABLE `ls_shoptype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table ls_stafftb
# ------------------------------------------------------------

DROP TABLE IF EXISTS `ls_stafftb`;

CREATE TABLE `ls_stafftb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupid` int(11) DEFAULT NULL,
  `groupname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isheadman` int(11) DEFAULT NULL COMMENT '0原1组长',
  `smcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `usercode` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位唯一标识',
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '店面编码',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职时间',
  `work_shop` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作店面',
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table pf_servicerscoresheet
# ------------------------------------------------------------

DROP TABLE IF EXISTS `pf_servicerscoresheet`;

CREATE TABLE `pf_servicerscoresheet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photoid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `orderId` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `scoretype` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `beipingname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `operating_time` datetime DEFAULT NULL,
  `totalscore` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `pfremark` text COLLATE utf8_unicode_ci,
  `Column1` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column2` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column3` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column4` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column5` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column6` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column7` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column8` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column9` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column10` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column11` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column12` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column13` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column14` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Column15` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `pfday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `isrecord` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='服务人员评分表';



# Dump of table province
# ------------------------------------------------------------

DROP TABLE IF EXISTS `province`;

CREATE TABLE `province` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) COLLATE ucs2_unicode_ci NOT NULL DEFAULT '0',
  `orderid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci COMMENT='省市县';

LOCK TABLES `province` WRITE;
/*!40000 ALTER TABLE `province` DISABLE KEYS */;

INSERT INTO `province` (`id`, `Name`, `orderid`)
VALUES
	(1,'北京',0),
	(2,'天津',0),
	(3,'河北',0),
	(4,'山西',0),
	(5,'内蒙古',0),
	(6,'辽宁',0),
	(7,'吉林',0),
	(8,'黑龙江',0),
	(9,'上海',0),
	(10,'江苏',0),
	(11,'浙江',0),
	(12,'安徽',0),
	(13,'福建',999),
	(14,'江西',0),
	(15,'山东',0),
	(16,'河南',0),
	(17,'湖北',0),
	(18,'湖南',0),
	(19,'广东',0),
	(20,'广西',0),
	(21,'海南',0),
	(22,'重庆',0),
	(23,'四川',0),
	(24,'贵州',0),
	(25,'云南',0),
	(26,'西藏',0),
	(27,'陕西',0),
	(28,'甘肃',0),
	(29,'青海',0),
	(30,'宁夏',0),
	(31,'新疆',0),
	(32,'香港',0),
	(33,'澳门',0),
	(34,'台湾',0);

/*!40000 ALTER TABLE `province` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table q_planninghuafei
# ------------------------------------------------------------

DROP TABLE IF EXISTS `q_planninghuafei`;

CREATE TABLE `q_planninghuafei` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `qhnumber` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qhname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qhhfitem` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qhhfmoney` decimal(10,2) NOT NULL DEFAULT '0.00',
  `djday` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `djstaff` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `qhname` (`qhname`),
  KEY `djday` (`djday`),
  KEY `qhnumber` (`qhnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table q_planninginfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `q_planninginfo`;

CREATE TABLE `q_planninginfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `qhnumber` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qhname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `qhstartday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `qhendday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `qhday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `qhhuafeimoney` decimal(10,2) DEFAULT '0.00',
  `qhpageitem` varchar(300) COLLATE utf8_unicode_ci DEFAULT '',
  `qhinfo` text COLLATE utf8_unicode_ci,
  `qhstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `qhpicurl` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `createtime` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`,`qhnumber`),
  UNIQUE KEY `qhnumber` (`qhnumber`),
  KEY `qhname` (`qhname`),
  KEY `createtime` (`createtime`),
  KEY `qhstartday` (`qhstartday`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='企划表';



# Dump of table s_acceptoraddress
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acceptoraddress`;

CREATE TABLE `s_acceptoraddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acceptoraddress_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='接单点';



# Dump of table s_all_control_time
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_all_control_time`;

CREATE TABLE `s_all_control_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctype` int(11) DEFAULT NULL COMMENT '排程类型：0拍照，1选片',
  `pcday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pctime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时间点',
  `timecount` int(11) DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `jibie` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `settime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_areaset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_areaset`;

CREATE TABLE `s_areaset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='区域设定';



# Dump of table s_bankinfoset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_bankinfoset`;

CREATE TABLE `s_bankinfoset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bankinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行名称',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='刷卡银行设定';



# Dump of table s_channelsources
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_channelsources`;

CREATE TABLE `s_channelsources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channelname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道来源设定';



# Dump of table s_collectmoneyset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_collectmoneyset`;

CREATE TABLE `s_collectmoneyset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `collectitem_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '款项名称',
  `collectitem_belongs` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '款项所属',
  `account_debited` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '借方科目',
  `credit_entry` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '贷方科目',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `isdisable` int(11) DEFAULT '0',
  `xnmoney` decimal(10,2) DEFAULT '0.00',
  `jianmianmoney` decimal(10,2) DEFAULT '0.00',
  `zhekou` decimal(10,2) DEFAULT '0.00',
  `skminmoney` decimal(10,2) DEFAULT '-1.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='收款款项设定';



# Dump of table s_commonsolutions
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_commonsolutions`;

CREATE TABLE `s_commonsolutions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `solutionname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `m_start` int(11) DEFAULT NULL,
  `m_end` int(11) DEFAULT NULL,
  `m_discount` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_consumptionitem
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_consumptionitem`;

CREATE TABLE `s_consumptionitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出件类别（摄影、礼服、化妆、其他）',
  `ckssubtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费项目类型',
  `item_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费项目名称',
  `item_pagecount` int(11) DEFAULT '0' COMMENT '消费项目P数',
  `item_sheetscount` int(11) DEFAULT '0' COMMENT '消费项目入册张数',
  `item_costs` decimal(10,2) DEFAULT '0.00' COMMENT '消费项目成本价',
  `item_price` decimal(10,2) DEFAULT '0.00' COMMENT '消费项目售价',
  `isconversion` tinyint(4) DEFAULT '0' COMMENT '转出件项目送后期制作',
  `item_remark` text COLLATE utf8_unicode_ci COMMENT '项目备注',
  `iscanuse` tinyint(4) DEFAULT '1' COMMENT '上架才可销售1可销售',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '设定店面简码',
  `specifications` varchar(2000) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '产品规格',
  `bottomPrice` decimal(10,2) DEFAULT '0.00',
  `addpprice` decimal(10,2) DEFAULT '0.00' COMMENT '加P单价',
  `addpcost` decimal(10,2) DEFAULT '0.00' COMMENT '加P成本',
  `xccolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '颜色',
  `isvipzs` tinyint(4) DEFAULT '0' COMMENT '可以VIP赠送',
  `issp` tinyint(4) DEFAULT '0' COMMENT '选片显示',
  `fengpi` tinyint(4) DEFAULT '0' COMMENT '是否包含封皮',
  `item_size` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '产品尺寸',
  `cansale` int(11) DEFAULT '1',
  `isnomatterzs` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_name` (`item_name`),
  KEY `item_price` (`item_price`),
  KEY `ckssubtype` (`ckssubtype`),
  KEY `category` (`category`),
  KEY `shop_code` (`shop_code`(255)),
  KEY `isvipzs` (`isvipzs`),
  KEY `issp` (`issp`),
  KEY `fengpi` (`fengpi`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消费项目设定';



# Dump of table s_consumptionitem_element
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_consumptionitem_element`;

CREATE TABLE `s_consumptionitem_element` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ele_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `photocount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `itemid` (`itemname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_consumptionitem_subtype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_consumptionitem_subtype`;

CREATE TABLE `s_consumptionitem_subtype` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `category` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '类别（摄影、化妆、礼服、其他）',
  `ckssubtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费项目子类别名称',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `iscanupdate` tinyint(4) DEFAULT NULL COMMENT '是否使用店面可以修改',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消费子类别设定';



# Dump of table s_consumptionitemfengmian
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_consumptionitemfengmian`;

CREATE TABLE `s_consumptionitemfengmian` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '消费项目',
  `fengyetyle` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '封面封底',
  `fengyehengshu` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '横竖',
  `caiqieshu` int(11) DEFAULT '0' COMMENT '照片数量',
  `size1` int(11) DEFAULT '0',
  `size2` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_consumptiontype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_consumptiontype`;

CREATE TABLE `s_consumptiontype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `myorderby` int(11) DEFAULT '0',
  `mustfill` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消费类型设定';



# Dump of table s_cussource
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_cussource`;

CREATE TABLE `s_cussource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户来源表';



# Dump of table s_customerareaset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_customerareaset`;

CREATE TABLE `s_customerareaset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户分区表';



# Dump of table s_czpackagedetailset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_czpackagedetailset`;

CREATE TABLE `s_czpackagedetailset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `czpackage_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `package_price` decimal(10,2) DEFAULT '0.00',
  `servicenumber` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_czpackageset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_czpackageset`;

CREATE TABLE `s_czpackageset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `czpackage_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `czpackage_price` decimal(10,2) DEFAULT '0.00',
  `czpack_remark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `iscanuse` tinyint(4) DEFAULT NULL,
  `package_count` tinyint(4) DEFAULT '0',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `czpackage_per` decimal(10,2) DEFAULT '0.00',
  `youxiaodaycount` int(11) DEFAULT '0',
  `bottomPrice` decimal(10,2) DEFAULT '0.00',
  `cztxtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`,`czpackage_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_dress_colorset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_dress_colorset`;

CREATE TABLE `s_dress_colorset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `color_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '颜色名称',
  `shop_code` varchar(500) DEFAULT '',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='礼服颜色设定';



# Dump of table s_elementset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_elementset`;

CREATE TABLE `s_elementset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ele_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `photocount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_foundry_projectset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_foundry_projectset`;

CREATE TABLE `s_foundry_projectset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工项目名称',
  `foundry_firmId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工工厂编号',
  `foundry_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '代工工厂名称',
  `foundry_price` decimal(10,2) DEFAULT NULL COMMENT '代工价格',
  `makedays` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '制造周期',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `pprice` decimal(10,2) DEFAULT NULL COMMENT '1P价格',
  `pcount` int(11) DEFAULT NULL COMMENT '标准P',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='代工项目设定';



# Dump of table s_foundryfirmset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_foundryfirmset`;

CREATE TABLE `s_foundryfirmset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `mfsid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商编号',
  `manufacturers_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商名称',
  `fcontact_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商联系人',
  `ftelephone1` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人方式1',
  `ftelephone2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人方式2',
  `faddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商地址',
  `fremarks` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商备注',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面编码',
  `shopCode` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '对应码',
  `shopip` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '连接IP',
  `ipPwd` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '访问密码',
  `sendpath` varchar(5000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '送件路径',
  `joinflag` int(4) DEFAULT '0' COMMENT '是否连接车间1连接车间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='代工厂商表';



# Dump of table s_function_set
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_function_set`;

CREATE TABLE `s_function_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `A` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '门市销售',
  `Aid` int(11) DEFAULT NULL COMMENT '门市销售权限',
  `B` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '礼服销售',
  `Bid` int(11) DEFAULT NULL COMMENT '礼服销售权限',
  `C` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '化妆销售',
  `Cid` int(11) DEFAULT NULL COMMENT '化妆销售权限',
  `D` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影销售',
  `Did` int(11) DEFAULT NULL COMMENT '摄影销售权限',
  `E` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片销售',
  `Eid` int(11) DEFAULT NULL COMMENT '选片销售权限',
  `F` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '排程管理',
  `Fid` int(11) DEFAULT NULL COMMENT '排程管理权限',
  `G` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '后期制作',
  `Gid` int(11) DEFAULT NULL COMMENT '后期制作权限',
  `H` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '财务管理',
  `Hid` int(11) DEFAULT NULL COMMENT '财务管理权限',
  `I` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '统计分析',
  `Iid` int(11) DEFAULT NULL COMMENT '统计分析权限',
  `J` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '前台收银',
  `Jid` int(11) DEFAULT NULL COMMENT '前台收银权限',
  `K` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '进客登记',
  `Kid` int(11) DEFAULT NULL COMMENT '进客登记权限',
  `L` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '短信发送',
  `Lid` int(11) DEFAULT NULL COMMENT '短信发送权限',
  `M` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影排程',
  `Mid` int(11) DEFAULT NULL COMMENT '摄影排程权限',
  `N` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '系统设定',
  `Nid` int(11) DEFAULT NULL COMMENT '系统设定权限',
  `O` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '服务管控',
  `Oid` int(11) DEFAULT NULL COMMENT '服务管控权限',
  `P` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片系统',
  `Pid` int(11) DEFAULT NULL COMMENT '选片系统权限',
  `Q` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Qid` int(11) DEFAULT '0',
  `R` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Rid` int(11) DEFAULT '0',
  `S` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Sid` int(11) DEFAULT '0',
  `T` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `Tid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='权限设定表';

LOCK TABLES `s_function_set` WRITE;
/*!40000 ALTER TABLE `s_function_set` DISABLE KEYS */;

INSERT INTO `s_function_set` (`id`, `A`, `Aid`, `B`, `Bid`, `C`, `Cid`, `D`, `Did`, `E`, `Eid`, `F`, `Fid`, `G`, `Gid`, `H`, `Hid`, `I`, `Iid`, `J`, `Jid`, `K`, `Kid`, `L`, `Lid`, `M`, `Mid`, `N`, `Nid`, `O`, `Oid`, `P`, `Pid`, `Q`, `Qid`, `R`, `Rid`, `S`, `Sid`, `T`, `Tid`)
VALUES
	(1,'门市销售',0,'礼服销售',0,'化妆销售',0,'摄影销售',0,'选片销售',0,'取件订单',0,'后期制作',0,'财务管理',0,'统计分析',0,'前台收银',0,'进客登记',0,'短信发送',0,'排程管控',0,'',0,'客服回访中心',0,'选片系统',0,'数码管控',0,'电子工作簿',0,'其它设定',0,'资产管理',0),
	(2,'门市订单查询',1,'礼服订单查询',1,'化妆订单查询',1,'修改摄影订单',1,'选片订单查询',1,'取件订单查询',1,'送件',1,'核账查询',1,'订单统计',1,'收款查询',1,'进客信息查询',1,'短信查询',1,'拍照排程',1,'',0,'客户回访',1,'传片',1,'数码读卡',1,'摄影电子工作簿',1,'一销锁定',1,'',0),
	(3,'开立门市订单',1,'开立礼服订单',1,'开立化妆订单',1,'已拍完修改拍照状态',1,'开立选片订单',1,'产品整件',1,'回件',1,'核账',1,'实收明细统计',1,'门市收款',1,'新建客资',1,'短信发送',1,'查看拍照排程',2,'',0,'客诉客户',1,'选片查询',1,'读卡订单查询   ',2,'派送',2,'二销锁定',1,'',0),
	(4,'包套销售',1,'修改礼服订单',1,'修改化妆订单',1,'删除摄影订单',1,'修改选片订单',1,'产品取件',1,'修改',1,'取消核账',1,'摄影统计',1,'',0,'修改客资',1,'发送记录',1,'安排拍照排程',2,'',0,'查看回访订单',2,'选片',1,'新建读卡',2,'取消派送',2,'修改订单日期',1,'',0),
	(5,'新增包套',4,'删除礼服订单',1,'删除化妆订单',1,'上传先睹为快',1,'删除选片订单',1,'产品全部整件完成',1,'删除',1,'导出',1,'选片统计',1,'',0,'删除客资',1,'查看验证码',1,'修改排程设置',2,'',0,'导出回访订单',2,'操作记录',1,'修改读卡',2,'接收',2,'超出成本审核权',1,'',0),
	(6,'新增一销产品',4,'礼服登记',1,'新增化妆内容',1,'可修改选片已完成资料',1,'',NULL,'产品全部取件完成',1,'打印条码',1,'本单作废',1,'',1,'门市打印',1,'客资分配',1,NULL,NULL,'删除拍照排程',2,'',0,'操作回访订单',2,'选片系统设定',1,'删除读卡',2,'取消接收',2,'显示订单产品成本',1,'',0),
	(7,'新增二销产品',4,'删除礼服',1,'修改化妆内容',1,'可修改看版已完成资料',1,NULL,NULL,'打印',1,'一键送件',1,'订单退款状态',1,'操作记录查询',1,'',1,'客资标记',1,NULL,NULL,'查看拍照排程记录',2,'',0,'查看客诉订单',3,'选片浏览',4,'样前调色',1,'选片电子工作簿',1,'修改产品价格',1,'',0),
	(8,'保存修改',4,'',NULL,'删除化妆内容',1,'可修改美编已完成资料',1,NULL,NULL,'修改整件日期',1,'送件查询',1,'',NULL,'维修件统计',1,'',0,'已进店状态',1,NULL,NULL,'选片排程',1,'',0,'导出客诉订单',3,'消费明细',4,'调色订单查询',7,'派送',7,'修改门市收款',1,'',0),
	(9,'删除产品',4,NULL,NULL,'',NULL,'可修改效果已完成资料',1,NULL,NULL,'修改取件日期',1,'整件',1,'',NULL,'实收业绩统计',1,'',0,'未进店状态',1,NULL,NULL,'查看选片排程',8,'',0,'新建客诉订单',3,'选片打印',4,'新建调色',7,'取消派送',7,'删除门市收款',1,'',0),
	(10,'包套升级',4,NULL,NULL,NULL,NULL,'已拍完修改摄影师',1,NULL,NULL,'修改急件状态',1,'生产完成',1,'',NULL,'厂商回件统计',1,'',1,'转订单',1,NULL,NULL,'安排选片排程',8,'',0,'修改客诉订单',3,'图片操作',4,'修改调色',7,'接收',7,'',0,'',0),
	(11,'预约打印',1,NULL,NULL,NULL,NULL,'已拍完修改化妆师',1,NULL,NULL,'修改急件日期',1,'重新提交任务',1,'',NULL,'',1,'',1,'流失',1,NULL,NULL,'修改选片排程设置',8,'',0,'关闭客诉订单',3,'产品效果',4,'删除调色',7,'取消接收',7,'',0,'',0),
	(12,'修改客户资料',1,NULL,NULL,NULL,NULL,'已拍完修改引导师',1,NULL,NULL,'一键整件完成',1,'厂商对账',1,'',NULL,'财务审核统计',1,'',0,'导入',1,NULL,NULL,'删除选片排程',8,'',0,'客诉回访',3,'产品制作',4,'样前初修',1,'看版电子工作簿',1,'',0,'',0),
	(13,'添加客户介绍人',1,NULL,NULL,NULL,NULL,'已拍完修改MV摄影师',1,NULL,NULL,'一键取件完成',1,'产品出库单',1,'',NULL,'多单客户统计',1,'',0,'导出',1,NULL,NULL,'查看选片排程记录',8,'',0,'服务人评分',1,'选片发包',4,'初修订单查询',12,'派送',12,'',0,'',0),
	(14,'修改客户介绍人',1,NULL,NULL,NULL,NULL,'已拍完修改摄影备注',1,NULL,NULL,'修改预约取件',1,'产品到店表',1,'',NULL,'门店业绩成本统计',1,'',1,'查询其他门市客资',1,NULL,NULL,'',1,'',0,'操作评分',13,'快捷键设置',6,'新建初修',12,'取消派送',12,'收款修改当前日期',1,'',0),
	(15,'解除介绍关系',1,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,'预约取件记录',1,'数码工作',0,'',NULL,'',NULL,'',0,'查询其他登记人客资',1,NULL,NULL,'',NULL,'',0,'导出评分',13,'产品效果设置',6,'修改初修',12,'接收',12,'收款修改收银人',1,'',0),
	(16,'本单完成',1,NULL,NULL,NULL,NULL,'修改选片师',6,NULL,NULL,'维修件管理',1,'派活调配',15,'',NULL,'二销业绩统计',1,'修改业绩',1,NULL,NULL,NULL,NULL,'',NULL,'',0,NULL,NULL,'显示规则设置',6,'删除初修',12,'取消接收',12,'收款修改店面',1,'',0),
	(17,'产品升级',4,NULL,NULL,NULL,NULL,'修改选片张数',6,NULL,NULL,'发送短信',1,'派活',16,'',NULL,'游泳次数统计',1,'',0,NULL,NULL,NULL,NULL,'',NULL,'',0,NULL,NULL,'档案整理删除',1,'数码精修',1,'整件电子工作簿',1,'',1,'',0),
	(18,'删除订单',1,NULL,NULL,NULL,NULL,'修改预约张数',6,NULL,NULL,'取件类型',1,'修改',16,'',NULL,'销售产品统计',1,'退款操作',1,NULL,NULL,NULL,NULL,'',NULL,'',0,NULL,NULL,'底片云',1,'精修订单查询',17,'派送',17,'修改收款款项',8,'',0),
	(19,'修改预约取件',1,NULL,NULL,NULL,NULL,'修改精修张数',6,NULL,NULL,'送件信息',1,'删除',16,'',NULL,' 取件产品统计',1,'',1,NULL,NULL,NULL,NULL,'',NULL,'',0,NULL,NULL,'数码下载',1,'新建精修',17,'取消派送',17,'',1,'',0),
	(20,'相册加P',4,NULL,NULL,NULL,NULL,'修改选片备注',6,NULL,NULL,NULL,NULL,'完成',16,'',NULL,NULL,NULL,'重复打印',1,NULL,NULL,NULL,NULL,'',NULL,'',0,NULL,NULL,'选片后数码未派活提醒',1,'修改精修',17,'接收',17,'修改收款金额',8,'',0),
	(21,'包套合并',4,NULL,NULL,NULL,NULL,'修改看版师',7,NULL,NULL,NULL,NULL,'审核',16,'',NULL,'门市订单查询',2,NULL,NULL,NULL,NULL,NULL,NULL,'修改当天拍照排控设置',2,'',0,NULL,NULL,'界面操作',1,'删除精修',17,'取消接收',17,'修改支付方式',8,'',0),
	(22,'修改销售门市',1,NULL,NULL,NULL,NULL,'修改美编师',7,NULL,NULL,NULL,NULL,'个人工作',15,'',NULL,'门市订单导出',2,'VIP卡不需要验证码',1,NULL,NULL,NULL,NULL,'修改当天选片排控设置',8,'',0,NULL,NULL,'打开原始照片',21,'数码设计',1,'取件电子工作簿',1,'',1,'',0),
	(23,'客户催拍',1,NULL,NULL,NULL,NULL,'修改美编张数',8,NULL,NULL,NULL,NULL,'下载客户照片',22,'',NULL,'摄影订单查询',4,NULL,NULL,NULL,NULL,NULL,NULL,'修改当天看版排控设置',14,'',0,NULL,NULL,'打开照片',21,'设计订单查询',22,'派送',22,'修改发票号',8,'',0),
	(24,'相册合并',4,NULL,NULL,NULL,NULL,'修改美编状态',8,NULL,NULL,NULL,NULL,'上传客户照片',22,'',NULL,'摄影订单导出',4,NULL,NULL,NULL,NULL,NULL,NULL,' 拍照排程导出',1,'',0,NULL,NULL,'打开发包档',21,'新建设计',22,'取消派送',22,'修改付款码',8,'',0),
	(25,'包套转移',4,NULL,NULL,NULL,NULL,'修改套版P数',8,NULL,NULL,NULL,NULL,'打开服务器文件夹',22,'',NULL,'选片订单查询',5,NULL,NULL,NULL,NULL,NULL,NULL,' 选片排程导出',8,'',0,NULL,NULL,'打开发包压缩档',21,'修改设计',22,'接收',22,'修改收款备注',8,'',0),
	(26,'维修件管理',1,NULL,NULL,NULL,NULL,'修改看效果师',9,NULL,NULL,NULL,NULL,'打开服务器上传文件夹',22,'',NULL,'选片订单导出',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,'上传下载特殊标记图片',21,'删除设计',22,'取消接收',22,'收款活动卡',1,'',0),
	(27,'订单流程表',1,NULL,NULL,NULL,NULL,'修改选片完成日',NULL,NULL,NULL,NULL,NULL,'数码统计',15,'',NULL,'实收明细查询',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,'下载照片',21,'相册排版',1,' 发包电子工作簿',1,'收负款',1,'',0),
	(28,'会员客户',1,NULL,NULL,NULL,NULL,'修改看版完成日',NULL,NULL,NULL,NULL,NULL,'查询派活调配',27,'',NULL,'实收明细导出',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,'解锁',1,'排版订单查询',27,' 到店电子工作簿',1,'素材管理',1,'',0),
	(29,'会员卡发卡',1,NULL,NULL,NULL,NULL,'新增拍照',1,NULL,NULL,NULL,NULL,'查询个人工作',27,'',NULL,'分配业绩查询',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,'设计底片',4,'新建排版',27,' 电子工作簿导出',1,'原始素材上传',28,'',0),
	(30,'订单绑定会员卡',1,NULL,NULL,NULL,NULL,'修改MV剪辑师',1,NULL,NULL,NULL,NULL,'审核',27,'',NULL,'分配业绩导出',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'修改排版',27,'美工制作电子工作簿',1,'下载上传成品',28,'',0),
	(31,'订单解绑会员卡',1,NULL,NULL,NULL,NULL,'修改拍衣件数',1,NULL,NULL,NULL,NULL,'取消审核',27,'',NULL,'维修件查询',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'删除排版',27,'美工制作完成',1,'素材路径',28,'',0),
	(32,'产品转移',4,NULL,NULL,NULL,NULL,'修改有效素材数量',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'维修件导出',8,NULL,NULL,NULL,NULL,NULL,NULL,'导出本月排控汇总',2,'',0,NULL,NULL,NULL,NULL,'样前审核',1,'取消美工制作',1,'',NULL,'',0),
	(33,'会员卡操作',1,NULL,NULL,NULL,NULL,'上传素材',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'厂商回件查询',10,NULL,NULL,NULL,NULL,NULL,NULL,'修改排控人',2,'',0,NULL,NULL,NULL,NULL,'样后审核',1,'',0,'',NULL,'',0),
	(34,'会员卡查询',1,NULL,NULL,NULL,NULL,'下载素材',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'厂商回件导出',10,NULL,NULL,NULL,NULL,NULL,NULL,'拍照安排可操作店档期',2,'',0,NULL,NULL,NULL,NULL,'数码派活',1,'',0,'',NULL,'',0),
	(35,'会员卡设定',1,NULL,NULL,NULL,NULL,'是否采访',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'销售产品查询',18,NULL,NULL,NULL,NULL,NULL,NULL,'拍照安排所有店档期',2,'',0,NULL,NULL,NULL,NULL,'调色派活',34,'',0,'',NULL,'',0),
	(36,'发卡',33,NULL,NULL,NULL,NULL,'是否合格',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'销售产品导出',18,NULL,NULL,NULL,NULL,NULL,NULL,'拍照设置可操作店档期',2,'',0,NULL,NULL,NULL,NULL,'初修派活',34,'',0,'',NULL,'',0),
	(37,'绑定会员卡',33,NULL,NULL,NULL,NULL,'水印回传日',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'操作记录查询',7,NULL,NULL,NULL,NULL,NULL,NULL,'拍照设置所有店档期',2,'',0,NULL,NULL,NULL,NULL,'精修派活',34,'',0,'',NULL,'',0),
	(38,'解绑会员卡',33,NULL,NULL,NULL,NULL,'修改采访师',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'操作记录导出',7,NULL,NULL,NULL,NULL,NULL,NULL,'选片安排可操作店档期',8,'',0,NULL,NULL,NULL,NULL,'设计派活',34,'',0,'',NULL,'',0),
	(39,'会员卡类型升级',33,NULL,NULL,NULL,NULL,'修改前期拍摄金额',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'财务审核查询',12,NULL,NULL,NULL,NULL,NULL,NULL,'选片安排所有店档期',8,'',0,NULL,NULL,NULL,NULL,'可查所有调色人员工作',1,'',0,'',NULL,'',0),
	(40,'更换会员卡号',33,NULL,NULL,NULL,NULL,'修改全家福数',8,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'财务审核导出',12,NULL,NULL,NULL,NULL,NULL,NULL,'选片设置可操作店档期',8,'',0,NULL,NULL,NULL,NULL,'可查所有初修人员工作',1,'',0,'',NULL,'',0),
	(41,'手动加减积分',33,NULL,NULL,NULL,NULL,'修改单片设计数',8,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'多单客户查询',13,NULL,NULL,NULL,NULL,NULL,NULL,'选片设置所有店档期',8,'',0,NULL,NULL,NULL,NULL,'可查所有精修人员工作',1,'',0,'',NULL,'',0),
	(42,'修改会员卡密码',33,NULL,NULL,NULL,NULL,'修改特殊P数',8,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'多单客户导出',13,NULL,NULL,NULL,NULL,NULL,NULL,'客户占档',2,'',0,NULL,NULL,NULL,NULL,'可查所有设计人员工作',1,'',0,'',NULL,'',0),
	(43,'充值记录',34,NULL,NULL,NULL,NULL,'修改套系类型',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'门店业绩查询',14,NULL,NULL,NULL,NULL,NULL,NULL,'员工占档',2,'',0,NULL,NULL,NULL,NULL,'数码工作量统计',1,'',0,'',NULL,'',0),
	(44,'消费记录',34,NULL,NULL,NULL,NULL,'修改拍照类型',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'门店业绩导出',14,NULL,NULL,NULL,NULL,NULL,NULL,'取消本人占档',2,'',0,NULL,NULL,NULL,NULL,'读卡工作统计',43,'',0,'',NULL,'',0),
	(45,'升级记录',34,NULL,NULL,NULL,NULL,'修改出片日期',1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'门店成本查询',15,NULL,NULL,NULL,NULL,NULL,NULL,'取消所有人占档',2,'',0,NULL,NULL,NULL,NULL,'调色工作统计',43,'',0,'',NULL,'',0),
	(46,'本次服务完成',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'门店成本导出',15,NULL,NULL,NULL,NULL,NULL,NULL,'拍照排控之前档期',2,'',0,NULL,NULL,NULL,NULL,'初修工作统计',43,'',0,'',NULL,'',0),
	(47,'取消服次完成',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'二销业绩成本查询',16,NULL,NULL,NULL,NULL,NULL,NULL,'选片排控之前档期',8,'',0,NULL,NULL,NULL,NULL,'精修工作统计',43,'',0,'',NULL,'',0),
	(48,'修改妈妈手机号',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'二销业绩成本导出',16,NULL,NULL,NULL,NULL,NULL,NULL,'重拍不审核',2,'',0,NULL,NULL,NULL,NULL,'设计工作统计',43,'',0,'',NULL,'',0),
	(49,'取消本单完成',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'游泳次数查询',17,NULL,NULL,NULL,NULL,NULL,NULL,'仅能修改所属门店的当日排控量',2,'',0,NULL,NULL,NULL,NULL,'排版工作统计',43,'',0,'',NULL,'',0),
	(50,'会员类型设定',35,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,'游泳次数导出',17,NULL,NULL,NULL,NULL,NULL,NULL,'修改档期有效状态',2,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(51,'充值类型设定',35,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,' 取件产品查询',19,NULL,NULL,NULL,NULL,NULL,NULL,'开始拍摄',2,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(52,'会员导出',34,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,' 取件产品导出',19,NULL,NULL,NULL,NULL,NULL,NULL,'结束拍摄',2,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(53,'催拍导出',23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'客户满意度统计',1,NULL,NULL,NULL,NULL,NULL,NULL,'取消开始拍摄',2,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(54,'换卡',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'客户满意度查询',53,NULL,NULL,NULL,NULL,NULL,NULL,'取消结束拍摄',2,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(55,'修改消费类型',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'客户满意度导出',53,NULL,NULL,NULL,NULL,NULL,NULL,'开始选片',8,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(56,'修改来源渠道',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'数据汇总',1,NULL,NULL,NULL,NULL,NULL,NULL,'结束选片',8,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(57,'修改客户分区',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'门店日报表',56,NULL,NULL,NULL,NULL,NULL,NULL,'取消开始选片',8,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',NULL,'',0),
	(58,'修改网销门市',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'拍摄日报表',56,NULL,NULL,NULL,NULL,NULL,NULL,'取消结束选片',8,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'修改价格不验证',1,'',0),
	(59,'元素收集完成',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'门店业绩汇总',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'只可查看当日实收及业绩',1,'',0),
	(60,'批量开单',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'实收金额汇总',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'只可查看当月实收及业绩',1,'',0),
	(61,'退款',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'门市业绩表',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'催拍订单权限',1,'',0),
	(62,'取消退款',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'摄影师业绩表',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'仅能看分配自己的订单',61,'',0),
	(63,'本单作废',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'引导师业绩表',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'可看可操作店面的订单',61,'',0),
	(64,'取消本单作废',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'化妆师业绩表',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(65,'服务次交换',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'门店日报汇总',56,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(66,'修改服务管家',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'亦萌下单统计',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(67,'产品置换',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'亦萌下单导出',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(68,'加入册',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(69,'无条件赠送产品',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(70,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(71,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(72,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(73,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(74,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(75,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(76,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(77,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(78,'',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(79,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(80,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(81,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(82,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(83,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'流程预警',1,'',0),
	(84,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'流程预警设定',83,'',0),
	(85,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'流程预警导出',83,'',0),
	(86,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'客户中心',1,'',0),
	(87,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(88,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(89,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(90,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(91,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(92,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(93,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(94,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(95,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(96,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(97,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(98,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(99,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0),
	(100,'',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,'',0,'',0,'',0);

/*!40000 ALTER TABLE `s_function_set` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_globalset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_globalset`;

CREATE TABLE `s_globalset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ispcwx` int(11) NOT NULL DEFAULT '1',
  `iskhwx` int(11) DEFAULT '1',
  `isygwx` int(11) DEFAULT '1',
  `ishz` int(11) DEFAULT '1',
  `iscstp` int(11) DEFAULT '1',
  `Digital1` int(11) DEFAULT '0',
  `Digital2` int(11) DEFAULT '0',
  `Digital3` int(11) DEFAULT '0',
  `Digital4` int(11) DEFAULT '0',
  `Digital5` int(11) DEFAULT '0',
  `Digital6` int(11) DEFAULT '0',
  `Digital7` int(11) DEFAULT '0',
  `Digital8` int(11) DEFAULT '0',
  `Digital9` int(11) DEFAULT '0',
  `Digital10` int(11) DEFAULT '0',
  `Digital11` int(11) DEFAULT '0',
  `Digital12` int(11) DEFAULT '0',
  `Digital13` int(11) DEFAULT '0',
  `Digital14` int(11) DEFAULT '0',
  `Digital15` int(11) DEFAULT '0',
  `Digital16` int(11) DEFAULT '0',
  `Digital17` int(11) DEFAULT '0',
  `Digital6day` int(11) DEFAULT '0',
  `Digital7day` int(11) DEFAULT '0',
  `Digital8day` int(11) DEFAULT '0',
  `Digital9value` int(11) DEFAULT '0',
  `Digital13value` int(11) DEFAULT '0',
  `Digital14value` int(11) DEFAULT '0',
  `Digital15value` int(11) DEFAULT '0',
  `Digital16value` int(11) DEFAULT '0',
  `Digital17value` int(11) DEFAULT '0',
  `controlmode` int(11) DEFAULT '1',
  `Digital18` int(11) DEFAULT '0',
  `Digital19` int(11) DEFAULT '0',
  `Digital20` int(11) DEFAULT '0',
  `Digital21` int(11) DEFAULT '0',
  `Digital18value` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `Digital19value` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `Digital20value` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `Digital21value` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `Digital22` int(11) DEFAULT '0',
  `Digital22value` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `Digital23` int(11) DEFAULT '0',
  `Digital24` int(11) DEFAULT '0',
  `Digital25` int(11) DEFAULT '0',
  `Digital26` int(11) DEFAULT '0',
  `Digital27` int(11) DEFAULT '0',
  `validbz` decimal(10,2) DEFAULT '0.00',
  `Digital28` int(11) DEFAULT '0',
  `allqjfcwc` int(11) DEFAULT '0',
  `Digital29` int(11) DEFAULT '0',
  `photodaynostate` int(11) DEFAULT '0' COMMENT '拍照日期过几天后不填写拍照状态提示',
  `Digital30` int(11) DEFAULT '0',
  `Digital29value` decimal(10,2) DEFAULT '0.00',
  `kbwcqjday` int(11) DEFAULT '0' COMMENT '看版完成几天后自动填写取件日期',
  `wcback` int(11) DEFAULT '0' COMMENT '完成即回件',
  `Digital31` int(11) DEFAULT '0',
  `Digital31value` int(11) DEFAULT '0',
  `Digital32` int(11) DEFAULT '0',
  `Digital32value` int(11) DEFAULT '0',
  `Digital33` int(11) DEFAULT '0',
  `Digital34` int(11) DEFAULT '0',
  `Digital35` int(11) DEFAULT '0',
  `Digital34value` int(11) DEFAULT '0',
  `Digital35value` int(11) DEFAULT '0',
  `vxtx1` int(11) DEFAULT '0',
  `vxtx2` int(11) DEFAULT '0',
  `vxtx3` int(11) DEFAULT '0',
  `vxtx4` int(11) DEFAULT '0',
  `vxtx5` int(11) DEFAULT '0',
  `vxtx6` int(11) DEFAULT '0',
  `vxtx7` int(11) DEFAULT '0',
  `vxtx8` int(11) DEFAULT '0',
  `vxtx9` int(11) DEFAULT '0',
  `vxtx10` int(11) DEFAULT '0',
  `vxtx11` int(11) DEFAULT '0',
  `vxtx12` int(11) DEFAULT '0',
  `vxtx13` int(11) DEFAULT '0',
  `vxtx14` int(11) DEFAULT '0',
  `vxtx15` int(11) DEFAULT '0',
  `vxtx16` int(11) DEFAULT '0',
  `vxtx17` int(11) DEFAULT '0',
  `vxtx18` int(11) DEFAULT '0',
  `vxtx19` int(11) DEFAULT '0',
  `vxtx20` int(11) DEFAULT '0',
  `vxtx21` int(11) DEFAULT '0',
  `vxtx22` int(11) DEFAULT '0',
  `vxtx23` int(11) DEFAULT '0',
  `vxtx24` int(11) unsigned DEFAULT '0',
  `vxtx25` int(11) DEFAULT '0',
  `vxtx26` int(11) DEFAULT '0',
  `vxtx27` int(11) DEFAULT '0',
  `vxtx28` int(11) DEFAULT '0',
  `vxtx1value` int(11) DEFAULT '0',
  `vxtx2value` int(11) DEFAULT '0',
  `vxtx3value` int(11) DEFAULT '0',
  `vxtx4value` int(11) DEFAULT '0',
  `vxtx7value` int(11) DEFAULT '0',
  `vxtx8value` int(11) DEFAULT '0',
  `vxtx9value` int(11) DEFAULT '0',
  `vxtx16value` int(11) DEFAULT '0',
  `vxtx17value` int(11) DEFAULT '0',
  `vxtx18value` int(11) DEFAULT '0',
  `vxtx19value` int(11) DEFAULT '0',
  `vxtx20value` int(11) DEFAULT '0',
  `vxtx22value` int(11) DEFAULT '0',
  `vxtx23value` int(11) DEFAULT '0',
  `vxtx24value` int(11) DEFAULT '0',
  `vxtx25value` int(11) DEFAULT '0',
  `vxtx26value` int(11) DEFAULT '0',
  `vxtx27value` int(11) DEFAULT '0',
  `vxtx28value` int(11) DEFAULT '0',
  `Digital36` int(11) DEFAULT '0',
  `Digital36value` int(11) DEFAULT '0',
  `photopdsendwx` int(11) DEFAULT '0',
  `sppdsendwx` int(11) DEFAULT '0',
  `mulphoto` int(11) DEFAULT '1',
  `showjianji` int(11) DEFAULT '1',
  `paiwangaimv` int(11) DEFAULT '1',
  `dulisb` int(11) DEFAULT '0',
  `zbtxmoneysj` int(11) DEFAULT '0',
  `likesch` int(11) DEFAULT '0',
  `cztxzb` int(11) DEFAULT '0',
  `ym1` int(11) DEFAULT '0',
  `ym2` int(11) DEFAULT '0',
  `cs1` int(11) DEFAULT '0',
  `cs2` int(11) DEFAULT '0',
  `my1` int(11) DEFAULT '0',
  `my2` int(11) DEFAULT '0',
  `bt1` int(11) DEFAULT '0',
  `bt2` int(11) DEFAULT '0',
  `bs1` int(11) DEFAULT '0',
  `bs2` int(11) DEFAULT '0',
  `zs1` int(11) DEFAULT '0',
  `zs2` int(11) DEFAULT '0',
  `isokqqcz` int(11) DEFAULT '0',
  `prfidshowmark` int(11) DEFAULT '0',
  `usephototakeday` int(11) DEFAULT '0',
  `phototakeday` int(11) DEFAULT '0',
  `todiandays` int(11) DEFAULT '0',
  `tiyanmoney` decimal(10,2) DEFAULT '0.00',
  `taoximoney` decimal(10,2) DEFAULT '0.00',
  `vipmoney` decimal(10,2) DEFAULT '0.00',
  `payjifenmoney` decimal(10,2) DEFAULT '0.00',
  `xgtodiandays` int(11) DEFAULT '0',
  `usecantaketx` int(11) DEFAULT '0',
  `cantaketx` int(11) DEFAULT '0',
  `usepwnosendtx` int(11) DEFAULT '0',
  `pwnosendtx` int(11) DEFAULT '0',
  `zuizongfenpeistaff` int(11) DEFAULT '0',
  `usespwnotaobantx` int(11) DEFAULT '0',
  `spwnotaobantx` int(11) DEFAULT '0',
  `usewxjjstx` int(11) DEFAULT '0',
  `wxjjstx` int(11) DEFAULT '0',
  `usewxjjszjtx` int(11) DEFAULT '0',
  `wxjjszjtx` int(11) DEFAULT '0',
  `usewxjjstoshoptx` int(11) DEFAULT '0',
  `wxjjstoshoptx` int(11) DEFAULT '0',
  `istrack` int(11) DEFAULT '0',
  `isyxsk` int(11) DEFAULT '0',
  `usepaixiangday` int(11) DEFAULT '0',
  `paixiangday` int(11) DEFAULT '0',
  `usetboverwsjtx` int(11) DEFAULT '0',
  `tboverwsjtx` int(11) DEFAULT '0',
  `shuangyueday` int(11) DEFAULT '0',
  `usepaixianggqday` int(11) DEFAULT '0',
  `paixianggqday` int(11) DEFAULT '0',
  `paixianggaipaixiang` int(11) DEFAULT '0',
  `vippayfpyeji` int(11) DEFAULT '1',
  `vippaymse` int(11) DEFAULT '1',
  `isgaiqiday` int(11) DEFAULT '0',
  `loginchkshop` int(11) DEFAULT '0',
  `ispaikongzhandancolor` int(11) DEFAULT '0',
  `ispaikongweidaocolor` int(11) DEFAULT '0',
  `paikongzhandancolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `paikongweidaocolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `lcyj1` int(11) DEFAULT '0',
  `lcyj2` int(11) DEFAULT '0',
  `lcyj3` int(11) DEFAULT '0',
  `lcyj4` int(11) DEFAULT '0',
  `lcyj5` int(11) DEFAULT '0',
  `lcyj6` int(11) DEFAULT '0',
  `lcyj7` int(11) DEFAULT '0',
  `lcyj8` int(11) DEFAULT '0',
  `lcyj9` int(11) DEFAULT '0',
  `paikongphototype` int(11) DEFAULT '0',
  `lcyj10` int(11) DEFAULT '0',
  `lcyj11` int(11) DEFAULT '0',
  `lcyj12` int(11) DEFAULT '0',
  `lcyj13` int(11) DEFAULT '0',
  `controlrc` int(11) DEFAULT '0',
  `zeropaikong` int(11) DEFAULT '0',
  `iswxsendquday` int(11) DEFAULT '0',
  `wxsendquday` int(11) DEFAULT '0',
  `ispaikongphotosocolor` int(11) DEFAULT '0',
  `paikongphotosocolor` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `orderschopshop` int(11) DEFAULT '0',
  `qugongchang` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='全局设定';

LOCK TABLES `s_globalset` WRITE;
/*!40000 ALTER TABLE `s_globalset` DISABLE KEYS */;

INSERT INTO `s_globalset` (`id`, `ispcwx`, `iskhwx`, `isygwx`, `ishz`, `iscstp`, `Digital1`, `Digital2`, `Digital3`, `Digital4`, `Digital5`, `Digital6`, `Digital7`, `Digital8`, `Digital9`, `Digital10`, `Digital11`, `Digital12`, `Digital13`, `Digital14`, `Digital15`, `Digital16`, `Digital17`, `Digital6day`, `Digital7day`, `Digital8day`, `Digital9value`, `Digital13value`, `Digital14value`, `Digital15value`, `Digital16value`, `Digital17value`, `controlmode`, `Digital18`, `Digital19`, `Digital20`, `Digital21`, `Digital18value`, `Digital19value`, `Digital20value`, `Digital21value`, `Digital22`, `Digital22value`, `Digital23`, `Digital24`, `Digital25`, `Digital26`, `Digital27`, `validbz`, `Digital28`, `allqjfcwc`, `Digital29`, `photodaynostate`, `Digital30`, `Digital29value`, `kbwcqjday`, `wcback`, `Digital31`, `Digital31value`, `Digital32`, `Digital32value`, `Digital33`, `Digital34`, `Digital35`, `Digital34value`, `Digital35value`, `vxtx1`, `vxtx2`, `vxtx3`, `vxtx4`, `vxtx5`, `vxtx6`, `vxtx7`, `vxtx8`, `vxtx9`, `vxtx10`, `vxtx11`, `vxtx12`, `vxtx13`, `vxtx14`, `vxtx15`, `vxtx16`, `vxtx17`, `vxtx18`, `vxtx19`, `vxtx20`, `vxtx21`, `vxtx22`, `vxtx23`, `vxtx24`, `vxtx25`, `vxtx26`, `vxtx27`, `vxtx28`, `vxtx1value`, `vxtx2value`, `vxtx3value`, `vxtx4value`, `vxtx7value`, `vxtx8value`, `vxtx9value`, `vxtx16value`, `vxtx17value`, `vxtx18value`, `vxtx19value`, `vxtx20value`, `vxtx22value`, `vxtx23value`, `vxtx24value`, `vxtx25value`, `vxtx26value`, `vxtx27value`, `vxtx28value`, `Digital36`, `Digital36value`, `photopdsendwx`, `sppdsendwx`, `mulphoto`, `showjianji`, `paiwangaimv`, `dulisb`, `zbtxmoneysj`, `likesch`, `cztxzb`, `ym1`, `ym2`, `cs1`, `cs2`, `my1`, `my2`, `bt1`, `bt2`, `bs1`, `bs2`, `zs1`, `zs2`, `isokqqcz`, `prfidshowmark`, `usephototakeday`, `phototakeday`, `todiandays`, `tiyanmoney`, `taoximoney`, `vipmoney`, `payjifenmoney`, `xgtodiandays`, `usecantaketx`, `cantaketx`, `usepwnosendtx`, `pwnosendtx`, `zuizongfenpeistaff`, `usespwnotaobantx`, `spwnotaobantx`, `usewxjjstx`, `wxjjstx`, `usewxjjszjtx`, `wxjjszjtx`, `usewxjjstoshoptx`, `wxjjstoshoptx`, `istrack`, `isyxsk`, `usepaixiangday`, `paixiangday`, `usetboverwsjtx`, `tboverwsjtx`, `shuangyueday`, `usepaixianggqday`, `paixianggqday`, `paixianggaipaixiang`, `vippayfpyeji`, `vippaymse`, `isgaiqiday`, `loginchkshop`, `ispaikongzhandancolor`, `ispaikongweidaocolor`, `paikongzhandancolor`, `paikongweidaocolor`, `lcyj1`, `lcyj2`, `lcyj3`, `lcyj4`, `lcyj5`, `lcyj6`, `lcyj7`, `lcyj8`, `lcyj9`, `paikongphototype`, `lcyj10`, `lcyj11`, `lcyj12`, `lcyj13`, `controlrc`, `zeropaikong`, `iswxsendquday`, `wxsendquday`, `ispaikongphotosocolor`, `paikongphotosocolor`, `orderschopshop`, `qugongchang`)
VALUES
	(1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,'-4144960','-32640','0','-65536',1,'-16129',0,0,0,0,0,0.00,0,0,0,0,0,0.00,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.00,0.00,0.00,0.00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,'-128','-8323073',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,'-8323200',0,0);

/*!40000 ALTER TABLE `s_globalset` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_gximagepath
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_gximagepath`;

CREATE TABLE `s_gximagepath` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `spath` varchar(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `suser` varchar(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `spwd` varchar(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_hospitalset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_hospitalset`;

CREATE TABLE `s_hospitalset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hospital` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='医院设定';



# Dump of table s_intentionset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_intentionset`;

CREATE TABLE `s_intentionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `intention_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户意向设定表';



# Dump of table s_introducertype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_introducertype`;

CREATE TABLE `s_introducertype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Introdtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍类型',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='进客类型设定';



# Dump of table s_kaidanaddress
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_kaidanaddress`;

CREATE TABLE `s_kaidanaddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kaidan_sheng` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `kaidan_shi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `kaidan_qu` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_kanbantimeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_kanbantimeset`;

CREATE TABLE `s_kanbantimeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时间点',
  `timecount` int(11) DEFAULT NULL,
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `jibie` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `settime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='看版管控设定';



# Dump of table s_kesufangshi
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_kesufangshi`;

CREATE TABLE `s_kesufangshi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kesufangshi` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_kesujijindu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_kesujijindu`;

CREATE TABLE `s_kesujijindu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kesujinjidu` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `jiejuetime` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_kesutype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_kesutype`;

CREATE TABLE `s_kesutype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kesutypename` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_kesuzhuti
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_kesuzhuti`;

CREATE TABLE `s_kesuzhuti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kesuzhuti` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_manufacturers
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_manufacturers`;

CREATE TABLE `s_manufacturers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manufacturers_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工厂名称',
  `category_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工厂类型',
  `principal` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工厂联系人',
  `mobile` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人手机号',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工厂电话',
  `address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工厂地址',
  `email` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工厂EMAIL',
  `DealType` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '厂商所属类型（礼服订货商、代工厂商、礼服送洗厂商）',
  `licence` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '营业执照号',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='合作厂家设定';



# Dump of table s_manufacturers_categoryset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_manufacturers_categoryset`;

CREATE TABLE `s_manufacturers_categoryset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '类型名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='制作厂商类别设定';



# Dump of table s_message_template
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_message_template`;

CREATE TABLE `s_message_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ms_typename` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ms_tem_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ms_tem_msinfo` text COLLATE utf8_unicode_ci,
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`),
  KEY `ms_tem_name` (`ms_tem_name`) USING BTREE,
  KEY `ms_typename` (`ms_typename`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_mv_shoppathset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_mv_shoppathset`;

CREATE TABLE `s_mv_shoppathset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fileuploadpath` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mvdownloadpath` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filedownloadpath` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mvuploadpath` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_name` (`shop_name`) USING BTREE,
  KEY `shop_code` (`shop_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='店面MV 路径设定';



# Dump of table s_nas_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_nas_list`;

CREATE TABLE `s_nas_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nas_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `active_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_orderlossitem
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_orderlossitem`;

CREATE TABLE `s_orderlossitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lossitemname` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci COMMENT='流失原因';



# Dump of table s_ordertype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_ordertype`;

CREATE TABLE `s_ordertype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ordertype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行名称',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `consumptiontype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='新单类型表';



# Dump of table s_otherset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_otherset`;

CREATE TABLE `s_otherset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `printoption` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '打印选项',
  `isqydh` int(11) NOT NULL DEFAULT '0' COMMENT '启用单号规则0正常1自定义',
  `qysm` int(11) NOT NULL DEFAULT '0' COMMENT '是否启用数码',
  `nlength` int(11) NOT NULL DEFAULT '6',
  `lslength` int(11) NOT NULL DEFAULT '3',
  `shoporderno` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '单号',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lookstyle` int(11) DEFAULT '0',
  `defaultshowpic` int(11) DEFAULT '0',
  `ordernumber` int(11) DEFAULT '0',
  `sheyingzucount` int(11) DEFAULT '0',
  `yanzhengmamobanid` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='其他设定';



# Dump of table s_package_portfolio
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_package_portfolio`;

CREATE TABLE `s_package_portfolio` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '包套名称',
  `sequence` tinyint(4) DEFAULT NULL COMMENT '项目次序',
  `category` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目类别',
  `ckssubtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目子类别',
  `Item_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '项目名称',
  `amount` int(11) DEFAULT NULL COMMENT '项目数量',
  `item_sheetscount` int(11) DEFAULT NULL COMMENT '入册张数',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `remarks` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `txmoney` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `package_name_sequence_category_ckssubtype_Item_name` (`package_name`,`sequence`,`category`,`ckssubtype`,`Item_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='包套与产品关系表';



# Dump of table s_packageset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_packageset`;

CREATE TABLE `s_packageset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `package_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '包套名称',
  `package_price` decimal(10,2) DEFAULT '0.00' COMMENT '包套价格',
  `pack_remark` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '包套备注',
  `iscanuse` tinyint(4) DEFAULT NULL COMMENT '是否上架',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `package_per` decimal(10,0) DEFAULT NULL COMMENT '成本占比',
  `paizhaoshu` int(11) DEFAULT '0' COMMENT '拍照数量',
  `jingxiushu` int(11) DEFAULT '0' COMMENT '精修数量',
  `ruceshu` int(11) DEFAULT '0' COMMENT '入册数量',
  `shineifz` int(11) DEFAULT '0' COMMENT '室内服装数',
  `waijingfz` int(11) DEFAULT '0' COMMENT '外境数',
  `youxiaodaycount` int(11) DEFAULT '0',
  `package_cost` decimal(10,2) DEFAULT '0.00',
  `bottomPrice` decimal(10,2) DEFAULT '0.00',
  `txtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `package_name_package_price_iscanuse_shop_code` (`package_name`,`package_price`,`iscanuse`,`shop_code`(255)) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='包套设定表';



# Dump of table s_pcdefault_monthset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pcdefault_monthset`;

CREATE TABLE `s_pcdefault_monthset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctype` int(11) DEFAULT NULL COMMENT '排程类型：0拍照，1选片',
  `pcday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pctime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时间点',
  `timecount` int(11) DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `jibie` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `settime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  PRIMARY KEY (`id`),
  KEY `pctype_pcday_pctime_shop_code` (`pctype`,`pcday`,`pctime`,`shop_code`) USING BTREE,
  KEY `area` (`area`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='排程月设定';



# Dump of table s_pcdefault_pingkong_set
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pcdefault_pingkong_set`;

CREATE TABLE `s_pcdefault_pingkong_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctype` int(11) DEFAULT NULL COMMENT '排程类型：0拍照，1选片',
  `pctime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时间点',
  `timecount` int(11) DEFAULT NULL,
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `jibie` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `settime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  PRIMARY KEY (`id`),
  KEY `pctype_pctime_timecount_area_shop_code` (`pctype`,`pctime`,`timecount`,`area`,`shop_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='默认排程管控';



# Dump of table s_pcdefault_remark
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pcdefault_remark`;

CREATE TABLE `s_pcdefault_remark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctype` int(11) NOT NULL DEFAULT '0' COMMENT '0拍照，1选片，2看版，3取件',
  `pcday` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '备注天',
  `pcremarks` varchar(3000) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '特殊备注',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '店面',
  PRIMARY KEY (`id`),
  KEY `pctype_pcday_shop_code` (`pctype`,`pcday`,`shop_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='排控每日特殊备注表';



# Dump of table s_pcdefault_timeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pcdefault_timeset`;

CREATE TABLE `s_pcdefault_timeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pctype` tinyint(4) NOT NULL COMMENT '排程类型：0拍照，1选片',
  `pctime` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '时间点',
  `allcount` int(11) NOT NULL COMMENT '总控制数量',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `weekday` int(11) DEFAULT NULL,
  `jibie` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `pctype_pctime_shop_code_area_weekday` (`pctype`,`pctime`,`shop_code`,`area`,`weekday`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='默认排程设定表';



# Dump of table s_person_liableset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_person_liableset`;

CREATE TABLE `s_person_liableset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `person_liable` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人名称',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='后制送件责任人表';



# Dump of table s_photoaddress
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_photoaddress`;

CREATE TABLE `s_photoaddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `addressname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍摄地',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='拍照基地';



# Dump of table s_photography_base
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_photography_base`;

CREATE TABLE `s_photography_base` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pbass_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '摄影基地名称',
  `pbase_price` decimal(10,2) DEFAULT '0.00' COMMENT '摄影基地价格',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='摄影基地设定表';



# Dump of table s_photoscoreset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_photoscoreset`;

CREATE TABLE `s_photoscoreset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photoscore` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='照片评分设定表';



# Dump of table s_photoservicetypeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_photoservicetypeset`;

CREATE TABLE `s_photoservicetypeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `servicetype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='拍照服务类型';



# Dump of table s_phototype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_phototype`;

CREATE TABLE `s_phototype` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `phototype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照类型',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='拍照类型设定';



# Dump of table s_pingassesstype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pingassesstype`;

CREATE TABLE `s_pingassesstype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asname` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `subjectinfo` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `departinfo` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `worktype` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `pingjia1` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `pingjia2` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `pingjia3` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `pingjia4` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `pingjia5` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL COMMENT '使用店面编码',
  `setkey` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci;



# Dump of table s_pingjiatype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pingjiatype`;

CREATE TABLE `s_pingjiatype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aname` varchar(100) COLLATE ucs2_unicode_ci NOT NULL DEFAULT '0',
  `shop_code` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL COMMENT '使用店面编码',
  `setkey` varchar(100) COLLATE ucs2_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 COLLATE=ucs2_unicode_ci;



# Dump of table s_position_discount
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_position_discount`;

CREATE TABLE `s_position_discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `positionname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `m_start` int(11) DEFAULT NULL,
  `m_end` int(11) DEFAULT NULL,
  `m_discount` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_pricestep
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_pricestep`;

CREATE TABLE `s_pricestep` (
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `price` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_productidset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_productidset`;

CREATE TABLE `s_productidset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `productid` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `productname` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_producttypeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_producttypeset`;

CREATE TABLE `s_producttypeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `producttype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `distance` int(11) NOT NULL DEFAULT '0',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_qihuahuafeiset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_qihuahuafeiset`;

CREATE TABLE `s_qihuahuafeiset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `huafeiitem` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='企划花费';



# Dump of table s_qjtimeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_qjtimeset`;

CREATE TABLE `s_qjtimeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pctime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时间点',
  `timecount` int(11) DEFAULT NULL,
  `area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面狗号',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面狗号',
  `jibie` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `settime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='取件日期管控';



# Dump of table s_remindset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_remindset`;

CREATE TABLE `s_remindset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remindtype` int(11) DEFAULT '0' COMMENT '0客户生日、1拍照、2选片、3取件、4结婚纪念日',
  `remindday` int(11) DEFAULT '0' COMMENT '提前提醒天数',
  `remindmode` int(11) DEFAULT '0' COMMENT '0提前，1推后',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='ERP提醒设定表';



# Dump of table s_sanbaotype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_sanbaotype`;

CREATE TABLE `s_sanbaotype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sanbaotypename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_sendtypeset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_sendtypeset`;

CREATE TABLE `s_sendtypeset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `sendtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件类型',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '设定店面编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='取件类型设定';



# Dump of table s_session
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_session`;

CREATE TABLE `s_session` (
  `user_id` int(11) NOT NULL,
  `session_key` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌',
  KEY `user_id_session_key_login_type` (`user_id`,`session_key`,`login_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';



# Dump of table s_setallpaikonginfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_setallpaikonginfo`;

CREATE TABLE `s_setallpaikonginfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stetime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setalltimeinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setstaff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pctype` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='同步排控日期设定记录';



# Dump of table s_smflowset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_smflowset`;

CREATE TABLE `s_smflowset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `flowname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days` int(11) NOT NULL DEFAULT '0',
  `studiostaff` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `upway` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `needaudit` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `uploadchange` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='梦幻天使数码项目设定表';



# Dump of table s_smprojectmain
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_smprojectmain`;

CREATE TABLE `s_smprojectmain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `flowname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `floworder` int(11) NOT NULL DEFAULT '0',
  `projectnum` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `projectname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='梦幻天使数码方案下项目表';



# Dump of table s_smprojectset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_smprojectset`;

CREATE TABLE `s_smprojectset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `projectnum` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `projectname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='梦幻天使数码方案设定';



# Dump of table s_smsautosendset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_smsautosendset`;

CREATE TABLE `s_smsautosendset` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `stype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '日期类型',
  `sba` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '提前（-）退后（+）',
  `sday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '规则天数',
  `stime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '发送时间',
  `srecive` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接收者（男士，女士）',
  `sinfo` text COLLATE utf8_unicode_ci COMMENT '短信内容',
  `soper` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定者',
  `slasttime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '最后发送时间',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `isyx` int(11) DEFAULT '0',
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信发送规则设定表';



# Dump of table s_smtype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_smtype`;

CREATE TABLE `s_smtype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `smtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `listkey` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '设定店面编码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_spworkcycle
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_spworkcycle`;

CREATE TABLE `s_spworkcycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `worktypeid` int(11) NOT NULL DEFAULT '0',
  `worktype` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `distance` int(11) NOT NULL DEFAULT '0',
  `setkey` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='选片工作人员工作周期';



# Dump of table s_staffdgvstyle
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staffdgvstyle`;

CREATE TABLE `s_staffdgvstyle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `formname` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `styleinfo` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `staffname` (`staffname`),
  KEY `formname` (`formname`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_staffinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staffinfo`;

CREATE TABLE `s_staffinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名',
  `password` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `main_position_id` int(11) DEFAULT NULL COMMENT '主岗位',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位唯一标识',
  `position_id` text COLLATE utf8_unicode_ci,
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级',
  `turestaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '真实姓名',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT '0' COMMENT '小组id',
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `is_group_admin` text COLLATE utf8_unicode_ci,
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别',
  `entry_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '入职时间',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职时间',
  `birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生日',
  `IDcard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '身份证',
  `nation` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '国家',
  `place_origin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生地',
  `political` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '政治身份',
  `education` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '教育程度',
  `graduation_school` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '毕业学校',
  `marital_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '婚姻状况',
  `contract_endday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '合同结束时间',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '电话号',
  `QQ` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `a_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期折扣',
  `b_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期折扣',
  `a_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期成本',
  `b_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期成本',
  `liaison_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人',
  `liaison_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系电话',
  `salary_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '薪水',
  `social_security` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '社会保险',
  `bank_cardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行卡号',
  `addressinfo` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '住址',
  `remarkinfo` text COLLATE utf8_unicode_ci COMMENT '备注信息',
  `vice_work_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '副工作类型，兼职工作类型',
  `work_shop` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作店面',
  `open_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定微信',
  `open_id_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定的微信号名字，用于显示当前绑定者',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '在线状态：1：在线；2：忙碌；3：离线',
  `Popedom1` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom2` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom3` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom4` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom5` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom6` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom7` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom8` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom9` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `Popedom10` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom11` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom12` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom13` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom14` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom15` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom16` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom17` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom18` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `add_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` tinyint(2) DEFAULT NULL,
  `last_login_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `is_jiguang` tinyint(2) DEFAULT '2',
  `start_holiday` datetime DEFAULT NULL,
  `end_holiday` datetime DEFAULT NULL,
  `work_type_level_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_level` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `working_status` tinyint(2) DEFAULT '1',
  `visa_number` int(11) DEFAULT NULL,
  `fingerprint1` text COLLATE utf8_unicode_ci,
  `fingerprint2` text COLLATE utf8_unicode_ci,
  `fingerprint3` text COLLATE utf8_unicode_ci,
  `fingerprint4` text COLLATE utf8_unicode_ci,
  `fingerprint5` text COLLATE utf8_unicode_ci,
  `minzu` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_lock` tinyint(1) DEFAULT '2',
  `update_pwd_time` datetime DEFAULT NULL,
  `fingerprint6` text COLLATE utf8_unicode_ci,
  `fingerprint7` text COLLATE utf8_unicode_ci,
  `fingerprint8` text COLLATE utf8_unicode_ci,
  `fingerprint9` text COLLATE utf8_unicode_ci,
  `fingerprint10` text COLLATE utf8_unicode_ci,
  `address_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leaders` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='员工信息表';



# Dump of table s_systeminitialset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_systeminitialset`;

CREATE TABLE `s_systeminitialset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '使用店编码',
  `onoff1` int(11) DEFAULT '0' COMMENT '启动客户折扣',
  `onoff2` int(11) DEFAULT '0' COMMENT '启动系统提醒',
  `onoff3` int(11) DEFAULT '0',
  `onoff4` int(11) DEFAULT '0',
  `onoff5` int(11) DEFAULT '0',
  `onoff6` int(11) DEFAULT '0',
  `onoff7` int(11) DEFAULT '0',
  `onoff8` int(11) DEFAULT '0',
  `onoff9` int(11) DEFAULT '0',
  `onoff10` int(11) DEFAULT '0',
  `onoff11` int(11) DEFAULT '0',
  `onoff12` int(11) DEFAULT '0',
  `onoff13` int(11) DEFAULT '0' COMMENT '开启拍照公休',
  `onoff14` int(11) DEFAULT '0' COMMENT '开启选片公休',
  `onoff15` int(11) DEFAULT '0' COMMENT '开启看版公休',
  `onoff16` int(11) DEFAULT '0' COMMENT '开启取件公休',
  `photorestday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照公休日',
  `sprestday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选片公休日',
  `kbrestday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '看版公休日',
  `qjprestday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取件公休日',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='店面系统开关设定';



# Dump of table s_taktable
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_taktable`;

CREATE TABLE `s_taktable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `takaddress` varchar(100) CHARACTER SET gb2312 DEFAULT NULL,
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='取件点设置';



# Dump of table s_test2
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_test2`;

CREATE TABLE `s_test2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `key1` (`field_1`,`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_topic
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_topic`;

CREATE TABLE `s_topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照主题',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `endday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `xiaofeimoney` decimal(10,2) DEFAULT '0.00',
  `toppshu` int(11) DEFAULT '0',
  `banmensheji` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `cameraman` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `mentor_a` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `dresser` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `setshopname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `toppic1` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `toppic2` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `toppic3` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `toppic4` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='拍照主题';



# Dump of table s_topicwdy
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_topicwdy`;

CREATE TABLE `s_topicwdy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微电影主题',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微电影主题';



# Dump of table s_vipchongzhitype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_vipchongzhitype`;

CREATE TABLE `s_vipchongzhitype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cztypename` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `suoshu` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `czmoney` decimal(10,2) DEFAULT '0.00' COMMENT '收款金额',
  `zsmoney` decimal(10,2) DEFAULT '0.00' COMMENT '充入金额',
  `issuoding` int(11) DEFAULT '0' COMMENT '收款锁定',
  `czgivetype` int(11) DEFAULT '0',
  `shop_code` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `zsswimmingcs` int(11) DEFAULT '0' COMMENT '游泳次数',
  `ginvingmoney` decimal(10,2) DEFAULT '0.00' COMMENT '可赠产品金额',
  PRIMARY KEY (`id`),
  KEY `suoshu_zsswimmingcs` (`suoshu`,`zsswimmingcs`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='充值类型设定';



# Dump of table s_vipdiscount
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_vipdiscount`;

CREATE TABLE `s_vipdiscount` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `discount_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '客户折扣名称',
  `discount` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `shop_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面简码',
  `isjifen` int(11) DEFAULT '0' COMMENT '开启积分',
  `jfmoney` decimal(10,2) DEFAULT '0.00' COMMENT '钱',
  `jfvalue` decimal(10,2) DEFAULT '0.00' COMMENT '积分',
  `isjsjifen` int(11) DEFAULT '0' COMMENT '开启转介绍积分',
  `jsmoney` decimal(10,2) DEFAULT '0.00' COMMENT '钱',
  `jsvalue` decimal(10,2) DEFAULT '0.00' COMMENT '积分',
  `isczqq` int(11) DEFAULT '0',
  `czqqmoney` decimal(10,2) DEFAULT '0.00',
  `czqqvalue` decimal(10,2) DEFAULT '0.00',
  `isczhh` int(11) DEFAULT '0',
  `czhhmoney` decimal(10,2) DEFAULT '0.00',
  `czhhvalue` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='ERP客户折扣设定';



# Dump of table s_viprechargegiveitem
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_viprechargegiveitem`;

CREATE TABLE `s_viprechargegiveitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cztype` int(11) NOT NULL DEFAULT '0',
  `cztypename` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `czgriveitem` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='充值赠送产品项目';



# Dump of table s_vipzengsongitem
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_vipzengsongitem`;

CREATE TABLE `s_vipzengsongitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zptype` int(11) DEFAULT '0',
  `cardtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zengpingitem` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='赠送礼品';



# Dump of table s_wx_talkingskillinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_talkingskillinfo`;

CREATE TABLE `s_wx_talkingskillinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wxtype` int(11) NOT NULL DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_talkingskillinfo` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `wxtype` (`wxtype`) USING BTREE,
  KEY `shop_code` (`shop_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信话术';



# Dump of table s_yuemubiaoyeji
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_yuemubiaoyeji`;

CREATE TABLE `s_yuemubiaoyeji` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mbmonth` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `mbshop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `mbshop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `mblow` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `mbmid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `mbhigh` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_zc_changshang
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_zc_changshang`;

CREATE TABLE `s_zc_changshang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `changshangname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_zc_type
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_zc_type`;

CREATE TABLE `s_zc_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `setkey` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_zengsongitem
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_zengsongitem`;

CREATE TABLE `s_zengsongitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zs_type` int(11) DEFAULT '0',
  `total_money1` decimal(10,2) DEFAULT '0.00',
  `total_money2` decimal(10,2) DEFAULT '0.00',
  `zs_money` decimal(10,2) DEFAULT '0.00',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  KEY `id` (`id`),
  KEY `zs_type` (`zs_type`),
  KEY `total_money1` (`total_money1`),
  KEY `total_money2` (`total_money2`),
  KEY `zs_money` (`zs_money`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='赠送产品区间范围';



# Dump of table sm_bbfiledownpic
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sm_bbfiledownpic`;

CREATE TABLE `sm_bbfiledownpic` (
  `mid` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currentfc` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Count` int(11) DEFAULT NULL,
  `xingming` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `customerid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `id` int(11) DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tmtype` int(11) DEFAULT '0',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table sm_bbfiledownpicdetail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sm_bbfiledownpicdetail`;

CREATE TABLE `sm_bbfiledownpicdetail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currentfc` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shopname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '原名',
  `state` int(11) DEFAULT '0',
  `sendid` int(11) DEFAULT NULL,
  `tmtype` int(11) DEFAULT NULL COMMENT '0原1版2精修',
  `customerid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fatherpath` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `downloadtime` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `smuptime` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `bbname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table sm_bbuploadrecord
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sm_bbuploadrecord`;

CREATE TABLE `sm_bbuploadrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `targetdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Count` int(11) DEFAULT '0',
  `xingming` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filePath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(11) DEFAULT '0' COMMENT '0待确认1已完事2删除3处理',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uptype` int(11) DEFAULT '0',
  `uploadtime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currentfc` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `selectday` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table sm_bbuploadrecorddetail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sm_bbuploadrecorddetail`;

CREATE TABLE `sm_bbuploadrecorddetail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uploadid` int(11) DEFAULT '0',
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `filepath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` int(11) DEFAULT '0',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `targetdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `operator` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qianzhui` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `chuanpianri` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `fc` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table sm_erpflowserver
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sm_erpflowserver`;

CREATE TABLE `sm_erpflowserver` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `flowname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `person` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `state` int(11) NOT NULL DEFAULT '0',
  `remark` text COLLATE utf8_unicode_ci NOT NULL,
  `appoint` int(11) NOT NULL DEFAULT '0',
  `appointtime` datetime DEFAULT NULL,
  `appointman` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `audit` int(11) NOT NULL DEFAULT '0',
  `audittime` datetime DEFAULT NULL,
  `auditman` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `complete` int(11) NOT NULL DEFAULT '0',
  `completetime` datetime DEFAULT NULL,
  `completeman` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `backorder` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `appointorder` int(11) NOT NULL DEFAULT '0',
  `shoulddate` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pcount` int(11) NOT NULL DEFAULT '0',
  `backcount` int(11) NOT NULL DEFAULT '0',
  `floworder` int(11) NOT NULL DEFAULT '0',
  `uploadtime` datetime DEFAULT NULL,
  `projectname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `upway` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `needaudit` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loadsorting` text COLLATE utf8_unicode_ci,
  `loadtime` datetime DEFAULT NULL,
  `upLoadsorting` text COLLATE utf8_unicode_ci,
  `uploadchange` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `fwthis` int(11) DEFAULT '0',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `upddesigndate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `updcontent` text COLLATE utf8_unicode_ci,
  `updnum` int(11) DEFAULT '0',
  `isover` int(11) DEFAULT '0',
  `dutier` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `backtype` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `rccount` int(11) DEFAULT '0',
  `totalcount` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='梦幻天使数码表';



# Dump of table sys_updateinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sys_updateinfo`;

CREATE TABLE `sys_updateinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `updateday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updateinfo` text COLLATE utf8_unicode_ci,
  `sversion` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='系统升级记录表';



# Dump of table uploadrecord
# ------------------------------------------------------------

DROP TABLE IF EXISTS `uploadrecord`;

CREATE TABLE `uploadrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uploadtype` int(11) DEFAULT NULL COMMENT '0原片1精修',
  `uploadtime` datetime DEFAULT NULL,
  `filename` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `uploadcloud` int(11) DEFAULT '0',
  `currentfc` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table x_consume
# ------------------------------------------------------------

DROP TABLE IF EXISTS `x_consume`;

CREATE TABLE `x_consume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customernum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photonum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `consumeitem` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Size` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `itemnum` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='选片产品';



# Dump of table yundasend
# ------------------------------------------------------------

DROP TABLE IF EXISTS `yundasend`;

CREATE TABLE `yundasend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `currentfc` int(11) DEFAULT '0',
  `kdno` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `iteminfo` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `receiveaddress` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `sendtime` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `sendman` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table z_message_remind
# ------------------------------------------------------------

DROP TABLE IF EXISTS `z_message_remind`;

CREATE TABLE `z_message_remind` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标题',
  `info` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '提醒内容',
  `senddate` datetime DEFAULT NULL COMMENT '提示时间',
  `state` int(11) DEFAULT '0' COMMENT '0未提醒1以提醒',
  `operrecord` int(11) DEFAULT '0' COMMENT '0未处理1已处理',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table z_p1
# ------------------------------------------------------------

DROP TABLE IF EXISTS `z_p1`;

CREATE TABLE `z_p1` (
  `chanpinliebie` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `chanleixing` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `chanpinname` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `chicun` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `pshu` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `rucuzhangshu` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `jiapjiage` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `chengben` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `danjia` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `songzhizuo` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `yanse` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table z_sms_send
# ------------------------------------------------------------

DROP TABLE IF EXISTS `z_sms_send`;

CREATE TABLE `z_sms_send` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telnum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telcontent` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `sendtime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opertime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smstate` tinyint(4) DEFAULT '0' COMMENT '0未发1成功2失败',
  `yx` tinyint(4) DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ms_remarks` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信发送记录表';



# Dump of table z_sms_waitsend
# ------------------------------------------------------------

DROP TABLE IF EXISTS `z_sms_waitsend`;

CREATE TABLE `z_sms_waitsend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telnum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telcontent` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `sendtime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opertime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smstate` tinyint(4) DEFAULT '0' COMMENT '0未发1成功2失败',
  `yx` tinyint(4) DEFAULT '0' COMMENT '0短信，1微信',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ms_remarks` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信发送记录表';



# Dump of table zc_baoyang
# ------------------------------------------------------------

DROP TABLE IF EXISTS `zc_baoyang`;

CREATE TABLE `zc_baoyang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zcid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `startdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `enddate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `baoyangmoney` decimal(10,2) DEFAULT '0.00',
  `remark` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `opstaffname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table zc_diaodong
# ------------------------------------------------------------

DROP TABLE IF EXISTS `zc_diaodong`;

CREATE TABLE `zc_diaodong` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zcid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `diaodongdate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `oldshop` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `oldstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `newshop` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `newstaff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `remark` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `opstaffname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table zc_jiegui
# ------------------------------------------------------------

DROP TABLE IF EXISTS `zc_jiegui`;

CREATE TABLE `zc_jiegui` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zcid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `startdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `enddate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `jieyongfang` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `remark` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `opstaffname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table zc_weixiu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `zc_weixiu`;

CREATE TABLE `zc_weixiu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zcid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `startdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `enddate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `weixiumoney` decimal(10,2) DEFAULT '0.00',
  `weixiufang` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `remark` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `opstaffname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `opdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table zc_zichan
# ------------------------------------------------------------

DROP TABLE IF EXISTS `zc_zichan`;

CREATE TABLE `zc_zichan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zcid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zcname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zccount` int(11) DEFAULT '0',
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `buydate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `changshangname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `buytotalmoney` decimal(10,2) DEFAULT '0.00',
  `currentmoney` decimal(10,2) DEFAULT '0.00',
  `usedate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `baofeidate` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `remark` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `shopcode` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `RFID` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `InDate` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
