<?php
/**
 * 公共函数
 * User: zhaibaoming
 * Date: 2018/8/8 0008
 * Time: 10:14
 */

/**
 * 过滤特殊字符
 * @param $str
 * @return bool
 * User: zhaibaoming
 * Date: ${DATE}
 */
function filter_specialChar($str)
{
    $regex = "/\!|\#|\\$|\%|\^|\&|\*|\(|\)|\+|\{|\}|\<|\>|\?|\[|\]|\;|\'|\'|\"|\`|\=/";
    return !preg_match($regex, trim($str));
}

/**
 * 获取视频图片 子目录
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_video_image_Subdirectory()
{
    return 'video';
}

/**
 * 获取视频图片路径
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_video_image_path()
{
    $res = \think\Config::get('view_replace_str');
    return $res['__PUBLIC__'] . 'uploads/' . get_video_image_Subdirectory();
}


/**
 * 获取客照图片 子目录
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_user_photos_image_Subdirectory()
{
    return 'Userphotos';
}

/**
 * 获取视频图片路径
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_user_photos_image_path()
{
    $res = \think\Config::get('view_replace_str');
    return $res['__PUBLIC__'] . 'uploads/' . get_user_photos_image_Subdirectory();
}

/**
 * 获取 帖子图片 子目录
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_topic_image_subdirectory()
{
    return 'topic';
}


/**
 * 获取帖子图片路径
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_topic_image_path()
{
    $res = \think\Config::get('view_replace_str');
    return $res['__PUBLIC__'] . 'uploads/' . get_topic_image_subdirectory();
}


/**
 * 保存图片
 * @param $imgfile 上传的文件
 * @param string $subdir
 * @param bool|true $istime
 * @return string
 * User: zhaibaoming
 * Date: 2018-08-09
 */
function save_images($imgfile, $subdir = '')
{
    $image = \think\Image::open($imgfile);
    $time = date('Ymd', time());
    if ($subdir) {
        $imgdir = ROOT_PATH . 'public' . DS . 'uploads' . DS . $subdir;
    } else {
        $imgdir = ROOT_PATH . 'public' . DS . 'uploads';
    }
    $truePath = $imgdir . DS . $time;
    if (!is_dir($truePath)) {
        mkdir(iconv("UTF-8", "GBK", $truePath), 0777, true);
    }
    $imgname = substr(str_shuffle('abcdefghigklmnewrwrwerwererfgfd234234'), 0, 4) . time() . '.png';
    $result = $image->save($truePath . '/' . $imgname , 'png');
    $imgName = $time . '/' . $imgname;
    return $result ? $imgName : false;
}

/**
 * 保存图片 并生成缩略图
 * @param $imgfile 上传的文件
 * @param string $subdir
 * @param bool|true $istime
 * @return img_name 原图名    thumb_name 缩略图名
 * User: zhaibaoming
 * Date: 2018-08-29
 */
function save_images_thumbnail($imgfile, $subdir = '', $thumbWhith = 0, $thumbHeight = 0)
{
    $image = \think\Image::open($imgfile);
    $time = date('Ymd', time());
    if ($subdir) {
        $imgdir = ROOT_PATH . 'public' . DS . 'uploads' . DS . $subdir;
    } else {
        $imgdir = ROOT_PATH . 'public' . DS . 'uploads';
    }
    $truePath = $imgdir . DS . $time;
    if (!is_dir($truePath)) {
        mkdir(iconv("UTF-8", "GBK", $truePath), 0777, true);
    }
    $name1 = substr(str_shuffle('abcdefghigklmnewrwrwerwererfgfd234234'), 0, 4) . time();
    $imgname = $name1 . '.png';
    $thumbname = $name1 . '_s.png';
    $result = $image->save($truePath . '/' . $imgname);
    if ($result) {
        $result = $image->thumb(150,150,\think\Image::THUMB_CENTER)->save($truePath . '/' . $thumbname);
        if (empty($result)) {
            return false;
        }
        $data['img_name'] = $time . '/' . $imgname;
        $data['thumb_name'] = $time . '/' . $thumbname;
        return $data;
    }

    return false;
}

/**
 * 获取 品牌故事图片 子目录
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_brand_story_image_subdirectory()
{
    return 'brand_story';
}


/**
 * 获取品牌故事图片路径
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_brand_story_image_path()
{
    $res = \think\Config::get('view_replace_str');
    return $res['__PUBLIC__'] . 'uploads/' . get_brand_story_image_subdirectory();
}


/**
 * 获取 玩转积分 图片 子目录
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_play_integral_image_subdirectory()
{
    return 'play_integral';
}


/**
 * 获取 玩转积分 图片路径
 * @return string
 * User: zhaibaoming
 * Date: ${DATE}
 */
function get_play_integral_image_path()
{
    $res = \think\Config::get('view_replace_str');
    return $res['__PUBLIC__'] . 'uploads/' . get_play_integral_image_subdirectory();
}

/**
 * 提示文字 配置数组
 * @return array
 * User: zhaibaoming
 * Date: ${DATE}
 */
function hint_text()
{
    return [
        1 => '取件评价',
        2 => '选片评价',
        3 => '礼服详情',
        4 => '取件详情',
        5 => '选片详情',
        6 => '预约取件',
        7 => '档期详情',
        8 => '人员服务评价',
        9 => '服务评价',

        100 => '拍摄详情-拍摄内容',
        101 => '拍摄详情-注意事项',
        102 => '拍摄详情-新郎拍摄须知',
        103 => '拍摄详情-新娘拍摄须知',
    ];
}

/**
 * 评价问卷列表
 * @return array
 * User: zhaibaoming
 * Date: ${DATE}
 */
function evaluation_questionnaire_list()
{
    return [
        1 => '拍摄评价',
        2 => '选片评价',
        3 => '取件评价',
    ];
}

/**
 * 评价问卷的 上下限制
 * @return array
 * User: zhaibaoming
 * Date: ${DATE}
 */
function evaluate_limit()
{
    return [
        'titleUpperLimit' => 10, // 题目上限
        'answerUpperLimit' => 10, // 答案上限
        'answerLowerLimit' => 2, // 答案下限
    ];
}