<?php
/**
 * 基础类的基础函数库
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-18 $
 */

/**
* 获取本系统内的所有模块信息。
* 
* @return Array 所有模块列表数组
* @author songdemei<songdemei@suxuantech.cn> 2017-10-18
*/
use think\Session;
function loginCheck () {
    $openid = Session::get('openid');
    if($openid){
        $prevLoginTime = Session::get('logintime');
        if($prevLoginTime<(time()-300)){
            $isUser = db('m_users')->where(['openid'=>$openid])->count();
            if($isUser){
                Session::set('logintime',time());
                return true;
            }
            return false;
        }else{
            return true;
        }
    }
    return false;
}
/**
 * 方法描述     积分日志方法
 * @return mixed $title 标题 $minute 积分值 $userid 执行人  $type 类型
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
//function minuteDetailed ($title,$minute,$userid,$type) {
//    $datas = array('m_title'=>$title,'m_num'=>$minute,'m_time'=>date('Y-m-d'),'m_executor'=>$userid,'m_type'=>$type);
//    $minuteDetailed = db('minute_log')->insert($datas);
//    if ($minuteDetailed) {
//        return true;
//    } else {
//        return false;
//    }
//}
/**
 * 方法描述     分享方法
 * @return mixed
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
function weShare($appid,$brandid){
     require_once 'vendor'.DS.'weshare'.DS.'JSSDK.php';
     $jssdk = new JSSDK($appid,$brandid);
     $signPackage = $jssdk->GetSignPackage();
     return $signPackage;
}

/**
 * 获取具体位置
 * @param  [type] $lat [纬度]
 * @param  [type] $lng [经度]
 * @return [type]      [description]
 * @author wangyining 2019-02-11
 */
function getRealAddress($lat,$lng){
    $address = '';
    if($lat && $lng){

        $arr = changeToBaidu($lat,$lng);
        $url = 'http://api.map.baidu.com/geocoder/v2/?callback=&location='.$arr['y'].','.$arr['x'].'.&output=json&pois=1&ak=IeRjfQ7puEUEGhGpf9PVMrvK';
        $content = httpRequest($url,"GET");
        $place = json_decode($content,true);
        $province = $place['result']['addressComponent']['province'];//省
        $city = $place['result']['addressComponent']['city'];//市
        $district = $place['result']['addressComponent']['district'];//区
        $street = $place['result']['addressComponent']['street'];//街道
        $address = $place['result']['formatted_address'];//详细地址

    }

    return ['province'=>$province,'city'=>$city,'district'=>$district,'street'=>$street,'address'=>$address];
}

/**
 * 转换为百度经纬度
 * @param  [type] $lat [description]
 * @param  [type] $lng [description]
 * @return [type]      [description]
 * @author wangyining 2019-02-11
 */
function changeToBaidu($lat,$lng){
    $apiurl = 'http://api.map.baidu.com/geoconv/v1/?coords='.$lng.','.$lat.'&from=1&to=5&ak=IeRjfQ7puEUEGhGpf9PVMrvK';
    $file = file_get_contents($apiurl);
    $arrpoint = json_decode($file, true);
    return $arrpoint['result'][0];
}

 

/**
 * 方法描述     写入登陆日志
 * @return mixed
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月6日 下午3:04:12
 */
function writeLoginLog ($d) {
    if($d){
        // 写入log日志表
        db("user_logs")->insert($d);
    }
    return true;
}

function S($name,$value="",$options = null) {
    return cache($name, $value, $options);
}
function I($key,$default = null,$filter = '') {
    return input($key,$default,$filter);
}
function C($name,$value=null,$range='') {
    return config($name,$value,$range);
}
function D($param) {
    return db($param);
}
function U($url = '', $vars = '', $suffix = true, $domain = false) {
    return url($url , $vars, $suffix, $domain);
}
function L($string){
    return Lang($string);
}

