<?php
/**
 * 客片大赏
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author:
 */

namespace app\front\controller;
use think\Request;
use think\Session;

class Guestphoto extends BaseFront
{

    //客片页面
    public function index(){

        //客片分类
        $type = db('guest_photo_type')->where('brand_id',session('brand_id'))->order('sort asc')->select();

        $type_id = input('type_id') ? input('type_id') : $type[0]['id'];

        //系统设置中 是否允许会员自己上传客片
        $can_upload = db('c_sysconfig')->where('ckey','front_upload_photo')->value('cvalue');

        $this->assign(['type'=>$type,'type_id'=>$type_id,'can_upload'=>$can_upload]);

        return view('index');
    }

    /*
     * 获取某事业部分类下客片
     */
    public function getTypePhoto(){

        $type_id = input('type_id');
        $tip_name = input('tip_name');

        if(!$type_id){
            $type = db('guest_photo_type')->where('brand_id',session('brand_id'))->order('sort asc')->select();
            $type_id = $type[0]['id'];
        }

        $page = input('page') ? input('page') : 1;
        $limit = input('limit') ? input('limit') : 10;

        if($tip_name){
            $data = controller('Guestphoto','lib')->getTypePhotoData($type_id,$page,$limit,$tip_name);
        }else{
            $data = controller('Guestphoto','lib')->getTypePhotoData($type_id,$page,$limit);
        }

        //$count = controller('Guestphoto','lib')->getTypePhotoCount($type_id);

        return json(['code'==200,'data'=>$data]);
    }


    /*
     * 客片详情
     */
    public function detail(){

        $id = input('id');

        $detail = db('guest_photo')->where('id',$id)->find();

        $detail['content_img'] = json_decode($detail['content_img'],true);

        $this->assign('detail',$detail);

        return $this->fetch();
    }


    /*
     * 上传客片操作
     */
    public function addGuestPhoto(){

        if(Request::instance()->isAjax()){
            $params = input();

            $res = controller('Guestphoto','lib')->addGuestPhoto($params);

            return $res;
        }

        $type_id = input('type_id');

        //客片分类列表
        $type = db('guest_photo_type')->where('brand_id',session('brand_id'))->order('sort asc')->select();

        $this->assign(['type_id'=>$type_id,'type'=>$type]);
        return $this->fetch('upload');
    }



    /**
     * 通用图片上传接口
     * @return \think\response\Json
     */
    public function upload()
    {
        $config = [
            'size' => 20971520,
            'ext'  => 'jpg,gif,png,bmp'
        ];
        $file        = $this->request->file('file');
        $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
        $save_path   = '/uploads/';
        $info        = $file->validate($config)->move($upload_path);
        if ($info) {
            $result = [
                'error' => 0,
                'url'   => str_replace('\\', '/', $save_path . $info->getSaveName())
            ];
        } else {
            $result = [
                'error'   => 1,
                'message' => $file->getError()
            ];
        }
        return json($result);
    }


    /*
     *  用户的客片
     */
    public function myPhoto(){

        $data = db('guest_photo')
            ->alias('photo')
            ->join('guest_photo_type type','photo.type_id = type.id','left')
            ->where('photo.user_id',$this->userId)
            ->where('photo.brand_id',$this->brandId)
            ->field('photo.*,type.type_name')
            ->order('status asc')
            ->select();

        //系统设置中 是否允许会员自己上传客片
        $can_upload = db('c_sysconfig')->where('ckey','front_upload_photo')->value('cvalue');

        $this->assign(['data'=>$data,'can_upload'=>$can_upload]);
        return $this->fetch();

    }


    /*
     * 所有分类下客片
     */
    public function getAllTypePhoto($photo_type_tip){

        $type = db('guest_photo_type')->where('brand_id',$this->brandId)->order('sort asc')->select();

        $photo = db('guest_photo')
            ->where(['brand_id'=>$this->brandId,'status'=>1])
            ->field('id,title,content_text,type_id,cover_img')
            ->order('sort asc')
            ->select();

        //分类下展示标签
        if($photo_type_tip == 1){
            foreach($type as $key => $val){
                $arr = [];
                foreach($photo as $k => $v){

                    if($v['type_id'] == $val['id']){
                        $arr[] = $v['content_text'];
                    }
                }
                $arr = array_unique($arr);
                $arr2 = array_slice($arr,0,6);
                $tip = db('guest_photo_tip')
                    ->where(['tip_name'=>['in',$arr2]])
                    ->field('id,tip_name,img as cover_img')
                    ->select();
                $type[$key]['photo'] = $tip;
            }
        }else{
            //分类下直接展示客片
            foreach($type as $key => $val){
                foreach($photo as $k => $v){

                    if($v['type_id'] == $val['id']){
                        $type[$key]['photo'][] = $v;
                    }
                }
            }
        }

       return $type;
    }

    //分类标签页
    public function tipindex(){

        //客片分类
        $type = db('guest_photo_type')->where('brand_id',session('brand_id'))->order('sort asc')->select();

        $type_id = input('type_id') ? input('type_id') : $type[0]['id'];

        $this->assign(['type'=>$type,'type_id'=>$type_id]);

        return view('tipindex');
    }

    /*
     * 获取分类下标签
     */
    public function getTypeTip(){
        $type_id = input('type_id/d');
        if(!$type_id){
            $type = db('guest_photo_type')->where('brand_id',session('brand_id'))->order('sort asc')->select();
            $type_id = $type[0]['id'];
        }

        $photo = db('guest_photo')
            ->where(['brand_id'=>$this->brandId,'status'=>1,'type_id'=>$type_id])
            ->field('id,title,content_text,type_id,cover_img')
            ->order('sort asc')
            ->select();

        $arr = array_unique(array_column($photo,'content_text'));

        $tip = db('guest_photo_tip')
            ->where(['tip_name'=>['in',$arr]])
            ->field('id,tip_name,img')
            ->select();
        return ['code'=>200,'data'=>$tip];
    }

    /*
     * 分类标签页
     */
    public function tipPhoto(){
        $type_id = input('type_id');
        $tip_name = input('tip_name');

        $this->assign([
            'type_id'=>$type_id,
            'tip_name'=>$tip_name,
        ]);
        return view('tipphoto');
    }

}