<?php
/**
 * 会员中心首页
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月16日 下午3:48:53
 */
namespace app\front\controller;
use app\front\lib\Rili;
use think\Cache;
use app\vip\model\TTaskList;
use think\Controller;
use think\Db;
use think\db\Query;
use think\image\Exception;
use think\Session;
use app\front\controller\BaseFront;
use app\front\model\Mem;

class Payment extends BaseFront{
    protected $libname = "Payment";
    /**
     * 方法描述：支付 -----------------------------------------暂时未用
     * @param unknown $front_money 支付金额
     * @param unknown $order_no 单号
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月15日 15:38:38
     */
    public function payment()
    {
        //$price        = input('price'); //价格
        // $order_no = $this->rands();
        //$action   = input('action');     //判断 支付类型（action=jiujiu 说明是 99会员支付，否则是套系支付）

        $attach   = input('attach');     //支付类型，用于区分mc回调时接口
        $order_sn = input('order_sn');   //支付单号
        $response_url = input('response_url');  //回调地址

        if($order_sn){
            if($attach == "99vip"){ //99会员支付
                $vip = db('jgq_vip_coupon')->where('brand_id',$this->brandId)->find();
                $price = $vip['price'];

            }elseif($attach == 'jgq'){  //套系支付
                $where['payment_order_sn'] = $order_sn;
                $orderinfoData = controller('jgqvip','lib')->orderinfoList($where);
                $price = $orderinfoData['pay_money'];//实际支付金额

                /*
                * 每次生成新的流水号 调用mc支付接口，解决同一单号再次发起支付问题
                */
                $serial_number = $this->rands();
                $insertSerial = db('s_order_serial')->insert([
                    'order_number'  => $order_sn,
                    'serial_number' => $serial_number,
                    'pay_price'     => $price,
                    'pay_status'    => '1',//1，未支付，2支付成功，3支付失败
                    'add_time'      => date('Y-m-d H:i:s'),
                ]);

                if($insertSerial === false){
                    echo "生成订单流水号错误，请联系工作人员！";die;
                }

                //传给mc的单号 改为新的流水号
                $order_sn = $serial_number;

            }



            //回调地址以及流水号
            $response_url = strpos($response_url,'?') === false ? urldecode($response_url).'?' : urldecode($response_url).'&';
            $response_url .= 'order_no='.$serial_number;

            $data['body']       = Session::get("group_company_name") . "-在线订单支付";
            $data['total_fee']  = $price * 100;
            $data['trade_type'] = "JSAPI";
            $data['order_no']   = $order_sn;
            //$data['order_no']   = $serial_number;
            $data['brand_id']   = Session::get("brand_id");
            $data['open_id']    = Session::get("openid");
            $data['attach']     = $attach; //用于区分mc回调时接口
            $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
            if ($payOrder['code'] == 200) {
                $prepay_id = $payOrder['data']['prepay_id'];
                $arr['prepay_id'] = $prepay_id;
                $arr['brand_id'] = Session::get("brand_id");
                $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
                if($payment['code'] !== 200){
                    echo "错误码：".$payment['code'].',错误提示：'.$payment['msg'].'。请联系工作人员！';die;
                }
            }else{
                echo "错误码：".$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！';die;
            }

            $this->assign('order_sn', $order_sn);
            //$this->assign('order_sn', $serial_number);
            $this->assign('response_url',urlencode($response_url));
            $this->assign('payment', $payment);
            return view();
        }

    }


    /**
     * 方法描述：订单号生成
     * @return string
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月15日 11:18:38
     */
     public function rands()
    {
        $str = '1234567890';
        $randStr = str_shuffle($str);//打乱字符串
        $rands = substr($randStr, 0, 5);
        $rand = time() . Session::get("memid") . $rands;
        return $rand;
    }
    public function paymentJudge(){
        $order_no = input("order_no");
        $price    = input("price");
        $res = controller($this->libname,'lib')->paymentJudge();

    }


    /*
    * 支付
    *  order_sn  订单编号
    *  price     价格
    * attach     标识，用于区分mc回调时调用的接口
    */
    public function paymentPrice(){

        $order_sn = input('order_sn');
        $price = input('price');
        $attach = input('attach');

        $data['body']       = Session::get("group_company_name") . "-线上支付";;
        $data['total_fee']  = $price * 100;
        $data['trade_type'] = "JSAPI";
        $data['order_no']   = $order_sn;
        $data['brand_id']   = Session::get("brand_id");
        $data['open_id']    = Session::get("openid");
        $data['attach']     = $attach;//用于区分mc回调时接口
        $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
        if ($payOrder['code'] == 200) {
            $prepay_id = $payOrder['data']['prepay_id'];
            $arr['prepay_id'] = $prepay_id;
            $arr['brand_id'] = Session::get("brand_id");
            $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
            if($payment['code'] !== 200){
                echo "错误码1：".$payment['code'].',错误提示：'.$payment['msg'].'。请联系工作人员！';die;
            }
        }else{
            echo "错误码2：".$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！';die;
        }

        //支付后回调页面
        $response_url = '/front/Payment/completePay?price='.$price;

        $this->assign('order_sn', $order_sn);
        $this->assign('response_url', $response_url);

        $this->assign('payment', $payment);
        return view('payment');
    }

    /*
     * 完成支付展示页
     */
    public function completePay(){
        $price = input('price');
        $this->assign('price',$price);
        return view('payment2');
    }

    /*
    * 订单支付页面（订单详情）
    */
    public function paymentErpOrder(){

        $order_id = input('order_id');
        $code = input('code');
        /*
         * 调erp接口查询订单信息 付款信息
         */
//        $erp = config('ext.app_config');  //读取erp配置文件
//        $addr = $erp['sx_erp']['addr'];  //调用url
//        $url = $addr . '/SX_VipApi/Vip_OnLinePaymentOpen?Token=^******^&orderId='.$order_id.'&pay_code='.$code.'&paystate=1';
//        $response = requestERP($url, '');  //调用erp接口

//        print_r($response);die;


        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $url = $addr . '/SX_VipApi/Vip_OnLinePaymentInfo?Token=^******^&orderId='.$order_id.'&pay_code='.$code; //定义拼接url
        $response = requestERP($url, '');  //调用erp接口
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $code);
        }

        //print_r($response);die;
        $erp_detail = $response['Data'];
        //总计
        $price = 0;
        foreach($erp_detail as $k => $v){
            $erp_detail[$k]['targetdate'] = date('Y-m-d',strtotime($v['targetdate']));
            $price = $price + $v['payment_money1'];
        }

        if(Session::get('mem_phone')){
            $recommend = db('recommend')->where(['r_phone'=>Session::get('mem_phone'),'status'=>2])->find();
        }
        //绑定订单
        $insertOrder = [
            'order_number' => $order_id,//订单编号
            'package_name' => $erp_detail[0]['package_name'],//套系名称
            'one_money'    => $erp_detail[0]['bargain_money'],//一销金额
            'two_money'    => $erp_detail[0]['supplementary_money'],//二销金额
            'one_detail'   => $erp_detail[0]['payment_money'],//一销实付
            'two_detail'   => 0,//二销实付
            'total_money'  => $erp_detail[0]['total_money'],//订单总金额
            'order_time'   => $erp_detail[0]['targetdate']?date('Y-m-d', strtotime($erp_detail[0]['targetdate'])):null,//订单时间
            'phone'   => Session::get('mem_phone'),//手机号
            'brandid' => Session::get('brand_id'),//事业部id
            'order_userid' => Session::get('phoneid'),//m_users_phone表id
            'user_id' => $this->userId,//m_users表id
            'recommend_id' => $recommend['id'],
            'create_time'  => date('Y-m-d H:i:s', time()),//记录时间
        ];

        $insertPay = [
            'pay_code' => $code,
            'order_number' => $order_id,
            'order_time'   => $erp_detail[0]['targetdate']?date('Y-m-d', strtotime($erp_detail[0]['targetdate'])):null,//订单时间
            'price_content'   => $price,//订单付款详情
            'price'   => $price,//订单金额
            'pay_status'   => 1,//支付状态1未支付，2支付完成
            'create_time' => date('Y-m-d H:i:s')
        ];


        $errorMsg = '';
        db()->startTrans();
        try{

            if(!db('m_order')->where('order_number',$order_id)->find()){
                //绑定订单
                db("m_order")->insert($insertOrder);
            }

            //创建支付信息
            $pay_detail = db('erp_pay')->where('pay_code',$code)->find();
            if(!$pay_detail){
                db('erp_pay')->insert($insertPay);
            }

            db()->commit();
        }catch (Exception $e){
            $errorMsg = $e->getMessage();
            db()->rollback();
        }

        if(!$erp_detail){
            $errorMsg = '未获取到erp付款信息';
        }

        unset($insertOrder,$insertPay);

        //支付后回调页面
        $response_url = '/front/Payment/completePay?price='.$price;
        $this->assign('response_url', $response_url);

        $this->assign('errorMsg',$errorMsg);
        $this->assign(['pay_code'=> $code,'order_id'=>$order_id]);
        $this->assign(['price'=>$price,'pay_detail'=>$pay_detail,'erp_detail'=>$erp_detail]);

        return view('paymenterporder');
    }

    /*
     * 点击支付后 获取支付信息
     */
    public function doPay(){
        $pay_code = input('pay_code');
        $price = input('price');

        $serial = [
            'erp_pay_code'  => $pay_code,
            'serial_number' => controller('Payment')->rands(),
            'pay_price'     => $price,
            'pay_status'    => 1,
            'add_time'      => date('Y-m-d H:i:s')
        ];

        db()->startTrans();
        try{
            //新增一条流水号信息
            db('erp_pay_serial')->insert($serial);

            $data['body']       = Session::get("group_company_name") . "-线上支付";
            $data['total_fee']  = $price * 100;
            $data['trade_type'] = "JSAPI";
            $data['order_no']   = $serial['serial_number'];
            $data['brand_id']   = Session::get("brand_id");
            $data['open_id']    = Session::get("openid");
            $data['attach']     = 'payErpOrder';//用于区分mc回调时接口

            $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
            if ($payOrder['code'] == 200) {
                $prepay_id = $payOrder['data']['prepay_id'];
                $arr['prepay_id'] = $prepay_id;
                $arr['brand_id'] = Session::get("brand_id");
                $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
                if($payment['code'] !== 200){
                    db()->rollback();
                    return array('code'=>202,'msg'=>'错误码2：'.$payment['code'].',错误提示：'.$payment['msg'].'。请联系工作人员！');
                }
            }else{
                db()->rollback();
                return array('code'=>201,'msg'=>'错误码1：'.$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！');
            }

            db()->commit();
            return array('code'=>200,'data'=>$payment['data']);
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>204,'msg'=>$e->getMessage());
        }
    }

    /*
     * 提交订单页面
     */
    public function submitOrder(){
        $shop_code = input('shop_code');
        $package_ids = input('package_ids');//套系id
        $reach_shop_date = input('reach_shop_date');//到店时间

        $shopRes = controller('Order','lib')->getShopInfo($shop_code);
        $shopInfo = $shopRes['data'];

        $erp = config('ext.app_config');
        $addr = $erp['sx_erp']['addr'];

        //折扣是否可与优惠券同用  1可以，2不可以
        $is_with = db('c_sysconfig')->where('ckey','vip_coupon_with')->value('cvalue');

        //用户信息 等级折扣
        $userInfo = db('m_users')
            ->alias('user')
            ->where('user.id',session('userid'))
            ->join('user_level level','user.level = level.id','left')
            ->field('user.*,level.name,level.discount')
            ->find();

        if($userInfo['brithday'])  $userInfo['brithday'] = date('Y-m-d',strtotime($userInfo['brithday']));

        //线上下单是否使用erp线下储值卡消费 1是，2不是（以此设定为主）
        $erp_vip_card = db('c_sysconfig')->where('ckey','erp_vip_card')->value('cvalue');

        if($userInfo['erp_vipcard']){
            $erpCardInfo = db('c_vipcardinfo','db_erp')->where(['cardid'=>$userInfo['erp_vipcard']])->find();
            $erp_discount = $erpCardInfo['percents'] / 10;
        }

        if($erp_vip_card == 1 && $erp_discount < 1){
            //线下会员的折扣
            $discount = $erp_discount;
            $discount_name = 'erp会员卡折扣';

        }elseif($userInfo['discount'] > 0 && $userInfo['discount'] < 1){
            //vip系统的会员等级折扣
            $discount = $userInfo['discount'];
            $discount_name = '会员折扣';
        }

        //若店面展示所有套系，购物车中的套系来自多个店，所以查询条件中 不加店面
        $all_package = db('c_sysconfig')->where('ckey','all_package')->value('cvalue');
        if($all_package != 1){
            $shopSql = 'cart.shop_code = "'.$shop_code.'"';
        }
        
        //选购清单内套系详情
        $packageList = db('s_package_cart')
            ->where('cart.package_id','in',$package_ids)
            ->where('cart.user_id',session('userid'))
            //->where('info.use_coupon',1)
            ->where($shopSql)
            ->alias('cart')
            ->join('s_package_info info','cart.package_id = info.id','left')
            ->field('cart.id,cart.package_id,cart.price_type,cart.price,info.package_name,info.erp_package_name,info.package_price,info.shop_code,info.shop_name,info.brand_id,info.consumption_type,info.use_coupon')
            ->order('add_time desc')
            ->select();


        //print_r($packageList);die;
        //每个套系相应优惠券
        $couponList = [];
        $required = [];
        $have_price_type = false;
        foreach($packageList as $key => $val){
            if($discount){
                //会员折扣后价格  差价
                $new_package_price = $val['package_price'] * $discount;
                $packageList[$key]['new_package_price'] = round($new_package_price,2);
                $packageList[$key]['vip_diff'] = $val['package_price'] - $packageList[$key]['new_package_price'];
                //全款 则应付折扣后
                if($val['price_type'] == 1){
                    $packageList[$key]['pay_price'] = round($new_package_price,2);
                }else{
                    //定金则应付为定金
                    $packageList[$key]['pay_price'] = $val['price'];
                }
            }else{
                $packageList[$key]['new_package_price'] = $val['package_price'];
                $packageList[$key]['vip_diff'] = 0;

                $packageList[$key]['pay_price'] = $val['price'];
            }

            //允许使用优惠券的套系
            if($val['use_coupon'] ==1){
                $coupon = controller('Order','lib')->getCoupon(session('userid'),$val['price'],$val['package_id']);
                $couponList = array_merge($couponList,$coupon['data']);
            }

            //$packageList[$key]['coupon'] = $coupon['data'];
            //$packageList[$key]['coupon_count'] = $coupon['count'];

            //根据消费类型 获取必填项
            $consumption_type = $val['consumption_type'];
            if($consumption_type){

                $url = $addr.'SX_ChildErpAppNew/SX_MustfillSet?Token=^******^&Consumption_Name='.$consumption_type;

                $response = requestERP($url, '');

                if ($response['Code'] == 200) {
                    $array = $response['Data'] ? explode(';',$response['Data']) : [];
                    $required = array_merge($required,$array);
                }
            }

            //订单中有选择定金的套系
            if($val['price_type'] == 2){
                $have_price_type = true;
            }

        }


        //套系折扣前总价 折扣后总价 总优惠
        $total =  array_sum(array_map(create_function('$val', 'return $val["package_price"];'), $packageList));
        $new_total =  array_sum(array_map(create_function('$val', 'return $val["new_package_price"];'), $packageList));
        $diff = $total - $new_total;


        //支付 折扣前总金额  折扣后总金额
        $pay_total =  array_sum(array_map(create_function('$val', 'return $val["price"];'), $packageList));
        $vip_pay_total =  array_sum(array_map(create_function('$val', 'return $val["pay_price"];'), $packageList));

        //优惠券 排重
        $coupon_ids = [];
        foreach($couponList as $k => $v){
            if(!in_array($v['id'],$coupon_ids)){
                $coupon_ids[] = $v['id'];
            }else{
                unset($couponList[$k]);
            }
        }

        //下单是强制查看协议
        $must_look_agreement = db('c_sysconfig')->where('ckey','must_look_agreement')->value('cvalue');

        /**  婚纱还是儿童，取下单店的标识，更符合要求。
        $Etbrandid =  db_config(ET_BRAND);
        if(Session::get("brand_id") == $Etbrandid){
            $zltype = 'ET';
        }else{
            $zltype = 'HS';
        }**/
        //$zltype = 'HS';
        if($shopInfo['shop_type'] == 2){
            $zltype = 'ET';
        }else{
            $zltype = 'HS';
        }

        //使用线下erp卡，并且erp卡里有余额，并且订单里没定金，则支付可使用
        if($erp_vip_card == 1 && $erpCardInfo['cardmoney'] > 0 && $have_price_type === false){
            $this->assign('cardmoney',$erpCardInfo['cardmoney']);
        }

        $this->assign([
            'package_ids' => $package_ids,
            'shop_code'=> $shop_code,
            'shopInfo' => $shopInfo,
            'userInfo' => $userInfo,
            'packageList' => $packageList,
            'couponList'  => $couponList,
            'reach_shop_date' => $reach_shop_date,
            'discount'  => $discount,//折扣
            'total'     => $total,//折扣前总价
            'new_total' => $new_total,//折扣后总价
            'diff'      => $diff,//优惠价
            'pay_total' => $pay_total,//此次支付总价
            'vip_pay_total' => $vip_pay_total,
            'nowYear'   => date('Y'),
            'is_with'   => $is_with,
            'required'  => $required,//订单必填项
            'must_look_agreement'  => $must_look_agreement,//必须预览协议
            'zltype'    => $zltype,//婚纱/儿童
            'discount_name' => $discount_name,//折扣显示名称，erp的线下储值卡折扣/vip的会员折扣
            'check' => input('check'),
        ]);


        return $this->fetch('Order/submitorder');
    }

    /*
     * 点击支付后 获取支付信息
     */
    public function submitPackageOrder(){

        $total_price = input('total_price');
        $total_erp_card_diff = input('total_erp_card_diff');//使用erp卡优惠总金额
        $discount = input('discount');
        $shop_code = input('shop_code');
        $shop_name = input('shop_name');
        $reach_shop_date = input('reach_shop_date');//到店时间
        $bb_name = trim(input('bb_name'));//宝宝姓名
        $bb_birthday = trim(input('bb_birthday'));//宝宝生日
        $bb_sex = trim(input('bb_sex'));//宝宝性别
        $packageOrder = input('packageOrder/a');
        $wname = trim(input('wname'));  //妈妈姓名
        $wphone = trim(input('wphone'));  //妈妈手机号

        $wsname  = trim(input('wsname'));   //女士姓名
        $wsphone = trim(input('wsphone'));  //女士手机号
        $wwechat = trim(input('wwechat'));  //女士微信
        $address = trim(input('address'));  //地址

        $yc_day = trim(input('yc_day'));//预产期

        $userInfo = db('m_users')->where('id',session('userid'))->find();
        

        if($total_erp_card_diff > 0){
            $erpVipCard = db('c_vipcardinfo','db_erp')->where('cardid',$userInfo['erp_vipcard'])->find();//erp会员卡信息
            if($total_erp_card_diff > $erpVipCard['cardmoney']){
                return array('code'=>204,'msg'=>'erp储值卡金额不足！');
            }

        }
        $shopRes = controller('Order','lib')->getShopInfo($shop_code);
        $shopInfo = $shopRes['data'];

        db()->startTrans();
        try{
            $addData = [];
            foreach($packageOrder as $key => $val){
                $addData[] = [
                    'p_id'          => $val['package_id'],
                    'cart_id'       => $val['cart_id'],
                    'user_id'       => session('userid'),
                    'package_price' => $val['package_price'],       //套系原价
                    'vip_discount'  => $val['vip_diff']?$discount:0,//会员折扣
                    'vip_diff'      => $val['vip_diff'],            //会员折扣便宜了多少
                    'coupon_id'     => (int)$val['coupon_id'],      //优惠券id
                    'coupon_diff'   => $val['coupon_diff'],         //优惠券便宜了多少
                    'order_package_price' => $val['order_package_price'],//订单中套系金额
                    'order_pay_type'  => $val['price_type'],        //支付价格类型，1全款，2定金
                    'order_pay_price' => $val['order_pay_price'],   //订单应付金额
                    'shop_code'     => $shop_code, //店code
                    'shop_name'     => $shop_name, //店名称
                    'brand_id'      => session('brand_id'), //事业部
                    'bb_name'       => $bb_name ? $bb_name : null,        //宝宝姓名
                    'bb_birthday'   => $bb_birthday ? $bb_birthday : null,//宝宝生日
                    'bb_sex'        => $bb_sex ? $bb_sex : null,          //宝宝性别
                    'tel'           => $userInfo['phone'],                //手机号
                    'wname'         => $wname ? $wname : null,            //妈妈姓名
                    'wphone'        => $wphone ? $wphone : $userInfo['phone'],//妈妈姓名
                    'wsname'         => $wsname ? $wsname : null,            //妈妈姓名
                    'wsphone'        => $wsphone ? $wsphone : $userInfo['phone'],//妈妈姓名
                    'wwechat'       => $wwechat ? $wwechat : null,  //妈妈微信
                    'address'       => $address ? $address : null,  //地址
                    'yc_day'        => $yc_day ? $yc_day : null,//预产期
                    'reach_shop_date'  => $reach_shop_date ? $reach_shop_date : null,     //到店时间
                    'payment_order_sn' => $this->rands(),       //支付单号
                    'payment_status'=> 1,                       //支付状态，1未支付，2已支付
                    'create_time'   => date('Y-m-d H:i:s'),     //订单创建时间

                    'erp_vipcard_diff' => $val['erp_card_diff'],  //使用erp线下储值卡抵扣的金额
                    'erp_vipcard'    => $erpVipCard['cardid'],    //erp线下储值卡号
                    'erp_cardtype'   => $erpVipCard['cardtype'],  //erp线下储值卡类型
                ];

                //更改优惠券使用状态
                if($val['coupon_id'] && (int)$val['coupon_id'] > 0){
                    db('c_coupon_list')->where('id',$val['coupon_id'])->update(['status'=>1,'update_time'=>date('Y-m-d H:i:s')]);
                }

            }

            //套系订单
            db('s_package_order')->insertAll($addData);

            $order_numbers = implode(',',array_column($addData,'payment_order_sn'));

            //区分儿童婚纱 改为读取店的配置信息进行判断
            /**
            $Etbrandid =  db_config(ET_BRAND);
            
            if(Session::get("brand_id") == $Etbrandid){
                $zltype = 'ET';
            }else{
                $zltype = 'HS';
            }*/
            if($shopInfo['shop_type'] == 2){
                $zltype = 'ET';
            }else{
                $zltype = 'HS';
            }

            //新增一条流水号信息
            $serial_number = $this->rands();
            $serial = [
                'order_number'  => $order_numbers,
                'serial_number' => $serial_number,
                'pay_price'     => $total_price,
                'pay_status'    => 1,
                'add_time'      => date('Y-m-d H:i:s'),
                'zltype'        => $zltype,
            ];
            db('s_order_serial')->insert($serial);

            if($total_price > 0){
                $data['body']       = Session::get("group_company_name") . "-线上支付";
                $data['total_fee']  = $total_price * 100;
                $data['trade_type'] = "JSAPI";
                $data['order_no']   = $serial['serial_number'];
                $data['brand_id']   = Session::get("brand_id");
                $data['open_id']    = Session::get("openid");
                $data['attach']     = 'childPackage';//用于区分mc回调时接口

                $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
                if ($payOrder['code'] == 200) {
                    $prepay_id = $payOrder['data']['prepay_id'];
                    $arr['prepay_id'] = $prepay_id;
                    $arr['brand_id'] = Session::get("brand_id");
                    $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
                    if($payment['code'] !== 200){
                        db()->rollback();
                        return array('code'=>202,'msg'=>'错误码2：'.$payment['code'].',错误提示：'.$payment['msg'].'。请联系工作人员！');
                    }
                }else{
                    db()->rollback();
                    return array('code'=>201,'msg'=>'错误码1：'.$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！');
                }
            }else{
                db()->commit();
                return array('code'=>300,'data'=>$serial_number,'msg'=>'0元提交订单，无需支付');
            }
            db()->commit();
            return array('code'=>200,'data'=>$payment['data']);

        }catch (Exception $e){
            db()->rollback();
            return array('code'=>204,'msg'=>$e->getMessage());
        }

    }

    /**
     * 方法描述: 调取erp错误处理流程
     * @return payCode
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    private static function errorLog($url, $data)
    {
        $errorLogData = [
            'url' => $url,
            'data' => $data,
            'create_time' => date('Y-m-d'),
            'error_count' => 1,
        ];
        $logRes = db("c_vip_save")->insert($errorLogData);   //写入错误记录日志表
        if (!$logRes) {
            return array('code' => 201, 'msg' => '数据写入失败');
        }
        return 1;
    }


    /*
    * 先睹为快生成动态模板
    * orderId   订单号
    * fc_id     服次
    */
    public function photoAlbum(){
        $orderId = input('orderId');
        $fc = input('fc');

        //$shop_code = input('shop_code');//用于获取vip设置的店面信息（店面电话，店长二维码）
        $photo_shop_code = input('photo_shop_code');//摄影师所在店
        $cameraman = input('cameraman');//摄影师（推荐人）
        if(!$photo_shop_code || !$cameraman){
            $photoData = controller('order','lib')->getSneakPeek(['order_id'=>$orderId,'fc'=>$fc]);
            $cameraman = $photoData['cameraman'];//摄影师
            $photo_shop_code = $photoData['photo_shop_code'];//拍摄店
        }

        $orderData = db('m_order')
            ->where('order.order_number',$orderId)
            ->alias('order')
            ->join('m_users user','order.user_id = user.id','left')
            ->field('order.*,user.username,user.simg')
            ->find();

        //若订单没有绑定user_id，通过m_order表手机号查用户信息
        if(!$orderData['user_id']){
            $vipUser = db('m_users')->where('phone',$orderData['phone'])->find();
            $orderData['user_id']  = $vipUser['id'];
            $orderData['username'] = $vipUser['username'];
        }

        //若从分享进来，不是本人订单，更改推荐店，推荐订单，推荐人（摄影师）
        if(session('userid') != $orderData['user_id']){

            $u_recommend = db('m_users_recommend')->where('user_id',session('userid'))->find();
            $add = [
                'user_id' => session('userid'),
                'recommend_shop_code' => $photo_shop_code,
                'recommend_staff_name' => $cameraman,
                'recommend_order_number' => $orderId,
            ];

            if($u_recommend){
                 $add['update_time'] = date('Y-m-d H:i:s');
                db('m_users_recommend')->where('id',$u_recommend['id'])->update($add);
            }else{
                $add['add_time'] = date('Y-m-d H:i:s');
                db('m_users_recommend')->insert($add);
            }
        }

        //先睹为快照片
        $photoData = controller('order','lib')->getSneakPeek(['order_id'=>$orderId,'fc'=>$fc]);
        $photoArr = $photoData['photo'];

        //礼物
        $gift = db('m_gift')->where('brand_id',session('brand_id'))->select();

        //已发弹幕
        $getWish = db('m_order_wish')
            ->where(['wish.orderId'=>$orderId,'fc'=>$fc])
            ->alias('wish')
            ->join('m_users user','wish.user_id = user.id','left')
            ->field('wish.*,user.username,user.simg')
            ->order('wish.add_time desc')
            ->select();

        //弹幕祝福语   旧版页面弹幕用
        //$wishArr = array_reverse(array_column($getWish,'wish'));
        //$wishStr = $wishArr?implode(',',$wishArr):'';

        //已得到礼物
        $getGift = db('m_order_gift')
            ->where(['gift.orderId'=>$orderId,'gift.fc'=>$fc])
            ->where('gift.pay_time is not null')
            ->alias('gift')
            ->join('m_users user','gift.give_userid = user.id','left')
            ->field('gift.*,user.username,user.simg')
            ->order('gift.add_time desc')
            ->select();

        //vip设定的店面信息   旧版页面用
        /*
        $shopInfo = db('s_shop_info')->where('shop_code',$photo_shop_code)->find();
        if(!$shopInfo){
            $shopInfo['shop_code'] = $photo_shop_code;
            $shopInfo['shop_tel'] = db('c_kf')->where('brandid',session('brand_id'))->value('phone');
        }
        */

        //获取erp消费类型
        $erp = config('ext.app_config');   //读取配置文件
        $url = $erp['sx_erp']['addr'].'/SX_ChildErpAppNew/SX_ConsumptiontypeSet?Token=^******^';
        $response = requestERP($url, '');

        if ($response['Code'] == 200) {
            $consumptionType = $response['Data'];
        }

        //是否报过名
        $signUp = db('m_order_sign_up')->where('user_id',session('userid'))->find();

        //微信分享图片，不可分享其他链接的图片
        $imgPath = "/uploads/xdwk/".$orderId.'/'.$fc.'.jpg';
        if(!file_exists(ROOT_PATH."public".$imgPath)){
            $imgPath = $this ->savePhoto($orderId,$fc,$photoArr[1]);
        }

        //版本判断
        if(customize('babypastel')){
            $customize = 'babypastel';
            $this->assign(['customize'=>$customize]);

            $share_title = $orderData['username'].'宝宝大片抢先看';
        }


        //分享标题 图片 链接
        $setInfo = [
            'title'    => $share_title ? $share_title : '大片来袭',
            'img_path' => '/public'.$imgPath,
            'share_link' => url('front/Payment/photoAlbum','','',true).'?orderId='.$orderId.'&fc='.$fc.'&photo_shop_code='.$photo_shop_code.'&cameraman='.$cameraman,
            'content'  => '素人大改造，超有范！',
        ];

        $xdwkInfo = db('c_sysconfig')->where('ckey','xdwk_crm_url')->value('cvalue');
        $xdwk = json_decode($xdwkInfo,true);
        $xdwk_url = $xdwk['url'];

        $this->assign(['photoArr'=>$photoArr]);
        $this->assign([
            'orderId' => $orderId,
            'fc'      => $fc,
            'orderData'=> $orderData,
            'username'=> $orderData['username'],
            'userid'  => $orderData['user_id'],
            'gift'    => $gift,
            'getWish' => $getWish,
            'wishStr' => $wishStr,
            'getGift' => $getGift,
            'shopInfo'=> $shopInfo,
            'setInfo' => $setInfo,
            'consumptionType'=>$consumptionType,
            'signUp'  => $signUp,
            'myInfo'  => db('m_users')->where('id',session('userid'))->find(),
            'photo_shop_code'=>$photo_shop_code,
            'xdwk_url'=> $xdwk_url,
        ]);
        return view('Order/photoalbum2');

    }

    //根据图片地址，保存图片
    public function savePhoto($orderId,$fc,$url){

        set_time_limit(0);//抓取不受时间限制
        $url=str_replace('&amp;','&',$url);
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; SeaPort/1.2; Windows NT 5.1; SV1; InfoPath.2)");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 0);

        $values = curl_exec($curl);
        curl_close($curl);

        $fileName = $fc.'.jpg';
        $savePath = "/uploads/xdwk/".$orderId.'/';
        $path = ROOT_PATH.'public'.$savePath;

        if(!is_dir($path)){
            mkdir($path,'0755',true);
        }
        $fp2 = fopen($path.$fileName,'wb');

        fputs($fp2, $values);
        fclose($fp2);
        return $savePath.$fileName;
    }


    /*
     * 先睹为快打赏礼物
     */
    public function payGift(){
        $orderId = input('orderId');
        $fc = input('fc');
        $gift_id = input('gift_id');

        $order = db('m_order')->where('order_number',$orderId)->find();

        $gift = db('m_gift')->where('id',$gift_id)->order('sort asc')->find();
        $pay_number = $this->rands();
        $addData = [
            'orderId'    => $orderId,
            'fc'         => $fc,
            'gift_id'    => $gift_id,
            'gift_name'  => $gift['name'],
            'gift_img'   => $gift['img'],
            'gift_money' => $gift['money'],
            'gift_score' => $gift['score'],
            'give_userid'=> session('userid'),
            'get_userid' => $order['user_id'],
            'add_time'   => date('Y-m-d H:i:s'),
            'pay_number' => $pay_number,
        ];

        db()->startTrans();
        try{
            //新增一条流水号信息
            db('m_order_gift')->insert($addData);

            $data['body']       = Session::get("group_company_name") . "-线上支付";
            $data['total_fee']  = $gift['money'] * 100;
            $data['trade_type'] = "JSAPI";
            $data['order_no']   = $pay_number;
            $data['brand_id']   = Session::get("brand_id");
            $data['open_id']    = Session::get("openid");
            $data['attach']     = 'sneak-peek-gift';//用于区分mc回调时接口

            $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
            if ($payOrder['code'] == 200) {
                $prepay_id = $payOrder['data']['prepay_id'];
                $arr['prepay_id'] = $prepay_id;
                $arr['brand_id'] = Session::get("brand_id");
                $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
                if($payment['code'] !== 200){
                    db()->rollback();
                    return array('code'=>202,'msg'=>'错误码2：'.$payment['code'].',错误提示：'.$payment['msg'].'。请联系工作人员！');
                }
            }else{
                db()->rollback();
                return array('code'=>201,'msg'=>'错误码1：'.$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！');
            }

            db()->commit();
            return array('code'=>200,'data'=>['config'=>$payment['data'],'pay_number'=>$pay_number]);
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>204,'msg'=>$e->getMessage());
        }


    }

    /**
     * 充值支付
     * @return [type] [description]
     */
    public function charge(){

        $acdata = input();
        if(!$acdata['price']){
            return json(['code'=>202,'msg'=>'支付金额参数缺失！']);
        }
        $rands = $this->rands();
        $data['body']       = "会员卡充值-在线订单支付";
        $data['total_fee']  = $acdata['price'] * 100;
        $data['trade_type'] = "JSAPI";
        $data['order_no']   = $rands;
        $data['brand_id']   = Session::get("brand_id");
        $data['open_id']    = Session::get("openid");
        $data['attach']     = 'charge';//用于区分mc回调时接口
        $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
        if ($payOrder['code'] == 200) {
            $prepay_id = $payOrder['data']['prepay_id'];
            $arr['prepay_id'] = $prepay_id;
            $arr['brand_id'] = Session::get("brand_id");
            $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
            if($payment['code'] !== 200){
                return json(['code'=>202,'msg'=>'错误码：'.$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！']);
            }
            //添加记录
            $add = [
                    'userid' => $this->userId,   
                    'pay_status' => 1, //未确认支付
                    'price'  => $acdata['price']*100,
                    'create_time' => date('Y-m-d H:i:s',time()),
                    'user_number' => $acdata['user_number'],
                    'order_sn'    => $rands,
                ];
            $res = db('c_charge_log')->insert($add);
            if(!$res){
                return json(['code'=>202,'msg'=>'支付记录添加失败']);    
            }
            return json(['code'=>200,'msg'=>'成功','data'=>$payment['data']]);
        }else{
            return json(['code'=>202,'msg'=>'错误码：'.$payOrder['code'].',错误提示：'.$payOrder['msg'].'。请联系工作人员！']);
        }
    }

    /**
     * 充值
     */
    public function rechargepay(){

        $data = json_decode(db_config(SX_CHARGE.''.$this->brandId),true);
        $userinfo = db("m_users")->where('id',$this->userId)->find();

        $this->assign('user_number',$userinfo['user_number']);
        $this->assign('data',$data['data']);
        $this->assign('is_pay',$data['is_pay']);
        return view();
    }
   

}