<?php
/**
 * 前台活动处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\front\lib;
use think\Controller;
use app\vip\model\AActivityList;
use app\vip\model\AActivitySignUp;
use app\vip\model\AActivityLink;
use app\vip\model\AActivityVisit;
use think\Session;
class Activity extends Controller{
    
    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件 
     * 必须：brandid品牌id,isenjoy存在表示查询尊享活动，如果isenjoy存在 levelid是必须,
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        if(!$c && !$c['brandid']){
            return false;
        }
        $limit    = $c['limit']?$c['limit']:10;
        $pagenum  = $c['page']?($c['page']-1)*$limit:0;
        $w = ['status'=>1];
        $w['brandid'] = $c['brandid'];
        // 判断当前查看是不是尊享的活动

        if($c['isenjoy'] && $c['levelid']){
            $w2 = "instr(permit_level,$c[levelid])>0";
        }elseif($c['levelid']){
            $w2 = 'permit_level = "" or FIND_IN_SET("'.$c['levelid'].'",permit_level)';
        }else{
            $w2 = 'permit_level = ""';
        }
        //if($c['ishot']){
            $order = 'ishot desc,create_time desc';
        //}else{
            //$order = 'create_time desc';
        //}
        $d = AActivityList::where($w)
        ->where($w2)
        ->field('share_total,view_total,id,title,share_score,share_title,share_img,ishot,hot_img,share_content,index_img,start_time,end_time,status')
        ->order($order)
        ->limit($pagenum,$limit)
        ->select();
        //print_r(db()->getLastSql());die;
        return $d;
    }
    
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        if(!$c['brandid']){
            return false;
        }
        $w['brandid'] = $c['brandid'];
        return AActivityList::where($c)->count('id');
    }
 
    /**
     * 报名处理方法
     * @param array $d 数据数组 #phoneid当它存在说明已经绑了手机
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function signUp($d){
        if(!$d || !$d['activityid'] || !$d['userid'] ){
            return false;
        }else{
            $has = $this->isActivity($d['activityid']);
            if($has){
                if(!$this->isSignUp($d['activityid'],$d['userid'],$d['phoneid'])){
                    if($d['parent_id']){
                        $signupData = db("a_activity_sign_up")->where("userid",$d["parent_id"])->where("activityid",$d['activityid'])->find();
                        $d['share_userid'] = $d['parent_id'];
                        if($signupData){
                            $parent_ids = trim($signupData['parent_ids'].','.$d['parent_id'],',');
                            $d['parent_ids'] = $parent_ids;
                            $d['share_userid'] = $signupData['share_userid'];
                            //if($signupData['share_userid']) $d['share_userid'] = $signupData['share_userid'];
                        }
                    }
                    try{
                        db()->startTrans();
                        if($d['share_userid']){
                            $share_staffArr = $this->GetShareQrData(['userid'=>$d['share_userid'],'activityid'=>$d['activityid']]);
                            $share_userData = $this->GetShareQrData(['userid'=>$d['parent_id'],'activityid'=>$d['activityid']]);
                            if($share_staffArr){
                                if($share_staffArr['staff_id'] == 0){
                                    $share_staffid = -1;
                                }else{
                                    $share_staffid = $share_staffArr['staff_id'];
                                }
                            }
                            //推荐人
                            if($share_userData){
                                $share_name = $share_staffArr['staff_name'];

                                //mc获取手机号
                                $mcRes=sx_call('5a01766b4a3dd',['staffname'=>$share_name]);
                                if($mcRes['code']==200){
                                    $share_phone = $mcRes['data'][0]['telephone'];
                                }
                            }else{
                                //$username = db("m_users")->where('id',$d['parent_id'])->value('username');
                                $usersData = db('m_users')
                                    ->where('a.id',$d['parent_id'])
                                    ->alias('a')
                                    ->join('m_users_phone b','a.id = b.userid','left')
                                    ->field('a.*,b.phone')
                                    ->find();
                                $share_name = $usersData['username'];
                                $share_phone = $usersData['phone'];
                            }
                            $share_staffname = $share_staffArr['staff_name'];
                            $defaultstaffid  = $has['default_staff_id'];
                            //同步crm
                            $data['staff_id']              = $share_staffid;
                            $data['staff_name']            = $share_staffname;
                            $data['default_staff_id']      = $defaultstaffid;
                            $data['hd_name']               = $has['title'];
                            $data['baby_birthday']         = $d['baby_birthday'];
                            $data['customer_name']         = $d['b_username'];
                            $data['customer_tel']          = $d['b_phone'];
                            $data['consulation_shop_code'] = $d['shop_code'];
                            $data['consulation_shop']      = $d['shop_name'];
                            $data['shop_code']             = $has['affiliation_shop_code'];
                            $data['shop_name']             = $has['affiliation_shop_name'];
                            $data['customer_cource_id']    = $has['cource_id'];
                            $data['customer_cource']       = $has['cource_name'];
                            $data['introducer_name']       = $share_name;
                            $data['introducer_tel']        = $share_phone;
                            //return json(['code'=>202,'msg'=>$data]);
                            $crmArr = sx_call('5be54b43c8bb8',$data,'sx_crm');
                            if($crmArr['code'] !== 200){
                                db()->rollback();
                                if($crmArr['code'] == 102){
                                 //   payment_log('活动客资录入重复','活动id：'.$d['activityid'].'；重复手机号：'.$d['b_phone']);
                                    return json(['code'=>202,'msg'=>'该手机号已参加过活动']);
                                }else{
                                    return json(['code'=>202,'msg'=>'客资同步crm失败'.$crmArr['msg']]);
                                }
                            }
                            $d['cancel'] = $crmArr['data']['hx_code'];
                        }
                        $res = db("a_activity_sign_up")->insert($d);

                        //发送短信
                        $kr_phone = $d['b_phone'];
                        /*
                        $kr_send = db('c_sysconfig')->where('ckey',KR_SEND)->value('cvalue');

                        preg_match("/(?:\{)(.*)(?:\})/i",$kr_send,$name);
                        preg_match("/(?:\[)(.*)(?:\])/i",$kr_send,$cancel);
                        preg_match("/(?:\()(.*)(?:\))/i",$kr_send,$link);

                        $kr_send = str_replace($name[0],$d['b_username'],$kr_send);
                        $kr_send = str_replace($cancel[0],$crmArr['data']['hx_code'],$kr_send);
                        $kr_send = str_replace($link[0],$crmArr['data']['message'],$kr_send);

                        set_send($kr_phone,$kr_send,$d['b_username'],"客人");
                        */
                        //客人短信
                        $krData = [
                            '_mobile'      => $kr_phone,
                            '_template_id' => config('active_kr_template_id'),
                            '_brand_id'    => session('brand_id'),
                            'name'         => $d['b_username'],
                            'code'         => $crmArr['data']['hx_code'] ? $crmArr['data']['hx_code'] :'',
                            'link'         => $crmArr['data']['message'] ? $crmArr['data']['message'] : '',
                        ];
                        sms_send($krData,"客人");


                        $kf_phone = controller('index', 'lib')->getKf('phone');   //客服手机号
                        if($kf_phone){
                            /*

                            $kf_send = db('c_sysconfig')->where('ckey',KF_SEND)->value('cvalue');
                            preg_match("/(?:\{)(.*)(?:\})/i",$kf_send, $username);
                            preg_match("/(?:\[)(.*)(?:\])/i",$kf_send, $phone);

                            $kf_send = str_replace($username[0],$d['b_username'],$kf_send);
                            $kf_send = str_replace($phone[0],$d['b_phone'],$kf_send);

                            //客服短信
                            set_send($kf_phone,$kf_send,$d['b_username'],"客服");
                            */

                            $kfData = [
                                '_mobile'      => $kf_phone,
                                '_template_id' => config('active_kf_template_id'),
                                '_brand_id'    => session('brand_id'),
                                'name'         => $d['b_username'],
                                'phone'        => $d['b_phone'],
                            ];
                            sms_send($kfData,"客服");
                        }


                        if(!$res){
                            db()->rollback();
                            return json(['code'=>203,'msg'=>'报名失败']);
                        }
                        db('a_activity_list')->where('id='.$d['activityid'])->setInc('signup_total');
                        if($d['parent_id']){
                            db('a_activity_sign_up')->where('userid',$d['parent_id'])->where('activityid',$d['activityid'])->update(['share_num'=>['exp','share_num + 1']]);
                            db('a_activity_sign_up')->where('userid','in',$parent_ids)->where('activityid',$d['activityid'])->update(['fission_num'=>['exp',"fission_num + 1"]]);
                        }
                        db()->commit();
                        return json(['code'=>200,'msg'=>'报名成功','data'=>['id'=>$d['activityid'],'_share_userid'=>session('memid')]]);
                    }
                    catch(\Exception $e){
                        echo $e->getMessage();
                        db()->rollback();
                        return json(['code'=>203,'msg'=>'报名失败']);
                    }
                }
                return json(['code'=>202,'msg'=>'您已报名']); 
            }
            return json(['code'=>202,'msg'=>'抱歉活动已经结束']);
        }
    }
 
    /**
     * 记录浏览量
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function addVisit($d){
        if(!$d || !$d['activityid'] || !$d['userid']){
            return false;
        }else{
            $upview = db('a_activity_list')->where(['id'=>$d['activityid']])->setInc('view_total');
            if($d['link_code']){
                // 记录浏览记录
                db('a_activity_link')->where(['link'=>$d['link_code']])->setInc('visit_total');
            }
            if($upview){
                $this->addLinkVisit($d);
            }
        }
    }
    
    /**
     * 记录访问的数据
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function addLinkVisit($d){
            $res = AActivityVisit::create($d);
            return $res?true:false;
    }
    
    /**
     * 查询一个活动是否存在
     * @param array $c 查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function isActivity($id){
        if(!$id){
            return false;
        }
        $w = [];
        $w['id'] = $id;
        //$w['status'] = 1;
        return AActivityList::where($w)->find();
    }
    
    /**
     * 查询一个用户是否已经报名了某个活动
     * @param array $c 查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function isSignUp($id,$userid,$phoneid=0){
        if(!$id  || !$userid){
            return false;
        }
        $w = [ 'activityid'=>$id,'userid'=>$userid];
        return AActivitySignUp::where($w)->find();
    }
    
    /**
     * 获取一条信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){

        if(!$id){
            return false;        
        }else{
            if(!$this->isActivity($id)){
                return false;
            }
            $res = AActivityList::alias('a')
            ->where('a.id='.$id)
            ->field('n.title as couponname,n.img,a.id,a.title,a.style_detail,a.start_time,a.index_img,a.scontent,a.content,a.end_time,a.couponid,a.share_title,a.share_content,a.share_img,a.view_total,a.status,a.share_score,a.order_num')
            ->join('__C_COUPON_NUM__ n','n.id=a.couponid','left')
            ->find();

            if($res){
                // 用来标识活动是否已经过期
                $res['isend'] = 0;
                if($res['end_time']<date('Y-m-d H:i:s',time())){
                    $res['isend'] = 1;
                }
                return $res;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 获取一条活动的所有留言信息信息处理方法
     * @param array $c 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getMsgList($c){
        if(!$c['id']){
            return false;
        }else{
            $limit    = $c['limit']?$c['limit']:10;
            $pagenum  = $c['page']?($c['page']-1)*$limit:0;
            $res = db('a_activity_msg')->alias('a')
            ->where(['a.activity_id'=>$c['id'],'a.user_del'=>0,'a.status'=>1])
            ->field('a.content,p.username as pusername,u.openid,u.username,a.userid,a.id,a.create_time')
            ->join('__M_USERS_PHONE__ p','p.userid=a.userid','left')
            ->join('__M_USERS__ u','u.id=a.userid','left')
            ->order('create_time desc')
            ->limit($pagenum,$limit)
            ->select();
 
            return $res?$res:null;
        }
    }
    
    /**
     * 获取一条活动的所有留言信息信息的总数
     * @param array $c 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getMsgCount($c){
        if(!$c['id']){
            return false;
        }else{
            $res = db('a_activity_msg')->alias('a')
            ->where(['a.activity_id'=>$c['id'],'a.user_del'=>0])
            ->count('a.id');
            return $res;
        }
    }
    
 
    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $hasdata = AActivityList::where('id='.$id)->count();
            if($hasdata){
                $res = AActivityList::destroy($id);
                if($res){
                    return true;
                }else{
                    return false;
                
                }
            }
        }
    }
    
    /**
     * 方法描述  添加一条留言
     * @param  array $d 数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月6日 下午7:14:07
     */
    public function addActivityMsg($d){
        if($d){
           $res = db('a_activity_msg')->insertGetId($d);
        }
        return $res?$res:0;
    }
    
    /**
     * 方法描述  修改一条留言
     * @param  array $d 数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月6日 下午7:14:07
     */
    public function editActivityMsg($d){
        $res = db('a_activity_msg')->update($d);
        return $res!==false?1:0;
    }
    
    /**
     * 方法描述  删除一条留言
     * @param  int $id 信息的id
     * @param  int $userid 用户的id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月6日 下午7:14:07
     */
    public function delActivityMsg($id,$userid){
        $w = ['id'=>$id,'userid'=>$userid];
        $d = ['user_del'=>1];
        $res = db('a_activity_msg')->where($w)->update($d);
        return $res!==false?1:0;
    }
    /**
     * 获取分享二维码数据
     * @param [type] $data [description]
     */
    public function GetShareQrData($data){
        if(!$data){
            return false;
        }
        if($data['userid']){
            $where['userid'] = $data['userid'];
        }
        if($data['activityid']){
            $where['activityid'] = $data['activityid'];
        }
        if($data['staff_name']){
            $where['staff_name'] = $data['staff_name'];
        }
        if($data['id']){
            $where['id'] = $data['id'];
        }
        $data = db('a_activity_share_qr')->where($where)->find();
        if($data){
            return $data;
        }else{
            return false;
        }
    }
    /**
     * 添加 分享二维码数据
     * @param [type] $data [description]
     */
    public function AddShareQrData($data){
        if(!$data){
            return false;
        }
        $res = db('a_activity_share_qr')->insertGetId($data);
        if($res){
            return $res;
        }else{
            return false;
        }
    }
    /**
     * 获取报名数据
     * @param [type] $data [description]
     */
    public function GetActivitySignUp($data){
        if(!$data){
            return false;
        }
        if($data['activityid']){
            $where['activityid'] = $data['activityid'];
        }
        if($data['userid']){
            $where['userid'] = $data['userid'];
        }
        $where['brandid'] = session('brand_id');
        $data = db("a_activity_sign_up")->where($where)->find();
        if($data){
            return $data;
        }else{
            return false;
        }
    }
}