<?php
/**
 * CRM项目默认类，此类在素玄系统内每个模块都有，供全局管理系统间握手使用
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-17 $
 */
namespace app\index\controller;
use think\Controller;
class Index extends Controller
{
    function _initialize() {
        if(!defined('IS_POST')){
            define('IS_POST', \think\Request::instance()->isPost());
        }
    }
    public function index()
    {
        $this->redirect('front/Index/index');
        // return $this->fetch();
    }
    ///判断是PC还是微信登录
    function is_weixin(){
        if ( strpos($_SERVER['HTTP_USER_AGENT'],'MicroMessenger') !== false ) {
            return true;
        }else{
            return false;
        }
    }
    //  记录微信公众号,每日关注或取消关注的记录
    public function wxrequest()
    {
        define("TOKEN", config('WX_MSG_TOKEN'));//定义识别码
        textlog('jinru');
        //获得参数 signature nonce token timestamp echostr
        $nonce     = $_GET['nonce'];
        $token     = config('WX_MSG_TOKEN');
        $timestamp = $_GET['timestamp'];
        $echostr   = $_GET['echostr'];
        $signature = $_GET['signature'];
        textlog(date('Y-m-d H:i:s',time()));
        textlog("nonce--".$nonce);
        textlog("Token--".$token);
        textlog("timestamp--".$timestamp);
        textlog("echostr--".$echostr);
        textlog("signature--".$signature);

        //形成数组，然后按字典序排序
        $array = array($nonce, $timestamp, $token);
        sort($array);

        //拼接成字符串,sha1加密 ，然后与signature进行校验
        $str = sha1( implode( $array ) );
        textlog("加密后".$str);
        if( $str == $signature && $echostr ){
            //第一次接入weixin api接口的时候
            textlog("验证成功");
            echo  $echostr;
            exit;
        }else{
            $postStr = file_get_contents("php://input");//接收用户输入的信息
            //$postStr = $GLOBALS["HTTP_RAW_POST_DATA"];//接收用户输入的信息
            //$brandid = (int)input('brandid');
            if (!empty($postStr)){
                libxml_disable_entity_loader(true);//防止文件泄漏
                $postObj = simplexml_load_string($postStr, 'SimpleXMLElement', LIBXML_NOCDATA);
                $fromUsername = $postObj->FromUserName;//发送方帐号（一个OpenID）
                $toUsername = $postObj->ToUserName;//接收方账号
                $msgType = $postObj->MsgType;//消息类型
                $Event = $postObj->Event;//事件
                $keywords = trim($postObj->Content);//消息内容

                $Latitude = $postObj->Latitude;//地理位置纬度
                $Longitude = $postObj->Longitude;//地理位置经度
                $Precision = $postObj->Precision;//地理位置精度
                $time = time();
            }

            if(!empty($fromUsername)){
                $brandid = db("m_users")->where("openid",$fromUsername)->value('brandid');
            }
            $groupBrandId = db_config('sx_brand');
            //若没有事业部，则取集团事业部设置
            if(!$brandid){
                $brandid = $groupBrandId;
            }

            //若没有设置集团事业部，则取第一个事业部
            if(!$brandid){
                $brandClassList = cache('all_brand_class_list');

                if(!$brandClassList){
                    $brandList = sx_call('5a38840b15ba9',array(),'sx_mc');
                    if($brandList['code'] == 200){
                        cache('all_brand_class_list',$brandList['data'],3600);
                        $brandClassList = $brandList['data'];
                    }
                }

                $brandid = $brandClassList[0]['id'];
            }

            $eventKey = $postObj->EventKey;
            if($eventKey){
                //从mc生成二维码的信息中 获取到事业部id
                $scene = str_replace('qrscene_', '', $eventKey);
                if(strpos($scene,'brandid') !== false){
                    $tmp = substr($scene,0,strpos($scene, '-'));
                    $scene = str_replace($tmp.'-', '', $scene);
                    $tmp = str_replace('brandid','',$tmp);
                    $brandid = intval($tmp)?intval($tmp):$brandid;
                    unset($tmp);
                }
                textlog($scene);//二维码带参
            }
            $defaultinfo = $this->getDefaultInfo($brandid);
            if($keywords){
                $content = $this->getRelayMsg($keywords, $brandid);
                $content = $content?$content:($defaultinfo && $defaultinfo['relay_msg']?$defaultinfo['relay_msg']:'');

                if($content && $msgType == 'text'){
                    $itemTpl = "<xml>
                    <ToUserName><![CDATA[%s]]></ToUserName>
                    <FromUserName><![CDATA[%s]]></FromUserName>
                    <CreateTime>%s</CreateTime>
                    <MsgType><![CDATA[text]]></MsgType>
                    <Content><![CDATA[%s]]></Content>
                    </xml>";
                    $result = sprintf($itemTpl, $fromUsername, $toUsername, $time, $content);
                    echo $result;//返回消息给微信
                }
            }
            if($Event){

                $data = [
                    'from_openid' => $toUsername,
                    'openid'      => $fromUsername,
                    'brandid'     => $brandid,
                    'create_time' => date('Y-m-d H:i:s'),
                    'event_type'  => 0,
                ];
                if($Event=='subscribe'){
                    textlog('关注');
                    //未关注扫码，并关注(去掉参数前缀)
                    $data['event_type'] = 1;
                    if($eventKey == "" || $eventKey == null || $eventKey == 0){
                        $content= $defaultinfo && $defaultinfo['follow_msg']?$defaultinfo['follow_msg']:'';
                        $itemTpl = "<xml>
                        <ToUserName><![CDATA[%s]]></ToUserName>
                        <FromUserName><![CDATA[%s]]></FromUserName>
                        <CreateTime>%s</CreateTime>
                        <MsgType><![CDATA[text]]></MsgType>
                        <Content><![CDATA[%s]]></Content>
                        </xml>";
                        $result = sprintf($itemTpl, $fromUsername, $toUsername, $time, $content);
                        echo $result;//返回消息给微信
                    }
                    $userBrandid = $brandid==$groupBrandId?0:$brandid;
                    self::writeWxlogin($fromUsername,$userBrandid,$brandid);
                    self::writeWxEvent($data);
                }elseif($Event == 'CLICK'){
                    //菜单点击事件,根据关键词key 发送消息
                    $relayMsg = $this->getRelayMsg($scene, $brandid);
                    $sendMsg = $relayMsg?$relayMsg:($defaultinfo && $defaultinfo['relay_msg']?$defaultinfo['relay_msg']:'');

                    if($sendMsg){
                        $itemXml = "<xml>
                        <ToUserName><![CDATA[%s]]></ToUserName>
                        <FromUserName><![CDATA[%s]]></FromUserName>
                        <CreateTime>%s</CreateTime>
                        <MsgType><![CDATA[text]]></MsgType>
                        <Content><![CDATA[%s]]></Content>
                        </xml>";
                        $result = sprintf($itemXml, $fromUsername, $toUsername, $time, $sendMsg);
                        echo $result;//返回消息给微信
                    }

                }else{
                    //已关注扫码
                    textlog('扫码');
                    //$scene = $eventKey;
                }

                if($Event=='unsubscribe'){
                    self::writeWxEvent($data);
                }


                //$filepath = dirname(THINK_PATH) . '/log.txt';
                //file_put_contents(dirname(THINK_PATH).'/log.txt',"写入内容--".$scene,FILE_APPEND);
                // 写入数据库
                $sceneArray=explode('_',$scene);
                //<!--  签名和评价使用
                $accessTokenApi=sx_call('5a60436d631a4',array('brandclass_id'=>$brandid));
                if($accessTokenApi['code']==200){
                    $accessTokenData=$accessTokenApi['data']['access_token'];
                }
                unset($accessTokenApi);
                $appConfig = config('ext.app_config');
                $addr = $appConfig['sx_mc']['addr'];
                //  -->
                
                if($sceneArray[0]=='QD'){
                    $this->eventExtend($fromUsername,$Event,$scene,$brandid);
                }elseif($sceneArray[0]=='ZL'){
                    textlog("进入助力活动");
                    $zhuliNum=$sceneArray[1];
                    if(count($sceneArray)>2 && strtolower($sceneArray[2]) != 'test'){
                        $lastOpenid = str_replace($sceneArray[0].'_'.$sceneArray[1].'_', '', $scene);
                    }
                    if(count($sceneArray)>2&&strtolower($sceneArray[2])=='test'){
                        $zl_type='test';
                    }
                    $this->eventHelp($fromUsername,$zhuliNum,$lastOpenid,$zl_type);
                }elseif($sceneArray[0]=='SIGNORDER'){
                    //订单签名
                    $signKey = str_replace('SIGNORDER_', '', $scene);
                    $addr.= '/index/index/signature?code='.$signKey;
                    $content="<a href='".$addr."'>点击此处 进行订单签名~</a>";
                    $kf='{
                        "touser":"'.$fromUsername.'",
                        "msgtype":"text",
                        "text":
                        {"content":"'.$content.'"}
                    }';
                    $this->sendKfMsg($kf,$accessTokenData);
                }elseif($sceneArray[0] == 'PJ'){
                    textlog("评价");
                    if($sceneArray[1]){
                        $addr.= '/index/index/appraiselogin?orderid='.$sceneArray[1];
                    }else{
                        $addr.= '/index/index/appraiselogin';
                    }
                    
                    $content="<a href='".$addr."'>点击此处 进行订单评价~</a>";
                    $kf='{
                        "touser":"'.$fromUsername.'",
                        "msgtype":"text",
                        "text":
                        {"content":"'.$content.'"}
                    }';
                    $this->sendKfMsg($kf,$accessTokenData);
                }elseif($sceneArray[0] == 'payErpOrder'){
                    $orderId = $sceneArray[1]; //订单编号
                    $code = $sceneArray[2]; //唯一识别码，用于到erp查询收款信息
                    $vip_url = getSiteBrand('',$brandid)['vip_url'];//会员地址

                    $vip_url .= "/front/Payment/paymentErpOrder?order_id=".$orderId."&code=".$code;
                    $content="<a href='".$vip_url."'>点击此处 进行支付~</a>";
                    $kf='{
                        "touser":"'.$fromUsername.'",
                        "msgtype":"text",
                        "text":
                        {"content":"'.$content.'"}
                    }';
                    $this->sendKfMsg($kf,$accessTokenData);
                }
            }
        }
    }
    /*上传多媒体文件到微信服务器
     *
    */
    public function uploadImg($filepath,$access_token){
        //$filepath = 'D:/photo/n.jpg';
        if (class_exists ( '\CURLFile' )) {//关键是判断curlfile,官网推荐php5.5或更高的版本使用curlfile来实例文件
            $filedata['media'] = new \CURLFile ( realpath ( $filepath ));
        } else {
            $filedata['media'] = '@'.realpath ( $filepath );
        }

        $url="https://api.weixin.qq.com/cgi-bin/media/upload?access_token=".$access_token."&type=image";
        $result = upload_http($url,$filedata);
        $res = json_decode($result,true);
        if($res['errcode']==0){
            return $res['media_id'];
        }

    }


    /*发送客服消息
    *@param String  $content   内容
    *@param String  $access_token
    * $content='{
            "touser":"'.$openid.'",
            "msgtype":"text",
            "text":
            {
                 "content":"Hello World"
            }
        }';
    */
    public function sendKfMsg($content,$access_token){

        $kfurl='https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token='.$access_token;
        $kfresult=http_request($kfurl,'POST',$content,array('Content-Type: application/json', 'Content-Length: ' . strlen($content)));
        $res=json_decode($kfresult['response'],true);
        textlog('---发送客服消息结果---'.$kfresult['response']);
        return $res;
    }


    /*获取微信二维码ticket
    *@param String  shop_code  店面识别码 (任一)
    *@param String  brandclass_id  品牌id  (任一)
    *@param String  scene   场景编号，即参数，不可重复
    */
    public function getTicket($param){
        $url="5a73d4f13a9eb";
        $res=sx_call($url,$param);
        if($res['code']==200){
            $ticket=$res['data'];
        }
        return $ticket;
    }

    public function sendZLrequest(){
        textlog('进入发送消息环节');
        $code = json_decode(think_decrypt(input('code')),true);
        if(!$code['test'] &&  $code['id']){
            //非测试
            $info = db('wx_help_user')->find($code['id']);
            if(!$info){
                exit();
            }
            $openid = $info['openid'];
            $zhuliData=db('wx_help')->where('id',$info['help_id'])->where('delete_time','null')->where('status',1)->find();
            //zhenshi发父消息
            if($info['parent_id'] > 0) {
                //给$lastOpenid发送模板消息，xxx给您助力 现助力人数为 $lastData['help_num']+1
                $parentInfo = db('wx_help_user')->find($info['parent_id']);
                $content = [
                    'touser' => $parentInfo['openid'],
                    'template_id' => HELP_TEMPLATE,
                    'data' => [
                        'first' => [
                            'value' => '您好，您有新的助力信息啦！',
                            'color' => '#173177'
                        ],
                        'keyword1' => [
                            'value' => $info['nick_name'],
                            'color' => '#173177'
                        ],
                        'keyword2' => [
                            'value' => $parentInfo['help_num'],
                            'color' => '#173177'
                        ],
                        'keyword3' => [
                            'value' => $info['add_time'],
                            'color' => '#173177'
                        ],
                        'remark' => [
                            'value' => '还要继续加油哦！',
                            'color' => '#173177'
                        ],
                    ]
                ];
                $send_data['content'] = json_encode($content);
                $send_data['brandclass_id'] = $zhuliData['brand_id'];
                sendMemberWxMsg($send_data);
            }
        }
        if(!$code['test'] && !$code['id']){
            exit();
        }
        //客服消息
        if($code['test']){
            $info['help_id'] = $code['help_id'];
            $zhuliData=db('wx_help')->where('id',$info['help_id'])->where('delete_time','null')->where('status',1)->find();
            $scene='ZL_'.$info['help_id'].'_test';
            $openid = is_array($code['openid'])?$code['openid'][0]:$code['openid'];
        }else{
            $scene='ZL_'.$info['help_id'].'_'.$info['openid'];
        }
        $qrExpire =  strtotime($zhuliData['end_time']) - time();
        $qrdata = [
            'brandclass_id'=>$zhuliData['brand_id'],
            'type'=>2,//1临时二维码
            'scene'=>$scene,
            'expire'=>$qrExpire,
        ];
        $getTicket=$this->getTicket($qrdata);
        $ticket=$getTicket['ticket'];
        $bg_img=ROOT_PATH.$zhuliData['help_img'];
        $qrcode='https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket='.$ticket;

        $params=json_decode($zhuliData['params'],true);
        $site['photo_scale']=$params['avatar']['scale'];
        $site['photo_x']= $params['avatar']['x'];
        $site['photo_y']= $params['avatar']['y'];
        $site['name_x'] = $params['avatar']['x']+110;
        $site['name_y'] = $params['avatar']['y']+30;
        $site['name_color']=$params['avatar']['color'];
        $site['ewm_scale']=$params['qrcode']['scale'];
        $site['ewm_x']  = $params['qrcode']['x'];
        $site['ewm_y']  = $params['qrcode']['y'];
        if($params['is_show_avatar']==1){
            $head_img=$code['head_img'];
            $nickname=$code['nick_name'];
        }
        /*$brandData = sx_call('5a38840b15ba9',array('id'=>$zhuliData['brand_id']),'sx_mc');
        if($brandData['code'] == 200){
            $vip_url=$brandData['data'][0]['vip_url'];
        }*/
        $vip_url = getSiteBrand('',$zhuliData['brand_id'])['vip_url'];
        $href=$vip_url.'/front/wxhelp/index?help_id='.$zhuliData['id'];
        $content="<a href='".$href."'>点击此处 查看活动~</a>";
        $accessTokenData = $code['access_token'];
        $kf='{
                "touser":"'.$openid.'",
                "msgtype":"text",
                "text":
                {"content":"'.$content.'"}
            }';
        $this->sendKfMsg($kf,$accessTokenData);

        $img=watermark($bg_img,$head_img,$nickname,$qrcode,$site,$openid,$zhuliData['brand_id']);
        //将带二维码图片上传至微信服务器
        $media_id=$this->uploadImg($img,$accessTokenData);
        $kfImg='{
                    "touser":"'.$openid.'",
                    "msgtype":"image",
                    "image":
                        {
                          "media_id":"'.$media_id.'"
                        }
                }';

        $this->sendKfMsg($kfImg,$accessTokenData);
        if(!$code['test'] &&  $code['id']){
            $userData = [
                'id'=>$code['id'],
                'ticket'=>$ticket,
                'img'=>$img,
            ];
            db('wx_help_user')->update($userData);

        }
    }

    /* 助力
    * 记录微信扫码/关注事件，针对于带参数二维码
    * openid  用户对于微信公众号的openid
    * event   事件类型
    * scene   二维码参数
    */
    public function eventHelp($openid,$helpId,$lastOpenid,$zl_type){
        $time=date('Y-m-d H:i:s',time());
        $zhuliData=db('wx_help')->where('id',$helpId)->where('delete_time','null')->where('status',1)->where('end_time',['>',$time])->find();
        if($zhuliData){
            $nowData=db('wx_help_user')->where(array('help_id'=>$helpId,'openid'=>$openid))->find();
            if(!$nowData||$zl_type=='test'){//此助力活动存在，并且未参加过
                //$accessTokenData=controller('vip/WechatSetting','lib')->getAccessToken(array('brandclass_id'=>$zhuliData['brand_id']));
                $accessTokenApi=sx_call('5a60436d631a4',array('brandclass_id'=>$zhuliData['brand_id']));
                if($accessTokenApi['code']==200){
                    $accessTokenData=$accessTokenApi['data'];
                }
                //获取用户信息
                $urlInfo = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=".$accessTokenData['access_token']."&openid=".$openid."&lang=zh_CN";
                $res = http_request($urlInfo,'GET');
                $userInfo = json_decode($res['response'],true);

                preg_match_all('/[\w\x{4e00}-\x{9fa5}]+/u',$userInfo['nickname'],$newName);
                $nickName = $newName && $newName[0]?implode('', $newName[0]):'';
                //正式助力活动才记录用户关系和裂变数助力数
                if($zl_type!='test'){
                    //给所有父级裂变数+1，直系父级助力数+1
                    if(!empty($lastOpenid)){
                        $lastData=db('wx_help_user')->where(array('help_id'=>$helpId,'openid'=>$lastOpenid))->find();
                        $parent_ids=trim($lastData['parent_ids'].','.$lastData['id'],',');
                        if($lastData['parent_id']==0){
                            $dataWX['help_num'] = ['exp',"help_num + 1"];
                            $dataWX['fission_num'] = ['exp',"fission_num + 1"];
                            db('wx_help_user')->where('openid',$lastOpenid)->update($dataWX);
                        }else{
                            db('wx_help_user')->where('openid',$lastOpenid)->update(['help_num'=>['exp','help_num + 1']]);
                            db('wx_help_user')->where('id','in',$parent_ids)->update(['fission_num'=>['exp',"fission_num + 1"]]);
                        }
                    }
                    //插入用户与助理活动关系详情表(用户信息，昵称，头像)
                    $helpUser=array(
                        // 'user_id'=>$user_id,
                        'parent_id'=>$lastData['id']?$lastData['id']:0,
                        'help_id'=>$helpId,
                        'openid'=>$openid,
                        'nick_name'=>$nickName,
                        'head_img'=>$userInfo['headimgurl'],
                        'parent_nick_name'=>$lastData['nick_name'],
                        'parent_head_img'=>$lastData['head_img'],
                        'parent_ids'=>$parent_ids,
                       // 'ticket'=>$ticket,
                       // 'img'=>$img,
                        'add_time'=>$time,
                    );

                    $res = db('wx_help_user')->insert($helpUser);
                    if( $res !==  false){
                        $params['id'] = db()->getLastInsID();
                        $params['test'] = 0;
                        $params['head_img'] = $userInfo['headimgurl'];
                        $params['nick_name'] = $nickName;
                        $params['access_token'] = $accessTokenData['access_token'];
                        $params['help_id'] = $zhuliData['id'];
                    }

                }else{
                    $params['access_token'] = $accessTokenData['access_token'];
                    $params['help_id'] = $zhuliData['id'];
                    $params['head_img'] = $userInfo['headimgurl'];
                    $params['nick_name'] = $nickName;
                    $params['test'] = 1;
                    $params['openid'] = $openid;
                }
                if($params){
                    $accessTokenData = $accessTokenData['access_token'];
                    //给$openid 发送客服消息
                    //o3mGr0paq4VWktKzPiBn-082a4Go
                    $kf='{
                            "touser":"'.$openid.'",
                            "msgtype":"text",
                            "text":
                            {"content":"'.$zhuliData['subscribe_rule'].'"}
                        }';
                    $this->sendKfMsg($kf,$accessTokenData);

                    $paramCode = think_encrypt(json_encode($params));
                    //($url, $method="GET", $postfields = null, $headers = array(), $debug = false,$timeOut = 60
                    textlog('-------'.url('index/index/sendZLrequest',['code'=>$paramCode],'',true));
                    http_request(url('index/index/sendZLrequest',['code'=>$paramCode],'',true),'POST',null,array(),false,1);
                }
                exit();

            }
        }

    }


    /*
     * 记录微信扫码/关注事件，针对于带参数二维码
     * 
     * @return [type] [description]
     */
    public function eventExtend($openId,$event,$scene,$brandid){

        //$data = ['open'];
        $extendInfo = db('wx_extend')->where('scene',$scene)->where('brandid',$brandid)->where('delete_time','null')->find();
        if($extendInfo){
            if(strtoupper($event) == 'SCAN'){
                $data['scan_time'] = date('Y-m-d H:i:s');
                $dataWX['scaned_num'] = ['exp',"scaned_num + 1"];
            }
            if(strtoupper($event) == 'SUBSCRIBE'){
                $data['follow_time'] = date('Y-m-d H:i:s');
                $dataWX['follow_num'] = ['exp',"follow_num + 1"];
            }
            $extenDetailInfo = db('wx_extend_detail')
                    ->where(['openid'=>$openId,'event'=>$event])->find();
            if(!$extenDetailInfo){
                $data['extend_id'] = $extendInfo['id'];
                $data['openid'] = $openId;
                $data['event'] = $event;
                $data['event_key'] = $scene;
                db()->startTrans();
                try{
                    db('wx_extend_detail')->insert($data);
                    db('wx_extend')->where(['id'=>$extendInfo['id']])->update($dataWX);
                    db()->commit();
                }catch(\Exception $e){
                    db()->rollback();
                }
            }
            
        }

    }


    /**
     * 方法描述  记录用户取消关注和关注操作
     * @param  array $data 保存的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月19日 下午7:13:21
     */
    public function writeWxEvent($data){
       if($data){
           
           $query = db('wx_event_log')
                    ->where('openid',$data['openid'])
                    ->where('event_type',$data['event_type'])
                    ->where('brandid',$data['brandid'])
                    ->select();
           if(empty($query)){           
               $res = db('wx_event_log')->insert($data);
               if(!$res){
                   $this->logger('取关事件时写入数据库时出错：执行的语句是：'.db()->getLastSql().'\r\n'.'要插入的数据是：'.print_r($data).';时间：'.date('Y-m-d H:i:s',time()));
               }
           }
       }
    }
    /**
     * 方法描述  根据用户openid获取用户信息并存入用户表中
     * @param  array $data 保存的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月19日 下午7:13:21
     */
    public function writeWxlogin($openid="",$userBrandid,$brandid){
        if($openid && $brandid){

        //获取access_token
        //$accessTokenData=controller('WechatSetting','lib')->getAccessToken(array('brandclass_id'=>$brandid));
        $res=sx_call('5a60436d631a4',array('brandclass_id'=>$brandid));
        if($res['code']==200){
            $accessData=$res['data'];
        }
        if($accessData['access_token']){
            $url="https://api.weixin.qq.com/cgi-bin/user/info?access_token=".$accessData['access_token']."&openid=".$openid."&lang=zh_CN";
            $result = http_request($url,'GET');
            $result = json_decode($result['response'],true);
            $userData = array(
                'openid' => $result['openid'],
                'username' => $result['nickname'],
                'sex' => $result['sex'],
                'simg' => $result['headimgurl'],
                'brandid'=> $userBrandid,
                'create_time' => date('Y-m-d H:i:s',time()),
            );
            $res = db('m_users')->where("openid",$openid)->find();
            if(empty($res)){
                db()->startTrans();
                try{
                    $userid = db("m_users")->insertGetId($userData);
                    if(!$userid){
                        db()->rollback();
                    }
                    $scoreRule = getScoreRule(['userid'=>$userid]);
                    $regScore  = $scoreRule && $scoreRule['account']?$scoreRule['account']:0;
                    $score = AddScore($userid,'',$regScore,'17','关注公众号');
                    if($score === false){
                        db()->rollback();
                    }
                    db()->commit();
                }
                catch(\Exception $e){
                    db()->rollback();
                }
            }
        }
    }
    }
    /**
     * 方法描述  获取自动回复的内容
     * @param  string $key 
     * @param  int $brandid
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月19日 下午7:13:21
     */
    public function getRelayMsg($key,$brandid){
        if($key){
            $w   = ['brandid'=>(int)$brandid];
            $res = db('wx_auto_relay')->field('name,content')->where($w)->select();
            $maxlength = 0;     
            $content   = '';
            foreach ($res as $v){
                if($v['name'] == $key){
                    return $v['content'];
                }
                if(false !== strpos($key,$v['name'])){
                    if(strlen($key)>$maxlength){
                        $content = $v['content'];
                        $maxlength = strlen($key);
                    }
                }
                if(false !== strpos($v['name'],$key)){
                    if(strlen($v['name'])>$maxlength){
                        $content = $v['content'];
                        $maxlength = strlen($v['name']);
                    }
                }
 
            }
            return $content;
        }
        return;
        
    }

   /**
    * 方法描述  获取默认公众号的设置
    * @return mixed
    * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月20日 下午4:17:08
    */ 
    public function getDefaultInfo($brandid){
        $w = ['brandid'=>$brandid];
        $res = db('wx_default_info')->field('follow_msg,relay_msg')->where($w)->find();
        return $res?$res:'';
    }
    
 
    /**
     * 方法描述  记录用户取消关注和关注操作出错时写入文本
     * @param  array $data 保存的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月19日 下午7:13:21
     */
    public function logger($str){
		if(file_exists('./write_event.log') && filesize('./write_event.log') > 1024*1024*1024*2){
			@rename("./write_event.log",'./write_ervet.log.'.date('Y-m-d H:i:s'));
		}
		file_put_contents("./write_event.log",$str,FILE_APPEND);
    }
        	
    /**
     * 方法描述  记录用户取消关注和关注操作出错时写入文本
     * @param  array $data 保存的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月19日 下午7:13:21
     */
//     public function mdebug($str){
//         db('minute_log')->insert(['m_title'=>$str]);
        
//     }
// 
 
    /**
     * 生成二维码
     * @return [type] [description]
     */
    public function qr_code(){
        $content = input('content');
        $qrcode  = qrcode($content);
        header("Content-type: image/jpeg");
        echo $qrcode;
        die;
    }
    /**
     * 活动分享码   图片合成
     * @return [type] [description]
     */
    public function showSharePageImg(){
        $content = urlencode(input("content"));
        $id = input("id");
        $activityData = db("a_activity_list")->where("id",$id)->find();
        $qrcode = request()->domain().'/index/index/qr_code?content='.$content;

        $ewm_x   = 190;
        $ewm_y   = 730;
        if($activityData['shareqr_img']){
            $w = "public/uploads/".$activityData['shareqr_img'];    
        }else{
            $w = "public/front/imgnew/evm-2.jpg";    
        }
        $image = \think\Image::open($w);
        file_put_contents('qrcode.txt',$qrcode);
        $image->water($qrcode,[$ewm_x,$ewm_y]);
        unlink($qrPath);
        header("Content-type: image/jpeg");
        $image->save("php://output");
        die;
    }


    /*
    * 儿童套系，修改vip订单状态，erp下单
    */
    public function setChildPackageOrder(){

        $params["order_no"] = '15583478289996328';
        $params["pay_fee"] = 100;
        $params["pay_status"] = 'PAYED';
        if(!$params["order_no"]){
            payment_log("mc回调支付未接收到单号",'','');
            return array('error'=>1,'code'=>204,'msg'=>'mc回调支付未接收到单号');
        }

        $res = controller('Index/Order','lib')->setChildPackageOrder($params);
        return $res;

    }


}
