<?php
/**
 * 活动控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月22日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
class Activity extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'activity';
    protected $imgWH   = [
                            'share'   => [300,300],
                            'shareqr' => [750,1264],
                            'index'   => [555,300],
                            'hot'     => [400,600],
                           ]; 
    /**
     * 方法描述: 获取列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
        }
        
        $this->assign([
            'headinfo'=>[
                'title'=>'活动管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
   
    /**
     * 方法描述     添加
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function add(){
        if(IS_POST && request()->isAjax()){
            // 数据信息
            $acdata = request()->post();

            $fileimg  = request()->file("indeximg");
            $shareimg = request()->file("shareimg");
            $hotimg   = request()->file("hotimg");
            $shareqrimg   = request()->file("shareqrimg");

            $hot_img = $shareqr_img = $upimg = $share_img = false;
            if($fileimg){
                $upimg = saveImg($fileimg,$this->imgWH['index'][0],$this->imgWH['index'][1]);
            }else{
                return json(['status'=>0,'msg'=>'请上传列表图片']);
            }
            if($hotimg){
                $hot_img = saveImg($hotimg,$this->imgWH['hot'][0],$this->imgWH['hot'][1]);
            }elseif($acdata['ishot'] == 1){
                return json(['status'=>0,'msg'=>'请上传热门图片']);
            }
            if($shareimg){
                $share_img = saveImg($shareimg,$this->imgWH['share'][0],$this->imgWH['share'][1]);
            }
            if($shareqrimg){
                $shareqr_img = saveImg($shareqrimg,$this->imgWH['shareqr'][0],$this->imgWH['shareqr'][1]);
            }
            //意向店面
            if($acdata['cource']){
                $courcearr = explode(',',$acdata['cource']);
                $cource_id = $courcearr[0];
                $cource_name = $courcearr[1];
            }
            //默认归属员工
            if($acdata['staff']){
                $staffarr = explode(',',$acdata['staff']);
                $staff_id   = $staffarr[0];
                $staff_name = $staffarr[1];
            }
            //归属店面
            if($acdata['affiliation']){
                $affiliation = explode(',',$acdata['affiliation']);
                $affiliation_shop_code = $affiliation[0];
                $affiliation_shop_name = $affiliation[1];
            }
            if($upimg){
                $data = [
                    'title'     => $acdata['title'],
                    'couponid'  => $acdata['couponid'],
                    'content'   => $acdata['content'],
                    'share_score'  => $acdata['sharescore'],
                    'share_title'  => $acdata['sharetitle'],
                    'share_img'    => $share_img,
                    'shareqr_img'  => $shareqr_img,
                    'share_content'=> $acdata['sharecontent'],
                    'start_time'=> $acdata['starttime'],
                    'end_time'  => $acdata['endtime'],
                    'view_total'=> $acdata['viewtotal'],
                    'status'    => $acdata['status'],
                    'index_img' => $upimg,
                    'hot_img'   => $hot_img,
                    'ishot'     => (int)$acdata['ishot'],
//                    'order_num' => $acdata['ordernum'],
                    'style_detail' => $acdata['styledetail'],
                    'permit_level' => $acdata['levelids']?implode(',',$acdata['levelids']):'',
                    'cource_name'  => $cource_name,
                    'cource_id'    => $cource_id,
                    'affiliation_shop_name' => $affiliation_shop_name,
                    'affiliation_shop_code'   => $affiliation_shop_code,
                    'default_staff_name'=>$staff_name,
                    'default_staff_id'=>$staff_id,
                ];
                preg_match('/class="coupon [\w\d]+"/',$acdata['content'],$coupon);
                $strSeat = strripos($coupon[0],'n');
                $strSub = substr($coupon[0],$strSeat+1,-1);
                $data['couponid'] = $strSub;
                if(!$acdata['starttime']){
                    unset($data['start_time']);
                }
                if(!$acdata['endtime']){
                    unset($data['end_time']);
                }
                $res = controller($this->libname,'lib')->add($data);
                if($res){
                    action_log($data);      //写日志
                    $this->msg = ['status'=>1,'msg'=>'添加成功'];
                }else{
                    // 上传失败获取错误信息
                    $this->msg = ['status'=>0,'msg'=>'添加失败'];
                }
            }else{
                 $this->msg = ['status'=>0,'msg'=>'图片上传失败,请确认是图片类型'];
            }
            $this->assign([
                'headinfo'=>[
                    'title'=>'添加新活动'
                ]
            ]);
            return json($this->msg);
            
        }else{
            //客户来源
            $cource = sx_call('59fd5ec462c88', array(''), 'sx_mc');
            if($cource['code'] == 200){
                $courceArr = $cource['data'];
            }
            //默认员工
            $data['brandclass_id'] = 1;
            $staff = sx_call('5a01766b4a3dd',$data,'sx_mc');
            if($staff['code'] == 200){
                $staffArr = $staff['data'];
            }
            //店面选择
            $shop = sx_call('5a005e0038270', array(''), 'sx_mc');
            if($shop['code'] == 200){
                $shopArr = $shop['data'];
            }
            $this->assign('staffarr',$staffArr);
            $this->assign('courcearr',$courceArr);
            $this->assign('shoparr',$shopArr);
            $this->assign('videos',controller($this->libname,'lib')->getVideolist());
            $this->assign('bgimgs',controller($this->libname,'lib')->getImgList());
            $this->assign('levels',controller('level','lib')->getList());
            $this->assign('coupons',controller('coupon','lib')->getSmallList());
            $this->getTopMenu();
            $this->assign('imgsize',$this->imgWH);
            return $this->fetch();
        }
    }
    /** 
     * 生成二维码
     * @return [type] [description]
     */
    public function qr_code(){
        $content = input('content');
        $qrcode  = qrcode($content);
        echo $qrcode;
    }
    /**
     * 修改优惠券信息
     * @param string
     * @param string
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function edit(){
        
        if(IS_POST && request()->isAjax()){
            
            // 数据信息
            $acdata = request()->post();
            //意向店面
            if($acdata['cource']){
                $courcearr = explode(',',$acdata['cource']);
                $cource_id = $courcearr[0];
                $cource_name = $courcearr[1];
            }
            //默认归属员工
            if($acdata['staff']){
                $staffarr = explode(',',$acdata['staff']);
                $staff_id   = $staffarr[0];
                $staff_name = $staffarr[1];
            }
            //归属店面
            if($acdata['affiliation']){
                $affiliation = explode(',',$acdata['affiliation']);
                $affiliation_shop_code   = $affiliation[0];
                $affiliation_shop_name = $affiliation[1];
            }
            $data = [
                'id'        => $acdata['id'],
                'title'     => $acdata['title'],
                'couponid'  => $acdata['couponid'],
                'scontent'  => $acdata['scontent'],
                'content'   => $acdata['content'],
                'share_score'  => $acdata['sharescore'],
                'share_title'  => $acdata['sharetitle'],
                'share_content'=> $acdata['sharecontent'],
                'view_total'   => $acdata['viewtotal'],
                'start_time'   => $acdata['starttime'],
                'end_time'     => $acdata['endtime'],
                'status'       => $acdata['status'],
                'order_num'    => $acdata['ordernum'],
                'style_detail' => $acdata['styledetail'],
                'permit_level' => $acdata['levelids']?implode(',',$acdata['levelids']):'',
                'ishot'        => (int)$acdata['ishot'],
                'cource_name'  => $cource_name,
                'cource_id'    => $cource_id,
                'affiliation_shop_name' => $affiliation_shop_name,
                'affiliation_shop_code'   => $affiliation_shop_code,
                'default_staff_name'=>$staff_name,
                'default_staff_id'=>$staff_id,
            ];
            
            // 获取上传的图片信息
            $fileimg = request()->file("indeximg");
            if($fileimg){
                $data['index_img'] = saveImg($fileimg,$this->imgWH['index'][0],$this->imgWH['index'][1]);
            }
            // 获取是否上传分享的图片
            $shareimg = request()->file("shareimg");
            if($shareimg){
                $data['share_img'] = saveImg($shareimg,$this->imgWH['share'][0],$this->imgWH['share'][1]);
            }

            $shareqrimg = request()->file("shareqrimg");
            if($shareqrimg){
                $data['shareqr_img'] = saveImg($shareqrimg,$this->imgWH['share'][0],$this->imgWH['share'][1]);
            }
            $hotimg   = request()->file("hotimg");
            if($hotimg){
                $data['hot_img'] = saveImg($hotimg,$this->imgWH['hot'][0],$this->imgWH['hot'][1]);
            }
            if(!$acdata['starttime']){
                unset($data['start_time']);
            }
            if(!$acdata['endtime']){
                unset($data['end_time']);
            }
            // 处理数据
            $res = controller($this->libname,'lib')->edit($data);
            if($res===false){
                $this->msg = ['status'=>0,'msg'=>'修改失败'];
            }else{
                action_log($data);          //写日志
                $this->msg = ['status'=>1,'msg'=>'修改成功'];
            }
            return json($this->msg);
            
        }else{
            $id = request()->get('id');
            //客户来源
            $cource = sx_call('59fd5ec462c88', array(''), 'sx_mc');
            if($cource['code'] == 200){
                $courceArr = $cource['data'];
            }
            //默认员工
            $data['brandclass_id'] = 1;
            $staff = sx_call('5a01766b4a3dd',$data,'sx_mc');
            if($staff['code'] == 200){
                $staffArr = $staff['data'];
            }
            //店面选择
            $shop = sx_call('5a005e0038270', array(''), 'sx_mc');
            if($shop['code'] == 200){
                $shopArr = $shop['data'];
            }
            $this->assign('staffarr',$staffArr);
            $this->assign('courcearr',$courceArr);
            $this->assign('shoparr',$shopArr);

            if($id){
                $this->assign([
                    'videos' => controller($this->libname,'lib')->getVideolist(),
                    'bgimgs' => controller($this->libname,'lib')->getImgList(),
                    'levels' => controller('level','lib')->getList(),
                    'coupons'=> controller('coupon','lib')->getSmallList(),
                    'data'   => controller($this->libname,'lib')->getOne($id)
                ]);
                $this->assign([
                    'headinfo'=>[
                        'title'=>'修改活动'
                    ],
                    'imgsize' => $this->imgWH,
                ]);
                $this->getTopMenu();
                return $this->fetch();
            }else{
                return $this->error('无法获取您要修改的数据！');
            }
            
        }
    }
    
    /**
     * 方法描述     设置活动发布状态，是否启用
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id     = request()->post('id');
        $status = request()->post('status');
        $res = controller($this->libname,'lib')->setStatus($id,$status);
        return json(['status'=>$res?1:0,'msg'=>'']);
    }
    
    
    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $arr = db('a_activity_list')->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id);
        if($res){
        	action_log($arr);
        }
        return json(['status'=>$res?1:0,'msg'=>'']);
    }

    /**
     * 方法描述     连接管理中心
     * @param  string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 上午9:22:57
     */
    public function linkCenter(){
        if(request()->isAjax()){
            $id = (int)input('request.id');
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
                'id'    => $id,
            ];
            //$this->makeCode();
            $data['data']  = controller($this->libname,'lib')->getLinkList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getLinkCount($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'活动推广链接管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    
    
    
    
    /**
     * 方法描述
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 上午9:22:57
     */
    public function makeCode(){
        if(request()->isAjax()){
            $id      = (int)input('post.id');
            $makeNum = (int)input('post.makenum')?:1;
            $makeName = input('post.makename')?:'';
            //$id = 4;
            //$makeNum = 1;
            if(!$id){
                return json(['status'=>0,'msg'=>'生成失败，无法获取活动的id']);
            }
            if(strlen($makeName) > 40){
                return json(['status'=>0,'msg'=>'名称超长（13个汉字或40个字母以内），请重新输入']);
            }
            $d = []; // 要存储的数据
            for($i=0;$i<$makeNum;$i++){
                // 生成连接的码
                $linkCode = '';
                while (!$linkCode) {
                    # code...
                    $linkCode  = $id.'-'.$this->makeStr();
                    $res = db('AActivityLink')->where('link',$linkCode)->find();
                    if($res){
                        $linkCode = '';
                    }
                }
                
                $qrcode    = new \Endroid\QrCode\QrCode();
                //$qrcode->setText('http://vip.t.suxuantech.cn/front/index/activitydetail?id='.$id.'&codeid='.$linkCode);
                $url = url('front/index/activitydetail','','',true).'?brandid='.$this->brandId.'&id='.$id.'&codeid='.$linkCode;

                $qrcode->setText($url);
                $imgname   =  $linkCode.''.time().'.png';
                $completename   = 'public/uploads/QRimgs/'.$linkCode.''.time().'.png';
                $qrcode->writeFile($completename);
                $d[] = [
                            'activityid'  => $id,
                            'link'        => $linkCode,
                            'name'        => $makeName,
                            'qrcode'      => $imgname,
                            'brandid'     => $this->brandId,
                            'create_user' => $this->staffName,
                            'create_time' => date('Y-m-d H:i:s',time())
                        ];
                if(!is_file($completename)){
                    return json(['status'=>0,'msg'=>'public/uploads/QRimgs目录不可写']);
                }
            }
            //print_r($d);die;
            if($d){
                $res = controller($this->libname,'lib')->addLink($d);
                return json(['status'=>$res?1:0]);
            }
            return json(['status'=>0]);
           
        }else{
           $this->index();
        }
    }
    
    
    /**
     * 方法描述   制作是随机串
     * @param  int $length 长度
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 上午9:44:21
     */
    public function makeStr($length = false){
       $str = '1234567890abcdefghigklmnopqrstuvwsyzABCDEFGHIJKLMNOPQRSTUVWSYZ';
       $time = time();
       $length = $length?$length-4:8;
       return substr(str_shuffle($str),0,$length).''.substr($time,0,4);
    }
    
    
    /**
     * 方法描述     查看浏览详情
     * @param  string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 上午9:22:57
     */
    public function visitDetail(){
        if(request()->isAjax()){
            $id = (int)input('request.id');
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
                'id'    => $id,
            ];
            $data['data']  = controller($this->libname,'lib')->getLinkVisitList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getLinkVisitCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'活动浏览详情'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    
    
    /**
     * 方法描述     删除一条一个活动的生成的连接
     * @param  string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 上午9:22:57
     */
    public function delLink(){
        if(request()->isAjax()){
            $id   = (int)input('request.id');
            $arr = db('a_activity_link')->where('id',$id)->find();
            $res  = controller($this->libname,'lib')->delLink($id);
            if($arr){
            	action_log($arr);  //写日志
            }
            return json(['status'=>$res?1:0]);
        }else{
            return $this->linkCenter();
        }
    }
    
    /**
     * 方法描述
     * @param string
     * @param string
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月18日 上午10:35:22
     */
    public function upload(){
  
        if(request()->file()){
            $file = request()->file();
            $name = array_keys($file);
            $type = (int)request()->get('type');
            if($type==1){
                    $info = $file[$name[0]]->validate(['size'=>1024*1024*50,'ext'=>'mp4,wmv'])->move(ROOT_PATH . 'public' . DS . 'uploads'. DS .'video'. DS);
                    $savename = $info->getSavename();
                    if($savename){
                       $ext = end(explode('.',$savename));
                       $d = [
                                'brandid'  => $this->brandId,
                                'name'     => $savename,
                                'type'     => $ext
                            ];
                       $lastid =  db("video")->insertGetId($d);
                       if(!$lastid){
                           return json_encode(['errno'=>1,'msg'=>'上传失败,请重试！']);
                       }
                       return json_encode(['errno'=>0,'data'=>[['/public/uploads/video/'.$savename]],'id'=>$lastid,'type'=>$ext]);
                    }
                    return json_encode(['errno'=>1,'msg'=>'上传失败,请重试！']);
            }else{
                $savename = saveImg($file[$name[0]],600,'','editor');
                $d = [
                    'brandid' => $this->brandId,
                    'add_time' => date('Y-m-d H:i:s',time()),
                    'img'     => $savename
                ];
                $lastid =  db("bg_imgs")->insertGetId($d);
                if(!$lastid){
                    return json_encode(['errno'=>1,'msg'=>'上传失败,请重试！']);
                }            
                return json_encode(['errno'=>0,'data'=>[['/public/uploads/editor/'.$savename]],'id'=>$lastid]);
            }

        }
    }
    
    /**
     * 方法描述   删除背景图片
     * @param string
     * @param string
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月18日 上午10:35:22
     */
    public function delBgImg(){

        if(request()->isAjax()){
            $id = (int)input('post.id');
            $imgname = input('post.imgname');
            if($id){
                $saveimg =  db("bg_imgs")->delete($id);
                $newimg  = controller($this->libname,'lib')->getImgList();
                //echo db()->getLastSql();
                
            }else{
                return json(['status'=>0,'msg'=>'删除失败，无法获取您要删除的图片信息']);
            }
            if($imgname){
                @unlink(substr($imgname,1));
            }
            echo  json_encode(['status'=>1,'msg'=>'删除成功','newimg'=>$newimg[8]]);
            
        }
    }
    

    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/activity/';
        $activity      = $currentUrlStart.'index';
        $activityEdit  = $currentUrlStart.'edit';
        $activityAdd   = $currentUrlStart.'add';
        $activityDel   = $currentUrlStart.'del';
        $activitySetstatus   = $currentUrlStart.'setstatus';
        $activityLinkCenter  = $currentUrlStart.'linkcenter';
        $visitdetail         = $currentUrlStart.'visitdetail';
        $activityLinkDel     = $currentUrlStart.'linkdel';
        $activityMakeCode    = $currentUrlStart.'makecode';
        
        $msglist     = $currentUrlStart.'activitymsg';
        $delmsg      = $currentUrlStart.'delactivitymsg';
        $editmsg     = $currentUrlStart.'editactivitymsg';
        $checkmsg    = $currentUrlStart.'setmsgstatus';
        
        $activityShare   = '/vip/share/index';
        $signup          = '/vip/signup/index';
        $signupnew          = '/vip/signup/newindex';
        $signupSetstatus = '/vip/signup/setstatus';
        $signupDel       = '/vip/signup/del';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            //echo $menuUrl.'==||||=topend';
            if($menuUrl == $activity){
                $class = '';
                if($activity == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$activity.'">活动管理</a></div>';
            }else if($menuUrl == $activityAdd){
                $topmenuend1 = '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$activityAdd.'">添加活动</a></div>';
            }else if($menuUrl == $activityLinkCenter){
                $class = '';
                if($activityLinkCenter == $currentUrl){
                    $class = 'mactive';
                }
                $this->assign('activitylinkcenter',1);
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$activityLinkCenter.'">活动推广链接列表</a></div>';
            }else if($menuUrl == $activityDel){
                $this->assign('activitydel',1);
            }else if($menuUrl == $activityEdit){
                if($activityEdit == $currentUrl){
                    $topmenuend = '<div class="layui-btn"><a href="'.$activity.'">返回活动列表</a></div>';
                }
                $this->assign('activityedit',1);
            }else if($menuUrl == $activityShare){
                $topmenu .= '<div class="layui-btn"><a href="'.$activityShare.'">活动分享列表</a></div>';
            }else if($menuUrl == $signup){
                $class = '';
                if($signup == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"><a href="'.$signup.'">活动报名列表</a></div>';
                $this->assign('signup',1);
            }else if($menuUrl == $signupnew){
                $class = '';
                if($signupnew == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$signupnew.'">报名新统计</a></div>';
            }else if($menuUrl == $activitySetstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $visitdetail){
                $this->assign('visitdetail',1);
            }else if($menuUrl == $activityLinkDel){
                $this->assign('linkdel',1);
            }else if($menuUrl == $activityMakeCode){
                $id = (int)input('get.id');
                if($currentUrl == $activityLinkCenter && $id){
                  $topmenuend2 = '<button class="layui-btn layui-btn-warm addlink">
                                    <i class="layui-icon">&#xe654;</i>生成新连接
                                    </button>';
                }
            }else if($menuUrl == $signupSetstatus){
                $this->assign('signupsetstatus',1);
            }else if($menuUrl == $signupDel){
                $this->assign('signupdel',1);
            }else if($menuUrl == $msglist){
                $this->assign('viewmsglist',1);
            }else if($menuUrl == $delmsg){
                $this->assign('delmsg',1);
            }else if($menuUrl == $editmsg){
                $this->assign('editmsg',1);
            }else if($menuUrl == $checkmsg){
                $this->assign('checkmsg',1);
            }
           

        }
         
        $this->assign('topmenu',$topmenu.$topmenuend1.$topmenuend.$topmenuend2);
        //return $topmenu;
    }
    
    /**
     * 方法描述  会员活动留言管理
     * @param  string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 上午9:22:57
     */
    public function activityMsg(){
        if(request()->isAjax()){
            $id = (int)input('request.id');
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
                'id'    => $id,
            ];
            //$this->makeCode();
            $data['data']  = controller($this->libname,'lib')->getMsgList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getMsgCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'活动留言管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    
    /**
     * 方法描述  修改活动留言
     * @return payCode
     * @author Leishaoju<Leishaoju@suxuantech.cn> 2018年02月02日 下午4:19:47
     */
    public function editActivityMsg () {
        if(request()->isAjax()){
            $content = htmlspecialchars(input('post.msgcontent'));
            $d = [
                'id'     => (int)input('post.id'),
                'content'=> $content,
                'status' => 1,
                'check_time' => date('Y-m-d H:i:s',time()),
                'staff_name' => $this->staffName,
                'staff_id'   => $this->staffId,
            ];
            if($d['id']){
                $res = controller('activity','lib')->editActivityMsg($d);
            }
            return json(['status'=>$res?1:0]);
        }
    }
    
    
    /**
     * 方法描述 删除活动留言
     * @return payCode
     * @author Leishaoju<Leishaoju@suxuantech.cn> 2018年02月02日 下午4:19:47
     */
    public function delActivityMsg () {
        if(request()->isAjax()){
            $id  = (int)input('request.id');
            if($id){
                $res = controller('activity','lib')->delActivityMsg($id);
            }
            return json(['status'=>$res?1:0]);
        }
    }

    /**
     * 方法描述  设置审核状态
     * @return payCode
     * @author Leishaoju<Leishaoju@suxuantech.cn> 2018年02月02日 下午4:19:47
     */
    public function setStatusMsg () {
        if(request()->isAjax()){
            $d = [
                'id'     => (int)input('request.id'),
                'status' => (int)input('request.status'),
                'check_time' => date('Y-m-d H:i:s',time()),
                'staff_name' => $this->staffName,
                'staff_id'   => $this->staffId,
            ];
            if($d['id']){
                $res = controller('activity','lib')->editActivityMsg($d);
            }
            return json(['status'=>$res?1:0]);
        }
    }
    
}