<?php
/**
* 广告控制器。
*
*  * ============================================================================
* 版权所有 2017北京素玄科技，并保留所有权利。
*
* 网站地址: http://www.suxuantech.com
* ----------------------------------------------------------------------------
* 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
* 不允许对程序代码以任何形式任何目的的再发布。
* 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
* ============================================================================
* $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
*/
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\AdverModel;
use think\controller;
use think\Session;

class  Advertising extends Base {
//    public  $showselect = [
//                '1'=>'我的任务中心',
//                '2'=>'任务大厅',
//                '3'=>'推荐新人',
//                '4'=>'推荐新人列表',
//                '5'=>'投诉建议头部',
//            ];
    public  $showselect = [
        '1'  => '首页上方-轮播',
        //'2'  => '首页下方',
        '4'  => '海量优惠券上方-轮播',
        '3'  => '海量优惠券中部-轮播',
        '9'  => '海量优惠卷下方-轮播',
        //'5'  => '粉丝日',
        //'6'  => '会员活动',
        '10' => '积分商城上方-轮播',
        '7'  => '积分商城订单-轮播',//积分商城我的订单
        //'8'  => '订单优惠',
        //'11' => '积分商城下方',
        '12' => '积分商城分类上方-轮播',
        '13' => '积分商城分类下商品-轮播',
        //'14' => '订单',
        //'15' => '任务大厅上方',
        //'16' => '任务大厅-功能入口',
        '20' => '品牌商品列表-轮播',
        '17' => '经纪人-功能入口',
        '18' => '活动中心-功能入口',
        '19' => '海量优惠券-功能入口',
        '21' => '电子相册-功能入口',
        '33' => '会员中心',

        '23' => '轮播下方-图片',
        '24' => '客照标题-图片',
        '25' => '首页中部轮播标题-图片',
        '26' => '首页中部-轮播',

        '27' => '版块1标题-图片',
        '28' => '版块1内容-图片',
        '29' => '版块2标题-图片',
        '30' => '版块2内容-图片',
        '31' => '版块3标题-图片',
        '32' => '版块3内容-图片',
        '22' => '首页下方-图片',
        //'23' => '每周视频',
        //'24' => '订单',
        //'25' => '帖子列表页',
        //'26' => '套系列表',
        //'27' => '公司介绍',
    ];
    public  $imgWH   = [
        'index' =>[1080,432],
    ];
    
    /**
     * 广告位展示页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function index () {
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $limit    = isset($c['limit'])?$c['limit']:5;
            $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
            

            $lists = db('advertising')->where('brandid',$this->brandId)->limit($limit,$pagenum)->select();
            foreach ($lists as $k=>$v){
                $lists[$k]['typename']   =  $this->showselect[$v['adv_seat']];
                $lists[$k]['adv_detail'] = $v['adv_detail']?json_decode($v['adv_detail'],true):'';
                unset($this->showselect[$v['adv_seat']]);
            }
            Session::set('hasAdv',count($this->showselect));
            $data['data'] = $lists;

            unset($c['limit'],$c['page']);
            $data['count'] = controller('Advertising','lib')->getCount(['brandid'=>$this->brandId]);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'广告管理中心'
            ],
        ]);
        
        $this->getTopMenu();
        return view();
    }
    
    /**
     * 广告位添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function add () {
        
        if(request()->isAjax()) {
            // 数据信息
            $acdata = request()->post();
            //print_r($acdata);die;
            // 获取上传的图片信息
            $data = [
                'adv_name' => $acdata['adv_name'],
                'create_time' => date('Y-m-d H:i:s', time()),
                'adv_status' => $acdata['adv_status'],
                'adv_seat' => $acdata['adv_seat'],
                'brandid' => $this->brandId,
            ];
        
            $fileimg = request()->file("image");


            if ($fileimg) {
                $updata = [];
                for($i=0;$i<count($fileimg);$i++){

                    //作为素材展示的图片不压缩比例
                    if(in_array($data['adv_seat'],[22,23,24,25,27,28,29,30,31,32])) {
                        $updata['img'][] = uploadImg($fileimg[$i],20971520,'jpg,gif,png,bmp');
                    }else{
                        $updata['img'][] = saveImg($fileimg[$i], $this->imgWH['index'][0], $this->imgWH['index'][1]);
                    }
                    $updata['link'][]  = $acdata['link'][$i];
                }
                $data['adv_detail'] = json_encode($updata);
            }

            // 处理数据
            $datas = AdverModel::insert($data);
            if ($datas===false) {
                $arr = array('code' => 200, 'msg' => '添加失败');
                return json($arr);
            } else {
                action_log($data);          //写日志
                Session::set('hasAdv',Session::get('hasAdv')-1);
                $arr = array('code' => 1, 'msg' => '添加成功');
                return json($arr);
            }
            
            
        }else{
            
            $select = db('advertising')->where(['brandid'=>$this->brandId])->column('adv_seat');
            if($select){
                foreach ($select as $v){
                    unset($this->showselect[$v]);
                }
            }
            $this->assign('showselect',$this->showselect);
            $this->assign([
                'headinfo'=>[
                    'title'=>'添加广告信息'
                ],
                'imgsize'=>$this->imgWH
            ]);
            $this->getTopMenu();
            return view ();
            
        }
    }

    /**
     * 广告位修改页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function edit () {
        if(IS_POST && request()->isAjax()){
            // 数据信息
            $acdata = request()->post();
            // 获取上传的图片信息
            $data = [
                'id'         => (int)$acdata['id'],
                'adv_name'   => $acdata['adv_name'],
                'create_time'=> date('Y-m-d H:i:s', time()),
                'adv_status' => (int)$acdata['adv_status'],
                'adv_seat'   => (int)$acdata['adv_seat'],
            ];
            $fileimg = request()->file("image");
            $updata = [];
            if ($fileimg) {
                 
                for($i=0;$i<count($fileimg);$i++){

                    //首页下方图片不压缩比例
                    if(in_array($data['adv_seat'],[22,23,24,25,27,28,29,30,31,32])) {
                        $updata['img'][] = uploadImg($fileimg[$i],20971520,'jpg,gif,png,bmp');
                    }else{
                        $updata['img'][] = saveImg($fileimg[$i], $this->imgWH['index'][0], $this->imgWH['index'][1]);
                    }

                    $updata['link'][]  = $acdata['link'][$i];
                }
            }

            if ($acdata['oldimg']) {
                $olddata = [];
                for($i=0;$i<count($acdata['oldimg']);$i++){
                    $updata['img'][]   = $acdata['oldimg'][$i];
                    $updata['link'][]  = $acdata['oldlink'][$i];
                }
            
            }
            $data['adv_detail'] = json_encode($updata);
            // 处理数据
            $res = db('advertising')->update($data);
            if($res!==false){
                action_log($data);          //写日志
                $this->msg = ['code'=>1,'msg'=>'修改成功'];
            }else{
                $this->msg = ['code'=>0,'msg'=>'修改失败'];
            }
            return json($this->msg);
        }else{
            $id = request()->get('id');
            if($id){
                $data = db('advertising')->where(['brandid'=>$this->brandId,'id'=>$id])->find();
                if(!$data){
                    return $this->error('无法获取您要修改的数据！');
                }
                $detail = json_decode($data['adv_detail'],true);
                $this->assign([
                    'data'   => $data,
                    'detail' => $detail,
                    'showselect' => $this->showselect[$data['adv_seat']],
                ]);
                $this->assign([
                    'headinfo'=>[
                        'title'=>'修改广告位信息'
                    ],
                    'imgsize'=>$this->imgWH
                ]);
                $this->getTopMenu();
                return $this->fetch();
            }else{
                return $this->error('无法获取您要修改的数据！');
            }
        }
    }

    /**
     * 广告位删除
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function del () {
        $id = (int)input('post.id');
        if(!$id){
            return json(['code'=>0,'msg'=>'非法操作']);
        }
        $arr = db('advertising')->where('id',$id)->find();
        $result = db('advertising')->where('id','=',$id)->delete();
        if ($result!==false) {
            action_log($arr);       //写日志
            Session::set('hasAdv',Session::get('hasAdv')+1);
            $code = 1;$msg = '广告位删除成功';
        } else { 
            $code = 0;$msg = '广告位删除失败';
        }
        return json(['code'=>$code,'msg'=>$msg]);
    }
    

    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth('auth');
        $currentUrlStart = '/vip/advertising/';
        $indexurl   = $currentUrlStart.'index';
        $edit  = $currentUrlStart.'edit';
        $add   = $currentUrlStart.'add';
        $del   = $currentUrlStart.'del';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        $hasadv = (int)Session::get('hasAdv');
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $indexurl){
                $class = '';
                if($indexurl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$indexurl.'">广告管理</a></div>';
            }else if($menuUrl == $add){
                if($hasadv>0){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$add.'">添加广告</a></div>';
                }
            }else if($menuUrl == $edit){
                $this->assign('edit',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }
        }
         
        $this->assign('topmenu',$topmenu);
        //return $topmenu;
    }
    

}