<?php
/**
 * 品牌故事
 * User: zhaibaoming
 * Date: 2018/8/10 0010
 * Time: 15:46
 */

namespace app\vip\controller;

use app\index\controller\Base;

class Brand extends Base
{
    public function index()
    {
        if (request()->isGet()) {
            $data = controller('vip/McBrandStory', 'model')->getData($this->brandId);
            $this->assign('data', $data);
            $this->assign([
            'headinfo'=>[
                    'title'=>'品牌故事'
                ]
            ]);
            return $this->fetch('Brand/index');
        }
        $resultData = ['code' => 0, 'msg' => ''];

        $acdata = request()->post();
        $data['brand_id']    = $this->brandId;
        $data['image']       = $acdata['up2-img'];
        $data['title_image'] = $acdata['up1-img'];
        // $fileimg = request()->file("image");
        // if (empty($fileimg)) {
        //     $resultData['msg'] = '没有上传图片';
        //     return json($resultData);
        // }
        // $data['image'] = save_images($fileimg, get_brand_story_image_subdirectory());

        $resultList = controller('vip/McBrandStory', 'model')->getData($this->brandId);
        if ($resultList) {
            //删除老数据
            controller('vip/McBrandStory', 'model')->delBidData($this->brandId);
        }

        $res = controller('vip/McBrandStory', 'model')->addData($data);

        if ($res) {
            $resultData['msg'] = '添加成功';
            $resultData['code'] = 200;
            return json($resultData);
        }
        $resultData['msg'] = '添加失败';
        return json($resultData);
    }


    public function del()
    {
        $res = controller('vip/McBrandStory', 'model')->delBidData($this->brandId);

        if ($res) {
           $this->success('删除成功');
        }
        $this->error('删除失败');
    }

    /*
     * 首页视频
     */
    public function indexVideo(){

        if(request()->isAjax()){
            $param = input();

            $info = [
                'image' => $param['image'],
                'url'   => $param['url'],
                'is_show'   => $param['is_show'],
                'brand_id'  => $this->brandId,
                'create_time' => date('Y-m-d H:i:s'),
            ];

            if($param['id']){
                $res = db('mc_video')->where('id',$param['id'])->update($info);
            }else{
                $res = db('mc_video')->insert($info);
            }

            if($res !== false){
                return ['code'=>200,'msg'=>'设置成功'];
            }else{
                return ['code'=>201,'msg'=>'设置失败！'];
            }

        }


        $detail = db('mc_video')->where(['brand_id'=>$this->brandId])->find();

        $this->assign(['detail'=>$detail]);
        return $this->fetch();
    }
}