<?php
/**
 * 优惠券控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Zhao Jie Peng <zhaojiepeng@suxuantech.cn>  2017年11月14日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
class Couponbag extends Base{
    protected $msg = ['status'=>0,'msg'=>'操作失败'];//用于ajax返回的数据
    /**
     * 方法描述:优惠券类别列表
     * @return array
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $d['data']  = controller('couponbag','lib')->getList($c);
            $d['count'] = controller('couponbag','lib')->getBagCount();
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $this->assign([
            'headinfo'=>[
                'title' => '卡包管理',
            ]
        ]);
        controller('coupon','controller')->getTopMenu();
        return $this->fetch();
    }
    /**
     * 方法描述:添加优惠券类别
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function add(){
        if(IS_POST && request()->isAjax()){
            $data = input();

            $title    = $data['title'];
            $sort     = $data['sort'];

            //优惠券和张数
            $couponData = [];
            foreach($data['couponid'] as $k => $v){
                $couponData[] = ['couponid'=>$v,'num'=>$data['num'][$v]];
            }
            $cid = json_encode($couponData);

            //$couponid = json_decode(request()->post('couponid'));
            //$cid = implode(',',$couponid);

            $data = [
                    'name' =>$title,
                    'cid'   =>$cid,
                    'sort'  =>$sort,
                ];

            $res = controller('couponbag','lib')->add($data);
            if($res){
                action_log($data);      //写日志
                $this->msg = ['code'=>200,'msg'=>'添加成功'];
            }else{
                $this->msg = ['code'=>202,'msg'=>'添加失败'];
            }
            return json($this->msg);
        }else{
            //$couponlist = controller('coupon','lib')->getList('','all');
            $couponlist = db('c_coupon_num')->where(["brandid"=>$this->brandId,'end_time'=>['>=',date('Y-m-d H:i:s')]])->select();

            $this->assign('couponlist',$couponlist);
            controller('coupon','controller')->getTopMenu();
            return $this->fetch();
        }
    }
    
    /**
     * 修改优惠券类别信息
     * @param string
     * @param string
     * @param string
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function edit(){
        if(IS_POST && request()->isAjax()){
            $data = input("post.");

            $title    = $data['title'];
            $sort     = $data['sort'];
            $id       = $data['id'];

//            $couponid = json_decode(request()->post('couponid'));
//            $cid  = implode(',',$couponid);

            //优惠券和张数
            $couponData = [];
            foreach($data['couponid'] as $k => $v){
                $couponData[] = ['couponid'=>$v,'num'=>$data['num'][$v]];
            }
            $cid = json_encode($couponData);

            $data = [
                    'name' =>$title,
                    'cid'  =>$cid,
                    'sort' =>$sort,
                ];
            $res = controller('couponbag','lib')->edit($id,$data);
            if($res){
                action_log($data);      //写日志
                $this->msg = ['code'=>200,'msg'=>'修改成功'];
            }else{
                $this->msg = ['code'=>202,'msg'=>'修改失败'];
            }
            return json($this->msg);
        }else{
            $id = input("id");
            $couponbag = controller('couponbag','lib')->getList(['id'=>$id]);

            if($couponbag&&$couponbag['cid']){
                $cid = json_decode($couponbag['cid'],true);
                $coupon_id = array_column($cid,'couponid');
                $num = [];
                foreach($cid as $k => $v){
                    $num[$v['couponid']] = $v['num'];
                }
            }

            //$couponlist = controller('coupon','lib')->getList('','all');
            $couponlist = db('c_coupon_num')->where(["brandid"=>$this->brandId,'end_time'=>['>=',date('Y-m-d H:i:s')]])->select();

//            if($couponbag){
//                $cid = explode(',', $couponbag['cid']);
//            }
//            $couponlist = controller('coupon','lib')->getList('','all');
//            foreach ($couponlist as $k => $v) {
//                foreach ($cid as $k2 => $v2) {
//                    if($v['id'] == $v2){
//                        $couponlist[$k]['checked'] = 1;
//                    }
//                }
//            }
            $this->assign(['couponbag'=>$couponbag,'cid'=>$cid,'coupon_id'=>$coupon_id,'num'=>$num]);
            $this->assign('couponlist',$couponlist);
            controller('coupon','controller')->getTopMenu();
            return $this->fetch();
        }
    }
 
    /**
     * 方法描述: 删除优惠券类型，假删除
     * @param  int $id 优惠券类型的id
     * @return bool
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id  = request()->post('id');
        $arr = controller('couponbag','lib')->getlist(['id'=>$id]);
        $res = controller('couponbag','lib')->del($id);
        if($res){
            action_log($arr);       //写日志
            return json( ['code'=>200,'msg'=>'修改成功']);
        }else{
            return json(['code'=>201,'msg'=>'修改失败']);
        }
    }

}