<?php
/**
* 用户提现处理控制器。
*
*  * ============================================================================
* 版权所有 2017北京素玄科技，并保留所有权利。
*
* 网站地址: http://www.suxuantech.com
* ----------------------------------------------------------------------------
* 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
* 不允许对程序代码以任何形式任何目的的再发布。
* 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
* ============================================================================
* $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
*/
namespace app\vip\controller;
use app\index\controller\Base;
use think\Session;
class Disposemoney extends Base{
    /**
     * 用户提现处理页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function index () {
        $brandId = Session::get('brandid');
        if(request()->isAjax()){

            $postData  = input();

            $data['data'] = controller('Disposemoney','lib')->getList($postData);
            $data['count'] = controller('Disposemoney','lib')->getCount($postData);

            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'财务管理'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 导出体现数据
     */
    public function export(){
        $data = input('get.');
        $sql = controller('Disposemoney','lib')->getSql($data);

        $data = db('m_withdraw_log')
            ->alias('a')
            ->join('m_withdraw b','a.userid = b.userid')
            ->where('a.brandid',Session::get('brandid'))
            ->where($sql)
            ->field('a.userid,a.get_number,b.user_number,b.user_true_name,a.get_money,b.bank_code,a.get_time,a.money_status')
            ->select();

        $export_header=export_header();
        controller("Disposemoney","lib")->export($export_header,$data,'提现数据.xlsx');
    }

    //导入页面
    public function import(){

        $size=getMaxUploadSize();
        $this->assign('size', $size);
        return view('import');
    }

    //文件上传
    public function uploadExcel(){
        //获取表单上传文件
        $get_file=$_FILES;
        $before_name=$get_file['file']['name'];

        $file = request()->file('file');
        controller("Disposemoney","lib")->uploadExcel($file,$before_name);
    }

    /*
     * 导入文件列表
     */
    function new_list(){
        $excel=db('c_excel_import')->where(array('staff_id'=>Session::get('staff_id'),'excel_type'=>2))->ORDER("addtime desc")->select();
        $this->success('成功','/',$excel);
    }

     /*
     * 下载导入模板
     */
     public function excel_download(){
         $title=template_header();;
         $file="模板.xlsx";
         return controller("Disposemoney","lib")->export($title,'',$file);
     }

    //下载源文件
    function before_file($id){
        $data=db('c_excel_import')->where(array('id'=>$id))->find();
        $this->down_file($data['file_url'],$data['file_name']);
    }

    //下载失败文件
    function fail_file($id){
        $data=db('c_excel_import')->where(array('id'=>$id))->find();
        $this->down_file($data['fail_file_url'],'错误数据-'.$data['file_name']);
    }

    //下载文件
    function down_file($url,$name){
        $file=fopen($url,"r");
        header("Content-Type: application/octet-stream");
        header("Accept-Ranges: bytes");
        header("Accept-Length: ".filesize($url));
        header("Content-Disposition: attachment; filename=".$name);
        echo fread($file,filesize($url));
        fclose($file);

    }


    /**
     * 用户提现处理到账成功
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function ok () {
        $id = input('post.id');
        $staffName = Session::get('staffname');
        $moneyStatus = 1;
        $exeTime = date('Y-m-d H:i:s',time());
        $okData = [
            'money_status' => $moneyStatus,
            'staff_name' => $staffName,
            'exe_time' => $exeTime
        ];
        $okResult = db('m_withdraw_log')->where('id',$id)->update($okData);
        if ($okResult === false) {
            $jsonData = ['code'=>201,'msg'=>'到账数据处理失败'];
            return json($jsonData);
        }
        action_log($okData);        //写日志
        $jsonData = ['code'=>200,'msg'=>'到账数据处理成功'];
        return json($jsonData);
    }
    /**
     * 用户提现处理到账未成功
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function error () {
        $id = input('post.id');
        $state = input('post.state');
        $staffName = Session::get('staffname');
        $moneyStatus = 3;
        $exeTime = date('Y-m-d H:i:s',time());
        $errorData = [
            'exe_time' => $exeTime,
            'staff_name' => $staffName,
            'money_status' => $moneyStatus,
            'error_state' => $state
        ];
        $errorResult = db('m_withdraw_log')->where('id',$id)->update($errorData);
        if ($errorResult === false) {
            $jsonData = ['code'=>201,'msg'=>'未到账数据处理失败'];
            return json($jsonData);
        }
        action_log($errorData);         //写日志
        $jsonData = ['code'=>200,'msg'=>'未到账数据处理成功'];
        return json($jsonData);

    }



}