<?php
/**
 * 活动报名和获取报价控制器--------废弃
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月24日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\AActivitySignUp;

class Getmoney extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'activitysignup';
    
    /**
     * 方法描述: 获取报价列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getGetMoneyList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getGetMoneyCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'获取报价管理'
            ]
        ]);
        
        $this->getTopMenu();
        return $this->fetch();
    }
 
    /**
     * 方法描述     设置活动发布状态，是否启用
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id  = request()->post('id');
        $res = db('a_activity_sign_up')->where('id','=',$id)->update(['status'=>1,'check_userid'=>$this->staffId,'update_time'=>date('Y-m-d H:i:s',time()),'check_name'=>$this->staffName]);
//        $res =  controller($this->libname,'lib')->setStatus($id,1);
        return json(['status'=>$res?1:0,'msg'=>'']);
    }
    
    
    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $res = AActivitySignUp::destroy($id);
        if ($res) {
            $arr = array('status' => 1, 'msg' => '删除成功');
            return json($arr);
        } else {
            $arr = array('status' => 0, 'msg' => '删除失败');
            return json($arr);
        }
    }

    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/getmoney/';
        //print_r($menuList);
        $indexurl    = $currentUrlStart.'index';
        $setstatus   = $currentUrlStart.'setstatus';
        $del   = $currentUrlStart.'del';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $indexurl){
                $topmenu .= '<div class="layui-btn mactive" ><a href="'.$indexurl.'">获取报价管理</a></div>';
            }else if($menuUrl == $setstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }
           
            if($v['children']){
                foreach ($v['children'] as $kk=>$vv){
                    $submenuUrl = strtolower(str_replace('/', '\\', $vv['menu_url']));
                    if($submenuUrl == $indexurl){
                        $topmenu .= '<div class="layui-btn mactive" ><a href="'.$indexurl.'">获取报价管理</a></div>';
                    }else if($submenuUrl == $setstatus){
                        $this->assign('setstatus',1);
                    }else if($submenuUrl == $del){
                        $this->assign('del',1);
                    }
                }
            }
        }
         
        $this->assign('topmenu',$topmenu);
    }
    
}