<?php
/**
 * 团购控制器。
 *
 *  * ============================================================================
 * 版权所有 2018北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2018-04-09 $
 */
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\SScoreDetail;
use think\Cache;
use think\Session;
class Groupbuy extends Base {
    //用于ajax返回的数据
    protected $msg     = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'Groupbuys';
    protected $imgWH   = [
                                'share' =>[300,300],
                                'index' =>[555,300],
                                'info'   =>[400,600],
                                'apply'   =>[400,600],
                            ];
    /**
     * 方法描述: 获取列表
     * @return array
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月10日 11:03:38
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'活动管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    /**
     * 方法描述：团购详情
     * @param  
     * @return Ambigous <\think\mixed, string>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>2018年4月10日 10:15:38
     */
    public function group_buy(){
        if(request()->isAjax()){
            $c = [
            'limit'  => (int)input('get.limit'),
            'page'   => (int)input('get.page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getgroupbuyList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
            'title'=>'团购管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    /**
     * 方法描述：参与人员管理
     * @param
     * @return Ambigous <\think\mixed, string> 
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>2018年4月10日 10:22:38
     */
    public function group_user(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getgroupuserList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
    	$this->assign([
	           'headinfo'=>[
	           'title'=>'参团人员管理'
        	   ]
    	]);
    	$this->getTopMenu();
    	return $this->fetch();
    }
    /**
     * 方法描述：团购活动添加
     * @return Ambigous <\think\mixed, string>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>2018年4月10日 11:10:38
     */
    public function activityadd(){
    	if(IS_POST && request()->isAjax()){
    	    // 数据信息
    	    $acdata = request()->post();
    	    $fileimg  = request()->file("indeximg");     //列表图
    	    $shareimg = request()->file("shareimg");     //分享图片
    	    //$infoimg   = request()->file("infoimg");   //详情图
    	    //$applyimg   = request()->file("applyimg"); //报名图
    	    $upimg = $share_img = $apply_img = false;
    	    if($fileimg){
    	        $upimg = saveImg($fileimg,$this->imgWH['index'][0],$this->imgWH['index'][1]);
    	    }else{
    	        return json(['status'=>0,'msg'=>'请上传列表图片']);
    	    }
//     	    if($infoimg){
//     	        $info_img = saveImg($infoimg,$this->imgWH['info'][0],$this->imgWH['info'][1]);
//     	    }else{
//     	        return json(['status'=>0,'msg'=>'请上传详情图片']);
//     	    }
    	    /* if($applyimg){
    	    	$apply_img = saveImg($applyimg,$this->imgWH['apply'][0],$this->imgWH['apply'][1]);
    	    }else{
    	        return json(['status'=>0,'msg'=>'请上传报名图片']);
    	    } */
    	    if($shareimg){
    	        $share_img = saveImg($shareimg,$this->imgWH['share'][0],$this->imgWH['share'][1]);
    	    }else{
    	    	return json(['status'=>0,'msg'=>'请上传分享图片']);
    	    }
    	    if($upimg){
    	        $coupon_num = db("c_coupon_num")->where("id",$acdata['couponid'])->field("coupon_num")->find();
    	        $coupon_num = $doupon_num['coupon_num'];
    	        $data = [
    	        'activity_title'     => $acdata['activity_title'], //活动标题
    	        'list_img'           => $upimg,
    	        'info_img'           => $acdata['infoimg'],
    	      //'apply_img'          => $apply_img,
    	        'share_img'          => $share_img,
    	        //'share_score'        => $acdata['share_score'],
    	        'share_title'        => $acdata['share_title'],
    	        'share_desc'         => $acdata['share_desc'],
    	        'starttime'          => $acdata['starttime'],
    	        'endtime'            => $acdata['endtime'],
    	        'status'             => $acdata['status'],
    	        'wedding_price'      => $acdata['wedding_price'],
    	        'discount'           => $acdata['discount'],
    	        'user_require'       => $acdata['user_require'],
    	        'brandid'            => $this->brandId,
    	        'permit_level'       => $acdata['levelids']?implode(',',$acdata['levelids']):'',     //参与用户等级
    	        'create_time'        => date("Y-m-d",time()),
    	        'ordernum'           => $acdata['ordernum'],
    	        'couponid'           => $acdata['couponid'],
    	        'coupon_num'         => $coupon_num,
    	        'price'              => $acdata['price'],
    	        'front_money'        => $acdata['front_money'],
    	        ];
    	        if(!$acdata['starttime']){
    	            unset($data['start_time']);
    	        }
    	        if(!$acdata['endtime']){
    	            unset($data['end_time']);
    	        }
    	        $res = controller($this->libname,'lib')->add($data);
                
    	        if($res){
    	            action_log($data);       //写日志(活动列表)

                    //新团购（添加活动 直接添加 团购）
                    $data2['activity_id']       = $res;
                    $data2['activity_title']    = $acdata['activity_title'];
                    //$data2['broker_id']         = Session::get("phoneid");
                    //$data2['broker_name']       = Session::get("username");
                    $data2['brandid']           = $this->brandId;
                    $data2['create_time']       = date("Y-m-d H:i:s");
                    $res2 = db("group_buy")->insert($data2);
                    if($res2){
                        action_log($data2);      //写日志(团购活动)
                        $this->msg = ['status'=>1,'msg'=>'添加成功'];    
                    }else{
                        db("group_activity")->where("id",$res)->delete();
                        $this->msg = ['status'=>0,'msg'=>'添加失败'];
                    }
    	        }else{
    	            // 上传失败获取错误信息
    	            $this->msg = ['status'=>0,'msg'=>'添加失败'];
    	        }
    	    }else{
    	        $this->msg = ['status'=>0,'msg'=>'图片上传失败,请确认是图片类型'];
    	    }
            return json($this->msg);
    	}else{
    	    $this->assign([
    	        'headinfo'=>[
    	        'title'=>'添加新活动'
    	        ]
    	        ]);
    	    $this->assign('coupons',controller($this->libname,'lib')->getcouponlist());
    	    $this->assign('levels',controller('level','lib')->getList());
    	    $this->assign('imgsize',$this->imgWH);
    	    return $this->fetch();
    	}
    }
    /**
     *方法描述：活动修改
     */
    public function activityedit(){
        if(IS_POST && request()->isAjax()){
            // 数据信息
            $acdata = request()->post();
            $data = [
            'id'                 => $acdata['id'],
            'activity_title'     => $acdata['activity_title'], //活动标题
           // 'share_score'        => $acdata['share_score'],
            'share_title'        => $acdata['share_title'],
            'share_desc'         => $acdata['share_desc'],
            'starttime'          => $acdata['starttime'],
            'endtime'            => $acdata['endtime'],
            'status'             => $acdata['status'],
            'wedding_price'      => $acdata['wedding_price'],
            'discount'           => $acdata['discount'],
            'user_require'       => $acdata['user_require'],
            'brandid'            => $this->brandId,
            'permit_level'       => $acdata['levelids']?implode(',',$acdata['levelids']):'',     //参与用户等级
            'update_time'        => date('Y-m-d',time()),
            'ordernum'           => $acdata['ordernum'],
            'price'              => $acdata['price'],
            'couponid'           => $acdata['couponid'],
            'front_money'        => $acdata['front_money'],
            'info_img'           => $acdata['infoimg']
            ];
            $fileimg  = request()->file("indeximg");
            $shareimg = request()->file("shareimg");
           // $infoimg   = request()->file("infoimg");
          //$applyimg   = request()->file("applyimg"); //报名图
            if($fileimg){
                $data['list_img'] = saveImg($fileimg,$this->imgWH['index'][0],$this->imgWH['index'][1]);
            }
//             if($infoimg){
//                 $data['info_img'] = saveImg($infoimg,$this->imgWH['info'][0],$this->imgWH['info'][1]);
//             }
            /* if($applyimg){
                $data['apply_img'] = saveImg($applyimg,$this->imgWH['apply'][0],$this->imgWH['apply'][1]);
            } */
            if($shareimg){
                $data['share_img'] = saveImg($shareimg,$this->imgWH['share'][0],$this->imgWH['share'][1]);
            }
            if(!$acdata['starttime']){
                unset($data['start_time']);
            }
            if(!$acdata['endtime']){
                unset($data['end_time']);
            }
            // 处理数据
            $res = controller($this->libname,'lib')->edit($data);
            if($res===false){
                $this->msg = ['status'=>0,'msg'=>'修改失败'];
            }else{
                action_log($data);          //写日志
                $this->msg = ['status'=>1,'msg'=>'修改成功'];
            }
            return json($this->msg);
        }else{
            $id = request()->get('id');
            if($id){
                $this->assign([
                    'videos' => controller($this->libname,'lib')->getVideolist(),
                    'bgimgs' => controller($this->libname,'lib')->getImgList(),
                    'levels' => controller('level','lib')->getList(),
                    'coupons'=> controller($this->libname,'lib')->getcouponlist(),
                    'data'   => controller($this->libname,'lib')->getOne($id)
                    ]);
                $this->assign([
                    'headinfo'=>[
                        'title'=>'修改活动'
                    ],
                    'imgsize' => $this->imgWH,
                    ]);
                    $this->getTopMenu();
                return $this->fetch();
            }else{
                return $this->error('无法获取您要修改的数据！');
            }
        
       }
    }

    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function activitydel(){
        $id = request()->post('id');
        $arrs = db('recommend')->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id);
        if ($res) {
            action_log($arrs);      //写日志
            $arr = array('status'=>1,'msg'=>'信息删除成功');
            return json($arr);
        } else {
            $arr = array('status'=>0,'msg'=>'信息删除失败');
            return json($arr);
        }
    }

    public function user_info(){
    	$id = request()->post('id');
    	$arr = db('group_user')
    	       ->where('groupbuy_id',$id)
    	       ->field('user_name,wedding_day,phone')
    	       ->select();
        if($arr){
            $res = array('status'=>1,'msg'=>'查询成功','data'=>$arr);
            return json($res);
        }else{
            $res = array('status'=>1,'msg'=>'查询成功','data'=>$arr);
        	return  json($res);
        }
    }
    /**
     * 方法描述     设置状态，是否启用
     * @param  int $id id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
//     public function setStatus(){
//         $id     = request()->post('id');
//         $status = 1;
//         $res = controller($this->libname,'lib')->setStatus($id,$status);
//         return json(['status'=>$res?1:0]);
//     }


    /**
     * 用户推荐列表页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */

    public function setStatus () {
        $recommenId = input('post.id');
        if(!$recommenId){
            $arr = array('status'=>0,'msg'=>'无法获取您要审核的数据,请刷新页面重试！');
            return json($arr);
        }
        $memData = db('recommend')
            ->alias('a')
                ->field('a.*,b.id,p.userid as puserid')
            ->join('m_users b','a.userid = b.id')
            ->join('m_users_phone p','p.userid=b.id','left')
            ->where('a.id','=',$recommenId)
            ->find();
        if(!$memData){
            $arr = array('status'=>0,'msg'=>'无法获取您要审核的数据,请刷新页面重试！');
            return json($arr);
        }
        $memId   = $memData['userid'];  //推荐人id
        $staffId = Session::get('staffid'); //哪个员工更改的
        $status  =  input('post.status');
        
        // 获取积分规则
        $scoreRule  = getScoreRule(['userid'=>$memId]);
        $recomdRule = '';
        if($scoreRule){
            $recomdRule = $scoreRule['recommend_rule'];
        }
        
//        $phoneid = 0;
//        if($memData['puserid']){
//            $phoneid = 1;
//        }
        db()->startTrans();
        try{
            if ($status == 2 ) {
                $memCount = db('recommend')->where(array('userid'=>$memId,'status'=>2))->count();  //查询推荐了几人
               
                $minute   = 0;
                if($recomdRule){
                    $minute = $recomdRule[$memCount] ? $recomdRule[$memCount]['scores'] :($recomdRule[1]['scores']?$recomdRule[1]['scores']:'') ;
                    //$minute?minuteDetailed("推荐用户",(int)$minute,$memId,8,$phoneid):'';
                    //$minute?minuteDetailed("推荐用户",(int)$minute,$memId,8,$memData['puserid']):'';
                    
                }
                $result = growthMemRecord($memId,5,$recommenId);
                if (!$result) {
                    $gro = getGrowthRule(['userid'=>$memId]);
                    if($gro){
                        growthDetailed($memId,$gro['recommend'],5,$recommenId,$phoneid);
                    }
                }  
                $d = [
                    'check_user' => $this->staffName,
                    'status'     => 2,
                    'recom_num'  => (int)$minute,
                    'update_time'=> date('Y-m-d H:i:s',time())
                ];
                $memRecon = db('recommend')->where('id','=',$recommenId)->update($d);
                if ($memRecon!==false) {
                    if($minute){
                        /*if($phoneid){
                            $tableName = 'm_users_phone';
                            $fieldname = 'userid';
                        }else{
                            $tableName = 'm_users';
                            $fieldname = 'id';
                        }
                                   
                        $memAggScore = db($tableName)->where($fieldname,'=',$memId)->setInc('total_score',(int)$minute);*/
                        $score = AddScore($memId,$phoneid,$minute,'8','推荐用户');
                        if($score === false){
                            db()->rollback();
                            $arr = array('status'=>0,'msg'=>'更改状态失败');
                            return json($arr); 
                        }
                    }
                    action_log($d);     //写日志
                    db()->commit();
                    $arr = array('status'=>1,'msg'=>'状态更改成功');
                    return json($arr);
                } else {
                    db()->rollback();
                    $arr = array('status'=>0,'msg'=>'更改状态失败');
                    return json($arr);
                }
            }else{
               $d = [
                   'check_user' => $this->staffName,
                   'status'     => 1,
                   'update_time'=> date('Y-m-d H:i:s',time())
               ];
               $memRecon = db('recommend')->where('id','=',$recommenId)->update($d);
               if ($memRecon!==false) {
                   action_log($d);          //写日志
                   db()->commit();
                   $arr = array('status'=>1,'msg'=>'状态更改成功');
                   return json($arr);
               } else {
                    db()->rollback();
                   $arr = array('status'=>0,'msg'=>'更改状态失败');
                   return json($arr);
               }
            }
        }
        catch (Exception $e){
            db()->rollback();
            $arr = array('status'=>0,'msg'=>'更改状态失败');
            return json($arr);
        }
    }

    /*经纪人管理
     *
     */
    public function agent(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];
            $limit    = isset($c['limit'])?$c['limit']:5;
            $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
            $data['data']  = db('m_users_phone')->where('agent_status is not null')->limit($pagenum,$limit)->order('agent_status')->select();

            $data['count'] = db('m_users_phone')->where('agent_status is not null')->count('id');
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'经纪人管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }

    /*
     * 审核经纪人
     */
    public function checkAgent(){
        $phone_id = input('post.id');
        $agent_status=input('post.status');
        $res=db('m_users_phone')->where('id',$phone_id)->update(array('agent_status'=>$agent_status,'check_apply_time'=>date('Y-m-d H:i:s',time())));
        if($res!==false){
            if($agent_status==2){
                //审核通过，发模板消息提醒已成为经纪人
            }
            action_log(array('agent_status'=>$agent_status,'check_apply_time'=>date('Y-m-d H:i:s',time())));
            return json(array('status'=>1,'msg'=>'状态更改成功'));
        }
    }


    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/groupbuy/';
        //print_r($menuList);
        $indexurl    = $currentUrlStart.'index';
        $activityadd    = $currentUrlStart.'activityadd';
        $activityedit   = $currentUrlStart.'activityedit';
        $activitydel    = $currentUrlStart.'activitydel';
        $buyUrl      = $currentUrlStart.'group_buy';
        $userUrl     = $currentUrlStart.'group_user';
        

        $checkAgent   = $currentUrlStart.'checkAgent';
        $delAgent   = $currentUrlStart.'delAgent';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $indexurl){
                $class = '';
                if($indexurl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$indexurl.'">活动管理</a></div>';
            }else if($menuUrl == $buyUrl){
                $class = '';
                if($buyUrl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$buyUrl.'">团购管理</a></div>';
            }elseif ($menuUrl == $userUrl){
                $class = '';
                if($userUrl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$userUrl.'">参团人员管理</a></div>';
            }else if($activityadd == $menuUrl){
                 $topmenuend1 = '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$activityadd.'">添加活动</a></div>';
            }else if($menuUrl == $activityedit){
                $this->assign('activityedit',1);
            }else if($menuUrl == $activitydel){
                $this->assign('activitydel',1);
            }else if($menuUrl == $checkAgent){
                $this->assign('checkAgent',1);
            }else if($menuUrl == $delAgent){
                $this->assign('delAgent',1);
            }
        }
        $this->assign('topmenu',$topmenu.$topmenuend1);
    }
    
    
}