<?php
/**
 * 客片大少
 * User: Wangyining<Wangyining@suxuantech.cn>
 * Date: 2019/04/22
 */
namespace app\vip\controller;
use app\index\controller\Base;

class Guestphoto extends Base{
	protected $libname = 'Guestphoto';

    /*
     *  后台 客片列表
     */
    public function photoList(){

        if(request()->isAjax()){
            $params = input();
            $params['upload_type'] = 1;//上传类型，1后台上传，2用户前台上传
            $params['title'] = input('title');
            $params['content_text'] = input('content_text');
            $params['type_id']  = input('type_id');

            $data = controller($this->libname,'lib')->photoList($params);
            $count = controller($this->libname,'lib')->photoCount($params);
            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }

        //分类
        $type = db('guest_photo_type')->where(['brand_id'=>$this->brandId])->select();
        //标签
        $tips = db('guest_photo_tip')->where('brand_id',$this->brandId)->select();
        $this->getTopMenu();
        $this->assign([
            'type' => $type,
            'tips' => $tips,
            'headinfo'=>[
                'title'=>'客片管理'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 客片添加
     * @return [type] [description]
     */
    public function photoAdd(){
        if(request()->isAjax()){

            $params = request()->post();

            $res = controller($this->libname, 'lib')->photoAdd($params);

            return $res;
        }

        //分类
        $type = db('guest_photo_type')->where(['brand_id'=>$this->brandId])->select();
        //标签
        $tip = db('guest_photo_tip')->where(['brand_id'=>$this->brandId])->select();
        //套系
        $package = db('s_package_info')->where(['brand_id'=>$this->brandId,'is_del'=>1])->select();

        $this->assign(['type'=>$type,'tip'=>$tip,'package'=>$package]);

        return $this->fetch();
    }

    /*
     * 客片修改
     */
    public function photoEdit(){
        if(request()->isAjax()){

            $params = request()->post();

            $res = controller($this->libname, 'lib')->photoEdit($params);

            return $res;
        }

        $id   = input('id');

        $data = db('guest_photo')->where('id',$id)->find();
        //分类
        $type = db('guest_photo_type')->where(['brand_id'=>$this->brandId])->select();
        //标签
        $tip = db('guest_photo_tip')->where(['brand_id'=>$this->brandId])->select();
        //套系
        $package = db('s_package_info')->where(['brand_id'=>$this->brandId,'is_del'=>1])->select();

        $this->assign('detail',json_decode($data['content_img'],true));
        $this->assign(['id'=>$id,'data'=>$data,'type'=>$type,'tip'=>$tip,'package'=>$package]);

        return $this->fetch();
    }

    //删除客片
    public function photoDel(){
        $id = input('id');
        $res = db('guest_photo')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }

    /**
     * 通用图片上传接口
     * @return \think\response\Json
     */
    public function upload()
    {
        $config = [
            'size' => 20971520,
            'ext'  => 'jpg,gif,png,bmp'
        ];
        $file        = $this->request->file('file');

        $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
        $save_path   = '/uploads/';
        $info        = $file->validate($config)->move($upload_path);
        if ($info) {
            $result = [
                'error' => 0,
                'url'   => str_replace('\\', '/', $save_path . $info->getSaveName())
            ];
        } else {
            $result = [
                'error'   => 1,
                'message' => $file->getError()
            ];
        }
        return json($result);
    }


    /**
     * 通用视频上传接口
     * @return \think\response\Json
     */
    public function uploadVideo()
    {
        $config = [
            'size' => 52428800,
            'ext'  => 'mp4'
        ];
        $file        = $this->request->file('file');
        $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
        $save_path   = '/uploads/';
        $info        = $file->validate($config)->move($upload_path);
        if ($info) {
            $result = [
                'error' => 0,
                'url'   => str_replace('\\', '/', $save_path . $info->getSaveName())
            ];
        } else {
            $result = [
                'error'   => 1,
                'message' => $file->getError()
            ];
        }
        return json($result);
    }


    //获取客片类型列表
    public function getType(){
        $device = db('guest_photo_type')->where('brand_id',$this->brandId)->select();
        return array('code'=>'200','data'=>$device);
    }

    /*
     *  后台 客片分类列表------暂时没用
     */
    public function photoTypeList(){

        if(request()->isAjax()){
            $params = input();
            $data = controller($this->libname,'lib')->photoTypeList($params);
            $count = controller($this->libname,'lib')->photoTypeCount($params);
            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }
        $this->getTopMenu();
        $this->assign([
            'headinfo'=>[
                'title'=>'客片分类管理'
            ]
        ]);
        return $this->fetch();
    }


    //添加客片分类  -----暂时没用
    public function photoTypeAdd(){
        if(request()->isAjax()){

            $params = request()->post();
            if(db('guest_photo_type')->where(['type_name'=>$params['type_name'],'brand_id'=>$this->brandId])->find()){
                return ['code'=>201,'msg'=>'此分类已存在，请修改分类名称'];
            }

            $info = [
                'type_name' => $params['type_name'],
                'sort'      => $params['sort'],
                'brand_id'  => $this->brandId,
                'staff_id'  => session('staff_id'),
                'staff_name'  => session('staffname'),
                'create_time' => date('Y-m-d H:i:s'),
            ];

            $res = db('guest_photo_type')->insert($info);

            return $res;
        }


        return $this->fetch();
    }

    //新增编辑 客片类型
    public function addType(){
        $id = input('id');
        $type_name = input('type_name');
        db()->startTrans();

        $updateInfo = [
            'type_name' => $type_name,
            'brand_id'  => $this->brandId,
            'staff_id'  => session('staff_id'),
            'staff_name'  => session('staffname'),
            'create_time' => date('Y-m-d H:i:s'),
        ];

        try{
            if($id){
                db('guest_photo_type')->where('id',$id)->update($updateInfo);
            }else{
                $id = db('guest_photo_type')->insertGetId($updateInfo);
            }
            db()->commit();
            return array('code'=>200,'data'=>$id);

        }catch (\Exception $e){
            db()->rollback();
            return array('code'=>201,'msg'=>'操作客片分类失败，请稍后重试！');
        }

    }

    //删除客片类型
    public function delType(){
        $id = input('id');
        $res = db('guest_photo_type')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }


    //获取客片类型列表
    public function getTip(){
        $tips = db('guest_photo_tip')->where('brand_id',$this->brandId)->select();
        return array('code'=>'200','data'=>$tips);
    }

    //新增编辑 客片类型
    public function addTip(){
        $id = input('id');
        $tip_name = input('tip_name');
        db()->startTrans();

        $updateInfo = [
            'tip_name' => $tip_name,
            'brand_id'  => $this->brandId,
            'staff_id'  => session('staff_id'),
            'staff_name'  => session('staffname'),
            'create_time' => date('Y-m-d H:i:s'),
        ];

        try{
            if($id){
                db('guest_photo_tip')->where('id',$id)->update($updateInfo);
            }else{
                $id = db('guest_photo_tip')->insertGetId($updateInfo);
            }
            db()->commit();
            return array('code'=>200,'data'=>$id);

        }catch (\Exception $e){
            db()->rollback();
            return array('code'=>201,'msg'=>'操作客片标签失败，请稍后重试！');
        }

    }

    //删除客片类型
    public function delTip(){
        $id = input('id');
        $res = db('guest_photo_tip')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }



    /*
    *  前台用户上传的客片列表
    */
    public function userPhotoList(){

        if(request()->isAjax()){
            $params = input();
            $params['upload_type'] = 2;//上传类型，1后台上传，2用户前台上传
            $params['title'] = input('title');
            $params['content_text'] = input('content_text');
            $params['type_id']  = input('type_id');

            $data = controller($this->libname,'lib')->photoList($params);
            $count = controller($this->libname,'lib')->photoCount($params);
            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }

        //分类
        $type = db('guest_photo_type')->where(['brand_id'=>$this->brandId])->select();
        //标签
        $tips = db('guest_photo_tip')->where('brand_id',$this->brandId)->select();

        $this->getTopMenu();
        $this->assign([
            'type' => $type,
            'tips' => $tips,
            'headinfo'=>[
                'title'=>'客片管理'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 审核客片
     */
    public function photoCheck(){

        if(request()->isAjax()){

            $params = request()->post();

            $res = controller($this->libname, 'lib')->photoCheck($params);

            return $res;
        }

        $action = input('action');//view为查看，不可操作
        $id = input('id');
        $detail = db('guest_photo')
            ->where('a.id',$id)
            ->alias('a')
            ->join('guest_photo_type type','a.type_id = type.id','left')
            ->field('a.*,type.type_name')
            ->find();

        $detail['content_img'] = json_decode($detail['content_img'],true);

        //标签
        $tip = db('guest_photo_tip')->where(['brand_id'=>$this->brandId])->select();

        //套系
        $package = db('s_package_info')->where(['brand_id'=>$this->brandId,'is_del'=>1])->select();

        $this->assign(['detail'=>$detail,'package'=>$package,'tip'=>$tip,'action'=>$action]);
        return $this->fetch();
    }


    /*
     * 首页展示客片
     */
    public function photoIndex(){

        if(request()->isAjax()){
            $params = input();

            $data = [
                'cover_img'   => $params['cover_img'],
                'content_img' => json_encode($params['content_img']),
                'staff_name'  => session('staffname'),
                'create_time' => date("Y-m-d H:i:s",time()),
                'brand_id'    => $this->brandId,
                'status'      => 4,
            ];

            if($params['id']){
                $res = db('guest_photo')->where('id',$params['id'])->update($data);
            }else{
                $res = db('guest_photo')->insert($data);
            }

            if($res !== false){
                return ['code'=>200,'msg'=>'success'];
            }else{
                return ['code'=>201,'msg'=>'设置失败！'];
            }


        }

        $index = db('guest_photo')->where(['brand_id'=>$this->brandId,'status'=>4])->find();

        $this->assign([
            'index' => $index,
            'detail'=> json_decode($index['content_img'],true),
        ]);

        return $this->fetch();
    }


    /*
     * 获取用户可使用的页面顶部菜单和操作选项的设置
     */
    public function getTopMenu(){
        $menuList = getAuth('auth');
        $type = '/vip/guest_photo_type';

        //$photoType = '/vip/guestphoto/phototypelist';
        //$addType = '/vip/guestphoto/phototypeadd';

        $guest_photo = '/vip/guestphoto/photolist';
        $photo_add   = '/vip/guestphoto/photoadd';
        $photo_edit  = '/vip/guestphoto/photoedit';
        $photo_del   = '/vip/guestphoto/photodel';

        $tip = '/vip/guestphoto/phototiplist';
        $tip_add   = '/vip/guestphoto/phototipadd';
        $tip_edit  = '/vip/guestphoto/phototipedit';
        $tip_del   = '/vip/guestphoto/phototipdel';

        $user_photo  = '/vip/guestphoto/userphotolist';
        $photo_check = '/vip/guestphoto/photocheck';

        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);

            if($currentUrl == $guest_photo){
                if($menuUrl == $photo_add){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$photo_add.'">添加客片</a></div>';
                    $this->assign('add',1);
                }elseif($menuUrl == $photo_edit){
                    $this->assign('edit',1);
                }elseif($menuUrl == $photo_del){
                    $this->assign('del',1);
                }elseif($menuUrl == $photo_add){

                }

            }

            if($currentUrl == $tip){
                if($menuUrl == $tip_add){
                    $topmenu .= '<div class="layui-btn"><a href="'.$guest_photo.'">返回客片列表</a></div></a>';
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$tip_add.'">添加标签</a></div>';
                    $this->assign('add',1);
                }elseif($menuUrl == $tip_edit){
                    $this->assign('edit',1);
                }elseif($menuUrl == $tip_del){
                    $this->assign('del',1);
                }

            }

            if($currentUrl == $tip_add){

                if($menuUrl == $tip){
                    $topmenu .= '<div class="layui-btn"><a href="'.$tip.'">返回标签列表</a></div></a>';
                }
                if($menuUrl == $tip){
                    $topmenu .= '<div class="layui-btn"><a href="'.$guest_photo.'">返回客片列表2</a></div></a>';
                }
            }

            if($currentUrl == $user_photo){
                if($menuUrl == $photo_check){
                    $this->assign('check',1);
                }
            }



//            if($currentUrl == $photoType){
//                if($menuUrl == $addType){
//                    $topmenu .= '<div class="layui-btn"><a id="add_type">添加分类</a></div></a>';
//                }
//
//            }

        }

        $topmenu .= '<div class="layui-btn"><a id="add_type">设置分类</a></div></a>';

        $photo_type_tip = db('c_sysconfig')->where('ckey','photo_type_tip')->value('cvalue');//客片分类下是否展示标签图
        if($photo_type_tip == 1){
            $topmenu .= '<div class="layui-btn"><a href="'.$tip.'">设置标签</a></div></a>';
        }else{
            $topmenu .= '<div class="layui-btn"><a id="add_tip">设置标签</a></div></a>';
        }


        $this->assign('topmenu',$topmenu);
    }



    /*
     *  后台 客片标签列表
     */
    public function photoTipList(){

        if(request()->isAjax()){
            $params = input();

            if(input('name')) $where['tip_name'] = ['like','%'.input('name').'%'];
            $where['brand_id'] = $this->brandId;

            $data = db("guest_photo_tip")
                ->where($where)
                ->order("create_time desc")
                ->select();

            $count = db("guest_photo_tip")
                ->where($where)
                ->order("create_time desc")
                ->count();
            //$data = controller($this->libname,'lib')->photoTipList($params);
            //$count = controller($this->libname,'lib')->photoTipCount($params);
            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }

        $this->getTopMenu();
        $this->assign([
            'headinfo'=>[
                'title'=>'客片标签管理'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 客片标签添加
     * @return [type] [description]
     */
    public function photoTipAdd(){
        if(request()->isAjax()){

            $params = request()->post();

            $data = [

                'img'   => $params['cover_img'],
                'tip_name' => $params['tip_name'],
                'brand_id'  => $this->brandId,
                'staff_id'  => session('staff_id'),
                'staff_name'  => session('staffname'),
                'create_time' => date('Y-m-d H:i:s'),
            ];

            $res = db('guest_photo_tip')->insert($data);
            if($res){
                return ['code'=>200,'msg'=>'添加成功'];
            }else{
                return ['code'=>202,'msg'=>'添加失败'];
            }

        }

        return $this->fetch();
    }

    /*
     * 客片标签修改
     */
    public function photoTipEdit(){
        if(request()->isAjax()){

            $params = request()->post();
            $id = $params['id'];

            $data = [

                'img'   => $params['cover_img'],
                'tip_name' => $params['tip_name'],
                'brand_id'  => $this->brandId,
                'staff_id'  => session('staff_id'),
                'staff_name'  => session('staffname'),
                'create_time' => date('Y-m-d H:i:s'),
            ];

            $info = db('guest_photo_tip')->where('id',$id)->find();
            if(!$info){
                return ['code'=>201,'msg'=>'未找到这个标签，请重新操作'];
            }
            try{
                db()->startTrans();
                db('guest_photo')->where('content_text',$info['tip_name'])->update(['content_text'=>$params['tip_name']]);
                db('guest_photo_tip')->where('id',$id)->update($data);
                db()->commit();
                return ['code'=>200,'msg'=>'添加成功'];
            }catch(\Exception $e){
                db()->rollback();
                return ['code'=>202,'msg'=>'添加失败'.$e->getMessage()];
            }

        }

        $id   = input('id');

        $data = db('guest_photo_tip')->where('id',$id)->find();

        $this->assign('detail',json_decode($data['content_img'],true));
        $this->assign(['id'=>$id,'data'=>$data]);

        return $this->fetch();
    }

    //删除客片标签
    public function photoTipDel(){
        $id = input('id');
        $res = db('guest_photo_tip')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }
}