<?php
/**
 * 页面提示文字
 * User: zhaibaoming
 * Date: 2018/8/15 0015
 * Time: 18:49
 */

namespace app\vip\controller;

use app\index\controller\Base;

class Hinttextoperation extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $limit = input('post.limit', 0);
            $page = input('post.page', 0);
            $limit = isset($limit) ? $limit : 10;
            $page = isset($page) ? ($page - 1) * $limit : 0;
            $testList = hint_text();
            $data = model('McPromptText')->getLimit($this->brandId, $page, $limit);
            foreach ($data as $k => $v) {
                $list['data'][$k] = $v;
                $list['data'][$k]['page'] = $testList[$v['type_id']];
            }
            $list['count'] = model('McPromptText')->getCount($this->brandId);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $this->assign([
                'headinfo'=>[
                    'title'=>'页面提示信息'
                ]
            ]);
        return $this->fetch('Hinttextoperation/index');
    }

    /**
     * 新增
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function add()
    {

        if (request()->isAjax()) {
            $resultData = [
                'code' => 0,
                'msg' => '',
            ];
            $data = [
                'content' => trim(input('content', 0)),
                'type_id' => intval(input('type_id', 0)),
                'brand_id' => $this->brandId,
            ];

            $res = $this->checkData($data);
            if ($res['code'] != 200) {
                $resultData['code'] = $res['code'];
                $resultData['msg'] = $res['msg'];
                return json($resultData);
            }
            $res = model('McPromptText')->getWhereData($data['type_id'], $this->brandId);
            if ($res) {
                $resultData['code'] = 301;
                $resultData['msg'] = '当前页面已经有提示文字';
                return json($resultData);
            }

            // 处理数据
            $res = model('vip/McPromptText')->addData($data);
            if ($res) {
                $resultData = ['code' => 200];
            } else {
                $resultData = ['code' => 401, 'msg' => '添加失败'];
            }
            return json($resultData);
        }

        $this->assign([
            'headinfo' => [
                'title' => '添加文字'
            ],
        ]);
        $this->assign('testList', hint_text());
        return $this->fetch('Hinttextoperation/add');
    }


    private function checkData($param, $type = 0, $id = 0)
    {
        $resultData = [
            'code' => 0,
            'msg' => '',
        ];
        if (empty($param['content'])) {
            $resultData['code'] = 601;
            $resultData['msg'] = '内容不能为空';
            return $resultData;
        }
        if (mb_strlen($param['content'], 'utf-8') > 300) {
            $resultData['code'] = 603;
            $resultData['msg'] = '内容不能大于300个字';
            return $resultData;
        }
        if (empty($param['type_id'])) {
            $resultData['code'] = 604;
            $resultData['msg'] = '请选择所属页面';
            return $resultData;
        }
        if ($type && $id < 1) {
            $resultData['code'] = 605;
            $resultData['msg'] = '参数错误_2';
            return $resultData;
        }
        $resultData['code'] = 200;
        return $resultData;
    }

    public function del()
    {
        $id = intval(request()->post('id'));
        $reaultData = [
            'code' => 0,
            'msg' => '',
        ];
        if (empty($id)) {
            $reaultData['code'] = 301;
            $reaultData['msg'] = '参数错误';
            return json($reaultData);
        }
        $res = model('McPromptText')->del($id, $this->brandId);
        if ($res) {
            $reaultData['code'] = 200;
            return json($reaultData);
        }

        $reaultData['code'] = 401;
        $reaultData['msg'] = '操作失败';
        return json($reaultData);
    }

    /**
     * 修改
     * @return mixed|\think\response\Json|void
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function edit()
    {
        if (!request()->isAjax()) {
            $id = intval(input('get.id', 0));
            if (empty($id)) {
                $this->error('参数错误');
            }
            $data = model('McPromptText')->getIdData($id, $this->brandId);
            $this->assign('data', $data);
            $this->assign('testList', hint_text());
            return $this->fetch('Hinttextoperation/edit');
        }

        return $this->editPost();
    }

    private function editPost()
    {
        $id = intval(input('post.id', 0));
        $data = [
            'content' => trim(input('post.content', 0)),
            'type_id' => intval(input('post.type_id', 0)),
        ];
        $res = $this->checkData($data, 1, $id);
        if ($res['code'] != 200) {
            $resultData['code'] = $res['code'];
            $resultData['msg'] = $res['msg'];
            return json($resultData);
        }
        $res = model('McPromptText')->editData($data, $id, $this->brandId);
        if ($res === false) {
            $resultData = ['code' => 701, 'msg' => '修改失败'];
        } else {
            $resultData = ['code' => 200];
        }
        return json($resultData);
    }

}