<?php
/**
 * 活动控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月22日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Cache;
use think\Session;
class Index extends Base {
    /**
     * 方法描述: 获取列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(Session::get('brandid') == 0){
            $this->redirect('systemsetup/setbrand');
        }
        // 查询的条件
        $today    = date('Y-m-d',time());
        $tomorrow = date('Y-m-d',time()+86400);
        // 获取今天投诉和建议的数据
        $todayCP = $this->getTodayPC();
        // 今天总建议量
        $todayProposal  = 0;
        // 今天总投诉量
        $todayComplaint = 0;
        // 未处理投诉的量
        $todayNoCheckComplaint = 0;
        // 未处理的建议量
        $todayNoCheckProposal = 0;
        if($todayCP){
            foreach($todayCP as $k=>$v){
                if($v['status']==1){
                    if($v['typeid']==1){
                        $todayComplaint++;
                    }else{
                        $todayProposal++;
                    }
                }else{
                    // 未处理的
                    if($v['typeid']==1){
                        $todayComplaint++;
                        $todayNoCheckComplaint++;
                    }else{
                        $todayProposal++;
                        $todayNoCheckProposal++;             
                    }
                }
            }  
        }
        // 今日 建议和投诉整理后的数据
        $nTodayPC = [
            'complaint'=>[
                'total'  => $todayComplaint,
                'check'  => $todayComplaint-$todayNoCheckComplaint,
                'nocheck'=> $todayNoCheckComplaint,
            ],
            'proposal'=>[
                'total'  => $todayProposal,
                'check'  => $todayProposal-$todayNoCheckProposal,
                'nocheck'=> $todayNoCheckProposal,
            ], 
        ];
        // 最近7天的投诉和建议的数据集
        $weekPC = $this->getWeekPC();
        
        // 获取今天的推荐数据
        $todayRecommentList = $this->getTodayRecommendList();
        // 今天推荐总建议量
        $todayRecomment  = 0;
        // 未处理推荐的量
        $todayNoCheckRecomment = 0;
        if($todayRecommentList){
            foreach($todayRecommentList as $k=>$v){
                $todayRecomment++;
                if($v['status']==3){
                    $todayNoCheckRecomment++;
                }
            }
        }

        // 今日整理后的推荐数据
        $ntodayRecomment = [
                'total'  => $todayRecomment,
                'check'  => $todayRecomment-$todayNoCheckRecomment,
                'nocheck'=> $todayNoCheckRecomment,
        ];
        
        // 获取今天的活动报名的数据
        $todaySignUpList = $this->getTodaySignUpList();
        // 今天推荐总建议量
        $todaySignUp  = 0;
        // 未处理推荐的量
        $todayNoCheckSignUp = 0;
        if($todaySignUpList){
            foreach($todaySignUpList as $k=>$v){
                $todaySignUp++;
                if($v['status']!=1){
                    $todayNoCheckSignUp++;
                }
            }
        }
        // 今日整理后的活动报名数据
        $ntodaySignUp = [
            'total'  => $todaySignUp,
            'check'  => $todaySignUp-$todayNoCheckSignUp,
            'nocheck'=> $todayNoCheckSignUp,
        ];
        

        // 领取的任务总数
        $receiveTask = $this->getUserTaskCount();
        // 做完的任务数量
        $doneTask    = $this->getUserTaskCount(['done'=>true]);
        // 一次没做的任务数量
        $noDoTask    = $this->getUserTaskCount(['nodo'=>true]);
        // 执行中的任务总数
        $doTask       = $receiveTask - $doneTask - $noDoTask;

        //echo 'receive='.$receiveTask.'doneTask='.$doneTask.'noD='.$noDoTask;
        $data = [
            'userTotal'          => $this->getUserCount()?:0,  // 用户总数
            'todayUserTotal'     => $this->getTodayUserCount()?:0, // 新会员数量
            'todayLandTotal'     => $this->getTodayLandUserCount()?:0, // 获取今天登陆会员数量
            'todaySignTotal'     => $this->getTodaySignCount()?:0, // 今天签到的用户总数
            'todayDoTaskUserTotal' => $this->getTodayDoTaskCount()?:0, // 今日执行任务用户总数
            'receiveTask'     => $receiveTask?:0, // 领取的任务总数
            'doneTask'        => $doneTask?:0, // 做完的任务数量
            'noDoTask'        => $noDoTask?:0, // 一次没做的任务数量
            'doTask'          => $doTask?:0, // 执行中的任务总数
            'todayDone'       => $this->getUserTaskCount(['todaydone'=>true])?:0, // 今天完成的任务数量
            'nobodyTaskTotal' => $this->getNobodyTasks()?:0, // 每人领取的任务总数
            'weekDoTask'      => implode(',',$this->getWeekUserDoTask()), // 一周的做任务用的数量
            'todayPC'         => $nTodayPC?:0, //今日投诉和建议的未处理和已处理数据 
            'weekProposal'    => implode(',',$weekPC['proposal']),  // 这周的建议总数据
            'weekComplaint'   => implode(',',$weekPC['complaint']),  // 这周的投诉总数据
            'todayRecommend'  => $ntodayRecomment?:0, // 当天推荐的数据
            'weekRecommend'   => implode(',',$this->getWeekRecommendList()),      // 一周推荐数据
            'todaySignUp'     => $ntodaySignUp?:0,
            'weekSignUp'      => implode(',',$this->getWeekSignUpList()),      // 一周推荐数据
        ];
        $this->assign([
            'headinfo'=>[
                'title'=>'后台管理中心-首页'
            ]
        ]);
        // print_r($data['todayfeed']);
        $this->assign('data',$data);
        return $this->fetch();
    }

    public  function watermark(){
        $bg_img='public/img/modal4.jpg';

        $accessTokenApi=sx_call('5a60436d631a4',array('brandclass_id'=>2));
        if($accessTokenApi['code']==200){
            $accessTokenData=$accessTokenApi['data'];
        }
        $openid='o3mGr0gcYxhVjF2ibkHfaqHcSVIk';
        $urlInfo = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=".$accessTokenData['access_token']."&openid=".$openid."&lang=zh_CN";
        $res = http_request($urlInfo,'GET');
        $userInfo = json_decode($res['response'],true);

print_r($userInfo);die;
        $head_img=$userInfo['head_img'];
        $nickname='小宁宁';
        $qrcode='public/img/ewm.jpg';
        $site=[];
        $openid="ll23423532";
        $a=watermark($bg_img,$head_img,$nickname,$qrcode,$site,$openid);
print_r($a);die;

    }


    /**
     * 方法描述: 获取用户总数
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getUserCount(){
        return controller('users','lib')->getNewCount();
    }
    
    
    /**
     * 方法描述: 获取今天用户总数
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodayUserCount(){
        $c['today'] = 1;
        return controller('users','lib')->getNewCount($c);
    } 
    
    /**
     * 方法描述: 获取今天用户登陆总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodayLandUserCount($c){
        $c['todayland'] = true;
        return controller('users','lib')->getNewCount($c);
    }
 
    /**
     * 方法描述: 获取今天推荐的人总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodayRecommendCount($c){
        return controller('recommends','lib')->getTodayCount($c);
    }
    
    /**
     * 方法描述: 获取今天推荐的人总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodayRecommendList($c){
        return controller('recommends','lib')->getTodayList($c);
    }

    /**
     * 方法描述: 获取一周推荐的人总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getWeekRecommendList($c){
        return controller('recommends','lib')->getWeekList($c);
    }

    /**
     * 方法描述: 获取今天报名的人总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodaySignUpList($c){
        return controller('activitysignup','lib')->getTodayList($c);
    }
    
    
    /**
     * 方法描述: 获取一周报名的人总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getWeekSignUpList($c){
        return controller('activitysignup','lib')->getWeekList($c);
    }
 
    
    /**
     * 方法描述: 今日签到总人数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodaySignCount($c){
        return controller('sign','lib')->getTodayCount($c);
    }
    
    /**
     * 方法描述: 获取今天执行任务的人员总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodayDoTaskCount($c){
        return controller('tasks','lib')->getTodayDoTaskCount($c);
    }

    /**
     * 方法描述: 获取用户已领取的任务总数
     * @param  array $c 数组，查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getUserTaskCount($c){
        return controller('tasks','lib')->getUserTaskCount($c);
    }

    
    /**
     * 方法描述: 获取用户一周执行任务的状况
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getWeekUserDoTask($c){
        return controller('tasks','lib')->getWeekList($c);
    }
    
    /**
     * 方法描述     获取所有没人任取的任务总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getNobodyTasks(){
        $c['nobody'] = true;
        return controller('tasks','lib')->getCount($c);
    }

    /**
     * 方法描述     获取今天投诉建议的总数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getTodayPC($c){
        return controller('commend','lib')->getTodayList($c);
    }
    
    /**
     * 方法描述     最近一周投诉和建议的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getWeekPC($c){
        return controller('commend','lib')->getWeekList($c);
    }
    
    /**
     * 方法描述     生成最近七天的日期
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    protected function getWeekDay(){
        
        for($i = 6; $i >=0 ; $i--) {
            $days[date("Y-m-d", time() - 86400 * $i)] = 0;
        }
        return $days;
    }
    
    /**
     * 方法描述     获取投诉建议
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function getMessage () {
        $w = [];
        if (!$this->root) {
            $w['b.brandid'] = $this->brandId;
        }
        $messData = db('message')
            ->alias('a')
            ->join('user_commend b','a.com_id = b.id')
            ->join('m_users c ','b.userid = c.id')
            ->where($w)
            ->select();
        $mesCount = db('message')->where('mes_status','=',0)->count();
        Session::set('num',$mesCount);
        $arr = array('code'=>1,'msg'=>'获取信息成功','data'=>$messData,'num'=>$mesCount);
        if ($arr != null) {
            return json($arr);
        } else {
            $arr = array('msg'=>'获取消息信息失败');
            return json();
        }

    }
    //  标记已读
    public function readMessage(){
        $id = input('post.id');
        $mes_time = date('Y-m-d H:i:s');
        $datas = array(
            'mes_status'=>1,
            'mes_time'=>$mes_time
        );
        $res = db('message')->where('m_id','=',$id)->update($datas);
        if ($res) {
            $arr = array('code'=>1,'msg'=>'阅读成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'操作失败');
            return json($arr);
        }
    }

    
    /**
     * 方法描述  当用户一个权限都没有的时候定向到此页
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月17日 上午11:14:01
     */
    public function noPermission(){
       $isdug = (int)input('get.isdebug');
       if($isdug){
            echo '当前用户的数据：';
            print_r(Session::get());
            echo '可使用的菜单：';
            print_r(getAuth());
       }
	   $this->assign('headinfo',array('title'=>'您没有任何权限'));
       return $this->fetch();
    }

    /**
     * 清除模版缓存 不删除 temp目录
     */
    public function clear_cache()
    {
        $my_files = (array)glob(TEMP_PATH . '/*.php');
        array_map(
            function ($v) {
                if (file_exists($v))
                    @unlink($v);
            }, $my_files
        );

        //@unlink(ROOT_PATH . 'public/login.html');//登录缓存文件

        //清除session
        //session('position_list', null);

        //清除菜单缓存
        cache('VIP_child_menuAll',null);
        cache('VIP_child_menu_*',null);
        //前台缓存
        cache('all_brand_class_list',null);
        //清除前台数据缓存
        cache('p_shop_list'.session('brandid'),null);//事业部下 根据省分类的店面
        cache('shop_list_'.session('brandid'),null); //事业部下的店
        cache('p_shop_list*',null);//事业部下 根据省分类的店面
        cache('shop_list_*',null);
        cache('packageInfo_*',null);
        cache('mc_interface*',null);

        //linux下没有缓存文件会报错，清除前必须判断文件存不存在
        // array_map( 'unlink', glob(TEMP_PATH.'*.php' ) );
    }

    /*
     * 获取模块下级菜单
     */
    public function getNextMenu(){
        $menu_code = input('menu_code');

        if(!$menu_code)  return json(['code'=>201,'data'=>[],'msg'=>'没有接收到菜单code']);

        $nextList = getNextMenu($menu_code);

        if($nextList){
            return json(['code'=>200,'data'=>$nextList]);
        }else{
            return json(['code'=>202,'data'=>[],'msg'=>'没有下级菜单']);
        }
    }

}