<?php
namespace app\vip\controller;

use app\front\controller\BaseFront;
use app\index\controller\Base;
use think\Controller;
use think\Paginator;

class Memberq extends Base {
    protected $imgWH   = [100,100];
    /**
     * 用户权益列表页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function index () {
        $memData = db('membereq')->select();
        //dump($cardData);
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit')?request()->get('limit'):10,
                'page'  => request()->get('page')?request()->get('page'):1,
            ];
            $w = [];
            if (!$this->root) {
               if(!$this->brandId){
                   return false;
               }
               // $w['m.brandid'] = $this->brandId;
            }
            $data['data']  = db('membereq')
                        ->field('m.id,m.eq_type,m.eq_count,m.eq_card_type,m.eq_img,m.create_time,m.brandid,v.name')
                        ->alias('m')
                        ->join('user_level v','v.id=m.eq_card_type')
                        ->where($w)
                        ->page($c['page'],$c['limit'])
                        ->select();
            unset($c['limit'],$c['page']);
            $data['count'] = db('membereq')
                        ->alias('m')
                        ->join('user_level v','v.id=m.eq_card_type')
                        ->where($w)
                        ->count('m.id');
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);

        }
        controller('level','controller')->getTopMenu();
        $this->assign('data',$memData);
        $this->assign([
            'headinfo'=>[
                'title'=>'会员权益管理'
            ]
        ]);
        return $this->fetch('memberQ/index');
    }
    /**
     * 用户权益添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function add () {
//        $w = [];
//        if (!$this->root) {
//            if(!$this->brandId){
//                return false;
//            }
//            $w['brandid'] = $this->brandId;
//        }
        $data = db('user_level')
            //->where($w)
            ->select();
        if(request()->isAjax()){
            // 数据信息
            $acdata = request()->post();
            // 获取上传的图片信息
            $fileimg = request()->file("img");
            if($fileimg){
                $img  = saveImg($fileimg,$this->imgWH[0],$this->imgWH[1]);
            }
            if($acdata['card_type'] == "1"){    //权益类别是否是生日礼
                $res = db('membereq')->where('card_type',1)->find();
                if($res){
                    return json(['status'=>0,'msg'=>"添加失败，生日礼已存在"]);
                }
                $acdata['card_type_name'] = "生日礼";
            }
            if($acdata['couponids']){
                $couponids = implode(',',$acdata['couponids']);
            }
            // 处理数据
            $data = [
                'id'            => $acdata['id'],
                'eq_type'       => $acdata['eq_type'],
                'eq_count'      => $acdata['eq_count'],
                'eq_card_type'  => $acdata['eq_card_type'],
                'card_type'     => $acdata['card_type'],
                'card_type_name'=> $acdata['card_type_name'],
                'create_time'   => date('Y-m-d,H:i:s',time()),
                'eq_img'        => $img,
                'brandid'       => $this->brandId,
                'couponids'     => $couponids
            ];
            $res = db('membereq')->insert($data);
            if($res){
                action_log($data); //写入日志
                cache("brand_bereq",null);
                $this->msg = ['status'=>1,'msg'=>'会员权益添加成功'];
            }else{
                $this->msg = ['status'=>0,'msg'=>'添加失败'];
            }
            return json($this->msg);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'添加会员权益信息'
            ],
             'imgsize'=>$this->imgWH
        ]);
        controller('level','controller')->getTopMenu();
        $this->assign('coupons',controller('coupon','lib')->getSmallList());
        $this->assign('data',$data);
        return $this->fetch('memberQ/add');
    }
    /**
     * 用户权益修改页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function edit () {
        $id = input('get.id');
        if(IS_POST && request()->isAjax()){
            // 数据信息
            $acdata = request()->post();
            if($acdata['card_type'] == "1"){
                $acdata['card_type_name'] = "生日礼";
                $res = db('membereq')->where('card_type',1)->find();
                if($res['id'] != $id){
                    return json(['status'=>0,'msg'=>"添加失败，生日礼已存在"]);
                }
            }
            $d = [
                'eq_type'      => $acdata['eq_type'],
                'eq_count'     => $acdata['eq_count'],
                'eq_card_type' => (int)$acdata['eq_card_type'],
                'card_type'     => $acdata['card_type'],
                'card_type_name'=> $acdata['card_type_name'],
            ];
            // 获取上传的图片信息
            $fileimg = request()->file("img");
            if($fileimg){
                $img  = saveImg($fileimg,$this->imgWH[0],$this->imgWH[1]);
                $d['eq_img'] = $img;
            }
            //$w = ['brandid'=>$this->brandId,'id'=>$id];
            $w = ['id'=>$id];
            $hasDada = db('membereq')->where($w)->find();
            if(!$hasDada){
                return  json(['status'=>0,'msg'=>'无法获取您要修改的数据']);
            }
            $res = db('membereq')->where($w)->update($d);
            if($res!==false){
                action_log($d); //写日志
                cache("brand_bereq",null);
                $this->msg = ['status'=>1,'msg'=>'会员权益修改成功'];
            }else{
                $this->msg = ['status'=>0,'msg'=>'修改失败'];
            }
            return json($this->msg);


        }else{
         
            $id = (int)input('get.id');
            if($id){
                //$data   = db('membereq')->where(['id'=>$id,'brandid'=>$this->brandId])->find();
                $data   = db('membereq')->where(['id'=>$id])->find();
                if(!$data){
                    return $this->error('无法获取您要修改的数据！');
                }
                //$levels = db('user_level')->where(['brandid'=>$this->brandId])->select();
                $levels = db('user_level')->select();
                $this->assign([
                    'data'   => $data,
                    'levels' => $levels,
                ]);
                $this->assign([
                    'headinfo'=>[
                        'title'=>'修改会员权益信息'
                    ],
                    'imgsize'=>$this->imgWH
                ]);
                $this->assign('coupons',controller('coupon','lib')->getSmallList());
                controller('level','controller')->getTopMenu();
                return $this->fetch('memberQ/edit');
            }else{
                return $this->error('无法获取您要修改的数据！');
            }
        }

    }
    /**
     * 用户权益删除
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function del () {
        $id = input('post.id');
        $arr = db('membereq')->where('id',$id)->find();
        $res = db('membereq')->where('id','=',$id)->delete();
        if ($res) {
            action_log($arr);       //写日志
            cache("brand_bereq",null);
            return $this->msg = ['status'=>1,'msg'=>'会员权益刪除成功'];
        }else{
            return $this->msg = ['status'=>0,'msg'=>'刪除失败'];
        }
    }
}