<?php
/**
 * vip设定
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017-10-27 $
 */
namespace app\vip\controller;

use app\index\controller\Base;
use think\Session;
use think\Request;

class Note extends Base {
	protected $libname = "note";
	/**
	 * 短信管理
	 * @return [type] [description]
	 * @author Zhaojiepeng<[<zhaojiepeng@suxuantech.cn>]>
	 */
	public function index(){
		if(request()->isAjax()){
			$name = input('name');
			$phone = input('phone');
	    	$c=[
	            	'limit' => (int)request()->get('limit'),
	                'page'  => (int)request()->get('page'),
	                'name'  => $name,
	                'phone' => $phone
	            ];
	    	$data['data']  = controller($this->libname,'lib')->getList($c);
	    	$data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
    	}
    	$this->getTopMenu();
		return $this->fetch();
	}
	/**
     * 删除数据
     * @return [type] [description]
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function del(){
        $id = input('id');
        $data = controller($this->libname,'lib')->del($id);
        if($data){
            return json(['code'=>200,'msg'=>'删除成功']);
        }else{
            return json(['code'=>202,'msg'=>'删除失败']);
        }
    }
    /** 
     * 短信管理 添加短信内容
     * @return   [<description>]
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function DreamSend(){
    	$kr_send = KR_SEND;	//客人发送短信内容
    	$kf_send = KF_SEND;  //客服发送短信内容
    	if(request()->isAjax()){    		
        	$kr_sendContent = input('kr_send');
        	$kf_sendContent = input('kf_send');
        	$kr_sendData = controller('systemsetup','lib')->GetOneData($kr_send);
        	$kf_sendData = controller('systemsetup','lib')->GetOneData($kf_send);
        	if(!$kr_sendData && !$kf_sendData){
        		$data[] = ['ckey'=>$kr_send,'cvalue'=>$kr_sendContent];
        		$data[] = ['ckey'=>$kf_send,'cvalue'=>$kf_sendContent];
        		$arr = controller('systemsetup','lib')->AddAllData($data);
        	}elseif($kr_sendData && $kf_sendData){
				$data[] = ['ckey'=>$kr_send,'cvalue'=>$kr_sendContent];
        		$data[] = ['ckey'=>$kf_send,'cvalue'=>$kf_sendContent];
				$arr = controller('systemsetup','lib')->UpdateAllData($data);
        	}elseif(!$kf_sendData && $kr_sendData){
        		db()->startTrans();
        		try{
        			$kfdata = ['cvalue'=>$kf_sendContent];
        			$kfres = controller('systemsetup','lib')->UpdateData($kf_send,$kfdata);
        			if(!$kfres){
        				db()->rollback();
        				return json(['code'=>202,'msg'=>'更新失败']);
        			}
        			$krdata = ['ckey'=>$kr_send,'cvalue'=>$kr_sendContent];
        			$krres = controller('systemsetup','lib')->AddData($krdata);
        			if(!$krres){
        				db()->rollback();
        				return json(['code'=>202,'msg'=>'更新失败']);
        			}
        			db()->commit();
        			return json(['code'=>200,'msg'=>'更新成功']);
        		}
        		catch(\Exception $e){
        			db()->rollback();
        			return json(['code'=>202,'msg'=>'更新失败']);
        		}
        	}else{
				db()->startTrans();
        		try{
        			$krdata = ['cvalue'=>$kr_sendContent];
        			$krres = controller('systemsetup','lib')->UpdateData($kr_send,$krdata);
        			if(!$krres){
        				db()->rollback();
        				return json(['code'=>202,'msg'=>'更新失败']);
        			}
        			$kfdata = ['ckey'=>$kf_send,'cvalue'=>$kf_sendContent];
        			$kfres = controller('systemsetup','lib')->AddData($kfdata);
        			if(!$kfres){
        				db()->rollback();
        				return json(['code'=>202,'msg'=>'更新失败']);
        			}
        			db()->commit();
        			return json(['code'=>200,'msg'=>'更新成功']);
        		}
        		catch(\Exception $e){
        			db()->rollback();
        			return json(['code'=>202,'msg'=>'更新失败']);
        		}
        	}
        	if($arr){
        		return json(['code'=>200,'msg'=>'更新成功']);
        	}else{
        		return json(['code'=>202,'msg'=>'更新失败']);
        	}
        }else{
            $kr_sendData = controller('systemsetup','lib')->GetOneData($kr_send);
        	$kf_sendData = controller('systemsetup','lib')->GetOneData($kf_send);
            $this->assign('kr_senddata',$kr_sendData);
            $this->assign('kf_senddata',$kf_sendData);
            $this->getTopMenu();
            return $this->fetch();
        }
    }

    /**
     * 短信模板
     * @return [type] [description]
     */
    public function noteTemplate(){
        $sms = SMS_TEMPLATE;//短信模板

        if(request()->isAjax()){
            $smId = input('smId');
            
            $sms_Data = controller('systemsetup','lib')->GetOneData($sms);

            if($sms_Data){
                $res = controller('systemsetup','lib')->UpdateData($sms,['cvalue'=>$smId]);
            }else{
                $param = ['ckey'=>$sms,'cvalue'=>$smId];
                $res = controller('systemsetup','lib')->AddData($param);
            }
            if($res){
                return json(['code'=>200,'msg'=>'设置成功']);
            }else{
                return json(['code'=>202,'msg'=>'设置失败']);
            }

        }

        $data = controller('note','lib')->getSMSModel();//mc短信模板配置

        $smsData = controller('systemsetup','lib')->GetOneData($sms);
  
        $this->assign('data',$data);
        $this->assign('smsData',$smsData);
        return $this->fetch();
    }

    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    public function getTopMenu(){
        $menuList = getAuth();
        $index     = '/vip/note/index';
        $del       = '/vip/note/del';
        $dreamsend = '/vip/note/dreamsend';
        $noteTemplate = '/vip/note/notetemplate';


        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl==$index){
            	$class = '';
                if($index == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"><a href="'.$index.'">短信列表</a></div></a>';
            }else if($menuUrl==$del){
                $this->assign('del',1);
            }else if($menuUrl==$dreamsend){
                $class = '';
                if($dreamsend == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"><a href="'.$dreamsend.'">短信内容</a></div></a>';
            }else if($menuUrl==$noteTemplate){
                $class = '';
                if($noteTemplate == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"><a href="'.$noteTemplate.'">短信模板设定</a></div></a>';
            }
        }
        $this->assign('topmenu',$topmenu);
    }

}