<?php
/**
 * 套系订单管理
 * User: 李龙
 * Date: 2018/10/16
 * Time: 
 */

namespace app\vip\controller;

use app\index\controller\Base;
use think\Session;
use think\Request;

class Packageorder extends Base
{
    public function __construct(){
        parent::__construct();
        $this->assign('controller', request()->controller());
    }

    // 查看所有 套系订单列表
    public function index(){
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');
            
            $param['page']    = isset($page) ? ($page - 1) * $limit : 0;
            $param['limit']   = isset($limit) ? $limit : 10;
            $param['brand_id']= (int)$this->brandId;
            $data = controller('Packageorder', 'model')->getLimit($param);
            $list['data'] = $data;
            $list['count'] = controller('Packageorder', 'model')->getCount($param);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }

        $this->getTopMenu();
        $headinfo['title'] = '订单列表';
        $this->assign('headinfo', $headinfo);

        $id = (int)input('get.id');
        // var_dump($id);
        // exit;
        $this->assign('id', $id);
        return $this->fetch();
    }

    /**
     * 查询 某 套系订单
     * 
     * @param  套系id
     * @return view
     * @author lilong
     */
    public function getPackorderList(){
        $pid = (int)input('get.id');
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');

            $param['page']    = isset($page) ? ($page - 1) * $limit : 0;
            $param['limit']   = isset($limit) ? $limit : 10;
            $param['brand_id']= (int)$this->brandId;
            $param['pid']     = $pid;
            // var_dump($param);
            // exit;
            $data = controller('Packageorder', 'model')->getLimit($param);
            $list['data'] = $data;
            $list['count'] = controller('Packageorder', 'model')->getCount($param);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }

        $this->getTopMenu();
        $headinfo['title'] = '订单列表';
        $this->assign('headinfo', $headinfo);

        $id = (int)input('get.id');
        // var_dump($id);
        // exit;
        $this->assign('id', $id);
        return $this->fetch('orderindex');
    }

    /**
     * 编辑套系内订单 页面
     * 
     * @param  
     * @return view
     * @author lilong
     */
    public function editpackageorder(){
        /*
        $auth = check_right('menu1539864488');
        if (!$auth) {
            $returnData['code']= 100;
            $returnData['msg'] = '您没有相关权限，请确认。';
            return json($returnData);
        }
        */

        $id = (int)input('get.id');
        // 订单信息
        $param['id'] = $id;
        $order = controller('Packageorder', 'model')->getOnePackageorder($param);
        $this->assign('order', $order);

        return $this->fetch();
    }

    /**
     * 编辑套系内订单 方法
     * 
     * @param  
     * @return view
     * @author lilong
     */
    public function editPackageorderAction(){
        /*
        $auth = check_right('menu1539864488');
        if (!$auth) {
            $returnData['code']= 100;
            $returnData['msg'] = '您没有相关权限，请确认。';
            return json($returnData);
        }
        */

        $data = input('post.');
        $tel = trim($data['user_tel']);
        $res = is_mobile($tel);

        if ($res === false) {
            $returnData['code']= 101;
            $returnData['msg'] = '手机号格式不正确，请确认。';
            return json($returnData);
        }

        $param['id']          = (int)$data['id'];
        $param['user_name']   = trim($data['user_name']);
        $param['user_tel']    = $tel;
        $param['user_wechat'] = trim($data['user_wechat']);
        $param['user_address']= trim($data['user_address']);
        // 获取原数据
        $old = controller('Packageorder', 'model')->getOnePackageorder($param);

        $res = controller('Packageorder', 'model')->editPackageorder($param);

        if ($res === false) {
            $returnData['code']= 101;
            $returnData['msg'] = '编辑套系失败。';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '编辑套系成功。';
            action_log($param,$old,0,session('staff_id'),session('staffname'));
        }
        return json($returnData);
    }
    
    /**
     * 删除套系
     * 
     * @param  套系id
     * @return json
     * @author lilong
     */
    public function delPackageorder(){   
        /*
        $auth = check_right('menu1539864569');
        if (!$auth) {
            $returnData['code']= 100;
            $returnData['msg'] = '您没有相关权限，请确认。';
            return json($returnData);
        }
        */
        $id = intval(request()->post('id'));
        
        if (empty($id)) {
            $returnData['code']= 101;
            $returnData['msg'] = '参数错误';
            return json($returnData);
        }
        $param['id'] = $id;
        // 获取原数据
        $old = controller('Packageorder', 'model')->getOnePackageorder($param);

        $res = controller('Packageorder', 'model')->delPackageorder($param);

        if ($res === false) {
            $returnData['code']= 102;
            $returnData['msg'] = '操作失败';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '操作成功';
            action_log($param,$old,0,session('staff_id'),session('staffname'));
        }
        
        return json($returnData);
    }

    /*
     * 退款
     */
    public function refund(){
        $payment_order_sn = input('payment_order_sn');
        $money = input('money');

        if(!$payment_order_sn){
            return ['code'=>201,'msg'=>'未获取到订单数据，请稍后重试'];
        }

        //套系订单详情
        $orderInfo = db('s_package_order')->where('payment_order_sn',$payment_order_sn)->find();

        //支付成功了的支付流水号
        $serialInfo = db('s_order_serial')->where("FIND_IN_SET(order_number,'$payment_order_sn')")->where('pay_status',2)->find();
        $order_no = $serialInfo['serial_number'];
        if(!$order_no){
            return ['code'=>202,'msg'=>'没有找到相应支付信息！'];
        }

        //$order_no = '156076162564230';
        //$money = 1;

        $res = sx_call('5ccfccc905078',['order_no'=>$order_no,'refund_fee' => $money*100]);
        if($res['code'] == 200){
            db()->startTrans();
            try{

                $addData = [
                    'serial_sn'  => $serialInfo['serial_number'],
                    'refund_fee' => $money,
                    'vip_order_sn' => $payment_order_sn,
                    'erp_order_sn' => $orderInfo,
                    'user_id'      => $orderInfo['user_id'],
                    'staff_name'   => session('staffname'),
                    'refund_time'  => date('Y-m-d H:i:s'),
                ];
                db('s_package_order_refund')->insert($addData);
                db('s_package_order')->where('payment_order_sn',$payment_order_sn)->update(['refund_fee'=>$orderInfo['refund_fee']+$money]);
                db()->commit();
                return ['code'=>200,'msg'=>'success'];
            }catch (\Exception $e){
                db()->rollback();
                return ['code'=>204,'msg'=>'退款申请已成功，系统记录数据出错'.$e->getMessage()];
            }


        }else{
            return $res;
        }

    }

    /*
     * 套系订单相关设置（默认开单店 开店人）
     */
    public function orderDefault(){

        if(request()->isAjax()){
            $data = [
                'shop_code' => input('shop_code'),
                'shop_name' => input('shop_name'),
                'staff_id' => input('staff_id'),
                'staff_sn' => input('staff_sn'),
                'staff_name' => input('staff_name'),
            ];

            $xdwk_url = trim(input('xdwk_url'));
            if($xdwk_url && strpos($xdwk_url,'http://') === false){
                return ['code'=>201,'msg'=>'先睹为快报价地址请以【http://】开头！'];
            }

            $xdwk = [
                'url' => $xdwk_url,
            ];

            db()->startTrans();

            try{

                //修改订单默认
                $exist = db('c_sysconfig')->where('ckey','order_default_data')->find();
                if($exist){
                    db('c_sysconfig')->where('ckey','order_default_data')->update(['cvalue'=>json_encode($data)]);
                }else{
                    db('c_sysconfig')->insert(['ckey'=>'order_default_data','cvalue'=>json_encode($data)]);
                }

                //修改先睹为快报价地址
                $xdwk_exist = db('c_sysconfig')->where('ckey','xdwk_crm_url')->find();
                if($xdwk_exist){
                    db('c_sysconfig')->where('ckey','xdwk_crm_url')->update(['cvalue'=>json_encode($xdwk)]);
                }else{
                    db('c_sysconfig')->insert(['ckey'=>'xdwk_crm_url','cvalue'=>json_encode($xdwk)]);
                }

                db()->commit();
                return ['code'=>200,'msg'=>'success'];
            }catch (\Exception $e){
                db()->rollback();
                return ['code'=>201,'msg'=>'操作失败！'];

            }

        }


        $default = db('c_sysconfig')->where('ckey','order_default_data')->value('cvalue');
        $detail = json_decode($default,true);
        //print_r($detail);

        $xdwkInfo = db('c_sysconfig')->where('ckey','xdwk_crm_url')->value('cvalue');
        $xdwk = json_decode($xdwkInfo,true);

        //店面选择
        $shop = sx_call('5a005e0038270', ['brandclass_id'=>session('brand_id')], 'sx_mc');
        if($shop['code'] == 200){
            $shopList = $shop['data'];
        }

        $shop_code = $detail['shop_code'] ? $detail['shop_code'] : $shopList[0]['shop_code'];
        //默认员工
        if($shop_code){

            $staff = sx_call('5a01766b4a3dd',['shop_code'=>$shop_code],'sx_mc');
            if($staff['code'] == 200){
                $staffList = $staff['data'];
            }
        }
        //print_r($staffList);die;

        $this->assign([
            'detail'    => $detail,
            'xdwk'      => $xdwk,
            'shopList'  => $shopList,
            'staffList' => $staffList,
        ]);
        return $this->fetch();
    }

    public function getStaff(){
        $shop_code = input('shop_code');
        if(!$shop_code){
            return ['code'=>201,'msg'=>'未获取到店面信息'];
        }

        $staff = sx_call('5a01766b4a3dd',['shop_code'=>$shop_code],'sx_mc');
        return $staff;

    }

    /*
     * 通过先睹为快报名的客资信息
     */
    public function customerList(){
        if (request()->isAjax()) {
            $limit = input('limit') ? input('limit') : 10;
            $page = input('page') ? input('page') : 1;

            //消费类型
            $consultation_type = input('consultation_type');
            $name = input('name');
            $phone = input('phone');

            if($consultation_type)  $where['consultation_type'] = $consultation_type;
            if($name)  $where['name'] = ['like','%'.$name.'%'];
            if($phone)  $where['phone'] = ['like','%'.$phone.'%'];

            $data = db('m_order_sign_up')->where($where)->order('create_time desc')->page($page,$limit)->select();
            $count = db('m_order_sign_up')->where($where)->count('id');

            foreach($data as $k => $v){
                if($v['error_msg']){
                    $data[$k]['is_crm'] = '失败';
                }else{
                    $data[$k]['is_crm'] = '成功';
                }
            }

            $list['data'] = $data;
            $list['count']= $count;
            $list['msg']  = '';
            $list['code'] = 0;
            return json($list);
        }


        //获取消费类型
        $erp = config('ext.app_config');
        $addr = $erp['sx_erp']['addr'];
        $consultation = controller('Package','lib')->getConsumptionType(['addr'=>$addr]);
        //print_r($consultation);die;
        $headinfo['title'] = '先睹为快-客资列表';

        $this->assign([
            'consultation'=>$consultation,
            'headinfo'=>$headinfo,
        ]);
        return $this->fetch();
    }

    /*
     * 删除提交记录
     */
    public function delCustomer(){
        $id = input('id');
        $res = db('m_order_sign_up')->where('id',$id)->delete();
        if($res === false){
            return ['code'=>201,'msg'=>'删除失败，请稍后重试！'];
        }else{
            return ['code'=>200,'msg'=>'success'];
        }
    }


    // 显示权限
    private function getTopMenu(){
        $menuList = getAuth('auth');

        // $index      = '/vip/index/index';
        $edit= '/vip/packageorder/editPackageorder';
        $del= '/vip/packageorder/delPackageorder';
        $refund = '/vip/packageorder/refund';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/', $this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k => $v) {
            $menuUrl = str_replace('\\', '/', $v['menu_url']);

            if ($menuUrl == $edit) {
                $this->assign('editPackageorder', 1);
            } else if ($menuUrl == $del) {
                $this->assign('delPackageorder', 1);
            } else if($menuUrl == $refund){
                $this->assign('refund', 1);
            }

        }

        $this->assign('topmenu', $topmenu);

    }
}