<?php
/**
 * 推荐控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\SScoreDetail;
use think\Cache;
use think\image\Exception;
use think\Session;
class Recommendusername extends Base {
    //用于ajax返回的数据
    protected $msg     = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'recommendusername';
    /**
     * 方法描述: 获取列表
     * @return array
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
        
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'转推荐管理'
            ]
        ]);
        controller('recommend','controller')->getTopMenu();
        return $this->fetch();
    }

    /**
     * 方法描述：添加
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function add(){
        if(request()->isAjax()){
            $username = request()->post('username');
            $password = request()->post('password');
            $amount   = request()->post('amount');
            $b_id     = request()->post('b_id');
            $sort     = request()->post('sort');
            if(!$username){
                return json(['code'=>202,'msg'=>'密码不能为空！']);
            }
            $where['username'] = $username;
            $where['brandid']  = $this->brandId;
            $is_data = controller($this->libname,'lib')->getdata($where);
            if($is_data){
                return json(['code'=>202,'msg'=>'该用户名已经存在！']);
            }
            if($password){
                $password = think_encrypt($password);
            }else{
                return json(['code'=>202,'msg'=>'密码不能为空！']);
            }
            $data = [
                    'username' => $username,
                    'password' => $password,
                    'amount'   => $amount,
                    'b_id'     => $b_id,
                    'sort'     => $sort,
                ];
            $res = controller($this->libname,'lib')->add($data);
            if($res){
                action_log($data);      //写日志
                $this->msg = ['code'=>200,'msg'=>'添加成功'];
            }else{
                $this->msg = ['code'=>202,'msg'=>'添加失败'];
            }
            return json($this->msg);
        }
        $couponBagData = controller("couponbag","lib")->getlist("","all");
        controller('recommend','controller')->getTopMenu();
        $this->assign('bagdata',$couponBagData);
        return $this->fetch();        
    }
    /**
     * 方法描述：修改
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function edit(){
        if(request()->isAjax()){
            $username = request()->post('username');
            $password = request()->post('password');
            $amount   = request()->post('amount');
            $b_id     = request()->post('b_id');
            $sort     = request()->post('sort');
            $id       = request()->post('id');
            if(!$username){
                return json(['code'=>202,'msg'=>'用户名不能为空！']);
            }
            if($password){
                $password = think_encrypt($password);
                $data['password'] = $password;
            }
            $data = [
                    'username' => $username,
                    'amount'   => $amount,
                    'b_id'     => $b_id,
                    'sort'     => $sort,
                ];
            $res = controller($this->libname,'lib')->update($id,$data);
            if($res){
                action_log($data);      //写日志
                $this->msg = ['code'=>200,'msg'=>'修改成功'];
            }else{
                $this->msg = ['code'=>202,'msg'=>'修改失败'];
            }
            return json($this->msg);
        }
        $id = input("id");
        $data = controller($this->libname,"lib")->getdata(['id'=>$id]);
        $couponBagData = controller("couponbag","lib")->getlist("","all");  //查询卡包
        $this->assign('bagdata',$couponBagData);
        $this->assign('data',$data);
        return $this->fetch();        
    }

    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $arrs = controller($this->libname,'lib')->getdata(['id'=>$id]);
        $res  = controller($this->libname,'lib')->del($id);
        if ($res) {
            action_log($arrs);      //写日志
            $arr = array('code'=>200,'msg'=>'删除成功');
            return json($arr);
        } else {
            $arr = array('code'=>202,'msg'=>'删除失败');
            return json($arr);
        }
    }

}