<?php
/**
 * 积分规则设置
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月18日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Session;

class Scorerule extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'scorerule';
    /**
     * 方法描述: 积分规则列表
     * @return array 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page' => request()->get('page'),
            ];
            $d['data']  = controller($this->libname,'lib')->getList();
            $d['count'] = controller($this->libname,'lib')->getCount();
            $d['msg']   = '';
            $d['code']  = 0;

            return json($d);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'积分规则设置'
            ]
        ]);
        controller('level','controller')->getTopMenu();
        return $this->fetch();
    }
    
    /**
     * 方法描述: 会员卡生成规则展示页面
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function setCardNumRule () {
        if(request()->isAjax()){
            // 数据信息
            $acdata = request()->post();
            $id     = (int)$acdata['id'];
            $cardNumber = input('post.card_number/a');
            $cardNumber = implode(',',$cardNumber);
            $data = [
                'card_lenght'  => $acdata['card_lenght'],   //会员卡长度
                'card_prefix'  => $acdata['card_prefix'],   //会员卡的前缀
                'card_next'    => $acdata['card_next'],     //会员卡的后缀
                'card_number'  => $cardNumber,              //随机数
                'this_phone'   => $acdata['this_phone'],
                'staffid'      => Session::get('staff_id'),
                'brandid'      => $this->brandId,
                ];
            
            if($id){
                $data['id'] = $id;
                $res = db('card_rule')->where(['id'=>$id])->update($data);
            }else{
                $res = db('card_rule')->where(['brandid'=>$this->brandId])->insert($data);
            }
            // 处理数据
            if($res!==false){
                action_log($data);      //写日志
                $code = 1;
                $msg  = '修改成功';
            }else{
                $code = 0;
                $msg  = '修改失败';
            }
            return json(['code'=>$code,'msg'=>$msg]);
        }else{
            if($this->brandId){
                $data = db('card_rule')->where(['brandid'=>$this->brandId])->find();
            }
            $card_number = explode(',', $data['card_number']);
            $this->assign([
                'headinfo'=>[
                    'title'=>'会员卡生成规则设置'
                ],
                'card_number'=>$card_number,
                'data' => $data
            ]);
            controller('level','controller')->getTopMenu();
            return view();
        }
    }

//     /**
//      * 方法描述: 会员卡生成规则页面管理
//      * @return array
//      * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
//      */
//     public function cardAdd () {
//         if(request()->isAjax()){
//             $data = request()->post();
//             $cardNumber = input('post.card_number/a');
//             $cardNumber = implode(',',$cardNumber);
//             $arr = [
//                 'card_lenght' => $data['card_lenght'],
//                 'card_prefix' => $data['card_prefix'],
//                 'brandid' => $this->brandId,
//                 'staffid' => Session::get('staff_id'),
//                 'card_next' => $data['card_next'],
//                 'card_number' => $cardNumber,
//                 'this_phone' => $data['this_phone']
//             ];
//             $brandOne = db('card_rule')->where('brandid',$this->brandId)->find();
//             if ($brandOne) {
//                 $this->msg = ['code'=>2,'msg'=>'一个事业部下只能有一条会员卡编号生成记录'];
//             }
//             $res = db("card_rule")->insert($arr);
//             if($res){
//                 $this->msg = ['code'=>1,'msg'=>'添加成功'];
//             }else{
//                 // 上传失败获取错误信息
//                 $this->msg = ['code'=>0,'msg'=>'添加失败'];
//             }
            
//             return json($this->msg);
//         }else{
//             $this->assign([
//                 'headinfo'=>[
//                     'title'=>'设置会员卡生成规则'
//                 ]
//             ]);
//             return $this->fetch();
//         }
//     }

    /**
     * 方法描述: 会员卡生成规则修改单条记录
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
//     public function cardEdit () {

//         $id = input('get.id');
//         if(request()->isAjax()){
//             // 数据信息
//             $acdata = request()->post();
//             $cardNumber = input('post.card_number/a');
//             $cardNumber = implode(',',$cardNumber);
//             // 处理数据
//             $res = db('card_rule')->where('id','=',$id)->update([
//                 'card_lenght'    => $acdata['card_lenght'],
//                 'card_prefix'  => $acdata['card_prefix'],
//                 'card_next' => $acdata['card_next'],
//                 'card_number' => $cardNumber,
//                 'this_phone' => $acdata['this_phone']
//             ]);
//             if($res){
//                 $this->msg = ['code'=>1,'msg'=>'修改成功'];
//             }else{
//                 $this->msg = ['code'=>0,'msg'=>'修改失败'];
//             }
//             return json($this->msg);
//         }else{
//             $id = request()->get('id');
//             if($id){
//                 $this->assign([
//                     'data'   => db('card_rule')->where('id','=',$id)->find(),
//                     'headinfo'=>[
//                         'title'=>'会员卡生成规则管理'
//                     ]
//                 ]);
//                 return $this->fetch();
//             }else{
//                 return $this->error('无法获取您要修改的数据！');
//             }
//         }
//     }
    /**
     * 方法描述: 会员卡生成规则删除记录
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
//     public function deltes () {
//         $id  = request()->post('id');
//         $res = db('card_rule')->where('id',$id)->delete();
//         return json(['status'=>$res?1:0]);
//     }

    /**
     * 方法描述: 添加规则
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function edit(){
        if(IS_POST && request()->isAjax()){
                $acdata = request()->post();
                $d = [
                    'first_sign'    => $acdata['firstsign'],
                    'everyday_sign' => $acdata['everydaysign'],
                    'brithday_sign' => $acdata['brithdaysign'],
                    'supply_sign'   => $acdata['supplysign'],
                    'merryday_sign' => $acdata['merrydaysign'],
                    'first_land'    => $acdata['firstland'],
                    'everyday_land' => $acdata['everydayland'],
                    'reg_suc'       => $acdata['regsuc'],
                    'headimg'       => $acdata['headimg'],
                    'perfectinfo'   => $acdata['perfectinfo'],
                    'create_time'   => date('Y-m-d H:i:s'),
                    'secondbuy'     => $acdata['secondbuy'],
                    'secondbuy_score' => $acdata['secondbuyscore'],
                    'fristbuy'      => $acdata['fristbuy'],
                    'fristbuy_score' => $acdata['fristbuyscore'],
                    'recommendOne'  =>$acdata['recommendOne'],
                    'recommendTwo'  =>$acdata['recommendTwo'],
                    'recommendShangOne'=>$acdata['recommendShangOne'],
                    'recommendShangTwo'=>$acdata['recommendShangTwo'],
                    'order'         => $acdata['order'],
                    'account'         => $acdata['account'],
                ];
                
                // 连续签到数据处理
                $lands     = $acdata['land'];
                $landcores = $acdata['landscore'];
                $keep_rule = [];
                if(!$lands || !$landcores){
                    unset($lands,$landcores);
                }else{
                    foreach($landcores as $k=>$v){
                        if(!$v || !$lands[$k]){
                            unset($landcores[$k],$lands[$k]);
                        }else{
                            $keep_rule[$lands[$k]]['days']    = $lands[$k];
                            $keep_rule[$lands[$k]]['scores']   = $landcores[$k];
                        }
                    }
                }
                
                // 累计签单数据处理
                $granddays      = $acdata['grandday'];    // 接收累计的天数
                $grandtypeids   = $acdata['grandtypeid']; // 接收累计赠送的类别
                $grandnums      = $acdata['grandnum'];    // 接收积分的数量
                $couponids      = $acdata['couponid'];    // 优惠券的id
                
                //print_r($acdata);die;
                $grand_rule = [];
                if(!$granddays || !$grandnums){
                    unset($granddays,$grandnums,$grandtypeids,$couponids);
                }else{
                    foreach($grandnums as $k=>$v){
                        if(!$v || !$granddays[$k]){
                            unset($grandnums[$k],$grandtypeids[$k],$granddays[$k]);
                        }else{
                           
                            if($grandtypeids[$k]==1){
                                if(!$grandnums[$k]){
                                    continue;
                                }
                                $grand_rule[$granddays[$k]]['num'] = $grandnums[$k];
                            }else{
                                if(!$couponids[$k]){
                                    continue;
                                }
                                $grand_rule[$granddays[$k]]['num'] = $couponids[$k];
                            }
                            $grand_rule[$granddays[$k]]['days']    = $granddays[$k];
                            $grand_rule[$granddays[$k]]['typeid']  = $grandtypeids[$k];
                        }
                    }
                }
                
                // 接收推荐人积分规则数据
                $recommendnums   = $acdata['recommendnum'];
                $recommendscores = $acdata['recommendscore'];
                $recommend_rule = [];
                if(!$recommendnums || !$recommendscores){
                    unset($recommendnums,$recommendscores);
                }else{
                    foreach($recommendscores as $k=>$v){
                        if(!$v || !$recommendnums[$k]){
                            unset($recommendnums[$k],$recommendscores[$k]);
                        }else{
                            $recommend_rule[$recommendnums[$k]]['num']    = $recommendnums[$k];
                            $recommend_rule[$recommendnums[$k]]['scores']= $recommendscores[$k];
                        }
                    }
                }

                $data['id']         = $acdata['id'];
                $data['levelid']    = $acdata['level'];
                $d['recommend_rule']= $recommend_rule;
                $d['keep_rule']     = $keep_rule;
                $d['grand_rule']    = $grand_rule;
                $data['detail']     = json_encode($d);
                $funcName = $data['id']?'edit':'add';
                $a = controller($this->libname,'lib')->$funcName($data);
                if($a){
                    action_log($data);              //写日志
                    $this->msg = ['status'=>1,'msg'=>'添加成功'];
                }else{
                    // 上传失败获取错误信息
                    $this->msg = ['status'=>0,'msg'=>'添加失败'];
                }
             return json($this->msg);
        }else{   
            $levelid = request()->get('levelid');
            if($levelid){
                $res = controller($this->libname,'lib')->getOne($levelid);
                $coupons = controller('coupon','lib')->getSmallList();
                //print_r($res);die;
                $this->assign([
                            'data'   => $res,
                            'coupons'=> $coupons,
                            'levels' => controller($this->libname,'lib')->getLevels()
                        ]);
                $this->assign([
                    'headinfo'=>[
                        'title'=>'修改积分规则信息'
                    ]
                ]);
                controller('level','controller')->getTopMenu();
                return $this->fetch();
            }
        }
    }
    
    /**
     * 方法描述   修改规则信息
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
//     public function edit(){
        
//         if(IS_POST && request()->isAjax()){
          
//            $acdata = request()->post();
//                 $d = [
//                     'first_sign'    => $acdata['firstsign'],
//                     'everyday_sign' => $acdata['everydaysign'],
//                     'brithday_sign' => $acdata['brithdaysign'],
//                     'supply_sign'   => $acdata['supplysign'],
//                     'merryday_sign' => $acdata['merrydaysign'],
//                     'first_land'    => $acdata['firstland'],
//                     'everyday_land' => $acdata['everydayland'],
//                     'reg_suc'       => $acdata['regsuc'],
//                     'headimg'       => $acdata['headimg'],
//                     'perfectinfo'   => $acdata['perfectinfo'],
//                     'create_time'   => date('Y-m-d H:i:s'),
//                 ];
                
//                 // 处理连续签到数据
//                 $lands     = $acdata['land'];
//                 $landcores = $acdata['landscore'];
//                 $keep_rule = [];
//                 if(!$lands || !$landcores){
//                     unset($lands,$landcores);
//                 }else{
//                     foreach($landcores as $k=>$v){
//                         if(!$v || !$lands[$k]){
//                             unset($landcores[$k],$lands[$k]);
//                         }else{
//                             $keep_rule[$lands[$k]]['days']    = $lands[$k];
//                             $keep_rule[$lands[$k]]['scores']   = $landcores[$k];
//                         }
//                     }
//                 }
//                 // 累计签单数据处理
//                 $granddays      = $acdata['grandday'];    // 接收累计的天数
//                 $grandtypeids   = $acdata['grandtypeid']; // 接收累计赠送的类别
//                 $grandnums      = $acdata['grandnum'];    // 接收积分的数量
//                 $couponids      = $acdata['couponid'];    // 优惠券的id
                
//                 //print_r($acdata);die;
//                 $grand_rule = [];
//                 if(!$granddays || !$grandnums){
//                     unset($granddays,$grandnums,$grandtypeids,$couponids);
//                 }else{
//                     foreach($grandnums as $k=>$v){
//                         if(!$v || !$granddays[$k]){
//                             unset($grandnums[$k],$grandtypeids[$k],$granddays[$k]);
//                         }else{
                             
//                             if($grandtypeids[$k]==1){
//                                 if(!$grandnums[$k]){
//                                     continue;
//                                 }
//                                 $grand_rule[$granddays[$k]]['num'] = $grandnums[$k];
//                             }else{
//                                 if(!$couponids[$k]){
//                                     continue;
//                                 }
//                                 $grand_rule[$granddays[$k]]['num'] = $couponids[$k];
//                             }
//                             $grand_rule[$granddays[$k]]['days']    = $granddays[$k];
//                             $grand_rule[$granddays[$k]]['typeid']  = $grandtypeids[$k];
//                         }
//                     }
//                 }
                
//                 // 接收推荐人积分规则数据
//                 $recommendnums   = $acdata['recommendnum'];
//                 $recommendscores = $acdata['recommendscore'];
//                 $recommend_rule = [];
//                 if(!$recommendnums || !$recommendscores){
//                     unset($recommendnums,$recommendscores);
//                 }else{
//                     foreach($recommendscores as $k=>$v){
//                         if(!$v || !$recommendnums[$k]){
//                             unset($recommendnums[$k],$recommendscores[$k]);
//                         }else{
//                             $recommend_rule[$recommendnums[$k]]['num']   = $recommendnums[$k];
//                             $recommend_rule[$recommendnums[$k]]['score'] = $recommendscores[$k];
//                         }
//                     }
//                 }
                
//                 $data['id']          = $acdata['id'];
//                 $data['levelid']     = $acdata['level'];
//                 $d['keep_rule']      = $keep_rule ;
//                 $d['recommend_rule'] = $recommend_rule;
//                 $d['grand_rule']     = $grand_rule;
//                 $data['detail']      = json_encode($d);
//                 $funcName = $d['id']?'edit':'add';
//                 $res = controller($this->libname,'lib')->$funcName($data);
//                 if($res){
//                     $this->msg = ['status'=>1,'msg'=>'成功'];
//                 }else{
//                     // 上传失败获取错误信息
//                     $this->msg = ['status'=>0,'msg'=>'失败'];
//                 }
//              return json($this->msg);
            
            
//         }else{
//             $levelid = request()->get('levelid');
//             if($levelid){
//                 $res = controller($this->libname,'lib')->getOne($levelid);
//                 $coupons = controller('coupon','lib')->getSmallList();
//                 //print_r($res);die;
//                 $this->assign([  
//                             'data'   => $res,
//                             'coupons'=> $coupons,
//                             'levels' => controller($this->libname,'lib')->getLevels()
//                         ]);
                
//                 $this->assign([
//                     'headinfo'=>[
//                         'title'=>'修改积分规则信息'
//                     ]
//                 ]);
//                 controller('level','controller')->getTopMenu();
//                 return $this->fetch();
//             }else{
//                 return $this->error('无法获取您要修改的数据！');
//             }
           
//             return $this->fetch();
//         }
//     }
 
    /**
     * 方法描述: 删除积分规则假删除
     * @param  int $id 优惠券批次的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id  = request()->post('id');
        $res = controller($this->libname,'lib')->del($id);
        return json(['status'=>$res?1:0]);
    }
    /**
     * 方法描述: 提现说明
     * @param  int $id 优惠券批次的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function moneyrule () {
        if (request()->isAjax()) {
            $staffId = Session::get('staff_id');
            $brandId = Session::get('brandid');
//            $moneyExplain = input('post.money_explain');
            $moneyExplain = request()->post('money_explain');
            $monryTime = date('Y-m-d H:i:s',time());
            $data = [
                'staff_id' => $staffId,
                'brand_id' => $brandId,
                'monry_time' => $monryTime,
                'money_explain' => $moneyExplain,
            ];
            $moneyData = db('rule_money')->insert($data);
            if ($moneyData === false) {
                $json = ['code' => 201, 'msg' => '提现说明数据入库失败'];
                return json($json);
            }
            $json = ['code' => 200, 'msg' => '提现说明数据入库失败'];
            return json($json);
        } else {
            return $this->fetch();
        }
    }
    /**
     * 方法描述: 后台提现展示页
     * @param  int $id 优惠券批次的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function moneyList () {
        if (request()->isAjax()) {
            $staffId = Session::get('staff_id');
            $brandId = Session::get('brandid');
            $d['data']  = db('rule_money')->where('staff_id',$staffId)->where('brand_id',$brandId)->find();
//            $d['count'] = controller($this->libname,'lib')->getCount();
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        return $this->fetch();

    }


    /**
     * 方法描述: 经济人处理页面
     * @param  int $id 优惠券批次的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function economicsrule () {

        return view();
    }




}