<?php
/**
 * 用户等级设置控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:34:37
 */
namespace app\vip\controller;

use app\index\controller\Base;
use think\Db;

class Setindex extends Base
{
    protected $msg     = ['status'=>0,'msg' => '操作失败'];//用于ajax返回的数据
    protected $libname = 'setindex';
    protected $imgWH   = [400, 250];

    /**
     * 方法描述     级别列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index()
    {
        if (request()->isAjax()) {
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $d['data']  = controller($this->libname, 'lib')->getList($c);
            $d['count'] = controller($this->libname, 'lib')->getCount();
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $this->assign([
            'headinfo' => [
                'title' => '首页导航'
            ],
        ]);
        $cateArr = Db::connect('db_shop')->query('select * from tp_goods_category where is_show = 1 and is_index = 1');

        //我的订单选项
        $cateArr[] = [
            'id' => 0,
            'name' => '我的订单'
        ];

        $this->assign('catearr', $cateArr);
        $this->getTopMenu();
        return $this->fetch();
    }

    /**
     * 方法描述    添加
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function add()
    {
        if (IS_POST && request()->isAjax()) {
            $fileimg = request()->file("img");
            if ($fileimg) {
                $img = save_images($fileimg);
            }
            $data = [
                'name'          => request()->post('name'),
                'cateid'        => request()->post('cateid'),
                'img'           => $img,
                'create_time'   => date('Y-m-d H:i:s', time()),
                'staff_name'    => $this->staffName,
                'staff_id'      => $this->staffId,
                'brandid'       => $this->brandId,
            ];
            $res = db("s_index")->insert($data);
            if ($res) {
                $this->msg = ['code' => 200, 'msg' => '添加成功'];
            } else {
                $this->msg = ['code' => 202, 'msg' => '添加失败'];
            }
            return json($this->msg);
        } else {
            return $this->error('非法操作');
        }
    }

    /**
     * 方法描述：
     * @return Ambigous <\think\response\Json, \think\Response, \think\response\View, \think\response\Xml, \think\response\Redirect, \think\response\Jsonp, unknown, \think\Response>
     */
    public function getcatearr()
    {
        $id = input('id');
        $indexArr = db("s_index")->where('id', $id)->find();
        if ($indexArr) {
            return json(['code' => 200, 'msg' => '获取成功', 'data' => $indexArr]);
        } else {
            return json(['code' => 202, 'msg' => '获取失败']);
        }
    }

    /**
     * 修改信息
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function edit()
    {

        if (!request()->isAjax()) {
            return $this->error('无法获取您要修改的数据！');
        }

        $data = [
            'id'     => request()->post('id'),
            'name'   => request()->post('name'),
            'cateid' => request()->post('cateid'),
        ];

        if ($data['id'] < 1) {
            $this->msg = ['code' => 301, 'msg' => '参数错误'];
            return json($this->msg);
        }

        $fileimg = request()->file("img");
        if ($fileimg) {
            $data['img'] = save_images($fileimg);
        }
        $res = db('s_index')->where('id', $data['id'])->update($data);
        if ($res === false) {
            $this->msg = ['code' => 202, 'msg' => '修改失败'];
        } else {
            $this->msg = ['code' => 200];
        }

        return json($this->msg);
    }

    /**
     * 方法描述: 删除类型，假删除
     * @param  int $id 数据的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del()
    {
        $id = request()->post('id');
        $arr = db('s_index')->where('id',$id)->find();
        $res = db('s_index')->where('id',$id)->delete();
        if (!$res) {
            return json(['status' =>202, 'msg' => '删除失败']);
        }
        action_log($arr);           //写日志
        return json(['status' => 200, 'msg' => '删除成功']);
    }

    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */

    public function getTopMenu()
    {

        $menuList = getAuth();

        $index = '/vip/setindex/index';
        $edit = '/vip/setindex/edit';
        $add = '/vip/setindex/add';
        $del = '/vip/setindex/del';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/', $this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k => $v) {
            $menuUrl = str_replace('\\', '/', $v['menu_url']);
            if ($menuUrl == $index) {
                $class = '';
                if ($index == $currentUrl) {
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn ' . $class . '" ><a href="' . $index . '">首页导航键</a></div>';
            } else if ($menuUrl == $add) {
                $topmenu .= '<div class="layui-btn  layui-btn-warm" lay-event="addsecretary" id="addsecretary"><i class="layui-icon">&#xe654;</i>添加导航</div>';
            } else if ($menuUrl == $edit) {
                $this->assign('edit', 1);
            } else if ($menuUrl == $del) {
                $this->assign('del', 1);
            }

        }
        $this->assign('topmenu', $topmenu);
    }

}