<?php
/**
 * vip设定
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2017-10-27 $
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Queue;
use think\Session;

class Setting extends Base{

    function menu(){

        return $this->fetch();
    }

    //功能菜单设定
    function menuSet(){
        $data=controller('vip/Setting',"lib")->getMenuList();
        $this->assign('data',$data);
        $this->getTopMenu();
        return $this->fetch();
    }

    //功能菜单列表
    function getMenuJSON(){
        $res = controller("vip/Setting","lib")->getMenuJSON(input());
        return json($res);
    }
    
    public function addMenuSet(){
        $id= input('get.id');
        if($id){
            $detail=db('s_menu')->where('id',$id)->find();
            $this->assign('detail',$detail);
            $data=controller('vip/Setting',"lib")->getMenuList();
            $this->assign('data',$data);
            return  $this->fetch();
        }else{
            $data=controller('vip/Setting',"lib")->getMenuList();
            $this->assign('data',$data);
            
            return  $this->fetch();
        }
    }

    //增加功能
    public function addMenu(){
        //print_r(input('post.'));die;
        return controller('vip/Setting','lib')->addMenu(input('post.'));
    }

    //修改功能
    function  editMenu(){
        $res= controller('vip/Setting','lib')->editMenu(input('post.'));
        return $res;
    }
    //删除功能
    function  delMenu(){
        return controller('vip/Setting','lib')->delMenu(input('post.id'));
    }

    //功能菜单状态修改
    function editStatus(){
        return controller('vip/Setting','lib')->editStatus(input('post.'));
    }

    //权限设定
    public function permission(){
        $is_belong = Session::get('is_belong');
        $is_belong = 1;
        $brandname = Session::get('brandname');
        $shop_code = Session::get('shop_code');
        if($is_belong==1){
            $brand=controller('vip/Setting','lib')->brandclass_list();
            $department=controller('vip/Setting','lib')->department_list(array('grade_type'=>$is_belong));
            $position=controller("vip/Setting","lib")->get_position_list(array('grade_type'=>$is_belong,'department_id'=>'zero'));
        }
        if($is_belong==2){
            $shop=controller('vip/Setting','lib')->get_shop(array('brandclass'=>$brandname));
            $department=controller('vip/Setting','lib')->department_list(array('grade_type'=>$is_belong,'brandclass'=>$brandname));
            $position=controller("vip/Setting","lib")->get_position_list(array('grade_type'=>$is_belong,'brandclass'=>$brandname,'department_id'=>'zero'));
        }
        if($is_belong==3||$is_belong==4){
            $department=controller('vip/Setting','lib')->department_list(array('shop_code'=>$shop_code));
            $position=controller("vip/Setting","lib")->get_position_list(array('grade_type'=>3,'shop_code'=>$shop_code));
        }
        $this->assign('is_belong',$is_belong);
        $this->assign('brand',$brand);
        $this->assign('shop',$shop);
        $this->assign('department',$department);
        $this->assign('position',$position);
        $this->getTopMenu();
        $this->assign([
            'headinfo'=>[
                'title'=>'权限设定'
            ]
        ]);
        return $this->fetch();
    }
    //获取部门、岗位
    public function link_search(){
        $data=input('post.');
        if($data['brandclass']){
            $brandclass=$data['brandclass'];
        }else{
            $brandclass='zero';
        }
        if(empty($data['shop_code'])){
            $shop_code='zero';
        }else{
            $shop_code=$data['shop_code'];
        }
        $department_id='zero';
        $msg['department']=controller('vip/Setting','lib')->department_list(array('brandclass'=>$brandclass,'shop_code'=>$shop_code));
        $msg['position']=controller("vip/Setting","lib")->get_position_list(array('brandclass'=>$brandclass,'shop_code'=>$shop_code,'department_id'=>$department_id));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }
    //获取 店、部门、岗位
    public function bran_link(){
        $brand=input('post.');
        $msg['shop']=controller('vip/Setting','lib')->get_shop(array('brandclass'=>$brand['brandclass']));
        $msg['department']=controller('vip/Setting','lib')->department_list(array('grade_type'=>2,'brandclass'=>$brand['brandclass']));
        $msg['position']=controller("vip/Setting","lib")->get_position_list(array('grade_type'=>2,'brandclass'=>$brand['brandclass'],'department_id'=>'zero'));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }
    //获取岗位
    public function department_link(){
        $data=input('post.');
        $department['department_id']=(int)$data['department'];
        $msg['position']=controller("vip/Setting","lib")->get_position_list(array('department_id'=>$department['department_id']));

        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }

    public function shop_link(){
        $shop=input('post.');
        $msg['department']=controller('vip/Setting','lib')->department_list(array('grade_type'=>3,'shop_code'=>$shop['shop_code']));
        $msg['position']=controller("vip/Setting","lib")->get_position_list(array('grade_type'=>3,'shop_code'=>$shop['shop_code'],'department_id'=>'zero'));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }
    /**
     * 方法描述：获取数据
     * @return [type] [description]
     * @author  Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function getdata(){
        $type = input("type");
        if($type == 2){ //获取店列表
            $brandid = input("brandid");
            $shoplist  = controller("vip/Setting",'lib')->get_shoplist($brandid);       //店列表
            if($shoplist){
                return json(['code'=>200,'msg'=>'获取成功','data'=>$shoplist]);
            }else{
                return json(['code'=>202,'msg'=>'获取失败']);
            }
        }else if($type == 3){ //获取部门列表
            $shop_code = input("shop_code");
            $bumenlist = controller("vip/Setting","lib")->get_bumenlist($shop_code);    //部门列表
            if($bumenlist){
                return json(['code'=>200,'msg'=>'获取成功','data'=>$bumenlist]);
            }else{
                return json(['code'=>202,'msg'=>'获取失败']);
            }
        }else if($type == 4){  //获取岗位列表
            $department_id = input("department_id");
            $position  = controller("vip/Setting","lib")->get_position_list($department_id);//岗位列表
            if($position){
                return json(['code'=>200,'msg'=>'获取成功','data'=>$position]);
            }else{
                return json(['code'=>202,'msg'=>'获取失败']);
            }
        }
    }

    //递归后功能菜单数据
    public function  getPermissionJSON(){
        return controller('vip/Setting','lib')->getPermissionJSON();
    }

    //授权
    public function authorise(){
        return controller("vip/Setting","lib")->authorise(input('post.'));
    }

    //根据岗位查询其功能权限
    public function getPositionMenu(){
        $position_code=input('post.position_code');
        return controller("vip/Setting","lib")->getPositionMenu($position_code);
    }
    
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth('auth');
        $currentUrlStart = '/vip/setting/';
        $permissionurl   = $currentUrlStart.'permission';
        $addmenu   = $currentUrlStart.'addmenu';
        $delmenu   = $currentUrlStart.'delmenu';
        $setmenu   = $currentUrlStart.'menuset';
        $setbrand  = $currentUrlStart.'setbrand';
        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $setmenu){
                $class = '';
                if($setmenu == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn layui-btn-sm '.$class.'" ><a href="'.$setmenu.'">菜单管理</a></div>';
            }else if($menuUrl == $permissionurl){
                $class = '';
                if($permissionurl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn layui-btn-sm '.$class.'" ><a href="'.$permissionurl.'">权限设定</a></div>';
            }else if($menuUrl == $addmenu){
                $class = '';
                if($setmenu == $currentUrl){
                    $class = 'mactive';
                    $topmenu .= '<button class="layui-btn layui-btn-sm fp-btn layui-btn-warm" data-type="add"><i class="layui-icon">&#xe654;</i>添加菜单</button>';
                }
               
                $this->assign('add',1);
            }else if($menuUrl == $delmenu){
                $this->assign('del',1);
            }
        }
         
        $this->assign('topmenu',$topmenu);
        //return $topmenu;
    }
    
    
    
    
}