<?php
/**
 * Created by PhpStorm.
 * User: Zhaojiepeng
 * Date: 2018/8/6 0006
 * Time: 19:03
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Session;

class Systemsetup extends Base
{
    protected $sx_brand   = JT_BRAND;   //集团事业部
    protected $sx_ertong  = ET_BRAND;   //儿童事业部
    protected $sx_logo    = SX_LOGO;    //logo
    protected $kf_phone   = KF_PHONE;   //客服手机号
    protected $sx_baidu   = BAIDU_TJ;   //百度统计
    protected $vip_coupon_with = VIP_COUPON_WITH;  //会员折扣和优惠券是否同时使用
    protected $sx_charge  = SX_CHARGE;  //充值规定
    protected $libname    = 'systemsetup';
    protected $imgWH      = [
                                'login' => [89,25],
                                'index' => [60,50],
                            ];

    /**
     * 方法描述：index
     * @return [type] [description]
     */
    public function index(){
        //$status   = controller('McExamine', 'lib')->getStatus($this->brandId);
        //$setbaidu = db('c_sysconfig')->where('ckey','sx_baidu')->value('cvalue');
        $vip_coupon_with = db('c_sysconfig')->where('ckey','vip_coupon_with')->value('cvalue');//订单中会员折扣与优惠券是否可同时使用
        $all_package = db('c_sysconfig')->where('ckey','all_package')->value('cvalue');//店面中是否展示所有套系
        $reach_shop_date = db('c_sysconfig')->where('ckey','reach_shop_date')->value('cvalue');//下单是否预约到店日期
        $must_look_agreement = db('c_sysconfig')->where('ckey','must_look_agreement')->value('cvalue');//下单是强制查看协议
        $front_upload_photo = db('c_sysconfig')->where('ckey','front_upload_photo')->value('cvalue');//前台是否允许上传客片
        $photo_type_tip = db('c_sysconfig')->where('ckey','photo_type_tip')->value('cvalue');//客片分类下是否展示标签图
        $erp_vip_card = db('c_sysconfig')->where('ckey','erp_vip_card')->value('cvalue');//线上下单是否使用erp线下储值卡消费 1是，2不是


        $this->assign('vip_coupon_with',$vip_coupon_with);
        $this->assign('all_package',$all_package);
        $this->assign('reach_shop_date',$reach_shop_date);
        $this->assign('must_look_agreement',$must_look_agreement);
        $this->assign('front_upload_photo',$front_upload_photo);
        $this->assign('photo_type_tip',$photo_type_tip);
        $this->assign('erp_vip_card',$erp_vip_card);
        //$this->assign('setbaidu',$setbaidu);
        //$this->assign('status', $status);
        //$this->getTopMenu($status,$setbaidu);
        $this->assign([
            'headinfo'=>[
                'title'=>'系统设置'
            ]
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述：客服中心负责人设定
     * @return
     * @author  liwenhua <[<liwenhua@suxuantech.cn>]>
     */
    public function customerserver(){
        if(request()->isAjax()){
            $customer_server_id   = input('customer_server_id');
            $re = db()->table('c_sysconfig')->where('ckey','kf_staff_id')->update(['cvalue'=>$customer_server_id]);
            if($re){
                return json(array('code'=>200,'msg'=>'设置成功'));
            }else{
                return json(array('code'=>202,'msg'=>'设置失败'));
            }
        }else{
            //读mc接口
            $shop_code = Session::get('shop_code');
            $shop_code = 'XLM109';
            $customer_server_id = db()->table('c_sysconfig')->where('ckey','kf_staff_id')->value('cvalue');
            $this->assign('customer_server_id',$customer_server_id);
            $staff_list = sx_call('5a0e6f272bb38',json_encode([]),'sx_mc');
            if($staff_list['code'] == 200){
                $this->assign('staff_list',$staff_list['data']);
            }
            $this->getTopMenu();
            return $this->fetch();
        }
    }

    /**
     * 方法描述：儿童事业部设定
     * @return 
     * @author  zhaojiepeng <[<Zhaojiepeng@suxuantech.cn>]>
     */
    public function setertong(){
        if(request()->isAjax()){
        	$brandid   = input('brandid');
        	//儿童事业部与集团事业部设置 不同事业部
            $brand_config = controller($this->libname,'lib')->GetOneData($this->sx_brand);
        	if($brand_config['cvalue'] == $brandid){
        		return json(array('code'=>202,'msg'=>'当前选择事业部为集团事业部，请重新选择设定！'));
        	}
            $rt_config = controller($this->libname,'lib')->GetOneData($this->sx_ertong);
        	if(!$rt_config){
                $data['ckey']   = $this->sx_ertong;
                $data['cvalue'] = $brandid;
        	    $arr = controller($this->libname,'lib')->AddData($data);
            }else{
                $data['cvalue'] = $brandid;
                $arr = controller($this->libname,'lib')->UpdateData($this->sx_ertong,$data);
        	}
        	if($arr){
        		return json(array('code'=>200,'msg'=>'设置成功'));
        	}else{
        	    return json(array('code'=>202,'msg'=>'设置失败'));
        	}
        	
        }else{
            //读mc接口
            $brandArr = sx_call('5a38840b15ba9',array(''),'sx_mc');
            if($brandArr['code'] == 200){
                $this->assign('brandarr',$brandArr['data']);
            }
            $configArr = db('c_sysconfig')->where("ckey",$this->sx_ertong)->find();
            $this->assign('brandid',$configArr['cvalue']);
            $this->getTopMenu();
            return $this->fetch();
        }
    }

    /**
     * 方法描述：集团事业部设定
     * @return 
     * @author  zhaojiepeng <[<Zhaojiepeng@suxuantech.cn>]>
     */
    public function setbrand(){
        if(request()->isAjax()){
        	$brandid   = input('brandid');
        	//儿童事业部与集团事业部设置 不同事业部
        	$ertong_config = controller($this->libname,'lib')->GetOneData($this->sx_ertong);
        	if($ertong_config['cvalue'] == $brandid){
        		return json(array('code'=>202,'msg'=>'当前选择事业部为儿童事业部，请重新选择设定！'));
        	}
            $config = controller($this->libname,'lib')->GetOneData($this->sx_brand);
        	$config_brandid = db_config($this->sx_brand);
        	if(!$config){
                $data['ckey']   = $this->sx_brand;
                $data['cvalue'] = $brandid;
        	    $arr = controller($this->libname,'lib')->AddData($data);
            }else{
                $data['cvalue'] = $brandid;
                $arr = controller($this->libname,'lib')->UpdateData($this->sx_brand,$data);
        	}
        	if($arr){
                if(empty($config_brandid)){
                    //Session::set('brandid',$brandid);
                }
        		return json(array('code'=>200,'msg'=>'设置成功'));
        	}else{
        	    return json(array('code'=>202,'msg'=>'设置失败'));
        	}
        	
        }else{
            //读mc接口
            $brandArr = sx_call('5a38840b15ba9',array(''),'sx_mc');
            if($brandArr['code'] == 200){
                $this->assign('brandarr',$brandArr['data']);
            }
            $configArr = db('c_sysconfig')->where("ckey",$this->sx_brand)->find();
            $this->assign('brandid',$configArr['cvalue']);
            $this->getTopMenu();
            return $this->fetch();
        }
    }

    /**
     * 方法描述：百度统计设定
     * @return 
     * @author  zhaojiepeng <[<Zhaojiepeng@suxuantech.cn>]>
     */
    public function setBaidu(){
        $status = input("status");
        $baiduarr = controller($this->libname,'lib')->GetOneData($this->sx_baidu);
        if(!$baiduarr){
            $data['ckey'] = $this->sx_baidu;
            $data['cvalue'] = 1;
            $arr = controller($this->libname,'lib')->AddData($data);
        }else{
            $data['cvalue'] = $status;
            $arr = controller($this->libname,'lib')->UpdateData($this->sx_baidu,$data);
        }
        if($arr){
            return json(['code'=>200,'msg'=>'修改成功']);
        }else{
            return json(['code'=>202,'msg'=>'修改失败']);
        }
    }
    /**
     * 方法描述：订单中会员折扣与优惠券是否可同时使用
     * @return 
     * @author  zhaojiepeng <[<Zhaojiepeng@suxuantech.cn>]>
     */
    public function setVipCouponWith(){
        $status = input("status");
        $baiduarr = controller($this->libname,'lib')->GetOneData($this->vip_coupon_with);
        if(!$baiduarr){
            $data['ckey'] = $this->vip_coupon_with;
            $data['cvalue'] = 1;
            $arr = controller($this->libname,'lib')->AddData($data);
        }else{
            $data['cvalue'] = $status;
            $arr = controller($this->libname,'lib')->UpdateData($this->vip_coupon_with,$data);
        }
        if($arr){
            return json(['code'=>200,'msg'=>'修改成功']);
        }else{
            return json(['code'=>202,'msg'=>'修改失败']);
        }
    }


    /*
     * 系统设置开关
     * key_name   系统设置key值
     * status     开关状态
     */
    public function systemSwitch(){
        $status = input("status");
        $key_name = trim(input("key_name"));

        $baiduarr = controller($this->libname,'lib')->GetOneData($key_name);
        if(!$baiduarr){
            $data['ckey'] = $key_name;
            $data['cvalue'] = 1;
            $arr = controller($this->libname,'lib')->AddData($data);
        }else{
            $data['cvalue'] = $status;
            $arr = controller($this->libname,'lib')->UpdateData($key_name,$data);
        }
        if($arr){
            return json(['code'=>200,'msg'=>'修改成功']);
        }else{
            return json(['code'=>202,'msg'=>'修改失败']);
        }
    }

    /*
     * 设置网站logo
     * @return [type] [description]
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function setlogo(){
        if(request()->isAjax()){
            $login_logo = request()->file('login_logo');
            $index_logo = request()->file('index_logo');
            if($login_logo) {
                $loginimg = saveImg($login_logo,$this->imgWH['login'][0],$this->imgWH['login'][1]);  
            }
            if($index_logo){
                $indeximg = saveImg($index_logo,$this->imgWH['index'][0],$this->imgWH['index'][1]);  
            }
            $config = controller($this->libname,'lib')->GetOneData($this->sx_logo); //判断是否存在该值
            if(!$config){
                $arr = json_encode(array("login_logo"=>$loginimg,"index_logo"=>$indeximg));
                $data['ckey']   = $this->sx_logo;
                $data['cvalue'] = $arr;
                $res = controller($this->libname,"lib")->AddData($data);
            }else{
                $confarr = json_decode($config['cvalue'],true); //转换已存在数据 (json格式，双数据判断，防止数据修改交互错误。)
                if($loginimg && !$indeximg){                
                    $arr = array('login_logo'=>$loginimg,'index_logo'=>$confarr['index_logo']);
                }else if(!$loginimg && $indeximg){
                    $arr = array('login_logo'=>$confarr['login_logo'],'index_logo'=>$indeximg);
                }else{
                    $arr = array('login_logo'=>$loginimg,'index_logo'=>$indeximg);
                }
                $data['cvalue'] = json_encode($arr);
                $res = controller($this->libname,'lib')->UpdateData($this->sx_logo,$data);
            }            
            if($res){
                return json(['code'=>200,'msg'=>'成功']);
            }else{
                return json(['code'=>200,'msg'=>'失败']);
            }
        }
        $config = controller($this->libname,'lib')->GetOneData($this->sx_logo);

        $this->assign('data',json_decode($config['cvalue'],true));
        $this->assign('imgsize',$this->imgWH);
        return $this->fetch();
    }
    /**
     * 客服手机号配置
     * @return [type] [description]
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
/*    public function kf_phone(){
        if(request()->isAjax()){
            $phone   = input('phone');
            $onedata = controller($this->libname,'lib')->GetOneData($this->kf_phone);
            if(!$onedata){
                $data['ckey']   = $this->kf_phone;
                $data['cvalue'] = $phone;
                $arr = controller($this->libname,'lib')->AddData($data);
            }else{
                $data['cvalue'] = $phone;
                $arr = controller($this->libname,'lib')->UpdateData($this->kf_phone,$data);
            }
            if($arr){
                return json(array('code'=>200,'msg'=>'设置成功'));
            }else{
                return json(array('code'=>202,'msg'=>'设置失败'));
            }
            
        }else{
            //读mc接口
            $brandArr = sx_call('5a38840b15ba9',array(''),'sx_mc');
            if($brandArr['code'] == 200){
                $this->assign('brandarr',$brandArr['data']);
            }
            $configArr = db('c_sysconfig')->where("ckey",$this->sx_brand)->find();
            $this->assign('brandid',$configArr['cvalue']);
            $this->getTopMenu();
            return $this->fetch();
        }
        return $this->fetch();
    }*/

    /*
     * 充值设定
     * @return [type] [description]
     * @author zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function charge(){
        if(request()->isAjax()){
            $acdata = input('');

            $config = controller($this->libname,'lib')->GetOneData($this->sx_charge.''.$this->brandId); //判断是否存在该值
            $jsondata['data'] = $acdata['number'];
            $jsondata['is_pay'] = $acdata['is_pay'] == 'on'?1:0;
            $jsondata['charge_money'] = $acdata['charge_money'];
            $jsondata['score'] = $acdata['score'];
            if(!$config){
                $arr = json_encode($jsondata);
                $data['ckey']   = $this->sx_charge.''.$this->brandId;
                $data['cvalue'] = $arr;
                $res = controller($this->libname,"lib")->AddData($data);
            }else{
                $data['cvalue'] = json_encode($jsondata);
                $res = controller($this->libname,'lib')->UpdateData($this->sx_charge.''.$this->brandId,$data);
            }            
            if($res){
                return json(['code'=>200,'msg'=>'成功']);
            }else{
                return json(['code'=>200,'msg'=>'失败']);
            }
        }
        $config = controller($this->libname,'lib')->GetOneData($this->sx_charge.''.$this->brandId);

        $this->assign('data',json_decode($config['cvalue'],true));

        return $this->fetch();
    }
    /**
     * 方法描述：获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    public function getTopMenu($status,$setbaidu){
        $menuList   = getAuth();
        $currentUrlStart = '/vip/systemsetup/';
        $comment   = $currentUrlStart.'comment';
        $post      = $currentUrlStart.'post';
        $setbrand  = $currentUrlStart.'setbrand';
        $setertong = $currentUrlStart.'setertong';
        $setbaidus  = $currentUrlStart.'setbaidu';
        $setlogo   = $currentUrlStart.'setlogo';
        $customerserver   = $currentUrlStart.'customerserver';
        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $comment){
                $class = '';
                if($status['topic_is_examine'] == 1){
                    $this->assign("is_pinglun",1);
			    }
            }else if($menuUrl == $post){
                $class = '';
                 if($status['comment_is_examine'] == 1){
                	$this->assign("is_tiezi",1);
                }
            }else if($menuUrl == $setbaidus){
                $class = '';
                if($setbaidu == 1){
                    $this->assign("is_baidu",1);
                    // $topmenu.='<button class="layui-btn" id="setbaidus" lay-submit="" lay-filter="*"
                    //     style="margin-left: 10px;">关闭百度统计
                    //     </button>';
                }
            }else if($menuUrl == $setlogo){
                $class = '';
                if($currentUrl == $setlogo){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$setlogo.'">设置网站logo</a></div>';
            }else if($menuUrl == $setbrand){
                $class = '';
                if($currentUrl == $setbrand){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$setbrand.'">集团会员事业部设置</a></div>';
            }else if($menuUrl == $setertong){
                $class = '';
                if($currentUrl == $setertong){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$setertong.'">儿童会员事业部设置</a></div>';
            }else if($menuUrl == $customerserver){
                $class = '';
                if($currentUrl == $customerserver){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$customerserver.'">客服中心负责人设置</a></div>';
            }
        }
        $this->assign('topmenu',$topmenu);
        //return $topmenu;
    }
}