<?php
/**
 * 任务管理控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月22日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Session;
class Task extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'tasks';
    protected $imgWH   = [
        'share' =>[300,300],
        'index' =>[300,300],
    ];
    /**
     * 方法描述: 获取列表
     * @return array 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'任务管理'
            ]
            
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
   
    /**
     * 方法描述     添加
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function add(){
        if(IS_POST && request()->isAjax()){

            //数据信息
            $acdata = request()->post();
            if($acdata['typeid'] == 1) {
                //连续签到数据处理
                $lands     = $acdata['land'];
                $landcores = $acdata['landscore'];
                $keep_rule = [];
                if(!$lands || !$landcores){
                    unset($lands,$landcores);
                }else{
                    foreach($landcores as $k=>$v){
                        if(!$v || !$lands[$k]){
                            unset($landcores[$k],$lands[$k]);
                        }else{
                            $keep_rule[$lands[$k]]['days']    = $lands[$k];
                            $keep_rule[$lands[$k]]['scores']  = $landcores[$k];
                        }
                    }
                }
                // 累计签单数据处理
                $granddays      = $acdata['grandday'];    // 接收累计的天数
                $grandtypeids   = $acdata['grandtypeid']; // 接收累计赠送的类别
                $grandnums      = $acdata['grandnum'];    // 接收积分的数量
                $couponids      = $acdata['couponid'];    // 优惠券的id
                $grand_rule = [];
                if(!$granddays || !$grandnums){
                    unset($granddays,$grandnums,$grandtypeids,$couponids);
                }else{
                    foreach($grandnums as $k=>$v){
                        if(!$v || !$granddays[$k]){
                            unset($grandnums[$k],$grandtypeids[$k],$granddays[$k]);
                            }else{
                            if($grandtypeids[$k]==1){
                                if(!$grandnums[$k]){
                                    continue;
                                }
                                $grand_rule[$granddays[$k]]['num'] = $grandnums[$k];
                            }else{
                                if(!$couponids[$k]){
                                    continue;
                                }
                                $grand_rule[$granddays[$k]]['num'] = $couponids[$k];
                            }
                            $grand_rule[$granddays[$k]]['days']    = $granddays[$k];
                            $grand_rule[$granddays[$k]]['typeid']  = $grandtypeids[$k];
                        }
                    }
                }
                //首次签到
                $firstsign['scores'] = $acdata['firstsign'];
                $everyday['scores']  = $acdata['everyday'];
                $detail = json_encode(['keep_rule'=>$keep_rule,'grand_rule'=>$grand_rule,'everyday'=>$everyday,'firstsign'=>$firstsign]);
            }elseif($acdata['typeid'] == 2){
                $babyname     = $acdata['babyname']?$acdata['babyname']:0;
                $babybrithday = $acdata['babybrithday']?$acdata['babybrithday']:0;
                $phone        = $acdata['phone']?$acdata['phone']:0;
                $babysex      = $acdata['babysex']?$acdata['babysex']:0;
                $message['message'] = [
                    'babyname'      =>  $babyname,
                    'babybrithday'  =>  $babybrithday,
                    'phone'         =>  $phone,
                    'babysex'       =>  $babysex
                ];
                $detail = json_encode($message);
            }
            $data = [
                'title'         => $acdata['title'],
                'typeid'        => $acdata['typeid'],
                'status'        => $acdata['status'],
                'reward_score'  => $acdata['rewardscore'],
                'share_num'     => $acdata['share_num'],
                'activityid'    => $acdata['activityid'],
                'order_num'     => $acdata['ordernum'],
                'detail'        => $detail
            ];
            if($acdata['typeid'] == 1 || $acdata['typeid'] == 2){
                $auction = controller($this->libname,'lib')->getOneData(['typeid'=>$acdata['typeid']]);
                if($auction){
                    $this->msg = ['status'=>0,'msg'=>'添加失败'];
                    return json($this->msg);
                }
            }
            $res = controller($this->libname,'lib')->add($data);
            if($res){
                action_log($data);          //写日志
                $this->msg = ['status'=>1,'msg'=>'添加成功'];
            }else{
                // 上传失败获取错误信息
                $this->msg = ['status'=>0,'msg'=>'添加失败'];
            }
            
            return json($this->msg);
        }else{
            $this->assign('videos',controller('activity','lib')->getVideolist());
            $this->assign('bgimgs',controller('activity','lib')->getImgList());
            $this->assign([
                'headinfo'=>[
                    'title'=>'添加新任务'
                ],
                'imgsize'=>$this->imgWH
            ]);
            $this->getTopMenu();

            $signdata = controller($this->libname,'lib')->getOneData(['typeid'=>1]);
            $messagedata = controller($this->libname,'lib')->getOneData(['typeid'=>2]);
            $this->assign('signdata',$signdata);
            $this->assign('messagedata',$messagedata);
            //获取活动列表
            $w['brandid'] = $this->brandId;
            $activityData = db('a_activity_list')->where($w)->field('title,id')->select();
            $this->assign('activitydata',$activityData);
            // 获取优惠券列表
            $w['brandid'] = $this->brandId;
            $w['status']  = 1;
            $cList = db('c_coupon_num')->where($w)->where("delete_time is null")->field('id,title')->select();
            $this->assign('cList', $cList);
            return $this->fetch();
        }
    }
    
    /**
     * 修改信息
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function edit(){
        
        if(IS_POST && request()->isAjax()){
            // 数据信息
            $acdata = request()->post();
            
            if($acdata['typeid'] == 1) {
                //连续签到数据处理
                $lands     = $acdata['land'];
                $landcores = $acdata['landscore'];
                $keep_rule = [];
                if(!$lands || !$landcores){
                    unset($lands,$landcores);
                }else{
                    foreach($landcores as $k=>$v){
                        if(!$v || !$lands[$k]){
                            unset($landcores[$k],$lands[$k]);
                        }else{
                            $keep_rule[$lands[$k]]['days']    = $lands[$k];
                            $keep_rule[$lands[$k]]['scores']  = $landcores[$k];
                        }
                    }
                }
                 // 累计签单数据处理
                $granddays      = $acdata['grandday'];    // 接收累计的天数
                $grandtypeids   = $acdata['grandtypeid']; // 接收累计赠送的类别
                $grandnums      = $acdata['grandnum'];    // 接收积分的数量
                $couponids      = $acdata['couponid'];    // 优惠券的id

                $grand_rule = [];
                if(!$granddays || !$grandnums){
                    unset($granddays,$grandnums,$grandtypeids,$couponids);
                }else{
                    foreach($grandnums as $k=>$v){
                        if(!$v || !$granddays[$k]){
                            unset($grandnums[$k],$grandtypeids[$k],$granddays[$k]);
                        }else{
                            if($grandtypeids[$k]==1){
                                if(!$grandnums[$k]){
                                    continue;
                                }
                                $grand_rule[$granddays[$k]]['num'] = $grandnums[$k];
                            }else{
                                if(!$couponids[$k]){
                                    continue;
                                }
                                $grand_rule[$granddays[$k]]['num'] = $couponids[$k];
                            }
                            $grand_rule[$granddays[$k]]['days']    = $granddays[$k];
                            $grand_rule[$granddays[$k]]['typeid']  = $grandtypeids[$k];
                        }
                    }
                }
                //首次签到
                $firstsign['firstsign'] = $acdata['firstsign'];
                $everyday['scores']  = $acdata['everyday'];
                $detail = json_encode(['keep_rule'=>$keep_rule,'grand_rule'=>$grand_rule,'everyday'=>$everyday,'firstsign'=>$firstsign]);
            }elseif($acdata['typeid'] == 2){
                $babyname     = $acdata['babyname']?$acdata['babyname']:0;
                $babybrithday = $acdata['babybrithday']?$acdata['babybrithday']:0;
                $phone        = $acdata['phone']?$acdata['phone']:0;
                $babysex      = $acdata['babysex']?$acdata['babysex']:0;
                $message['message'] = [
                    'babyname'      =>  $babyname,
                    'babybrithday'  =>  $babybrithday,
                    'phone'         =>  $phone,
                    'babysex'       =>  $babysex
                ];
                $detail = json_encode($message);
            }
            $data = [
                'id'            => $acdata['id'],
                'title'         => $acdata['title'],
                'typeid'        => $acdata['typeid'],
                'status'        => $acdata['status'],
                'reward_score'  => $acdata['rewardscore'],
                'share_num'     => $acdata['share_num'],
                'activityid'    => $acdata['activityid'],
                'order_num'     => $acdata['ordernum'],
                'detail'        => $detail
            ];
            // 处理数据
            $res = controller($this->libname,'lib')->edit($data);
            if($res){
                action_log($data);      //写日志
                $this->msg = ['status'=>1,'msg'=>'修改成功'];
            }else{
                $this->msg = ['status'=>0,'msg'=>'修改失败'];
            }
            return json($this->msg);
        }else{
            $id = request()->get('id');
            $aa = controller($this->libname,'lib')->getOne($id);
            if($id){
                $data = controller($this->libname,'lib')->getOne($id);
                if($data['detail']){
                    $detail = json_decode($data['detail'],true);
                }
                $this->assign([
                    'videos'  => controller('activity','lib')->getVideolist(),
                    'bgimgs'  => controller('activity','lib')->getImgList(),
                    'data'    => $data,
                    'detail'  => $detail,
                    'headinfo'=> ['title'=>'添加新任务'],
                    'imgsize' => $this->imgWH,
                    'id'=>$id,
                ]);
                $this->getTopMenu();
                //获取活动列表
                $activityData = db('a_activity_list')->where('brandid', $this->brandId)->field('title,id')->select();                            
                $this->assign('activitydata',$activityData);                            
                // 获取优惠券列表
                $w['brandid'] = $this->brandId;
                $w['status']  = 1;
                $cList = db('c_coupon_num')->where($w)->where("delete_time is null")->field('id,title')->select();
                $this->assign('cList', $cList);                            
                return $this->fetch();                            
            }else{
                return $this->error('无法获取您要修改的数据！');
            }
        }
    }
    
    /**
     * 方法描述     设置发布状态，是否启用
     * @param  int $id id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id     = request()->post('id');
        $status = request()->post('status');
        $res = controller($this->libname,'lib')->setStatus($id,$status);
        if ($res) {
            action_log(['id'=>$id,'status'=>$status]);
            $arr = array('status'=>1,'msg'=>'状态修改成功');
            return json($arr);
        } else {
            $arr = array('status'=>0,'msg'=>'状态修改失败');
            return json($arr);
        }
    }
    
    
    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $arrs = db("t_task_list")->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id);
        if ($res) {
            action_log($arrs);      //写日志
            $arr = array('status'=>1,'msg'=>'任务删除成功');
            return json($arr);
        } else {
            $arr = array('status'=>0,'msg'=>'任务删除失败');
            return json($arr);
        }
    }
    
    /**
     * 方法描述     用户领取任务管理
     * @param  array $c 条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function taskDetail(){
 
        if(request()->isAjax()){
            $c = [
                'userid' => request()->get('userid'),
                'taskid' => request()->get('taskid'),
                'searchtypeid' => request()->get('searchtypeid'),
                'searchkey'    => request()->get('searchkey'),
                'limit'  => request()->get('limit'),
                'page'   => request()->get('page'),
            ];
            $c = array_filter($c);
            $d['data'] = controller($this->libname,'lib')->getTaskDetailList($c);
            unset($c['limit'],$c['page']);
            $d['count'] = controller($this->libname,'lib')->getTaskDetailCount($c);
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'用户领取任务管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    
    /**
     * 方法描述     用户执行详情
     * @param  array $c 条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function doDetail(){
        //var_dump(request()->get());
        if(IS_POST && request()->isAjax()){
            $c = [
                'userid' => request()->get('userid'),
                'taskid' => request()->get('taskid'),
                'searchtypeid' => request()->get('searchtypeid'),
                'searchkey'    => request()->get('searchkey'),
                'limit'  => request()->get('limit'),
                'page'   => request()->get('page'),
            ];
            $c = array_filter($c);
            $data['data']  = controller($this->libname,'lib')->getDoTaskDetail($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getDoTaskDetailCount($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
          }
          $this->assign([
              'headinfo'=>[
                  'title'=>'用户做任务详情'
              ]
          ]);
          $this->getTopMenu();
          return $this->fetch();
    }

    /**
     * 方法描述     设置优惠券的使用状态
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function setCouponStatus(){
        $c = [
            'shopid' => request()->post('shopid'), // 使用的店铺id
            'status' => request()->post('status'), // 状态是否使用
            'id'     => request()->post('id') //要设置的数据id
        ];
        $d = controller('coupon','lib')->setCouponStatus($c);
        return $d;
    }
    
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/task/';
        //print_r($menuList);
        $indexurl    = $currentUrlStart.'index';
        $setstatus   = $currentUrlStart.'setstatus';
        $del   = $currentUrlStart.'del';
        $add   = $currentUrlStart.'add';
        $edit  = $currentUrlStart.'edit';
        $taskdetail = $currentUrlStart.'taskdetail';
        $dodetail   = $currentUrlStart.'dodetail';
        
        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $indexurl){
                $class = '';
                if($indexurl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$indexurl.'">任务管理</a></div>';
            }else if($menuUrl == $setstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }else if($menuUrl == $add){
                 $topmenu .= '<div class="layui-btn layui-btn-warm" ><a href="'.$add.'"><i class="layui-icon">&#xe654;</i>添加新任务</a></div>';
            }else if($menuUrl == $taskdetail){
                $class = '';
                if($taskdetail == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$taskdetail.'">任务领取详情</a></div>';
                $this->assign('taskdetail',1);
            }else if($menuUrl == $dodetail){
                $class = '';
                if($dodetail == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$dodetail.'">执行任务详情</a></div>';
                $this->assign('dodetail',1);
            }else if($menuUrl == $edit){
                $this->assign('edit',1);
            }
             
            if($v['children']){
                foreach ($v['children'] as $kk=>$vv){
                    $submenuUrl = strtolower(str_replace('/', '\\', $vv['menu_url']));
                            if($submenuUrl == $indexurl){
                                $class = '';
                                if($indexurl == $currentUrl){
                                    $class = 'mactive';
                                }
                                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$indexurl.'">任务管理</a></div>';
                            }else if($submenuUrl == $setstatus){
                                $this->assign('setstatus',1);
                            }else if($submenuUrl == $del){
                                $this->assign('del',1);
                            }else if($submenuUrl == $add){
                                 $topmenu .= '<div class="layui-btn layui-btn-warm '.$class.'" ><a href="'.$add.'"><i class="layui-icon">&#xe654;</i>添加新任务</a></div>';
                            }else if($submenuUrl == $taskdetail){
                                $class = '';
                                if($taskdetail == $currentUrl){
                                    $class = 'mactive';
                                }
                                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$taskdetail.'">任务领取详情</a></div>';
                                $this->assign('taskdetail',1);
                            }else if($submenuUrl == $dodetail){
                                $class = '';
                                if($dodetail == $currentUrl){
                                    $class = 'mactive';
                                }
                                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$dodetail.'">执行任务详情</a></div>';
                                $this->assign('dodetail',1);
                            }else if($submenuUrl == $edit){
                                $this->assign('edit',1);
                            }
                }
            }
        }
        $this->assign('topmenu',$topmenu);
    }

}