<?php

/**
 * 用户控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\controller;
use think\Session;
use app\vip\model\UserModel;
class User extends Login{
    /**
     * 用户登录页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function login () {
        $this->assign([
            'headinfo'=>[
                'title'=>'会员管理系统-登录'
            ]
        ]);
        $Ip  = get_client_ip();
        $this->assign('ip',$Ip);
        $logo = json_decode(db_config(SX_LOGO),true);
        $this->assign('logo',$logo);
        return view('login');
    }
    /**
     * 用户重置密码页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function passReset () {
        $this->assign([
            'headinfo'=>[
                'title'=>'会员管理系统-密码找回'
            ]
        ]);
        return view('passReset');
    }
    /**
     * 用户重置密码处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function passWordResset () {
        $mobileCaptcha = input('post.mobileCaptcha');
        $phone = input('post.phone');
        $password = input('post.passWord');
        $sessionCaptcha = Session::get('capt');
        if ($mobileCaptcha != $sessionCaptcha) {
            $arrar = array('code'=>3,'msg'=>'手机验证码错误');
            return json($arrar);
        }
        $data = array('telphone'=>$phone,'password'=>$password);
        $res = sx_call('5a1cb7e65cb5f',$data,'sx_mc');
        if ($res['code']==200) {
            $arr = array('code'=>1,'msg'=>'密码修改成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'密码修改失败');
            return json($arr);
        }
    }
    /**
     * 后台首页页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function Index () {
        return view('index');
    }
    /**
     * 用户登录信息处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
//    public function loginCheck () {
//
//        $captcha = input('post.captcha');
//        $data = array(
//            'staffname' => input('post.staff_name'),
//            'password' => input('post.staff_password'),
//            'five'=> 0
//        );
////        if (!captcha_check($captcha)) {
////            $array = array(
////                'status' => 0,
////                'msg' => '验证码错误'
////            );
////            return  json($array);
////        } else {
//            //调用crm接口，返回用户信息。
//            $userInfo = sx_call('59f2e9fb5f863',$data,'sx_mc');
//            var_dump($userInfo);exit;
//            if($userInfo['code'] == 200){
//                //session
//                Session::set('staff_id',$userInfo['data']['staff_id']);
//                Session::set('session_id',$userInfo['data']['session_id']);
//                Session::set('login_type',$userInfo['data']['login_type']);
//                Session::set('login_method',$userInfo['data']['login_method']);
//                Session::set('expiry',$userInfo['data']['expiry']);
//                Session::set('staffname',$userInfo['data']['staffname']);
//                Session::set('photo',$userInfo['data']['photo']);
//                Session::set('shop_name',$userInfo['data']['shop_name']);
//                Session::set('shop_code',$userInfo['data']['shop_code']);
//                Session::set('setkey',$userInfo['data']['setkey']);
//                //session表'
//                $data = array(
//                    'staff_id' => $userInfo['data']['staff_id'],
//                    'session_id' => $userInfo['data']['session_id'],
//                    'ip' => $userInfo['data']['ip'],
//                    'login_type' => $userInfo['data']['login_type'],
//                    'login_method' => $userInfo['data']['login_method'],
//                    'expiry' => $userInfo['data']['expiry'],
//                    'status' => 1
//                );
//                $res = UserModel::session($data);
//                if ($res) {
//                    $array = array(
//                        'code' => 1,
//                        'msg'=>'session信息入库成功'
//                    );
//                    return json($array);
//                } else {
//                    $array = array(
//                        'code' => 0,
//                        'msg'=>'session信息入库失败'
//                    );
//                    return json($array);
//                }
//                //跳转个人中心
//            } else {
//                $array = array(
//                    'status' => 2,
//                    'msg' => '登录名或密码错误'
//                );
//                return json($array);
//            }
//        }
//    }

    /**
     * 用户默认生成会员卡号码
     * @param  String  $card_lenght 卡片长度默认13位
     * @return json   返回影响行数，成功或者失败$memid
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memCardNum ($memid,$tel,$brandid) {
        if (empty($memid)) {
            $res = db('m_users_phone')->where('phone',$tel)->where('brandid',$brandid)->find();
        } else {
            $res = db('m_users')->where('id',$memid)->field('brandid,id')->find();  //获取当前登录人的事业部id
            $userPhone = db('m_users_phone')->where('userid',$res['id'])->find();
        }
        $userData = db('card_rule')->where('brandid',$res['brandid'])->find();  //根据事业部id查询出当前所属卡编号的生成规则
        if (empty($userData)) {
            return $mem_number = $tel;
        }
        $mem_number =''; //默认定义卡号为空
        if ($userData['this_phone'] == 1 && !empty($userPhone)) {    //卡号默认使用手机号生成
            $mem_number = $userPhone['phone'];
        }
//        $nextLenght = strlen($userData['card_next']);  //取出后缀长度
//        $lenght = $userData['card_lenght'] - $nextLenght;  //去掉后缀长度

        $num = rand_chars(str_replace(',','',$userData['card_number']),$userData['card_lenght'],true);

        if (!empty($userData['card_prefix']) && !empty($userData['card_next'])) {   //带前缀与后缀会员编号
            $mem_number = $userData['card_prefix'].$num.$userData['card_next'];
        }

        return $mem_number;
    }
    /**
     * 前台公众号进入个人
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
//    public function weCatRegist () {
//        $data = array();
//        $userInfo = sx_call('5a029ee140dba',$data,'sx_mc'); //请求crm微信接口
//        $openId = $userInfo['data']['openid'];
//        $userData = UserModel::openId($openId);
//        if (empty($userData)) {
//            $userArr = array(
//                'openid' => $userInfo['data']['openid'],
//                'simg' => $userInfo['data']['photo'],
//                'ip' => $userInfo['data']['ip'],
//                'username' => $userInfo['data']['staffname'],
//                'use_number'=> $this->memCardNum(),
//                'create_time'=>date('Y-m-d,H:i:s',time())
//            );
//            //将微信首次登陆信息入库
//            $res = UserModel::insert($userArr);
//            if ($res) {
//                $array = array(
//                    'code' => 1,
//                    'msg'  => '用户信息添加成功'
//                );
//                return json_encode($array);
//            } else {
//                $array = array(
//                    'code' => 1,
//                    'msg'  => '用户信息添加失败'
//                );
//                return json_encode($array);
//            }
//        }
//    }
    /**
     * 用户注册页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function regist () {
       $satff_name =  Session::get('staffname');
        return view('regist');
    }

    /**
     * 用户添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function add()
    {
        return $this->fetch('add');
    }
    /**
     * 添加用户信息处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function addAll()
    {
        $name = input('post.name');
        $password = input('post.password');
        $db = db('user');
        //添加用户
        $list = $db->insert(['name' => $name, 'password' => $password]);
        //判断添加用户是否成功
        if($list){
            $this->success('添加成功!','index');
        }else{
            $this->error('添加错误!','index');
        }
    }
    /**
     * 用户修改页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function update($id)
    {
        $db = db('user');
        $data = $db->where(['id'=>$id])->find();
        return $this->fetch('update',['data'=>$data]);
    }
    /**
     * 微信扫码登录成功页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function weSuccess(){
        $this->assign('qrcodeId',input('id'));
        $this->assign([
            'headinfo'=>[
                'title'=>'微信扫码成功-会员管理系统'
            ]
        ]);
        return view();
    }
    /**
     * 微信扫码
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function logShows () {
        $id = input('id');
        $id = $id?$id:get_rand_string();
        $qrcodeInfo = session('qrlogincodeinfo_'.$id);
        if(!$qrcodeInfo){
            $response = sx_call('5a260b53c2907');
            if($response && $response['code'] == 200){
                $qrcodeInfo = $response['data'];
                session('qrlogincodeinfo_'.$id,$qrcodeInfo);
            }
        }else{
            $response = sx_call('5a260b53c2907',array('qr_code'=>$qrcodeInfo['qr_code']));
        }
        if(\think\Request::instance()->isAjax()){
            if($response && $response['code'] == 200){

                unset($response['data']['qr_code'],$response['data']['qr_code_url']);
                $response['data']['code_id'] = $id;
                if($response['data']['expire']>time()){
                    //未过期
                    $response['data']['expired'] = 0;
                    ///*
                    if($response['data']['state'] == 'logined'){
                        //本地登录
                        $res = self::weChat($response['data']);
                        if($res){
                            return $response;
                        }else{
                            session('qrlogincodeinfo_'.$id,null);
                            return ['code'=>500,'msg'=>'登录失败','data'=>array('state'=>'error')];
                        }
                    }//*/
                }else{
                    $response['data']['expired'] = 1;
                }
            }else{
                $response['data']['expired'] = 1;
            }
            return $response;
        }else{
            $qrcode = new \Endroid\QrCode\QrCode();
            $qrcode->setText($qrcodeInfo['qr_code_url']);
            return response($qrcode->writeString(), 200)->contentType("image/jpg");
            // echo $qrcode->writeString();
        }
    }
    /**
     * 员工登出
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function dieLogin () {
        Session('staff_id',null);
        $arr = array('code'=>1,'msg'=>'退出成功');
        return json($arr);
    }
    /**
     * 处理员工微信登录
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public static function weChat ($data) {
        
        Session::set('staff_id',$data['staff_id']);
        Session::set('staffname',$data['staffname']);
        return true;
    }



    /**
     * 修改密码页面
     * @author wangyining
     */
    public function passChange () {
        $staff_name = input('staff_name');

        $this->assign([
            'headinfo'=>[
                'title'=>'会员管理系统-修改密码'
            ],
            'staff_name' => $staff_name
        ]);
        return view('passchange');
    }

    /**
     * 修改密码处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author wangyining
     */
    public function passWordChange () {

        $staff_name = input('post.staff_name');
        $oldPassword = input('post.oldPassword');
        $newPassword = input('post.newPassword');


        $data = array('staff_name'=>$staff_name,'oldPassword'=>$oldPassword,'newPassword'=>$newPassword);
        $res = sx_call('59f44a14c3cae',$data,'sx_mc');
        if ($res['code']==200) {
            $userInfo = $res['data'];
            Session::set('staff_id',$userInfo['staff_id']);
            Session::set('session_id',$userInfo['session_id']);
            Session::set('login_type',$userInfo['login_type']);
            Session::set('login_method',$userInfo['login_method']);
            Session::set('expiry',$userInfo['expiry']);
            Session::set('staffname',$userInfo['staffname']);
            Session::set('photo',$userInfo['photo']);
            Session::set('shop_name',$userInfo['shop_name']);
            Session::set('shop_code',$userInfo['shop_code']);
            Session::set('setkey',$userInfo['setkey']);
            Session::set('brandid',$userInfo['brandclass_id']);
            Session::set('brandname',$userInfo['brandclass']);
            Session::set('is_belong',$userInfo['is_belong']);
            Session::set('main_work_type',$userInfo['main_work_type']);
            Session::set('work_type',$userInfo['work_type']);
            Session::set('main_position_code',$userInfo['main_position_code']);
            Session::set('position_code',$userInfo['position_code']);

            if($userInfo['brandclass_id'] == 0){
                if(empty(db_config('sx_brand'))){
                    $brand_id = 0;
                }else{
                    $brand_id = db_config('sx_brand');
                }
            }else{
                $brand_id = $userInfo['brandclass_id'];
            }
            Session::set('brandid',$brand_id);
            //session表'
            $data = array(
                'staff_id'   => $userInfo['staff_id'],
                'session_id' => $userInfo['session_id'],
                'ip'         => $userInfo['ip'],
                'login_type' => $userInfo['login_type'],
                'login_method' => $userInfo['login_method'],
                'expiry'     => $userInfo['expiry'],
                'status'     => 1
            );
            $brandid            = Session::get('brandid');           //事业部id
            $staff_id           = Session::get('staff_id');          //用户的id
            $main_position_code = Session::get('main_position_code');//岗位code(code当id的用)
            $ip                 = $userInfo['ip'];           //ip
            $expiry             = strtotime(Session::get('expiry')); //最后登录的时间
            $user_name          = Session::get('staffname');         //用户名
            $main_work_type     = Session::get('main_work_type');    //主工作类型
            $work_type          = Session::get('work_type');         //副工作类型
            $is_belong			= Session::get('is_belong');		 //当前帐号的类型
            $brandname			= Session::get('brandname');		 //事业部名称
            $shop_code			= Session::get('shop_code');		 //店code
            //获取商城域名
            if(empty(session('addr'))){
                $brandarr = getShopUrl($brandid);
                if($brandarr){
                    session('addr',$brandarr['mall_url']);
                    // session('addr','http://vip-shop.sx.com');
                }
            }
            //给参数数据加密
            $brandid            = think_encrypt($brandid);
            $staff_id           = think_encrypt($staff_id);
            $main_position_code = think_encrypt($main_position_code);
            $ip                 = think_encrypt($ip);
            $expiry             = think_encrypt($expiry);
            $user_name          = think_encrypt($user_name);
            $main_work_type     = think_encrypt($main_work_type);
            $work_type          = think_encrypt($work_type);
            $is_belong          = think_encrypt($is_belong);
            $brandname          = think_encrypt($brandname);
            $shop_code          = think_encrypt($shop_code);
            //实现单点登录
            $addr = session('addr')."/Admin/Oauth/index/?brandid=".$brandid."&admin_id=".$staff_id."&main_position_code=".$main_position_code."&ip=".$ip."&expiry=".$expiry."&user_name=".$user_name."&work_type=".$work_type."&main_work_type=".$main_work_type.'&is_belong='.$is_belong.'&brandname='.$brandname.'&shop_code='.$shop_code;
            $url = "<script src='".$addr."'></script>";
            session('shopAdminUrl',$url);
            $res = UserModel::session($data);
            if ($res) {
                $array = array(
                    'code' => 1,
                    'msg'=>'密码修改并登录成功',
                );
                return json($array);
            } else {
                $array = array(
                    'code' => 0,
                    'msg'=>'session信息入库失败'
                );
                return json($array);
            }

        } else {
            $arr = array('code'=>0,'msg'=>$res['msg']);
            return json($arr);
        }
    }
}



