<?php
/**
 * 客照
 * User: zhaibaoming
 * Date: 2018/8/8 0008
 * Time: 11:22
 */

namespace app\vip\controller;

use app\index\controller\Base;

class Userphotos extends Base
{

    private $pathImage ;//图片保存路径

    public function __construct(){
        parent::__construct();
        $this->pathImage = get_user_photos_image_Subdirectory();
    }

    public function index()
    {
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');
            $limit = isset($limit) ? $limit : 10;
            $page = isset($page) ? ($page - 1) * $limit : 0;
            $list['data'] = controller('McUserPhotos', 'model')->getLimit($this->brandId, $page, $limit);
            $list['count'] = controller('McUserPhotos', 'model')->getCount($this->brandId);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $headinfo['title'] = '客照';
        $this->assign('headinfo', $headinfo);
        $this->assign('imagePath', $this->pathImage);
        $this->getTopMenu();
        return $this->fetch('Userphotos/index');
    }
    /**
     * 唯映像客照列表
     * @return [type] [description]
     * @author Zhaojiepeng <[<zhaojiepeng@suxuantech.cn>]>
     */
    public function wei_index()
    {
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');
            $limit = isset($limit) ? $limit : 10;
            $page = isset($page) ? ($page - 1) * $limit : 0;
            $list['data'] = controller('McUserPhotos', 'model')->getLimit($this->brandId, $page, $limit , 1);
            $list['count'] = controller('McUserPhotos', 'model')->getCount($this->brandId,1);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $headinfo['title'] = '客照';
        $this->assign('headinfo', $headinfo);
        $this->assign('imagePath', $this->pathImage);
        $this->getTopMenu();
        return $this->fetch('Userphotos/wei_index');
    }

    /**
     * 添加信息
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function add()
    {
        if (request()->isAjax()) {
            $msg = ['status' => 0, 'msg' => ''];
            // 数据信息
            $acdata = request()->post();
            $data = [
                'title'         => trim($acdata['title']),
                'content'       => trim($acdata['content']),
                'sort'          => intval($acdata['sort']),
                'is_show'       => intval($acdata['is_show']),
                'url'           => trim($acdata['url']),
                'brand_id'      => $this->brandId,
                'is_weiying'    => intval($acdata['is_weiying']),
            ];
            $res = $this->verificationData($data);
            if ($res['code'] != 200) {
                $msg['msg'] = $res['msg'];
                return json($msg);
            }
            // 获取上传的图片信息
            $fileimg = request()->file("image");
            if (!$fileimg) {
                $msg['msg'] = '没有上传图片';
            }
            $data['image'] = saveImg($fileimg, 400, 240, $this->pathImage);

            // 处理数据
            $res = controller('McUserPhotos', 'model')->add($data);
            if ($res) {
                $msg = ['status'=>1,'msg'=>'添加成功'];
            } else {
                $msg['msg'] = '添加失败';
            }
            return json($msg);
        }
        $this->assign([
            'headinfo' => [
                'title' => '添加客照'
            ],
        ]);
        $this->getTopMenu();
        return $this->fetch('Userphotos/add');
    }

    /**
     * 验证数据
     * @param $data
     * @return array
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function verificationData($data)
    {
        $resultData = [
            'code' => '',
            'msg' => '',
            'data' => '',
        ];

        if (mb_strlen($data['title'], 'utf-8') > 20) {
            $resultData[] = '标题长度不能大于20个字';
            return $resultData;
        }

        if (empty($data['title'])) {
            $resultData[] = '标题不能为空';
            return $resultData;
        }

        if (mb_strlen($data['content'], 'utf-8') > 200) {
            $resultData['msg'] = '内容长度不能大于200个字';
            return $resultData;
        }

        if (empty($data['content'])) {
            $resultData['msg'] = '内容不能为空';
            return $resultData;
        }

        if ($data['sort'] < 1 || $data['sort'] > 100000000) {
            $resultData['msg'] = '排序错误';
            return $resultData;
        }

        if (mb_strlen($data['url'], 'utf-8') > 200) {
            $resultData['msg'] = '链接长度不能大于200个字';
            return $resultData;
        }

        if (empty($data['url'])) {
            $resultData['msg'] = '链接不能为空';
            return $resultData;
        }

        if ($data['is_show'] !== 1 && $data['is_show'] !== 0) {
            $resultData['msg'] = '状态错误';
            return $resultData;
        }

        $resultData['code'] = 200;
        $resultData['data'] = $data;
        return $resultData;
    }

    public function editStatus()
    {
        $id = intval(request()->post('id'));
        $status = intval(request()->post('status'));
        $reaultData = [
            'code' => 0,
            'msg' => '',
        ];

        if ($id < 1) {
            $reaultData['code'] = 301;
            $reaultData['msg'] = '参数错误_1';
            return json($reaultData);
        }

        if ($status > 1 || $status < 0) {
            $reaultData['code'] = 302;
            $reaultData['msg'] = '参数错误_2';
            return json($reaultData);
        }

        $status1 = $status ? 0 : 1;

        $res = controller('McUserPhotos', 'model')->editStatus($id, $status1);
        if ($res !== false) {
            $reaultData['code'] = 200;
            return json($reaultData);
        }

        $reaultData['code'] = 401;
        $reaultData['msg'] = '操作失败';
        return json($reaultData);
    }

    public function del()
    {
        $id = intval(request()->post('id'));
        $reaultData = [
            'code' => 0,
            'msg' => '',
        ];
        if (empty($id)) {
            $reaultData['code'] = 301;
            $reaultData['msg'] = '参数错误';
            return json($reaultData);
        }
        $res = controller('McUserPhotos', 'model')->del($id);
        if ($res) {
            $reaultData['code'] = 200;
            return json($reaultData);
        }

        $reaultData['code'] = 401;
        $reaultData['msg'] = '操作失败';
        return json($reaultData);
    }

    public function edit()
    {
        if (request()->isGet()) {
            $id = intval(request()->get('id'));
            $url = $_SERVER['HTTP_REFERER'];
            if (empty($id)) {
                $this->error('参数错误');
                return;
            }
            $reault = controller('McUserPhotos', 'model')->getIdData($id);
            $this->assign('url',$url);
            $this->assign('data', $reault);
            $this->assign('imagePath', $this->pathImage);
            $this->getTopMenu();
            return $this->fetch('Userphotos/edit');
        } else {
            $msg = ['status' => 0, 'msg' => ''];
            // 数据信息
            $acdata = request()->post();
            $id = intval($acdata['id']);
            if ($id < 1) {
                $msg['msg'] = '参数错误_1';
                return json($msg);
            }
            $data = [
                'title'      => trim($acdata['title']),
                'content'    => trim($acdata['content']),
                'sort'       => intval($acdata['sort']),
                'is_show'    => intval($acdata['is_show']),
                'url'        => trim($acdata['url']),
                'is_weiying' => intval($acdata['is_weiying'])
            ];

            $res = $this->verificationData($data);
            if ($res['code'] != 200) {
                $msg['msg'] = $res['msg'];
                return json($msg);
            }

            // 获取上传的图片信息
            $fileimg = request()->file("image");
            if ($fileimg) {
                $data['image'] = saveImg($fileimg, 400, 240, $this->pathImage);
                $res = controller('McUserPhotos', 'model')->editImg($data,$id);
            } else {
                $res = controller('McUserPhotos', 'model')->editNoImg($data,$id);
            }
            if ($res || $res === 0) {
                $msg = ['status' => 1, 'msg' => '添加成功'];
            } else {
                $msg['msg'] = '添加失败';
            }
            return json($msg);
        }
    }
    /**
     * 导航
     * @return [type] [description]
     */
    public function getTopMenu()
    {
        $menuList = getAuth();

        $index = '/vip/Userphotos/index';
        $edit  = '/vip/Userphotos/edit';
        $add   = '/vip/Userphotos/add';
        $del   = '/vip/Userphotos/del';
        $wei_index = '/vip/Userphotos/wei_index';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/', $this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k => $v) {
            $menuUrl = str_replace('\\', '/', $v['menu_url']);
            if ($menuUrl == $index) {
                $index = strtolower($index);
                $class = '';
                if ($index == $currentUrl) {
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn ' . $class . '" ><a href="' . $index . '">客照列表</a></div>';
            }else if ($menuUrl == $wei_index) {
                $wei_index = strtolower($wei_index);
                $class = '';
                if ($wei_index == $currentUrl) {
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn ' . $class . '" ><a href="' . $wei_index . '">唯映像客照列表</a></div>';
            } else if ($menuUrl == $add) {
                $topmenu .= '<div class="layui-btn  layui-btn-warm" lay-event="addsecretary" id="addsecretary"><i class="layui-icon">&#xe654;</i><a href="'.$add.'">添加客照</a></div>';
            } else if ($menuUrl == $edit) {
                $this->assign('edit', 1);
            } else if ($menuUrl == $del) {
                $this->assign('del', 1);
            }

        }
        $this->assign('topmenu', $topmenu);
    }



    /**
     * 全部启用
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function allEnabled()
    {
        $data['msg'] = '';
        $data['code'] = 0;
        $idStr = input('post.idStr', 0);
        if (empty($idStr)) {
            $data['msg'] = '参数错误';
            $data['code'] = 301;
            return json($data);
        }

        $McTopicModel = model('McUserPhotos');
        $res = $McTopicModel->allEnabled($idStr);
        if($res === false){
            $data['msg'] = '参数错误';
            $data['code'] = 302;
        }else{
            $data['code'] = 200;
        }

        return json($data);
    }


    /**
     * 全部停用
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function allDiscontinuation()
    {
        $data['msg'] = '';
        $data['code'] = 0;
        $idStr = input('post.idStr', 0);
        if (empty($idStr)) {
            $data['msg'] = '参数错误';
            $data['code'] = 301;
            return json($data);
        }

        $McTopicModel = model('McUserPhotos');
        $res = $McTopicModel->allDiscontinuation($idStr);
        if($res === false){
            $data['msg'] = '参数错误';
            $data['code'] = 302;
        }else{
            $data['code'] = 200;
        }

        return json($data);
    }
}