<?php
/**
 * 所有会员管理控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author:  2017年11月22日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Db;
use PHPExcel_IOFactory;
use PHPExcel;
use app\vip\lib\RunExcelImport;
use think\Request;
use think\Session;
use think\model\Merge;

class Users extends Base{
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'users';
    private $numZero = 0;
    private $numOne = 1;
    private $numTwo = 2;
    
    /**
     * 方法描述: 获取列表
     * @return array
     */
    public function index(){
        $usertype = (int)input('get.usertype');
        $brandid  = Session::get('brandid');
        $searchPhone = input('get.search_phone');
        $searchName = input('get.search_name');
        $searchOrderCode = input('get.search_order');
        $user_number = input('get.user_number');
        $total_score = input('get.total_score');
        if(request()->isAjax()){
            $searchlevel = input('request.searchlevel');//会员等级
            $brand_id    = input('request.brandid');
            $start_time  = input('request.start_time');
            $end_time    = input('request.end_time');
            $setphone    = input('setphone');
            $importid    = (int)input('request.searchimport');
            $recommend   = input('recommend');//介绍人或介绍人手机号
            $phone_start_time = input('phone_start_time');//绑定手机号查询开始时间
            $phone_end_time = input('phone_end_time');//绑定手机号查询结束时间

            $c = [
                'limit'        => (int)request()->get('limit'),
                'page'         => (int)request()->get('page'),
                'phone'        => $searchPhone,
                'username'     => $searchName,
                'order_number' => $searchOrderCode,
                'usertype'     => $usertype,
                'importid'     => $importid,
                'user_number'  => $user_number,
                'total_score'  => $total_score,
                'setphone'     => $setphone,
                'recommend'    => $recommend,
                'phone_start_time' => $phone_start_time,
                'phone_end_time'   => $phone_end_time,
             ];


            if($searchlevel!='all'){
                $c['level'] = (int)$searchlevel;
            }
            if($brand_id!='all'){
                $c['brandid']     = (int)$brand_id;
            }
            if($start_time){
                $c['start_time']  = $start_time;
            }
            if($end_time){
                $c['end_time']    = $end_time;
            }

            //表格数据
            $data['data']  = controller($this->libname,'lib')->getNewList($c);

            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getNewCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);

        }

        $levelData = db('user_level')->where('delete_time is null')->field('id,name,max_value')->order('min_once_pay asc')->select();
        if($levelData){
            $levelName  = '"'.implode('","',array_column($levelData,'name')).'"';
            $levelValue = implode(',',array_column($levelData,'max_value'));
        }
        $importfiles = db('c_excel_import')->field('file_name,id')->where(['brandid'=>$this->brandId,'import_number'=>['>=',1],'status'=>1])->select();
        // 输出页面头部菜单
        $this->getTopMenu();
        if(!isset($_GET['searchlevel']) || $_GET['searchlevel']=='all'){
            $this->assign(['isall'=>1]);
        }
        if(!isset($_GET['brandid']) || $_GET['brandid']=='all'){
            $this->assign(['isbrandall'=>1]);
        }
        if(!isset($_GET['setphone']) || $_GET['setphone']=='all'){
            $this->assign(['issetphone'=>1]);
        }
        $brandList = '';
        if($this->brandId == db_config('sx_brand')){
            $brandList = sx_call('5a38840b15ba9',array(),'sx_mc');
            if($brandList['code'] == 200){
                $brandList = $brandList['data'];
            }    
        }
        //优惠券列表
        $couponList = db('c_coupon_num')
            ->field('id,title')
            ->where(['brandid'=>$this->brandId, 'is_show'=>1, 'status'=>1])
            ->where('start_time','<',date('Y-m-d'))
            ->where('end_time','>',date('Y-m-d'))
            ->select();
        $this->assign(
                [
                'levelname'  => $levelName,
                'levelvalue' => $levelValue,
                'levelData'  => $levelData,
                'importfiles'=> $importfiles,
                'brandList'  => $brandList,
                'couponList' => $couponList
                ]);
        $this->assign([
            'headinfo'=>[
                'title'=>'会员管理'
            ]
        ]);
        return $this->fetch();
    }


    //导出会员数据
    public function exportVip(){
        $usertype = (int)input('get.usertype');
        $brandid  = Session::get('brandid');
        $searchPhone = input('get.search_phone');
        $searchName = input('get.search_name');
        $searchOrderCode = input('get.search_order');
        $user_number = input('get.user_number');
        $total_score = input('get.total_score');

        $growthvalue = input('request.searchlevel');
        $brand_id    = input('request.brandid');
        $start_time  = input('request.start_time');
        $end_time    = input('request.end_time');
        $setphone    = input('setphone');
        $importid    = (int)input('request.searchimport');
        $recommend   = input('recommend');//介绍人或介绍人手机号

        $c = [
            'limit'        => (int)request()->get('limit'),
            'page'         => (int)request()->get('page'),
            'phone'        => $searchPhone,
            'username'     => $searchName,
            'order_number' => $searchOrderCode,
            'usertype'     => $usertype,
            'importid'     => $importid,
            'user_number'  => $user_number,
            'total_score'  => $total_score,
            'setphone'     => $setphone,
            'recommend'    => $recommend
        ];


        if($growthvalue!='all'){
            $c['growthvalue'] = (int)$growthvalue;
        }
        if($brand_id!='all'){
            $c['brandid']     = (int)$brand_id;
        }
        if($start_time){
            $c['start_time']  = $start_time;
        }
        if($end_time){
            $c['end_time']    = $end_time;
        }

        //数据类型,all为全部 导出

        $c['data_type'] = 'all';
        $list = controller($this->libname,'lib')->getNewList($c);
        $data = [];
        foreach($list as $k => $v){
            $data[$k]['username']  = $v['username'];
            $data[$k]['phone']     = $v['phone'];
            $data[$k]['levelname'] = $v['levelname'];
            $data[$k]['user_number'] = $v['user_number'];
            $data[$k]['money'] = $v['money'];
            $data[$k]['total_score']  = $v['total_score'];
            $data[$k]['growth_value'] = $v['growth_value'] ? $v['growth_value'] : 0;
            $data[$k]['total_sign']   = $v['total_sign'] ? $v['total_sign'] : 0;
            $data[$k]['brandname']    = $v['brandname'];
            $data[$k]['sex'] = $v['sex']==1 ? '男' : '女';
            $data[$k]['create_time'] = $v['create_time'];
            $data[$k]['reg_time']    = $v['reg_time'];
            $data[$k]['share_username'] = $v['share_username'];
            $data[$k]['share_phone'] = $v['share_phone'];
        }

        $title = ['用户名','手机号','等级','会员卡号','账户余额','总积分','总成长值','累计签到次数','来源事业部','性别','注册日期','绑手机号日期','介绍人','介绍人手机号'];

        controller($this->libname,'lib')->export($title,$data,'users.xlsx');

    }



    /**
     * 修改会员资料
     * $return array   
     * $aurhor Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年3月12日
     */
    public function editusers(){
    	$is_ajax = input("is_ajax");//标识
        if($is_ajax == 1){
            $id      = input("id"); //user表 id
            $pid     = input("pid");//user_phone表 id
            /*
            if(!empty($id) && $pid != "null"){
            	$res =db('m_users')
            	        ->alias('p')
            	        ->where("p.id",$id)
                        ->join('m_users_phone m','m.userid=p.id','left')
                        ->field('m.username,m.sex,m.phone,m.brithday,m.userid,p.qq,p.email,p.weixin,p.address,p.remark')
            	        ->find();
            }elseif(!empty($id) && $pid == "null"){
            	$res = db('m_users')->where('id',$id)->find();
            }
            */
            $res = db('m_users')->where('id',$id)->find();

            $data = array("status"=>1,'msg'=>'查询成功','data'=>$res);
            return json($data);
        }elseif ($is_ajax == 2){
            $pid = input("pid");
            $userid = input("userid");
            $username= input("username");
        	$sex     = input("sex");
        	$phone   = input("phone");
        	$brithday= input("brithday");
        	$qq      = input("qq");
        	$email   = input("email");
        	$address = input("address");
        	$weixin  = input("weixin");
        	$remark  = input("remark");
        	
        	$data['username'] = $username;
        	$data['sex']  = $sex;
        	$data['brithday'] = $brithday;
        	$data['qq'] = $qq;
        	$data['email'] = $email;
        	$data['address'] = $address;
        	$data['weixin'] = $weixin;
        	$data['remark'] = $remark;
        	$log_users = db('m_users')->where('id',$pid)->find();    //插数据记录log
            
        	foreach($log_users as $k=>$v){
        	    if($data[$k] && $data[$k] != $v) {
        	    	$old_record_users[$k]=$v;                  //旧数据   
        	    	$new_record_users[$k]=$data[$k];           //新数据
        	    }
        	}
        	$new_record_users = json_encode($new_record_users); //将数据转json格式
        	$old_record_users = json_encode($old_record_users); 
        	
        	$arr = array('status'=>1,'msg'=>"修改成功");
        	$arr2 = array('status'=>-1,'msg'=>"修改失败");
        	if($pid == ""  && $userid != ""){
        		$r['qq'] = $qq;
        		$r['email'] = $email;
        		$r['address'] = $address;
        		$r['weixin'] = $weixin;
        		$r['remark'] = $remark;
        		
        		$c['username'] = $username;
        		$c['sex'] = $sex;
        		$c['phone'] = $phone;
        		$c['brithday'] = $brithday;
        		
        		$b = array_merge($r,$c);  //数据相加
        		action_log($b);           //写日志
        		$res  = db("m_users")->where('id',$userid)->update($r);
        		$res1 = db("m_users_phone")->where('userid',$userid)->update($c);
        		if(($res || $res === 0) && $res1 || $res1 ===0){
        			return json($arr);
        		}else{
        			return json($arr2);
        		}
        	}elseif($pid != "" && $userid == ""){
        		$res = db("m_users")->where('id',$pid)->update($data);
        		if($res || $res === 0){
        		    action_log($new_record_users, $old_record_users);
        		    return json($arr);
        		}else{
        			return json($arr2);
        		}
        	}
        }
    }
    /**
     * 方法描述：积分详情
     * $return array
     * $author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年2月24 14:55
     */
     public function integrallinfo(){
    	$id = input('post.id');
    	$a['m_executor'] = $id;
    	$minute = \db('minute_log')->where($a)->where('delete_time')->select();
    	$data['data'] = $minute;
    	$data['status'] = 1;
    	return json($data);
    }
    /**
     * 方法描述: 获取导入列表列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function importList(){
        if(request()->isAjax()){
            $c = [
                'limit'   => (int)request()->get('limit'),
                'page'    => (int)request()->get('page'),
            ];
            $data['data']  = controller($this->libname,'lib')->getImportList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getImportCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        // 输出页面头部菜单
        $this->getTopMenu();
        return $this->fetch();
    }

    /**
     * 方法描述     设置用户状态，是否启用
     * @param  int $id 用户id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id      = (int)input('post.id'); 
        $status  = (int)input('post.status'); 
        $pid     = (int)input('post.pid');
 
        $res = controller($this->libname,'lib')->setStatus($id,$status,$pid);
        if ($res) {
            $arr = array('status'=>1,'msg'=>'状态修改成功');
            return json($arr);
        } else {
            $arr = array('status'=>0,'msg'=>'状态修改失败');
            return json($arr);
        }
    }

    /**
     * 方法描述: 删除假删除
     * @param  int $id 用户id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id  = (int)request()->post('id');
        $pid = (int)request()->post('pid');
        $arr = db('m_users')->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id,$pid);
        if ($res) {
            action_log($arr);//写日志
            $arr = array('status'=>1,'msg'=>'删除成功');
            return json($arr);
        } else {
            $arr = array('status'=>0,'msg'=>'删除失败');
            return json($arr);
        }

    }
    
    /**
     * 方法描述     获取一个用户的信息
     * @param  array $c 条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function userDetail(){
 
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $c['id'] = request()->get('id');
            $d['data'] = controller($this->libname,'lib')->getOne($c);
            unset($c['limit'],$c['page']);
            $d['count'] = controller($this->libname,'lib')->getCount($c);
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        return $this->fetch();
    }
    
    public function upExcel(){
        if(request()->isAjax()){
            $usersfile = request()->file('filename');
            $path = ROOT_PATH . 'public' . DS . 'uploads'. DS .'excel'. DS;
            if($usersfile){
                $info = $usersfile->validate(['ext'=>'xls,xlsx'])->move($path);
                $file_name = $info->getSavename();
                $oldname   = $info->getInfo()['name'];
            }else{
                return json(['status'=>1,'msg'=>'没有找到您导入的数据文件']);
            }
            //$data         = \PHPExcel_IOFactory::load($path.$file_name);
            $excel_file['file_name'] = $oldname;
            $excel_file['file_url']  = $file_name;
            $excel_file['staff_id']  = session('staff_id');
            $excel_file['staff_name']= session('staffname');
            $excel_file['brandid']   = session('brandid');///??????????????????????????????
            $excel_file['addtime']   = date('Y-m-d H:i:s',time());
            $excel_file['excel_type'] = 1;
            $excel_file['all_number']= 0;
            db()->startTrans();//开启事务
            $id = db('c_excel_import')->insertGetId($excel_file);
            if($id){
                db()->commit();
            }else{
                db()->rollback();
            }
            $message['body']['id']     =  $id;
            $message['body']['table']  =  'm_users_phone';
            $message['body']['unikey'] =  'brandid';
            $message['body']['unikey2']=  'phone';
            if($id){
                \app\common\lib\redisQueue::init()->rPush('vip_excelImportRedisList',$message);
                return json(['status'=>1]);
            }else{
                return json(['status'=>0]);
            }
        }else{
            return $this->fetch();
        }
    }
    
    public function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }

    /**
     * 方法描述    处理excel数据导入
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月10日 下午3:31:15
     */
    public function upUser(){
        $tablename = 'm_users_phone';
        if(request()->isAjax()){
            $usersfile = request()->file('users');
            //print_r($users);
            $path = ROOT_PATH . 'public' . DS . 'uploads'. DS .'excel'. DS;
            if($usersfile){
                $info = $usersfile->validate(['ext'=>'xls,xlsx'])->move($path);
                $savename = $info->getSavename();
            }else{
                return json(['status'=>1,'msg'=>'没有找到您导入的数据文件']);
            }
            $unikey  = 'brandid';
            $unikey2 = 'phone';
            include_once '/vendor/phpexcel/Classes/PHPExcel/IOFactory.php';
            $data      = \PHPExcel_IOFactory::load($path.$savename);
            $users     = $data->getActiveSheet()->toArray();
            $userFiels = Db::getTableInfo($tablename,'fields');
            
            // 查询出旧的会员数据
            $oldusers = db('m_users_phone')->field("$unikey,$unikey2")->select();
            // 记录数据库里存在的字段
            $keyArr    = [];
            if($users && count($users)>1){
                $addFields = $users[0];
                for($i=0;$i<count($addFields);$i++){
                    if(in_array($addFields[$i],$userFiels)){
                        $keyArr[] = $i;
                    }
                }
                //print_r($users);
                //print_r($keyArr);
                $insertData     = [];
                $noInsertData   = [];
                $newTempData    = [];
                for($i=1;$i<count($users);$i++){
                    $one = $users[$i];
                    $tempData = [];
                    for($k=0;$k<count($one);$k++){
                        if(in_array($k,$keyArr)){
                            //echo $addFields[$k],'<br/>';
                            if($addFields[$k]==$unikey){
                                 $phone = $one[$k];
                            }
                            if($addFields[$k]==$unikey2){
                                $brandid = $one[$k];
                            }
                            if($addFields[$k]=='create_time'){
                                $newone = date('Y-m-d H:i:s',strtotime($one[$k]));
                                $tempData[$addFields[$k]] = $newone;
                            }else{
                                $tempData[$addFields[$k]] = $one[$k];
                            }
                        }
                    }
                    // 如果手机号不存在说明没有数据
                    if($phone){
                        if($newTempData[$phone.'_'.$brandid]){
                            $newTempData[$phone.'_'.$brandid]['haswhere'] = '导入的表里数据重复';
                            $noInsertData[] =  array_values($newTempData[$phone.'_'.$brandid]);
                        }
                        $newTempData[$phone.'_'.$brandid] = $tempData;
                    }
                    //print_r($newD);die;
                }
                //print_r($newTempData); 
                //print_r($noInsertData); 
                if($oldusers){
                    foreach ($oldusers as $k=>$v){
                        if($newTempData[$v[$unikey].'_'.$v[$unikey2]]){
                            $newTempData[$v[$unikey].'_'.$v[$unikey2]]['haswhere']="数据库里已存在";
                            $noInsertData[] = array_values($newTempData[$v[$unikey].'_'.$v[$unikey2]]);
                            unset($newTempData[$v[$unikey].'_'.$v[$unikey2]]);
                        }
                    }
                } 
                //print_r(array_values($noInsertData));
                //print_r($newTempData);
                if($noInsertData){
                    for($i=0;$i<count($keyArr);$i++){
                        $title[] = $addFields[$keyArr[$i]]; 
                    }
                    $title[] = 'because';
                    array_unshift($noInsertData,$title);
                    $filename = self::outExcel($noInsertData);
                }
                //print_r($noInsertData);die;
                if($newTempData){
                    $res = db($tablename)->insertAll($newTempData);
                    return json(['status'=>$res?1:0,'total'=>count($newTempData),'filename'=>$filename]);
                }else{
                    return json(['status'=>$res?1:0,'total'=>count($newTempData),'filename'=>$filename]);
                }
                //print_r($newTempData);die;
            }
            return json(['status'=>0,'没有您要导入的数据']);
        }
    
    }

    public function outExcel($data){
        // Create new PHPExcel object
        include_once '/vendor/phpexcel/Classes/PHPExcel/IOFactory.php';
        include_once '/vendor/phpexcel/Classes/PHPExcel.php';
        $objPHPExcel = new \PHPExcel();
        $path = ROOT_PATH . 'public' . DS . 'uploads'. DS .'excel'. DS;
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Maarten Balliauw")
        ->setLastModifiedBy("Suxuan System");

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
        ->setSize(10);
        
        $letters= ['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
        // Add some data
        $num = 1;
        foreach ($data as $k=>$v){
            for($i=0;$i<count($v);$i++){
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($letters[$i].$num,$v[$i]);
            }
            $num++;
        }
        $savename = 'noImport'.time().'.xlsx';
        $objPHPExcel->getActiveSheet()->setTitle('未导入的会员数据');
        $objPHPExcel->setActiveSheetIndex(0);
        // Save Excel 2007 file
        $callStartTime = microtime(true);
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save($path.$savename);
        
        return $savename;
    }

    public function downExcel(){
      
        $fileid = (int)input('request.fileid');
        $failFileid = (int)input('request.failfileid');
        if(!$fileid && !$failFileid){
           $this->error('mei you zhao dao ni yao xia zai de ');
        }
        $id = $failFileid?$failFileid:$fileid;
        $fileinfo = db('c_excel_import')->field('file_url,fail_file_url,file_name')->find($id);
        if($failFileid){
            $id = $failFileid;
            $savename = 'error_data.xlsx';
            $downFileName = $fileinfo['fail_file_url'];
        }else{
            $id = $fileid;
            $savename = $fileinfo['file_name'];
            $downFileName = $fileinfo['file_url'];
        }
        if(!is_file($downFileName)){
           $this->error('mei you zhao dao ni yao xia zai de ');
        }
        $data      = \PHPExcel_IOFactory::load($downFileName);
        ob_end_clean();
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$savename.'"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        header("Content-type: text/html; charset=utf-8");
        $objWriter = \PHPExcel_IOFactory::createWriter($data, 'Excel5');
        $objWriter->save('php://output');
        exit;
        
    }
 
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
        $menuList   = getAuth();
        $usertype   = (int)input('get.usertype');
        $indexurl   = '/vip/users/index';
        $importlist = '/vip/users/importlist';
        $upexcel    = '/vip/users/upexcel';
        $setstatus  = '/vip/users/setstatus';
        $del        = '/vip/users/del';
        $downexcel  = '/vip/users/downexcel';

        
        $integrall   = '/vip/users/integrall'; 
        $setscore    = '/vip/users/setscore';
        $setgrowth   = '/vip/users/setgrowth';
        $sendmsg     = '/vip/users/sendmsg';
        $editusers   = '/vip/users/editusers';
        
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $class  = $usertype !=1 && $currentUrl!=$importlist ?'mactive':'';
        $class2 = $usertype ==1?'mactive':'';
        $class3 = $currentUrl == $importlist?'mactive':'';
        $topmenu = '';

        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl==$indexurl){
                //$topmenu .= '<div class="layui-btn '.$class.'"><a href="'.$indexurl.'">会员列表</a></div>';
                //$topmenu .= '<div class="layui-btn '.$class2.'" ><a href="'.$indexurl.'?usertype=1">粉丝列表</a></div>';
            }else if($menuUrl==$importlist){
                //$topmenu .= '<div class="layui-btn '.$class3.'"><a href="'.$importlist.'">导入记录</a></div>';
            }else if($menuUrl==$upexcel) {
                //$topmenu .= '<div class="layui-btn importbtn" >导入粉丝</div>';
            }else if($menuUrl == $downexcel){
                $this->assign('downexcel',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }else if($menuUrl == $setstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $setgrowth){
                $this->assign('setgrowth',1);
            }else if($menuUrl == $setscore){
                $this->assign('setscore',1);
            }else if($sendmsg == $menuUrl){
                $this->assign('sendmsg',1);
            }else if($menuUrl == $editusers){
                $this->assign('editusers',1);
            }

        }
        $this->assign('topmenu',$topmenu);
        //return $topmenu;
    }

    /**
     * 方法描述 设置等级
     * @param  string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    public function setGrowth () {
        $brandId = Session::get('brandid');
        $id  = (int)input('post.id');
        $pid = (int)input('post.pid');
        $newlevelName = input('post.newlevelname');
        $oldlevelName = input('post.oldlevelname');
        $oldValue     = (int)input('post.oldvalue');
        $newValue     = (int)input('post.newvalue');
        $addValue     = (int)input('post.addvalue');
        if(!$id && !$pid) return array('code'=>201,'msg'=>'无法获取您要修改的数据');
        
        // 员工操作日志
        $actionData = [
            'staff_name' => Session::get('staffname'),
            'up_time' => date('Y-m-d H:i:s'),
            'user_id' => $id,
            'brand_id' => $brandId,
        ];

        $tablename = 'm_users';
        $field     = 'id';
        if($pid){
            $tablename = 'm_users_phone';
            if($id){
                $field = 'userid';
            }else{
                $field = 'id';
                $id    = $pid;
            }
  
        }
        $up = '';
        if($newValue){
            $d = ['growth_value'=> $newValue];
            $w = ['brandid'=>$brandId,$field=>$id];
            $actionData['old_level_name'] = $oldlevelName;
            $actionData['new_level_name'] = $newlevelName;
            $up = db($tablename)->where($w)->update($d);
            if($up!==false && $addValue){
                action_log($d);         //写日志
                $recordGrowData = [
                    'userid' => $id,
                    'graowth_num' => (int)$addValue,
                    'graowth_type' =>13,
                    'graowth_time' => date('Y-m-d H:i:s'),
                    'iswid' => 0,
                ];
                $recordGrowRes = db('growth_log')->insert($recordGrowData);
            }

        }
        if($up!==false){
            $res = \db('action_log')->insert($actionData);
        }
        return array('code'=>200,'msg'=>'单条数据修改成功');
    }

    /**
     * 方法描述  设置积分
     * @param  string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    public function setScore () {
        $brandId = Session::get('brandid');
        $id  = (int)input('post.id');
        $pid = (int)input('post.pid');
        $score     = (int)input('post.score');
        $oldScore  = (int)input('post.oldscore');
        if(!$id && !$pid) return array('code'=>201,'msg'=>'无法获取您要修改的数据');
        $tablename = 'm_users';
        $field     = 'id';

        if($pid){
            $tablename = 'm_users_phone';
            if($id){
                $field = 'userid';
            }else{
                $field = 'id';
                $id    = $pid;
            }
        }

        if($score){
            $d = ['total_score'=>['exp',"total_score+$score"]];
            $w = [$field=>$id];
            if ($score>0) {
                $scoreTitle = '商家赠送';
            } else {
                $scoreTitle = '商家扣除';
            }
            $actionData['old_score'] = $oldScore;
            $actionData['new_score'] = $oldScore+$score;
            db()->startTrans();
            try{
                $up = db($tablename)->where($w)->update($d);
                $log = array_merge($w,$d);
                if(!$up){
                    db()->rollback();
                    return array('code'=>202,'msg'=>'添加失败');
                }
                action_log($log);         //写日志
                $recordScoreData = [
                    'm_title' => $scoreTitle,
                    'm_num'   => $score,
                    'm_time' => date('Y-m-d H:i:s',time()),
                    'm_executor' => $id,
                    'users_phone_id'=>$pid,
                    'm_type' => 0,
                    'iswid' => 0,
                ];
                $recordScoreRes = \db('minute_log')->insert($recordScoreData);
                if(!$recordScoreRes){
                    db()->rollback();
                    return array('code'=>202,'msg'=>"添加失败");
                }
                db()->commit();
            }
            catch(\Exception $e){
                db()-rollback();
                return array('code'=>202,'msg'=>'添加失败');
            }
        }else{
             return array('code'=>202,'msg'=>'请选择要操作的积分值');
        }
        return array('code'=>200,'msg'=>'单条数据修改成功');
    }

    
    /**
     * 方法描述  群发短信
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月4日 下午10:10:54
     */
    public function sendMsg(){
        if(request()->isAjax()){
            $usertype = (int)input('request.usertype');
            $brandId  = Session::get('brandid');
            $searchPhone = input('request.search_phone');
            $searchName  = input('request.search_name');
            $searchOrderCode = input('request.search_order');
            $growthvalue = input('request.searchlevel');
            $importid    = (int)input('request.searchimport');
            $c = [
                'limit'   => (int)request()->get('limit'),
                'page'    => (int)request()->get('page'),
                'phone'   => $searchPhone,
                'username'=> $searchName,
                'usertype'=> $usertype,
                'importid'=> $importid,
                'sendmsg'  => true,
            ];
            if($growthvalue!='all'){
                $c['growthvalue'] = (int)$growthvalue;
            }
            $data = controller($this->libname,'lib')->getNewList($c);
            $phones = $data?implode(',',array_filter(array_column($data,'phone'))):'';
            if(!$phones){
                return json(['status'=>0,'msg'=>'没有符合条件用户']);
            }else{
                // 调用短信接口开始发送
                $sendData = [
                    'mobile'=>$phones,
                    'content'=>input('request.msgcontent'),
                    'brand_id'=>$brandId,
                ];
                $res=sx_call('5a17b86088f1a',$sendData);
                if($res['code']==200){
                    return json(['status'=>1,'msg'=>'发送成功']);
                }else{
                    return json(['status'=>0,'msg'=>'发送失败']);
                }
                //return json(['status'=>1,'msg'=>'数据获取完毕，准备发送了,等待接口对接']);
            }
 
            
        }
    }

    //发送优惠券模板消息
    public function sendCouponTemplateNotify(){
        $post = input('post.');
        $id = $post['id'];
        $coupon_id = $post['coupon_id'];
        $coupon_info = db()->table('c_coupon_num')->alias('coupon')
            ->join('c_coupon_type type','coupon.coupon_typeid = type.id')
            ->where('coupon.id',$coupon_id)
            ->field('title,img,money,content,total_num,start_time,end_time,min_consume,receive_total,expire_time,name')
            ->find();
        $users  = db()->table('m_users')->where(['id'=>['in',$id]])->select();
        $url = url('front/index/receiveCoupon',['id'=>$coupon_id],'',true);
        if($users){
            foreach($users as $key => $val){
                $content = [
                    'touser'       => $val['openid'],
                    'template_id'  => COUPON_REMIND,
                    'url'          => $url,
                    'data'         => [
                        'first'=>[
                            'value'=> '您好，您有一张优惠券待领取，点击立即领取使用',
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> '优惠券：'.$coupon_info['title'],
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> '有效期'.$coupon_info['expire_time'].'天',
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '领取后进入会员系统 “个人中心-卡券” 可查看此优惠券。',
                            'color'=> '#173177'
                        ]
                    ]
                ];
                $send_data['content'] = json_encode($content);
                $send_data['brandclass_id'] = $val['brandid'];
                $send_data['brandclass_id'] = 3;
                $res = sendMemberWxMsg($send_data);
                if($res['code'] == 200){
                    return json(array('code'=>200,'msg'=>'发送成功'));
                }else{
                    return json(array('code'=>202,'msg'=>'发送失败'));
                }
            }
        }
    }




}