<?php
/**
 * 公众号配置管理控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年12月12日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;

class Weixinconfig extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'WeixinConfig';
    /**
     * 方法描述  查看微信会员菜单的连接
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月18日 下午1:09:11
     */
    public function wxlink(){
        $this->assign(['brandid'=>$this->brandId]);
        $this->getTopMenu();
        return $this->fetch();
    }
    
    /**
     * 方法描述     微信自定义菜单列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function menu(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data  = controller($this->libname,'lib')->getMenuList($c);
            $d['data'] = getSubs($data);
            foreach ($d['data'] as $k=>$v){
                if($v['parentid']==0){
                    $d['data'][$k]['mpname'] = '<span style="color:#FF5722;font-weight:bold">顶级菜单</span>';
                }
                if($v['parentid']!=0){
                    $submenu[$v['parentid']] += 1;
                }
            }
            // 统计子类数量
            foreach ($submenu as $k=>$v){
                session('subtotal_'.$k,(int)$v);
                $newdata[$k] = $v;
                //echo $newdata[$k];
            }
            // 把子类数量给data
             foreach ($d['data'] as $k=>$v){
                 if($v['parentid']==0){
                     $d['data'][$k]['subnum'] = $newdata[$v['id']];
                 }
             }

            $d['count'] = controller($this->libname,'lib')->getMenuCount();
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $parentdata   = controller($this->libname,'lib')->getMenuList(['pid'=>1]);
        $topmenutotal = count($parentdata);
        session('topmenutotal',$topmenutotal);

        $keys = db('wx_auto_relay')->field('name,content')->where(['brandid'=>$this->brandId])->select();

   
        
        $this->assign([
            'headinfo'=>[
                'title'=>'微信自定义菜单管理'
            ],
            'parentData' =>  $parentdata,
            'keys'=>$keys,
        ]);
        
        $this->getTopMenu();
        return $this->fetch();
    }
     
    /**
     * 方法描述    添加
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function addMenu(){
    
        if(IS_POST && request()->isAjax()){
            $topmenutotal = session('topmenutotal');
            $postData = request()->post();
            $data = [
                'type'       => $postData['type'],
                'name'       => $postData['aname'],
                'parentid'   => (int)$postData['apid'],
                'url'        => $postData['aurl'],
                'appid'      => $postData['appid'],
                'pagepath'   => $postData['pagepath'],
                'key'        => $postData['key'],
                'create_time'=> date('Y-m-d H:i:s',time()),
                'brandid'    => (int)$this->brandId,
                'staff_id'   => $this->staffId,
                'staff_name' => $this->staffName,
            ];
    
            if($data['name']){
                $has = controller($this->libname,'lib')->hasVal($data['name'],$data['parentid']);
                if(!$has){
                    
                    $newsubnum = session('subtotal_'.$data['parentid']);
                    if($newsubnum>4){
                        return json(['status'=>0,'msg'=>'当前父类已经有5个子菜单了,不可以在添加了']);
                    }

                    $res = controller($this->libname,'lib')->add($data,'menu');
                    if($res){
                        session('topmenutotal',$topmenutotal+1);
                        if($data['parentid']!=0){
                           $subnum = (int)session('subtotal_'.$data['parentid']);
                           session('subtotal_'.$data['parentid'],$subnum+1);
                        }
                        action_log($data);      //写日志
                        $this->msg = ['status'=>1,'msg'=>'添加成功'];
                    }else{
                        $this->msg = ['status'=>0,'msg'=>'添加失败'];
                    }
                }else{
                    $this->msg = ['status'=>0,'msg'=>'添加失败,此菜单下已存在相同的名称了'];
                }
                 
            }
            return json($this->msg);
    
        }else{
            return $this->error('非法操作');
        }
    }
    
    /**
     * 修改菜单信息信息
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function editMenu(){
    
        if(IS_POST && request()->isAjax()){
            $postData = request()->post();
            // 数据信息
            $data = [
                'id'         => (int)$postData['id'],
                'type'       => $postData['etype'],
                'name'       => $postData['ename'],
                'parentid'   => (int)$postData['epid'],
                'url'        => $postData['eurl'],
                'appid'      => $postData['appid'],
                'pagepath'   => $postData['pagepath'],
                'key'        => $postData['key'],
                'brandid'    => (int)$this->brandId,
            ];

            $oldpid = (int)$postData['oldpid'];
     
            // 处理数据
            if($data['id'] && $data['name']){
                $has = controller($this->libname,'lib')->hasVal($data['name'],$data['parentid'],$data['id']);
                if(!$has){

                    // 判断当一级菜单改成二级菜单时判断一级菜单下是否有二级菜单有的话不可更改
                    if($oldpid==0 && $data['parentid']!=0){
                        $oldsubnum = (int)session('subtotal_'.$postData['id']);
                        if($oldsubnum>0){
                            return json(['status'=>0,'msg'=>'当前菜单下有子菜单,不可以更改为二级菜单']);
                        }
                       
                    }
                    
                    // 判断当前的修改的父类下边有几个子类,如果大于5就不可以改了
                    $subnum = (int)session('subtotal_'.$data['parentid']);
                    if($subnum>4&&$oldpid!=$data['parentid']){
                       return json(['status'=>0,'msg'=>'您选择的父菜单已经有5个子菜单了,不可以添加了。']);
                    }
                    
                    // 判断从二级菜单改成一级子菜单
                    $topmenutotal = (int)session('topmenutotal');
                    if($data['parentid']==0 && $topmenutotal>=3){
                        //$isEdit = true;
                        if(!$data['parentid']==$oldpid){
                            return json(['status'=>0,'msg'=>'当前已经有3个顶级菜单了,不可以在创建了']);
                        }
                       
                    }
                    
                    $res = controller($this->libname,'lib')->edit($data,'menu');
                    if($res!==false){
                        
                        //$topmenutotal = (int)session('topmenutotal');
                        // 如果是从一级菜单更改到二级菜单更改session
                        if($oldpid==0 && $data['parentid']!=0){
                            $newsubnum = session('subtotal_'.$data['parentid']);
                            session('subtotal_'.$data['parentid'],$oldsubnum+1);
                            session('topmenutotal',$topmenutotal-1);
                        }else if($oldpid!=0 && $data['parentid']!=0){
                            // 判断当前的父类id是不是和老父类id是一样的，不一样更改session
                            if($oldpid!=$data['parentid']){
                                $oldsubnum = session('subtotal_'.$oldpid);
                                session('subtotal_'.$oldpid,$oldsubnum-1);
                                $newsubnum = session('subtotal_'.$data['parentid']);
                                session('subtotal_'.$data['parentid'],$oldsubnum+1);
                            }
                        }
                        action_log($data);
                        $this->msg = ['status'=>1,'msg'=>'修改成功'];
                    }else{
                        $this->msg = ['status'=>0,'msg'=>'修改失败'];
                    }
                }else{
                    $this->msg = ['status'=>0,'msg'=>'修改失败,此菜单下已存在相同的名称了'];
                }
            }
            return json($this->msg);
    
        }else{
            return $this->error('无法获取您要修改的数据！');
        }
    }
    
    /**
     * 方法描述: 删除菜单
     * @param  int $id 数据的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function delMenu(){
        $id  = (int)request()->post('id');
        $parentid  = (int)request()->post('parentid');
        if(!$id){
            return json(['status'=>0,'msg'=>'无法获取您要删除的数据']);
        }
        $w = "id=$id or parentid=$id";
        $arr = db('wx_menu')->where($w)->find();
        $res = controller($this->libname,'lib')->del($id,'menu');
        if(!$res){
            return json($this->msg = ['status'=>0,'msg'=>'删除失败']);
        }
        
        if($parentid!=0){
            $subnum = (int)session('subtotal_'.$parentid);
            //echo $subnum.'id='.$parentid;
            session('subtotal_'.$parentid,$subnum-1);
           //$newsubnum = session('subtotal_'.$parentid);
           // echo '删除后'.$newsubnum.'id='.$parentid;
            
        }else{
            $topmenutotal = session('topmenutotal');
            session('topmenutotal',$topmenutotal-1);
        }
        action_log($arr);      //写日志
        return json($this->msg = ['status'=>1,'msg'=>'删除成功']);
    }
 
    /**
     * 方法描述     微信自动回复消息列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function relay(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data  = controller($this->libname,'lib')->getRelayList($c);
            $d['data'] = getSubs($data);
            foreach ($d['data'] as $k=>$v){
                if($v['parentid']==0){
                    $d['data'][$k]['mpname'] = '顶级菜单';
                }
            }
            $d['count'] = controller($this->libname,'lib')->getRelayCount();
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
 
    
        $this->assign([
            'headinfo'=>[
                'title'=>'微信自定义回复信息管理'
            ],
        ]);
    
        $this->getTopMenu();
        return $this->fetch();
    }
     
    /**
     * 方法描述    添加回复消息
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function addRelay(){
    
        if(IS_POST && request()->isAjax()){
            $postData = request()->post();
            $data = [
                'name'       => $postData['aname'],
                'content'   =>  htmlspecialchars($postData['acontent']),
                'create_time'=> date('Y-m-d H:i:s',time()),
                'brandid'    => (int)$this->brandId,
                'staff_id'   => $this->staffId,
                'staff_name' => $this->staffName,
            ];
    
            if($data['name']){
                $has = controller($this->libname,'lib')->hasRelay($data['name']);
                if(!$has){
                    $res = controller($this->libname,'lib')->add($data,'relay');
                    if($res){
                        action_log($data);          //写日志
                        $this->msg = ['status'=>1,'msg'=>'添加成功'];
                    }else{
                        $this->msg = ['status'=>0,'msg'=>'添加失败'];
                    }
                }else{
                    $this->msg = ['status'=>0,'msg'=>'添加失败,此菜单下已存在相同的名称了'];
                }
                 
            }
            return json($this->msg);
    
        }else{
            return $this->error('非法操作');
        }
    }
    
    /**
     * 修改菜单信息信息
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function editRelay(){
    
        if(IS_POST && request()->isAjax()){
            $postData = request()->post();
            // 数据信息
            $data = [
                'id'         => (int)$postData['id'],
                'name'       => $postData['ename'],
                'content'    => htmlspecialchars($postData['econtent']),
            ];
 
            // 处理数据
            if($data['id'] && $data['name']){
                $has = controller($this->libname,'lib')->hasRelay($data['name'],$data['id']);
                if(!$has){
                    $res = controller($this->libname,'lib')->edit($data,'relay');
                    if($res!==false){
                        action_log($data);      //写日志
                        $this->msg = ['status'=>1,'msg'=>'修改成功'];
                    }else{
                        $this->msg = ['status'=>0,'msg'=>'修改失败'];
                    }
                }else{
                    $this->msg = ['status'=>0,'msg'=>'修改失败,此菜单下已存在相同的名称了'];
                }
            }
            return json($this->msg);
    
        }else{
            return $this->error('无法获取您要修改的数据！');
        }
    }
    
    /**
     * 方法描述: 删除自动回复消息
     * @param  int $id 数据的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function delRelay(){
        $id  = (int)request()->post('id');
        if(!$id){
            return json(['status'=>0,'msg'=>'无法获取您要删除的数据']);
        }
        $arr = db('wx_auto_relay')->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id,'relay');
        if(!$res){
            return json($this->msg = ['status'=>0,'msg'=>'删除失败']);
        }
        action_log($arr);       //写日志
        return json($this->msg = ['status'=>1,'msg'=>'删除成功']);
    }
    
    public function setDefault(){
        $w = ['brandid'=>(int)$this->brandId];
        $data = db('wx_default_info')->where($w)->find();
        if(request()->isAjax()){
            $d = [
                'follow_msg' => htmlspecialchars(input('post.followmsg')),
                'relay_msg' => htmlspecialchars(input('post.relaymsg')),
                'staff_id' => $this->staffId,
                'staff_name' => $this->staffName
            ];
            if(empty($data)){
                $d['create_time'] = date('Y-m-d H:i:s',time());
                $d['brandid']     = $this->brandId;
                $res = db('wx_default_info')->insert($d);
            }else{
                $res = db('wx_default_info')->where(['id'=>$data['id']])->update($d);
            }
            if($res){
            	action_log($d);
            }
            return json(['status'=>$res!==false?1:0]);
        }else{
            $this->assign([
                'headinfo'=>[
                    'title'=>'设置微信公众号平台默认信息'
                ],
                'data' => $data
            ]);
            
            $this->getTopMenu();
            return $this->fetch();
        }

    }
    
 
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    public function getTopMenu(){
        $menuList   = getAuth();
        $currentUrlStart = '/vip/weixinconfig/';
        $menu      = $currentUrlStart.'menu';
        $menuEdit  = $currentUrlStart.'editmenu';
        $menuAdd   = $currentUrlStart.'addmenu';
        $menuDel   = $currentUrlStart.'delmenu';
        $menuLink  = $currentUrlStart.'wxlink';        
        
        $relay      = $currentUrlStart.'relay';
        $relayEdit  = $currentUrlStart.'editrelay';
        $relayAdd   = $currentUrlStart.'addrelay';
        $relayDel   = $currentUrlStart.'delrelay';
        
        $setdefault = $currentUrlStart.'setdefault';
        $setWxMenu   = $currentUrlStart.'setwxmenu';
        $topmenutotal = session('topmenutotal');
        
        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $menu){
                $class = '';
                if($menu == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$menu.'">微信菜单管理</a></div>';
            }else if($menuUrl == $menuDel){
                $this->assign('menudel',1);
            }else if($menuUrl == $menuEdit){
                $this->assign('menuedit',1);
            }else if($menuUrl == $menuAdd){
                if($currentUrl == $menu && $topmenutotal<3){
                    $topmenu .= '<div class="layui-btn  layui-btn-warm" lay-event="addmenubtn" id="addmenubtn"><i class="layui-icon">&#xe654;</i>添加菜单</div>';
                }                
                $this->assign('menuadd',1);
            }else if($menuUrl == $relay){
                $topmenu .= '<div class="layui-btn"><a href="'.$relay.'">微信自动回复消息管理</a></div>';
            }else if($menuUrl == $relayAdd){
                if($currentUrl == $relay){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" lay-event="addmsgbtn" id="addmsgbtn"><i class="layui-icon">&#xe654;</i>添加回复消息</div>
                ';
                }
            }else if($menuUrl == $relayEdit){
                $this->assign('editrelay',1);
            }else if($menuUrl == $relayDel){
                $this->assign('delrelay',1);
            }else if($menuUrl == $menuLink){
                $class = '';
                if($menuLink == $currentUrl){
                    $class = 'mactive';
                }
                $topmenuend = '<div class="layui-btn '.$class.'" ><a href="'.$menuLink.'">查看会员系统菜单</a></div>';
            }else if($menuUrl == $setdefault){
                $class = '';
                if($setdefault == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$setdefault.'">公众号默认设置</a></div>';
            }else if($menuUrl == $setWxMenu){
                if($currentUrl == $menu){
                    $setwxmenu  = '<div class="layui-btn site-demo-button" style="background:#5FB878;"lay-event="setmenubtn" id="setmenubtn">更新公众号微信菜单</div>';
                }
            }

        }
        $this->assign('topmenu',$topmenu.$topmenuend.$setwxmenu);
        //return $topmenu;
    }

    /**
     * 方法描述  初始化微信菜单操作
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月20日 下午2:40:36
     */
    public function setWxmenu(){

        if($this->brandId){
            $d = db('wx_menu')
                ->alias('m')
                ->where(['m.brandid'=>$this->brandId])
                ->join('wx_menu mp','mp.id=m.parentid','left')
                ->field('m.*,mp.name as mpname')
                ->order('parentid asc,id asc')->select();
            foreach ($d as $k=>$v){
                if($v['parentid']==0){
                    $newdata[$k]['type'] = $v['type'];
                    $newdata[$k]['name'] = $v['name'];
                    $newdata[$k]['url']  = trim($v['url']);

                    //跳转页面
                    if($v['type'] == 'view') {
                        $newdata[$k]['url'] = trim($v['url']);
                    }

                    //跳转小程序
                    if($v['type'] == 'miniprogram'){
                        $newdata[$k]['appid']    = $v['appid'];
                        $newdata[$k]['pagepath'] = $v['pagepath'];
                    }

                    //消息回复关键字
                    if($v['type'] == 'click') {
                        $newdata[$k]['key'] = trim($v['key']);
                    }


                    //二级菜单
                    foreach ($d as $kk=>$vv){
                        if($v['id']==$vv['parentid']){
                            $subData =  [
                                'type' => $vv['type'],
                                'name' => $vv['name'],
                            ];

                            //调转页面
                            if($vv['type'] == 'view'){
                                $subData['url'] = trim($vv['url']);
                            }

                            //跳转小程序
                            if($vv['type'] == 'miniprogram'){
                                $subData['url']      = trim($vv['url']);
                                $subData['appid']    = $vv['appid'];
                                $subData['pagepath'] = $vv['pagepath'];
                            }

                            //消息回复关键词
                            if($vv['type'] == 'click'){
                                $subData['key'] = trim($vv['key']);
                            }

                            if(isset($subData['url']) && trim($subData['url']) == ''){
                                unset($subData['url']);
                            }
                            $newdata[$k]['sub_button'][] = $subData;
                            unset($subData);
                            unset($d[$kk]);
                        }
                    }

                    //若是顶级，并且有下级，则去除type和url(微信自定义菜单接口格式)
                    if(count($newdata[$k]['sub_button'])>0){
                        unset($newdata[$k]['type']);
                        unset($newdata[$k]['url']);
                        unset($newdata[$k]['appid']);
                        unset($newdata[$k]['pagepath']);
                    }
                }


            }

            $data['button'] = $newdata;
            $content =json_encode($data,JSON_UNESCAPED_UNICODE);
            $a = controller('WechatSetting','lib')->menuSet($this->brandId,$content);
            return json(['status'=>$a && $a['errmsg']=='ok'?1:$a['errcode'],'msg'=>$a['errmsg']]);
            //return array('error'=>1,'code'=>$response['errcode'],'msg'=>$response['errmsg']);
        }

    }
    
 
}