<?php
/**
 * Created by PhpStorm.
 * User: sx-15
 * Date: 2017/12/9
 * Time: 11:48
 */

namespace app\vip\controller;

use app\index\controller\Base;
use phpDocumentor\Reflection\DocBlock\Tags\Var_;
use think\Model;
use think\Controller;
class Link extends Base
{
    /**
     * 二维码添加页
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败 `
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function add () {
        return view();
    }
    /**
     * 二维码添加数据处理页
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败 `
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function createLink () {
        if(IS_POST && request()->isAjax()) {
            $result = db('img_code')->where('brandid','=',$this->brandId)->find();
            if ($result) {
                $res = 1;
                $this->assign('res',$res);
                $arr = array('code'=>3,'msg'=>'该品牌下已有链接,请勿在成');
                return json($arr);
            } else {
                $res = 2;
                $this->assign('res',$res);
            }
            $data = request()->post();
            $url =$data['eq_card_type'];
            $urlName = $url;
            $branid = $this->brandId;
//            $staffid = $data['staff_id'];
            $staffid = 10;
            if (empty($staffid)) {
                $arr = array('code'=>1,'msg'=>'生成失败,缺少员工id');
                return json($arr);
            }
            $linkCode  = $this->strRandom();
            if ($url == 1) {
                $url = url('front/index/index','','',true).'?brandid='.$branid;
            } elseif ($url == 2) {
                $url = url('front/index/personalcenter','','',true).'?brandid='.$branid;
            } elseif ($url == 3) {
                $url = url('front/index/activitycenter','','',true).'?brandid='.$branid;
            } elseif ($url == 4) {
                $url = url('front/index/diy','','',true).'?brandid='.$branid;
            }
            $qrcode = new \Endroid\QrCode\QrCode();
            $qrcode->setText($url);
            $imgname   =  $linkCode.''.time().'.png';
            $completename   = 'public/uploads/QRimgs/'.$linkCode.''.time().'.png';
            $qrcode->writeFile($completename);
            if (!is_file($completename)) {
                $arr = array('code'=>1,'msg'=>'生成失败,目录不存在');
                return json($arr);
            }
    //        $img = $qrcode->writeString();
            $data = array(
                'c_img' => $completename,
                'staff_id' =>$staffid,
                'c_code' => $linkCode,
                'brandid' => $this->brandId,
                'staff_name' => $this->staffName,
                'qrcode' => $imgname,
                'c_tyid' => $urlName,
                'link_site' => $url,
                'create_time' => date('Y-m-d H:i:s',time())
            );
            $imgRes = db('img_code')->insert($data);
            if ($imgRes) {
                $arr = array('code'=>2,'msg'=>'二维码生成成功');
                return json($arr);
            } else {
                $arr = array('code'=>3,'msg'=>'二维码生成失败');
                return json($arr);
            }
        }
    }
    /**
     * 二维码列表数据展示页
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败 `
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function linkList () {
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data['data']  = db('img_code')->where('brandid','=',$this->brandId)->select();
            unset($c['limit'],$c['page']);
            $data['count'] = db('img_code')->count();
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'微信菜单连接管理'
            ]
        ]);
        return $this->fetch();
    }
    /**
     * 二维码随机串生成
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败 `
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    protected function strRandom ($length) {
        $str = '1234567890abcdefghigklmnopqrstuvwsyzABCDEFGHIJKLMNOPQRSTUVWSYZ';
        $rand = rand(111111,999999);
        $length = $length?$length-4:8;
        return substr($rand,0,5).''.substr(str_shuffle($str),0,$length);
    }
    /**
     * 二维码数据删除
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败 `
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function del () {
        $id = input('post.id');
        $res = db('img_code')->where('id','=',$id)->delete();
        if ($res) {
            $arr = array('code'=>1,'msg'=>'删除成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'删除失败');
            return json($arr);
        }
    }
}