<?php
/**
 * 活动增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\AActivityList;
use app\vip\model\AActivityLink;
use app\vip\model\AActivityVisit;
use app\index\controller\Base;
use think\Model;

class Activity extends Base{
    
    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        //$d = AActivityList::where($w)
        $w['delete_time'] = null;
        $d = db('a_activity_list')->where($w)
        ->field('share_total,view_total,signup_total,id,title,permit_level,share_score,share_img,share_title,share_content,hot_img,index_img,create_time,start_time,end_time,status,style_detail')
        ->limit($pagenum,$limit)
        ->order('order_num desc,create_time desc')
        ->select();
        $vip_url = getSiteBrand('',$this->brandId)['vip_url'];
        foreach($d as $k=>$v){
            $d[$k]['qrcode'] = urlencode($vip_url.'/front/index/activitydetail.html?_brandid='.$this->brandId.'&action=all&id='.$v['id']);
        }
        return $d;
    }
    
    /**
     * 方法描述: 获取背景图片所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getImglist($c){
        $limit    = isset($c['limit'])?$c['limit']:9;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('bg_imgs')->where($w)
        ->field('img,id')
        ->limit($pagenum,$limit)
        ->order('add_time desc')
        ->select();
        return $d;
    }
    
    /**
     * 方法描述: 获取背景图片所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getVideolist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('video')->where($w)
        ->field('name,id,type')
        ->limit($pagenum,$limit)
        ->order('add_time desc')
        ->select();
        return $d;
    }
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return AActivityList::where($w)->count('id');
    }
 
    /**
     * 添加处理方法
     * @param array $d 数据数组
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $model = new AActivityList();
           $d['brandid'] = $this->brandId;
           $d['create_user'] = $this->staffName;
           $res = $model->save($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 修改处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function edit($d){
        if(!$d){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            unset($d['id']);
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = AActivityList::where($w)->update($d);
            if($res!==false){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 获取一条信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
   
        if(!$id){
            return false;
        }else{
            $w = ['a.id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['a.brandid'] = $this->brandId;
                }
            }
            $w['a.delete_time'] = null;
            $res = AActivityList::alias('a')
            ->where($w)
            ->field('n.title as couponname,n.img,a.*')
            ->join('__C_COUPON_NUM__ n','n.id=a.couponid','left')
            ->find();
            if($res){
                return $res;
            }else{
                return false;
            }
        }
    }

    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = AActivityList::where($w)->update(['status'=>$status]);
            if($res!==false){
                return true;
            }else{
                return false;
            }
        }
    }
    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatuss($id,$status){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = AActivityList::where($w)->update(['status'=>$status]);
            if($res!==false){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $hasdata = AActivityList::where($w)->count();
            if($hasdata){
                $res = AActivityList::destroy($id);
                if($res){
                    return true;
                }else{
                    return false;
                
                }
            }
        }
    }

    /**
     * 删除一条活动的生成的连接记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function delLink($id){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            $res = AActivityLink::where($w)->update(['is_del'=>1]);
            if($res!==false){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述: 获取活动连接所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getLinklist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        if($c && $c['id']){
            $w['k.activityid'] = $c['id'];
        }
        $w['is_del'] = 0;
        $d = AActivityLink::alias('k')->where($w)
        ->field('a.title,a.id,k.id as lid,k.link,k.qrcode,k.visit_total,k.create_time,k.create_user,k.name')
        ->join('__A_ACTIVITY_LIST__ a','a.id=k.activityid')
        ->limit($pagenum,$limit)
        ->order('k.create_time desc')
        ->select();
        return $d;
    }
    
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getLinkCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        if($c && $c['id']){
            $w['k.activityid'] = $c['id'];
        }
        $w['is_del'] = 0;
        $d = AActivityLink::alias('k')->where($w)
        ->join('__A_ACTIVITY_LIST__ a','a.id=k.activityid')
        ->count();
        return $d;
    }
    
    /**
     * 存储二维码图片和连接
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function addLink($d){
        if(!$d){
            return false;
        }else{
            $model = new AActivityLink();
            $res = $model->insertAll($d);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述: 获取活动连接所有浏览数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getLinkVisitList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        if($c){
            if($c['activityid']){
                $w['v.activityid'] = $c['activityid'];
            }
            if($c['id']){
                $w['v.linkid'] = $c['id'];
            }
            if($c['linkcode']){
                $w['v.link_code'] = $c['linkcode'];
            }
        }
       
        $d = AActivityVisit::alias('v')->where($w)
        ->field('a.title,a.id,v.userid,v.create_time,v.link_code,v.linkid,v.add_time,u.username')
        ->join('__A_ACTIVITY_LIST__ a','a.id=v.activityid')
        ->join('__M_USERS__ u','u.id=v.userid')
        ->limit($pagenum,$limit)
        ->select();
        return $d;
    }
    
    /**
     * 方法描述: 获取连接浏览数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getLinkVisitCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        if($c && $c['id']){
            $w['v.id'] = $c['id'];
        }
        $d = AActivityVisit::alias('v')->where($w)
        ->join('__A_ACTIVITY_LIST__ a','a.id=v.activityid')
        ->count();
        return $d;
    }
    
    
    /**
     * 获取一条活动的所有留言信息信息处理方法
     * @param array $c 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getMsgList($c){
        if(!$c['id']){
            return false;
        }else{
            $limit    = $c['limit']?$c['limit']:10;
            $pagenum  = $c['page']?($c['page']-1)*$limit:0;
            $res = db('a_activity_msg')->alias('a')
            ->where(['a.activity_id'=>$c['id']])
            ->field('a.content,p.username as pusername,u.openid,a.check_time,a.staff_name,a.status,u.username,p.phone,a.userid,a.id,a.create_time')
            ->join('__M_USERS_PHONE__ p','p.userid=a.userid','left')
            ->join('__M_USERS__ u','u.id=a.userid','left')
            ->order('create_time desc')
            ->limit($pagenum,$limit)
            ->select();
    
            return $res?$res:null;
        }
    }
    
    /**
     * 获取一条活动的所有留言信息信息的总数
     * @param array $c 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getMsgCount($c){
        if(!$c['id']){
            return false;
        }else{
            $res = db('a_activity_msg')
            ->where(['activity_id'=>$c['id']])
            ->count('id');
            return $res;
        }
    }
    
    /**
     * 方法描述  修改一条留言
     * @param  array $d 数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月6日 下午7:14:07
     */
    public function editActivityMsg($d){
        $res = db('a_activity_msg')->update($d);
        return $res!==false?1:0;
    }
    
    /**
     * 方法描述  删除一条留言
     * @param  int $id 信息的id
     * @param  int $userid 用户的id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月6日 下午7:14:07
     */
    public function delActivityMsg($id){
        $w = ['id'=>$id];
        $res = db('a_activity_msg')->where($w)->delete();
        return $res!==false?1:0;
    }
    
    /**
     * 方法描述  设置留言状态
     * @param  int $id 信息的id
     * @param  int $staff_id 员工的id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月6日 下午7:14:07
     */
    public function setStatusMsg($id,$staff_id){
        $w = ['id'=>$id,'userid'=>$staff_id];
        $d = ['user_del'=>1];
        $res = db('a_activity_msg')->where($w)->update($d);
        return $res!==false?1:0;
    }
}