<?php
/**
 * 优惠券类型增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Zhao Jie Peng <Zhaojiepeng@suxuantech.cn>  2017年11月16日 下午12:36:20
 */
namespace app\vip\lib;
use app\index\controller\Base;

class Couponbag extends Base{
    
    /**
     * 方法描述:获取优惠券类别列表
     * @param  array $c 是查询条件
     * @return mixed
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getlist($c,$type){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        if($c['id']){
            $w['id'] = $c['id'];
            $d = db('c_coupon_bag')->where($w)->find();
        }else if($type == 'all'){
            $d = db('c_coupon_bag')->where($w)->select();
        }else{
            $d = db('c_coupon_bag')->where($w)->limit($pagenum,$limit)->order("sort desc")->select();    
            $couponData = db('c_coupon_num')->where($w)->select();
            if($d){
                foreach ($d as $k => $v) {
                    if($v['cid']){
                        //$cid = explode(',',$v['cid']);
                        $cid = json_decode($v['cid'],true);
                        foreach ($cid as $k3 => $v3) {
                            foreach ($couponData as $k2 => $v2){
                                if($v3['couponid'] == $v2['id']){
                                    $ciddata[] = $v2['title'].$v3['num'].'张';
                                }
                            }    
                        }
                        $d[$k]['cid']  = implode(',',$ciddata);
                        unset($ciddata);
                    }
                }   
            }
        }

        return $d;
    }
    /**
     * 方法描述     获取优惠券类别总数
     * @return mixed
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getBagCount(){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return db('c_coupon_bag')->where($w)->count('id');
    }
    
    
    /**
     * 添加优惠券类别方法
     * @param array $d 数据
     * @return bool 
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $d['brandid'] = $this->brandId;
           $d['create_time'] = date("Y-m-d H:i:s",time());
           $res = db("c_coupon_bag")->insert($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 修改优惠券类型方法
     * @param array $d 数据数组
     * @return bool
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function edit($id,$data){
        if(!$data || !$id){
            return false;
        }
        $res = db('c_coupon_bag')->where("id",$id)->update($data);
        // echo $res;die;
        if($res || $res === 0){
            return true;
        }else{
            return false;
        }
    }
 

    /**
     * 软删除优惠券类别
     * @param int $id 优惠券批次号
     * @return mixed
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }
        $res = db("c_coupon_bag")->where('id',$id)->delete();
        if($res){
            return true;
        }else{
            return false;
        }   
    }   
}