<?php
/**
 * 用户推荐管理
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Zhao Jie Peng <zhaojiepeng@suxuantech.cn>  2017年11月23日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\Recommend;
use app\index\controller\Base;

class Recommends extends Base{
    
    /**
     * 方法描述: 所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:10;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;

        $w = [];

        if($c['username']) $w['u.username'] = ['like','%'.$c['username'].'%'];
        if($c['r_username']) $w['r.r_username'] = ['like','%'.$c['r_username'].'%'];
        if($c['r_phone']) $w['r.r_phone'] = ['like','%'.$c['r_phone'].'%'];

        //一定要有事业部id，因为需要根据事业部获取转介绍客资的设置，会批量操作，所以列表里数据需要保持是同一个事业部
        //if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['r.brandid'] = $this->brandId;
            }
        //}
        $d = db('recommend')->alias('r')
        ->join('m_users u','u.id=r.userid')
        //->join('m_users_phone m','m.userid=u.id','left')
        ->join('recommend_photo_type t','r.price_type = t.id','left')
        ->where($w)
        ->field('u.username,r.id,r.userid,r.price_type,r.sell_counselor,t.type_name,
            r.remark,r.servant_money,r.r_username,r.check_user,r_phone,
            r.update_time,r.crm_status,u.username as musername,r.create_time,
            r.r_sex,r.check_user,r.status,u.phone')
        ->limit($pagenum,$limit)
        ->order('r.create_time desc')
        ->select();
        return $d;
    }
     
    /**
     * 方法描述: 获取数据的总数
     * @param  array $c 是查询条件
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        $w = [];
        if($c['username']) $w['u.username'] = ['like','%'.$c['username'].'%'];
        if($c['r_username']) $w['r.r_username'] = ['like','%'.$c['r_username'].'%'];
        if($c['r_phone']) $w['r.r_phone'] = ['like','%'.$c['r_phone'].'%'];

        //if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['r.brandid'] = $this->brandId;
            }
        //}

        $d = db('recommend')->alias('r')
            ->join('m_users u','u.id=r.userid')
            //->join('m_users_phone m','m.userid=u.id','left')
            ->join('recommend_photo_type t','r.price_type = t.id','left')
            ->where($w)
            ->field('u.username,r.id,r.userid,r.price_type,r.sell_counselor,t.type_name,
            r.remark,r.servant_money,r.r_username,r.check_user,r_phone,
            r.update_time,u.username as musername,r.create_time,
            r.r_sex,r.check_user,r.status,u.phone')
            ->count();

        return $d;
    }
    /**
     * 方法描述：获取股东码列表
     * @param [type] $c [description]
     */
    public function GetShareList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['s.brandid'] = $this->brandId;
            }
        }
        $w['s.is_del'] = 1;
        $d = db('s_shareholder')->alias('s')
            ->where($w)
            ->field("s.*,u.username")
            ->join('m_users_phone u','u.id=s.phoneid','left')
            ->limit($pagenum,$limit)
            ->select();
        return $d;
    }
    /**
     * 方法描述：股东码总数
     * @author Zhaojiepeng
     */
    public function GetShareCount(){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $w['is_del'] = 1;
        return db('s_shareholder')->where($w)->count('id');
    }
    /**
     * 方法描述：股东码总数
     * @author Zhaojiepeng
     */
    public function SetShareHolder(){
        do{
            $str = "QWERTYUPASDFGHJKLXCVBNM1234567890";
            $str = substr(str_shuffle($str),-6);
            $strData = db("s_shareholder")->where('code',$str)->find();
            if($strData){
                $action = true;
            }else{
                $action = false;
            }
        }while($action);
        return $str;
    }
    /**
     * 方法描述：添加股东码
     */
    public function AddShareHolder($data){
        $data['brandid']     = $this->brandId;
        $data['create_time'] = date("Y-m-d H:i:s",time());
        $data['status']      = 1;
        $data['is_del']      = 1;
        $data = db('s_shareholder')->insert($data);
        if($data){
            return true;
        }else{
            return false;
        }
        
    }
    /**
     * 方法描述: 获取今天推荐数据列表
     * @param  array $c 是查询条件
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTodayList($c){
         
        $w = [
            'create_time' => [
                 ['>=',date('Y-m-d',time())],
                ['<', date('Y-m-d',time()+86400)],
            ],
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return Recommend::where($w)->field('status,userid')->select();
    }
    
    /**
     * 方法描述: 获取最近一周的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getWeekList($c){
        $w    = [];
        // 判断当前的用户权限如果是root 选择全部
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $data = [];
        for($i=6;$i>=0;$i--){
            $currenttime = time();
            $starttime   = date('Y-m-d',$currenttime+86400-$i*86400);
            $endtime     = date('Y-m-d',$currenttime-$i*86400);
            $w['create_time'] = [
                        ['<=',$starttime],
                        ['>', $endtime],
            ];
            $data[$endtime] = Recommend::where($w)->count();
        }
        return $data;
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;  
        }else{
            $w = [];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $d = [
                'id'         => $id,
                'check_user' => $this->staffName,
                'status'     => $status,
                'update_time'=>date('Y-m-d H:i:s',time())
            ];
            $res = Recommend::where($w)->update($d);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    

    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $hasdata = Recommend::where('id='.$id)->count();
            if($hasdata){
                $res = db('recommend')->delete($id);
                if($res){
                    return true;
                }else{
                    return false;
                
                }
            }
        }
    }



}