<?php
/**
 * 会员秘书类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2018年02月01日 下午12:36:20
 */
namespace app\vip\lib;
use app\index\controller\Base;

class Setindex extends Base{
    
    /**
     * 方法描述     列表
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('s_index')->where($w)->limit($pagenum,$limit)->select();
        
        return $d;
    }
    
    /**
     * 方法描述     总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getCount(array $c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return db('s_index')->where($w)->count('id');
    }
    /**
     * 方法描述   添加
     * @param  array $d 数据
     * @return bool 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $res   = db('secretary')->insert($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 方法描述    修改
     * @param  array $d 数据数组,id单元必须存在
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function edit($d){
        if(!$d || !$d['id']){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            unset($d['id']);
            $isdata =  db('secretary')->where($w)->find();
            if($isdata){
                $res = db('secretary')->where($w)->update($d);
                if($res!==false){
                    return true;
                }
                return false;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述    判断当前的值是否已经存在 
     * @param  int  $val 数据
     * @param  int  $noid 排除的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function hasName($name,$noid=false){
        if(!$name){
            return;
        }
         $w['brandid']   = $this->brandId;
         if($noid){
             $w['id'] = ['not in',$noid];
         }
         $w['name'] = $name;
         $res = db('secretary')->where($w)->find();
         return $res?true:false;
        
    }

    /**
     * 方法描述    软删除类别
     * @param  int $id 积分类别删除
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $res = db('secretary')->delete($id);
            if($res !== false){
                return true;
            }else{
                return false;
                
            }
        }
    }
}